require "json"

package = JSON.parse(File.read(File.join(__dir__, "package.json")))

Pod::Spec.new do |s|
  s.name         = "react-native-themis"
  s.version      = package["version"]
  s.summary      = package["description"]
  s.homepage     = package["homepage"]
  s.license      = package["license"]
  s.authors      = package["author"]
  s.platforms    = { :ios => "12.4" }
  s.source       = { :git => "https://github.com/cossacklabs/themis.git", :tag => "#{s.version}" }

  s.vendored_frameworks = 'ios/themis.xcframework'
  s.source_files = "ios/**/*.{h,m,mm,swift}"
  s.requires_arc = true
  s.pod_target_xcconfig = { 'DEFINES_MODULE' => 'YES' }

  s.dependency "React-Core"

end
