/*
* Copyright (c) 2015 Cossack Labs Limited
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package com.cossacklabs.themis;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public class SecureServerSocket extends ServerSocket {
	
	byte[] id;
	PrivateKey signPrivateKey;
	ISessionCallbacks callbacks;

	public SecureServerSocket(int port, byte[] id, PrivateKey signPrivateKey, ISessionCallbacks callbacks) throws IOException {
		super(port);
		
		this.id = id;
		this.signPrivateKey = signPrivateKey;
		this.callbacks = callbacks;
	}
	
	@Override
	public Socket accept() throws IOException {
		if (isClosed()) {
			throw new SocketException("Socket is closed");
		}
		
		if (!isBound()) {
			throw new SocketException("Socket is not bound");
		}
		
		SecureSocket socket = new SecureSocket(this.id, this.signPrivateKey, this.callbacks);
		
		try {
			implAccept(socket);
		} catch (IOException e) {
			socket.close();
			throw e;
		}
		
		socket.runServerProtocol();
		
		return socket;
	}

}
