# GoThemis

[![pkg.go.dev][pkg-go-dev-badge]][pkg-go-dev]
[![GitHub Actions][github-ci-badge]][github-ci]
[![License][license-badge]][license]

_Go_ wrapper for [**Themis** crypto library][themis].

Themis is an open-source high-level cryptographic services library that provides secure data exchange, authentication, and storage protection.
Themis provides ready-made building components, which simplifies the usage of core cryptographic security operations.

[themis]: https://github.com/cossacklabs/themis
[pkg-go-dev]: https://pkg.go.dev/mod/github.com/cossacklabs/themis/gothemis
[pkg-go-dev-badge]: https://pkg.go.dev/badge/mod/github.com/cossacklabs/themis/gothemis
[github-ci]: https://github.com/cossacklabs/themis/actions?query=workflow%3AGoThemis
[github-ci-badge]: https://github.com/cossacklabs/themis/workflows/GoThemis/badge.svg
[license]: https://github.com/cossacklabs/themis/blob/master/LICENSE
[license-badge]: https://img.shields.io/github/license/cossacklabs/themis

## Getting started

GoThemis requires a native Themis library.
Please refer to the [Installation guide][installation] for the instructions.

See also:

 - [In-depth documentation on Cossack Labs Documentation Server][docs]
 - [Go API documentation on pkg.go.dev][pkg-go-dev]
 - [Changelog on GitHub][CHANGELOG]

You can start experimenting with [Examples][examples] or take a look at [Tests][tests]
to get a feeling of how Themis can be used.

[installation]: https://docs.cossacklabs.com/themis/languages/go/installation/
[docs]: https://docs.cossacklabs.com/themis/
[CHANGELOG]: https://github.com/cossacklabs/themis/blob/master/CHANGELOG.md
[examples]: https://github.com/cossacklabs/themis/tree/master/docs/examples/go
[tests]: https://github.com/cossacklabs/themis/tree/master/gothemis

## Licensing

The code is distributed under [Apache 2.0 license][license].
