# Contributing to Themis

Themis is an open-source, Apache 2 licensed software, maintained by [Cossack Labs](https://www.cossacklabs.com) for building reliable cryptography in our products: [Acra](https://www.github.com/cossacklabs/acra), [Hermes](https://www.cossacklabs.com/hermes), and [Toughbase](https://www.cossacklabs.com/toughbase). You can hack it in any way you want and contribute things back if you need something more than what we provide. As a development company, we focus on implementing features that are important to our products but would gladly spend some time to make Themis useful for everybody.

We highly encourage you to: 

  - Ask questions and participate in [discussions on GitHub](https://github.com/cossacklabs/themis/discussions).
  - Report any bugs and request features via [GitHub Issues](https://github.com/cossacklabs/themis/issues).
  - Report bugs that you have fixes with a patch via [GitHub Pull request](https://github.com/cossacklabs/themis/pulls) (after issuing a corresponding issue and leaving a link to pull there).
  - Add something new to Themis. There is a certain design scheme according to which we'd like to keep developing Themis. If your contributions fall along with it, we'd be more than glad to accept some fundamental additions. It's better to discuss the subject using [email](mailto:dev@cossacklabs.com) before taking action.


Every commit that goes into the master branch is audited and reviewed by somebody from Cossack Labs, so don't be surprised if it takes longer than you expect. 

## "I'd like to help somehow, but don't know what will be useful. What should I do?"

If you're looking for something to contribute to and gain eternal respect,
just pick the things in the [list of issues](https://github.com/cossacklabs/themis/issues)
and let us know via [email](mailto:dev@cossacklabs.com),
or raise a [new issue](https://github.com/cossacklabs/themis/issues)
to make sure nobody's on it yet.

Issues marked as ["enhancement"](https://github.com/cossacklabs/themis/issues?utf8=%E2%9C%93&q=is%3Aissue%20is%3Aopen%20label%3Aenhancement%20) are a great place to start.

If you'd like to do independent parts (implement new procedures/objects, create a language wrapper or a set of examples for languages or architectures we don't have and don't even plan yet) — just go ahead and let us know when you finish. 

If you'd like to participate in the core development more closely, [get in touch](mailto:dev@cossacklabs.com). 

### Getting in touch

- Requests/bugfixes/queries should go through [GitHub Issues](https://github.com/cossacklabs/themis/issues)
- To reach the developers, use [dev@cossacklabs.com](mailto:dev@cossacklabs.com).
- See more information [on contributing](https://docs.cossacklabs.com/themis/community/contributing/) and [Themis community](https://docs.cossacklabs.com/themis/community/).
- To talk to the business wing of Cossack Labs, drop us an email to [info@cossacklabs.com](mailto:info@cossacklabs.com).
