/*
 * Copyright 2024 Confluent Inc.
 *
 * Licensed under the Confluent Community License (the "License"); you may not use
 * this file except in compliance with the License.  You may obtain a copy of the
 * License at
 *
 * http://www.confluent.io/confluent-community-license
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OF ANY KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations under the License.
 */

package io.confluent.ksql.security.oauth.exceptions;

public class KsqlOAuthTokenRetrieverException extends RuntimeException {
  public KsqlOAuthTokenRetrieverException(final String message, final Throwable cause) {
    super("Error while fetching Oauth Token for KSQL Client: " + message, cause);
  }
}
