---
layout: page
title: How-to Guides 
tagline: Frequently used ksqlDB patterns 
description: Quick lessons that help you work with common ksqlDB functionality. 
keywords: pattern, satructured data, changelog, connector, query, function, identifier, timestamp, variable
---

Follow compact lessons that help you work with common ksqlDB functionality.

<div class="cards">
  <div class="card how-to-guide">
    <a href="/how-to-guides/query-structured-data"><strong>Query structured data</strong></a>
    <p class="card-body"><small>Process and query structured data types like structs, maps, and arrays.</small></p>
    <span><a href="/how-to-guides/query-structured-data">Learn →</a></span>
  </div>

  <div class="card how-to-guide">
    <a href="/how-to-guides/convert-changelog-to-table"><strong>Convert a changelog to a table</strong></a>
    <p class="card-body"><small>Create a table representing the latest values in a stream.</small></p>
    <span><a href="/how-to-guides/convert-changelog-to-table">Learn →</a></span>
  </div>

  <div class="card how-to-guide">
    <a href="/how-to-guides/use-connector-management"><strong>Use connector management</strong></a>
    <p class="card-body"><small>Source and sink data from external systems.</small></p>
    <span><a href="/how-to-guides/use-connector-management">Learn →</a></span>
  </div>
</div>

<div class="cards">
  <div class="card how-to-guide">
    <a href="/how-to-guides/update-a-running-persistent-query"><strong>Update a running persistent query</strong></a>
    <p class="card-body"><small>Change a running persistent query with no downtime.</small></p>
    <span><a href="/how-to-guides/update-a-running-persistent-query">Learn →</a></span>
  </div>

  <div class="card how-to-guide">
    <a href="/how-to-guides/create-a-user-defined-function"><strong>Create a user-defined function</strong></a>
    <p class="card-body"><small>Extend ksqlDB and invoke code that you wrote.</small></p>
    <span><a href="/how-to-guides/create-a-user-defined-function">Learn →</a></span>
  </div>

  <div class="card how-to-guide">
    <a href="/how-to-guides/control-the-case-of-identifiers"><strong>Control the case of identifiers</strong></a>
    <p class="card-body"><small>Specify the exact capitalization of object names.</small></p>
    <span><a href="/how-to-guides/control-the-case-of-identifiers">Learn →</a></span>
  </div>
</div>

<div class="cards">
  <div class="card how-to-guide">
    <a href="/how-to-guides/use-a-custom-timestamp-column"><strong>Use a custom timestamp column</strong></a>
    <p class="card-body"><small>Perform time-based operations using a timestamp in each record.</small></p>
    <span><a href="/how-to-guides/use-a-custom-timestamp-column">Learn →</a></span>
  </div>

  <div class="card how-to-guide">
    <a href="/how-to-guides/test-an-app"><strong>Test an application</strong></a>
    <p class="card-body"><small>Build test suites to assert correct program behavior.</small></p>
    <span><a href="/how-to-guides/test-an-app">Learn →</a></span>
  </div>

  <div class="card how-to-guide">
    <a href="/how-to-guides/substitute-variables"><strong>Substitute variables</strong></a>
    <p class="card-body"><small>Change the content of a query based on variables.</small></p>
    <span><a href="/how-to-guides/substitute-variables">Learn →</a></span>
  </div>
</div>

<div class="cards">
  <div class="card how-to-guide">
    <strong>Transforming columns with structured data</strong>
    <p class="card-body"><small>Transform columns of structured data without user-defined functions.</small></p>
    <span><a href="/how-to-guides/use-lambda-functions">Learn →</a></span>
  </div>
  
  <div class="card how-to-guide contribute">
    <a href="https://github.com/confluentinc/ksql"><strong>Help us write another?</strong></a>
    <p class="card-body"><small>We're always looking for more guides. Just send a pull request!</small></p>
    <span><a href="https://github.com/confluentinc/ksql">Contribute →</a></span>
  </div>
</div>