---
layout: page
title: ksqlDB API Index
tagline: Program ksqlDB 
description: Learn to program ksqlDB to create streaming applications.
keywords: ksqldb, api, reference, function, operator, metadata, connector, query
---

## SQL Quick Reference

- [SQL Quick Reference](quick-reference.md)

## Functions and Operators

- [Aggregate Functions](aggregate-functions.md)
- [Operators](operators.md)
- [Scalar Functions](scalar-functions.md)
- [Table Functions](table-functions.md)
- [Type Coercion](type-coercion.md)

## Streams and Tables

- [CREATE STREAM AS SELECT](create-stream-as-select.md)
- [CREATE STREAM](create-stream.md)
- [CREATE TABLE AS SELECT](create-table-as-select.md)
- [CREATE TABLE](create-table.md)
- [DESCRIBE](describe.md)
- [DROP STREAM](drop-stream.md)
- [DROP TABLE](drop-table.md)
- [INSERT INTO](insert-into.md)
- [INSERT VALUES](insert-values.md)
- [PRINT](print.md)

## Queries

- [SELECT (Pull Query)](select-pull-query.md)
- [SELECT (Push Query)](select-push-query.md)
- [EXPLAIN](explain.md)
- [PAUSE](pause.md)
- [RESUME](resume.md)
- [TERMINATE](terminate.md)

## Connectors

- [CREATE CONNECTOR](create-connector.md)
- [DESCRIBE CONNECTOR](describe-connector.md)
- [DROP CONNECTOR](drop-connector.md)
- [SHOW CONNECTORS](show-connectors.md)

## Custom Types

- [CREATE TYPE](create-type.md)
- [DROP TYPE](drop-type.md)
- [SHOW TYPES](show-types.md)

## Metadata

- [DESCRIBE FUNCTION](describe-function.md)
- [SHOW FUNCTIONS](show-functions.md)
- [SHOW PROPERTIES](show-properties.md)
- [SHOW QUERIES](show-queries.md)
- [SHOW STREAMS](show-streams.md)
- [SHOW TABLES](show-tables.md)
- [SHOW TOPICS](show-topics.md)
- [SPOOL](spool.md)

## Execution

- [RUN SCRIPT](run-script.md)
- [ALTER SYSTEM](alter-system.md)

## Assertions
- [ASSERT SCHEMA](assert-schema.md)
- [ASSERT TOPIC](assert-topic.md)

