/*
 * Copyright 2020 Confluent Inc.
 *
 * Licensed under the Confluent Community License (the "License"); you may not use
 * this file except in compliance with the License.  You may obtain a copy of the
 * License at
 *
 * http://www.confluent.io/confluent-community-license
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OF ANY KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations under the License.
 */

package io.confluent.support.metrics.common;

import java.util.UUID;

public class Uuid {

  /**
   * For the purposes of metrics collection we want to use type-4 UUIDs.
   */
  private final UUID uuid = UUID.randomUUID();

  public String getUuid() {
    return toString();
  }

  @Override
  public String toString() {
    return uuid.toString();
  }

}
