---
layout: page
title: ksqlDB Reference
tagline:  Reference material for all aspects of using ksqlDB
description: Reference material for all aspects of using ksqlDB.
keywords: ksqldb, sql, syntax, query, api
---

Look up critical information quickly as you use the project.

<div class="cards">
  <div class="card reference">
    <a href="/reference/sql/syntax/lexical-structure"><strong>The SQL language</strong></a>
    <p class="card-body"><small>Learn the make-up of the SQL language to write programs.</small></p>

    <span><a href="/reference/sql/syntax/lexical-structure">Read →</a></span>
  </div>

  <div class="card reference">
    <a href="/developer-guide/ksqldb-reference/functions"><strong>Built-in functions</strong></a>
    <p class="card-body"><small>Invoke built-in functions shipped with ksqlDB.</small></p>

    <span><a href="/developer-guide/ksqldb-reference/functions">Read →</a></span>
  </div>

  <div class="card reference">
    <a href="/developer-guide/ksqldb-reference/operators"><strong>Operators</strong></a>
    <p class="card-body"><small>Call operators built-into the language.</small></p>

    <span><a href="/developer-guide/ksqldb-reference/operators">Read →</a></span>
  </div>
</div>

<div class="cards">
  <div class="card reference">
    <a href="/reference/server-configuration"><strong>Server configuration</strong></a>
    <p class="card-body"><small>Control how ksqlDB server behaves.</small></p>

    <span><a href="/reference/server-configuration">Read →</a></span>
  </div>

  <div class="card reference">
    <a href="/reference/metrics"><strong>Metrics</strong></a>
    <p class="card-body"><small>Observe how your cluster is behaving over time.</small></p>

    <span><a href="/reference/metrics">Read →</a></span>
  </div>
</div>

<div class="cards">
  <div class="card reference">
    <a href="/reference/user-defined-functions"><strong>User-defined functions</strong></a>
    <p class="card-body"><small>Extend ksqlDB to invoke custom code written in Java.</small></p>

    <span><a href="/reference/user-defined-functions">Read →</a></span>
  </div>

  <div class="card reference">
    <a href="/reference/processing-log"><strong>Processing log</strong></a>
    <p class="card-body"><small>Log internal events that arise when processing rows.</small></p>

    <span><a href="/reference/processing-log">Read →</a></span>
  </div>
</div>

<div class="cards">
  <div class="card reference">
    <a href="/reference/serialization"><strong>Serialization</strong></a>
    <p class="card-body"><small>Control the format of how data is read and written.</small></p>

    <span><a href="/reference/serialization">Read →</a></span>
  </div>

  <div class="card reference">
    <a href="/developer-guide/ksqldb-clients"><strong>Clients</strong></a>
    <p class="card-body"><small>Talk to ksqlDB using your favorite programming language.</small></p>

    <span><a href="/developer-guide/ksqldb-clients">Read →</a></span>
  </div>

  <div class="card reference">
    <a href="/developer-guide/api"><strong>REST API</strong></a>
    <p class="card-body"><small>Communicate with ksqlDB over an HTTP REST API.</small></p>

    <span><a href="/developer-guide/api">Read →</a></span>
  </div>
</div>

<div class="cards">
  <div class="card reference">
    <a href="/developer-guide/ksqldb-reference/quick-reference/"><strong>Appendix</strong></a>
    <p class="card-body"><small>Quickly reference the elements of the language.</small></p>

    <span><a href="/developer-guide/ksqldb-reference/quick-reference/">Read →</a></span>
  </div>
</div>
