---
layout: page
title: Terminate a ksqlDB cluster
tagline: terminate endpoint
description: The `/ksql/terminate` resource terminates the cluster and cleans up resources
keywords: ksqlDB, terminate
---

If you don't need your ksqlDB cluster anymore, you can terminate the
cluster and clean up the resources using this endpoint. To terminate a
ksqlDB cluster, first shut down all of the servers, except one. Then, send
the `TERMINATE CLUSTER` request to the `/ksql/terminate` endpoint in the
last remaining server. When the server receives a `TERMINATE CLUSTER`
request at `/ksql/terminate` endpoint, it writes a `TERMINATE CLUSTER`
command into the command topic. Note that a `TERMINATE CLUSTER` request
can be sent only via the `/ksql/terminate` endpoint, and you can't send
it via the CLI. When the server reads the `TERMINATE CLUSTER` command,
it takes the following steps:

- Sets the ksqlDB engine mode to `NOT ACCEPTING NEW STATEMENTS` so no new
statements are passed to the engine for execution.
- Terminates all persistent and transient queries in the engine and performs the required clean up for each query.
- Deletes the command topic for the cluster.

### Example request

```http
POST /ksql/terminate HTTP/1.1
Accept: application/vnd.ksql.v1+json
Content-Type: application/vnd.ksql.v1+json

{}
```

You can customize the clean up process if you want to delete some or all
of the Kafka topics too:

### Provide a List of Kafka Topics to Delete

You can provide a list of kafka topic names or regular expressions for Kafka
topic names along with your `TERMINATE CLUSTER` request. The ksqlDB Server will
delete all topics with names that are in the list or that match any of the
regular expressions in the list. Only the topics that were generated by SQL
queries are considered for deletion. Topics that were not generated by SQL
queries aren't deleted, even if they match the provided list. The following
example shows how to delete topic `FOO`, along with all topics with the prefix
`bar`.

```http
POST /ksql/terminate HTTP/1.1
Accept: application/vnd.ksql.v1+json
Content-Type: application/vnd.ksql.v1+json

{
  "deleteTopicList": ["FOO", "bar.*"]
}
```

