# Conda Organization Code of Conduct

# The Short Version

Be kind to others. Do not insult or put down others. Behave professionally. Remember that harassment and sexist, racist, or exclusionary jokes are not appropriate for the conda Organization.

All communication should be appropriate for a professional audience including people of many different backgrounds. Sexual language and imagery is not appropriate.

The conda Organization is dedicated to providing a harassment-free community for everyone, regardless of gender, sexual orientation, gender identity and expression, disability, physical appearance, body size, race, or religion. We do not tolerate harassment of community members in any form.

Thank you for helping make this a welcoming, friendly community for all.

## Report an Incident

* Report a code of conduct incident [using a form](https://form.jotform.com/221527028480048).
* Report a code of conduct incident via email: [conduct@conda.org](mailto:conduct@conda.org).
* Contact [an individual committee member](#committee-membership) or [CoC event representative](#coc-representatives) to report an incident in confidence.

&nbsp;

And now the longer version...

# Conda Organization Diversity Statement

The conda Organization welcomes and encourages participation in our community by people of all backgrounds and identities. We are committed to promoting and sustaining a culture that values mutual respect, tolerance, and learning, and we work together as a community to help each other live out these values.

We have created this diversity statement because we believe that a diverse community is stronger, more vibrant, and produces better software and better science. A diverse community where people treat each other with respect has more potential contributors, more sources for ideas, and fewer shared assumptions that might hinder development or research.

Although we have phrased the formal diversity statement generically to make it all-inclusive, we recognize that there are specific identities that are impacted by systemic discrimination and marginalization. We welcome all people to participate in the conda Organization community regardless of their identity or background.

# Conda Organization Code of Conduct: Introduction & Scope

This code of conduct should be honored by everyone who participates in the conda Organization community. It should be honored in any conda Organization-related activities, by anyone claiming affiliation with the conda Organization, and especially when someone is representing the conda Organization in any role (including as an event volunteer or speaker).

This code of conduct applies to all spaces managed by the conda Organization, including all public and private mailing lists, issue trackers, wikis, forums, and any other communication channel used by our community. The code of conduct equally applies at conda Organization events and governs standards of behavior for attendees, speakers, volunteers, booth staff, and event sponsors.

This code is not exhaustive or complete. It serves to distill our understanding of a collaborative, inclusive community culture. Please try to follow this code in spirit as much as in letter, to create a friendly and productive environment that enriches the conda Organization community.

The conda Organization Code of Conduct follows below.

# Standards for Behavior

The conda Organization is a worldwide community. All communication should be appropriate for a professional audience including people of many different backgrounds.

**Please always be kind and courteous. There's never a need to be mean or rude or disrespectful.** Thank you for helping make this a welcoming, friendly community for all.

We strive to:

**Be empathetic, welcoming, friendly, and patient.** We remember that the conda Organization is crafted by human beings who deserve to be treated with kindness and empathy. We work together to resolve conflict and assume good intentions. We may all experience some frustration from time to time, but we do not allow frustration to turn into a personal attack. A community where people feel uncomfortable or threatened is not a productive one.

**Be collaborative.** Our work depends on the participation of many people, and in turn others depend on our work. Open source communities depend on effective and friendly collaboration to achieve their goals.

**Be inquisitive.** Nobody knows everything! Asking questions early avoids many problems later, so we encourage questions, although we may direct them to the appropriate forum. We will try hard to be responsive and helpful.

**Be careful in the words that we choose.** We are careful and respectful in our communication and we take responsibility for our own speech. Be kind to others. Do not insult or put down other members of the community.

## Unacceptable Behavior

We are committed to making participation in this community a harassment-free experience.

We will not accept harassment or other exclusionary behaviors, such as:

- The use of sexualized language or imagery
- Excessive profanity (please avoid curse words; people differ greatly in their sensitivity to swearing)
- Posting sexually explicit or violent material
- Violent or intimidating threats or language directed against another person
- Inappropriate physical contact and/or unwelcome sexual attention or sexual comments
- Sexist, racist, or otherwise discriminatory jokes and language
- Trolling or insulting and derogatory comments
- Written or verbal comments which have the effect of excluding people on the basis of membership in a specific group, including level of experience, gender, gender identity and expression, sexual orientation, disability, neurotype, personal appearance, body size, race, ethnicity, age, religion, or nationality
- Public or private harassment
- Sharing private content, such as emails sent privately or non-publicly, or direct message history, without the sender's consent
- Continuing to initiate interaction (such as photography, recording, messaging, or conversation) with someone after being asked to stop
- Sustained disruption of talks, events, or communications, such as heckling of a speaker
- Publishing (or threatening to post) other people's personally identifying information ("doxing"), such as physical or electronic addresses, without explicit permission
- Other unethical or unprofessional conduct
- Advocating for, or encouraging, any of the above behaviors

The conda Organization prioritizes marginalized people’s safety over privileged people’s comfort. The conda CoC Committee reserves the right not to act on complaints including, but not limited to:

* ‘Reverse’ -isms, including ‘reverse racism,’ ‘reverse sexism,’ and ‘cisphobia’.
* Reasonable communication of boundaries, such as “leave me alone,” “go away,” or “I’m not discussing this with you.”
* Communicating in a ‘tone’ you don’t find congenial.
* Criticizing racist, sexist, cissexist, or otherwise oppressive behavior or assumptions.

## Behavior Outside of conda Organization Spaces

The CoC Committee does not influence behavior and membership in spaces outside the conda Organization. However, if you are being harassed by a member of the conda community outside our spaces, you may still report it to the CoC Committee. We will take all good-faith reports of harassment by conda community members seriously. This includes harassment outside our spaces and harassment that took place at any point in time.

The CoC Committee reserves the right to exclude people from conda Organization spaces based on their past behavior, including behavior outside conda Organization spaces and behavior towards people who are not in the conda community.

# Confidentiality and Public Statements to the Community

The CoC Committee will keep the identity of the reporter confidential.

Whenever possible, CoC cases will be reported to the community. The level of detail in reports will vary from case to case. Reports will describe at least the type of infraction that was reported, and the Committee's decision and any action taken.  In most cases, the report will not include personally identifiable information.

# Live Events

> **If you feel your safety is in jeopardy or the situation is an emergency, we urge you to contact local law enforcement before making a report to the event's Code of Conduct committee members, [representatives](#coc-representatives), or other staff.** (In the U.S., call 911.)

Live events present particular challenges:

**Code of conduct reports, and consequences that stem from them, merit a thoughtful and deliberative process.  Decisions and consequences matter for the reporter, the reported, and for the community at large.  However, many reports, especially at live events, require rapid action to quickly address the behavior being reported.**

To better support situations where immediate action may be required, these guidelines are used *during* live events:

* All conda Organization events will have specific, named Code of Conduct contacts for the events.
* The names and contact mechanisms for the Code of Conduct representatives will be clearly and frequently communicated to event participants.

## CoC Representatives

Every conda Organization associated event will have named CoC Committee members or *CoC representatives* that are the first point of contact for that event. Who these people are will be clearly and frequently communicated to event participants. CoC approved representatives are used when there are no committee members participating in the event.

## Live Events: Reporting and Actions
At conda Organization events, Code of Conduct committee members or representatives will attempt to gather and write down [information](#what-to-include-in-a-report) from anyone making a verbal report at a live event. Recording the details in writing is exceedingly important in order for us to effectively respond to reports. If event staff write down a report taken verbally, then the person making the report will be asked to review the written report for accuracy.

For reports made during live events, or in any situation where urgent action is needed:

* Any two (or more) event organizers, event staff, CoC Committee members or CoC representatives can decide if immediate action is to be taken and what that action is. In exceptionally dangerous situations, this decision can be made by a single person.
* These rapid decisions can be reconsidered during the event as more information becomes available.
* The scope of any rapid decision is limited to the current event / situation.
* The report, any related information, and any decisions and consequences will be reported to the full Code of Conduct Committee as soon as possible.

The full Code of Conduct Committee will then consider the report using the full timeline and processes defined below.  The Committee may decide to apply consequences in other spaces beyond the space where the behavior was reported.

Potential *immediate* consequences for violating the conda Organization Code of Conduct at a live event include, but are not limited to:

- Warning the person to cease their behavior and that any further reports will result in sanctions
- Requiring that the person avoid any interaction with, and physical proximity to, the person they are harassing for the remainder of the event
- Ending a talk that violates the policy early
- Not publishing the video or slides of a talk that violated the policy
- Not allowing a speaker who violated the policy to give (further) talks at the event now or in the future
- Immediately ending any event volunteer responsibilities and privileges the reported person holds
- Expelling the person from the event without a refund
- Requiring that the person immediately leave the event and not return
- Any other response that the CoC members, representatives, or event staff deem necessary and appropriate to the situation

# Reporting Guidelines

If you believe someone is violating the code of conduct, please report this in a timely manner. Code of conduct violations reduce the value of the community for everyone. The conda Code of Conduct (CoC) Committee and the conda Organization take reports of misconduct very seriously and are committed to preserving and maintaining the welcoming nature of our community.

> [!NOTE]
> You are also encouraged to reach out to the conda Code of Conduct (CoC) Committee if you want clarification on something, if you notice some borderline behavior, or just have a concern. Send us a note at [conduct@conda.org](mailto:conduct@conda.org).

All complaints will be reviewed and investigated and will result in a response that is deemed necessary and appropriate to the circumstances.  The conda CoC Committee commits to maintaining confidentiality with regard to the reporter of an incident.

For possibly unintentional breaches of the code of conduct, you may want to respond to the person and point out this code of conduct (either in public or in private, whatever is most appropriate). If you would prefer not to do that, please report the issue to the conda CoC Committee directly.

Take care of each other. Alert someone if you notice a dangerous situation, someone in distress, or violations of this code of conduct, even if they seem inconsequential.

## How to Submit a Report

The CoC Committee is committed to promptly addressing any reported issues. If you have experienced or witnessed behavior that violates the conda Organization Code of Conduct, please let us know.

You can report an incident

* via the **[Incident Reporting Form](https://form.jotform.com/221527028480048)**
* via email: [conduct@conda.org](mailto:conduct@conda.org)
* contact [an individual committee member](#committee-membership) or [CoC event representative](#coc-representatives) to report an incident in confidence.

Reports submitted via the form or committee email address are sent to the [full conda Code of Conduct Committee](#committee-membership).

## What to Include in a Report

Our ability to address any code of conduct breaches in a timely and effective manner is impacted by the amount of information you can provide, so, we ask you to include as much of the following information as you can**:

- **Your contact info** (so we can get in touch with you if we need to follow up). This will be kept confidential. You can also file a report [anonymously](#anonymous-reporting).
- The **approximate time and location of the incident** (please be as specific as possible).
- **Identifying information** (e.g. name, nickname, screen name, physical description) of the individual whose behavior is being reported.
- **Description of the behavior** (if reporting harassing language, please be specific about the words used), **your account of what happened**, and any available **supporting records** (e.g. email, GitHub issue, screenshots, etc.).
- **Description of the circumstances/context** surrounding the incident.
- Let us know **if the incident is ongoing**, and/or if this is part of an ongoing pattern of behavior.
- Names and contact info, if possible, of **anyone else who witnessed** or was involved in this incident. (Did anyone else observe the incident?)
- **Any other relevant information** you believe we should have.

## Anonymous Reporting

The reporting form supports anonymous incident reporting.  Anonymous reporting works best when the behavior happened in a public space and was witnessed by many.  If an incident is reported anonymously and was not witnessed by others, then the committee may be limited in what actions it can take and what it can report to the larger community.  Nevertheless, the CoC Committee is still interested in receiving these reports.  They are helpful when determining what we need to address as a community, and when looking for evidence of repeated behavior.

## Conflicts of Interest

Committee members are expected to recuse themselves if they have a conflict of interest, and are required to recuse themselves if they are the accused or the target of the reported behavior. In addition, the CoC Committee can [vote](#voting-and-decision-making) to remove a committee member from a case, if the committee feels that the member has a conflict of interest.  This [vote](#voting-and-decision-making) requires a simple majority. <!-- codespell:ignore recuse -->

If you are concerned about making a report that will be read by all committee members, you are strongly encouraged to contact [individual committee members](#committee-membership) directly.

# Enforcement: What Happens After a Report is Filed?

## Acknowledgment and Responding to Immediate Needs

CoC Committee members and/or event staff will attempt to ensure your safety and help with any immediate needs. The CoC Committee will make every effort to **acknowledge receipt within 24 hours** (and we'll aim for much more quickly than that).

## Reviewing the Report

The CoC Committee will make all efforts to **review the incident within three days** and determine:

- Whether this is an ongoing situation, or if there is a threat to anyone's physical safety
- What happened
- Whether this event constitutes a code of conduct violation
- Who the bad actor was, if any

## Contacting the Person Reported

After the CoC Committee has had time to review and discuss the report, someone will attempt to contact the person who is the subject of the report to inform them of what has been reported about them. We will then ask that person for their account of what happened.

## Response and Potential Consequences

Once the CoC Committee has completed our investigation of the report, we will make a decision as to how to respond. The person making a report will not normally be consulted as to the proposed resolution of the issue, except insofar as we need to understand how to help them feel safe.

Potential consequences for violating the conda Organization code of conduct include:

- Nothing (if we determine that no violation occurred)
- Private feedback or reprimand from the CoC Committee to the individual(s) involved
- Warning the person to cease their behavior and that any further reports will result in sanctions
- A public announcement that an incident occurred
- Mediation (only if both reporter and reportee agree)
- An imposed vacation (e.g. asking someone to "take a week off" from a mailing list)
- A permanent or temporary ban from some or all the conda Organization spaces (mailing lists, GitHub repos, in-person events, etc.)
- Assistance to the complainant with a report to other bodies, for example, institutional offices or appropriate law enforcement agencies
- Removing a person from the conda Organization membership or other formal affiliation
- Publishing an account of the harassment and calling for the resignation of the alleged harasser from their responsibilities (may be called for if the person is an event leader, or refuses to stand aside from the conflict of interest, or similar)
- Any other response that the CoC Committee deems necessary and appropriate to the situation

No one espousing views or values contrary to the standards of our code of conduct will be permitted to hold any position representing the conda Organization, including volunteer positions. The CoC Committee has the right and responsibility to remove, edit, or reject comments, commits, code, website edits, issues, and other contributions that are not aligned with this code of conduct.

We aim to **respond within one week** to the original reporter with either a resolution or an explanation of why the situation is not yet resolved.

We will contact the person who is the subject of the report to let them know what actions will be taken as a result of the report, if any.

Our policy is to make sure that everyone aware of the initial incident is also made aware that official action has been taken, while still respecting the privacy of individuals. In addition, we will also usually [notify the community](#confidentiality-and-public-statements-to-the-community) that an incident has been reported, what type of incident it was, and what the response was, again respecting the privacy of individuals.

## Appealing a Decision

To appeal a decision of the CoC Committee, contact the [Committee Co-Chairs](#committee-membership), with your appeal. Please include as much detail as possible about why you are appealing the decision. The Co-Chairs will review the appeal, possibly consulting with the full Committee, and then issue a decision.

# Timeline Summary:

| Time | Event | Details |
| ---- | ---- | ---- |
| Within 24 Hours | Acknowledge | The CoC Committee will make every effort to **acknowledge receipt of a report within 24 hours**. |
| Within 3 Days | Review | The CoC Committee aims to **review the incident within three days**. |
| Within 1 Week | Resolve | We will **respond within one week** to the original reporter with either a resolution or an explanation of why the situation is not yet resolved. |

# Voting and Decision Making

Committee votes and decisions require both a minimum quorum size for the vote to be counted, and then a minimum percentage of cast affirmative votes to pass.

Except where otherwise noted, votes require a quorum and a simple majority to pass:

* Minimum Quorum:
  * More than 50% of eligible committee members must vote.
    * Eligibile members do not include those excluded because of [conflicts of interest](#conflicts-of-interest).
* Affirmative vote threshold:
  * More than 50% of the votes cast need to be affirmative to take action.

# Committee Membership

You can reach the entire CoC Committee by emailing [conduct@conda.org](mailto:conduct@conda.org).

| Name | Employer / Funding | Steering Council Member | Current Term Ends |
| ---- | ---- | ---- | --- |
| [Eric Dill](https://github.com/ericdill) | [Anaconda](https://anaconda.com/) | | 2026-07-01 |
| [Dasha Gurova](https://github.com/dashagurova) | [Anaconda](https://anaconda.com/) | | 2026-07-01 |
| [Bianca Henderson](https://github.com/beeankha) | [Anaconda](https://anaconda.com/) | | 2026-07-01 |
| [Katherine Kinnaman](https://github.com/kathatherine) | [Anaconda](https://anadonda.com/) | | 2026-07-01 |
| [Mahe Iram Khan](https://github.com/ForgottenProgramme) | [Anaconda](https://anaconda.com/) | | 2025-07-01 |
| [Ken Odegard](https://github.com/kenodegard) | [Anaconda](https://anaconda.com/) | | 2025-07-01 |
| [Crystal Soja](https://github.com/csoja), Co-Chair | [Anaconda](https://anaconda.com/) | | 2025-07-01 |
| [Jaime Rodríguez-Guerra](https://github.com/jaimergp), Co-Chair | [Quansight](https://quansight.com/) | yes | 2025-07-01 |

# Terms and New Members

* Committee members are appointed for two year terms. Committee members can choose to renew their memberships.
* Committee members can resign before their term ends.
* Committee members can also be removed by a [simple majority vote](#voting-and-decision-making) from their fellow committee members.
* New committee members are added by a simple majority vote as well.

# Eligibility

Anyone from the community who is interested and able to do CoC Committee work is eligible to be nominated for the committee.  New committee members can be nominated by any community member, including nominating themselves.

## Shared Funding

Unlike the Steering Council, we are not limiting the number of Committee members who share a common source of funding. However, if a report involves someone who shares funding with CoC Committee members, then the remainder of the committee may vote to exclude some or all Committee members with that same funding, even if that excludes a majority of the CoC Committee. This should be done only if the separately funded Committee members feel that the common funding is interfering with decision making.

Note: This requires tracking the funding sources of CoC Committee members.

## Overlap with Steering Council Membership

Committee members can also be on the conda Organization Steering Council.  However, Steering Council members have to make up less than 50% of the Code of Conduct Committee.

# Updating this Code of Conduct

The conda Organization's Code of Conduct can be updated by a [simple majority vote](#voting-and-decision-making) of the CoC Committee.


# License

This code of conduct is based on the [NumFOCUS code of conduct template](https://github.com/numfocus/numfocus/blob/8759e21481552f213489e3718979ccecf68e9ead/manual/numfocus-coc.md) as it existed on 2022/03/08 (which is the 2019/11/20 version).  Several added sections are based on the [Galaxy Community Code of Conduct](https://galaxyproject.org/community/coc/).

The NumFOCUS code of conduct template was itself adapted from numerous sources, including the [*Geek Feminism wiki, created by the Ada Initiative and other volunteers, which is under a Creative Commons Zero license*](http://geekfeminism.wikia.com/wiki/Conference_anti-harassment/Policy), the [*Contributor Covenant version 1.2.0*](http://contributor-covenant.org/version/1/2/0/), the [*Bokeh Code of Conduct*](https://github.com/bokeh/bokeh/blob/master/CODE_OF_CONDUCT.md), the [*SciPy Code of Conduct*](https://github.com/jupyter/governance/blob/master/conduct/enforcement.md), the [*Carpentries Code of Conduct*](https://docs.carpentries.org/topic_folders/policies/code-of-conduct.html#enforcement-manual), and the [*NeurIPS Code of Conduct*](https://neurips.cc/public/CodeOfConduct).

**The conda Organization Code of Conduct is licensed under the [Creative Commons Attribution 3.0 Unported License](https://creativecommons.org/licenses/by/3.0/).**
