// GENERATED BY THE COMMAND ABOVE; DO NOT EDIT
// This file was generated by swaggo/swag

package docs

import (
	"bytes"
	"encoding/json"
	"strings"

	"github.com/alecthomas/template"
	"github.com/swaggo/swag"
)

var doc = `{
    "schemes": {{ marshal .Schemes }},
    "swagger": "2.0",
    "info": {
        "description": "{{.Description}}",
        "title": "{{.Title}}",
        "contact": {
            "name": "WireGuard Portal Project",
            "url": "https://github.com/h44z/wg-portal"
        },
        "license": {
            "name": "MIT",
            "url": "https://github.com/h44z/wg-portal/blob/master/LICENSE.txt"
        },
        "version": "{{.Version}}"
    },
    "host": "{{.Host}}",
    "basePath": "{{.BasePath}}",
    "paths": {
        "/backend/device": {
            "get": {
                "security": [
                    {
                        "ApiBasicAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Interface"
                ],
                "summary": "Get the given device",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Device Name",
                        "name": "device",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/wireguard.Device"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "401": {
                        "description": "Unauthorized",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "403": {
                        "description": "Forbidden",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "404": {
                        "description": "Not Found",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiBasicAuth": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Interface"
                ],
                "summary": "Updates the given device based on the given device model (UNIMPLEMENTED)",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Device Name",
                        "name": "device",
                        "in": "query",
                        "required": true
                    },
                    {
                        "description": "Device Model",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/wireguard.Device"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/wireguard.Device"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "401": {
                        "description": "Unauthorized",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "403": {
                        "description": "Forbidden",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "404": {
                        "description": "Not Found",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    }
                }
            },
            "patch": {
                "security": [
                    {
                        "ApiBasicAuth": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Interface"
                ],
                "summary": "Updates the given device based on the given partial device model (UNIMPLEMENTED)",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Device Name",
                        "name": "device",
                        "in": "query",
                        "required": true
                    },
                    {
                        "description": "Device Model",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/wireguard.Device"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/wireguard.Device"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "401": {
                        "description": "Unauthorized",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "403": {
                        "description": "Forbidden",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "404": {
                        "description": "Not Found",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    }
                }
            }
        },
        "/backend/devices": {
            "get": {
                "security": [
                    {
                        "ApiBasicAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Interface"
                ],
                "summary": "Get all devices",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/wireguard.Device"
                            }
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "401": {
                        "description": "Unauthorized",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "403": {
                        "description": "Forbidden",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "404": {
                        "description": "Not Found",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    }
                }
            }
        },
        "/backend/peer": {
            "get": {
                "security": [
                    {
                        "ApiBasicAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Peers"
                ],
                "summary": "Retrieves the peer for the given public key",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Public Key (Base 64)",
                        "name": "pkey",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/wireguard.Peer"
                        }
                    },
                    "401": {
                        "description": "Unauthorized",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "403": {
                        "description": "Forbidden",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "404": {
                        "description": "Not Found",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiBasicAuth": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Peers"
                ],
                "summary": "Updates the given peer based on the given peer model",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Public Key",
                        "name": "pkey",
                        "in": "query",
                        "required": true
                    },
                    {
                        "description": "Peer Model",
                        "name": "peer",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/wireguard.Peer"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/wireguard.Peer"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "401": {
                        "description": "Unauthorized",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "403": {
                        "description": "Forbidden",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "404": {
                        "description": "Not Found",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiBasicAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Peers"
                ],
                "summary": "Updates the given peer based on the given partial peer model",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Public Key",
                        "name": "pkey",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "202": {
                        "description": "No Content"
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "401": {
                        "description": "Unauthorized",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "403": {
                        "description": "Forbidden",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "404": {
                        "description": "Not Found",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    }
                }
            },
            "patch": {
                "security": [
                    {
                        "ApiBasicAuth": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Peers"
                ],
                "summary": "Updates the given peer based on the given partial peer model",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Public Key",
                        "name": "pkey",
                        "in": "query",
                        "required": true
                    },
                    {
                        "description": "Peer Model",
                        "name": "peer",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/wireguard.Peer"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/wireguard.Peer"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "401": {
                        "description": "Unauthorized",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "403": {
                        "description": "Forbidden",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "404": {
                        "description": "Not Found",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    }
                }
            }
        },
        "/backend/peers": {
            "get": {
                "security": [
                    {
                        "ApiBasicAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Peers"
                ],
                "summary": "Retrieves all peers for the given interface",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Device Name",
                        "name": "device",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/wireguard.Peer"
                            }
                        }
                    },
                    "401": {
                        "description": "Unauthorized",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "403": {
                        "description": "Forbidden",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "404": {
                        "description": "Not Found",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiBasicAuth": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Peers"
                ],
                "summary": "Creates a new peer based on the given peer model",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Device Name",
                        "name": "device",
                        "in": "query",
                        "required": true
                    },
                    {
                        "description": "Peer Model",
                        "name": "peer",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/wireguard.Peer"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/wireguard.Peer"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "401": {
                        "description": "Unauthorized",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "403": {
                        "description": "Forbidden",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "404": {
                        "description": "Not Found",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    }
                }
            }
        },
        "/backend/user": {
            "get": {
                "security": [
                    {
                        "ApiBasicAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Retrieves user based on given Email",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User Email",
                        "name": "email",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/users.User"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "401": {
                        "description": "Unauthorized",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "403": {
                        "description": "Forbidden",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "404": {
                        "description": "Not Found",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "ApiBasicAuth": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Updates a user based on the given user model",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User Email",
                        "name": "email",
                        "in": "query",
                        "required": true
                    },
                    {
                        "description": "User Model",
                        "name": "user",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/users.User"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/users.User"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "401": {
                        "description": "Unauthorized",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "403": {
                        "description": "Forbidden",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "404": {
                        "description": "Not Found",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "ApiBasicAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Deletes the specified user",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User Email",
                        "name": "email",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No content"
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "401": {
                        "description": "Unauthorized",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "403": {
                        "description": "Forbidden",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "404": {
                        "description": "Not Found",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    }
                }
            },
            "patch": {
                "security": [
                    {
                        "ApiBasicAuth": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Updates a user based on the given partial user model",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User Email",
                        "name": "email",
                        "in": "query",
                        "required": true
                    },
                    {
                        "description": "User Model",
                        "name": "user",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/users.User"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/users.User"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "401": {
                        "description": "Unauthorized",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "403": {
                        "description": "Forbidden",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "404": {
                        "description": "Not Found",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    }
                }
            }
        },
        "/backend/users": {
            "get": {
                "security": [
                    {
                        "ApiBasicAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Retrieves all users",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/users.User"
                            }
                        }
                    },
                    "401": {
                        "description": "Unauthorized",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "403": {
                        "description": "Forbidden",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "404": {
                        "description": "Not Found",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "ApiBasicAuth": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Creates a new user based on the given user model",
                "parameters": [
                    {
                        "description": "User Model",
                        "name": "user",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/users.User"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/users.User"
                        }
                    },
                    "400": {
                        "description": "Bad Request",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "401": {
                        "description": "Unauthorized",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "403": {
                        "description": "Forbidden",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "404": {
                        "description": "Not Found",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    }
                }
            }
        },
        "/provisioning/peer": {
            "get": {
                "security": [
                    {
                        "GeneralBasicAuth": []
                    }
                ],
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Provisioning"
                ],
                "summary": "Retrieves the peer config for the given public key",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Public Key (Base 64)",
                        "name": "pkey",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "The WireGuard configuration file",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "401": {
                        "description": "Unauthorized",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "403": {
                        "description": "Forbidden",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "404": {
                        "description": "Not Found",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    }
                }
            }
        },
        "/provisioning/peers": {
            "get": {
                "security": [
                    {
                        "GeneralBasicAuth": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Provisioning"
                ],
                "summary": "Retrieves all active peers for the given email address",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Email Address",
                        "name": "email",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "All active WireGuard peers",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/server.PeerDeploymentInformation"
                            }
                        }
                    },
                    "401": {
                        "description": "Unauthorized",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "403": {
                        "description": "Forbidden",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "404": {
                        "description": "Not Found",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "GeneralBasicAuth": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "Provisioning"
                ],
                "summary": "Creates the requested peer config and returns the config file",
                "parameters": [
                    {
                        "description": "Provisioning Request Model",
                        "name": "body",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/server.ProvisioningRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "The WireGuard configuration file",
                        "schema": {
                            "type": "string"
                        }
                    },
                    "401": {
                        "description": "Unauthorized",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "403": {
                        "description": "Forbidden",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    },
                    "404": {
                        "description": "Not Found",
                        "schema": {
                            "$ref": "#/definitions/server.ApiError"
                        }
                    }
                }
            }
        }
    },
    "definitions": {
        "gorm.DeletedAt": {
            "type": "object",
            "properties": {
                "time": {
                    "type": "string"
                },
                "valid": {
                    "description": "Valid is true if Time is not NULL",
                    "type": "boolean"
                }
            }
        },
        "server.ApiError": {
            "type": "object",
            "properties": {
                "message": {
                    "type": "string"
                }
            }
        },
        "server.PeerDeploymentInformation": {
            "type": "object",
            "properties": {
                "device": {
                    "type": "string"
                },
                "deviceIdentifier": {
                    "type": "string"
                },
                "identifier": {
                    "type": "string"
                },
                "publicKey": {
                    "type": "string"
                }
            }
        },
        "server.ProvisioningRequest": {
            "type": "object",
            "required": [
                "email",
                "identifier"
            ],
            "properties": {
                "allowedIPsStr": {
                    "type": "string"
                },
                "deviceName": {
                    "description": "DeviceName is optional, if not specified, the configured default device will be used.",
                    "type": "string"
                },
                "dnsstr": {
                    "type": "string"
                },
                "email": {
                    "type": "string"
                },
                "identifier": {
                    "type": "string"
                },
                "mtu": {
                    "type": "integer"
                },
                "persistentKeepalive": {
                    "type": "integer"
                }
            }
        },
        "users.User": {
            "type": "object",
            "required": [
                "email",
                "firstname",
                "lastname"
            ],
            "properties": {
                "createdAt": {
                    "description": "database internal fields",
                    "type": "string"
                },
                "deletedAt": {
                    "$ref": "#/definitions/gorm.DeletedAt"
                },
                "email": {
                    "description": "required fields",
                    "type": "string"
                },
                "firstname": {
                    "description": "optional fields",
                    "type": "string"
                },
                "isAdmin": {
                    "type": "boolean"
                },
                "lastname": {
                    "type": "string"
                },
                "password": {
                    "description": "optional, integrated password authentication",
                    "type": "string"
                },
                "phone": {
                    "type": "string"
                },
                "source": {
                    "type": "string"
                },
                "updatedAt": {
                    "type": "string"
                }
            }
        },
        "wireguard.Device": {
            "type": "object",
            "required": [
                "deviceName",
                "ipsStr",
                "privateKey",
                "publicKey",
                "type"
            ],
            "properties": {
                "createdAt": {
                    "type": "string"
                },
                "defaultAllowedIPsStr": {
                    "description": "comma separated list  of IPs that are used in the client config file",
                    "type": "string"
                },
                "defaultEndpoint": {
                    "description": "Settings that are applied to all peer by default",
                    "type": "string"
                },
                "defaultPersistentKeepalive": {
                    "type": "integer"
                },
                "deviceName": {
                    "type": "string"
                },
                "displayName": {
                    "type": "string"
                },
                "dnsstr": {
                    "description": "comma separated list of the DNS servers of the client, wg-quick addition",
                    "type": "string"
                },
                "firewallMark": {
                    "type": "integer"
                },
                "ipsStr": {
                    "description": "comma separated list of the IPs of the client, wg-quick addition",
                    "type": "string"
                },
                "listenPort": {
                    "type": "integer"
                },
                "mtu": {
                    "description": "the interface MTU, wg-quick addition",
                    "type": "integer"
                },
                "postDown": {
                    "description": "post down script, wg-quick addition",
                    "type": "string"
                },
                "postUp": {
                    "description": "post up script, wg-quick addition",
                    "type": "string"
                },
                "preDown": {
                    "description": "pre down script, wg-quick addition",
                    "type": "string"
                },
                "preUp": {
                    "description": "pre up script, wg-quick addition",
                    "type": "string"
                },
                "privateKey": {
                    "description": "Core WireGuard Settings (Interface section)",
                    "type": "string"
                },
                "publicKey": {
                    "description": "Misc. WireGuard Settings",
                    "type": "string"
                },
                "routingTable": {
                    "description": "the routing table, wg-quick addition",
                    "type": "string"
                },
                "saveConfig": {
                    "description": "if set to ` + "`" + `true', the configuration is saved from the current state of the interface upon shutdown, wg-quick addition",
                    "type": "boolean"
                },
                "type": {
                    "type": "string"
                },
                "updatedAt": {
                    "type": "string"
                }
            }
        },
        "wireguard.Peer": {
            "type": "object",
            "required": [
                "deviceName",
                "email",
                "identifier",
                "publicKey"
            ],
            "properties": {
                "allowedIPsStr": {
                    "description": "a comma separated list of IPs that are used in the client config file",
                    "type": "string"
                },
                "createdAt": {
                    "type": "string"
                },
                "createdBy": {
                    "type": "string"
                },
                "deactivatedAt": {
                    "type": "string"
                },
                "deviceName": {
                    "type": "string"
                },
                "dnsstr": {
                    "description": "comma separated list of the DNS servers for the client",
                    "type": "string"
                },
                "email": {
                    "type": "string"
                },
                "endpoint": {
                    "type": "string"
                },
                "identifier": {
                    "description": "Identifier AND Email make a WireGuard peer unique",
                    "type": "string"
                },
                "ignoreGlobalSettings": {
                    "type": "boolean"
                },
                "ipsStr": {
                    "description": "a comma separated list of IPs of the client",
                    "type": "string"
                },
                "mtu": {
                    "description": "Global Device Settings (can be ignored, only make sense if device is in server mode)",
                    "type": "integer"
                },
                "persistentKeepalive": {
                    "type": "integer"
                },
                "presharedKey": {
                    "type": "string"
                },
                "privateKey": {
                    "description": "Misc. WireGuard Settings",
                    "type": "string"
                },
                "publicKey": {
                    "description": "Core WireGuard Settings",
                    "type": "string"
                },
                "updatedAt": {
                    "type": "string"
                },
                "updatedBy": {
                    "type": "string"
                }
            }
        }
    },
    "securityDefinitions": {
        "ApiBasicAuth": {
            "type": "basic"
        },
        "GeneralBasicAuth": {
            "type": "basic"
        }
    }
}`

type swaggerInfo struct {
	Version     string
	Host        string
	BasePath    string
	Schemes     []string
	Title       string
	Description string
}

// SwaggerInfo holds exported Swagger Info so clients can modify it
var SwaggerInfo = swaggerInfo{
	Version:     "1.0",
	Host:        "",
	BasePath:    "/api/v1",
	Schemes:     []string{},
	Title:       "WireGuard Portal API",
	Description: "WireGuard Portal API for managing users and peers.",
}

type s struct{}

func (s *s) ReadDoc() string {
	sInfo := SwaggerInfo
	sInfo.Description = strings.Replace(sInfo.Description, "\n", "\\n", -1)

	t, err := template.New("swagger_info").Funcs(template.FuncMap{
		"marshal": func(v interface{}) string {
			a, _ := json.Marshal(v)
			return string(a)
		},
	}).Parse(doc)
	if err != nil {
		return doc
	}

	var tpl bytes.Buffer
	if err := t.Execute(&tpl, sInfo); err != nil {
		return doc
	}

	return tpl.String()
}

func init() {
	swag.Register(swag.Name, &s{})
}
