/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import com.kenai.constantine.platform.Fcntl;
import com.kenai.constantine.platform.OpenFlags;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jnr.constants.platform.ProtocolFamily;
import jnr.constants.platform.Sock;
import jnr.constants.platform.SocketLevel;
import jnr.constants.platform.SocketOption;
import jnr.ffi.LastError;
import jnr.ffi.Library;
import jnr.ffi.Platform;
import jnr.ffi.Runtime;
import jnr.ffi.annotations.In;
import jnr.ffi.annotations.Out;
import jnr.ffi.annotations.Transient;
import jnr.ffi.byref.IntByReference;
import jnr.unixsocket.SockAddrUnix;

class Native {
    static final String[] libnames;

    Native() {
    }

    static final LibC libsocket() {
        return LibC.INSTANCE;
    }

    static final LibC libc() {
        return LibC.INSTANCE;
    }

    static int socket(ProtocolFamily protocolFamily, Sock sock, int n) throws IOException {
        int n2 = Native.libsocket().socket(protocolFamily.intValue(), sock.intValue(), n);
        if (n2 < 0) {
            throw new IOException(Native.getLastErrorString());
        }
        return n2;
    }

    static int socketpair(ProtocolFamily protocolFamily, Sock sock, int n, int[] nArray) throws IOException {
        if (Native.libsocket().socketpair(protocolFamily.intValue(), sock.intValue(), n, nArray) < 0) {
            throw new IOException("socketpair(2) failed " + Native.getLastErrorString());
        }
        return 0;
    }

    static int listen(int n, int n2) {
        return Native.libsocket().listen(n, n2);
    }

    static int bind(int n, SockAddrUnix sockAddrUnix, int n2) {
        return Native.libsocket().bind(n, sockAddrUnix, n2);
    }

    static int accept(int n, SockAddrUnix sockAddrUnix, IntByReference intByReference) {
        return Native.libsocket().accept(n, sockAddrUnix, intByReference);
    }

    static int connect(int n, SockAddrUnix sockAddrUnix, int n2) {
        return Native.libsocket().connect(n, sockAddrUnix, n2);
    }

    static String getLastErrorString() {
        return Native.strerror(LastError.getLastError((Runtime)Runtime.getSystemRuntime()));
    }

    static String strerror(int n) {
        return Native.libc().strerror(n);
    }

    public static void setBlocking(int n, boolean bl) {
        int n2 = Native.libc().fcntl(n, LibC.F_GETFL, 0);
        n2 = bl ? (n2 &= ~LibC.O_NONBLOCK) : (n2 |= LibC.O_NONBLOCK);
        Native.libc().fcntl(n, LibC.F_SETFL, n2);
    }

    public static int setsockopt(int n, SocketLevel socketLevel, SocketOption socketOption, boolean bl) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        byteBuffer.putInt(bl ? 1 : 0).flip();
        return Native.libsocket().setsockopt(n, socketLevel.intValue(), socketOption.intValue(), byteBuffer, byteBuffer.remaining());
    }

    static {
        String[] stringArray;
        if (Platform.getNativePlatform().getOS() == Platform.OS.SOLARIS) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "socket";
            stringArray2[1] = "nsl";
            stringArray = stringArray2;
            stringArray2[2] = "c";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "c";
        }
        libnames = stringArray;
    }

    public static interface LibC {
        public static final LibC INSTANCE = (LibC)Library.loadLibrary(LibC.class, (String[])libnames);
        public static final int F_GETFL = Fcntl.F_GETFL.value();
        public static final int F_SETFL = Fcntl.F_SETFL.value();
        public static final int O_NONBLOCK = OpenFlags.O_NONBLOCK.value();

        public int socket(int var1, int var2, int var3);

        public int listen(int var1, int var2);

        public int bind(int var1, @In @Out @Transient SockAddrUnix var2, int var3);

        public int accept(int var1, @Out SockAddrUnix var2, @In @Out IntByReference var3);

        public int connect(int var1, @In @Transient SockAddrUnix var2, int var3);

        public int getsockname(int var1, @Out SockAddrUnix var2, @In @Out IntByReference var3);

        public int getpeername(int var1, @Out SockAddrUnix var2, @In @Out IntByReference var3);

        public int socketpair(int var1, int var2, int var3, @Out int[] var4);

        public int fcntl(int var1, int var2, int var3);

        public int getsockopt(int var1, int var2, int var3, @Out ByteBuffer var4, @In @Out IntByReference var5);

        public int setsockopt(int var1, int var2, int var3, @In ByteBuffer var4, int var5);

        public String strerror(int var1);
    }
}

