# encoding: UTF-8
require 'test/unit'

class TestRegex19 < Test::Unit::TestCase
  def test_to_s
    assert_equal /(?-mix:foo|bar)/, /#{Regexp.union("foo", "bar")}/
  end

  # JRUBY-5622
  def test_dstr_with_unicode_class
    letter = '\p{L}'
    atext = "[#{letter}]"
    assert_nothing_raised { /#{atext}/ }
  end

  # JRUBY-5924
  def test_matchdata_end_position_on_unicode_strings
    rails_scriptlet_re = /(?m-ix:<%(=+|-|\#|%)?(.*?)([-=])?%>([ \t]*\r?\n)?)/
    match = rails_scriptlet_re.match "<%= @user %> á"

    assert_equal 12, match.end(0)
  end
end
