---
title: "Grafana Mimir version 3.0 release notes"
menuTitle: "V3.0 release notes"
description: "Release notes for Grafana Mimir version 3.0"
weight: 1100
---

# Grafana Mimir version 3.0 release notes

<!-- vale Grafana.GoogleWill = NO -->
<!-- vale Grafana.Timeless = NO -->
<!-- Release notes are often future focused -->

Grafana Labs is excited to announce version 3.0 of Grafana Mimir.

The highlights that follow include the top features, enhancements, and bug fixes in this release. For the complete list of changes, refer to the [CHANGELOG](https://github.com/grafana/mimir/blob/main/CHANGELOG.md).

## Features and enhancements

Grafana Mimir version 3.0 includes the following key features and enhancements.

### Ingest storage architecture

Mimir 3.0 introduces ingest storage architecture, a next-generation architecture that separates the read and write paths using a Kafka-based ingest storage layer. In previous versions, the ingester handled both ingestion and querying, which could cause contention under heavy query loads. By introducing Kafka as an asynchronous buffer between ingestion and query, reads and writes now scale independently. This design improves ingestion stability, query performance, and operational flexibility for large deployments.

Note that in Grafana Mimir version 3.0, classic architecture is still supported.

### Mimir Query Engine (MQE)

The Mimir Query Engine (MQE) is now the default query engine for all queriers and query-frontends. MQE is fully PromQL-compatible and processes data in a streaming fashion, reducing peak memory usage by up to 92% compared to the Prometheus engine. You can expect faster, more stable query performance and lower resource consumption under load.

### Additional improvements

Grafana Mimir 3.0 also includes:

- Optimizations to MQE for histogram queries and query rewrites
- Improvements to query planning in frontends and queriers
- General stability and performance updates across core components

## Important changes

Grafana Mimir 3.0 introduces several updates that change default behavior and configuration. Review these changes before upgrading:

- Ingest storage architecture: Grafana Mimir now uses a Kafka-based ingest storage layer that separates reads and writes. This change improves performance by altering data flow between components.
- MQE as the default engine: MQE replaces the Prometheus engine as the default query engine. To continue using the Prometheus engine, set `-querier.query-engine=prometheus`.
- Removal of experimental features: Some deprecated and experimental flags, including the read-write deployment mode, have been removed.
- Configuration updates: Some deprecated CLI flags and configuration options have been removed or renamed.

## Experimental features

Grafana Mimir 3.0 includes some features that are experimental and disabled by default. Use these features with caution and report any issues that you encounter:

- Prometheus Remote-Write 2.0 protocol
- PromQL duration expressions that allow simple arithmetic in range or offset values
- Cluster validation for HTTP requests (`-server.cluster-validation.*` flags)
- Native OTLP delta metric ingestion (`-distributor.otel-native-delta-ingestion`)

## Bug fixes

For a detailed list of bug fixes, refer to the [CHANGELOG](https://github.com/grafana/mimir/blob/main/CHANGELOG.md).

### Helm chart improvements

The Grafana Mimir Helm chart is released independently. Refer to the [Grafana Mimir Helm chart documentation](https://grafana.com/docs/helm-charts/mimir-distributed/latest/).
