---
title: "Grafana Mimir Helm chart version 4.3 release notes"
menuTitle: "V4.3 release notes"
description: "Release notes for Grafana Mimir Helm chart version 4.3"
weight: 300
---

# Grafana Mimir Helm chart version 4.3 release notes

Grafana Labs is excited to announce version 4.3 of the Grafana Mimir Helm chart, which is compatible with Grafana Mimir v2.7 or Grafana Enterprise Metrics (GEM) v2.7. The `mimir-distributed` Helm chart is the best way to install Mimir on Kubernetes.

To learn about new features and enhancements in Grafana Mimir or GEM, see the release notes for [Grafana Mimir v2.7](/docs/mimir/v2.7.x/release-notes/v2.7/) or [Grafana Enterprise Metrics v2.7](/docs/enterprise-metrics/v2.7.x/release-notes/v2-7/).

The highlights that follow include the top features, enhancements, and bugfixes in this release. For a comprehensive list of changes, see the [Helm chart changelog](https://github.com/grafana/mimir/tree/main/operations/helm/charts/mimir-distributed/CHANGELOG.md).

> **Note:** If you are upgrading from a previous major version, review the changelog entry for all the major releases since then and perform the necessary migrations.

## Important changes

- The ruler deployment max surge was changed from `0` to `50%`, and max unavailable from `1` to `0`.

## Features and enhancements

Notable enhancements are as follows:

- **nginx autoscaling**
  Support autoscaling/v2 HorizontalPodAutoscaler for nginx autoscaling starting with Kubernetes 1.23.
- **Default pod security context**
  Set default pod security context under `rbac.podSecurityContext` for easier install on OpenShift.
- **Cache support for GEM's admin bucket**
  The cache will be enabled by default when you use the small.yaml, large.yaml, capped-small.yaml
  or capped-large.yaml Helm values file.
  > **Note:** For more information, refer to the [Grafana Enterprise Metrics configuration](/docs/enterprise-metrics/v2.7.x/config/).

## Bug fixes

- [PR 4299](https://github.com/grafana/mimir/pull/4299): Allow override of Kubernetes version for nginx HPA.
- [PR 4353](https://github.com/grafana/mimir/pull/4353): Do not generate query-frontend-headless service if query scheduler is enabled. Fixes parity with jsonnet.
- [PR 4126](https://github.com/grafana/mimir/pull/4126): Apply `clusterLabel` to ServiceMonitors for kube-state-metrics, kubelet, and cadvisor.
- [PR 4392](https://github.com/grafana/mimir/pull/4392): Add http port in distributor headless service. Fixes parity with jsonnet.
- [PR 4272](https://github.com/grafana/mimir/pull/4272): Generate the pod security context on the pod level in graphite web deployment, instead of on container level.
- [PR 4485](https://github.com/grafana/mimir/pull/4485): Fix kube-state-metrics metricRelabelings dropping pods and deployments.
- [PR 4407](https://github.com/grafana/mimir/pull/4485): Allow for single extraArg flags in templated memcached args.

### 4.3.1

- [PR 4803](https://github.com/grafana/mimir/pull/4803): Updated Go version in Mimir and GEM images to 1.20.3 to fix CVE-2023-24538.
