---
title: "Grafana Mimir Helm chart version 6.0 release notes"
menuTitle: "V6.0 release notes"
description: "Release notes for Grafana Mimir Helm chart version 6.0"
weight: 300
---

# Grafana Mimir Helm chart version 6.0 release notes

Grafana Labs is excited to announce version 6.0 of the Grafana Mimir Helm chart, which is compatible with Grafana Mimir version 3.0. The `mimir-distributed` Helm chart is the best way to install Mimir on Kubernetes.

To upgrade from version 5.x, refer to [Migrate the Helm chart from version 5.x to 6.0](https://grafana.com/docs/helm-charts/mimir-distributed/latest/migration-guides/migrate-helm-chart-5.x-to-6.0/).

The highlights that follow include the top features, enhancements, and bug fixes in this release. For a comprehensive list of changes, see the [Helm chart changelog](https://github.com/grafana/mimir/tree/main/operations/helm/charts/mimir-distributed/CHANGELOG.md3600).

## Important changes

### Ingest storage architecture is now the default

The Helm chart deploys Grafana Mimir using the ingest storage architecture by default. This next-generation architecture decouples read and write paths using Apache Kafka or a Kafka-compatible backend. Refer to [About ingest storage architecture](https://grafana.com/docs/mimir/latest/get-started/about-grafana-mimir-architecture/about-ingest-storage-architecture/) in the Grafana Mimir documentation for more information.

The Helm chart deploys a single-node Kafka cluster for demo purposes. In production environments, you must configure Mimir components with credentials for an external Kafka-compatible cluster. Refer to ["Run Grafana Mimir in production using the Helm chart"](https://grafana.com/docs/helm-charts/mimir-distributed/v6.0.x/run-production-environment-with-helm/) for more information.

### Minimum Kubernetes version

The minimum compatible Kubernetes version is v1.29.

### Removed NGINX configuration

The deprecated `nginx` top-level values section is removed. Use the `gateway` section instead. For migration guidance, refer to the [migration guide](https://grafana.com/docs/helm-charts/mimir-distributed/v5.6.x/migration-guides/migrate-to-unified-proxy-deployment/).

### Rollout operator upgrade

The rollout-operator has been upgraded to [version 0.35.1](https://github.com/grafana/helm-charts/blob/main/charts/rollout-operator/README.md#upgrade-of-grafana-rollout-operator). Before upgrading to Helm chart version 6.0, you must apply the CustomResourceDefinitions (CRDs) from [helm-charts](https://github.com/grafana/helm-charts/tree/main/charts/rollout-operator/crds) to your cluster.

### Grafana Agent deprecation

The `metaMonitoring.grafanaAgent` values are deprecated. Grafana Agent was deprecated in early 2024 and reaches End-of-Support at the end of 2025. Instead of provisioning the agent's Kubernetes resources with `metaMonitoring.grafanaAgent.enabled`, collect Mimir's meta-monitoring data with an external collector. It is recommended to use Grafana k8s-monitoring, which manages the creation and lifecycle of Alloy instances and has built-in support for collecting telemetry from Grafana LGTM stacks.

## Features and enhancements

You can apply user-defined overrides to components with predefined `GOMAXPROCS` or `GOMEMLIMIT` environment variables, such as the distributor, ingester, querier, ruler-querier, and store-gateway, through the components' `env` values.

All components support `dnsConfig`.

The distributor, gateway, querier, query-frontend, query-scheduler, ingester, and store-gateway services include a `trafficDistribution` configuration option to enable same-zone traffic routing.

## Bug fixes

For a complete list of bug fixes, see the [Helm chart changelog](https://github.com/grafana/mimir/tree/main/operations/helm/charts/mimir-distributed/CHANGELOG.md).
