---
title: "Grafana Mimir Helm chart version 4.0 release notes"
menuTitle: "V4.0 release notes"
description: "Release notes for Grafana Mimir Helm chart version 4.0"
weight: 300
---

# Grafana Mimir Helm chart version 4.0 release notes

Grafana Labs is excited to announce version 4.0 of the Grafana Mimir Helm chart, which is compatible with Grafana Mimir v2.5 and Grafana Enterprise Metrics v2.5. The `mimir-distributed` Helm chart is the best way to install Mimir on Kubernetes.

To learn about new features and enhancements in Grafana Mimir or GEM, see the release notes for [Grafana Mimir v2.5](/docs/mimir/v2.5.x/release-notes/v2.5/) or [Grafana Enterprise Metrics v2.5](/docs/enterprise-metrics/latest/release-notes/v2-5/).

The highlights that follow include the top features, enhancements, and bugfixes in this release. For a comprehensive list of changes, see the [Helm chart changelog](https://github.com/grafana/mimir/tree/main/operations/helm/charts/mimir-distributed/CHANGELOG.md).

> **Note:** If you are upgrading from Grafana Mimir Helm chart 3.3, review the [list of important changes](#important-changes) that follow.

## Features and enhancements

Notable enhancements are as follows:

- **Zone aware replication**
  Helm now supports deploying the ingesters and store-gateways as different availability zones. The replication is also zone-aware, therefore multiple instances of one zone can fail without any service interruption and rollouts can be performed faster because many instances of each zone can be restarted together, as opposed to them all restarting in sequence.

- **Running without root privileges**
  All Mimir, GEM, and Agent processes no longer require root privileges to run.

- **Unified reverse proxy (`gateway`) configuration for Mimir and GEM**
  This change allows you to more easily upgrade from Mimir to GEM, without any downtime. The unified configuration also makes it possible to autoscale the GEM gateway pods and it supports OpenShift Route. The change also deprecates the `nginx` section in the configuration. The section will be removed in release `7.0.0`.

  > **Note:** The `nginx` section was removed earlier than planned in release `6.0.0` instead of `7.0.0`.

- **Various quality of life improvements**
  - Rollout strategies with zero downtime
  - Read-path and compactor configuration provide better default settings
  - OTLP ingestion support in the Nginx configuration
  - A default configuration for Alertmanager: its user interface, as well as the sending of alerts from the ruler, work out of the box

## Important changes

In Grafana Mimir Helm chart v4.0, the following changes were made:

- **Breaking change**, zone aware replication is enabled by default, which can cause data loss if upgrade procedure is not followed, [for details about how to upgrade, see the Helm changelog](https://github.com/grafana/mimir/blob/main/operations/helm/charts/mimir-distributed/CHANGELOG.md).
- We updated our sizing plans to make them better reflect how we recommend running Mimir and GEM in production.
- **Breaking change**, due to the sizing plans updates, users of the _small_ plan must consult the [Helm changelog](https://github.com/grafana/mimir/blob/main/operations/helm/charts/mimir-distributed/CHANGELOG.md).
- **Updated MinIO**
  The MinIO sub-chart was updated from `4.x` to `5.0.0`. This update **inherits a breaking change** because the MinIO gateway mode was removed.

## Bug fixes

- [PR 3170](https://github.com/grafana/mimir/pull/3170): Fix an issue that caused metamonitoring secrets to be created incorrectly.
- [PR 3208](https://github.com/grafana/mimir/pull/3208): Nginx: fixed imagePullSecret value reference inconsistency.
- [PR 3169](https://github.com/grafana/mimir/pull/3169): Move the activity tracker log from /data to /active-query-tracker to remove ignore log messages.
- [PR 3087](https://github.com/grafana/mimir/pull/3087): Fix Invalid ingress nginx config due to newline in prometheusHttpPrefix Helm named templates.
- [PR 3479](https://github.com/grafana/mimir/pull/3479): Added missing endpoint for OTLP in NGINX.
