---
aliases:
  - ../operators-guide/configure/reference-configuration-parameters/
  - ../operators-guide/configuring/reference-configuration-parameters/
  - ../reference-configuration-parameters/
  - ../references/configuration-parameters/
description: Describes parameters used to configure Grafana Mimir.
menuTitle: Configuration parameters
title: Grafana Mimir configuration parameters
weight: 130
---

# Grafana Mimir configuration parameters

<!-- DO NOT EDIT THIS FILE - This file has been automatically generated from its .template -->

You can configure Grafana Mimir by using a YAML file or via command-line flags
that represent configuration parameters.
To specify the YAML file, use the `-config.file` command-line option.
If you specify both the command-line flags and YAML configuration parameters,
the command-line flags take precedence over values in a YAML file.

To see the current configuration of any component,
go to the `/config` HTTP API endpoint.
Passwords are filtered out of this endpoint.

Parameters are
written in [YAML format](https://en.wikipedia.org/wiki/YAML), and
brackets indicate that a parameter is optional.

## Generic placeholders

- `<boolean>`: a boolean that can take the values `true` or `false`
- `<int>`: any integer matching the regular expression `[1-9]+[0-9]*`
- `<duration>`: a duration matching the regular expression `[0-9]+(ns|us|µs|ms|s|m|h|d|w|y)` where y = 365 days
- `<string>`: a string
- `<url>`: a URL
- `<filepath>`: a string containing an absolute or relative path and filename to a file on disk
- `<prefix>`: a CLI flag prefix based on the context (look at the parent configuration block to see which CLI flags prefix should be used)
- `<relabel_config>`: a [Prometheus relabeling configuration](https://prometheus.io/docs/prometheus/latest/configuration/configuration/#relabel_config)
- `<time>`: a timestamp, with available formats:
  - `2006-01-20` (midnight, local timezone)
  - `2006-01-20T15:04` (local timezone)
  - RFC 3339 formats: `2006-01-20T15:04:05Z` (UTC) or `2006-01-20T15:04:05+07:00` (explicit timezone)

## Parameter categories

In order to simplify Mimir configuration, we categorize parameters by
maturity level and intended use:

- **Basic** parameters are ones that we expect the majority of users to modify.
  Examples of basic parameters are object store credentials and
  other dependency connection information.
  These parameters will generally remain stable for long periods of time,
  and they focus on user goals.
  In this reference, any parameters that are not marked as `(advanced)` or
  `(experimental)` are in the basic category.

- **Advanced** parameters are ones that few users will change
  from their default values.
  There are strong use cases for altered values.
  In this reference, advanced-category parameters include `(advanced)` at
  the beginning of their description.

- **Experimental** parameters are for new and experimental features.
  These parameters permit
  early adopters and Mimir developers to gain confidence with new
  features.
  In this reference, experimental-category parameters include `(experimental)` at
  the beginning of their description.

### Parameter lifecycle

When new parameters are added, they can be introduced as **basic**, **advanced**, or **experimental**.

**Experimental** parameters will remain experimental until they are either made stable or removed. Parameters that are made stable will be classified as either **basic** or **advanced**. We aim to make this decision on an experimental parameter within 6 months of its initial release, but this decision may take longer depending on what we discover during testing, or if upstream dependencies (e.g., Prometheus) of our code changes.

If we decide to eliminate a **basic** or **advanced** parameter, we will first mark it deprecated. After two more minor releases, a deprecated flag will be removed entirely. Use the metric `deprecated_flags_inuse_total` to determine whether you're using deprecated flags.
A configuration parameter is in maintenance and usable as expected between its deprecation and removal.
If you configure Mimir with a removed parameter, Mimir will fail to start.

![Parameter states](param-states.png)

## Use environment variables in the configuration

You can use environment variable references in the YAML configuration file
to set values that need to be configurable during deployment.
To do this, pass `-config.expand-env=true` on the command line and use
`${VAR}`,
where `VAR` is the name of the environment variable.

Each variable reference is replaced at startup by the value of the environment variable.
The replacement is case-sensitive and occurs before the YAML file is parsed.
References to undefined variables are replaced by empty strings unless you specify a default value or custom error text.

To specify a default value, use `${VAR:default_value}`,
where `default_value` is the value to use if the environment variable is undefined.

## Configuration parameters

```yaml
# Comma-separated list of components to include in the instantiated process. The
# default value 'all' includes all components that are required to form a
# functional Grafana Mimir instance in single-binary mode. Use the '-modules'
# command line flag to get a list of available components, and to see which
# components are included with 'all'.
# CLI flag: -target
[target: <string> | default = "all"]

# When set to true, incoming HTTP requests must specify tenant ID in HTTP
# X-Scope-OrgId header. When set to false, tenant ID from -auth.no-auth-tenant
# is used instead.
# CLI flag: -auth.multitenancy-enabled
[multitenancy_enabled: <boolean> | default = true]

# (advanced) Tenant ID to use when multitenancy is disabled.
# CLI flag: -auth.no-auth-tenant
[no_auth_tenant: <string> | default = "anonymous"]

# (advanced) How long to wait between SIGTERM and shutdown. After receiving
# SIGTERM, Mimir will report not-ready status via /ready endpoint.
# CLI flag: -shutdown-delay
[shutdown_delay: <duration> | default = 0s]

# (experimental) Maximum number of groups allowed per user by which specified
# distributor and ingester metrics can be further separated.
# CLI flag: -max-separate-metrics-groups-per-user
[max_separate_metrics_groups_per_user: <int> | default = 1000]

# (advanced) Set to true to enable all Go runtime metrics, such as go_sched_*
# and go_memstats_*.
# CLI flag: -enable-go-runtime-metrics
[enable_go_runtime_metrics: <boolean> | default = false]

api:
  # (advanced) Allows to skip label name validation via
  # X-Mimir-SkipLabelNameValidation header on the http write path. Use with
  # caution as it breaks PromQL. Allowing this for external clients allows any
  # client to send invalid label names. After enabling it, requests with a
  # specific HTTP header set to true will not have label names validated.
  # CLI flag: -api.skip-label-name-validation-header-enabled
  [skip_label_name_validation_header_enabled: <boolean> | default = false]

  # (advanced) Allows to disable enforcement of the label count limit
  # "max_label_names_per_series" via X-Mimir-SkipLabelCountValidation header on
  # the http write path. Allowing this for external clients allows any client to
  # send invalid label counts. After enabling it, requests with a specific HTTP
  # header set to true will not have label counts validated.
  # CLI flag: -api.skip-label-count-validation-header-enabled
  [skip_label_count_validation_header_enabled: <boolean> | default = false]

  # (advanced) HTTP URL path under which the Alertmanager ui and api will be
  # served.
  # CLI flag: -http.alertmanager-http-prefix
  [alertmanager_http_prefix: <string> | default = "/alertmanager"]

  # (advanced) HTTP URL path under which the Prometheus api will be served.
  # CLI flag: -http.prometheus-http-prefix
  [prometheus_http_prefix: <string> | default = "/prometheus"]

# The server block configures the HTTP and gRPC server of the launched
# service(s).
[server: <server>]

# The distributor block configures the distributor.
[distributor: <distributor>]

# The querier block configures the querier.
[querier: <querier>]

# The ingester_client block configures how the distributors connect to the
# ingesters.
[ingester_client: <ingester_client>]

# The ingester block configures the ingester.
[ingester: <ingester>]

# The flusher block configures the WAL flusher target, used to manually run
# one-time flushes when scaling down ingesters.
[flusher: <flusher>]

# The limits block configures default and per-tenant limits imposed by
# components.
[limits: <limits>]

# The frontend_worker block configures the worker running within the querier,
# picking up and executing queries enqueued by the query-frontend or the
# query-scheduler.
[frontend_worker: <frontend_worker>]

# The frontend block configures the query-frontend.
[frontend: <frontend>]

# The ingest_storage block configures the Kafka-based ingest storage.
[ingest_storage: <ingest_storage>]

# The blocks_storage block configures the blocks storage.
[blocks_storage: <blocks_storage>]

# The compactor block configures the compactor component.
[compactor: <compactor>]

# The store_gateway block configures the store-gateway component.
[store_gateway: <store_gateway>]

tenant_federation:
  # If enabled on all services, queries can be federated across multiple
  # tenants. The tenant IDs involved need to be specified separated by a '|'
  # character in the 'X-Scope-OrgID' header.
  # CLI flag: -tenant-federation.enabled
  [enabled: <boolean> | default = false]

  # (experimental) The number of workers used for each tenant federated query.
  # This setting limits the maximum number of per-tenant queries executed at a
  # time for a tenant federated query.
  # CLI flag: -tenant-federation.max-concurrent
  [max_concurrent: <int> | default = 16]

  # The max number of tenant IDs that may be supplied for a federated query if
  # enabled. 0 to disable the limit.
  # CLI flag: -tenant-federation.max-tenants
  [max_tenants: <int> | default = 0]

activity_tracker:
  # File where ongoing activities are stored. If empty, activity tracking is
  # disabled.
  # CLI flag: -activity-tracker.filepath
  [filepath: <string> | default = "./metrics-activity.log"]

  # (advanced) Max number of concurrent activities that can be tracked. Used to
  # size the file in advance. Additional activities are ignored.
  # CLI flag: -activity-tracker.max-entries
  [max_entries: <int> | default = 1024]

# (experimental) Include tenant ID in pprof labels for profiling. Currently only
# supported by the ingester. This can help debug performance issues for specific
# tenants.
# CLI flag: -include-tenant-id-in-profile-labels
[include_tenant_id_in_profile_labels: <boolean> | default = false]

vault:
  # (experimental) Enables fetching of keys and certificates from Vault
  # CLI flag: -vault.enabled
  [enabled: <boolean> | default = false]

  # (experimental) Location of the Vault server
  # CLI flag: -vault.url
  [url: <string> | default = ""]

  # (experimental) Location of secrets engine within Vault
  # CLI flag: -vault.mount-path
  [mount_path: <string> | default = ""]

  auth:
    # (experimental) Authentication type to use. Supported types are: approle,
    # kubernetes, userpass, token
    # CLI flag: -vault.auth.type
    [type: <string> | default = ""]

    approle:
      # (experimental) Role ID of the AppRole
      # CLI flag: -vault.auth.approle.role-id
      [role_id: <string> | default = ""]

      # (experimental) Secret ID issued against the AppRole
      # CLI flag: -vault.auth.approle.secret-id
      [secret_id: <string> | default = ""]

      # (experimental) Response wrapping token if the Secret ID is response
      # wrapped
      # CLI flag: -vault.auth.approle.wrapping-token
      [wrapping_token: <boolean> | default = false]

      # (experimental) Path if the Vault backend was mounted using a non-default
      # path
      # CLI flag: -vault.auth.approle.mount-path
      [mount_path: <string> | default = ""]

    kubernetes:
      # (experimental) The Kubernetes named role
      # CLI flag: -vault.auth.kubernetes.role-name
      [role_name: <string> | default = ""]

      # (experimental) The Service Account JWT
      # CLI flag: -vault.auth.kubernetes.service-account-token
      [service_account_token: <string> | default = ""]

      # (experimental) Path to where the Kubernetes service account token is
      # mounted. By default it lives at
      # /var/run/secrets/kubernetes.io/serviceaccount/token. Field will be used
      # if the service_account_token is not specified.
      # CLI flag: -vault.auth.kubernetes.service-account-token-path
      [service_account_token_path: <string> | default = ""]

      # (experimental) Path if the Vault backend was mounted using a non-default
      # path
      # CLI flag: -vault.auth.kubernetes.mount-path
      [mount_path: <string> | default = ""]

    userpass:
      # (experimental) The userpass auth method username
      # CLI flag: -vault.auth.userpass.username
      [username: <string> | default = ""]

      # (experimental) The userpass auth method password
      # CLI flag: -vault.auth.userpass.password
      [password: <string> | default = ""]

      # (experimental) Path if the Vault backend was mounted using a non-default
      # path
      # CLI flag: -vault.auth.userpass.mount-path
      [mount_path: <string> | default = ""]

    token:
      # (experimental) The token used to authenticate against Vault
      # CLI flag: -vault.auth.token
      [token: <string> | default = ""]

# The ruler block configures the ruler.
[ruler: <ruler>]

# The ruler_storage block configures the ruler storage backend.
[ruler_storage: <ruler_storage>]

# The alertmanager block configures the alertmanager.
[alertmanager: <alertmanager>]

# The alertmanager_storage block configures the alertmanager storage backend.
[alertmanager_storage: <alertmanager_storage>]

runtime_config:
  # (advanced) How often to check runtime config files.
  # CLI flag: -runtime-config.reload-period
  [period: <duration> | default = 10s]

  # Comma separated list of yaml files with the configuration that can be
  # updated at runtime. Runtime config files will be merged from left to right.
  # CLI flag: -runtime-config.file
  [file: <string> | default = ""]

# The memberlist block configures the Gossip memberlist.
[memberlist: <memberlist>]

# The query_scheduler block configures the query-scheduler.
[query_scheduler: <query_scheduler>]

usage_stats:
  # Enable anonymous usage reporting.
  # CLI flag: -usage-stats.enabled
  [enabled: <boolean> | default = true]

  # Installation mode. Supported values: custom, helm, jsonnet.
  # CLI flag: -usage-stats.installation-mode
  [installation_mode: <string> | default = "custom"]

overrides_exporter:
  ring:
    # Enable the ring used by override-exporters to deduplicate exported limit
    # metrics.
    # CLI flag: -overrides-exporter.ring.enabled
    [enabled: <boolean> | default = false]

    # The key-value store used to share the hash ring across multiple instances.
    kvstore:
      # Backend storage to use for the ring. Supported values are: consul, etcd,
      # inmemory, memberlist, multi.
      # CLI flag: -overrides-exporter.ring.store
      [store: <string> | default = "memberlist"]

      # (advanced) The prefix for the keys in the store. Should end with a /.
      # CLI flag: -overrides-exporter.ring.prefix
      [prefix: <string> | default = "collectors/"]

      # The consul block configures the consul client.
      # The CLI flags prefix for this block configuration is:
      # overrides-exporter.ring
      [consul: <consul>]

      # The etcd block configures the etcd client.
      # The CLI flags prefix for this block configuration is:
      # overrides-exporter.ring
      [etcd: <etcd>]

      multi:
        # (advanced) Primary backend storage used by multi-client.
        # CLI flag: -overrides-exporter.ring.multi.primary
        [primary: <string> | default = ""]

        # (advanced) Secondary backend storage used by multi-client.
        # CLI flag: -overrides-exporter.ring.multi.secondary
        [secondary: <string> | default = ""]

        # (advanced) Mirror writes to secondary store.
        # CLI flag: -overrides-exporter.ring.multi.mirror-enabled
        [mirror_enabled: <boolean> | default = false]

        # (advanced) Timeout for storing value to secondary store.
        # CLI flag: -overrides-exporter.ring.multi.mirror-timeout
        [mirror_timeout: <duration> | default = 2s]

    # (advanced) Period at which to heartbeat to the ring. 0 = disabled.
    # CLI flag: -overrides-exporter.ring.heartbeat-period
    [heartbeat_period: <duration> | default = 15s]

    # (advanced) The heartbeat timeout after which overrides-exporters are
    # considered unhealthy within the ring. 0 = never (timeout disabled).
    # CLI flag: -overrides-exporter.ring.heartbeat-timeout
    [heartbeat_timeout: <duration> | default = 1m]

    # (advanced) Instance ID to register in the ring.
    # CLI flag: -overrides-exporter.ring.instance-id
    [instance_id: <string> | default = "<hostname>"]

    # List of network interface names to look up when finding the instance IP
    # address.
    # CLI flag: -overrides-exporter.ring.instance-interface-names
    [instance_interface_names: <list of strings> | default = [<private network interfaces>]]

    # (advanced) Port to advertise in the ring (defaults to
    # -server.grpc-listen-port).
    # CLI flag: -overrides-exporter.ring.instance-port
    [instance_port: <int> | default = 0]

    # (advanced) IP address to advertise in the ring. Default is auto-detected.
    # CLI flag: -overrides-exporter.ring.instance-addr
    [instance_addr: <string> | default = ""]

    # (advanced) Enable using a IPv6 instance address. (default false)
    # CLI flag: -overrides-exporter.ring.instance-enable-ipv6
    [instance_enable_ipv6: <boolean> | default = false]

    # (advanced) Minimum time to wait for ring stability at startup, if set to
    # positive value. Set to 0 to disable.
    # CLI flag: -overrides-exporter.ring.wait-stability-min-duration
    [wait_stability_min_duration: <duration> | default = 0s]

    # (advanced) Maximum time to wait for ring stability at startup. If the
    # overrides-exporter ring keeps changing after this period of time, it will
    # start anyway.
    # CLI flag: -overrides-exporter.ring.wait-stability-max-duration
    [wait_stability_max_duration: <duration> | default = 5m]

    # (advanced) Number of consecutive timeout periods an unhealthy instance in
    # the ring is automatically removed after. Set to 0 to disable auto-forget.
    # CLI flag: -overrides-exporter.ring.auto-forget-unhealthy-periods
    [auto_forget_unhealthy_periods: <int> | default = 4]

  # Comma-separated list of metrics to include in the exporter. Metric names
  # must match yaml tags from the limits section of the configuration.
  # CLI flag: -overrides-exporter.enabled-metrics
  [enabled_metrics: <string> | default = "ingestion_rate,ingestion_burst_size,max_global_series_per_user,max_global_series_per_metric,max_global_exemplars_per_user,max_fetched_chunks_per_query,max_fetched_series_per_query,max_fetched_chunk_bytes_per_query,ruler_max_rules_per_rule_group,ruler_max_rule_groups_per_tenant"]

# The common block holds configurations that configure multiple components at a
# time.
[common: <common>]

# (experimental) Enables optimized marshaling of timeseries.
# CLI flag: -timeseries-unmarshal-caching-optimization-enabled
[timeseries_unmarshal_caching_optimization_enabled: <boolean> | default = true]

# (experimental) Specifies how often inactive cost attributions for received and
# discarded sample trackers are evicted from the counter, ensuring they do not
# contribute to the cost attribution cardinality per user limit. This setting
# does not apply to active series, which are managed separately.
# CLI flag: -cost-attribution.eviction-interval
[cost_attribution_eviction_interval: <duration> | default = 20m]

# (experimental) Defines a custom path for the registry. When specified, Mimir
# exposes cost attribution metrics through this custom path. If not specified,
# cost attribution metrics aren't exposed.
# CLI flag: -cost-attribution.registry-path
[cost_attribution_registry_path: <string> | default = ""]

# (experimental) Time interval at which the cost attribution cleanup process
# runs, ensuring inactive cost attribution entries are purged.
# CLI flag: -cost-attribution.cleanup-interval
[cost_attribution_cleanup_interval: <duration> | default = 3m]
```

### common

The `common` block holds configurations that configure multiple components at a time.

```yaml
storage:
  # Backend storage to use. Supported backends are: s3, gcs, azure, swift,
  # filesystem.
  # CLI flag: -common.storage.backend
  [backend: <string> | default = "filesystem"]

  # The s3_backend block configures the connection to Amazon S3 object storage
  # backend.
  # The CLI flags prefix for this block configuration is: common.storage
  [s3: <s3_storage_backend>]

  # The gcs_backend block configures the connection to Google Cloud Storage
  # object storage backend.
  # The CLI flags prefix for this block configuration is: common.storage
  [gcs: <gcs_storage_backend>]

  # The azure_storage_backend block configures the connection to Azure object
  # storage backend.
  # The CLI flags prefix for this block configuration is: common.storage
  [azure: <azure_storage_backend>]

  # The swift_storage_backend block configures the connection to OpenStack
  # Object Storage (Swift) object storage backend.
  # The CLI flags prefix for this block configuration is: common.storage
  [swift: <swift_storage_backend>]

  # The filesystem_storage_backend block configures the usage of local file
  # system as object storage backend.
  # The CLI flags prefix for this block configuration is: common.storage
  [filesystem: <filesystem_storage_backend>]

client_cluster_validation:
  # (experimental) Primary cluster validation label.
  # CLI flag: -common.client-cluster-validation.label
  [label: <string> | default = ""]
```

### server

The `server` block configures the HTTP and gRPC server of the launched service(s).

```yaml
# (advanced) HTTP server listen network, default tcp
# CLI flag: -server.http-listen-network
[http_listen_network: <string> | default = "tcp"]

# HTTP server listen address.
# CLI flag: -server.http-listen-address
[http_listen_address: <string> | default = ""]

# HTTP server listen port.
# CLI flag: -server.http-listen-port
[http_listen_port: <int> | default = 8080]

# (advanced) Maximum number of simultaneous http connections, <=0 to disable
# CLI flag: -server.http-conn-limit
[http_listen_conn_limit: <int> | default = 0]

# (advanced) gRPC server listen network
# CLI flag: -server.grpc-listen-network
[grpc_listen_network: <string> | default = "tcp"]

# gRPC server listen address.
# CLI flag: -server.grpc-listen-address
[grpc_listen_address: <string> | default = ""]

# gRPC server listen port.
# CLI flag: -server.grpc-listen-port
[grpc_listen_port: <int> | default = 9095]

# (advanced) Maximum number of simultaneous grpc connections, <=0 to disable
# CLI flag: -server.grpc-conn-limit
[grpc_listen_conn_limit: <int> | default = 0]

# If true, the max streams by connection gauge will be collected.
# CLI flag: -server.grpc-collect-max-streams-by-conn
[grpc_collect_max_streams_by_conn: <boolean> | default = true]

# (experimental) Enables PROXY protocol.
# CLI flag: -server.proxy-protocol-enabled
[proxy_protocol_enabled: <boolean> | default = false]

# Comma-separated list of cipher suites to use. If blank, the default Go cipher
# suites is used.
# CLI flag: -server.tls-cipher-suites
[tls_cipher_suites: <string> | default = ""]

# Minimum TLS version to use. Allowed values: VersionTLS10, VersionTLS11,
# VersionTLS12, VersionTLS13. If blank, the Go TLS minimum version is used.
# CLI flag: -server.tls-min-version
[tls_min_version: <string> | default = ""]

http_tls_config:
  # Server TLS certificate. This configuration parameter is YAML only.
  [cert: <string> | default = ""]

  # Server TLS key. This configuration parameter is YAML only.
  [key: <string> | default = ""]

  # Root certificate authority used to verify client certificates. This
  # configuration parameter is YAML only.
  [client_ca: <string> | default = ""]

  # (advanced) HTTP server cert path.
  # CLI flag: -server.http-tls-cert-path
  [cert_file: <string> | default = ""]

  # (advanced) HTTP server key path.
  # CLI flag: -server.http-tls-key-path
  [key_file: <string> | default = ""]

  # (advanced) HTTP TLS Client Auth type.
  # CLI flag: -server.http-tls-client-auth
  [client_auth_type: <string> | default = ""]

  # (advanced) HTTP TLS Client CA path.
  # CLI flag: -server.http-tls-ca-path
  [client_ca_file: <string> | default = ""]

grpc_tls_config:
  # Server TLS certificate. This configuration parameter is YAML only.
  [cert: <string> | default = ""]

  # Server TLS key. This configuration parameter is YAML only.
  [key: <string> | default = ""]

  # Root certificate authority used to verify client certificates. This
  # configuration parameter is YAML only.
  [client_ca: <string> | default = ""]

  # (advanced) GRPC TLS server cert path.
  # CLI flag: -server.grpc-tls-cert-path
  [cert_file: <string> | default = ""]

  # (advanced) GRPC TLS server key path.
  # CLI flag: -server.grpc-tls-key-path
  [key_file: <string> | default = ""]

  # (advanced) GRPC TLS Client Auth type.
  # CLI flag: -server.grpc-tls-client-auth
  [client_auth_type: <string> | default = ""]

  # (advanced) GRPC TLS Client CA path.
  # CLI flag: -server.grpc-tls-ca-path
  [client_ca_file: <string> | default = ""]

# (advanced) Register the intrumentation handlers (/metrics etc).
# CLI flag: -server.register-instrumentation
[register_instrumentation: <boolean> | default = true]

# If set to true, gRPC statuses will be reported in instrumentation labels with
# their string representations. Otherwise, they will be reported as "error".
# CLI flag: -server.report-grpc-codes-in-instrumentation-label-enabled
[report_grpc_codes_in_instrumentation_label_enabled: <boolean> | default = true]

# (advanced) Timeout for graceful shutdowns
# CLI flag: -server.graceful-shutdown-timeout
[graceful_shutdown_timeout: <duration> | default = 30s]

# (advanced) Read timeout for entire HTTP request, including headers and body.
# CLI flag: -server.http-read-timeout
[http_server_read_timeout: <duration> | default = 30s]

# Read timeout for HTTP request headers. If set to 0, value of
# -server.http-read-timeout is used.
# CLI flag: -server.http-read-header-timeout
[http_server_read_header_timeout: <duration> | default = 0s]

# (advanced) Write timeout for HTTP server
# CLI flag: -server.http-write-timeout
[http_server_write_timeout: <duration> | default = 2m]

# (advanced) Idle timeout for HTTP server
# CLI flag: -server.http-idle-timeout
[http_server_idle_timeout: <duration> | default = 2m]

# Log closed connections that did not receive any response, most likely because
# client didn't send any request within timeout.
# CLI flag: -server.http-log-closed-connections-without-response-enabled
[http_log_closed_connections_without_response_enabled: <boolean> | default = false]

# (advanced) Limit on the size of a gRPC message this server can receive
# (bytes).
# CLI flag: -server.grpc-max-recv-msg-size-bytes
[grpc_server_max_recv_msg_size: <int> | default = 104857600]

# (advanced) Limit on the size of a gRPC message this server can send (bytes).
# CLI flag: -server.grpc-max-send-msg-size-bytes
[grpc_server_max_send_msg_size: <int> | default = 104857600]

# (advanced) Limit on the number of concurrent streams for gRPC calls per client
# connection (0 = unlimited)
# CLI flag: -server.grpc-max-concurrent-streams
[grpc_server_max_concurrent_streams: <int> | default = 100]

# (advanced) The duration after which an idle connection should be closed.
# Default: infinity
# CLI flag: -server.grpc.keepalive.max-connection-idle
[grpc_server_max_connection_idle: <duration> | default = 2562047h47m16.854775807s]

# (advanced) The duration for the maximum amount of time a connection may exist
# before it will be closed. Default: infinity
# CLI flag: -server.grpc.keepalive.max-connection-age
[grpc_server_max_connection_age: <duration> | default = 2562047h47m16.854775807s]

# (advanced) An additive period after max-connection-age after which the
# connection will be forcibly closed. Default: infinity
# CLI flag: -server.grpc.keepalive.max-connection-age-grace
[grpc_server_max_connection_age_grace: <duration> | default = 2562047h47m16.854775807s]

# (advanced) Duration after which a keepalive probe is sent in case of no
# activity over the connection., Default: 2h
# CLI flag: -server.grpc.keepalive.time
[grpc_server_keepalive_time: <duration> | default = 2h]

# (advanced) After having pinged for keepalive check, the duration after which
# an idle connection should be closed, Default: 20s
# CLI flag: -server.grpc.keepalive.timeout
[grpc_server_keepalive_timeout: <duration> | default = 20s]

# (advanced) Minimum amount of time a client should wait before sending a
# keepalive ping. If client sends keepalive ping more often, server will send
# GOAWAY and close the connection.
# CLI flag: -server.grpc.keepalive.min-time-between-pings
[grpc_server_min_time_between_pings: <duration> | default = 10s]

# (advanced) If true, server allows keepalive pings even when there are no
# active streams(RPCs). If false, and client sends ping when there are no active
# streams, server will send GOAWAY and close the connection.
# CLI flag: -server.grpc.keepalive.ping-without-stream-allowed
[grpc_server_ping_without_stream_allowed: <boolean> | default = true]

# (advanced) If non-zero, configures the amount of GRPC server workers used to
# serve the requests.
# CLI flag: -server.grpc.num-workers
[grpc_server_num_workers: <int> | default = 100]

# Output log messages in the given format. Valid formats: [logfmt, json]
# CLI flag: -log.format
[log_format: <string> | default = "logfmt"]

# Only log messages with the given severity or above. Valid levels: [debug,
# info, warn, error]
# CLI flag: -log.level
[log_level: <string> | default = "info"]

# (advanced) Optionally log the source IPs.
# CLI flag: -server.log-source-ips-enabled
[log_source_ips_enabled: <boolean> | default = false]

# Log all source IPs instead of only the originating one. Only used if
# server.log-source-ips-enabled is true
# CLI flag: -server.log-source-ips-full
[log_source_ips_full: <boolean> | default = false]

# (advanced) Header field storing the source IPs. Only used if
# server.log-source-ips-enabled is true. If not set the default Forwarded,
# X-Real-IP and X-Forwarded-For headers are used
# CLI flag: -server.log-source-ips-header
[log_source_ips_header: <string> | default = ""]

# (advanced) Regex for matching the source IPs. Only used if
# server.log-source-ips-enabled is true. If not set the default Forwarded,
# X-Real-IP and X-Forwarded-For headers are used
# CLI flag: -server.log-source-ips-regex
[log_source_ips_regex: <string> | default = ""]

# Optionally log request headers.
# CLI flag: -server.log-request-headers
[log_request_headers: <boolean> | default = false]

# (advanced) Optionally log requests at info level instead of debug level.
# Applies to request headers as well if server.log-request-headers is enabled.
# CLI flag: -server.log-request-at-info-level-enabled
[log_request_at_info_level_enabled: <boolean> | default = false]

# Comma separated list of headers to exclude from loggin. Only used if
# server.log-request-headers is true.
# CLI flag: -server.log-request-headers-exclude-list
[log_request_exclude_headers_list: <string> | default = ""]

# Optionally add request headers to tracing spans.
# CLI flag: -server.trace-request-headers
[trace_request_headers: <boolean> | default = false]

# Comma separated list of headers to exclude from tracing spans. Only used if
# server.trace-request-headers is true. The following headers are always
# excluded: Authorization, Cookie, X-Access-Token, X-Csrf-Token, X-Grafana-Id.
# CLI flag: -server.trace-request-headers-exclude-list
[trace_request_exclude_headers_list: <string> | default = ""]

# (advanced) Base path to serve all API routes from (e.g. /v1/)
# CLI flag: -server.path-prefix
[http_path_prefix: <string> | default = ""]

cluster_validation:
  # (experimental) Primary cluster validation label.
  # CLI flag: -server.cluster-validation.label
  [label: <string> | default = ""]

  # (experimental) Comma-separated list of additional cluster validation labels
  # that the server will accept from incoming requests.
  # CLI flag: -server.cluster-validation.additional-labels
  [additional_labels: <string> | default = ""]

  grpc:
    # (experimental) When enabled, cluster label validation is executed:
    # configured cluster validation label is compared with the cluster
    # validation label received through the requests.
    # CLI flag: -server.cluster-validation.grpc.enabled
    [enabled: <boolean> | default = false]

    # (experimental) When enabled, soft cluster label validation is executed.
    # Can be enabled only together with server.cluster-validation.grpc.enabled
    # CLI flag: -server.cluster-validation.grpc.soft-validation
    [soft_validation: <boolean> | default = false]

  http:
    # (experimental) When enabled, cluster label validation is executed:
    # configured cluster validation label is compared with the cluster
    # validation label received through the requests.
    # CLI flag: -server.cluster-validation.http.enabled
    [enabled: <boolean> | default = false]

    # (experimental) When enabled, soft cluster label validation is executed.
    # Can be enabled only together with server.cluster-validation.http.enabled
    # CLI flag: -server.cluster-validation.http.soft-validation
    [soft_validation: <boolean> | default = false]

    # (experimental) Comma-separated list of url paths that are excluded from
    # the cluster validation check.
    # CLI flag: -server.cluster-validation.http.excluded-paths
    [excluded_paths: <string> | default = ""]

    # (experimental) Comma-separated list of user agents that are excluded from
    # the cluster validation check.
    # CLI flag: -server.cluster-validation.http.excluded-user-agents
    [excluded_user_agents: <string> | default = ""]
```

### distributor

The `distributor` block configures the distributor.

```yaml
pool:
  # (advanced) How frequently to clean up clients for ingesters that have gone
  # away.
  # CLI flag: -distributor.client-cleanup-period
  [client_cleanup_period: <duration> | default = 15s]

  # (advanced) Run a health check on each ingester client during periodic
  # cleanup.
  # CLI flag: -distributor.health-check-ingesters
  [health_check_ingesters: <boolean> | default = true]

retry_after_header:
  # (advanced) Enables inclusion of the Retry-After header in the response: true
  # includes it for client retry guidance, false omits it.
  # CLI flag: -distributor.retry-after-header.enabled
  [enabled: <boolean> | default = true]

  # (advanced) Minimum duration of the Retry-After HTTP header in responses to
  # 429/5xx errors. Must be greater than or equal to 1s. Backoff is calculated
  # as MinBackoff*2^(RetryAttempt-1) seconds with random jitter of 50% in either
  # direction. RetryAttempt is the value of the Retry-Attempt HTTP header.
  # CLI flag: -distributor.retry-after-header.min-backoff
  [min_backoff: <duration> | default = 6s]

  # (advanced) Minimum duration of the Retry-After HTTP header in responses to
  # 429/5xx errors. Must be greater than or equal to 1s. Backoff is calculated
  # as MinBackoff*2^(RetryAttempt-1) seconds with random jitter of 50% in either
  # direction. RetryAttempt is the value of the Retry-Attempt HTTP header.
  # CLI flag: -distributor.retry-after-header.max-backoff
  [max_backoff: <duration> | default = 1m36s]

ha_tracker:
  # Enable the distributors HA tracker so that it can accept samples from
  # Prometheus HA replicas gracefully (requires labels).
  # CLI flag: -distributor.ha-tracker.enable
  [enable_ha_tracker: <boolean> | default = false]

  # Enable the elected_replica_status metric, which shows the current elected
  # replica. It is disabled by default due to the possible high cardinality of
  # the metric.
  # CLI flag: -distributor.ha-tracker.enable-elected-replica-metric
  [enable_elected_replica_metric: <boolean> | default = false]

  # Backend storage to use for the HA tracker. Supported values are: consul,
  # etcd, inmemory, memberlist, multi. Memberlist is recommended.
  kvstore:
    # Backend storage to use for the ring. Supported values are: consul, etcd,
    # inmemory, memberlist, multi.
    # CLI flag: -distributor.ha-tracker.store
    [store: <string> | default = "memberlist"]

    # (advanced) The prefix for the keys in the store. Should end with a /.
    # CLI flag: -distributor.ha-tracker.prefix
    [prefix: <string> | default = "ha-tracker/"]

    # The consul block configures the consul client.
    # The CLI flags prefix for this block configuration is:
    # distributor.ha-tracker
    [consul: <consul>]

    # The etcd block configures the etcd client.
    # The CLI flags prefix for this block configuration is:
    # distributor.ha-tracker
    [etcd: <etcd>]

    multi:
      # (advanced) Primary backend storage used by multi-client.
      # CLI flag: -distributor.ha-tracker.multi.primary
      [primary: <string> | default = ""]

      # (advanced) Secondary backend storage used by multi-client.
      # CLI flag: -distributor.ha-tracker.multi.secondary
      [secondary: <string> | default = ""]

      # (advanced) Mirror writes to secondary store.
      # CLI flag: -distributor.ha-tracker.multi.mirror-enabled
      [mirror_enabled: <boolean> | default = false]

      # (advanced) Timeout for storing value to secondary store.
      # CLI flag: -distributor.ha-tracker.multi.mirror-timeout
      [mirror_timeout: <duration> | default = 2s]

# (advanced) Max message size in bytes that the distributors will accept for
# incoming push requests to the remote write API. If exceeded, the request will
# be rejected.
# CLI flag: -distributor.max-recv-msg-size
[max_recv_msg_size: <int> | default = 104857600]

# (experimental) Maximum OTLP request size in bytes that the distributors
# accept. Requests exceeding this limit are rejected.
# CLI flag: -distributor.max-otlp-request-size
[max_otlp_request_size: <int> | default = 104857600]

# (experimental) Max size of the pooled buffers used for marshaling write
# requests. If 0, no max size is enforced.
# CLI flag: -distributor.max-request-pool-buffer-size
[max_request_pool_buffer_size: <int> | default = 0]

# (advanced) Timeout for downstream ingesters.
# CLI flag: -distributor.remote-timeout
[remote_timeout: <duration> | default = 2s]

ring:
  # The key-value store used to share the hash ring across multiple instances.
  kvstore:
    # Backend storage to use for the ring. Supported values are: consul, etcd,
    # inmemory, memberlist, multi.
    # CLI flag: -distributor.ring.store
    [store: <string> | default = "memberlist"]

    # (advanced) The prefix for the keys in the store. Should end with a /.
    # CLI flag: -distributor.ring.prefix
    [prefix: <string> | default = "collectors/"]

    # The consul block configures the consul client.
    # The CLI flags prefix for this block configuration is: distributor.ring
    [consul: <consul>]

    # The etcd block configures the etcd client.
    # The CLI flags prefix for this block configuration is: distributor.ring
    [etcd: <etcd>]

    multi:
      # (advanced) Primary backend storage used by multi-client.
      # CLI flag: -distributor.ring.multi.primary
      [primary: <string> | default = ""]

      # (advanced) Secondary backend storage used by multi-client.
      # CLI flag: -distributor.ring.multi.secondary
      [secondary: <string> | default = ""]

      # (advanced) Mirror writes to secondary store.
      # CLI flag: -distributor.ring.multi.mirror-enabled
      [mirror_enabled: <boolean> | default = false]

      # (advanced) Timeout for storing value to secondary store.
      # CLI flag: -distributor.ring.multi.mirror-timeout
      [mirror_timeout: <duration> | default = 2s]

  # (advanced) Period at which to heartbeat to the ring. 0 = disabled.
  # CLI flag: -distributor.ring.heartbeat-period
  [heartbeat_period: <duration> | default = 15s]

  # (advanced) The heartbeat timeout after which distributors are considered
  # unhealthy within the ring. 0 = never (timeout disabled).
  # CLI flag: -distributor.ring.heartbeat-timeout
  [heartbeat_timeout: <duration> | default = 1m]

  # (advanced) Instance ID to register in the ring.
  # CLI flag: -distributor.ring.instance-id
  [instance_id: <string> | default = "<hostname>"]

  # List of network interface names to look up when finding the instance IP
  # address.
  # CLI flag: -distributor.ring.instance-interface-names
  [instance_interface_names: <list of strings> | default = [<private network interfaces>]]

  # (advanced) Port to advertise in the ring (defaults to
  # -server.grpc-listen-port).
  # CLI flag: -distributor.ring.instance-port
  [instance_port: <int> | default = 0]

  # (advanced) IP address to advertise in the ring. Default is auto-detected.
  # CLI flag: -distributor.ring.instance-addr
  [instance_addr: <string> | default = ""]

  # (advanced) Enable using a IPv6 instance address. (default false)
  # CLI flag: -distributor.ring.instance-enable-ipv6
  [instance_enable_ipv6: <boolean> | default = false]

  # (advanced) Number of consecutive timeout periods an unhealthy instance in
  # the ring is automatically removed after. Set to 0 to disable auto-forget.
  # CLI flag: -distributor.ring.auto-forget-unhealthy-periods
  [auto_forget_unhealthy_periods: <int> | default = 10]

instance_limits:
  # (advanced) Max ingestion rate (samples/sec) that this distributor will
  # accept. This limit is per-distributor, not per-tenant. Additional push
  # requests will be rejected. Current ingestion rate is computed as
  # exponentially weighted moving average, updated every second. 0 = unlimited.
  # CLI flag: -distributor.instance-limits.max-ingestion-rate
  [max_ingestion_rate: <float> | default = 0]

  # (advanced) Max inflight push requests that this distributor can handle. This
  # limit is per-distributor, not per-tenant. Additional requests will be
  # rejected. 0 = unlimited.
  # CLI flag: -distributor.instance-limits.max-inflight-push-requests
  [max_inflight_push_requests: <int> | default = 2000]

  # (advanced) The sum of the request sizes in bytes of inflight push requests
  # that this distributor can handle. This limit is per-distributor, not
  # per-tenant. Additional requests will be rejected. 0 = unlimited.
  # CLI flag: -distributor.instance-limits.max-inflight-push-requests-bytes
  [max_inflight_push_requests_bytes: <int> | default = 0]

# (experimental) Enable pooling of buffers used for marshaling write requests.
# CLI flag: -distributor.write-requests-buffer-pooling-enabled
[write_requests_buffer_pooling_enabled: <boolean> | default = true]

# (advanced) Number of pre-allocated workers used to forward push requests to
# the ingesters. If 0, no workers will be used and a new goroutine will be
# spawned for each ingester push request. If not enough workers available, new
# goroutine will be spawned. (Note: this is a performance optimization, not a
# limiting feature.)
# CLI flag: -distributor.reusable-ingester-push-workers
[reusable_ingester_push_workers: <int> | default = 2000]

reactive_limiter:
  # (experimental) Enable reactive limiting when making requests to a service
  # CLI flag: -distributor.reactive-limiter.enabled
  [enabled: <boolean> | default = false]

  # (experimental) Minimum inflight requests limit
  # CLI flag: -distributor.reactive-limiter.min-limit
  [min_limit: <int> | default = 2]

  # (experimental) Maximum inflight requests limit
  # CLI flag: -distributor.reactive-limiter.max-limit
  [max_limit: <int> | default = 200]

  # (experimental) Initial inflight requests limit
  # CLI flag: -distributor.reactive-limiter.initial-limit
  [initial_limit: <int> | default = 20]

  # (experimental) The maximum inflight limit as a multiple of current inflight
  # requests
  # CLI flag: -distributor.reactive-limiter.max-limit-factor
  [max_limit_factor: <float> | default = 5]

  # (experimental) Minimum duration of the window that is used to collect recent
  # response time samples
  # CLI flag: -distributor.reactive-limiter.recent-window-min-duration
  [recent_window_min_duration: <duration> | default = 1s]

  # (experimental) Maximum duration of the window that is used to collect recent
  # response time samples
  # CLI flag: -distributor.reactive-limiter.recent-window-max-duration
  [recent_window_max_duration: <duration> | default = 30s]

  # (experimental) Minimum number of samples that must be recorded in the recent
  # window before updating the limit
  # CLI flag: -distributor.reactive-limiter.recent-window-min-samples
  [recent_window_min_samples: <int> | default = 50]

  # (experimental) The quantile of recent recorded response times to consider
  # when adjusting the concurrency limit
  # CLI flag: -distributor.reactive-limiter.recent-quantile
  [recent_quantile: <float> | default = 0.9]

  # (experimental) The average age of baseline samples aggregated recent samples
  # are added to
  # CLI flag: -distributor.reactive-limiter.baseline-window-age
  [baseline_window_age: <int> | default = 10]

  # (experimental) How many recent limit and inflight time measurements are
  # stored to detect whether increases in limits correlate with increases in
  # inflight times
  # CLI flag: -distributor.reactive-limiter.correlation-window
  [correlation_window: <int> | default = 50]

  # (experimental) The number of allowed queued requests, as a multiple of
  # current inflight requests, after which rejections start
  # CLI flag: -distributor.reactive-limiter.initial-rejection-factor
  [initial_rejection_factor: <float> | default = 1]

  # (experimental) The number of allowed queued requests, as a multiple of
  # current inflight requests, after which all requests are rejected
  # CLI flag: -distributor.reactive-limiter.max-rejection-factor
  [max_rejection_factor: <float> | default = 2]
```

### ingester

The `ingester` block configures the ingester.

```yaml
ring:
  # The key-value store used to share the hash ring across multiple instances.
  # This option needs be set on ingesters, distributors, queriers, and rulers
  # when running in microservices mode.
  kvstore:
    # Backend storage to use for the ring. Supported values are: consul, etcd,
    # inmemory, memberlist, multi.
    # CLI flag: -ingester.ring.store
    [store: <string> | default = "memberlist"]

    # (advanced) The prefix for the keys in the store. Should end with a /.
    # CLI flag: -ingester.ring.prefix
    [prefix: <string> | default = "collectors/"]

    # The consul block configures the consul client.
    # The CLI flags prefix for this block configuration is: ingester.ring
    [consul: <consul>]

    # The etcd block configures the etcd client.
    # The CLI flags prefix for this block configuration is: ingester.ring
    [etcd: <etcd>]

    multi:
      # (advanced) Primary backend storage used by multi-client.
      # CLI flag: -ingester.ring.multi.primary
      [primary: <string> | default = ""]

      # (advanced) Secondary backend storage used by multi-client.
      # CLI flag: -ingester.ring.multi.secondary
      [secondary: <string> | default = ""]

      # (advanced) Mirror writes to secondary store.
      # CLI flag: -ingester.ring.multi.mirror-enabled
      [mirror_enabled: <boolean> | default = false]

      # (advanced) Timeout for storing value to secondary store.
      # CLI flag: -ingester.ring.multi.mirror-timeout
      [mirror_timeout: <duration> | default = 2s]

  # (advanced) Period at which to heartbeat to the ring. 0 = disabled.
  # CLI flag: -ingester.ring.heartbeat-period
  [heartbeat_period: <duration> | default = 15s]

  # (advanced) The heartbeat timeout after which ingesters are skipped for
  # reads/writes. 0 = never (timeout disabled). This option needs be set on
  # ingesters, distributors, queriers, and rulers when running in microservices
  # mode.
  # CLI flag: -ingester.ring.heartbeat-timeout
  [heartbeat_timeout: <duration> | default = 1m]

  # Number of ingesters that each time series is replicated to. This option
  # needs be set on ingesters, distributors, queriers, and rulers when running
  # in microservices mode.
  # CLI flag: -ingester.ring.replication-factor
  [replication_factor: <int> | default = 3]

  # True to enable the zone-awareness and replicate ingested samples across
  # different availability zones. This option needs be set on ingesters,
  # distributors, queriers, and rulers when running in microservices mode.
  # CLI flag: -ingester.ring.zone-awareness-enabled
  [zone_awareness_enabled: <boolean> | default = false]

  # (advanced) Comma-separated list of zones to exclude from the ring. Instances
  # in excluded zones will be filtered out from the ring. This option needs be
  # set on ingesters, distributors, queriers, and rulers when running in
  # microservices mode.
  # CLI flag: -ingester.ring.excluded-zones
  [excluded_zones: <string> | default = ""]

  # File path where tokens are stored. If empty, tokens are not stored at
  # shutdown and restored at startup. Must be empty if
  # -ingester.ring.token-generation-strategy is set to "spread-minimizing".
  # CLI flag: -ingester.ring.tokens-file-path
  [tokens_file_path: <string> | default = ""]

  # (advanced) Number of tokens for each ingester.
  # CLI flag: -ingester.ring.num-tokens
  [num_tokens: <int> | default = 128]

  # (advanced) Instance ID to register in the ring.
  # CLI flag: -ingester.ring.instance-id
  [instance_id: <string> | default = "<hostname>"]

  # (advanced) List of network interface names to look up when finding the
  # instance IP address.
  # CLI flag: -ingester.ring.instance-interface-names
  [instance_interface_names: <list of strings> | default = [<private network interfaces>]]

  # (advanced) Port to advertise in the ring (defaults to
  # -server.grpc-listen-port).
  # CLI flag: -ingester.ring.instance-port
  [instance_port: <int> | default = 0]

  # (advanced) IP address to advertise in the ring. Default is auto-detected.
  # CLI flag: -ingester.ring.instance-addr
  [instance_addr: <string> | default = ""]

  # (advanced) Enable using a IPv6 instance address. (default false)
  # CLI flag: -ingester.ring.instance-enable-ipv6
  [instance_enable_ipv6: <boolean> | default = false]

  # (advanced) The availability zone where this instance is running.
  # CLI flag: -ingester.ring.instance-availability-zone
  [instance_availability_zone: <string> | default = ""]

  # (advanced) Unregister from the ring upon clean shutdown. It can be useful to
  # disable for rolling restarts with consistent naming.
  # CLI flag: -ingester.ring.unregister-on-shutdown
  [unregister_on_shutdown: <boolean> | default = true]

  # (advanced) Observe tokens after generating to resolve collisions. Useful
  # when using gossiping ring.
  # CLI flag: -ingester.ring.observe-period
  [observe_period: <duration> | default = 0s]

  # (advanced) Minimum duration to wait after the internal readiness checks have
  # passed but before succeeding the readiness endpoint. This is used to
  # slowdown deployment controllers (eg. Kubernetes) after an instance is ready
  # and before they proceed with a rolling update, to give the rest of the
  # cluster instances enough time to receive ring updates.
  # CLI flag: -ingester.ring.min-ready-duration
  [min_ready_duration: <duration> | default = 15s]

  # (advanced) Duration to sleep for before exiting, to ensure metrics are
  # scraped.
  # CLI flag: -ingester.ring.final-sleep
  [final_sleep: <duration> | default = 0s]

  # (advanced) Specifies the strategy used for generating tokens for ingesters.
  # Supported values are: random,spread-minimizing.
  # CLI flag: -ingester.ring.token-generation-strategy
  [token_generation_strategy: <string> | default = "random"]

  # (advanced) True to allow this ingester registering tokens in the ring only
  # after all previous ingesters (with ID lower than the current one) have
  # already been registered. This configuration option is supported only when
  # the token generation strategy is set to "spread-minimizing".
  # CLI flag: -ingester.ring.spread-minimizing-join-ring-in-order
  [spread_minimizing_join_ring_in_order: <boolean> | default = false]

  # (advanced) Comma-separated list of zones in which spread minimizing strategy
  # is used for token generation. This value must include all zones in which
  # ingesters are deployed, and must not change over time. This configuration is
  # used only when "token-generation-strategy" is set to "spread-minimizing".
  # CLI flag: -ingester.ring.spread-minimizing-zones
  [spread_minimizing_zones: <string> | default = ""]

partition_ring:
  # The key-value store used to share the hash ring across multiple instances.
  # This option needs be set on ingesters, distributors, queriers, and rulers
  # when running in microservices mode.
  kvstore:
    # Backend storage to use for the ring. Supported values are: consul, etcd,
    # inmemory, memberlist, multi.
    # CLI flag: -ingester.partition-ring.store
    [store: <string> | default = "memberlist"]

    # (advanced) The prefix for the keys in the store. Should end with a /.
    # CLI flag: -ingester.partition-ring.prefix
    [prefix: <string> | default = "collectors/"]

    # The consul block configures the consul client.
    # The CLI flags prefix for this block configuration is:
    # ingester.partition-ring
    [consul: <consul>]

    # The etcd block configures the etcd client.
    # The CLI flags prefix for this block configuration is:
    # ingester.partition-ring
    [etcd: <etcd>]

    multi:
      # (advanced) Primary backend storage used by multi-client.
      # CLI flag: -ingester.partition-ring.multi.primary
      [primary: <string> | default = ""]

      # (advanced) Secondary backend storage used by multi-client.
      # CLI flag: -ingester.partition-ring.multi.secondary
      [secondary: <string> | default = ""]

      # (advanced) Mirror writes to secondary store.
      # CLI flag: -ingester.partition-ring.multi.mirror-enabled
      [mirror_enabled: <boolean> | default = false]

      # (advanced) Timeout for storing value to secondary store.
      # CLI flag: -ingester.partition-ring.multi.mirror-timeout
      [mirror_timeout: <duration> | default = 2s]

  # Minimum number of owners to wait before a PENDING partition gets switched to
  # ACTIVE.
  # CLI flag: -ingester.partition-ring.min-partition-owners-count
  [min_partition_owners_count: <int> | default = 1]

  # How long the minimum number of owners are enforced before a PENDING
  # partition gets switched to ACTIVE.
  # CLI flag: -ingester.partition-ring.min-partition-owners-duration
  [min_partition_owners_duration: <duration> | default = 10s]

  # How long to wait before an INACTIVE partition is eligible for deletion. The
  # partition is deleted only if it has been in INACTIVE state for at least the
  # configured duration and it has no owners registered. A value of 0 disables
  # partitions deletion.
  # CLI flag: -ingester.partition-ring.delete-inactive-partition-after
  [delete_inactive_partition_after: <duration> | default = 13h]

# (advanced) Period at which metadata we have not seen will remain in memory
# before being deleted.
# CLI flag: -ingester.metadata-retain-period
[metadata_retain_period: <duration> | default = 10m]

# (advanced) Period with which to update the per-tenant ingestion rates.
# CLI flag: -ingester.rate-update-period
[rate_update_period: <duration> | default = 15s]

# (advanced) Enable tracking of active series and export them as metrics.
# CLI flag: -ingester.active-series-metrics-enabled
[active_series_metrics_enabled: <boolean> | default = true]

# (advanced) How often to update active series metrics.
# CLI flag: -ingester.active-series-metrics-update-period
[active_series_metrics_update_period: <duration> | default = 1m]

# (advanced) After what time a series is considered to be inactive.
# CLI flag: -ingester.active-series-metrics-idle-timeout
[active_series_metrics_idle_timeout: <duration> | default = 20m]

# (experimental) Period with which to update the per-tenant TSDB configuration.
# CLI flag: -ingester.tsdb-config-update-period
[tsdb_config_update_period: <duration> | default = 15s]

instance_limits:
  # (advanced) Max ingestion rate (samples/sec) that ingester will accept. This
  # limit is per-ingester, not per-tenant. Additional push requests will be
  # rejected. Current ingestion rate is computed as exponentially weighted
  # moving average, updated every second. 0 = unlimited.
  # CLI flag: -ingester.instance-limits.max-ingestion-rate
  [max_ingestion_rate: <float> | default = 0]

  # (advanced) Max tenants that this ingester can hold. Requests from additional
  # tenants will be rejected. 0 = unlimited.
  # CLI flag: -ingester.instance-limits.max-tenants
  [max_tenants: <int> | default = 0]

  # (advanced) Max series that this ingester can hold (across all tenants).
  # Requests to create additional series will be rejected. 0 = unlimited.
  # CLI flag: -ingester.instance-limits.max-series
  [max_series: <int> | default = 0]

  # (advanced) Max inflight push requests that this ingester can handle (across
  # all tenants). Additional requests will be rejected. 0 = unlimited.
  # CLI flag: -ingester.instance-limits.max-inflight-push-requests
  [max_inflight_push_requests: <int> | default = 30000]

  # (advanced) The sum of the request sizes in bytes of inflight push requests
  # that this ingester can handle. This limit is per-ingester, not per-tenant.
  # Additional requests will be rejected. 0 = unlimited.
  # CLI flag: -ingester.instance-limits.max-inflight-push-requests-bytes
  [max_inflight_push_requests_bytes: <int> | default = 0]

# (advanced) Comma-separated list of metric names, for which the
# -ingester.max-global-series-per-metric limit will be ignored. Does not affect
# the -ingester.max-global-series-per-user limit.
# CLI flag: -ingester.ignore-series-limit-for-metric-names
[ignore_series_limit_for_metric_names: <string> | default = ""]

# (experimental) CPU utilization limit, as CPU cores, for CPU/memory utilization
# based read request limiting. Use 0 to disable it.
# CLI flag: -ingester.read-path-cpu-utilization-limit
[read_path_cpu_utilization_limit: <float> | default = 0]

# (experimental) Memory limit, in bytes, for CPU/memory utilization based read
# request limiting. Use 0 to disable it.
# CLI flag: -ingester.read-path-memory-utilization-limit
[read_path_memory_utilization_limit: <int> | default = 0]

# (advanced) Each error will be logged once in this many times. Use 0 to log all
# of them.
# CLI flag: -ingester.error-sample-rate
[error_sample_rate: <int> | default = 10]

# (experimental) When enabled, only series currently owned by ingester according
# to the ring are used when checking user per-tenant series limit.
# CLI flag: -ingester.use-ingester-owned-series-for-limits
[use_ingester_owned_series_for_limits: <boolean> | default = false]

# (experimental) This option enables tracking of ingester-owned series based on
# ring state, even if -ingester.use-ingester-owned-series-for-limits is
# disabled.
# CLI flag: -ingester.track-ingester-owned-series
[track_ingester_owned_series: <boolean> | default = false]

# (experimental) How often to check for ring changes and possibly recompute
# owned series as a result of detected change.
# CLI flag: -ingester.owned-series-update-interval
[owned_series_update_interval: <duration> | default = 15s]

push_circuit_breaker:
  # (experimental) Enable circuit breaking when making requests to ingesters
  # CLI flag: -ingester.push-circuit-breaker.enabled
  [enabled: <boolean> | default = false]

  # (experimental) Max percentage of requests that can fail over period before
  # the circuit breaker opens
  # CLI flag: -ingester.push-circuit-breaker.failure-threshold-percentage
  [failure_threshold_percentage: <int> | default = 10]

  # (experimental) How many requests must have been executed in period for the
  # circuit breaker to be eligible to open for the rate of failures
  # CLI flag: -ingester.push-circuit-breaker.failure-execution-threshold
  [failure_execution_threshold: <int> | default = 100]

  # (experimental) Moving window of time that the percentage of failed requests
  # is computed over
  # CLI flag: -ingester.push-circuit-breaker.thresholding-period
  [thresholding_period: <duration> | default = 1m]

  # (experimental) How long the circuit breaker will stay in the open state
  # before allowing some requests
  # CLI flag: -ingester.push-circuit-breaker.cooldown-period
  [cooldown_period: <duration> | default = 10s]

  # (experimental) Duration, in seconds, after an initial request that an
  # activated circuit breaker should wait before becoming effectively active.
  # During this time, neither failures nor successes are counted.
  # CLI flag: -ingester.push-circuit-breaker.initial-delay
  [initial_delay: <duration> | default = 0s]

  # (experimental) The maximum duration of an ingester's request before it
  # triggers a timeout. This configuration is used for circuit breakers only,
  # and its timeouts aren't reported as errors.
  # CLI flag: -ingester.push-circuit-breaker.request-timeout
  [request_timeout: <duration> | default = 2s]

read_circuit_breaker:
  # (experimental) Enable circuit breaking when making requests to ingesters
  # CLI flag: -ingester.read-circuit-breaker.enabled
  [enabled: <boolean> | default = false]

  # (experimental) Max percentage of requests that can fail over period before
  # the circuit breaker opens
  # CLI flag: -ingester.read-circuit-breaker.failure-threshold-percentage
  [failure_threshold_percentage: <int> | default = 10]

  # (experimental) How many requests must have been executed in period for the
  # circuit breaker to be eligible to open for the rate of failures
  # CLI flag: -ingester.read-circuit-breaker.failure-execution-threshold
  [failure_execution_threshold: <int> | default = 100]

  # (experimental) Moving window of time that the percentage of failed requests
  # is computed over
  # CLI flag: -ingester.read-circuit-breaker.thresholding-period
  [thresholding_period: <duration> | default = 1m]

  # (experimental) How long the circuit breaker will stay in the open state
  # before allowing some requests
  # CLI flag: -ingester.read-circuit-breaker.cooldown-period
  [cooldown_period: <duration> | default = 10s]

  # (experimental) Duration, in seconds, after an initial request that an
  # activated circuit breaker should wait before becoming effectively active.
  # During this time, neither failures nor successes are counted.
  # CLI flag: -ingester.read-circuit-breaker.initial-delay
  [initial_delay: <duration> | default = 0s]

  # (experimental) The maximum duration of an ingester's request before it
  # triggers a timeout. This configuration is used for circuit breakers only,
  # and its timeouts aren't reported as errors.
  # CLI flag: -ingester.read-circuit-breaker.request-timeout
  [request_timeout: <duration> | default = 30s]

rejection_prioritizer:
  # (experimental) The interval at which the rejection threshold is calibrated
  # CLI flag: -ingester.rejection-prioritizer.calibration-interval
  [calibration_interval: <duration> | default = 1s]

push_reactive_limiter:
  # (experimental) Enable reactive limiting when making requests to a service
  # CLI flag: -ingester.push-reactive-limiter.enabled
  [enabled: <boolean> | default = false]

  # (experimental) Minimum inflight requests limit
  # CLI flag: -ingester.push-reactive-limiter.min-limit
  [min_limit: <int> | default = 2]

  # (experimental) Maximum inflight requests limit
  # CLI flag: -ingester.push-reactive-limiter.max-limit
  [max_limit: <int> | default = 200]

  # (experimental) Initial inflight requests limit
  # CLI flag: -ingester.push-reactive-limiter.initial-limit
  [initial_limit: <int> | default = 20]

  # (experimental) The maximum inflight limit as a multiple of current inflight
  # requests
  # CLI flag: -ingester.push-reactive-limiter.max-limit-factor
  [max_limit_factor: <float> | default = 5]

  # (experimental) Minimum duration of the window that is used to collect recent
  # response time samples
  # CLI flag: -ingester.push-reactive-limiter.recent-window-min-duration
  [recent_window_min_duration: <duration> | default = 1s]

  # (experimental) Maximum duration of the window that is used to collect recent
  # response time samples
  # CLI flag: -ingester.push-reactive-limiter.recent-window-max-duration
  [recent_window_max_duration: <duration> | default = 30s]

  # (experimental) Minimum number of samples that must be recorded in the recent
  # window before updating the limit
  # CLI flag: -ingester.push-reactive-limiter.recent-window-min-samples
  [recent_window_min_samples: <int> | default = 50]

  # (experimental) The quantile of recent recorded response times to consider
  # when adjusting the concurrency limit
  # CLI flag: -ingester.push-reactive-limiter.recent-quantile
  [recent_quantile: <float> | default = 0.9]

  # (experimental) The average age of baseline samples aggregated recent samples
  # are added to
  # CLI flag: -ingester.push-reactive-limiter.baseline-window-age
  [baseline_window_age: <int> | default = 10]

  # (experimental) How many recent limit and inflight time measurements are
  # stored to detect whether increases in limits correlate with increases in
  # inflight times
  # CLI flag: -ingester.push-reactive-limiter.correlation-window
  [correlation_window: <int> | default = 50]

  # (experimental) The number of allowed queued requests, as a multiple of
  # current inflight requests, after which rejections start
  # CLI flag: -ingester.push-reactive-limiter.initial-rejection-factor
  [initial_rejection_factor: <float> | default = 2]

  # (experimental) The number of allowed queued requests, as a multiple of
  # current inflight requests, after which all requests are rejected
  # CLI flag: -ingester.push-reactive-limiter.max-rejection-factor
  [max_rejection_factor: <float> | default = 3]

read_reactive_limiter:
  # (experimental) Enable reactive limiting when making requests to a service
  # CLI flag: -ingester.read-reactive-limiter.enabled
  [enabled: <boolean> | default = false]

  # (experimental) Minimum inflight requests limit
  # CLI flag: -ingester.read-reactive-limiter.min-limit
  [min_limit: <int> | default = 2]

  # (experimental) Maximum inflight requests limit
  # CLI flag: -ingester.read-reactive-limiter.max-limit
  [max_limit: <int> | default = 200]

  # (experimental) Initial inflight requests limit
  # CLI flag: -ingester.read-reactive-limiter.initial-limit
  [initial_limit: <int> | default = 20]

  # (experimental) The maximum inflight limit as a multiple of current inflight
  # requests
  # CLI flag: -ingester.read-reactive-limiter.max-limit-factor
  [max_limit_factor: <float> | default = 5]

  # (experimental) Minimum duration of the window that is used to collect recent
  # response time samples
  # CLI flag: -ingester.read-reactive-limiter.recent-window-min-duration
  [recent_window_min_duration: <duration> | default = 1s]

  # (experimental) Maximum duration of the window that is used to collect recent
  # response time samples
  # CLI flag: -ingester.read-reactive-limiter.recent-window-max-duration
  [recent_window_max_duration: <duration> | default = 30s]

  # (experimental) Minimum number of samples that must be recorded in the recent
  # window before updating the limit
  # CLI flag: -ingester.read-reactive-limiter.recent-window-min-samples
  [recent_window_min_samples: <int> | default = 50]

  # (experimental) The quantile of recent recorded response times to consider
  # when adjusting the concurrency limit
  # CLI flag: -ingester.read-reactive-limiter.recent-quantile
  [recent_quantile: <float> | default = 0.9]

  # (experimental) The average age of baseline samples aggregated recent samples
  # are added to
  # CLI flag: -ingester.read-reactive-limiter.baseline-window-age
  [baseline_window_age: <int> | default = 10]

  # (experimental) How many recent limit and inflight time measurements are
  # stored to detect whether increases in limits correlate with increases in
  # inflight times
  # CLI flag: -ingester.read-reactive-limiter.correlation-window
  [correlation_window: <int> | default = 50]

  # (experimental) The number of allowed queued requests, as a multiple of
  # current inflight requests, after which rejections start
  # CLI flag: -ingester.read-reactive-limiter.initial-rejection-factor
  [initial_rejection_factor: <float> | default = 2]

  # (experimental) The number of allowed queued requests, as a multiple of
  # current inflight requests, after which all requests are rejected
  # CLI flag: -ingester.read-reactive-limiter.max-rejection-factor
  [max_rejection_factor: <float> | default = 3]
```

### querier

The `querier` block configures the querier.

```yaml
# (advanced) The time after which a metric should be queried from storage and
# not just ingesters. 0 means all queries are sent to store. If this option is
# enabled, the time range of the query sent to the store-gateway will be
# manipulated to ensure the query end is not more recent than 'now -
# query-store-after'.
# CLI flag: -querier.query-store-after
[query_store_after: <duration> | default = 12h]

# The grpc_client block configures the gRPC client used to communicate between
# two Mimir components.
# The CLI flags prefix for this block configuration is:
# querier.store-gateway-client
[store_gateway_client: <grpc_client>]

# (advanced) Fetch in-memory series from the minimum set of required ingesters,
# selecting only ingesters which may have received series since
# -querier.query-ingesters-within. If this setting is false or
# -querier.query-ingesters-within is '0', queriers always query all ingesters
# (ingesters shuffle sharding on read path is disabled).
# CLI flag: -querier.shuffle-sharding-ingesters-enabled
[shuffle_sharding_ingesters_enabled: <boolean> | default = true]

# (experimental) When set, the querier prioritizes querying data from ingesters
# and store-gateways in this availability zone.
# CLI flag: -querier.prefer-availability-zone
[prefer_availability_zone: <string> | default = ""]

# (advanced) Number of series to buffer per ingester when streaming chunks from
# ingesters.
# CLI flag: -querier.streaming-chunks-per-ingester-buffer-size
[streaming_chunks_per_ingester_series_buffer_size: <int> | default = 256]

# (advanced) Number of series to buffer per store-gateway when streaming chunks
# from store-gateways.
# CLI flag: -querier.streaming-chunks-per-store-gateway-buffer-size
[streaming_chunks_per_store_gateway_series_buffer_size: <int> | default = 256]

# (advanced) If true, when querying ingesters, only the minimum required
# ingesters required to reach quorum will be queried initially, with other
# ingesters queried only if needed due to failures from the initial set of
# ingesters. Enabling this option reduces resource consumption for the happy
# path at the cost of increased latency for the unhappy path.
# CLI flag: -querier.minimize-ingester-requests
[minimize_ingester_requests: <boolean> | default = true]

# (advanced) Delay before initiating requests to further ingesters when request
# minimization is enabled and the initially selected set of ingesters have not
# all responded. Ignored if -querier.minimize-ingester-requests is not enabled.
# CLI flag: -querier.minimize-ingester-requests-hedging-delay
[minimize_ingester_requests_hedging_delay: <duration> | default = 3s]

# (experimental) Query engine to use, either 'prometheus' or 'mimir'
# CLI flag: -querier.query-engine
[query_engine: <string> | default = "mimir"]

# (experimental) If set to true and the Mimir query engine is in use, fall back
# to using the Prometheus query engine for any queries not supported by the
# Mimir query engine.
# CLI flag: -querier.enable-query-engine-fallback
[enable_query_engine_fallback: <boolean> | default = true]

# (advanced) If set to true, the header 'X-Filter-Queryables' can be used to
# filter down the list of queryables that shall be used. This is useful to test
# and monitor single queryables in isolation.
# CLI flag: -querier.filter-queryables-enabled
[filter_queryables_enabled: <boolean> | default = false]

# (advanced) Maximum number of remote read queries that can be executed
# concurrently. 0 or negative values mean unlimited concurrency.
# CLI flag: -querier.max-concurrent-remote-read-queries
[max_concurrent_remote_read_queries: <int> | default = 2]

# The number of workers running in each querier process. This setting limits the
# maximum number of concurrent queries in each querier. The minimum value is
# four; lower values are ignored and set to the minimum
# CLI flag: -querier.max-concurrent
[max_concurrent: <int> | default = 20]

# The timeout for a query. This config option should be set on query-frontend
# too when query sharding is enabled. This also applies to queries evaluated by
# the ruler (internally or remotely).
# CLI flag: -querier.timeout
[timeout: <duration> | default = 2m]

# Maximum number of samples a single query can load into memory. This config
# option should be set on query-frontend too when query sharding is enabled.
# CLI flag: -querier.max-samples
[max_samples: <int> | default = 50000000]

# (advanced) The default evaluation interval or step size for subqueries. This
# config option should be set on query-frontend too when query sharding is
# enabled.
# CLI flag: -querier.default-evaluation-interval
[default_evaluation_interval: <duration> | default = 1m]

# (advanced) Time since the last sample after which a time series is considered
# stale and ignored by expression evaluations. This config option should be set
# on query-frontend too when query sharding is enabled.
# CLI flag: -querier.lookback-delta
[lookback_delta: <duration> | default = 5m]

# (experimental) Enable the experimental Prometheus feature for delayed name
# removal.
# CLI flag: -querier.enable-delayed-name-removal
[enable_delayed_name_removal: <boolean> | default = false]

mimir_query_engine:
  # (experimental) Enable pruning query expressions that are toggled off with
  # constants.
  # CLI flag: -querier.mimir-query-engine.enable-prune-toggles
  [enable_prune_toggles: <boolean> | default = true]

  # (experimental) Enable common subexpression elimination when evaluating
  # queries.
  # CLI flag: -querier.mimir-query-engine.enable-common-subexpression-elimination
  [enable_common_subexpression_elimination: <boolean> | default = true]

  # (experimental) Enable common subexpression elimination for range vector
  # expressions when evaluating instant queries. This has no effect if common
  # subexpression elimination is disabled.
  # CLI flag: -querier.mimir-query-engine.enable-common-subexpression-elimination-for-range-vector-expressions-in-instant-queries
  [enable_common_subexpression_elimination_for_range_vector_expressions_in_instant_queries: <boolean> | default = true]

  # (experimental) Enable skipping decoding native histograms when evaluating
  # queries that do not require full histograms.
  # CLI flag: -querier.mimir-query-engine.enable-skipping-histogram-decoding
  [enable_skipping_histogram_decoding: <boolean> | default = true]

  # (experimental) Enable generating selectors for one side of a binary
  # expression based on results from the other side.
  # CLI flag: -querier.mimir-query-engine.enable-narrow-binary-selectors
  [enable_narrow_binary_selectors: <boolean> | default = false]

  # (experimental) Enable eliminating redundant DeduplicateAndMerge nodes from
  # the query plan when it can be proven that each input series produces a
  # unique output series.
  # CLI flag: -querier.mimir-query-engine.enable-eliminate-deduplicate-and-merge
  [enable_eliminate_deduplicate_and_merge: <boolean> | default = false]
```

### frontend

The `frontend` block configures the query-frontend.

```yaml
# Log queries that are slower than the specified duration. Set to 0 to disable.
# Set to < 0 to enable on all queries.
# CLI flag: -query-frontend.log-queries-longer-than
[log_queries_longer_than: <duration> | default = 0s]

# (advanced) Comma-separated list of request header names to include in query
# logs. Applies to both query stats and slow queries logs.
# CLI flag: -query-frontend.log-query-request-headers
[log_query_request_headers: <string> | default = ""]

# (advanced) Max body size for downstream prometheus.
# CLI flag: -query-frontend.max-body-size
[max_body_size: <int> | default = 10485760]

# (advanced) False to disable query statistics tracking. When enabled, a message
# with some statistics is logged for every query.
# CLI flag: -query-frontend.query-stats-enabled
[query_stats_enabled: <boolean> | default = true]

# (experimental) Timeout for writing active series responses. 0 means the value
# from `-server.http-write-timeout` is used.
# CLI flag: -query-frontend.active-series-write-timeout
[active_series_write_timeout: <duration> | default = 5m]

# Address of the query-scheduler component, in host:port format. The host should
# resolve to all query-scheduler instances. This option should be set only when
# query-scheduler component is in use and
# -query-scheduler.service-discovery-mode is set to 'dns'.
# CLI flag: -query-frontend.scheduler-address
[scheduler_address: <string> | default = ""]

# (advanced) How often to resolve the scheduler-address, in order to look for
# new query-scheduler instances.
# CLI flag: -query-frontend.scheduler-dns-lookup-period
[scheduler_dns_lookup_period: <duration> | default = 10s]

# (advanced) Number of concurrent workers forwarding queries to single
# query-scheduler.
# CLI flag: -query-frontend.scheduler-worker-concurrency
[scheduler_worker_concurrency: <int> | default = 5]

# Configures the gRPC client used to communicate between the query-frontends and
# the query-schedulers.
# The CLI flags prefix for this block configuration is:
# query-frontend.grpc-client-config
[grpc_client_config: <grpc_client>]

# (advanced) List of network interface names to look up when finding the
# instance IP address. This address is sent to query-scheduler and querier,
# which uses it to send the query response back to query-frontend.
# CLI flag: -query-frontend.instance-interface-names
[instance_interface_names: <list of strings> | default = [<private network interfaces>]]

# (advanced) Enable using a IPv6 instance address (default false).
# CLI flag: -query-frontend.instance-enable-ipv6
[instance_enable_ipv6: <boolean> | default = false]

# (advanced) IP address to advertise to the querier (via scheduler) (default is
# auto-detected from network interfaces).
# CLI flag: -query-frontend.instance-addr
[address: <string> | default = ""]

# (advanced) Port to advertise to querier (via scheduler) (defaults to
# server.grpc-listen-port).
# CLI flag: -query-frontend.instance-port
[port: <int> | default = 0]

# (experimental) Maximum number of series to send in a single remote execution
# response from a querier.
# CLI flag: -query-frontend.remote-execution-batch-size
[remote_execution_batch_size: <int> | default = 128]

# (advanced) Split range queries by an interval and execute in parallel. You
# should use a multiple of 24 hours to optimize querying blocks. 0 to disable
# it.
# CLI flag: -query-frontend.split-queries-by-interval
[split_queries_by_interval: <duration> | default = 24h]

results_cache:
  # Backend for query-frontend results cache, if not empty. Supported values:
  # memcached.
  # CLI flag: -query-frontend.results-cache.backend
  [backend: <string> | default = ""]

  # The memcached block configures the Memcached-based caching backend.
  # The CLI flags prefix for this block configuration is:
  # query-frontend.results-cache
  [memcached: <memcached>]

  # Enable cache compression, if not empty. Supported values are: snappy.
  # CLI flag: -query-frontend.results-cache.compression
  [compression: <string> | default = ""]

# Cache query results.
# CLI flag: -query-frontend.cache-results
[cache_results: <boolean> | default = false]

# Cache non-transient errors from queries.
# CLI flag: -query-frontend.cache-errors
[cache_errors: <boolean> | default = false]

# (advanced) Maximum number of retries for a single request; beyond this, the
# downstream error is returned.
# CLI flag: -query-frontend.max-retries-per-request
[max_retries: <int> | default = 5]

# (advanced) Maximum time to wait for the query-frontend to become ready before
# rejecting requests received before the frontend was ready. 0 to disable (i.e.
# fail immediately if a request is received while the frontend is still starting
# up)
# CLI flag: -query-frontend.not-running-timeout
[not_running_timeout: <duration> | default = 2s]

# True to enable query sharding.
# CLI flag: -query-frontend.parallelize-shardable-queries
[parallelize_shardable_queries: <boolean> | default = false]

# (experimental) If set to true and the Mimir query engine is in use, use remote
# execution to evaluate queries in queriers.
# CLI flag: -query-frontend.enable-remote-execution
[enable_remote_execution: <boolean> | default = false]

# (experimental) Set to true to enable performing query sharding inside the
# Mimir query engine (MQE). This setting has no effect if sharding is disabled.
# Requires remote execution and MQE to be enabled.
# CLI flag: -query-frontend.use-mimir-query-engine-for-sharding
[use_mimir_query_engine_for_sharding: <boolean> | default = false]

# (experimental) Set to true to enable rewriting histogram queries for a more
# efficient order of execution.
# CLI flag: -query-frontend.rewrite-histogram-queries
[rewrite_histogram_queries: <boolean> | default = false]

# (experimental) Set to true to enable rewriting queries to propagate label
# matchers across binary expressions.
# CLI flag: -query-frontend.rewrite-propagate-matchers
[rewrite_propagate_matchers: <boolean> | default = false]

# (advanced) How many series a single sharded partial query should load at most.
# This is not a strict requirement guaranteed to be honoured by query sharding,
# but a hint given to the query sharding when the query execution is initially
# planned. 0 to disable cardinality-based hints.
# CLI flag: -query-frontend.query-sharding-target-series-per-shard
[query_sharding_target_series_per_shard: <int> | default = 0]

# (experimental) True to enable sharding of active series queries.
# CLI flag: -query-frontend.shard-active-series-queries
[shard_active_series_queries: <boolean> | default = false]

# (experimental) Set to true to use the zero-allocation response decoder for
# active series queries.
# CLI flag: -query-frontend.use-active-series-decoder
[use_active_series_decoder: <boolean> | default = false]

# (advanced) Comma-separated list of request header names to allow to pass
# through to the rest of the query path. This is in addition to a list of
# required headers that the read path needs.
# CLI flag: -query-frontend.extra-propagated-headers
[extra_propagated_headers: <string> | default = ""]

# Format to use when retrieving query results from queriers. Supported values:
# json, protobuf
# CLI flag: -query-frontend.query-result-response-format
[query_result_response_format: <string> | default = "protobuf"]

# Cache statistics of processed samples on results cache.
# CLI flag: -query-frontend.cache-samples-processed-stats
[cache_samples_processed_stats: <boolean> | default = false]

client_cluster_validation:
  # (experimental) Primary cluster validation label.
  # CLI flag: -query-frontend.client-cluster-validation.label
  [label: <string> | default = ""]

# (experimental) Query engine to use, either 'prometheus' or 'mimir'
# CLI flag: -query-frontend.query-engine
[query_engine: <string> | default = "mimir"]

# (experimental) If set to true and the Mimir query engine is in use, fall back
# to using the Prometheus query engine for any queries not supported by the
# Mimir query engine.
# CLI flag: -query-frontend.enable-query-engine-fallback
[enable_query_engine_fallback: <boolean> | default = true]
```

### query_scheduler

The `query_scheduler` block configures the query-scheduler.

```yaml
# Maximum number of outstanding requests per tenant per query-scheduler.
# In-flight requests above this limit will fail with HTTP response status code
# 429.
# CLI flag: -query-scheduler.max-outstanding-requests-per-tenant
[max_outstanding_requests_per_tenant: <int> | default = 100]

# (experimental) If a querier disconnects without sending notification about
# graceful shutdown, the query-scheduler will keep the querier in the tenant's
# shard until the forget delay has passed. This feature is useful to reduce the
# blast radius when shuffle-sharding is enabled.
# CLI flag: -query-scheduler.querier-forget-delay
[querier_forget_delay: <duration> | default = 0s]

# This configures the gRPC client used to report errors back to the
# query-frontend.
# The CLI flags prefix for this block configuration is:
# query-scheduler.grpc-client-config
[grpc_client_config: <grpc_client>]

# (experimental) Service discovery mode that query-frontends and queriers use to
# find query-scheduler instances. When query-scheduler ring-based service
# discovery is enabled, this option needs be set on query-schedulers,
# query-frontends and queriers. Supported values are: dns, ring.
# CLI flag: -query-scheduler.service-discovery-mode
[service_discovery_mode: <string> | default = "dns"]

# The hash ring configuration. The query-schedulers hash ring is used for
# service discovery.
ring:
  # The key-value store used to share the hash ring across multiple instances.
  # When query-scheduler ring-based service discovery is enabled, this option
  # needs be set on query-schedulers, query-frontends and queriers.
  kvstore:
    # Backend storage to use for the ring. Supported values are: consul, etcd,
    # inmemory, memberlist, multi.
    # CLI flag: -query-scheduler.ring.store
    [store: <string> | default = "memberlist"]

    # (advanced) The prefix for the keys in the store. Should end with a /.
    # CLI flag: -query-scheduler.ring.prefix
    [prefix: <string> | default = "collectors/"]

    # The consul block configures the consul client.
    # The CLI flags prefix for this block configuration is: query-scheduler.ring
    [consul: <consul>]

    # The etcd block configures the etcd client.
    # The CLI flags prefix for this block configuration is: query-scheduler.ring
    [etcd: <etcd>]

    multi:
      # (advanced) Primary backend storage used by multi-client.
      # CLI flag: -query-scheduler.ring.multi.primary
      [primary: <string> | default = ""]

      # (advanced) Secondary backend storage used by multi-client.
      # CLI flag: -query-scheduler.ring.multi.secondary
      [secondary: <string> | default = ""]

      # (advanced) Mirror writes to secondary store.
      # CLI flag: -query-scheduler.ring.multi.mirror-enabled
      [mirror_enabled: <boolean> | default = false]

      # (advanced) Timeout for storing value to secondary store.
      # CLI flag: -query-scheduler.ring.multi.mirror-timeout
      [mirror_timeout: <duration> | default = 2s]

  # (advanced) Period at which to heartbeat to the ring. 0 = disabled.
  # CLI flag: -query-scheduler.ring.heartbeat-period
  [heartbeat_period: <duration> | default = 15s]

  # (advanced) The heartbeat timeout after which query-schedulers are considered
  # unhealthy within the ring. When query-scheduler ring-based service discovery
  # is enabled, this option needs be set on query-schedulers, query-frontends
  # and queriers.
  # CLI flag: -query-scheduler.ring.heartbeat-timeout
  [heartbeat_timeout: <duration> | default = 1m]

  # (advanced) Number of consecutive timeout periods an unhealthy instance in
  # the ring is automatically removed after. Set to 0 to disable auto-forget.
  # CLI flag: -query-scheduler.ring.auto-forget-unhealthy-periods
  [auto_forget_unhealthy_periods: <int> | default = 10]

  # (advanced) Instance ID to register in the ring.
  # CLI flag: -query-scheduler.ring.instance-id
  [instance_id: <string> | default = "<hostname>"]

  # List of network interface names to look up when finding the instance IP
  # address.
  # CLI flag: -query-scheduler.ring.instance-interface-names
  [instance_interface_names: <list of strings> | default = [<private network interfaces>]]

  # (advanced) Port to advertise in the ring (defaults to
  # -server.grpc-listen-port).
  # CLI flag: -query-scheduler.ring.instance-port
  [instance_port: <int> | default = 0]

  # (advanced) IP address to advertise in the ring. Default is auto-detected.
  # CLI flag: -query-scheduler.ring.instance-addr
  [instance_addr: <string> | default = ""]

  # (advanced) Enable using a IPv6 instance address. (default false)
  # CLI flag: -query-scheduler.ring.instance-enable-ipv6
  [instance_enable_ipv6: <boolean> | default = false]

# The maximum number of query-scheduler instances to use, regardless how many
# replicas are running. This option can be set only when
# -query-scheduler.service-discovery-mode is set to 'ring'. 0 to use all
# available query-scheduler instances.
# CLI flag: -query-scheduler.max-used-instances
[max_used_instances: <int> | default = 0]
```

### ruler

The `ruler` block configures the ruler.

```yaml
# URL of alerts return path.
# CLI flag: -ruler.external.url
[external_url: <url> | default = ]

# Configures the gRPC client used to communicate between ruler instances.
# The CLI flags prefix for this block configuration is: ruler.client
[ruler_client: <grpc_client>]

# (advanced) How frequently to evaluate rules
# CLI flag: -ruler.evaluation-interval
[evaluation_interval: <duration> | default = 1m]

# (advanced) How frequently the configured rule groups are re-synced from the
# object storage.
# CLI flag: -ruler.poll-interval
[poll_interval: <duration> | default = 10m]

# Directory to store temporary rule files loaded by the Prometheus rule
# managers. This directory is not required to be persisted between restarts.
# CLI flag: -ruler.rule-path
[rule_path: <string> | default = "./data-ruler/"]

# (deprecated) Deprecated, use
# limits.ruler_alertmanager_client_config.alertmanager_url instead.
[alertmanager_url: <string> | default = ""]

# (advanced) How long to wait between refreshing DNS resolutions of Alertmanager
# hosts.
# CLI flag: -ruler.alertmanager-refresh-interval
[alertmanager_refresh_interval: <duration> | default = 1m]

# (advanced) Capacity of the queue for notifications to be sent to the
# Alertmanager.
# CLI flag: -ruler.notification-queue-capacity
[notification_queue_capacity: <int> | default = 10000]

# (advanced) Maximum number of notifications to send to Alertmanager in one
# request.
# CLI flag: -ruler.max-notification-batch-size
[max_notification_batch_size: <int> | default = 256]

# (advanced) HTTP timeout duration when sending notifications to the
# Alertmanager.
# CLI flag: -ruler.notification-timeout
[notification_timeout: <duration> | default = 10s]

# Deprecated, use limits.ruler_alertmanager_client_config instead.
alertmanager_client:
  # (advanced)
  [tls_enabled: <boolean> | default = ]

  # (advanced)
  [tls_cert_path: <string> | default = ""]

  # (advanced)
  [tls_key_path: <string> | default = ""]

  # (advanced)
  [tls_ca_path: <string> | default = ""]

  # (advanced)
  [tls_server_name: <string> | default = ""]

  # (advanced)
  [tls_insecure_skip_verify: <boolean> | default = ]

  # (advanced) Override the default cipher suite list (separated by commas).
  # Allowed values:
  #
  # Secure Ciphers:
  # - TLS_AES_128_GCM_SHA256
  # - TLS_AES_256_GCM_SHA384
  # - TLS_CHACHA20_POLY1305_SHA256
  # - TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA
  # - TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA
  # - TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA
  # - TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA
  # - TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256
  # - TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384
  # - TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256
  # - TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384
  # - TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256
  # - TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256
  #
  # Insecure Ciphers:
  # - TLS_RSA_WITH_RC4_128_SHA
  # - TLS_RSA_WITH_3DES_EDE_CBC_SHA
  # - TLS_RSA_WITH_AES_128_CBC_SHA
  # - TLS_RSA_WITH_AES_256_CBC_SHA
  # - TLS_RSA_WITH_AES_128_CBC_SHA256
  # - TLS_RSA_WITH_AES_128_GCM_SHA256
  # - TLS_RSA_WITH_AES_256_GCM_SHA384
  # - TLS_ECDHE_ECDSA_WITH_RC4_128_SHA
  # - TLS_ECDHE_RSA_WITH_RC4_128_SHA
  # - TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA
  # - TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256
  # - TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256
  [tls_cipher_suites: <string> | default = ""]

  # (advanced)
  [tls_min_version: <string> | default = ""]

  [basic_auth_username: <string> | default = ""]

  basic_auth_password:

  oauth2:
    [client_id: <string> | default = ""]

    client_secret:

    [token_url: <string> | default = ""]

    [scopes: <string> | default = ""]

    # (advanced)
    [endpoint_params: <map of string to string> | default = ]

  # (advanced)
  [proxy_url: <string> | default = ""]

# (advanced) Max time to tolerate outage for restoring "for" state of alert.
# CLI flag: -ruler.for-outage-tolerance
[for_outage_tolerance: <duration> | default = 1h]

# (advanced) This grace period controls which alerts the ruler restores after a
# restart. Alerts with "for" duration lower than this grace period are not
# restored after a ruler restart. This means that if the alerts have been firing
# before the ruler restarted, they will now go to pending state and then to
# firing again after their "for" duration expires. Alerts with "for" duration
# greater than or equal to this grace period that have been pending before the
# ruler restart will remain in pending state for at least this grace period.
# Alerts with "for" duration greater than or equal to this grace period that
# have been firing before the ruler restart will continue to be firing after the
# restart.
# CLI flag: -ruler.for-grace-period
[for_grace_period: <duration> | default = 2m]

# (advanced) Minimum amount of time to wait before resending an alert to
# Alertmanager.
# CLI flag: -ruler.resend-delay
[resend_delay: <duration> | default = 1m]

ring:
  # The key-value store used to share the hash ring across multiple instances.
  kvstore:
    # Backend storage to use for the ring. Supported values are: consul, etcd,
    # inmemory, memberlist, multi.
    # CLI flag: -ruler.ring.store
    [store: <string> | default = "memberlist"]

    # (advanced) The prefix for the keys in the store. Should end with a /.
    # CLI flag: -ruler.ring.prefix
    [prefix: <string> | default = "rulers/"]

    # The consul block configures the consul client.
    # The CLI flags prefix for this block configuration is: ruler.ring
    [consul: <consul>]

    # The etcd block configures the etcd client.
    # The CLI flags prefix for this block configuration is: ruler.ring
    [etcd: <etcd>]

    multi:
      # (advanced) Primary backend storage used by multi-client.
      # CLI flag: -ruler.ring.multi.primary
      [primary: <string> | default = ""]

      # (advanced) Secondary backend storage used by multi-client.
      # CLI flag: -ruler.ring.multi.secondary
      [secondary: <string> | default = ""]

      # (advanced) Mirror writes to secondary store.
      # CLI flag: -ruler.ring.multi.mirror-enabled
      [mirror_enabled: <boolean> | default = false]

      # (advanced) Timeout for storing value to secondary store.
      # CLI flag: -ruler.ring.multi.mirror-timeout
      [mirror_timeout: <duration> | default = 2s]

  # (advanced) Period at which to heartbeat to the ring. 0 = disabled.
  # CLI flag: -ruler.ring.heartbeat-period
  [heartbeat_period: <duration> | default = 15s]

  # (advanced) The heartbeat timeout after which rulers are considered unhealthy
  # within the ring. 0 = never (timeout disabled).
  # CLI flag: -ruler.ring.heartbeat-timeout
  [heartbeat_timeout: <duration> | default = 1m]

  # (advanced) Instance ID to register in the ring.
  # CLI flag: -ruler.ring.instance-id
  [instance_id: <string> | default = "<hostname>"]

  # List of network interface names to look up when finding the instance IP
  # address.
  # CLI flag: -ruler.ring.instance-interface-names
  [instance_interface_names: <list of strings> | default = [<private network interfaces>]]

  # (advanced) Port to advertise in the ring (defaults to
  # -server.grpc-listen-port).
  # CLI flag: -ruler.ring.instance-port
  [instance_port: <int> | default = 0]

  # (advanced) IP address to advertise in the ring. Default is auto-detected.
  # CLI flag: -ruler.ring.instance-addr
  [instance_addr: <string> | default = ""]

  # (advanced) Enable using a IPv6 instance address. (default false)
  # CLI flag: -ruler.ring.instance-enable-ipv6
  [instance_enable_ipv6: <boolean> | default = false]

  # (advanced) Number of consecutive timeout periods an unhealthy instance in
  # the ring is automatically removed after. Set to 0 to disable auto-forget.
  # CLI flag: -ruler.ring.auto-forget-unhealthy-periods
  [auto_forget_unhealthy_periods: <int> | default = 2]

  # (advanced) Number of tokens for each ruler.
  # CLI flag: -ruler.ring.num-tokens
  [num_tokens: <int> | default = 128]

# Enable the ruler config API.
# CLI flag: -ruler.enable-api
[enable_api: <boolean> | default = true]

# (advanced) Comma separated list of tenants whose rules this ruler can
# evaluate. If specified, only these tenants will be handled by ruler, otherwise
# this ruler can process rules from all tenants. Subject to sharding.
# CLI flag: -ruler.enabled-tenants
[enabled_tenants: <string> | default = ""]

# (advanced) Comma separated list of tenants whose rules this ruler cannot
# evaluate. If specified, a ruler that would normally pick the specified
# tenant(s) for processing will ignore them instead. Subject to sharding.
# CLI flag: -ruler.disabled-tenants
[disabled_tenants: <string> | default = ""]

# (advanced) Report the wall time for ruler queries to complete as a per-tenant
# metric and as an info level log message.
# CLI flag: -ruler.query-stats-enabled
[query_stats_enabled: <boolean> | default = false]

query_frontend:
  # Can be either the GRPC listen address of the query-frontend(s) or the
  # HTTP/HTTPS address of a Prometheus-compatible server. Must be a DNS address
  # (prefixed with dns:///) to enable GRPC client side load balancing.
  # CLI flag: -ruler.query-frontend.address
  [address: <string> | default = ""]

  # Configures the gRPC client used to communicate between the rulers and
  # query-frontends.
  # The CLI flags prefix for this block configuration is:
  # ruler.query-frontend.grpc-client-config
  [grpc_client_config: <grpc_client>]

  # Configures the HTTP client used to communicate between the rulers and
  # query-frontends.
  http_client_config:
    # (advanced) Timeout for establishing a connection to the query-frontend.
    # CLI flag: -ruler.query-frontend.http-client-config.connect-timeout
    [connect_timeout: <duration> | default = 30s]

  # Format to use when retrieving query results from query-frontends. Supported
  # values: json, protobuf
  # CLI flag: -ruler.query-frontend.query-result-response-format
  [query_result_response_format: <string> | default = "protobuf"]

  # Maximum number of retries for failed queries per second.
  # CLI flag: -ruler.query-frontend.max-retries-rate
  [max_retries_rate: <float> | default = 170]

tenant_federation:
  # Enable rule groups to query against multiple tenants. The tenant IDs
  # involved need to be in the rule group's 'source_tenants' field. If this flag
  # is set to 'false' when there are federated rule groups that already exist,
  # then these rules groups will be skipped during evaluations.
  # CLI flag: -ruler.tenant-federation.enabled
  [enabled: <boolean> | default = false]

# (experimental) Interval between sending queued rule sync requests to ruler
# replicas.
# CLI flag: -ruler.outbound-sync-queue-poll-interval
[outbound_sync_queue_poll_interval: <duration> | default = 10s]

# (experimental) Interval between applying queued incoming rule sync requests.
# CLI flag: -ruler.inbound-sync-queue-poll-interval
[inbound_sync_queue_poll_interval: <duration> | default = 10s]

# (experimental) Number of rules rules that don't have dependencies that we
# allow to be evaluated concurrently across all tenants. 0 to disable.
# CLI flag: -ruler.max-independent-rule-evaluation-concurrency
[max_independent_rule_evaluation_concurrency: <int> | default = 0]

# (experimental) Minimum threshold of the interval to last rule group runtime
# duration to allow a rule to be evaluated concurrency. By default, the rule
# group runtime duration must exceed 50.0% of the evaluation interval.
# CLI flag: -ruler.independent-rule-evaluation-concurrency-min-duration-percentage
[independent_rule_evaluation_concurrency_min_duration_percentage: <float> | default = 50]

# (experimental) Writes the results of rule evaluation to ingesters or ingest
# storage when enabled. Use this option for testing purposes. To disable, set to
# false.
# CLI flag: -ruler.rule-evaluation-write-enabled
[rule_evaluation_write_enabled: <boolean> | default = true]
```

### ruler_storage

The `ruler_storage` block configures the ruler storage backend.

```yaml
# Backend storage to use. Supported backends are: s3, gcs, azure, swift,
# filesystem, local.
# CLI flag: -ruler-storage.backend
[backend: <string> | default = "filesystem"]

# The s3_backend block configures the connection to Amazon S3 object storage
# backend.
# The CLI flags prefix for this block configuration is: ruler-storage
[s3: <s3_storage_backend>]

# The gcs_backend block configures the connection to Google Cloud Storage object
# storage backend.
# The CLI flags prefix for this block configuration is: ruler-storage
[gcs: <gcs_storage_backend>]

# The azure_storage_backend block configures the connection to Azure object
# storage backend.
# The CLI flags prefix for this block configuration is: ruler-storage
[azure: <azure_storage_backend>]

# The swift_storage_backend block configures the connection to OpenStack Object
# Storage (Swift) object storage backend.
# The CLI flags prefix for this block configuration is: ruler-storage
[swift: <swift_storage_backend>]

# The filesystem_storage_backend block configures the usage of local file system
# as object storage backend.
# The CLI flags prefix for this block configuration is: ruler-storage
[filesystem: <filesystem_storage_backend>]

# Prefix for all objects stored in the backend storage. For simplicity, it may
# only contain digits and English alphabet letters.
# CLI flag: -ruler-storage.storage-prefix
[storage_prefix: <string> | default = ""]

local:
  # Directory to scan for rules
  # CLI flag: -ruler-storage.local.directory
  [directory: <string> | default = ""]

cache:
  # Backend for ruler storage cache, if not empty. The cache is supported for
  # any storage backend except "local". Supported values: memcached.
  # CLI flag: -ruler-storage.cache.backend
  [backend: <string> | default = ""]

  # The memcached block configures the Memcached-based caching backend.
  # The CLI flags prefix for this block configuration is: ruler-storage.cache
  [memcached: <memcached>]
```

### alertmanager

The `alertmanager` block configures the alertmanager.

```yaml
# Directory to store Alertmanager state and temporarily configuration files. The
# content of this directory is not required to be persisted between restarts
# unless Alertmanager replication has been disabled.
# CLI flag: -alertmanager.storage.path
[data_dir: <string> | default = "./data-alertmanager/"]

# (advanced) How long should we store stateful data (notification logs and
# silences). For notification log entries, refers to how long should we keep
# entries before they expire and are deleted. For silences, refers to how long
# should tenants view silences after they expire and are deleted.
# CLI flag: -alertmanager.storage.retention
[retention: <duration> | default = 120h]

# The URL under which Alertmanager is externally reachable (eg. could be
# different than -http.alertmanager-http-prefix in case Alertmanager is served
# via a reverse proxy). This setting is used both to configure the internal
# requests router and to generate links in alert templates. If the external URL
# has a path portion, it will be used to prefix all HTTP endpoints served by
# Alertmanager, both the UI and API.
# CLI flag: -alertmanager.web.external-url
[external_url: <url> | default = http://localhost:8080/alertmanager]

# (advanced) How frequently to poll Alertmanager configs.
# CLI flag: -alertmanager.configs.poll-interval
[poll_interval: <duration> | default = 15s]

# (advanced) Maximum size (bytes) of an accepted HTTP request body.
# CLI flag: -alertmanager.max-recv-msg-size
[max_recv_msg_size: <int> | default = 104857600]

# (experimental) Timeout for reading the state from object storage during the
# initial sync. Set to `0` for no timeout.
# CLI flag: -alertmanager.storage.state-read-timeout
[state_read_timeout: <duration> | default = 15s]

sharding_ring:
  # The key-value store used to share the hash ring across multiple instances.
  kvstore:
    # Backend storage to use for the ring. Supported values are: consul, etcd,
    # inmemory, memberlist, multi.
    # CLI flag: -alertmanager.sharding-ring.store
    [store: <string> | default = "memberlist"]

    # (advanced) The prefix for the keys in the store. Should end with a /.
    # CLI flag: -alertmanager.sharding-ring.prefix
    [prefix: <string> | default = "alertmanagers/"]

    # The consul block configures the consul client.
    # The CLI flags prefix for this block configuration is:
    # alertmanager.sharding-ring
    [consul: <consul>]

    # The etcd block configures the etcd client.
    # The CLI flags prefix for this block configuration is:
    # alertmanager.sharding-ring
    [etcd: <etcd>]

    multi:
      # (advanced) Primary backend storage used by multi-client.
      # CLI flag: -alertmanager.sharding-ring.multi.primary
      [primary: <string> | default = ""]

      # (advanced) Secondary backend storage used by multi-client.
      # CLI flag: -alertmanager.sharding-ring.multi.secondary
      [secondary: <string> | default = ""]

      # (advanced) Mirror writes to secondary store.
      # CLI flag: -alertmanager.sharding-ring.multi.mirror-enabled
      [mirror_enabled: <boolean> | default = false]

      # (advanced) Timeout for storing value to secondary store.
      # CLI flag: -alertmanager.sharding-ring.multi.mirror-timeout
      [mirror_timeout: <duration> | default = 2s]

  # (advanced) Period at which to heartbeat to the ring. 0 = disabled.
  # CLI flag: -alertmanager.sharding-ring.heartbeat-period
  [heartbeat_period: <duration> | default = 15s]

  # (advanced) The heartbeat timeout after which alertmanagers are considered
  # unhealthy within the ring. 0 = never (timeout disabled).
  # CLI flag: -alertmanager.sharding-ring.heartbeat-timeout
  [heartbeat_timeout: <duration> | default = 1m]

  # (advanced) Instance ID to register in the ring.
  # CLI flag: -alertmanager.sharding-ring.instance-id
  [instance_id: <string> | default = "<hostname>"]

  # List of network interface names to look up when finding the instance IP
  # address.
  # CLI flag: -alertmanager.sharding-ring.instance-interface-names
  [instance_interface_names: <list of strings> | default = [<private network interfaces>]]

  # (advanced) Port to advertise in the ring (defaults to
  # -server.grpc-listen-port).
  # CLI flag: -alertmanager.sharding-ring.instance-port
  [instance_port: <int> | default = 0]

  # (advanced) IP address to advertise in the ring. Default is auto-detected.
  # CLI flag: -alertmanager.sharding-ring.instance-addr
  [instance_addr: <string> | default = ""]

  # (advanced) Enable using a IPv6 instance address. (default false)
  # CLI flag: -alertmanager.sharding-ring.instance-enable-ipv6
  [instance_enable_ipv6: <boolean> | default = false]

  # (advanced) The replication factor to use when sharding the alertmanager.
  # CLI flag: -alertmanager.sharding-ring.replication-factor
  [replication_factor: <int> | default = 3]

  # (advanced) True to enable zone-awareness and replicate alerts across
  # different availability zones.
  # CLI flag: -alertmanager.sharding-ring.zone-awareness-enabled
  [zone_awareness_enabled: <boolean> | default = false]

  # (advanced) The availability zone where this instance is running. Required if
  # zone-awareness is enabled.
  # CLI flag: -alertmanager.sharding-ring.instance-availability-zone
  [instance_availability_zone: <string> | default = ""]

# Filename of fallback config to use if none specified for instance.
# CLI flag: -alertmanager.configs.fallback
[fallback_config_file: <string> | default = ""]

# (advanced) Time to wait between peers to send notifications.
# CLI flag: -alertmanager.peer-timeout
[peer_timeout: <duration> | default = 15s]

# (advanced) Enable the alertmanager config API.
# CLI flag: -alertmanager.enable-api
[enable_api: <boolean> | default = true]

# (experimental) Enable routes to support the migration and operation of the
# Grafana Alertmanager.
# CLI flag: -alertmanager.grafana-alertmanager-compatibility-enabled
[grafana_alertmanager_compatibility_enabled: <boolean> | default = false]

# (experimental) Duration to wait before shutting down an idle Alertmanager
# using an unpromoted or default configuration when strict initialization is
# enabled.
# CLI flag: -alertmanager.grafana-alertmanager-grace-period
[grafana_alertmanager_idle_grace_period: <duration> | default = 5m]

# (advanced) Maximum number of concurrent GET requests allowed per tenant. The
# zero value (and negative values) result in a limit of GOMAXPROCS or 8,
# whichever is larger. Status code 503 is served for GET requests that would
# exceed the concurrency limit.
# CLI flag: -alertmanager.max-concurrent-get-requests-per-tenant
[max_concurrent_get_requests_per_tenant: <int> | default = 0]

alertmanager_client:
  # (advanced) Timeout for downstream alertmanagers.
  # CLI flag: -alertmanager.alertmanager-client.remote-timeout
  [remote_timeout: <duration> | default = 2s]

  # (advanced) gRPC client max receive message size (bytes).
  # CLI flag: -alertmanager.alertmanager-client.grpc-max-recv-msg-size
  [max_recv_msg_size: <int> | default = 104857600]

  # (advanced) gRPC client max send message size (bytes).
  # CLI flag: -alertmanager.alertmanager-client.grpc-max-send-msg-size
  [max_send_msg_size: <int> | default = 104857600]

  # (advanced) Use compression when sending messages. Supported values are:
  # 'gzip', 'snappy', 's2' and '' (disable compression)
  # CLI flag: -alertmanager.alertmanager-client.grpc-compression
  [grpc_compression: <string> | default = ""]

  # (advanced) Rate limit for gRPC client; 0 means disabled.
  # CLI flag: -alertmanager.alertmanager-client.grpc-client-rate-limit
  [rate_limit: <float> | default = 0]

  # (advanced) Rate limit burst for gRPC client.
  # CLI flag: -alertmanager.alertmanager-client.grpc-client-rate-limit-burst
  [rate_limit_burst: <int> | default = 0]

  # (advanced) Enable backoff and retry when we hit rate limits.
  # CLI flag: -alertmanager.alertmanager-client.backoff-on-ratelimits
  [backoff_on_ratelimits: <boolean> | default = false]

  backoff_config:
    # (advanced) Minimum delay when backing off.
    # CLI flag: -alertmanager.alertmanager-client.backoff-min-period
    [min_period: <duration> | default = 100ms]

    # (advanced) Maximum delay when backing off.
    # CLI flag: -alertmanager.alertmanager-client.backoff-max-period
    [max_period: <duration> | default = 10s]

    # (advanced) Number of times to backoff and retry before failing.
    # CLI flag: -alertmanager.alertmanager-client.backoff-retries
    [max_retries: <int> | default = 10]

  # (experimental) Initial stream window size. Values less than the default are
  # not supported and are ignored. Setting this to a value other than the
  # default disables the BDP estimator.
  # CLI flag: -alertmanager.alertmanager-client.initial-stream-window-size
  [initial_stream_window_size: <int> | default = 63KiB1023B]

  # (experimental) Initial connection window size. Values less than the default
  # are not supported and are ignored. Setting this to a value other than the
  # default disables the BDP estimator.
  # CLI flag: -alertmanager.alertmanager-client.initial-connection-window-size
  [initial_connection_window_size: <int> | default = 63KiB1023B]

  # (advanced) Enable TLS in the gRPC client. This flag needs to be enabled when
  # any other TLS flag is set. If set to false, insecure connection to gRPC
  # server will be used.
  # CLI flag: -alertmanager.alertmanager-client.tls-enabled
  [tls_enabled: <boolean> | default = false]

  # (advanced) Path to the client certificate, which will be used for
  # authenticating with the server. Also requires the key path to be configured.
  # CLI flag: -alertmanager.alertmanager-client.tls-cert-path
  [tls_cert_path: <string> | default = ""]

  # (advanced) Path to the key for the client certificate. Also requires the
  # client certificate to be configured.
  # CLI flag: -alertmanager.alertmanager-client.tls-key-path
  [tls_key_path: <string> | default = ""]

  # (advanced) Path to the CA certificates to validate server certificate
  # against. If not set, the host's root CA certificates are used.
  # CLI flag: -alertmanager.alertmanager-client.tls-ca-path
  [tls_ca_path: <string> | default = ""]

  # (advanced) Override the expected name on the server certificate.
  # CLI flag: -alertmanager.alertmanager-client.tls-server-name
  [tls_server_name: <string> | default = ""]

  # (advanced) Skip validating server certificate.
  # CLI flag: -alertmanager.alertmanager-client.tls-insecure-skip-verify
  [tls_insecure_skip_verify: <boolean> | default = false]

  # (advanced) Override the default cipher suite list (separated by commas).
  # Allowed values:
  #
  # Secure Ciphers:
  # - TLS_AES_128_GCM_SHA256
  # - TLS_AES_256_GCM_SHA384
  # - TLS_CHACHA20_POLY1305_SHA256
  # - TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA
  # - TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA
  # - TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA
  # - TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA
  # - TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256
  # - TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384
  # - TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256
  # - TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384
  # - TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256
  # - TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256
  #
  # Insecure Ciphers:
  # - TLS_RSA_WITH_RC4_128_SHA
  # - TLS_RSA_WITH_3DES_EDE_CBC_SHA
  # - TLS_RSA_WITH_AES_128_CBC_SHA
  # - TLS_RSA_WITH_AES_256_CBC_SHA
  # - TLS_RSA_WITH_AES_128_CBC_SHA256
  # - TLS_RSA_WITH_AES_128_GCM_SHA256
  # - TLS_RSA_WITH_AES_256_GCM_SHA384
  # - TLS_ECDHE_ECDSA_WITH_RC4_128_SHA
  # - TLS_ECDHE_RSA_WITH_RC4_128_SHA
  # - TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA
  # - TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256
  # - TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256
  # CLI flag: -alertmanager.alertmanager-client.tls-cipher-suites
  [tls_cipher_suites: <string> | default = ""]

  # (advanced) Override the default minimum TLS version. Allowed values:
  # VersionTLS10, VersionTLS11, VersionTLS12, VersionTLS13
  # CLI flag: -alertmanager.alertmanager-client.tls-min-version
  [tls_min_version: <string> | default = ""]

  # (advanced) The maximum amount of time to establish a connection. A value of
  # 0 means default gRPC client connect timeout and backoff.
  # CLI flag: -alertmanager.alertmanager-client.connect-timeout
  [connect_timeout: <duration> | default = 5s]

  # (advanced) Initial backoff delay after first connection failure. Only
  # relevant if ConnectTimeout > 0.
  # CLI flag: -alertmanager.alertmanager-client.connect-backoff-base-delay
  [connect_backoff_base_delay: <duration> | default = 1s]

  # (advanced) Maximum backoff delay when establishing a connection. Only
  # relevant if ConnectTimeout > 0.
  # CLI flag: -alertmanager.alertmanager-client.connect-backoff-max-delay
  [connect_backoff_max_delay: <duration> | default = 5s]

  cluster_validation:
    # (experimental) Primary cluster validation label.
    # CLI flag: -alertmanager.alertmanager-client.cluster-validation.label
    [label: <string> | default = ""]

# (advanced) The interval between persisting the current alertmanager state
# (notification log and silences) to object storage. This is only used when
# sharding is enabled. This state is read when all replicas for a shard can not
# be contacted. In this scenario, having persisted the state more frequently
# will result in potentially fewer lost silences, and fewer duplicate
# notifications.
# CLI flag: -alertmanager.persist-interval
[persist_interval: <duration> | default = 15m]

# (advanced) Enables periodic cleanup of alertmanager stateful data
# (notification logs and silences) from object storage. When enabled, data is
# removed for any tenant that does not have a configuration.
# CLI flag: -alertmanager.enable-state-cleanup
[enable_state_cleanup: <boolean> | default = true]

# (experimental) Skip initializing Alertmanagers for tenants without a
# non-default, non-empty configuration. For Grafana Alertmanager tenants,
# configurations not marked as 'promoted' will also be skipped.
# CLI flag: -alertmanager.strict-initialization-enabled
[strict_initialization: <boolean> | default = false]

# (experimental) Enable UTF-8 strict mode. Allows UTF-8 characters in the
# matchers for routes and inhibition rules, in silences, and in the labels for
# alerts. It is recommended that all tenants run the `migrate-utf8` command in
# mimirtool before enabling this mode. Otherwise, some tenant configurations
# might fail to load. For more information, refer to [Enable
# UTF-8](https://grafana.com/docs/mimir/<MIMIR_VERSION>/references/architecture/components/alertmanager/#enable-utf-8).
# Enabling and then disabling UTF-8 strict mode can break existing Alertmanager
# configurations if tenants added UTF-8 characters to their Alertmanager
# configuration while it was enabled.
# CLI flag: -alertmanager.utf8-strict-mode-enabled
[utf8_strict_mode: <boolean> | default = false]

# (experimental) Enable logging when parsing label matchers. This flag is
# intended to be used with -alertmanager.utf8-strict-mode-enabled to validate
# UTF-8 strict mode is working as intended.
# CLI flag: -alertmanager.log-parsing-label-matchers
[log_parsing_label_matchers: <boolean> | default = false]

# (experimental) Enable logging of tenant configurations that are incompatible
# with UTF-8 strict mode.
# CLI flag: -alertmanager.utf8-migration-logging-enabled
[utf8_migration_logging: <boolean> | default = false]

# (experimental) Enable pre-notification hooks.
# CLI flag: -alertmanager.notify-hooks-enabled
[enable_notify_hooks: <boolean> | default = false]
```

### alertmanager_storage

The `alertmanager_storage` block configures the alertmanager storage backend.

```yaml
# Backend storage to use. Supported backends are: s3, gcs, azure, swift,
# filesystem, local.
# CLI flag: -alertmanager-storage.backend
[backend: <string> | default = "filesystem"]

# The s3_backend block configures the connection to Amazon S3 object storage
# backend.
# The CLI flags prefix for this block configuration is: alertmanager-storage
[s3: <s3_storage_backend>]

# The gcs_backend block configures the connection to Google Cloud Storage object
# storage backend.
# The CLI flags prefix for this block configuration is: alertmanager-storage
[gcs: <gcs_storage_backend>]

# The azure_storage_backend block configures the connection to Azure object
# storage backend.
# The CLI flags prefix for this block configuration is: alertmanager-storage
[azure: <azure_storage_backend>]

# The swift_storage_backend block configures the connection to OpenStack Object
# Storage (Swift) object storage backend.
# The CLI flags prefix for this block configuration is: alertmanager-storage
[swift: <swift_storage_backend>]

# The filesystem_storage_backend block configures the usage of local file system
# as object storage backend.
# The CLI flags prefix for this block configuration is: alertmanager-storage
[filesystem: <filesystem_storage_backend>]

# Prefix for all objects stored in the backend storage. For simplicity, it may
# only contain digits and English alphabet letters.
# CLI flag: -alertmanager-storage.storage-prefix
[storage_prefix: <string> | default = ""]

local:
  # Path at which alertmanager configurations are stored.
  # CLI flag: -alertmanager-storage.local.path
  [path: <string> | default = ""]
```

### flusher

The `flusher` block configures the WAL flusher target, used to manually run one-time flushes when scaling down ingesters.

```yaml
# (advanced) Stop after flush has finished. If false, process will keep running,
# doing nothing.
# CLI flag: -flusher.exit-after-flush
[exit_after_flush: <boolean> | default = true]
```

### ingester_client

The `ingester_client` block configures how the distributors connect to the ingesters.

```yaml
# Configures the gRPC client used to communicate with ingesters from
# distributors, queriers and rulers.
# The CLI flags prefix for this block configuration is: ingester.client
[grpc_client_config: <grpc_client>]
```

### grpc_client

The `grpc_client` block configures the gRPC client used to communicate between two Mimir components. The supported CLI flags `<prefix>` used to reference this configuration block are:

- `ingester.client`
- `querier.frontend-client`
- `querier.scheduler-client`
- `querier.store-gateway-client`
- `query-frontend.grpc-client-config`
- `query-scheduler.grpc-client-config`
- `ruler.client`
- `ruler.query-frontend.grpc-client-config`

&nbsp;

```yaml
# (advanced) gRPC client max receive message size (bytes).
# CLI flag: -<prefix>.grpc-max-recv-msg-size
[max_recv_msg_size: <int> | default = 104857600]

# (advanced) gRPC client max send message size (bytes).
# CLI flag: -<prefix>.grpc-max-send-msg-size
[max_send_msg_size: <int> | default = 104857600]

# (advanced) Use compression when sending messages. Supported values are:
# 'gzip', 'snappy', 's2' and '' (disable compression)
# CLI flag: -<prefix>.grpc-compression
[grpc_compression: <string> | default = ""]

# (advanced) Rate limit for gRPC client; 0 means disabled.
# CLI flag: -<prefix>.grpc-client-rate-limit
[rate_limit: <float> | default = 0]

# (advanced) Rate limit burst for gRPC client.
# CLI flag: -<prefix>.grpc-client-rate-limit-burst
[rate_limit_burst: <int> | default = 0]

# (advanced) Enable backoff and retry when we hit rate limits.
# CLI flag: -<prefix>.backoff-on-ratelimits
[backoff_on_ratelimits: <boolean> | default = false]

backoff_config:
  # (advanced) Minimum delay when backing off.
  # CLI flag: -<prefix>.backoff-min-period
  [min_period: <duration> | default = 100ms]

  # (advanced) Maximum delay when backing off.
  # CLI flag: -<prefix>.backoff-max-period
  [max_period: <duration> | default = 10s]

  # (advanced) Number of times to backoff and retry before failing.
  # CLI flag: -<prefix>.backoff-retries
  [max_retries: <int> | default = 10]

# (experimental) Initial stream window size. Values less than the default are
# not supported and are ignored. Setting this to a value other than the default
# disables the BDP estimator.
# CLI flag: -<prefix>.initial-stream-window-size
[initial_stream_window_size: <int> | default = 63KiB1023B]

# (experimental) Initial connection window size. Values less than the default
# are not supported and are ignored. Setting this to a value other than the
# default disables the BDP estimator.
# CLI flag: -<prefix>.initial-connection-window-size
[initial_connection_window_size: <int> | default = 63KiB1023B]

# (advanced) Enable TLS in the gRPC client. This flag needs to be enabled when
# any other TLS flag is set. If set to false, insecure connection to gRPC server
# will be used.
# CLI flag: -<prefix>.tls-enabled
[tls_enabled: <boolean> | default = false]

# (advanced) Path to the client certificate, which will be used for
# authenticating with the server. Also requires the key path to be configured.
# CLI flag: -<prefix>.tls-cert-path
[tls_cert_path: <string> | default = ""]

# (advanced) Path to the key for the client certificate. Also requires the
# client certificate to be configured.
# CLI flag: -<prefix>.tls-key-path
[tls_key_path: <string> | default = ""]

# (advanced) Path to the CA certificates to validate server certificate against.
# If not set, the host's root CA certificates are used.
# CLI flag: -<prefix>.tls-ca-path
[tls_ca_path: <string> | default = ""]

# (advanced) Override the expected name on the server certificate.
# CLI flag: -<prefix>.tls-server-name
[tls_server_name: <string> | default = ""]

# (advanced) Skip validating server certificate.
# CLI flag: -<prefix>.tls-insecure-skip-verify
[tls_insecure_skip_verify: <boolean> | default = false]

# (advanced) Override the default cipher suite list (separated by commas).
# Allowed values:
#
# Secure Ciphers:
# - TLS_AES_128_GCM_SHA256
# - TLS_AES_256_GCM_SHA384
# - TLS_CHACHA20_POLY1305_SHA256
# - TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA
# - TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA
# - TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA
# - TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA
# - TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256
# - TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384
# - TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256
# - TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384
# - TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256
# - TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256
#
# Insecure Ciphers:
# - TLS_RSA_WITH_RC4_128_SHA
# - TLS_RSA_WITH_3DES_EDE_CBC_SHA
# - TLS_RSA_WITH_AES_128_CBC_SHA
# - TLS_RSA_WITH_AES_256_CBC_SHA
# - TLS_RSA_WITH_AES_128_CBC_SHA256
# - TLS_RSA_WITH_AES_128_GCM_SHA256
# - TLS_RSA_WITH_AES_256_GCM_SHA384
# - TLS_ECDHE_ECDSA_WITH_RC4_128_SHA
# - TLS_ECDHE_RSA_WITH_RC4_128_SHA
# - TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA
# - TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256
# - TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256
# CLI flag: -<prefix>.tls-cipher-suites
[tls_cipher_suites: <string> | default = ""]

# (advanced) Override the default minimum TLS version. Allowed values:
# VersionTLS10, VersionTLS11, VersionTLS12, VersionTLS13
# CLI flag: -<prefix>.tls-min-version
[tls_min_version: <string> | default = ""]

# (advanced) The maximum amount of time to establish a connection. A value of 0
# means default gRPC client connect timeout and backoff.
# CLI flag: -<prefix>.connect-timeout
[connect_timeout: <duration> | default = 5s]

# (advanced) Initial backoff delay after first connection failure. Only relevant
# if ConnectTimeout > 0.
# CLI flag: -<prefix>.connect-backoff-base-delay
[connect_backoff_base_delay: <duration> | default = 1s]

# (advanced) Maximum backoff delay when establishing a connection. Only relevant
# if ConnectTimeout > 0.
# CLI flag: -<prefix>.connect-backoff-max-delay
[connect_backoff_max_delay: <duration> | default = 5s]

cluster_validation:
  # (experimental) Primary cluster validation label.
  # CLI flag: -<prefix>.cluster-validation.label
  [label: <string> | default = ""]
```

### frontend_worker

The `frontend_worker` block configures the worker running within the querier, picking up and executing queries enqueued by the query-frontend or the query-scheduler.

```yaml
# Address of the query-scheduler component, in host:port format. The host should
# resolve to all query-scheduler instances. This option should be set only when
# query-scheduler component is in use and
# -query-scheduler.service-discovery-mode is set to 'dns'.
# CLI flag: -querier.scheduler-address
[scheduler_address: <string> | default = ""]

# (advanced) How often to query DNS for query-frontend or query-scheduler
# address.
# CLI flag: -querier.dns-lookup-period
[dns_lookup_duration: <duration> | default = 10s]

# (advanced) Querier ID, sent to the query-frontend to identify requests from
# the same querier. Defaults to hostname.
# CLI flag: -querier.id
[id: <string> | default = ""]

# Configures the gRPC client used to communicate between the querier and the
# query-frontend.
# The CLI flags prefix for this block configuration is: querier.frontend-client
[grpc_client_config: <grpc_client>]

# Configures the gRPC client used to communicate between the querier and the
# query-scheduler.
# The CLI flags prefix for this block configuration is: querier.scheduler-client
[query_scheduler_grpc_client_config: <grpc_client>]

# (experimental) Enables streaming of responses from querier to query-frontend
# for response types that support it (currently only `active_series` responses
# do).
# CLI flag: -querier.response-streaming-enabled
[response_streaming_enabled: <boolean> | default = false]
```

### etcd

The `etcd` block configures the etcd client. The supported CLI flags `<prefix>` used to reference this configuration block are:

- `alertmanager.sharding-ring`
- `compactor.ring`
- `distributor.ha-tracker`
- `distributor.ring`
- `ingester.partition-ring`
- `ingester.ring`
- `overrides-exporter.ring`
- `query-scheduler.ring`
- `ruler.ring`
- `store-gateway.sharding-ring`

&nbsp;

```yaml
# The etcd endpoints to connect to.
# CLI flag: -<prefix>.etcd.endpoints
[endpoints: <list of strings> | default = []]

# (advanced) The dial timeout for the etcd connection.
# CLI flag: -<prefix>.etcd.dial-timeout
[dial_timeout: <duration> | default = 10s]

# (advanced) The maximum number of retries to do for failed ops.
# CLI flag: -<prefix>.etcd.max-retries
[max_retries: <int> | default = 10]

# (advanced) Enable TLS.
# CLI flag: -<prefix>.etcd.tls-enabled
[tls_enabled: <boolean> | default = false]

# (advanced) Path to the client certificate, which will be used for
# authenticating with the server. Also requires the key path to be configured.
# CLI flag: -<prefix>.etcd.tls-cert-path
[tls_cert_path: <string> | default = ""]

# (advanced) Path to the key for the client certificate. Also requires the
# client certificate to be configured.
# CLI flag: -<prefix>.etcd.tls-key-path
[tls_key_path: <string> | default = ""]

# (advanced) Path to the CA certificates to validate server certificate against.
# If not set, the host's root CA certificates are used.
# CLI flag: -<prefix>.etcd.tls-ca-path
[tls_ca_path: <string> | default = ""]

# (advanced) Override the expected name on the server certificate.
# CLI flag: -<prefix>.etcd.tls-server-name
[tls_server_name: <string> | default = ""]

# (advanced) Skip validating server certificate.
# CLI flag: -<prefix>.etcd.tls-insecure-skip-verify
[tls_insecure_skip_verify: <boolean> | default = false]

# (advanced) Override the default cipher suite list (separated by commas).
# Allowed values:
#
# Secure Ciphers:
# - TLS_AES_128_GCM_SHA256
# - TLS_AES_256_GCM_SHA384
# - TLS_CHACHA20_POLY1305_SHA256
# - TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA
# - TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA
# - TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA
# - TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA
# - TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256
# - TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384
# - TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256
# - TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384
# - TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256
# - TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256
#
# Insecure Ciphers:
# - TLS_RSA_WITH_RC4_128_SHA
# - TLS_RSA_WITH_3DES_EDE_CBC_SHA
# - TLS_RSA_WITH_AES_128_CBC_SHA
# - TLS_RSA_WITH_AES_256_CBC_SHA
# - TLS_RSA_WITH_AES_128_CBC_SHA256
# - TLS_RSA_WITH_AES_128_GCM_SHA256
# - TLS_RSA_WITH_AES_256_GCM_SHA384
# - TLS_ECDHE_ECDSA_WITH_RC4_128_SHA
# - TLS_ECDHE_RSA_WITH_RC4_128_SHA
# - TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA
# - TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256
# - TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256
# CLI flag: -<prefix>.etcd.tls-cipher-suites
[tls_cipher_suites: <string> | default = ""]

# (advanced) Override the default minimum TLS version. Allowed values:
# VersionTLS10, VersionTLS11, VersionTLS12, VersionTLS13
# CLI flag: -<prefix>.etcd.tls-min-version
[tls_min_version: <string> | default = ""]

# Etcd username.
# CLI flag: -<prefix>.etcd.username
[username: <string> | default = ""]

# Etcd password.
# CLI flag: -<prefix>.etcd.password
[password: <string> | default = ""]
```

### consul

The `consul` block configures the consul client. The supported CLI flags `<prefix>` used to reference this configuration block are:

- `alertmanager.sharding-ring`
- `compactor.ring`
- `distributor.ha-tracker`
- `distributor.ring`
- `ingester.partition-ring`
- `ingester.ring`
- `overrides-exporter.ring`
- `query-scheduler.ring`
- `ruler.ring`
- `store-gateway.sharding-ring`

&nbsp;

```yaml
# Hostname and port of Consul.
# CLI flag: -<prefix>.consul.hostname
[host: <string> | default = "localhost:8500"]

# (advanced) ACL Token used to interact with Consul.
# CLI flag: -<prefix>.consul.acl-token
[acl_token: <string> | default = ""]

# (advanced) HTTP timeout when talking to Consul
# CLI flag: -<prefix>.consul.client-timeout
[http_client_timeout: <duration> | default = 20s]

# (advanced) Enable consistent reads to Consul.
# CLI flag: -<prefix>.consul.consistent-reads
[consistent_reads: <boolean> | default = false]

# (advanced) Rate limit when watching key or prefix in Consul, in requests per
# second. 0 disables the rate limit.
# CLI flag: -<prefix>.consul.watch-rate-limit
[watch_rate_limit: <float> | default = 1]

# (advanced) Burst size used in rate limit. Values less than 1 are treated as 1.
# CLI flag: -<prefix>.consul.watch-burst-size
[watch_burst_size: <int> | default = 1]

# (advanced) Maximum duration to wait before retrying a Compare And Swap (CAS)
# operation.
# CLI flag: -<prefix>.consul.cas-retry-delay
[cas_retry_delay: <duration> | default = 1s]
```

### memberlist

The `memberlist` block configures the Gossip memberlist.

```yaml
# (advanced) Name of the node in memberlist cluster. Defaults to hostname.
# CLI flag: -memberlist.nodename
[node_name: <string> | default = ""]

# (advanced) Add random suffix to the node name.
# CLI flag: -memberlist.randomize-node-name
[randomize_node_name: <boolean> | default = true]

# (advanced) The timeout for establishing a connection with a remote node, and
# for read/write operations.
# CLI flag: -memberlist.stream-timeout
[stream_timeout: <duration> | default = 2s]

# (advanced) Multiplication factor used when sending out messages (factor *
# log(N+1)).
# CLI flag: -memberlist.retransmit-factor
[retransmit_factor: <int> | default = 4]

# (advanced) How often to use pull/push sync.
# CLI flag: -memberlist.pullpush-interval
[pull_push_interval: <duration> | default = 30s]

# (advanced) How often to gossip.
# CLI flag: -memberlist.gossip-interval
[gossip_interval: <duration> | default = 200ms]

# (advanced) How many nodes to gossip to.
# CLI flag: -memberlist.gossip-nodes
[gossip_nodes: <int> | default = 3]

# (advanced) How long to keep gossiping to dead nodes, to give them chance to
# refute their death.
# CLI flag: -memberlist.gossip-to-dead-nodes-time
[gossip_to_dead_nodes_time: <duration> | default = 30s]

# (advanced) How soon can dead node's name be reclaimed with new address. 0 to
# disable.
# CLI flag: -memberlist.dead-node-reclaim-time
[dead_node_reclaim_time: <duration> | default = 0s]

# (advanced) Enable message compression. This can be used to reduce bandwidth
# usage at the cost of slightly more CPU utilization.
# CLI flag: -memberlist.compression-enabled
[compression_enabled: <boolean> | default = true]

# (advanced) How frequently to notify watchers when a key changes. Can reduce
# CPU activity in large memberlist deployments. 0 to notify without delay.
# CLI flag: -memberlist.notify-interval
[notify_interval: <duration> | default = 0s]

# Gossip address to advertise to other members in the cluster. Used for NAT
# traversal.
# CLI flag: -memberlist.advertise-addr
[advertise_addr: <string> | default = ""]

# Gossip port to advertise to other members in the cluster. Used for NAT
# traversal.
# CLI flag: -memberlist.advertise-port
[advertise_port: <int> | default = 7946]

# (advanced) The cluster label is an optional string to include in outbound
# packets and gossip streams. Other members in the memberlist cluster will
# discard any message whose label doesn't match the configured one, unless the
# 'cluster-label-verification-disabled' configuration option is set to true.
# CLI flag: -memberlist.cluster-label
[cluster_label: <string> | default = ""]

# (advanced) When true, memberlist doesn't verify that inbound packets and
# gossip streams have the cluster label matching the configured one. This
# verification should be disabled while rolling out the change to the configured
# cluster label in a live memberlist cluster.
# CLI flag: -memberlist.cluster-label-verification-disabled
[cluster_label_verification_disabled: <boolean> | default = false]

# Other cluster members to join. Can be specified multiple times. It can be an
# IP, hostname or an entry specified in the DNS Service Discovery format.
# CLI flag: -memberlist.join
[join_members: <list of strings> | default = []]

# (advanced) Min backoff duration to join other cluster members.
# CLI flag: -memberlist.min-join-backoff
[min_join_backoff: <duration> | default = 1s]

# (advanced) Max backoff duration to join other cluster members.
# CLI flag: -memberlist.max-join-backoff
[max_join_backoff: <duration> | default = 1m]

# (advanced) Max number of retries to join other cluster members.
# CLI flag: -memberlist.max-join-retries
[max_join_retries: <int> | default = 10]

# (advanced) Abort if this node fails the fast memberlist cluster joining
# procedure at startup. When enabled, it's guaranteed that other services,
# depending on memberlist, have an updated view over the cluster state when
# they're started.
# CLI flag: -memberlist.abort-if-fast-join-fails
[abort_if_cluster_fast_join_fails: <boolean> | default = false]

# Abort if this node fails to join memberlist cluster at startup. When enabled,
# it's not guaranteed that other services are started only after the cluster
# state has been successfully updated; use 'abort-if-fast-join-fails' instead.
# CLI flag: -memberlist.abort-if-join-fails
[abort_if_cluster_join_fails: <boolean> | default = false]

# (advanced) If not 0, how often to rejoin the cluster. Occasional rejoin can
# help to fix the cluster split issue, and is harmless otherwise. For example
# when using only few components as a seed nodes (via -memberlist.join), then
# it's recommended to use rejoin. If -memberlist.join points to dynamic service
# that resolves to all gossiping nodes (eg. Kubernetes headless service), then
# rejoin is not needed.
# CLI flag: -memberlist.rejoin-interval
[rejoin_interval: <duration> | default = 0s]

# (advanced) How long to keep LEFT ingesters in the ring.
# CLI flag: -memberlist.left-ingesters-timeout
[left_ingesters_timeout: <duration> | default = 5m]

# (experimental) How long to keep obsolete entries in the KV store.
# CLI flag: -memberlist.obsolete-entries-timeout
[obsolete_entries_timeout: <duration> | default = 30s]

# (advanced) Timeout for leaving memberlist cluster.
# CLI flag: -memberlist.leave-timeout
[leave_timeout: <duration> | default = 20s]

# (advanced) Timeout for broadcasting all remaining locally-generated updates to
# other nodes when shutting down. Only used if there are nodes left in the
# memberlist cluster, and only applies to locally-generated updates, not to
# broadcast messages that are result of incoming gossip updates. 0 = no timeout,
# wait until all locally-generated updates are sent.
# CLI flag: -memberlist.broadcast-timeout-for-local-updates-on-shutdown
[broadcast_timeout_for_local_updates_on_shutdown: <duration> | default = 10s]

# (advanced) How much space to use for keeping received and sent messages in
# memory for troubleshooting (two buffers). 0 to disable.
# CLI flag: -memberlist.message-history-buffer-bytes
[message_history_buffer_bytes: <int> | default = 0]

# (advanced) Size of the buffered channel for the WatchPrefix function.
# CLI flag: -memberlist.watch-prefix-buffer-size
[watch_prefix_buffer_size: <int> | default = 128]

# IP address to listen on for gossip messages. Multiple addresses may be
# specified. Defaults to 0.0.0.0
# CLI flag: -memberlist.bind-addr
[bind_addr: <list of strings> | default = []]

# Port to listen on for gossip messages.
# CLI flag: -memberlist.bind-port
[bind_port: <int> | default = 7946]

# (advanced) Timeout used when connecting to other nodes to send packet.
# CLI flag: -memberlist.packet-dial-timeout
[packet_dial_timeout: <duration> | default = 500ms]

# (advanced) Timeout for writing 'packet' data.
# CLI flag: -memberlist.packet-write-timeout
[packet_write_timeout: <duration> | default = 500ms]

# (advanced) Maximum number of concurrent writes to other nodes.
# CLI flag: -memberlist.max-concurrent-writes
[max_concurrent_writes: <int> | default = 5]

# (advanced) Timeout for acquiring one of the concurrent write slots. After this
# time, the message will be dropped.
# CLI flag: -memberlist.acquire-writer-timeout
[acquire_writer_timeout: <duration> | default = 1s]

# (advanced) Enable TLS on the memberlist transport layer.
# CLI flag: -memberlist.tls-enabled
[tls_enabled: <boolean> | default = false]

# (advanced) Path to the client certificate, which will be used for
# authenticating with the server. Also requires the key path to be configured.
# CLI flag: -memberlist.tls-cert-path
[tls_cert_path: <string> | default = ""]

# (advanced) Path to the key for the client certificate. Also requires the
# client certificate to be configured.
# CLI flag: -memberlist.tls-key-path
[tls_key_path: <string> | default = ""]

# (advanced) Path to the CA certificates to validate server certificate against.
# If not set, the host's root CA certificates are used.
# CLI flag: -memberlist.tls-ca-path
[tls_ca_path: <string> | default = ""]

# (advanced) Override the expected name on the server certificate.
# CLI flag: -memberlist.tls-server-name
[tls_server_name: <string> | default = ""]

# (advanced) Skip validating server certificate.
# CLI flag: -memberlist.tls-insecure-skip-verify
[tls_insecure_skip_verify: <boolean> | default = false]

# (advanced) Override the default cipher suite list (separated by commas).
# Allowed values:
#
# Secure Ciphers:
# - TLS_AES_128_GCM_SHA256
# - TLS_AES_256_GCM_SHA384
# - TLS_CHACHA20_POLY1305_SHA256
# - TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA
# - TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA
# - TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA
# - TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA
# - TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256
# - TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384
# - TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256
# - TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384
# - TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256
# - TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256
#
# Insecure Ciphers:
# - TLS_RSA_WITH_RC4_128_SHA
# - TLS_RSA_WITH_3DES_EDE_CBC_SHA
# - TLS_RSA_WITH_AES_128_CBC_SHA
# - TLS_RSA_WITH_AES_256_CBC_SHA
# - TLS_RSA_WITH_AES_128_CBC_SHA256
# - TLS_RSA_WITH_AES_128_GCM_SHA256
# - TLS_RSA_WITH_AES_256_GCM_SHA384
# - TLS_ECDHE_ECDSA_WITH_RC4_128_SHA
# - TLS_ECDHE_RSA_WITH_RC4_128_SHA
# - TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA
# - TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256
# - TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256
# CLI flag: -memberlist.tls-cipher-suites
[tls_cipher_suites: <string> | default = ""]

# (advanced) Override the default minimum TLS version. Allowed values:
# VersionTLS10, VersionTLS11, VersionTLS12, VersionTLS13
# CLI flag: -memberlist.tls-min-version
[tls_min_version: <string> | default = ""]
```

### limits

The `limits` block configures default and per-tenant limits imposed by components.

```yaml
# Maximum number of active series per user. 0 means no limit. This limit only
# applies with ingest storage enabled.
# CLI flag: -distributor.max-active-series-per-user
[max_active_series_per_user: <int> | default = 0]

# Per-tenant push request rate limit in requests per second. 0 to disable.
# CLI flag: -distributor.request-rate-limit
[request_rate: <float> | default = 0]

# Per-tenant allowed push request burst size. 0 to disable.
# CLI flag: -distributor.request-burst-size
[request_burst_size: <int> | default = 0]

# Per-tenant ingestion rate limit in samples per second.
# CLI flag: -distributor.ingestion-rate-limit
[ingestion_rate: <float> | default = 10000]

# Per-tenant allowed ingestion burst size (in number of samples).
# CLI flag: -distributor.ingestion-burst-size
[ingestion_burst_size: <int> | default = 200000]

# (experimental) Per-tenant burst factor which is the maximum burst size allowed
# as a multiple of the per-tenant ingestion rate, this burst-factor must be
# greater than or equal to 1. If this is set it will override the
# ingestion-burst-size option.
# CLI flag: -distributor.ingestion-burst-factor
[ingestion_burst_factor: <float> | default = 0]

# Flag to enable, for all tenants, handling of samples with external labels
# identifying replicas in an HA Prometheus setup.
# CLI flag: -distributor.ha-tracker.enable-for-all-users
[accept_ha_samples: <boolean> | default = false]

# Prometheus label to look for in samples to identify a Prometheus HA cluster.
# CLI flag: -distributor.ha-tracker.cluster
[ha_cluster_label: <string> | default = "cluster"]

# Prometheus label to look for in samples to identify a Prometheus HA replica.
# CLI flag: -distributor.ha-tracker.replica
[ha_replica_label: <string> | default = "__replica__"]

# Maximum number of clusters that HA tracker will keep track of for a single
# tenant. 0 to disable the limit.
# CLI flag: -distributor.ha-tracker.max-clusters
[ha_max_clusters: <int> | default = 100]

# (advanced) Update the timestamp in the KV store for a given cluster/replica
# only after this amount of time has passed since the current stored timestamp.
# CLI flag: -distributor.ha-tracker.update-timeout
[ha_tracker_update_timeout: <duration> | default = 15s]

# (advanced) Maximum jitter applied to the update timeout, in order to spread
# the HA heartbeats over time.
# CLI flag: -distributor.ha-tracker.update-timeout-jitter-max
[ha_tracker_update_timeout_jitter_max: <duration> | default = 5s]

# (advanced) If we don't receive any samples from the accepted replica for a
# cluster in this amount of time we will failover to the next replica we receive
# a sample from. This value must be greater than the update timeout.
# CLI flag: -distributor.ha-tracker.failover-timeout
[ha_tracker_failover_timeout: <duration> | default = 30s]

# (advanced) Additional timeout to use for failover that uses the earliest
# sample time instead of the current time. Defaults to 0, which is disabled.
# This is useful to prevent samples from being too close together during
# failover when write requests are delayed so that the sample time is earlier
# than the current time.
# CLI flag: -distributor.ha-tracker.failover-sample-timeout
[ha_tracker_sample_failover_timeout: <duration> | default = 0s]

# (advanced) This flag can be used to specify label names that to drop during
# sample ingestion within the distributor and can be repeated in order to drop
# multiple labels.
# CLI flag: -distributor.drop-label
[drop_labels: <list of strings> | default = []]

# Maximum length accepted for label names
# CLI flag: -validation.max-length-label-name
[max_label_name_length: <int> | default = 1024]

# Maximum length accepted for label value. This setting also applies to the
# metric name
# CLI flag: -validation.max-length-label-value
[max_label_value_length: <int> | default = 2048]

# (experimental) What to do for label values over the length limit. Options are:
# 'error', 'truncate', 'drop'. For 'truncate', the hash of the full value
# replaces the end portion of the value. For 'drop', the hash fully replaces the
# value.
# CLI flag: -validation.label-value-length-over-limit-strategy
[label_value_length_over_limit_strategy: <string> | default = "error"]

# Maximum number of label names per series.
# CLI flag: -validation.max-label-names-per-series
[max_label_names_per_series: <int> | default = 30]

# Maximum number of label names per info series. Has no effect if less than the
# value of the maximum number of label names per series option
# (-validation.max-label-names-per-series)
# CLI flag: -validation.max-label-names-per-info-series
[max_label_names_per_info_series: <int> | default = 80]

# Maximum length accepted for metric metadata. Metadata refers to Metric Name,
# HELP and UNIT. Longer metadata is dropped except for HELP which is truncated.
# CLI flag: -validation.max-metadata-length
[max_metadata_length: <int> | default = 1024]

# Maximum number of buckets per native histogram sample. 0 to disable the limit.
# CLI flag: -validation.max-native-histogram-buckets
[max_native_histogram_buckets: <int> | default = 0]

# (experimental) Maximum number of exemplars per series per request. 0 to
# disable limit in request. The exceeding exemplars are dropped.
# CLI flag: -distributor.max-exemplars-per-series-per-request
[max_exemplars_per_series_per_request: <int> | default = 0]

# Whether to reduce or reject native histogram samples with more buckets than
# the configured limit.
# CLI flag: -validation.reduce-native-histogram-over-max-buckets
[reduce_native_histogram_over_max_buckets: <boolean> | default = true]

# (advanced) Controls how far into the future incoming samples and exemplars are
# accepted compared to the wall clock. Any sample or exemplar will be rejected
# if its timestamp is greater than '(now + creation_grace_period)'. This
# configuration is enforced in the distributor and ingester.
# CLI flag: -validation.create-grace-period
[creation_grace_period: <duration> | default = 10m]

# (advanced) Controls how far into the past incoming samples and exemplars are
# accepted compared to the wall clock. Any sample or exemplar will be rejected
# if its timestamp is lower than '(now - OOO window - past_grace_period)'. This
# configuration is enforced in the distributor and ingester. 0 to disable.
# CLI flag: -validation.past-grace-period
[past_grace_period: <duration> | default = 0s]

# (advanced) Enforce every metadata has a metric name.
# CLI flag: -validation.enforce-metadata-metric-name
[enforce_metadata_metric_name: <boolean> | default = true]

# The tenant's shard size used by shuffle-sharding. This value is the total size
# of the shard (ie. it is not the number of ingesters in the shard per zone, but
# the number of ingesters in the shard across all zones, if zone-awareness is
# enabled). Must be set both on ingesters and distributors. 0 disables shuffle
# sharding.
# CLI flag: -distributor.ingestion-tenant-shard-size
[ingestion_tenant_shard_size: <int> | default = 0]

# (experimental) List of metric relabel configurations. Note that in most
# situations, it is more effective to use metrics relabeling directly in the
# Prometheus server, e.g. remote_write.write_relabel_configs. Labels available
# during the relabeling phase and cleaned afterwards: __meta_tenant_id
[metric_relabel_configs: <relabel_config...> | default = ]

# (experimental) Enable metric relabeling for the tenant. This configuration
# option can be used to forcefully disable metric relabeling on a per-tenant
# basis.
# CLI flag: -distributor.metric-relabeling-enabled
[metric_relabeling_enabled: <boolean> | default = true]

# The maximum number of in-memory series per tenant, across the cluster before
# replication. 0 to disable.
# CLI flag: -ingester.max-global-series-per-user
[max_global_series_per_user: <int> | default = 150000]

# The maximum number of in-memory series per metric name, across the cluster
# before replication. 0 to disable.
# CLI flag: -ingester.max-global-series-per-metric
[max_global_series_per_metric: <int> | default = 0]

# The maximum number of in-memory metrics with metadata per tenant, across the
# cluster. 0 to disable.
# CLI flag: -ingester.max-global-metadata-per-user
[max_global_metadata_per_user: <int> | default = 0]

# The maximum number of metadata per metric, across the cluster. 0 to disable.
# CLI flag: -ingester.max-global-metadata-per-metric
[max_global_metadata_per_metric: <int> | default = 0]

# (experimental) The maximum number of exemplars in memory, across the cluster.
# 0 to disable exemplars ingestion.
# CLI flag: -ingester.max-global-exemplars-per-user
[max_global_exemplars_per_user: <int> | default = 0]

# (experimental) Whether to ignore exemplars with out-of-order timestamps. If
# enabled, exemplars with out-of-order timestamps are silently dropped,
# otherwise they cause partial errors.
# CLI flag: -ingester.ignore-ooo-exemplars
[ignore_ooo_exemplars: <boolean> | default = false]

# (experimental) Enable ingestion of native histogram samples. If false, native
# histogram samples are ignored without an error. To query native histograms
# with query-sharding enabled make sure to set
# -query-frontend.query-result-response-format to 'protobuf'.
# CLI flag: -ingester.native-histograms-ingestion-enabled
[native_histograms_ingestion_enabled: <boolean> | default = true]

# (advanced) Custom trackers for active metrics. If there are active series
# matching a provided matcher (map value), the count is exposed in the custom
# trackers metric labeled using the tracker name (map key). Zero-valued counts
# are not exposed and are removed when they go back to zero.
# Example:
#   The following configuration counts the active series coming from dev and
#   prod namespaces for each tenant and labels them as {name="dev"} and
#   {name="prod"} in the cortex_ingester_active_series_custom_tracker metric.
#   active_series_custom_trackers:
#       dev: '{namespace=~"dev-.*"}'
#       prod: '{namespace=~"prod-.*"}'
# CLI flag: -ingester.active-series-custom-trackers
[active_series_custom_trackers: <map of tracker name (string) to matcher (string)> | default = ]

# (advanced) Additional custom trackers for active metrics merged on top of the
# base custom trackers. You can use this configuration option to define the base
# custom trackers globally for all tenants, and then use the additional trackers
# to add extra trackers on a per-tenant basis.
# Example:
#   The following configuration counts the active series coming from dev and
#   prod namespaces for each tenant and labels them as {name="dev"} and
#   {name="prod"} in the cortex_ingester_active_series_custom_tracker metric.
#   active_series_additional_custom_trackers:
#       dev: '{namespace=~"dev-.*"}'
#       prod: '{namespace=~"prod-.*"}'
[active_series_additional_custom_trackers: <map of tracker name (string) to matcher (string)> | default = ]

# (experimental) Non-zero value enables out-of-order support for most recent
# samples that are within the time window in relation to the TSDB's maximum
# time, i.e., within [db.maxTime-timeWindow, db.maxTime]). The ingester will
# need more memory as a factor of rate of out-of-order samples being ingested
# and the number of series that are getting out-of-order samples. If query falls
# into this window, cached results will use value from
# -query-frontend.results-cache-ttl-for-out-of-order-time-window option to
# specify TTL for resulting cache entry.
# CLI flag: -ingester.out-of-order-time-window
[out_of_order_time_window: <duration> | default = 0s]

# (experimental) Whether the shipper should label out-of-order blocks with an
# external label before uploading them. Setting this label will compact
# out-of-order blocks separately from non-out-of-order blocks
# CLI flag: -ingester.out-of-order-blocks-external-label-enabled
[out_of_order_blocks_external_label_enabled: <boolean> | default = false]

# (experimental) Label used to define the group label for metrics separation.
# For each write request, the group is obtained from the first non-empty group
# label from the first timeseries in the incoming list of timeseries. Specific
# distributor and ingester metrics will be further separated adding a 'group'
# label with group label's value. Currently applies to the following metrics:
# cortex_discarded_samples_total
# CLI flag: -validation.separate-metrics-group-label
[separate_metrics_group_label: <string> | default = ""]

# Maximum number of chunks that can be fetched in a single query from ingesters
# and store-gateways. This limit is enforced in the querier, ruler and
# store-gateway. 0 to disable.
# CLI flag: -querier.max-fetched-chunks-per-query
[max_fetched_chunks_per_query: <int> | default = 2000000]

# (experimental) Maximum number of chunks estimated to be fetched in a single
# query from ingesters and store-gateways, as a multiple of
# -querier.max-fetched-chunks-per-query. This limit is enforced in the querier.
# Must be greater than or equal to 1, or 0 to disable.
# CLI flag: -querier.max-estimated-fetched-chunks-per-query-multiplier
[max_estimated_fetched_chunks_per_query_multiplier: <float> | default = 0]

# The maximum number of unique series for which a query can fetch samples from
# ingesters and store-gateways. This limit is enforced in the querier, ruler and
# store-gateway. 0 to disable
# CLI flag: -querier.max-fetched-series-per-query
[max_fetched_series_per_query: <int> | default = 0]

# The maximum size of all chunks in bytes that a query can fetch from ingesters
# and store-gateways. This limit is enforced in the querier and ruler. 0 to
# disable.
# CLI flag: -querier.max-fetched-chunk-bytes-per-query
[max_fetched_chunk_bytes_per_query: <int> | default = 0]

# (experimental) The maximum estimated memory a single query can consume at
# once, in bytes. This limit is only enforced when Mimir's query engine is in
# use. This limit is enforced in the querier. 0 to disable.
# CLI flag: -querier.max-estimated-memory-consumption-per-query
[max_estimated_memory_consumption_per_query: <int> | default = 0]

# Limit how long back data (series and metadata) can be queried, up until
# <lookback> duration ago. This limit is enforced in the query-frontend, querier
# and ruler for instant, range and remote read queries. For metadata queries
# like series, label names, label values queries the limit is enforced in the
# querier and ruler. If the requested time range is outside the allowed range,
# the request will not fail but will be manipulated to only query data within
# the allowed time range. 0 to disable.
# CLI flag: -querier.max-query-lookback
[max_query_lookback: <duration> | default = 0s]

# Limit the time range for partial queries at the querier level.
# CLI flag: -querier.max-partial-query-length
[max_partial_query_length: <duration> | default = 0s]

# Maximum number of split (by time) or partial (by shard) queries that will be
# scheduled in parallel by the query-frontend for a single input query. This
# limit is introduced to have a fairer query scheduling and avoid a single query
# over a large time range saturating all available queriers.
# CLI flag: -querier.max-query-parallelism
[max_query_parallelism: <int> | default = 14]

# Limit the time range (end - start time) of series, label names and values
# queries. This limit is enforced in the querier. If the requested time range is
# outside the allowed range, the request will not fail but will be manipulated
# to only query data within the allowed time range. 0 to disable.
# CLI flag: -store.max-labels-query-length
[max_labels_query_length: <duration> | default = 0s]

# Maximum number of series, the series endpoint queries. This limit is enforced
# in the querier. If the requested limit is outside of the allowed value, the
# request doesn't fail, but is manipulated to only query data up to the allowed
# limit. Set to 0 to disable.
# CLI flag: -querier.max-series-query-limit
[max_series_query_limit: <int> | default = 0]

# (advanced) Most recent allowed cacheable result per-tenant, to prevent caching
# very recent results that might still be in flux.
# CLI flag: -query-frontend.max-cache-freshness
[max_cache_freshness: <duration> | default = 10m]

# Maximum number of queriers that can handle requests for a single tenant. If
# set to 0 or value higher than number of available queriers, *all* queriers
# will handle requests for the tenant. Each frontend (or query-scheduler, if
# used) will select the same set of queriers for the same tenant (given that all
# queriers are connected to all frontends / query-schedulers). This option only
# works with queriers connecting to the query-frontend / query-scheduler, not
# when using downstream URL.
# CLI flag: -query-frontend.max-queriers-per-tenant
[max_queriers_per_tenant: <int> | default = 0]

# The amount of shards to use when doing parallelisation via query sharding by
# tenant. 0 to disable query sharding for tenant. Query sharding implementation
# will adjust the number of query shards based on compactor shards. This allows
# querier to not search the blocks which cannot possibly have the series for
# given query shard.
# CLI flag: -query-frontend.query-sharding-total-shards
[query_sharding_total_shards: <int> | default = 16]

# The max number of sharded queries that can be run for a given received query.
# 0 to disable limit.
# CLI flag: -query-frontend.query-sharding-max-sharded-queries
[query_sharding_max_sharded_queries: <int> | default = 128]

# Disable query sharding for any query containing a regular expression matcher
# longer than the configured number of bytes. 0 to disable the limit.
# CLI flag: -query-frontend.query-sharding-max-regexp-size-bytes
[query_sharding_max_regexp_size_bytes: <int> | default = 4096]

# (advanced) Maximum lookback beyond which queries are not sent to ingester. 0
# means all queries are sent to ingester.
# CLI flag: -querier.query-ingesters-within
[query_ingesters_within: <duration> | default = 13h]

# Limit the total query time range (end - start time). This limit is enforced in
# the query-frontend on the received instant, range or remote read query.
# CLI flag: -query-frontend.max-total-query-length
[max_total_query_length: <duration> | default = 0s]

# Time to live duration for cached query results. If query falls into
# out-of-order time window,
# -query-frontend.results-cache-ttl-for-out-of-order-time-window is used
# instead.
# CLI flag: -query-frontend.results-cache-ttl
[results_cache_ttl: <duration> | default = 1w]

# Time to live duration for cached query results if query falls into
# out-of-order time window. This is lower than -query-frontend.results-cache-ttl
# so that incoming out-of-order samples are returned in the query results
# sooner.
# CLI flag: -query-frontend.results-cache-ttl-for-out-of-order-time-window
[results_cache_ttl_for_out_of_order_time_window: <duration> | default = 10m]

# Time to live duration for cached cardinality query results. The value 0
# disables the cache.
# CLI flag: -query-frontend.results-cache-ttl-for-cardinality-query
[results_cache_ttl_for_cardinality_query: <duration> | default = 0s]

# Time to live duration for cached label names and label values query results.
# The value 0 disables the cache.
# CLI flag: -query-frontend.results-cache-ttl-for-labels-query
[results_cache_ttl_for_labels_query: <duration> | default = 0s]

# Time to live duration for cached non-transient errors
# CLI flag: -query-frontend.results-cache-ttl-for-errors
[results_cache_ttl_for_errors: <duration> | default = 5m]

# (advanced) Cache requests that are not step-aligned.
# CLI flag: -query-frontend.cache-unaligned-requests
[cache_unaligned_requests: <boolean> | default = false]

# Max size of the raw query, in bytes. This limit is enforced by the
# query-frontend for instant, range and remote read queries. 0 to not apply a
# limit to the size of the query.
# CLI flag: -query-frontend.max-query-expression-size-bytes
[max_query_expression_size_bytes: <int> | default = 0]

# (experimental) List of queries to block.
# Example:
#   The following configuration blocks the query "rate(metric_counter[5m])".
#   Setting the pattern to ".*" and regex to true blocks all queries.
#   blocked_queries:
#       - pattern: rate(metric_counter[5m])
#         regex: false
#         reason: because the query is misconfigured
blocked_queries:
  - # PromQL expression pattern to match.
    [pattern: <string> | default = ""]

    # If true, the pattern is treated as a regular expression. If false, the
    # pattern is treated as a literal match.
    [regex: <boolean> | default = ]

    # Reason returned to clients when rejecting matching queries.
    [reason: <string> | default = ""]

# (experimental) List of queries to limit and duration to limit them for.
# Example:
#   The following configuration limits the query "rate(metric_counter[5m])" to
#   running, at most, every minute.
#   limited_queries:
#       - query: rate(metric_counter[5m])
#         allowed_frequency: 1m0s
limited_queries:
  - # Literal PromQL expression to match.
    [query: <string> | default = ""]

    # Minimum duration between matching queries. If a matching query arrives
    # more often than this, it is rejected.
    [allowed_frequency: <duration> | default = ]

# (experimental) List of HTTP requests to block.
# Example:
#   The following configuration blocks all GET requests to /foo when the "limit"
#   parameter is set to 100.
#   blocked_requests:
#       - path: /foo
#         method: GET
#         query_params:
#           limit:
#               value: "100"
blocked_requests:
  - # Path to match, including leading slash (/). Leave blank to match all paths.
    [path: <string> | default = ""]

    # HTTP method to match. Leave blank to match all methods.
    [method: <string> | default = ""]

    # Query parameters to match. Requests must have all of the provided query
    # parameters to be considered a match.
    [query_params:]
      <string>:
        # Value to match.
        [value: <string> | default = ""]

        # If true, the value is treated as a regular expression. If false, the
        # value is treated as a literal match.
        [is_regexp: <boolean> | default = ]

# Mutate incoming queries to align their start and end with their step to
# improve result caching.
# CLI flag: -query-frontend.align-queries-with-step
[align_queries_with_step: <boolean> | default = false]

# Enable certain experimental PromQL functions, which are subject to being
# changed or removed at any time, on a per-tenant basis. Defaults to empty which
# means all experimental functions are disabled. Set to 'all' to enable all
# experimental functions.
# CLI flag: -query-frontend.enabled-promql-experimental-functions
[enabled_promql_experimental_functions: <string> | default = ""]

# (experimental) Rewrite queries using the same range selector and resolution
# [X:X] which don't work in Prometheus 3.0 to a nearly identical form that works
# with Prometheus 3.0 semantics
# CLI flag: -query-frontend.prom2-range-compat
[prom2_range_compat: <boolean> | default = false]

# (experimental) Enable spinning off subqueries from instant queries as range
# queries to optimize their performance.
# CLI flag: -query-frontend.subquery-spin-off-enabled
[subquery_spin_off_enabled: <boolean> | default = false]

# (advanced) Enable labels query optimizations. When enabled, the query-frontend
# may rewrite labels queries to improve their performance.
# CLI flag: -query-frontend.labels-query-optimizer-enabled
[labels_query_optimizer_enabled: <boolean> | default = true]

# Enables endpoints used for cardinality analysis.
# CLI flag: -querier.cardinality-analysis-enabled
[cardinality_analysis_enabled: <boolean> | default = false]

# Maximum size in bytes of distinct label names and values. When querier
# receives response from ingester, it merges the response with responses from
# other ingesters. This maximum size limit is applied to the merged(distinct)
# results. If the limit is reached, an error is returned.
# CLI flag: -querier.label-names-and-values-results-max-size-bytes
[label_names_and_values_results_max_size_bytes: <int> | default = 419430400]

# Maximum number of label names allowed to be queried in a single
# /api/v1/cardinality/label_values API call.
# CLI flag: -querier.label-values-max-cardinality-label-names-per-request
[label_values_max_cardinality_label_names_per_request: <int> | default = 100]

# (experimental) Maximum number of series that can be requested in a single
# cardinality API request.
# CLI flag: -querier.cardinality-api-max-series-limit
[cardinality_analysis_max_results: <int> | default = 500]

# (experimental) Maximum size of an active series or active native histogram
# series request result shard in bytes. 0 to disable.
# CLI flag: -querier.active-series-results-max-size-bytes
[active_series_results_max_size_bytes: <int> | default = 419430400]

# (experimental)
[cost_attribution_labels: <string> | default = ""]

# (experimental)
cost_attribution_labels_structured:
  -     [input: <string> | default = ""]

    [output: <string> | default = ""]

# (experimental) Maximum cardinality of cost attribution labels allowed per
# user.
# CLI flag: -validation.max-cost-attribution-cardinality
[max_cost_attribution_cardinality: <int> | default = 2000]

# (experimental) Defines how long cost attribution stays in overflow before
# attempting a reset, with received/discarded samples extending the cooldown if
# overflow persists, while active series reset and restart tracking after the
# cooldown.
# CLI flag: -validation.cost-attribution-cooldown
[cost_attribution_cooldown: <duration> | default = 0s]

# Duration to delay the evaluation of rules to ensure the underlying metrics
# have been pushed.
# CLI flag: -ruler.evaluation-delay-duration
[ruler_evaluation_delay_duration: <duration> | default = 1m]

# (experimental) The maximum tolerated ingestion delay for eventually consistent
# rule evaluations. Set to 0 to disable the enforcement.
# CLI flag: -ruler.evaluation-consistency-max-delay
[ruler_evaluation_consistency_max_delay: <duration> | default = 0s]

# The tenant's shard size when sharding is used by ruler. Value of 0 disables
# shuffle sharding for the tenant, and tenant rules will be sharded across all
# ruler replicas.
# CLI flag: -ruler.tenant-shard-size
[ruler_tenant_shard_size: <int> | default = 0]

# Maximum number of rules per rule group per-tenant. 0 to disable.
# CLI flag: -ruler.max-rules-per-rule-group
[ruler_max_rules_per_rule_group: <int> | default = 20]

# Maximum number of rule groups per-tenant. 0 to disable.
# CLI flag: -ruler.max-rule-groups-per-tenant
[ruler_max_rule_groups_per_tenant: <int> | default = 70]

# Controls whether recording rules evaluation is enabled. This configuration
# option can be used to forcefully disable recording rules evaluation on a
# per-tenant basis.
# CLI flag: -ruler.recording-rules-evaluation-enabled
[ruler_recording_rules_evaluation_enabled: <boolean> | default = true]

# Controls whether alerting rules evaluation is enabled. This configuration
# option can be used to forcefully disable alerting rules evaluation on a
# per-tenant basis.
# CLI flag: -ruler.alerting-rules-evaluation-enabled
[ruler_alerting_rules_evaluation_enabled: <boolean> | default = true]

# (advanced) True to enable a re-sync of the configured rule groups as soon as
# they're changed via ruler's config API. This re-sync is in addition of the
# periodic syncing. When enabled, it may take up to few tens of seconds before a
# configuration change triggers the re-sync.
# CLI flag: -ruler.sync-rules-on-changes-enabled
[ruler_sync_rules_on_changes_enabled: <boolean> | default = true]

# (experimental) Maximum number of rules per rule group by namespace. Value is a
# map, where each key is the namespace and value is the number of rules allowed
# in the namespace (int). On the command line, this map is given in a JSON
# format. The number of rules specified has the same meaning as
# -ruler.max-rules-per-rule-group, but only applies for the specific namespace.
# If specified, it supersedes -ruler.max-rules-per-rule-group.
# CLI flag: -ruler.max-rules-per-rule-group-by-namespace
[ruler_max_rules_per_rule_group_by_namespace: <map of string to int> | default = {}]

# (experimental) Maximum number of rule groups per tenant by namespace. Value is
# a map, where each key is the namespace and value is the number of rule groups
# allowed in the namespace (int). On the command line, this map is given in a
# JSON format. The number of rule groups specified has the same meaning as
# -ruler.max-rule-groups-per-tenant, but only applies for the specific
# namespace. If specified, it supersedes -ruler.max-rule-groups-per-tenant.
# CLI flag: -ruler.max-rule-groups-per-tenant-by-namespace
[ruler_max_rule_groups_per_tenant_by_namespace: <map of string to int> | default = {}]

# (experimental) List of namespaces that are protected from modification unless
# a special HTTP header is used. If a namespace is protected, it can only be
# read, not modified via the ruler's configuration API. The value is a list of
# strings, where each string is a namespace name. On the command line, this list
# is given as a comma-separated list.
# CLI flag: -ruler.protected-namespaces
[ruler_protected_namespaces: <string> | default = ""]

# (experimental) Maximum number of independent rules that can run concurrently
# for each tenant. Depends on ruler.max-independent-rule-evaluation-concurrency
# being greater than 0. Ideally this flag should be a lower value. 0 to disable.
# CLI flag: -ruler.max-independent-rule-evaluation-concurrency-per-tenant
[ruler_max_independent_rule_evaluation_concurrency_per_tenant: <int> | default = 4]

# Per-tenant Alertmanager client configuration. If not supplied, the tenant's
# notifications are sent to the ruler-wide default.
ruler_alertmanager_client_config:
  # Comma-separated list of URL(s) of the Alertmanager(s) to send notifications
  # to. Each URL is treated as a separate group. Multiple Alertmanagers in HA
  # per group can be supported by using DNS service discovery format,
  # comprehensive of the scheme. Basic auth is supported as part of the URL.
  # CLI flag: -ruler.alertmanager-url
  [alertmanager_url: <string> | default = ""]

  # (advanced) Enable TLS for gRPC client connecting to alertmanager.
  # CLI flag: -ruler.alertmanager-client.tls-enabled
  [tls_enabled: <boolean> | default = true]

  # (advanced) Path to the client certificate, which will be used for
  # authenticating with the server. Also requires the key path to be configured.
  # CLI flag: -ruler.alertmanager-client.tls-cert-path
  [tls_cert_path: <string> | default = ""]

  # (advanced) Path to the key for the client certificate. Also requires the
  # client certificate to be configured.
  # CLI flag: -ruler.alertmanager-client.tls-key-path
  [tls_key_path: <string> | default = ""]

  # (advanced) Path to the CA certificates to validate server certificate
  # against. If not set, the host's root CA certificates are used.
  # CLI flag: -ruler.alertmanager-client.tls-ca-path
  [tls_ca_path: <string> | default = ""]

  # (advanced) Override the expected name on the server certificate.
  # CLI flag: -ruler.alertmanager-client.tls-server-name
  [tls_server_name: <string> | default = ""]

  # (advanced) Skip validating server certificate.
  # CLI flag: -ruler.alertmanager-client.tls-insecure-skip-verify
  [tls_insecure_skip_verify: <boolean> | default = false]

  # (advanced) Override the default cipher suite list (separated by commas).
  # Allowed values:
  #
  # Secure Ciphers:
  # - TLS_AES_128_GCM_SHA256
  # - TLS_AES_256_GCM_SHA384
  # - TLS_CHACHA20_POLY1305_SHA256
  # - TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA
  # - TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA
  # - TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA
  # - TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA
  # - TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256
  # - TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384
  # - TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256
  # - TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384
  # - TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256
  # - TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256
  #
  # Insecure Ciphers:
  # - TLS_RSA_WITH_RC4_128_SHA
  # - TLS_RSA_WITH_3DES_EDE_CBC_SHA
  # - TLS_RSA_WITH_AES_128_CBC_SHA
  # - TLS_RSA_WITH_AES_256_CBC_SHA
  # - TLS_RSA_WITH_AES_128_CBC_SHA256
  # - TLS_RSA_WITH_AES_128_GCM_SHA256
  # - TLS_RSA_WITH_AES_256_GCM_SHA384
  # - TLS_ECDHE_ECDSA_WITH_RC4_128_SHA
  # - TLS_ECDHE_RSA_WITH_RC4_128_SHA
  # - TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA
  # - TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256
  # - TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256
  # CLI flag: -ruler.alertmanager-client.tls-cipher-suites
  [tls_cipher_suites: <string> | default = ""]

  # (advanced) Override the default minimum TLS version. Allowed values:
  # VersionTLS10, VersionTLS11, VersionTLS12, VersionTLS13
  # CLI flag: -ruler.alertmanager-client.tls-min-version
  [tls_min_version: <string> | default = ""]

  # HTTP Basic authentication username. It overrides the username set in the URL
  # (if any).
  # CLI flag: -ruler.alertmanager-client.basic-auth-username
  [basic_auth_username: <string> | default = ""]

  # HTTP Basic authentication password. It overrides the password set in the URL
  # (if any).
  # CLI flag: -ruler.alertmanager-client.basic-auth-password
  [basic_auth_password: <string> | default = ""]

  oauth2:
    # OAuth2 client ID. Enables the use of OAuth2 for authenticating with
    # Alertmanager.
    # CLI flag: -ruler.alertmanager-client.oauth.client_id
    [client_id: <string> | default = ""]

    # OAuth2 client secret.
    # CLI flag: -ruler.alertmanager-client.oauth.client_secret
    [client_secret: <string> | default = ""]

    # Endpoint used to fetch access token.
    # CLI flag: -ruler.alertmanager-client.oauth.token_url
    [token_url: <string> | default = ""]

    # Optional scopes to include with the token request.
    # CLI flag: -ruler.alertmanager-client.oauth.scopes
    [scopes: <string> | default = ""]

    # (advanced) Optional additional URL parameters to send to the token URL.
    # CLI flag: -ruler.alertmanager-client.oauth.endpoint-params
    [endpoint_params: <map of string to string> | default = {}]

  # (advanced) Optional HTTP, HTTPS via CONNECT, or SOCKS5 proxy URL to route
  # requests through. Applies to all requests, including auxiliary traffic, such
  # as OAuth token requests.
  # CLI flag: -ruler.alertmanager-client.proxy-url
  [proxy_url: <string> | default = ""]

# (experimental) Minimum allowable evaluation interval for rule groups.
# CLI flag: -ruler.min-rule-evaluation-interval
[ruler_min_rule_evaluation_interval: <duration> | default = 0s]

# (experimental) Maximum number of alerts or series one alerting rule or one
# recording rule respectively can produce. 0 is no limit.
# CLI flag: -ruler.max-rule-evaluation-results
[ruler_max_rule_evaluation_results: <int> | default = 0]

# The tenant's shard size, used when store-gateway sharding is enabled. Value of
# 0 disables shuffle sharding for the tenant, that is all tenant blocks are
# sharded across all store-gateway replicas.
# CLI flag: -store-gateway.tenant-shard-size
[store_gateway_tenant_shard_size: <int> | default = 0]

# Delete blocks containing samples older than the specified retention period.
# Also used by query-frontend to avoid querying beyond the retention period by
# instant, range or remote read queries. 0 to disable.
# CLI flag: -compactor.blocks-retention-period
[compactor_blocks_retention_period: <duration> | default = 0s]

# The number of shards to use when splitting blocks. 0 to disable splitting.
# CLI flag: -compactor.split-and-merge-shards
[compactor_split_and_merge_shards: <int> | default = 0]

# Number of groups that blocks for splitting should be grouped into. Each group
# of blocks is then split separately. Number of output split shards is
# controlled by -compactor.split-and-merge-shards.
# CLI flag: -compactor.split-groups
[compactor_split_groups: <int> | default = 1]

# Max number of compactors that can compact blocks for single tenant. 0 to
# disable the limit and use all compactors.
# CLI flag: -compactor.compactor-tenant-shard-size
[compactor_tenant_shard_size: <int> | default = 0]

# If a partial block (unfinished block without meta.json file) hasn't been
# modified for this time, it will be marked for deletion. The minimum accepted
# value is 4h0m0s: a lower value will be ignored and the feature disabled. 0 to
# disable.
# CLI flag: -compactor.partial-block-deletion-delay
[compactor_partial_block_deletion_delay: <duration> | default = 1d]

# Enable block upload API for the tenant.
# CLI flag: -compactor.block-upload-enabled
[compactor_block_upload_enabled: <boolean> | default = false]

# Enable block upload validation for the tenant.
# CLI flag: -compactor.block-upload-validation-enabled
[compactor_block_upload_validation_enabled: <boolean> | default = true]

# Verify chunks when uploading blocks via the upload API for the tenant.
# CLI flag: -compactor.block-upload-verify-chunks
[compactor_block_upload_verify_chunks: <boolean> | default = true]

# (advanced) Maximum size in bytes of a block that is allowed to be uploaded or
# validated. 0 = no limit.
# CLI flag: -compactor.block-upload-max-block-size-bytes
[compactor_block_upload_max_block_size_bytes: <int> | default = 0]

# (experimental) Blocks uploaded before the lookback aren't considered in
# compactor cycles. If set, this value should be larger than all values in
# `-blocks-storage.tsdb.block-ranges-period`. A value of 0s means that all
# blocks are considered regardless of their upload time.
# CLI flag: -compactor.max-lookback
[compactor_max_lookback: <duration> | default = 0s]

# (advanced) Maximum number of TSDB segment files that the compactor can upload
# concurrently per block.
# CLI flag: -compactor.max-per-block-upload-concurrency
[compactor_max_per_block_upload_concurrency: <int> | default = 8]

# S3 server-side encryption type. Required to enable server-side encryption
# overrides for a specific tenant. If not set, the default S3 client settings
# are used.
[s3_sse_type: <string> | default = ""]

# S3 server-side encryption KMS Key ID. Ignored if the SSE type override is not
# set.
[s3_sse_kms_key_id: <string> | default = ""]

# S3 server-side encryption KMS encryption context. If unset and the key ID
# override is set, the encryption context will not be provided to S3. Ignored if
# the SSE type override is not set.
[s3_sse_kms_encryption_context: <string> | default = ""]

# Comma-separated list of network CIDRs to block in Alertmanager receiver
# integrations.
# CLI flag: -alertmanager.receivers-firewall-block-cidr-networks
[alertmanager_receivers_firewall_block_cidr_networks: <string> | default = ""]

# True to block private and local addresses in Alertmanager receiver
# integrations. It blocks private addresses defined by  RFC 1918 (IPv4
# addresses) and RFC 4193 (IPv6 addresses), as well as loopback, local unicast
# and local multicast addresses.
# CLI flag: -alertmanager.receivers-firewall-block-private-addresses
[alertmanager_receivers_firewall_block_private_addresses: <boolean> | default = false]

# Per-tenant rate limit for sending notifications from Alertmanager in
# notifications/sec. 0 = rate limit disabled. Negative value = no notifications
# are allowed.
# CLI flag: -alertmanager.notification-rate-limit
[alertmanager_notification_rate_limit: <float> | default = 0]

# Per-integration notification rate limits. Value is a map, where each key is
# integration name and value is a rate-limit (float). On command line, this map
# is given in JSON format. Rate limit has the same meaning as
# -alertmanager.notification-rate-limit, but only applies for specific
# integration. Allowed integration names: webhook, email, pagerduty, opsgenie,
# wechat, slack, victorops, pushover, sns, webex, telegram, discord, msteams,
# msteamsv2.
# CLI flag: -alertmanager.notification-rate-limit-per-integration
[alertmanager_notification_rate_limit_per_integration: <map of string to float64> | default = {}]

# Maximum size of the Grafana Alertmanager configuration for a tenant. 0 = no
# limit.
# CLI flag: -alertmanager.max-grafana-config-size-bytes
[alertmanager_max_grafana_config_size_bytes: <int> | default = 0B]

# Maximum size of the Alertmanager configuration for a tenant. 0 = no limit.
# CLI flag: -alertmanager.max-config-size-bytes
[alertmanager_max_config_size_bytes: <int> | default = 0]

# Maximum size of the Grafana Alertmanager state for a tenant. 0 = no limit.
# CLI flag: -alertmanager.max-grafana-state-size-bytes
[alertmanager_max_grafana_state_size_bytes: <int> | default = 0B]

# Maximum number of silences, including expired silences, that a tenant can have
# at once. 0 = no limit.
# CLI flag: -alertmanager.max-silences-count
[alertmanager_max_silences_count: <int> | default = 0]

# Maximum silence size in bytes. 0 = no limit.
# CLI flag: -alertmanager.max-silence-size-bytes
[alertmanager_max_silence_size_bytes: <int> | default = 0]

# Maximum number of templates in tenant's Alertmanager configuration uploaded
# via Alertmanager API. 0 = no limit.
# CLI flag: -alertmanager.max-templates-count
[alertmanager_max_templates_count: <int> | default = 0]

# Maximum size of single template in tenant's Alertmanager configuration
# uploaded via Alertmanager API. 0 = no limit.
# CLI flag: -alertmanager.max-template-size-bytes
[alertmanager_max_template_size_bytes: <int> | default = 0]

# Maximum number of aggregation groups in Alertmanager's dispatcher that a
# tenant can have. Each active aggregation group uses single goroutine. When the
# limit is reached, dispatcher will not dispatch alerts that belong to
# additional aggregation groups, but existing groups will keep working properly.
# 0 = no limit.
# CLI flag: -alertmanager.max-dispatcher-aggregation-groups
[alertmanager_max_dispatcher_aggregation_groups: <int> | default = 0]

# Maximum number of alerts that a single tenant can have. Inserting more alerts
# will fail with a log message and metric increment. 0 = no limit.
# CLI flag: -alertmanager.max-alerts-count
[alertmanager_max_alerts_count: <int> | default = 0]

# Maximum total size of alerts that a single tenant can have, alert size is the
# sum of the bytes of its labels, annotations and generatorURL. Inserting more
# alerts will fail with a log message and metric increment. 0 = no limit.
# CLI flag: -alertmanager.max-alerts-size-bytes
[alertmanager_max_alerts_size_bytes: <int> | default = 0]

# URL of a hook to invoke before a notification is sent. empty = no hook.
# CLI flag: -alertmanager.notify-hook-url
[alertmanager_notify_hook_url: <string> | default = ""]

# List of receivers to enable notify hooks for. empty = all receivers.
# CLI flag: -alertmanager.notify-hook-receivers
[alertmanager_notify_hook_receivers: <string> | default = ""]

# Maximum amount of time to wait for a hook to complete before timing out. 0 =
# no timeout.
# CLI flag: -alertmanager.notify-hook-timeout
[alertmanager_notify_hook_timeout: <duration> | default = 30s]

# (advanced) Whether to enable automatic suffixes to names of metrics ingested
# through OTLP.
# CLI flag: -distributor.otel-metric-suffixes-enabled
[otel_metric_suffixes_enabled: <boolean> | default = false]

# (experimental) Whether to enable translation of OTel start timestamps to
# Prometheus zero samples in the OTLP endpoint.
# CLI flag: -distributor.otel-created-timestamp-zero-ingestion-enabled
[otel_created_timestamp_zero_ingestion_enabled: <boolean> | default = false]

# (experimental) Optionally specify OTel resource attributes to promote to
# labels.
# CLI flag: -distributor.otel-promote-resource-attributes
[promote_otel_resource_attributes: <string> | default = ""]

# (experimental) Whether to keep identifying OTel resource attributes in the
# target_info metric on top of converting to job and instance labels.
# CLI flag: -distributor.otel-keep-identifying-resource-attributes
[otel_keep_identifying_resource_attributes: <boolean> | default = false]

# (experimental) Whether to convert OTel explicit histograms into native
# histograms with custom buckets.
# CLI flag: -distributor.otel-convert-histograms-to-nhcb
[otel_convert_histograms_to_nhcb: <boolean> | default = false]

# (experimental) Whether to promote OTel scope metadata (scope name, version,
# schema URL, attributes) to corresponding metric labels, prefixed with
# otel_scope_.
# CLI flag: -distributor.otel-promote-scope-metadata
[otel_promote_scope_metadata: <boolean> | default = false]

# (experimental) Whether to enable native ingestion of delta OTLP metrics, which
# will store the raw delta sample values without conversion. If disabled, delta
# metrics will be rejected. Delta support is in an early stage of development.
# The ingestion and querying process is likely to change over time.
# CLI flag: -distributor.otel-native-delta-ingestion
[otel_native_delta_ingestion: <boolean> | default = false]

# (experimental) Translation strategy to apply in OTLP endpoint for metric and
# label names. If unspecified (the default), the strategy is derived from
# -validation.name-validation-scheme and
# -distributor.otel-metric-suffixes-enabled. Supported values: "",
# UnderscoreEscapingWithSuffixes, UnderscoreEscapingWithoutSuffixes,
# NoUTF8EscapingWithSuffixes, NoTranslation.
# CLI flag: -distributor.otel-translation-strategy
[otel_translation_strategy: <string> | default = ""]

# (experimental) The default consistency level to enforce for queries when using
# the ingest storage. Supports values: strong, eventual.
# CLI flag: -ingest-storage.read-consistency
[ingest_storage_read_consistency: <string> | default = "eventual"]

# (experimental) The number of partitions a tenant's data should be sharded to
# when using the ingest storage. Tenants are sharded across partitions using
# shuffle-sharding. 0 disables shuffle sharding and tenant is sharded across all
# partitions.
# CLI flag: -ingest-storage.ingestion-partition-tenant-shard-size
[ingestion_partitions_tenant_shard_size: <int> | default = 0]

# (experimental) Validation scheme to use for metric and label names.
# Distributors reject time series that do not adhere to this scheme. Rulers
# reject rules with unsupported metric or label names. Supported values: legacy,
# utf8.
# CLI flag: -validation.name-validation-scheme
[name_validation_scheme: <int> | default = legacy]
```

### ingest_storage

The `ingest_storage` block configures the Kafka-based ingest storage.

```yaml
# True to enable the ingestion via object storage.
# CLI flag: -ingest-storage.enabled
[enabled: <boolean> | default = false]

kafka:
  # The Kafka backend address.
  # CLI flag: -ingest-storage.kafka.address
  [address: <string> | default = ""]

  # The Kafka topic name.
  # CLI flag: -ingest-storage.kafka.topic
  [topic: <string> | default = ""]

  # The Kafka client ID.
  # CLI flag: -ingest-storage.kafka.client-id
  [client_id: <string> | default = ""]

  # The maximum time allowed to open a connection to a Kafka broker.
  # CLI flag: -ingest-storage.kafka.dial-timeout
  [dial_timeout: <duration> | default = 2s]

  # How long to wait for an incoming write request to be successfully committed
  # to the Kafka backend.
  # CLI flag: -ingest-storage.kafka.write-timeout
  [write_timeout: <duration> | default = 10s]

  # The number of Kafka clients used by producers. When the configured number of
  # clients is greater than 1, partitions are sharded among Kafka clients. A
  # higher number of clients may provide higher write throughput at the cost of
  # additional Metadata requests pressure to Kafka.
  # CLI flag: -ingest-storage.kafka.write-clients
  [write_clients: <int> | default = 1]

  # The username used to authenticate to Kafka using the SASL plain mechanism.
  # To enable SASL, configure both the username and password.
  # CLI flag: -ingest-storage.kafka.sasl-username
  [sasl_username: <string> | default = ""]

  # The password used to authenticate to Kafka using the SASL plain mechanism.
  # To enable SASL, configure both the username and password.
  # CLI flag: -ingest-storage.kafka.sasl-password
  [sasl_password: <string> | default = ""]

  # The consumer group used by the consumer to track the last consumed offset.
  # The consumer group must be different for each ingester. If the configured
  # consumer group contains the '<partition>' placeholder, it is replaced with
  # the actual partition ID owned by the ingester. When empty (recommended),
  # Mimir uses the ingester instance ID to guarantee uniqueness.
  # CLI flag: -ingest-storage.kafka.consumer-group
  [consumer_group: <string> | default = ""]

  # How frequently a consumer should commit the consumed offset to Kafka. The
  # last committed offset is used at startup to continue the consumption from
  # where it was left.
  # CLI flag: -ingest-storage.kafka.consumer-group-offset-commit-interval
  [consumer_group_offset_commit_interval: <duration> | default = 1s]

  # How frequently to poll the last produced offset, used to enforce strong read
  # consistency.
  # CLI flag: -ingest-storage.kafka.last-produced-offset-poll-interval
  [last_produced_offset_poll_interval: <duration> | default = 1s]

  # How long to retry a failed request to get the last produced offset.
  # CLI flag: -ingest-storage.kafka.last-produced-offset-retry-timeout
  [last_produced_offset_retry_timeout: <duration> | default = 10s]

  # From which position to start consuming the partition at startup. Supported
  # options: last-offset, start, end, timestamp.
  # CLI flag: -ingest-storage.kafka.consume-from-position-at-startup
  [consume_from_position_at_startup: <string> | default = "last-offset"]

  # Milliseconds timestamp after which the consumption of the partition starts
  # at startup. Only applies when consume-from-position-at-startup is timestamp
  # CLI flag: -ingest-storage.kafka.consume-from-timestamp-at-startup
  [consume_from_timestamp_at_startup: <int> | default = 0]

  # The best-effort maximum lag a consumer tries to achieve at startup. Set both
  # -ingest-storage.kafka.target-consumer-lag-at-startup and
  # -ingest-storage.kafka.max-consumer-lag-at-startup to 0 to disable waiting
  # for maximum consumer lag being honored at startup.
  # CLI flag: -ingest-storage.kafka.target-consumer-lag-at-startup
  [target_consumer_lag_at_startup: <duration> | default = 2s]

  # The guaranteed maximum lag before a consumer is considered to have caught up
  # reading from a partition at startup, becomes ACTIVE in the hash ring and
  # passes the readiness check. Set both
  # -ingest-storage.kafka.target-consumer-lag-at-startup and
  # -ingest-storage.kafka.max-consumer-lag-at-startup to 0 to disable waiting
  # for maximum consumer lag being honored at startup.
  # CLI flag: -ingest-storage.kafka.max-consumer-lag-at-startup
  [max_consumer_lag_at_startup: <duration> | default = 15s]

  # Enable auto-creation of Kafka topic on startup if it doesn't exist. If
  # creating the topic fails and the topic doesn't already exist, Mimir fails to
  # start.
  # CLI flag: -ingest-storage.kafka.auto-create-topic-enabled
  [auto_create_topic_enabled: <boolean> | default = true]

  # When auto-creation of Kafka topic is enabled and this value is positive,
  # Mimir creates the topic with this number of partitions. When the value is -1
  # the Kafka broker uses the default number of partitions (num.partitions
  # configuration).
  # CLI flag: -ingest-storage.kafka.auto-create-topic-default-partitions
  [auto_create_topic_default_partitions: <int> | default = -1]

  # The maximum size of a Kafka record data that should be generated by the
  # producer. An incoming write request larger than this size is split into
  # multiple Kafka records. We strongly recommend to not change this setting
  # unless for testing purposes.
  # CLI flag: -ingest-storage.kafka.producer-max-record-size-bytes
  [producer_max_record_size_bytes: <int> | default = 15983616]

  # The maximum size of (uncompressed) buffered and unacknowledged produced
  # records sent to Kafka. The produce request fails once this limit is reached.
  # This limit is per Kafka client. 0 to disable the limit.
  # CLI flag: -ingest-storage.kafka.producer-max-buffered-bytes
  [producer_max_buffered_bytes: <int> | default = 1073741824]

  # The maximum allowed for a read requests processed by an ingester to wait
  # until strong read consistency is enforced. 0 to disable the timeout.
  # CLI flag: -ingest-storage.kafka.wait-strong-read-consistency-timeout
  [wait_strong_read_consistency_timeout: <duration> | default = 20s]

  # (experimental) The record version that this producer sends.
  # CLI flag: -ingest-storage.kafka.producer-record-version
  [producer_record_version: <int> | default = 0]

  # The maximum amount of time a Kafka broker waits for some records before a
  # Fetch response is returned.
  # CLI flag: -ingest-storage.kafka.fetch-max-wait
  [fetch_max_wait: <duration> | default = 5s]

  # The maximum number of concurrent fetch requests that the ingester makes when
  # reading data from Kafka during startup. Concurrent fetch requests are issued
  # only when there is sufficient backlog of records to consume. Set to 0 to
  # disable.
  # CLI flag: -ingest-storage.kafka.fetch-concurrency-max
  [fetch_concurrency_max: <int> | default = 0]

  # When enabled, the fetch request MaxBytes field is computed using the
  # compressed size of previous records. When disabled, MaxBytes is computed
  # using uncompressed bytes. Different Kafka implementations interpret MaxBytes
  # differently.
  # CLI flag: -ingest-storage.kafka.use-compressed-bytes-as-fetch-max-bytes
  [use_compressed_bytes_as_fetch_max_bytes: <boolean> | default = true]

  # The maximum number of buffered records ready to be processed. This limit
  # applies to the sum of all inflight requests. Set to 0 to disable the limit.
  # CLI flag: -ingest-storage.kafka.max-buffered-bytes
  [max_buffered_bytes: <int> | default = 100000000]

  # The maximum number of concurrent ingestion streams to the TSDB head. Every
  # tenant has their own set of streams. 0 to disable.
  # CLI flag: -ingest-storage.kafka.ingestion-concurrency-max
  [ingestion_concurrency_max: <int> | default = 0]

  # The number of timeseries to batch together before ingesting to the TSDB
  # head. Only use this setting when
  # -ingest-storage.kafka.ingestion-concurrency-max is greater than 0.
  # CLI flag: -ingest-storage.kafka.ingestion-concurrency-batch-size
  [ingestion_concurrency_batch_size: <int> | default = 150]

  # The number of batches to prepare and queue to ingest to the TSDB head. Only
  # use this setting when -ingest-storage.kafka.ingestion-concurrency-max is
  # greater than 0.
  # CLI flag: -ingest-storage.kafka.ingestion-concurrency-queue-capacity
  [ingestion_concurrency_queue_capacity: <int> | default = 5]

  # The expected number of times to ingest timeseries to the TSDB head after
  # batching. With fewer flushes, the overhead of splitting up the work is
  # higher than the benefit of parallelization. Only use this setting when
  # -ingest-storage.kafka.ingestion-concurrency-max is greater than 0.
  # CLI flag: -ingest-storage.kafka.ingestion-concurrency-target-flushes-per-shard
  [ingestion_concurrency_target_flushes_per_shard: <int> | default = 80]

  # The estimated number of bytes a sample has at time of ingestion. This value
  # is used to estimate the timeseries without decompressing them. Only use this
  # setting when -ingest-storage.kafka.ingestion-concurrency-max is greater than
  # 0.
  # CLI flag: -ingest-storage.kafka.ingestion-concurrency-estimated-bytes-per-sample
  [ingestion_concurrency_estimated_bytes_per_sample: <int> | default = 500]

migration:
  # When both this option and ingest storage are enabled, distributors write to
  # both Kafka and ingesters. A write request is considered successful only when
  # written to both backends.
  # CLI flag: -ingest-storage.migration.distributor-send-to-ingesters-enabled
  [distributor_send_to_ingesters_enabled: <boolean> | default = false]

  # When enabled, errors writing to ingest storage are logged but do not affect
  # write success or quorum. When disabled, write requests fail if ingest
  # storage write fails.
  # CLI flag: -ingest-storage.migration.ignore-ingest-storage-errors
  [ignore_ingest_storage_errors: <boolean> | default = false]

  # The maximum time a write request that goes through the ingest storage waits
  # before it times out. Set to `0` to disable the timeout.
  # CLI flag: -ingest-storage.migration.ingest-storage-max-wait-time
  [ingest_storage_max_wait_time: <duration> | default = 0s]

# (experimental) Enable fsyncing of WAL and WBL before Kafka offsets are
# committed.
# CLI flag: -ingest-storage.write-logs-fsync-before-kafka-commit-enabled
[write_logs_fsync_before_kafka_commit_enabled: <boolean> | default = true]

# (experimental) Number of tenants to concurrently fsync WAL and WBL before
# Kafka offsets are committed. Ignored if
# -ingest-storage.write-logs-fsync-before-kafka-commit-enabled=false
# CLI flag: -ingest-storage.write-logs-fsync-before-kafka-commit-concurrency
[write_logs_fsync_before_kafka_commit_concurrency: <int> | default = 1]
```

### blocks_storage

The `blocks_storage` block configures the blocks storage.

```yaml
# Backend storage to use. Supported backends are: s3, gcs, azure, swift,
# filesystem.
# CLI flag: -blocks-storage.backend
[backend: <string> | default = "filesystem"]

# The s3_backend block configures the connection to Amazon S3 object storage
# backend.
# The CLI flags prefix for this block configuration is: blocks-storage
[s3: <s3_storage_backend>]

# The gcs_backend block configures the connection to Google Cloud Storage object
# storage backend.
# The CLI flags prefix for this block configuration is: blocks-storage
[gcs: <gcs_storage_backend>]

# The azure_storage_backend block configures the connection to Azure object
# storage backend.
# The CLI flags prefix for this block configuration is: blocks-storage
[azure: <azure_storage_backend>]

# The swift_storage_backend block configures the connection to OpenStack Object
# Storage (Swift) object storage backend.
# The CLI flags prefix for this block configuration is: blocks-storage
[swift: <swift_storage_backend>]

# The filesystem_storage_backend block configures the usage of local file system
# as object storage backend.
# The CLI flags prefix for this block configuration is: blocks-storage
[filesystem: <filesystem_storage_backend>]

# Prefix for all objects stored in the backend storage. For simplicity, it may
# only contain digits and English alphabet letters.
# CLI flag: -blocks-storage.storage-prefix
[storage_prefix: <string> | default = ""]

# This configures how the querier and store-gateway discover and synchronize
# blocks stored in the bucket.
bucket_store:
  # Directory to store synchronized TSDB index headers. This directory is not
  # required to be persisted between restarts, but it's highly recommended in
  # order to improve the store-gateway startup time.
  # CLI flag: -blocks-storage.bucket-store.sync-dir
  [sync_dir: <string> | default = "./tsdb-sync/"]

  # (advanced) How frequently to scan the bucket, or to refresh the bucket index
  # (if enabled), in order to look for changes (new blocks shipped by ingesters
  # and blocks deleted by retention or compaction).
  # CLI flag: -blocks-storage.bucket-store.sync-interval
  [sync_interval: <duration> | default = 15m]

  # (advanced) Max number of concurrent queries to execute against the long-term
  # storage. The limit is shared across all tenants.
  # CLI flag: -blocks-storage.bucket-store.max-concurrent
  [max_concurrent: <int> | default = 200]

  # (advanced) Timeout for the queue of queries waiting for execution. If the
  # queue is full and the timeout is reached, the query will be retried on
  # another store-gateway. 0 means no timeout and all queries will wait
  # indefinitely for their turn.
  # CLI flag: -blocks-storage.bucket-store.max-concurrent-queue-timeout
  [max_concurrent_queue_timeout: <duration> | default = 5s]

  # (advanced) Maximum number of concurrent tenants synching blocks.
  # CLI flag: -blocks-storage.bucket-store.tenant-sync-concurrency
  [tenant_sync_concurrency: <int> | default = 1]

  # (advanced) Maximum number of concurrent blocks synching per tenant.
  # CLI flag: -blocks-storage.bucket-store.block-sync-concurrency
  [block_sync_concurrency: <int> | default = 4]

  # (advanced) Number of goroutines to use when syncing block meta files from
  # object storage per tenant.
  # CLI flag: -blocks-storage.bucket-store.meta-sync-concurrency
  [meta_sync_concurrency: <int> | default = 20]

  index_cache:
    # The index cache backend type. Supported values: inmemory, memcached.
    # CLI flag: -blocks-storage.bucket-store.index-cache.backend
    [backend: <string> | default = "inmemory"]

    # The memcached block configures the Memcached-based caching backend.
    # The CLI flags prefix for this block configuration is:
    # blocks-storage.bucket-store.index-cache
    [memcached: <memcached>]

    inmemory:
      # Maximum size in bytes of in-memory index cache used to speed up blocks
      # index lookups (shared between all tenants).
      # CLI flag: -blocks-storage.bucket-store.index-cache.inmemory.max-size-bytes
      [max_size_bytes: <int> | default = 1073741824]

  chunks_cache:
    # Backend for chunks cache, if not empty. Supported values: memcached.
    # CLI flag: -blocks-storage.bucket-store.chunks-cache.backend
    [backend: <string> | default = ""]

    # The memcached block configures the Memcached-based caching backend.
    # The CLI flags prefix for this block configuration is:
    # blocks-storage.bucket-store.chunks-cache
    [memcached: <memcached>]

    # (advanced) Maximum number of sub-GetRange requests that a single GetRange
    # request can be split into when fetching chunks. Zero or negative value =
    # unlimited number of sub-requests.
    # CLI flag: -blocks-storage.bucket-store.chunks-cache.max-get-range-requests
    [max_get_range_requests: <int> | default = 3]

    # (advanced) TTL for caching object attributes for chunks. If the metadata
    # cache is configured, attributes will be stored under this cache backend,
    # otherwise attributes are stored in the chunks cache backend.
    # CLI flag: -blocks-storage.bucket-store.chunks-cache.attributes-ttl
    [attributes_ttl: <duration> | default = 168h]

    # (advanced) Maximum number of object attribute items to keep in a first
    # level in-memory LRU cache. Metadata will be stored and fetched in-memory
    # before hitting the cache backend. 0 to disable the in-memory cache.
    # CLI flag: -blocks-storage.bucket-store.chunks-cache.attributes-in-memory-max-items
    [attributes_in_memory_max_items: <int> | default = 50000]

    # (advanced) TTL for caching individual chunks subranges.
    # CLI flag: -blocks-storage.bucket-store.chunks-cache.subrange-ttl
    [subrange_ttl: <duration> | default = 24h]

  metadata_cache:
    # Backend for metadata cache, if not empty. Supported values: memcached.
    # CLI flag: -blocks-storage.bucket-store.metadata-cache.backend
    [backend: <string> | default = ""]

    # The memcached block configures the Memcached-based caching backend.
    # The CLI flags prefix for this block configuration is:
    # blocks-storage.bucket-store.metadata-cache
    [memcached: <memcached>]

    # (advanced) How long to cache list of tenants in the bucket.
    # CLI flag: -blocks-storage.bucket-store.metadata-cache.tenants-list-ttl
    [tenants_list_ttl: <duration> | default = 15m]

    # (advanced) How long to cache list of blocks for each tenant.
    # CLI flag: -blocks-storage.bucket-store.metadata-cache.tenant-blocks-list-ttl
    [tenant_blocks_list_ttl: <duration> | default = 5m]

    # (advanced) How long to cache list of chunks for a block.
    # CLI flag: -blocks-storage.bucket-store.metadata-cache.chunks-list-ttl
    [chunks_list_ttl: <duration> | default = 24h]

    # (advanced) How long to cache information that block metafile exists. Also
    # used for tenant deletion mark file.
    # CLI flag: -blocks-storage.bucket-store.metadata-cache.metafile-exists-ttl
    [metafile_exists_ttl: <duration> | default = 2h]

    # (advanced) How long to cache information that block metafile doesn't
    # exist. Also used for tenant deletion mark file.
    # CLI flag: -blocks-storage.bucket-store.metadata-cache.metafile-doesnt-exist-ttl
    [metafile_doesnt_exist_ttl: <duration> | default = 5m]

    # (advanced) How long to cache content of the metafile.
    # CLI flag: -blocks-storage.bucket-store.metadata-cache.metafile-content-ttl
    [metafile_content_ttl: <duration> | default = 24h]

    # (advanced) Maximum size of metafile content to cache in bytes. Caching
    # will be skipped if the content exceeds this size. This is useful to avoid
    # network round trip for large content if the configured caching backend has
    # an hard limit on cached items size (in this case, you should set this
    # limit to the same limit in the caching backend).
    # CLI flag: -blocks-storage.bucket-store.metadata-cache.metafile-max-size-bytes
    [metafile_max_size_bytes: <int> | default = 1048576]

    # (advanced) How long to cache attributes of the block metafile.
    # CLI flag: -blocks-storage.bucket-store.metadata-cache.metafile-attributes-ttl
    [metafile_attributes_ttl: <duration> | default = 168h]

    # (advanced) How long to cache attributes of the block index.
    # CLI flag: -blocks-storage.bucket-store.metadata-cache.block-index-attributes-ttl
    [block_index_attributes_ttl: <duration> | default = 168h]

    # (advanced) How long to cache content of the bucket index.
    # CLI flag: -blocks-storage.bucket-store.metadata-cache.bucket-index-content-ttl
    [bucket_index_content_ttl: <duration> | default = 5m]

    # (advanced) Maximum size of bucket index content to cache in bytes. Caching
    # will be skipped if the content exceeds this size. This is useful to avoid
    # network round trip for large content if the configured caching backend has
    # an hard limit on cached items size (in this case, you should set this
    # limit to the same limit in the caching backend).
    # CLI flag: -blocks-storage.bucket-store.metadata-cache.bucket-index-max-size-bytes
    [bucket_index_max_size_bytes: <int> | default = 1048576]

  # (advanced) Duration after which the blocks marked for deletion will be
  # filtered out while fetching blocks. The idea of ignore-deletion-marks-delay
  # is to ignore blocks that are marked for deletion with some delay. This
  # ensures store can still serve blocks that are meant to be deleted but do not
  # have a replacement yet.
  # CLI flag: -blocks-storage.bucket-store.ignore-deletion-marks-delay
  [ignore_deletion_mark_delay: <duration> | default = 1h]

  # (experimental) Duration after which blocks marked for deletion will still be
  # queried. This ensures queriers still query blocks that are meant to be
  # deleted but do not have a replacement yet.
  # CLI flag: -blocks-storage.bucket-store.ignore-deletion-marks-while-querying-delay
  [ignore_deletion_mark_while_querying_delay: <duration> | default = 50m]

  bucket_index:
    # (advanced) How frequently a bucket index, which previously failed to load,
    # should be tried to load again. This option is used only by querier.
    # CLI flag: -blocks-storage.bucket-store.bucket-index.update-on-error-interval
    [update_on_error_interval: <duration> | default = 1m]

    # (advanced) How long a unused bucket index should be cached. Once this
    # timeout expires, the unused bucket index is removed from the in-memory
    # cache. This option is used only by querier.
    # CLI flag: -blocks-storage.bucket-store.bucket-index.idle-timeout
    [idle_timeout: <duration> | default = 1h]

    # (advanced) The maximum allowed age of a bucket index (last updated) before
    # queries start failing because the bucket index is too old. The bucket
    # index is periodically updated by the compactor, and this check is enforced
    # in the querier (at query time).
    # CLI flag: -blocks-storage.bucket-store.bucket-index.max-stale-period
    [max_stale_period: <duration> | default = 1h]

  # (advanced) Blocks with minimum time within this duration are ignored, and
  # not loaded by store-gateway. Useful when used together with
  # -querier.query-store-after to prevent loading young blocks, because there
  # are usually many of them (depending on number of ingesters) and they are not
  # yet compacted. Negative values or 0 disable the filter.
  # CLI flag: -blocks-storage.bucket-store.ignore-blocks-within
  [ignore_blocks_within: <duration> | default = 10h]

  # (advanced) Max size - in bytes - of the in-memory series hash cache. The
  # cache is shared across all tenants and it's used only when query sharding is
  # enabled.
  # CLI flag: -blocks-storage.bucket-store.series-hash-cache-max-size-bytes
  [series_hash_cache_max_size_bytes: <int> | default = 1073741824]

  # (advanced) Max size - in bytes - of a gap for which the partitioner
  # aggregates together two bucket GET object requests.
  # CLI flag: -blocks-storage.bucket-store.partitioner-max-gap-bytes
  [partitioner_max_gap_bytes: <int> | default = 524288]

  # (advanced) Controls what is the ratio of postings offsets that the store
  # will hold in memory.
  # CLI flag: -blocks-storage.bucket-store.posting-offsets-in-mem-sampling
  [postings_offsets_in_mem_sampling: <int> | default = 32]

  index_header:
    # (advanced) Maximum number of idle file handles the store-gateway keeps
    # open for each index-header file.
    # CLI flag: -blocks-storage.bucket-store.index-header.max-idle-file-handles
    [max_idle_file_handles: <int> | default = 1]

    # (experimental) If enabled, store-gateway will periodically persist block
    # IDs of lazy loaded index-headers and load them eagerly during startup.
    # Ignored if index-header lazy loading is disabled.
    # CLI flag: -blocks-storage.bucket-store.index-header.eager-loading-startup-enabled
    [eager_loading_startup_enabled: <boolean> | default = true]

    # (advanced) If enabled, store-gateway will lazy load an index-header only
    # once required by a query.
    # CLI flag: -blocks-storage.bucket-store.index-header.lazy-loading-enabled
    [lazy_loading_enabled: <boolean> | default = true]

    # (advanced) If index-header lazy loading is enabled and this setting is >
    # 0, the store-gateway will offload unused index-headers after 'idle
    # timeout' inactivity.
    # CLI flag: -blocks-storage.bucket-store.index-header.lazy-loading-idle-timeout
    [lazy_loading_idle_timeout: <duration> | default = 1h]

    # (advanced) Maximum number of concurrent index header loads across all
    # tenants. If set to 0, concurrency is unlimited.
    # CLI flag: -blocks-storage.bucket-store.index-header.lazy-loading-concurrency
    [lazy_loading_concurrency: <int> | default = 4]

    # (advanced) Timeout for the queue of index header loads. If the queue is
    # full and the timeout is reached, the load will return an error. 0 means no
    # timeout and the load will wait indefinitely.
    # CLI flag: -blocks-storage.bucket-store.index-header.lazy-loading-concurrency-queue-timeout
    [lazy_loading_concurrency_queue_timeout: <duration> | default = 5s]

    # (advanced) If true, verify the checksum of index headers upon loading them
    # (either on startup or lazily when lazy loading is enabled). Setting to
    # true helps detect disk corruption at the cost of slowing down index header
    # loading.
    # CLI flag: -blocks-storage.bucket-store.index-header.verify-on-load
    [verify_on_load: <boolean> | default = false]

  # (advanced) This option controls how many series to fetch per batch. The
  # batch size must be greater than 0.
  # CLI flag: -blocks-storage.bucket-store.batch-series-size
  [streaming_series_batch_size: <int> | default = 5000]

  # (advanced) This parameter controls the trade-off in fetching series versus
  # fetching postings to fulfill a series request. Increasing the series
  # preference results in fetching more series and reducing the volume of
  # postings fetched. Reducing the series preference results in the opposite.
  # Increase this parameter to reduce the rate of fetched series bytes (see
  # "Mimir / Queries" dashboard) or API calls to the object store. Must be a
  # positive floating point number.
  # CLI flag: -blocks-storage.bucket-store.series-fetch-preference
  [series_fetch_preference: <float> | default = 0.75]

tsdb:
  # Directory to store TSDBs (including WAL) in the ingesters. This directory is
  # required to be persisted between restarts.
  # CLI flag: -blocks-storage.tsdb.dir
  [dir: <string> | default = "./tsdb/"]

  # TSDB blocks retention in the ingester before a block is removed. If shipping
  # is enabled, the retention will be relative to the time when the block was
  # uploaded to storage. If shipping is disabled then its relative to the
  # creation time of the block. This should be larger than the
  # -blocks-storage.tsdb.block-ranges-period, -querier.query-store-after and
  # large enough to give store-gateways and queriers enough time to discover
  # newly uploaded blocks.
  # CLI flag: -blocks-storage.tsdb.retention-period
  [retention_period: <duration> | default = 13h]

  # (advanced) How frequently the TSDB blocks are scanned and new ones are
  # shipped to the storage. 0 means shipping is disabled.
  # CLI flag: -blocks-storage.tsdb.ship-interval
  [ship_interval: <duration> | default = 1m]

  # (advanced) Maximum number of tenants concurrently shipping blocks to the
  # storage.
  # CLI flag: -blocks-storage.tsdb.ship-concurrency
  [ship_concurrency: <int> | default = 10]

  # (advanced) How frequently the ingester checks whether the TSDB head should
  # be compacted and, if so, triggers the compaction. Mimir applies a jitter to
  # the first check, and subsequent checks will happen at the configured
  # interval. A block is only created if data covers the smallest block range.
  # The configured interval must be between 0 and 15 minutes.
  # CLI flag: -blocks-storage.tsdb.head-compaction-interval
  [head_compaction_interval: <duration> | default = 1m]

  # (advanced) Maximum number of tenants concurrently compacting TSDB head into
  # a new block
  # CLI flag: -blocks-storage.tsdb.head-compaction-concurrency
  [head_compaction_concurrency: <int> | default = 1]

  # (advanced) If TSDB head is idle for this duration, it is compacted. Note
  # that up to 25% jitter is added to the value to avoid ingesters compacting
  # concurrently. 0 means disabled.
  # CLI flag: -blocks-storage.tsdb.head-compaction-idle-timeout
  [head_compaction_idle_timeout: <duration> | default = 1h]

  # (advanced) The write buffer size used by the head chunks mapper. Lower
  # values reduce memory utilisation on clusters with a large number of tenants
  # at the cost of increased disk I/O operations. The configured buffer size
  # must be between 65536 and 8388608.
  # CLI flag: -blocks-storage.tsdb.head-chunks-write-buffer-size-bytes
  [head_chunks_write_buffer_size_bytes: <int> | default = 4194304]

  # (experimental) How much variance (as percentage between 0 and 1) should be
  # applied to the chunk end time, to spread chunks writing across time. Doesn't
  # apply to the last chunk of the chunk range. 0 means no variance.
  # CLI flag: -blocks-storage.tsdb.head-chunks-end-time-variance
  [head_chunks_end_time_variance: <float> | default = 0]

  # (advanced) The number of shards of series to use in TSDB (must be a power of
  # 2). Reducing this will decrease memory footprint, but can negatively impact
  # performance.
  # CLI flag: -blocks-storage.tsdb.stripe-size
  [stripe_size: <int> | default = 16384]

  # (advanced) True to enable TSDB WAL compression.
  # CLI flag: -blocks-storage.tsdb.wal-compression-enabled
  [wal_compression_enabled: <boolean> | default = false]

  # (advanced) TSDB WAL segments files max size (bytes).
  # CLI flag: -blocks-storage.tsdb.wal-segment-size-bytes
  [wal_segment_size_bytes: <int> | default = 134217728]

  # (advanced) Maximum number of CPUs that can simultaneously processes WAL
  # replay. If it is set to 0, then each TSDB is replayed with a concurrency
  # equal to the number of CPU cores available on the machine.
  # CLI flag: -blocks-storage.tsdb.wal-replay-concurrency
  [wal_replay_concurrency: <int> | default = 0]

  # (advanced) True to flush blocks to storage on shutdown. If false, incomplete
  # blocks will be reused after restart.
  # CLI flag: -blocks-storage.tsdb.flush-blocks-on-shutdown
  [flush_blocks_on_shutdown: <boolean> | default = false]

  # (advanced) If TSDB has not received any data for this duration, and all
  # blocks from TSDB have been shipped, TSDB is closed and deleted from local
  # disk. If set to positive value, this value should be equal or higher than
  # -querier.query-ingesters-within flag to make sure that TSDB is not closed
  # prematurely, which could cause partial query results. 0 or negative value
  # disables closing of idle TSDB.
  # CLI flag: -blocks-storage.tsdb.close-idle-tsdb-timeout
  [close_idle_tsdb_timeout: <duration> | default = 13h]

  # (experimental) True to enable snapshotting of in-memory TSDB data on disk
  # when shutting down.
  # CLI flag: -blocks-storage.tsdb.memory-snapshot-on-shutdown
  [memory_snapshot_on_shutdown: <boolean> | default = false]

  # (advanced) The size of the write queue used by the head chunks mapper. Lower
  # values reduce memory utilisation at the cost of potentially higher ingest
  # latency. Value of 0 switches chunks mapper to implementation without a
  # queue.
  # CLI flag: -blocks-storage.tsdb.head-chunks-write-queue-size
  [head_chunks_write_queue_size: <int> | default = 1000000]

  # (experimental) When enabled, ingester produces 24h blocks for out-of-order
  # data that is before the current day, instead of the usual 2h blocks.
  # CLI flag: -blocks-storage.tsdb.bigger-out-of-order-blocks-for-old-samples
  [bigger_out_of_order_blocks_for_old_samples: <boolean> | default = false]

  # (advanced) Max size - in bytes - of the in-memory series hash cache. The
  # cache is shared across all tenants and it's used only when query sharding is
  # enabled.
  # CLI flag: -blocks-storage.tsdb.series-hash-cache-max-size-bytes
  [series_hash_cache_max_size_bytes: <int> | default = 367001600]

  # (experimental) Maximum capacity for out of order chunks, in samples between
  # 1 and 255.
  # CLI flag: -blocks-storage.tsdb.out-of-order-capacity-max
  [out_of_order_capacity_max: <int> | default = 32]

  # (experimental) Whether postings for matchers cache should be shared across
  # blocks, as opposed to instantiated per block. With a shared cache, one cache
  # is created for head blocks, and one for compacted blocks.
  # CLI flag: -blocks-storage.tsdb.shared-postings-for-matchers-cache
  [shared_postings_for_matchers_cache: <boolean> | default = false]

  # (experimental) Whether head block postings should be tracked and invalidated
  # when they change, allowing higher TTLs to be used. When not using
  # invalidation, cache entries will be used until removed.
  # CLI flag: -blocks-storage.tsdb.head-postings-for-matchers-cache-invalidation
  [head_postings_for_matchers_cache_invalidation: <boolean> | default = false]

  # (experimental) The size of the metric versions cache in each ingester when
  # invalidation is enabled.
  # CLI flag: -blocks-storage.tsdb.head-postings-for-matchers-cache-versions
  [head_postings_for_matchers_cache_versions: <int> | default = 2097152]

  # (experimental) How long to cache postings for matchers in the Head and
  # OOOHead. 0 disables the cache and just deduplicates the in-flight calls.
  # CLI flag: -blocks-storage.tsdb.head-postings-for-matchers-cache-ttl
  [head_postings_for_matchers_cache_ttl: <duration> | default = 10s]

  # (deprecated) Maximum number of entries in the cache for postings for
  # matchers in the Head and OOOHead when TTL is greater than 0.
  # CLI flag: -blocks-storage.tsdb.head-postings-for-matchers-cache-size
  [head_postings_for_matchers_cache_size: <int> | default = 100]

  # (experimental) Maximum size in bytes of the cache for postings for matchers
  # in the Head and OOOHead when TTL is greater than 0.
  # CLI flag: -blocks-storage.tsdb.head-postings-for-matchers-cache-max-bytes
  [head_postings_for_matchers_cache_max_bytes: <int> | default = 104857600]

  # (experimental) Force the cache to be used for postings for matchers in the
  # Head and OOOHead, even if it's not a concurrent (query-sharding) call.
  # CLI flag: -blocks-storage.tsdb.head-postings-for-matchers-cache-force
  [head_postings_for_matchers_cache_force: <boolean> | default = false]

  # (experimental) How long to cache postings for matchers in each compacted
  # block queried from the ingester. 0 disables the cache and just deduplicates
  # the in-flight calls.
  # CLI flag: -blocks-storage.tsdb.block-postings-for-matchers-cache-ttl
  [block_postings_for_matchers_cache_ttl: <duration> | default = 10s]

  # (deprecated) Maximum number of entries in the cache for postings for
  # matchers in each compacted block when TTL is greater than 0.
  # CLI flag: -blocks-storage.tsdb.block-postings-for-matchers-cache-size
  [block_postings_for_matchers_cache_size: <int> | default = 100]

  # (experimental) Maximum size in bytes of the cache for postings for matchers
  # in each compacted block when TTL is greater than 0.
  # CLI flag: -blocks-storage.tsdb.block-postings-for-matchers-cache-max-bytes
  [block_postings_for_matchers_cache_max_bytes: <int> | default = 104857600]

  # (experimental) Force the cache to be used for postings for matchers in
  # compacted blocks, even if it's not a concurrent (query-sharding) call.
  # CLI flag: -blocks-storage.tsdb.block-postings-for-matchers-cache-force
  [block_postings_for_matchers_cache_force: <boolean> | default = false]

  # (experimental) When the number of in-memory series in the ingester is equal
  # to or greater than this setting, the ingester tries to compact the TSDB
  # Head. The early compaction removes from the memory all samples and inactive
  # series up until -ingester.active-series-metrics-idle-timeout time ago. After
  # an early compaction, the ingester will not accept any sample with a
  # timestamp older than -ingester.active-series-metrics-idle-timeout time ago
  # (unless out of order ingestion is enabled). The ingester checks every
  # -blocks-storage.tsdb.head-compaction-interval whether an early compaction is
  # required. Use 0 to disable it.
  # CLI flag: -blocks-storage.tsdb.early-head-compaction-min-in-memory-series
  [early_head_compaction_min_in_memory_series: <int> | default = 0]

  # (experimental) When the early compaction is enabled, the early compaction is
  # triggered only if the estimated series reduction is at least the configured
  # percentage (0-100).
  # CLI flag: -blocks-storage.tsdb.early-head-compaction-min-estimated-series-reduction-percentage
  [early_head_compaction_min_estimated_series_reduction_percentage: <int> | default = 15]

  # (experimental) Allows head compaction to happen when the min block range can
  # no longer be appended, without requiring 1.5x the chunk range worth of data
  # in the head.
  # CLI flag: -blocks-storage.tsdb.timely-head-compaction-enabled
  [timely_head_compaction_enabled: <boolean> | default = false]

  index_lookup_planning:
    # (advanced) Cost for iterating postings that have been retrieved from the
    # index.
    # CLI flag: -blocks-storage.tsdb.index-lookup-planning.retrieved-posting-cost
    [retrieved_posting_cost: <float> | default = 0.01]

    # (advanced) Cost for retrieving series from the index and checking if a
    # series belongs to the query's shard.
    # CLI flag: -blocks-storage.tsdb.index-lookup-planning.retrieved-series-cost
    [retrieved_series_cost: <float> | default = 10]

    # (advanced) Cost for retrieving the posting list from disk or from memory.
    # CLI flag: -blocks-storage.tsdb.index-lookup-planning.retrieved-posting-list-cost
    [retrieved_posting_list_cost: <float> | default = 10]

    # (advanced) Minimum number of series a block must have for query planning
    # to be used.
    # CLI flag: -blocks-storage.tsdb.index-lookup-planning.min-series-per-block-for-query-planning
    [min_series_per_block_for_query_planning: <int> | default = 10000]

    # (experimental) Controls the collection of statistics and whether to defer
    # some vector selector matchers to sequential scans. This leads to better
    # performance.
    # CLI flag: -blocks-storage.tsdb.index-lookup-planning.enabled
    [index_lookup_planning_enabled: <boolean> | default = false]

    # (experimental) Portion of queries where a mirrored chunk querier compares
    # results with and without index lookup planning. Value between 0 (disabled)
    # and 1 (all queries).
    # CLI flag: -blocks-storage.tsdb.index-lookup-planning.comparison-portion
    [index_lookup_planning_comparison_portion: <float> | default = 0]

    # (experimental) How frequently to collect block statistics, which are used
    # in query execution optimization. 0 to disable.
    # CLI flag: -blocks-storage.tsdb.index-lookup-planning.statistics-collection-frequency
    [statistics_collection_frequency: <duration> | default = 1h]
```

### compactor

The `compactor` block configures the compactor component.

```yaml
# (advanced) List of compaction time ranges.
# CLI flag: -compactor.block-ranges
[block_ranges: <list of durations> | default = 2h0m0s,12h0m0s,24h0m0s]

# (advanced) Number of goroutines to use when downloading blocks for compaction
# and uploading resulting blocks.
# CLI flag: -compactor.block-sync-concurrency
[block_sync_concurrency: <int> | default = 8]

# (advanced) Number of goroutines to use when syncing block meta files from the
# long term storage.
# CLI flag: -compactor.meta-sync-concurrency
[meta_sync_concurrency: <int> | default = 20]

# Directory to temporarily store blocks during compaction. This directory is not
# required to be persisted between restarts.
# CLI flag: -compactor.data-dir
[data_dir: <string> | default = "./data-compactor/"]

# (advanced) The frequency at which the compaction runs
# CLI flag: -compactor.compaction-interval
[compaction_interval: <duration> | default = 1h]

# (advanced) How many times to retry a failed compaction within a single
# compaction run.
# CLI flag: -compactor.compaction-retries
[compaction_retries: <int> | default = 3]

# (advanced) Max number of concurrent compactions running.
# CLI flag: -compactor.compaction-concurrency
[compaction_concurrency: <int> | default = 1]

# How long the compactor waits before compacting first-level blocks that are
# uploaded by the ingesters. This configuration option allows for the reduction
# of cases where the compactor begins to compact blocks before all ingesters
# have uploaded their blocks to the storage.
# CLI flag: -compactor.first-level-compaction-wait-period
[first_level_compaction_wait_period: <duration> | default = 25m]

# (experimental) When enabled, the compactor skips first-level compaction jobs
# if any source block has a MaxTime more recent than the wait period threshold.
# This prevents premature compaction of blocks that may still receive
# late-arriving data.
# CLI flag: -compactor.first-level-compaction-skip-future-max-time
[first_level_compaction_skip_future_max_time: <boolean> | default = false]

# (advanced) How frequently the compactor should run blocks cleanup and
# maintenance, as well as update the bucket index.
# CLI flag: -compactor.cleanup-interval
[cleanup_interval: <duration> | default = 15m]

# (advanced) Max number of tenants for which blocks cleanup and maintenance
# should run concurrently.
# CLI flag: -compactor.cleanup-concurrency
[cleanup_concurrency: <int> | default = 20]

# (advanced) Time before a block marked for deletion is deleted from bucket. If
# not 0, blocks will be marked for deletion and the compactor component will
# permanently delete blocks marked for deletion from the bucket. If 0, blocks
# will be deleted straight away. Note that deleting blocks immediately can cause
# query failures.
# CLI flag: -compactor.deletion-delay
[deletion_delay: <duration> | default = 12h]

# (advanced) For tenants marked for deletion, this is the time between deletion
# of the last block, and doing final cleanup (marker files, debug files) of the
# tenant.
# CLI flag: -compactor.tenant-cleanup-delay
[tenant_cleanup_delay: <duration> | default = 6h]

# (advanced) Max time for starting compactions for a single tenant. After this
# time no new compactions for the tenant are started before next compaction
# cycle. This can help in multi-tenant environments to avoid single tenant using
# all compaction time, but also in single-tenant environments to force new
# discovery of blocks more often. 0 = disabled.
# CLI flag: -compactor.max-compaction-time
[max_compaction_time: <duration> | default = 1h]

# (experimental) If enabled, will delete the bucket-index, markers and debug
# files in the tenant bucket when there are no blocks left in the index.
# CLI flag: -compactor.no-blocks-file-cleanup-enabled
[no_blocks_file_cleanup_enabled: <boolean> | default = false]

# (advanced) Number of goroutines opening blocks before compaction.
# CLI flag: -compactor.max-opening-blocks-concurrency
[max_opening_blocks_concurrency: <int> | default = 1]

# (advanced) Max number of blocks that can be closed concurrently during split
# compaction. Note that closing a newly compacted block uses a lot of memory for
# writing the index.
# CLI flag: -compactor.max-closing-blocks-concurrency
[max_closing_blocks_concurrency: <int> | default = 1]

# (advanced) Number of symbols flushers used when doing split compaction.
# CLI flag: -compactor.symbols-flushers-concurrency
[symbols_flushers_concurrency: <int> | default = 1]

# (advanced) Max number of uploaded blocks that can be validated concurrently. 0
# = no limit.
# CLI flag: -compactor.max-block-upload-validation-concurrency
[max_block_upload_validation_concurrency: <int> | default = 1]

# (advanced) Number of goroutines to use when updating blocks metadata during
# bucket index updates.
# CLI flag: -compactor.update-blocks-concurrency
[update_blocks_concurrency: <int> | default = 1]

# (advanced) Comma separated list of tenants that can be compacted. If
# specified, only these tenants will be compacted by the compactor, otherwise
# all tenants can be compacted. Subject to sharding.
# CLI flag: -compactor.enabled-tenants
[enabled_tenants: <string> | default = ""]

# (advanced) Comma separated list of tenants that cannot be compacted by the
# compactor. If specified, and the compactor would normally pick a given tenant
# for compaction (via -compactor.enabled-tenants or sharding), it will be
# ignored instead.
# CLI flag: -compactor.disabled-tenants
[disabled_tenants: <string> | default = ""]

sharding_ring:
  # The key-value store used to share the hash ring across multiple instances.
  kvstore:
    # Backend storage to use for the ring. Supported values are: consul, etcd,
    # inmemory, memberlist, multi.
    # CLI flag: -compactor.ring.store
    [store: <string> | default = "memberlist"]

    # (advanced) The prefix for the keys in the store. Should end with a /.
    # CLI flag: -compactor.ring.prefix
    [prefix: <string> | default = "collectors/"]

    # The consul block configures the consul client.
    # The CLI flags prefix for this block configuration is: compactor.ring
    [consul: <consul>]

    # The etcd block configures the etcd client.
    # The CLI flags prefix for this block configuration is: compactor.ring
    [etcd: <etcd>]

    multi:
      # (advanced) Primary backend storage used by multi-client.
      # CLI flag: -compactor.ring.multi.primary
      [primary: <string> | default = ""]

      # (advanced) Secondary backend storage used by multi-client.
      # CLI flag: -compactor.ring.multi.secondary
      [secondary: <string> | default = ""]

      # (advanced) Mirror writes to secondary store.
      # CLI flag: -compactor.ring.multi.mirror-enabled
      [mirror_enabled: <boolean> | default = false]

      # (advanced) Timeout for storing value to secondary store.
      # CLI flag: -compactor.ring.multi.mirror-timeout
      [mirror_timeout: <duration> | default = 2s]

  # (advanced) Period at which to heartbeat to the ring. 0 = disabled.
  # CLI flag: -compactor.ring.heartbeat-period
  [heartbeat_period: <duration> | default = 15s]

  # (advanced) The heartbeat timeout after which compactors are considered
  # unhealthy within the ring. 0 = never (timeout disabled).
  # CLI flag: -compactor.ring.heartbeat-timeout
  [heartbeat_timeout: <duration> | default = 1m]

  # (advanced) Instance ID to register in the ring.
  # CLI flag: -compactor.ring.instance-id
  [instance_id: <string> | default = "<hostname>"]

  # List of network interface names to look up when finding the instance IP
  # address.
  # CLI flag: -compactor.ring.instance-interface-names
  [instance_interface_names: <list of strings> | default = [<private network interfaces>]]

  # (advanced) Port to advertise in the ring (defaults to
  # -server.grpc-listen-port).
  # CLI flag: -compactor.ring.instance-port
  [instance_port: <int> | default = 0]

  # (advanced) IP address to advertise in the ring. Default is auto-detected.
  # CLI flag: -compactor.ring.instance-addr
  [instance_addr: <string> | default = ""]

  # (advanced) Enable using a IPv6 instance address. (default false)
  # CLI flag: -compactor.ring.instance-enable-ipv6
  [instance_enable_ipv6: <boolean> | default = false]

  # (advanced) Minimum time to wait for ring stability at startup. 0 to disable.
  # CLI flag: -compactor.ring.wait-stability-min-duration
  [wait_stability_min_duration: <duration> | default = 0s]

  # (advanced) Maximum time to wait for ring stability at startup. If the
  # compactor ring keeps changing after this period of time, the compactor will
  # start anyway.
  # CLI flag: -compactor.ring.wait-stability-max-duration
  [wait_stability_max_duration: <duration> | default = 5m]

  # (advanced) Timeout for waiting on compactor to become ACTIVE in the ring.
  # CLI flag: -compactor.ring.wait-active-instance-timeout
  [wait_active_instance_timeout: <duration> | default = 10m]

  # (advanced) Number of consecutive timeout periods an unhealthy instance in
  # the ring is automatically removed after. Set to 0 to disable auto-forget.
  # CLI flag: -compactor.ring.auto-forget-unhealthy-periods
  [auto_forget_unhealthy_periods: <int> | default = 10]

# (advanced) The sorting to use when deciding which compaction jobs should run
# first for a given tenant. Supported values are:
# smallest-range-oldest-blocks-first, newest-blocks-first.
# CLI flag: -compactor.compaction-jobs-order
[compaction_jobs_order: <string> | default = "smallest-range-oldest-blocks-first"]

# (experimental) If enabled, the compactor constructs and uploads sparse index
# headers to object storage during each compaction cycle. This allows
# store-gateway instances to use the sparse headers from object storage instead
# of recreating them locally.
# CLI flag: -compactor.upload-sparse-index-headers
[upload_sparse_index_headers: <boolean> | default = false]
```

### store_gateway

The `store_gateway` block configures the store-gateway component.

```yaml
# The hash ring configuration.
sharding_ring:
  # The key-value store used to share the hash ring across multiple instances.
  # This option needs be set both on the store-gateway, querier and ruler when
  # running in microservices mode.
  kvstore:
    # Backend storage to use for the ring. Supported values are: consul, etcd,
    # inmemory, memberlist, multi.
    # CLI flag: -store-gateway.sharding-ring.store
    [store: <string> | default = "memberlist"]

    # (advanced) The prefix for the keys in the store. Should end with a /.
    # CLI flag: -store-gateway.sharding-ring.prefix
    [prefix: <string> | default = "collectors/"]

    # The consul block configures the consul client.
    # The CLI flags prefix for this block configuration is:
    # store-gateway.sharding-ring
    [consul: <consul>]

    # The etcd block configures the etcd client.
    # The CLI flags prefix for this block configuration is:
    # store-gateway.sharding-ring
    [etcd: <etcd>]

    multi:
      # (advanced) Primary backend storage used by multi-client.
      # CLI flag: -store-gateway.sharding-ring.multi.primary
      [primary: <string> | default = ""]

      # (advanced) Secondary backend storage used by multi-client.
      # CLI flag: -store-gateway.sharding-ring.multi.secondary
      [secondary: <string> | default = ""]

      # (advanced) Mirror writes to secondary store.
      # CLI flag: -store-gateway.sharding-ring.multi.mirror-enabled
      [mirror_enabled: <boolean> | default = false]

      # (advanced) Timeout for storing value to secondary store.
      # CLI flag: -store-gateway.sharding-ring.multi.mirror-timeout
      [mirror_timeout: <duration> | default = 2s]

  # (advanced) Period at which to heartbeat to the ring. 0 = disabled.
  # CLI flag: -store-gateway.sharding-ring.heartbeat-period
  [heartbeat_period: <duration> | default = 15s]

  # (advanced) The heartbeat timeout after which store gateways are considered
  # unhealthy within the ring. 0 = never (timeout disabled). This option needs
  # be set both on the store-gateway, querier and ruler when running in
  # microservices mode.
  # CLI flag: -store-gateway.sharding-ring.heartbeat-timeout
  [heartbeat_timeout: <duration> | default = 1m]

  # (deprecated) When enabled, a store-gateway is automatically removed from the
  # ring after failing to heartbeat the ring for a period longer than the
  # configured -store-gateway.sharding-ring.auto-forget-unhealthy-periods times
  # the configured -store-gateway.sharding-ring.heartbeat-timeout. This setting
  # is deprecated. Set
  # -store-gateway.sharding-ring.auto-forget-unhealthy-periods to 0 to disable
  # auto-forget.
  # CLI flag: -store-gateway.sharding-ring.auto-forget-enabled
  [auto_forget_enabled: <boolean> | default = true]

  # (advanced) Number of consecutive timeout periods an unhealthy instance in
  # the ring is automatically removed after. Set to 0 to disable auto-forget.
  # CLI flag: -store-gateway.sharding-ring.auto-forget-unhealthy-periods
  [auto_forget_unhealthy_periods: <int> | default = 10]

  # (advanced) The replication factor to use when sharding blocks. This option
  # needs be set both on the store-gateway, querier and ruler when running in
  # microservices mode.
  # CLI flag: -store-gateway.sharding-ring.replication-factor
  [replication_factor: <int> | default = 3]

  # File path where tokens are stored. If empty, tokens are not stored at
  # shutdown and restored at startup.
  # CLI flag: -store-gateway.sharding-ring.tokens-file-path
  [tokens_file_path: <string> | default = ""]

  # (advanced) Number of tokens for each store-gateway.
  # CLI flag: -store-gateway.sharding-ring.num-tokens
  [num_tokens: <int> | default = 512]

  # True to enable zone-awareness and replicate blocks across different
  # availability zones. This option needs be set both on the store-gateway,
  # querier and ruler when running in microservices mode.
  # CLI flag: -store-gateway.sharding-ring.zone-awareness-enabled
  [zone_awareness_enabled: <boolean> | default = false]

  # (advanced) Minimum time to wait for ring stability at startup, if set to
  # positive value.
  # CLI flag: -store-gateway.sharding-ring.wait-stability-min-duration
  [wait_stability_min_duration: <duration> | default = 0s]

  # (advanced) Maximum time to wait for ring stability at startup. If the
  # store-gateway ring keeps changing after this period of time, the
  # store-gateway will start anyway.
  # CLI flag: -store-gateway.sharding-ring.wait-stability-max-duration
  [wait_stability_max_duration: <duration> | default = 5m]

  # (advanced) Instance ID to register in the ring.
  # CLI flag: -store-gateway.sharding-ring.instance-id
  [instance_id: <string> | default = "<hostname>"]

  # List of network interface names to look up when finding the instance IP
  # address.
  # CLI flag: -store-gateway.sharding-ring.instance-interface-names
  [instance_interface_names: <list of strings> | default = [<private network interfaces>]]

  # (advanced) Port to advertise in the ring (defaults to
  # -server.grpc-listen-port).
  # CLI flag: -store-gateway.sharding-ring.instance-port
  [instance_port: <int> | default = 0]

  # (advanced) IP address to advertise in the ring. Default is auto-detected.
  # CLI flag: -store-gateway.sharding-ring.instance-addr
  [instance_addr: <string> | default = ""]

  # (advanced) Enable using a IPv6 instance address. (default false)
  # CLI flag: -store-gateway.sharding-ring.instance-enable-ipv6
  [instance_enable_ipv6: <boolean> | default = false]

  # The availability zone where this instance is running. Required if
  # zone-awareness is enabled.
  # CLI flag: -store-gateway.sharding-ring.instance-availability-zone
  [instance_availability_zone: <string> | default = ""]

  # Unregister from the ring upon clean shutdown.
  # CLI flag: -store-gateway.sharding-ring.unregister-on-shutdown
  [unregister_on_shutdown: <boolean> | default = true]

# Experimental dynamic replication configuration.
dynamic_replication:
  # (experimental) Use a higher number of replicas for recent blocks. Useful to
  # spread query load more evenly at the cost of slightly higher disk usage.
  # CLI flag: -store-gateway.dynamic-replication.enabled
  [enabled: <boolean> | default = false]

  # (experimental) Threshold of the most recent sample in a block used to
  # determine it is eligible for higher than default replication. If a block has
  # samples within this amount of time, it is considered recent and will be
  # owned by more replicas.
  # CLI flag: -store-gateway.dynamic-replication.max-time-threshold
  [max_time_threshold: <duration> | default = 25h]

  # (experimental) Multiple of the default replication factor that should be
  # used for recent blocks. Minimum value is 2
  # CLI flag: -store-gateway.dynamic-replication.multiple
  [multiple: <int> | default = 5]

# (advanced) Comma separated list of tenants that can be loaded by the
# store-gateway. If specified, only blocks for these tenants will be loaded by
# the store-gateway, otherwise all tenants can be loaded. Subject to sharding.
# CLI flag: -store-gateway.enabled-tenants
[enabled_tenants: <string> | default = ""]

# (advanced) Comma separated list of tenants that cannot be loaded by the
# store-gateway. If specified, and the store-gateway would normally load a given
# tenant for (via -store-gateway.enabled-tenants or sharding), it will be
# ignored instead.
# CLI flag: -store-gateway.disabled-tenants
[disabled_tenants: <string> | default = ""]
```

### memcached

The `memcached` block configures the Memcached-based caching backend. The supported CLI flags `<prefix>` used to reference this configuration block are:

- `blocks-storage.bucket-store.chunks-cache`
- `blocks-storage.bucket-store.index-cache`
- `blocks-storage.bucket-store.metadata-cache`
- `query-frontend.results-cache`
- `ruler-storage.cache`

&nbsp;

```yaml
# Comma-separated list of memcached addresses. Each address can be an IP
# address, hostname, or an entry specified in the DNS Service Discovery format.
# CLI flag: -<prefix>.memcached.addresses
[addresses: <string> | default = ""]

# The socket read/write timeout.
# CLI flag: -<prefix>.memcached.timeout
[timeout: <duration> | default = 200ms]

# The connection timeout.
# CLI flag: -<prefix>.memcached.connect-timeout
[connect_timeout: <duration> | default = 200ms]

# (advanced) The minimum number of idle connections to keep open as a percentage
# (0-100) of the number of recently used idle connections. If negative, idle
# connections are kept open indefinitely.
# CLI flag: -<prefix>.memcached.min-idle-connections-headroom-percentage
[min_idle_connections_headroom_percentage: <float> | default = -1]

# (advanced) The maximum number of idle connections that will be maintained per
# address.
# CLI flag: -<prefix>.memcached.max-idle-connections
[max_idle_connections: <int> | default = 100]

# (advanced) The maximum number of concurrent asynchronous operations can occur.
# CLI flag: -<prefix>.memcached.max-async-concurrency
[max_async_concurrency: <int> | default = 50]

# (advanced) The maximum number of enqueued asynchronous operations allowed.
# CLI flag: -<prefix>.memcached.max-async-buffer-size
[max_async_buffer_size: <int> | default = 25000]

# (advanced) The maximum number of concurrent connections running get
# operations. If set to 0, concurrency is unlimited.
# CLI flag: -<prefix>.memcached.max-get-multi-concurrency
[max_get_multi_concurrency: <int> | default = 100]

# (advanced) The maximum number of keys a single underlying get operation should
# run. If more keys are specified, internally keys are split into multiple
# batches and fetched concurrently, honoring the max concurrency. If set to 0,
# the max batch size is unlimited.
# CLI flag: -<prefix>.memcached.max-get-multi-batch-size
[max_get_multi_batch_size: <int> | default = 100]

# (advanced) The maximum size of an item stored in memcached, in bytes. Bigger
# items are not stored. If set to 0, no maximum size is enforced.
# CLI flag: -<prefix>.memcached.max-item-size
[max_item_size: <int> | default = 1048576]

# (advanced) Enable connecting to Memcached with TLS.
# CLI flag: -<prefix>.memcached.tls-enabled
[tls_enabled: <boolean> | default = false]

# (advanced) Path to the client certificate, which will be used for
# authenticating with the server. Also requires the key path to be configured.
# CLI flag: -<prefix>.memcached.tls-cert-path
[tls_cert_path: <string> | default = ""]

# (advanced) Path to the key for the client certificate. Also requires the
# client certificate to be configured.
# CLI flag: -<prefix>.memcached.tls-key-path
[tls_key_path: <string> | default = ""]

# (advanced) Path to the CA certificates to validate server certificate against.
# If not set, the host's root CA certificates are used.
# CLI flag: -<prefix>.memcached.tls-ca-path
[tls_ca_path: <string> | default = ""]

# (advanced) Override the expected name on the server certificate.
# CLI flag: -<prefix>.memcached.tls-server-name
[tls_server_name: <string> | default = ""]

# (advanced) Skip validating server certificate.
# CLI flag: -<prefix>.memcached.tls-insecure-skip-verify
[tls_insecure_skip_verify: <boolean> | default = false]

# (advanced) Override the default cipher suite list (separated by commas).
# Allowed values:
#
# Secure Ciphers:
# - TLS_AES_128_GCM_SHA256
# - TLS_AES_256_GCM_SHA384
# - TLS_CHACHA20_POLY1305_SHA256
# - TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA
# - TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA
# - TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA
# - TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA
# - TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256
# - TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384
# - TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256
# - TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384
# - TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256
# - TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256
#
# Insecure Ciphers:
# - TLS_RSA_WITH_RC4_128_SHA
# - TLS_RSA_WITH_3DES_EDE_CBC_SHA
# - TLS_RSA_WITH_AES_128_CBC_SHA
# - TLS_RSA_WITH_AES_256_CBC_SHA
# - TLS_RSA_WITH_AES_128_CBC_SHA256
# - TLS_RSA_WITH_AES_128_GCM_SHA256
# - TLS_RSA_WITH_AES_256_GCM_SHA384
# - TLS_ECDHE_ECDSA_WITH_RC4_128_SHA
# - TLS_ECDHE_RSA_WITH_RC4_128_SHA
# - TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA
# - TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256
# - TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256
# CLI flag: -<prefix>.memcached.tls-cipher-suites
[tls_cipher_suites: <string> | default = ""]

# (advanced) Override the default minimum TLS version. Allowed values:
# VersionTLS10, VersionTLS11, VersionTLS12, VersionTLS13
# CLI flag: -<prefix>.memcached.tls-min-version
[tls_min_version: <string> | default = ""]

# (experimental) Allow client creation even if initial DNS resolution fails.
# CLI flag: -<prefix>.memcached.dns-ignore-startup-failures
[dns_ignore_startup_failures: <boolean> | default = true]
```

### s3_storage_backend

The s3_backend block configures the connection to Amazon S3 object storage backend. The supported CLI flags `<prefix>` used to reference this configuration block are:

- `alertmanager-storage`
- `blocks-storage`
- `common.storage`
- `ruler-storage`

&nbsp;

```yaml
# The S3 bucket endpoint. It could be an AWS S3 endpoint listed at
# https://docs.aws.amazon.com/general/latest/gr/s3.html or the address of an
# S3-compatible service in hostname:port format.
# CLI flag: -<prefix>.s3.endpoint
[endpoint: <string> | default = ""]

# S3 region. If unset, the client will issue a S3 GetBucketLocation API call to
# autodetect it.
# CLI flag: -<prefix>.s3.region
[region: <string> | default = ""]

# S3 bucket name
# CLI flag: -<prefix>.s3.bucket-name
[bucket_name: <string> | default = ""]

# S3 secret access key
# CLI flag: -<prefix>.s3.secret-access-key
[secret_access_key: <string> | default = ""]

# S3 access key ID
# CLI flag: -<prefix>.s3.access-key-id
[access_key_id: <string> | default = ""]

# S3 session token
# CLI flag: -<prefix>.s3.session-token
[session_token: <string> | default = ""]

# (advanced) If enabled, use http:// for the S3 endpoint instead of https://.
# This could be useful in local dev/test environments while using an
# S3-compatible backend storage, like Minio.
# CLI flag: -<prefix>.s3.insecure
[insecure: <boolean> | default = false]

# (advanced) The signature version to use for authenticating against S3.
# Supported values are: v4, v2.
# CLI flag: -<prefix>.s3.signature-version
[signature_version: <string> | default = "v4"]

# (advanced) Use a specific version of the S3 list object API. Supported values
# are v1 or v2. Default is unset.
# CLI flag: -<prefix>.s3.list-objects-version
[list_objects_version: <string> | default = ""]

# (advanced) Bucket lookup style type, used to access bucket in S3-compatible
# service. Default is auto. Supported values are: auto, path, virtual-hosted.
# CLI flag: -<prefix>.s3.bucket-lookup-type
[bucket_lookup_type: <string> | default = "auto"]

# (experimental) When enabled, direct all AWS S3 requests to the dual-stack
# IPv4/IPv6 endpoint for the configured region.
# CLI flag: -<prefix>.s3.dualstack-enabled
[dualstack_enabled: <boolean> | default = true]

# (experimental) The S3 storage class to use, not set by default. Details can be
# found at https://aws.amazon.com/s3/storage-classes/. Supported values are:
# STANDARD, REDUCED_REDUNDANCY, STANDARD_IA, ONEZONE_IA, INTELLIGENT_TIERING,
# GLACIER, DEEP_ARCHIVE, OUTPOSTS, GLACIER_IR, SNOW, EXPRESS_ONEZONE,
# FSX_OPENZFS
# CLI flag: -<prefix>.s3.storage-class
[storage_class: <string> | default = ""]

# (experimental) If enabled, it will use the default authentication methods of
# the AWS SDK for go based on known environment variables and known AWS config
# files.
# CLI flag: -<prefix>.s3.native-aws-auth-enabled
[native_aws_auth_enabled: <boolean> | default = false]

# (experimental) The minimum file size in bytes used for multipart uploads. If
# 0, the value is optimally computed for each object.
# CLI flag: -<prefix>.s3.part-size
[part_size: <int> | default = 0]

# (experimental) If enabled, a Content-MD5 header is sent with S3 Put Object
# requests. Consumes more resources to compute the MD5, but may improve
# compatibility with object storage services that do not support checksums.
# CLI flag: -<prefix>.s3.send-content-md5
[send_content_md5: <boolean> | default = false]

# Accessing S3 resources using temporary, secure credentials provided by AWS
# Security Token Service.
# CLI flag: -<prefix>.s3.sts-endpoint
[sts_endpoint: <string> | default = ""]

sse:
  # Enable AWS Server Side Encryption. Supported values: SSE-KMS, SSE-S3.
  # CLI flag: -<prefix>.s3.sse.type
  [type: <string> | default = ""]

  # KMS Key ID used to encrypt objects in S3
  # CLI flag: -<prefix>.s3.sse.kms-key-id
  [kms_key_id: <string> | default = ""]

  # KMS Encryption Context used for object encryption. It expects JSON formatted
  # string.
  # CLI flag: -<prefix>.s3.sse.kms-encryption-context
  [kms_encryption_context: <string> | default = ""]

http:
  # (advanced) The time an idle connection remains idle before closing.
  # CLI flag: -<prefix>.s3.http.idle-conn-timeout
  [idle_conn_timeout: <duration> | default = 1m30s]

  # (advanced) The amount of time the client waits for a server's response
  # headers.
  # CLI flag: -<prefix>.s3.http.response-header-timeout
  [response_header_timeout: <duration> | default = 2m]

  # (advanced) If the client connects to object storage via HTTPS and this
  # option is enabled, the client accepts any certificate and hostname.
  # CLI flag: -<prefix>.s3.http.insecure-skip-verify
  [insecure_skip_verify: <boolean> | default = false]

  # (advanced) Maximum time to wait for a TLS handshake. Set to 0 for no limit.
  # CLI flag: -<prefix>.s3.tls-handshake-timeout
  [tls_handshake_timeout: <duration> | default = 10s]

  # (advanced) The time to wait for a server's first response headers after
  # fully writing the request headers if the request has an Expect header. Set
  # to 0 to send the request body immediately.
  # CLI flag: -<prefix>.s3.expect-continue-timeout
  [expect_continue_timeout: <duration> | default = 1s]

  # (advanced) Maximum number of idle (keep-alive) connections across all hosts.
  # Set to 0 for no limit.
  # CLI flag: -<prefix>.s3.max-idle-connections
  [max_idle_connections: <int> | default = 100]

  # (advanced) Maximum number of idle (keep-alive) connections to keep per-host.
  # Set to 0 to use a built-in default value of 2.
  # CLI flag: -<prefix>.s3.max-idle-connections-per-host
  [max_idle_connections_per_host: <int> | default = 100]

  # (advanced) Maximum number of connections per host. Set to 0 for no limit.
  # CLI flag: -<prefix>.s3.max-connections-per-host
  [max_connections_per_host: <int> | default = 0]

  # (advanced) Path to the Certificate Authority (CA) certificates to validate
  # the server certificate. If not set, the host's root CA certificates are
  # used.
  # CLI flag: -<prefix>.s3.http.tls-ca-path
  [tls_ca_path: <string> | default = ""]

  # (advanced) Path to the client certificate, which is used for authenticating
  # with the server. This setting also requires you to configure the key path.
  # CLI flag: -<prefix>.s3.http.tls-cert-path
  [tls_cert_path: <string> | default = ""]

  # (advanced) Path to the key for the client certificate. This setting also
  # requires you to configure the client certificate.
  # CLI flag: -<prefix>.s3.http.tls-key-path
  [tls_key_path: <string> | default = ""]

  # (advanced) Override the expected name on the server certificate.
  # CLI flag: -<prefix>.s3.http.tls-server-name
  [tls_server_name: <string> | default = ""]

trace:
  # (advanced) When enabled, low-level S3 HTTP operation information is logged
  # at the debug level.
  # CLI flag: -<prefix>.s3.trace.enabled
  [enabled: <boolean> | default = false]
```

### gcs_storage_backend

The gcs_backend block configures the connection to Google Cloud Storage object storage backend. The supported CLI flags `<prefix>` used to reference this configuration block are:

- `alertmanager-storage`
- `blocks-storage`
- `common.storage`
- `ruler-storage`

&nbsp;

```yaml
# GCS bucket name
# CLI flag: -<prefix>.gcs.bucket-name
[bucket_name: <string> | default = ""]

# JSON either from a Google Developers Console client_credentials.json file, or
# a Google Developers service account key. Needs to be valid JSON, not a
# filesystem path. If empty, fallback to Google default logic:
# 1. A JSON file whose path is specified by the GOOGLE_APPLICATION_CREDENTIALS
# environment variable. For workload identity federation, refer to
# https://cloud.google.com/iam/docs/how-to#using-workload-identity-federation on
# how to generate the JSON configuration file for on-prem/non-Google cloud
# platforms.
# 2. A JSON file in a location known to the gcloud command-line tool:
# $HOME/.config/gcloud/application_default_credentials.json.
# 3. On Google Compute Engine it fetches credentials from the metadata server.
# CLI flag: -<prefix>.gcs.service-account
[service_account: <string> | default = ""]

http:
  # (advanced) The time an idle connection remains idle before closing.
  # CLI flag: -<prefix>.gcs.http.idle-conn-timeout
  [idle_conn_timeout: <duration> | default = 1m30s]

  # (advanced) The amount of time the client waits for a server's response
  # headers.
  # CLI flag: -<prefix>.gcs.http.response-header-timeout
  [response_header_timeout: <duration> | default = 2m]

  # (advanced) If the client connects to object storage via HTTPS and this
  # option is enabled, the client accepts any certificate and hostname.
  # CLI flag: -<prefix>.gcs.http.insecure-skip-verify
  [insecure_skip_verify: <boolean> | default = false]

  # (advanced) Maximum time to wait for a TLS handshake. Set to 0 for no limit.
  # CLI flag: -<prefix>.gcs.tls-handshake-timeout
  [tls_handshake_timeout: <duration> | default = 10s]

  # (advanced) The time to wait for a server's first response headers after
  # fully writing the request headers if the request has an Expect header. Set
  # to 0 to send the request body immediately.
  # CLI flag: -<prefix>.gcs.expect-continue-timeout
  [expect_continue_timeout: <duration> | default = 1s]

  # (advanced) Maximum number of idle (keep-alive) connections across all hosts.
  # Set to 0 for no limit.
  # CLI flag: -<prefix>.gcs.max-idle-connections
  [max_idle_connections: <int> | default = 100]

  # (advanced) Maximum number of idle (keep-alive) connections to keep per-host.
  # Set to 0 to use a built-in default value of 2.
  # CLI flag: -<prefix>.gcs.max-idle-connections-per-host
  [max_idle_connections_per_host: <int> | default = 100]

  # (advanced) Maximum number of connections per host. Set to 0 for no limit.
  # CLI flag: -<prefix>.gcs.max-connections-per-host
  [max_connections_per_host: <int> | default = 0]

  # (advanced) Path to the Certificate Authority (CA) certificates to validate
  # the server certificate. If not set, the host's root CA certificates are
  # used.
  # CLI flag: -<prefix>.gcs.http.tls-ca-path
  [tls_ca_path: <string> | default = ""]

  # (advanced) Path to the client certificate, which is used for authenticating
  # with the server. This setting also requires you to configure the key path.
  # CLI flag: -<prefix>.gcs.http.tls-cert-path
  [tls_cert_path: <string> | default = ""]

  # (advanced) Path to the key for the client certificate. This setting also
  # requires you to configure the client certificate.
  # CLI flag: -<prefix>.gcs.http.tls-key-path
  [tls_key_path: <string> | default = ""]

  # (advanced) Override the expected name on the server certificate.
  # CLI flag: -<prefix>.gcs.http.tls-server-name
  [tls_server_name: <string> | default = ""]
```

### azure_storage_backend

The `azure_storage_backend` block configures the connection to Azure object storage backend. The supported CLI flags `<prefix>` used to reference this configuration block are:

- `alertmanager-storage`
- `blocks-storage`
- `common.storage`
- `ruler-storage`

&nbsp;

```yaml
# Azure storage account name
# CLI flag: -<prefix>.azure.account-name
[account_name: <string> | default = ""]

# Azure storage account key. If unset, Azure managed identities will be used for
# authentication instead.
# CLI flag: -<prefix>.azure.account-key
[account_key: <string> | default = ""]

# If `connection-string` is set, the value of `endpoint-suffix` will not be
# used. Use this method over `account-key` if you need to authenticate via a SAS
# token. Or if you use the Azurite emulator.
# CLI flag: -<prefix>.azure.connection-string
[connection_string: <string> | default = ""]

# Azure storage container name
# CLI flag: -<prefix>.azure.container-name
[container_name: <string> | default = ""]

# Azure storage endpoint suffix without schema. The account name will be
# prefixed to this value to create the FQDN. If set to empty string, default
# endpoint suffix is used.
# CLI flag: -<prefix>.azure.endpoint-suffix
[endpoint_suffix: <string> | default = ""]

# (advanced) Number of retries for recoverable errors
# CLI flag: -<prefix>.azure.max-retries
[max_retries: <int> | default = 20]

# (advanced) User assigned managed identity. If empty, then System assigned
# identity is used.
# CLI flag: -<prefix>.azure.user-assigned-id
[user_assigned_id: <string> | default = ""]

http:
  # (advanced) The time an idle connection remains idle before closing.
  # CLI flag: -<prefix>.azure.http.idle-conn-timeout
  [idle_conn_timeout: <duration> | default = 1m30s]

  # (advanced) The amount of time the client waits for a server's response
  # headers.
  # CLI flag: -<prefix>.azure.http.response-header-timeout
  [response_header_timeout: <duration> | default = 2m]

  # (advanced) If the client connects to object storage via HTTPS and this
  # option is enabled, the client accepts any certificate and hostname.
  # CLI flag: -<prefix>.azure.http.insecure-skip-verify
  [insecure_skip_verify: <boolean> | default = false]

  # (advanced) Maximum time to wait for a TLS handshake. Set to 0 for no limit.
  # CLI flag: -<prefix>.azure.tls-handshake-timeout
  [tls_handshake_timeout: <duration> | default = 10s]

  # (advanced) The time to wait for a server's first response headers after
  # fully writing the request headers if the request has an Expect header. Set
  # to 0 to send the request body immediately.
  # CLI flag: -<prefix>.azure.expect-continue-timeout
  [expect_continue_timeout: <duration> | default = 1s]

  # (advanced) Maximum number of idle (keep-alive) connections across all hosts.
  # Set to 0 for no limit.
  # CLI flag: -<prefix>.azure.max-idle-connections
  [max_idle_connections: <int> | default = 100]

  # (advanced) Maximum number of idle (keep-alive) connections to keep per-host.
  # Set to 0 to use a built-in default value of 2.
  # CLI flag: -<prefix>.azure.max-idle-connections-per-host
  [max_idle_connections_per_host: <int> | default = 100]

  # (advanced) Maximum number of connections per host. Set to 0 for no limit.
  # CLI flag: -<prefix>.azure.max-connections-per-host
  [max_connections_per_host: <int> | default = 0]

  # (advanced) Path to the Certificate Authority (CA) certificates to validate
  # the server certificate. If not set, the host's root CA certificates are
  # used.
  # CLI flag: -<prefix>.azure.http.tls-ca-path
  [tls_ca_path: <string> | default = ""]

  # (advanced) Path to the client certificate, which is used for authenticating
  # with the server. This setting also requires you to configure the key path.
  # CLI flag: -<prefix>.azure.http.tls-cert-path
  [tls_cert_path: <string> | default = ""]

  # (advanced) Path to the key for the client certificate. This setting also
  # requires you to configure the client certificate.
  # CLI flag: -<prefix>.azure.http.tls-key-path
  [tls_key_path: <string> | default = ""]

  # (advanced) Override the expected name on the server certificate.
  # CLI flag: -<prefix>.azure.http.tls-server-name
  [tls_server_name: <string> | default = ""]
```

### swift_storage_backend

The `swift_storage_backend` block configures the connection to OpenStack Object Storage (Swift) object storage backend. The supported CLI flags `<prefix>` used to reference this configuration block are:

- `alertmanager-storage`
- `blocks-storage`
- `common.storage`
- `ruler-storage`

&nbsp;

```yaml
# OpenStack Swift application credential id
# CLI flag: -<prefix>.swift.application-credential-id
[application_credential_id: <string> | default = ""]

# OpenStack Swift application credential name
# CLI flag: -<prefix>.swift.application-credential-name
[application_credential_name: <string> | default = ""]

# OpenStack Swift application credential secret
# CLI flag: -<prefix>.swift.application-credential-secret
[application_credential_secret: <string> | default = ""]

# OpenStack Swift authentication API version. 0 to autodetect.
# CLI flag: -<prefix>.swift.auth-version
[auth_version: <int> | default = 0]

# OpenStack Swift authentication URL
# CLI flag: -<prefix>.swift.auth-url
[auth_url: <string> | default = ""]

# OpenStack Swift username.
# CLI flag: -<prefix>.swift.username
[username: <string> | default = ""]

# OpenStack Swift user's domain name.
# CLI flag: -<prefix>.swift.user-domain-name
[user_domain_name: <string> | default = ""]

# OpenStack Swift user's domain ID.
# CLI flag: -<prefix>.swift.user-domain-id
[user_domain_id: <string> | default = ""]

# OpenStack Swift user ID.
# CLI flag: -<prefix>.swift.user-id
[user_id: <string> | default = ""]

# OpenStack Swift API key.
# CLI flag: -<prefix>.swift.password
[password: <string> | default = ""]

# OpenStack Swift user's domain ID.
# CLI flag: -<prefix>.swift.domain-id
[domain_id: <string> | default = ""]

# OpenStack Swift user's domain name.
# CLI flag: -<prefix>.swift.domain-name
[domain_name: <string> | default = ""]

# OpenStack Swift project ID (v2,v3 auth only).
# CLI flag: -<prefix>.swift.project-id
[project_id: <string> | default = ""]

# OpenStack Swift project name (v2,v3 auth only).
# CLI flag: -<prefix>.swift.project-name
[project_name: <string> | default = ""]

# ID of the OpenStack Swift project's domain (v3 auth only), only needed if it
# differs the from user domain.
# CLI flag: -<prefix>.swift.project-domain-id
[project_domain_id: <string> | default = ""]

# Name of the OpenStack Swift project's domain (v3 auth only), only needed if it
# differs from the user domain.
# CLI flag: -<prefix>.swift.project-domain-name
[project_domain_name: <string> | default = ""]

# OpenStack Swift Region to use (v2,v3 auth only).
# CLI flag: -<prefix>.swift.region-name
[region_name: <string> | default = ""]

# Name of the OpenStack Swift container to put chunks in.
# CLI flag: -<prefix>.swift.container-name
[container_name: <string> | default = ""]

# (advanced) Max retries on requests error.
# CLI flag: -<prefix>.swift.max-retries
[max_retries: <int> | default = 3]

# (advanced) Time after which a connection attempt is aborted.
# CLI flag: -<prefix>.swift.connect-timeout
[connect_timeout: <duration> | default = 10s]

# (advanced) Time after which an idle request is aborted. The timeout watchdog
# is reset each time some data is received, so the timeout triggers after X time
# no data is received on a request.
# CLI flag: -<prefix>.swift.request-timeout
[request_timeout: <duration> | default = 5s]
```

### filesystem_storage_backend

The `filesystem_storage_backend` block configures the usage of local file system as object storage backend. The supported CLI flags `<prefix>` used to reference this configuration block are:

- `alertmanager-storage`
- `blocks-storage`
- `common.storage`
- `ruler-storage`

&nbsp;

```yaml
# Local filesystem storage directory.
# CLI flag: -<prefix>.filesystem.dir
[dir: <string> | default = ""]
```
