---
title: "Grafana Mimir Helm chart version 5.8 release notes"
menuTitle: "V5.8 release notes"
description: "Release notes for Grafana Mimir Helm chart version 5.8"
weight: 300
---

# Grafana Mimir Helm chart version 5.8 release notes

Grafana Labs is excited to announce version 5.8 of the Grafana Mimir Helm chart, which is compatible with Grafana Mimir v2.17 and Grafana Enterprise Metrics (GEM) v2.17. The `mimir-distributed` Helm chart is the best way to install Mimir on Kubernetes.

The highlights that follow include the top features, enhancements, and bug fixes in this release. For a comprehensive list of changes, see the [Helm chart changelog](https://github.com/grafana/mimir/tree/main/operations/helm/charts/mimir-distributed/CHANGELOG.md).

## Important changes

KEDA autoscaling has changed `kedaAutoscaling.toPromQLLabelSelector` from an object to a list of strings, adding support for all PromQL operators.

The Memcached timeout for the ruler-storage cache has increased from 200 milliseconds to 500 milliseconds.

Grafana Mimir now exports OTel traces instead of Jaeger traces. As a result, the environment variable `JAEGER_REPORTER_MAX_QUEUE_SIZE` is no longer set by default. Components use OTel's default value of 2048 unless explicitly configured. You can still configure `JAEGER_REPORTER_MAX_QUEUE_SIZE` if you configure tracing using Jaeger environment variables, and you can always set `OTEL_BSP_MAX_QUEUE_SIZE` for OTel configuration. For more information, refer to [Configure Grafana Mimir tracing](https://grafana.com/docs/mimir/<MIMIR_VERSION>/configure/configure-tracing/) in the Mimir documentation.

The rollout-operator has been updated to the latest release, which includes support for OTEL\_ tracing environment variables.

Memberlist configuration for ingesters now enables `memberlist.abort-if-fast-join-fails`.

Memcached now sets resource requests for the Memcached Prometheus exporter by default.

A new `store_gateway.grpcMaxQueryResponseSizeBytes` value has been added to set the maximum store-gateway gRPC query response send size, and corresponding querier receive size, with a default of 200MB.

## Features and enhancements

There are new values for setting annotations and labels for the rollout-operator.
