// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
)

func CopyOrigMappingSlice(dest, src []*otlpprofiles.Mapping) []*otlpprofiles.Mapping {
	var newDest []*otlpprofiles.Mapping
	if cap(dest) < len(src) {
		newDest = make([]*otlpprofiles.Mapping, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigMapping()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteOrigMapping(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigMapping()
		}
	}
	for i := range src {
		CopyOrigMapping(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestMappingSlice() []*otlpprofiles.Mapping {
	orig := make([]*otlpprofiles.Mapping, 5)
	orig[0] = NewOrigMapping()
	orig[1] = GenTestOrigMapping()
	orig[2] = NewOrigMapping()
	orig[3] = GenTestOrigMapping()
	orig[4] = NewOrigMapping()
	return orig
}
