---
title: "Grafana Mimir version 2.17 release notes"
menuTitle: "V2.17 release notes"
description: "Release notes for Grafana Mimir version 2.17"
weight: 1100
---

# Grafana Mimir version 2.17 release notes

<!-- vale Grafana.GoogleWill = NO -->
<!-- vale Grafana.Timeless = NO -->
<!-- Release notes are often future focused -->

Grafana Labs is excited to announce version 2.17 of Grafana Mimir.

The highlights that follow include the top features, enhancements, and bug fixes in this release.
For the complete list of changes, refer to the [CHANGELOG](https://github.com/grafana/mimir/blob/main/CHANGELOG.md).

## Features and enhancements

MQE is enabled by default in queriers. MQE provides benefits over the Prometheus engine, inluding reduced memory and CPU consumption and improved performance. To use the Prometheus engine instead of MQE, set `-querier.query-engine=prometheus`.

Grafana Mimir now supports using the Mimir Query Engine (MQE) in query-frontends in addition to queriers. You can enable MQE in query-frontends by setting the experimental CLI flag `-query-frontend.query-engine=mimir` or through the corresponding YAML option.

You can export the `cortex_ingester_attributed_active_native_histogram_series` and `cortex_ingester_attributed_active_native_histogram_buckets` native histogram cost attribution metrics to a custom Prometheus registry with user-specified labels.

Grafana Mimir supports converting OTel explicit bucket histograms to Prometheus native histograms with custom buckets using the `distributor.otel-convert-histograms-to-nhcb` flag.

The following experimental features have been removed:

- The `max_cost_attribution_labels_per_user` cost attribution limit
- Read-write deployment mode in the mixin

## Important changes

In Grafana Mimir 2.17, the following behavior has changed:

The following default configuration values now apply to the memberlist KV store:

| Key                                 | Value   |
| ----------------------------------- | ------- |
| `memberlist.packet-dial-timeout`    | `500ms` |
| `memberlist.packet-write-timeout`   | `500ms` |
| `memberlist.max-concurrent-writes`  | `5`     |
| `memberlist.acquire-writer-timeout` | `1s`    |

These values perform better but might cause long-running packets to be dropped in high-latency networks.

The `-ruler-storage.cache.rule-group-enabled` experimental CLI flag has been removed. Caching rule group contents is now always enabled when a cache is configured for the ruler.

The `-ingester.ooo-native-histograms-ingestion-enabled` CLI flag and corresponding `ooo_native_histograms_ingestion_enabled` runtime configuration option have been removed. Out-of-order native histograms are now enabled whenever both native histogram and out-of-order ingestion is enabled.

The `-ingester.stream-chunks-when-using-blocks` CLI flag and corresponding `ingester_stream_chunks_when_using_blocks` runtime configuration option have been deprecated and will be removed in a future release.

The `cortex_distributor_label_values_with_newlines_total` metric has been removed.

In the distributor, `memberlist` is marked as a stable option for backend storage for the high availability tracker. `etcd` has been deprecated for this purpose.

## Experimental features

Grafana Mimir 2.17 includes some features that are experimental and disabled by default.
Use these features with caution and report any issues that you encounter:

- Prometheus Remote-Write 2.0 protocol.
- Duration expressions in PromQL. These are simple arithmetics on numbers in offset and range specification. For example, `rate(http_requests_total[5m * 2])`.
- Promoting OTel scope metadata, including name, version, schema URL, and attributes, to metric labels, prefixed with `otel_scope_`. Enable this feature through the `-distributor.otel-promote-scope-metadata` flag.
- Allowing primitive delta metrics ingestion through the OTLP endpoint with the `-distributor.otel-native-delta-ingestion` option.
- Support for `sort_by_label` and `sort_by_label_desc` PromQL functions.
- Support for cluster validation in HTTP calls. When enabled, the HTTP server verifies if a request coming from an HTTP client comes from an expected cluster. You can configure this validation with the following options:
  - `-server.cluster-validation.label`
  - `-server.cluster-validation.http.enabled`
  - `-server.cluster-validation.http.soft-validation`
  - `-server.cluster-validation.http.exclude-paths`

## Bug fixes

For a detailed list of bug fixes, refer to the [CHANGELOG](https://github.com/grafana/mimir/blob/main/CHANGELOG.md).

### Helm chart improvements

The Grafana Mimir and Grafana Enterprise Metrics Helm chart is released independently.
Refer to the [Grafana Mimir Helm chart documentation](/docs/helm-charts/mimir-distributed/latest/).
