---
title: "Grafana Mimir Helm chart version 5.3 release notes"
menuTitle: "V5.3 release notes"
description: "Release notes for Grafana Mimir Helm chart version 5.3"
weight: 300
---

# Grafana Mimir Helm chart version 5.3 release notes

Grafana Labs is excited to announce version 5.3 of the Grafana Mimir Helm chart, which is compatible with Grafana Mimir v2.12 or Grafana Enterprise Metrics (GEM) v2.12. The `mimir-distributed` Helm chart is the best way to install Mimir on Kubernetes.

The highlights that follow include the top features, enhancements, and bug fixes in this release. For a comprehensive list of changes, see the [Helm chart changelog](https://github.com/grafana/mimir/tree/main/operations/helm/charts/mimir-distributed/CHANGELOG.md).

## Important changes

A number of timeout settings have been improved upon:

- Relaxed the hash ring heartbeat period and timeout for the distributor, ingester, store-gateway and compactor. This reduces load in intra component communication with the tradeoff that abrupt component failures take longer to detect. The new values are taken from Grafana Cloud Metrics operations.
- Increased the timeout for writing recording rule results to `10s` to accommodate large result sets.
- Increased the distributor termination grace period from `60s` to `100s` to give more time for a clean termination.
- Increased the read timeout for chunks and index caches using memcached from `450ms` to `750ms`.
- Tuned the GRPC maximum connection age and shutdown delay for the distributor and query-frontend components to avoid invoking components that are shutting down.

## Features and enhancements

Notable enhancements are as follows:

- Added experimental feature for deploying [KEDA](https://keda.sh) ScaledObjects as part of the helm chart for the components: distributor, querier, query-frontend and ruler. For more details please see the values sections `kedaAutoscaling`, `distributor.kedaAutoscaling`, `ruler.kedaAutoscaling`, `query_frontend.kedaAutoscaling`, and `querier.kedaAutoscaling`, and the [Helm chart changelog](https://github.com/grafana/mimir/tree/main/operations/helm/charts/mimir-distributed/CHANGELOG.md).
- Gateway: Added option for configuring whether or not NGINX binds IPv6: `gateway.nginx.config.enableIPv6`.

## Bug fixes

### 5.3.1

- [PR 9215](https://github.com/grafana/mimir/pull/9215): Update GEM to v2.12.1
