---
title: "Grafana Mimir Helm chart version 5.1 release notes"
menuTitle: "V5.1 release notes"
description: "Release notes for Grafana Mimir Helm chart version 5.1"
weight: 300
---

# Grafana Mimir Helm chart version 5.1 release notes

Grafana Labs is excited to announce version 5.1 of the Grafana Mimir Helm chart, which is compatible with Grafana Mimir v2.10 or Grafana Enterprise Metrics (GEM) v2.10. The `mimir-distributed` Helm chart is the best way to install Mimir on Kubernetes.

The highlights that follow include the top features, enhancements, and bugfixes in this release. For a comprehensive list of changes, see the [Helm chart changelog](https://github.com/grafana/mimir/tree/main/operations/helm/charts/mimir-distributed/CHANGELOG.md).

## Important changes

- Deployments now set `maxUnavailable` to 0 and `maxSurge` to `15%` by default to avoid becoming unavailable during rollout. Please note that if you have
  set `maxSurge=0`, the upgrade will fail to execute with the following error

  ```
  Invalid value: intstr.IntOrString{Type:0, IntVal:0, StrVal:""}: may not be 0 when `maxSurge` is 0
  ```

  and you have to adjust your values of `maxSurge` and `maxUnavailable`.

## Features and enhancements

Notable enhancements are as follows:

- Pod management policy is now configurable for store-gateways and compactors.
- Nginx now listens on IPv6 pod interface as well if available.
- Distributor and querier CPU utilization better in line with CPU request by using `GOMAXPROCS`.

## 5.1.1

- [PR 6371](https://github.com/grafana/mimir/pull/6371): Updated the Mimir and GEM images to 2.10.2. These include some bugfixes and update grpc-go library to 1.57.1 and golang.org/x/net to 0.17, which include fix for CVE-2023-44487.

## 5.1.2

- [PR 6427](https://github.com/grafana/mimir/pull/6427): Updated the Mimir and GEM images to 2.10.3. These include a fix to the previous release. Update grpc-go library to 1.57.2-dev that includes a fix for a bug introduced in 1.57.1.

## 5.1.3

- [PR 6654](https://github.com/grafana/mimir/pull/6654): Updated the Mimir and GEM images to 2.10.4. This updates otelhttp library to v0.44.0 as a mitigation for CVE-2023-45142. For GEM it also fixes memory leak in Admin client.

## 5.1.4

- [PR 6863](https://github.com/grafana/mimir/pull/6863): Updated the memcached-exporter dependency to version 0.14.1 which includes a fix for CVE-2023-39325.
