---
title: "Grafana Mimir Helm chart version 4.1 release notes"
menuTitle: "V4.1 release notes"
description: "Release notes for Grafana Mimir Helm chart version 4.1"
weight: 300
---

# Grafana Mimir Helm chart version 4.1 release notes

Grafana Labs is excited to announce version 4.1 of the Grafana Mimir Helm chart, which is compatible with Grafana Mimir v2.6 and Grafana Enterprise Metrics v2.5. The `mimir-distributed` Helm chart is the best way to install Mimir on Kubernetes.

To learn about new features and enhancements in Grafana Mimir or GEM, see the release notes for [Grafana Mimir v2.6](/docs/mimir/v2.6.x/release-notes/v2.6/) or [Grafana Enterprise Metrics v2.5](/docs/enterprise-metrics/latest/release-notes/v2-5/).

The highlights that follow include the top features, enhancements, and bugfixes in this release. For a comprehensive list of changes, see the [Helm chart changelog](https://github.com/grafana/mimir/tree/main/operations/helm/charts/mimir-distributed/CHANGELOG.md).

> **Note:** If you are upgrading from a previous major version, review the changelog entry for all the major releases since then and perform the necessary migrations.

## Features and enhancements

Notable enhancements are as follows:

- **PrometheusRule objects**
  Add ability to manage PrometheusRule for metamonitoring with Prometheus operator from the Helm chart.
  This feature allows you to create arbitrary PrometheusRule objects that your Prometheus operator will
  detect and start evaluating the rules inside them.

  > **Note:** This does not configure the Mimir cluster to evaluate the rules.

  We have also bundled the recommended [recording rules](https://github.com/grafana/mimir/blob/main/operations/mimir-mixin-compiled/rules.yaml)
  and [alerts](https://github.com/grafana/mimir/blob/main/operations/mimir-mixin-compiled/alerts.yaml) for monitoring Mimir with the Helm chart.
  The recording rules are used in the mimir-mixin dashboards, and the alerts cover the health
  of the Mimir cluster. To enable the recommended rules, set `metaMonitoring.prometheusRule.mimirRules: true`.
  To enable the recommended alerts, set `metaMonitoring.prometheusRule.mimirAlerts: true`.

- **Deploying extra objects**
  The Helm chart now supports deploying arbitrary objects via the `extraObjects` section. For example:
  ```yaml
  extraObjects:
    - kind: ConfigMap
      apiVersion: v1
      metadata:
        name: extra-cm-{{ .Release.Name }}
      data: |
        extra.yml: "does-my-install-need-extra-info: true"
  ```

## Bug fixes

- [PR 3686](https://github.com/grafana/mimir/pull/3686): Change `rollout-operator` to use the same `PodSecurityPolicy` as the Mimir/GEM service account.
- [PR 3780](https://github.com/grafana/mimir/pull/3780): Gateway: Fixed checksum/config label when using NGINX.
- [PR 3781](https://github.com/grafana/mimir/pull/3781): Gateway: Disable `ServiceMonitor` when using NGINX.
- [PR 3851](https://github.com/grafana/mimir/pull/3851): Gateway: Expose OTLP ingestion path in the NGINX routing configuration.
- [PR 3851](https://github.com/grafana/mimir/pull/3851): Gateway: use alertmanager headless service in the NGINX routing configuration.
- [PR 3919](https://github.com/grafana/mimir/pull/3919): Ingester: Increase persistent volume in `capped-small.yaml` to `50Gi`.
- [PR 4124](https://github.com/grafana/mimir/pull/4124): NGINX: Set server variables in configuration so that IP addresses are re-resolved when TTLs expire.
- [PR 4164](https://github.com/grafana/mimir/pull/4164): PodSecurityPolicy: Do not include namespace for the definition as it is not needed and some tools reject it.
