package rootcerts

import (
	"testing"

	"gotest.tools/v3/assert"
	"gotest.tools/v3/assert/cmp"
)

func TestAddBase64PEM(t *testing.T) {
	//nolint:lll
	B64Data := []byte(
		`LS0tLS1CRUdJTiBDRVJUSUZJQ0FURS0tLS0tCk1JSURlRENDQW1BQ0NRQzJMOFNEdkF2NjNUQU5CZ2txaGtpRzl3MEJBUXNGQURCK01Rc3dDUVlEVlFRR0V3SkQKUVRFUU1BNEdBMVVFQ0F3SFQyNTBZWEpwYnpFT01Bd0dBMVVFQnd3RmJtOXZibVV4RGpBTUJnTlZCQW9NQlc1dgpiMjVsTVE0d0RBWURWUVFMREFWdWIyOXVaVEVhTUJnR0ExVUVBd3dSYm05dmJtVXVaWGhoYlhCc1pTNWpiMjB4CkVUQVBCZ2txaGtpRzl3MEJDUUVXQW01aE1CNFhEVEl6TURreU9ERTJNVEkwTlZvWERUSTBNRGt5TnpFMk1USTAKTlZvd2ZqRUxNQWtHQTFVRUJoTUNRMEV4RURBT0JnTlZCQWdNQjA5dWRHRnlhVzh4RGpBTUJnTlZCQWNNQlc1dgpiMjVsTVE0d0RBWURWUVFLREFWdWIyOXVaVEVPTUF3R0ExVUVDd3dGYm05dmJtVXhHakFZQmdOVkJBTU1FVzV2CmIyNWxMbVY0WVcxd2JHVXVZMjl0TVJFd0R3WUpLb1pJaHZjTkFRa0JGZ0p1WVRDQ0FTSXdEUVlKS29aSWh2Y04KQVFFQkJRQURnZ0VQQURDQ0FRb0NnZ0VCQU52OUFVZzlJb3JmVU8xeDZhUWZGR3F0d0hlaC9odXMrbzBibjRJTwpOUlFkVjJSanRGMW5wRTlCYzlMLzBmNFlhN282cDk1K0FTR01ETXdVcEVhYVVPUVIvelMzM24ycE9nTHEvUjFHCmRSQ3ZiZWtCK3ZmRFFkTFZvWHQ3N0JuUTNwSDA5RWNwekI0TXVQeGVtMWxMeGRQbzcrSXVaRHR0RDhTM3lobngKT1BGTUEza1JYd1MvMndQaDJYZHY5WnU2a0lPVERyc29jUHlqRERETlN3NnhqN2NrU2hKN3cvUC9TWkFoMGc4cQpRTjZrNnVxN2RjZUgxM0lMOWFLUkI4MW1OZUlEVitZcEVEamQvK29TaUZrRVdzMXFXeDZTSTJmK2t2TDcvYzlBCkVHdXY4SFJzMUc2dmQwem52cmN1OFEwQnEwOG8rT0tHUXVvTXdnTXJJZ2FYOHlNQ0F3RUFBVEFOQmdrcWhraUcKOXcwQkFRc0ZBQU9DQVFFQXNWOWpBTnVTVnhXSjZpMWt3R0JjeGk1ZWErV2NmeUNmL0JOekZjVGdyanl6N2VjYgpRd2VGU2lhV0xQdkU1cjlJa0s2K3F2b0IwcVZIVUJIeVpGbWJGRzZqR3RhTWJwU0c2emcxSW1ZbnhxYWJsOFdwCnQzQU9McVF1cCtqUFRNNmlIYXNUY2NXSy9FUC9pRi9hRU1yd1VUVW9YNGo2bURkN043UnZ0YWg0Y2czYXJDUWIKZkNkQXFzWDNJU2RsYWR1K0M0MFg1dVpuY2cvYTR1UUE1OU5PbnpSdFZzV1dpSlFydVVPYWEvNkdEM0pxMmhZTgpXeFpEYUowT2V2YzdjMGxML0tjYWxITGtHU1pmU3kzS25qZDZSMzRTaDY1NnRkUExaUXFYUkNZcm1HUnVZZm5yClNOa1RuazlwdWwzb211ZkNqZ21QZ0t2Yk45bjQrRlhwcktRc2lBPT0KLS0tLS1FTkQgQ0VSVElGSUNBVEUtLS0tLQ==
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`)

	err := AddBase64PEM(B64Data)
	assert.NilError(t, err)

	exCertFound := false
	bananaCertFound := false
	nooneCertFound := false
	for _, v := range certs {
		if v.Label == "ex.example.com" {
			assert.Check(t, cmp.Equal(v.Serial, "13666238143011240803"))
			exCertFound = true
		}
		if v.Label == "banana.example.com" {
			assert.Check(t, cmp.Equal(v.Serial, "18321620170315569208"))
			bananaCertFound = true
		}
		if v.Label == "noone.example.com" {
			assert.Check(t, cmp.Equal(v.Serial, "13127927508882946781"))
			nooneCertFound = true
		}
	}
	assert.Check(t, exCertFound, "ex.example.com cert not found")
	assert.Check(t, bananaCertFound, "banana.example.com cert not found")
	assert.Check(t, nooneCertFound, "noone.example.com cert not found")
}

func TestAddPEM(t *testing.T) {
	PEMData := []byte(`
-----BEGIN CERTIFICATE-----
MIIDcjCCAloCCQC9qDsvKhQ7YzANBgkqhkiG9w0BAQsFADB7MQswCQYDVQQGEwJD
QTEQMA4GA1UECAwHVW5rbm93bjEQMA4GA1UEBwwHVGVzdGluZzELMAkGA1UECgwC
ZXgxDzANBgNVBAsMBmJhbmFuYTEXMBUGA1UEAwwOZXguZXhhbXBsZS5jb20xETAP
BgkqhkiG9w0BCQEWAk5BMB4XDTIzMDgyMzEzMTUwMFoXDTI0MDgyMjEzMTUwMFow
ezELMAkGA1UEBhMCQ0ExEDAOBgNVBAgMB1Vua25vd24xEDAOBgNVBAcMB1Rlc3Rp
bmcxCzAJBgNVBAoMAmV4MQ8wDQYDVQQLDAZiYW5hbmExFzAVBgNVBAMMDmV4LmV4
YW1wbGUuY29tMREwDwYJKoZIhvcNAQkBFgJOQTCCASIwDQYJKoZIhvcNAQEBBQAD
ggEPADCCAQoCggEBAK+D+j80/+12p4uc8K3Wtmmh1fUw+3M0Z734kRThZyGVu/u8
S+e/vCEr2oNRqen1POt6em0bbmeiqnZSBm6fTqE1rieP2j0bjxqjBw36jM2PMyzd
OjjQmjIcDe3Rw4BQK8RYVz/Z3ygb+tooys1eIr6ITJG9eIUT2v2bZASDZ8QpicqY
tnW6k/4DHSIaTVn6O6wYBT42MRyuhjRJlC2jVB7UhT+kTUeYCXkwqCiVU9pL0cts
/2oU4j42v1vaxW7+Okg+y3F/VxGLB2cqFmNjzhbYi9YL/ycpshWn9LZCIoHntKjm
jYpv8FRHi25Pfnpt2l6ndsxybYJFAHhYOVKPqqUCAwEAATANBgkqhkiG9w0BAQsF
AAOCAQEAYy8eupX0AeyIyl2PPdrRhT3BHqH4ZtK4f4UsOcrpR9Yj45cM4AsRn0ro
bPpTKSqCZZ8fjxNUAwtgY4UUSLT86Q3ZLEBmh7PGFh4yn/pcwJek2N1hEFE5m+PT
BjrxDKsYaaNmFSQkcaxeNNd/FCW6ALpiC3Z4tFPqRz1o8jSLFWtbkAA/jbod6Ods
tVbuDbuEFGhx4MZWc9xBoehLRO/qNHg6rc578C4ZTf5i1oP0fJeA//ztrQqKoPuE
oD/sBVVDvN3IaW6QJFGX+2Ww+vrtfUUV2NNEXBWt5zpnZBw4TviUmKr4kANHvkYb
CRlaLP/fPOT/Lugwuhp8gor70N+v2Q==
-----END CERTIFICATE-----

-----BEGIN CERTIFICATE-----
MIIDejCCAmICCQD+Q3h5CUqYODANBgkqhkiG9w0BAQsFADB/MQswCQYDVQQGEwJD
QTEQMA4GA1UECAwHVW5rbm93bjEQMA4GA1UEBwwHVGVzdGluZzELMAkGA1UECgwC
ZXgxDzANBgNVBAsMBmJhbmFuYTEbMBkGA1UEAwwSYmFuYW5hLmV4YW1wbGUuY29t
MREwDwYJKoZIhvcNAQkBFgJOQTAeFw0yMzA4MjMxMzE4MDNaFw0yNDA4MjIxMzE4
MDNaMH8xCzAJBgNVBAYTAkNBMRAwDgYDVQQIDAdVbmtub3duMRAwDgYDVQQHDAdU
ZXN0aW5nMQswCQYDVQQKDAJleDEPMA0GA1UECwwGYmFuYW5hMRswGQYDVQQDDBJi
YW5hbmEuZXhhbXBsZS5jb20xETAPBgkqhkiG9w0BCQEWAk5BMIIBIjANBgkqhkiG
9w0BAQEFAAOCAQ8AMIIBCgKCAQEA00KnZZbdkkTTLOxG5LwAZacksXyuTesJpkJK
IPJzpEWB4l+yrBdUXSa9sVVDuTX4qTpm+9YGL2c4ELBXHpC2p4I9RzlJF9/zbLx/
SZB+NRHoEIMUeuG5praxr6Rb7qyO9JXxzOxQ9KamzlpyI2sbxqH1Hu5TPZd+DHbl
izLxrT9pV/1PYoaBZXDFkd8EYXtdquqdZEnNh0eGD4oc+/vmp2YMcvEEc7RiGo62
Mxn9ECLUSkvWtUvcL3I3xYgEq9psz+9n6TCO3mKTtBl1EVX1j1G9J2WY1jjVzftq
UUjDyxk85ETcdRh9oiXiJxPtjNhwVBq5y0klHo93du+bMfRrDQIDAQABMA0GCSqG
SIb3DQEBCwUAA4IBAQCelvKPcEFMse3UIFdYReKOE9NR4UIuVbJiE4wXWUk6aSQG
2yZJK5j932P5IqgLZsv2dRvwC5Ax0GU1DmXWsaIjFMBqQV32LuBZa8k2M6YzSg/h
hhpp1SsROPQ6Ve4/VIhleKrhjzf2B5rkt3QAZNEElC1w1ppeFR1c376t3ANLvpT0
WIv7CLKksCHPUT836XRly7yRBingj/LVpP9f8jIw9uCq7l1gS0/6HeoL8YAl5tPy
KAEEsHBJeCr0GmUy5Tx2w15mIJdpPP+qfMmtNf7jAtHwpT4Pe3bJWVQYGCg326r2
ErRnwE7tyZc8ghIsq0JVDlnJPyZFAFtF9k84naQE
-----END CERTIFICATE-----
		`)

	err := AddPEM(PEMData)
	assert.NilError(t, err)

	exCertFound := false
	bananaCertFound := false
	for _, v := range certs {
		if v.Label == "ex.example.com" {
			assert.Check(t, cmp.Equal(v.Serial, "13666238143011240803"))
			exCertFound = true
		}
		if v.Label == "banana.example.com" {
			assert.Check(t, cmp.Equal(v.Serial, "18321620170315569208"))
			bananaCertFound = true
		}
	}
	assert.Check(t, exCertFound, "ex.example.com cert not found")
	assert.Check(t, bananaCertFound, "banana.example.com cert not found")
}
