package org.jruby.parser;

public class YyTables {
   private static short[] combine(short[] t1, short[] t2, 
                                  short[] t3, short[] t4) {
      short[] t = new short[t1.length + t2.length + t3.length + t4.length];
      int index = 0;
      System.arraycopy(t1, 0, t, index, t1.length);
      index += t1.length;
      System.arraycopy(t2, 0, t, index, t2.length);
      index += t2.length;
      System.arraycopy(t3, 0, t, index, t3.length);
      index += t3.length;
      System.arraycopy(t4, 0, t, index, t4.length);
      return t;
   }

   public static final short[] yyTable() {
      return combine(yyTable1(), yyTable2(), yyTable3(), yyTable4());
   }

   public static final short[] yyCheck() {
      return combine(yyCheck1(), yyCheck2(), yyCheck3(), yyCheck4());
   }
   private static final short[] yyTable1() {
      return new short[] {

          305,   96,  308,  288,  288,  378,  638,  288,  354,  425, 
           88,   88,  134,  134,   83,   83,  214,  250,  250,  250, 
          228,  352,  276,  250,  250,  302,  301,  250,  230,  675, 
          694,  215,  215,  463,  307,  674,  712,  485,  766,  712, 
          228,  645,  107,  713,  804,  639,  329,  333,  230,  691, 
          597,  640,  215,   88,  759,  761,    8,  350,  700,  250, 
          524,  826,  360,  705,  526,  626,    8,  324,  639,  570, 
           83,  133,  133,  628,  627,  833,  256,  215,  304,  438, 
          722,  133,  713,  628,  597,  658,  639,  292,  292,  869, 
          260,  292,  433,  304,  639,  274,  256,  737,  256,  597, 
          628,  634,  389,  570,  602,  641,  845,  350,  254,  257, 
          431,  430,  579,  256,  639,    8,  133,  301,  570,  331, 
          335,   83,  736,  376,  775,  255,  883,  291,  291,  669, 
          429,  291,  829, 1015,   75,  639,  250,  578,   88,  938, 
          589,  430,  395,  628,  634,  255,  579,  255,  116,  512, 
          639,  389,  755,  602,  256,  297,  941,  669,  777,  330, 
          314,  579,  255,  639,  639,  304,  133,  521,  300,  634, 
          895,  578,  376,  276,  589,  571,  900,  749,  564, 1030, 
          310,  345,  770,  260,  564,   75,  578,  634,   81,  589, 
           86,  395,  669,  275,   74,  549,  639,  116,  740,  639, 
          550,  520,  817,  255,  377,  410,  639,   72,  816,  571, 
          465,  442,  827,  639,  587,  771,  669,  797,  577,  564, 
          639,  756,  410,  428,  571, 1009,  549,   73,   86,  517, 
          345,  959,  300,  564,  248,  248,  248, 1015,  485,   81, 
          312,   53,   88,  521,  434,   72,  768,  564,  587,  602, 
          564,  803,  577,  377,  652,  639,  382,  304,  386,  528, 
          365,  808,  375,  587,   79,  380,  383,  577,  564,  250, 
          250,  712,  712, 1030,  315,  549,  713,  523,   71,  869, 
          378,  319,  367,  381,  376,  288,  379,  288,  288,  401, 
          377, 1047,  371,  403,  404,  807, 1045,  809,  602,  491, 
           76,  587,  841,  628,  373,  250,  588,  250,  250,  941, 
          417,  250,  412,  250,  477,   79,  479,  418,   88,  477, 
          628,  479,  439,  436,   88,  421,   88,  437,  510,  103, 
          955,  420, 1077,  427,  910,  250,  260,  963,  422,   83, 
          324,  812,  967,  945,  426,  597,  515,  949,  951,  303, 
          953,   76,  954,  435,  450,  454,  453,  350,  461,  468, 
          469,  465,  908,  103,  460,  628,  319,  697,  639,  292, 
          454,  292,  628,  384,  385,  462,  464,  642,  474,  646, 
          103,  597,  640,  656,  660,  640,  565,  250,  250,  250, 
          250,   88,  250,  250,  673,  595,  654,   17,  597,  260, 
           84,   83,  639,   75,  288,  116,  467,  639,  303,  291, 
          436,  291,  481,  645,  597,  491,  133,  570,    8,  630, 
          470,  639,  440,  933,  250,   72,  274,  626,  250,  274, 
          250,   88,  350,  288,  250,  250,  627,   88,  639,  514, 
          636,   83, 1084,  528,  491,  324,   17,  288,  630, 1001, 
          389,   84,  602,  250,   88,  250,  837,   81,  491,  843, 
          579,  288,  630,   88,   77,   75,  517,  250,  662,  636, 
          571,   88,  491,  517,  830,  480,  630,  591,  592,  593, 
          594,  250,  484,  636, 1060,  578,  248,  248,  589,  712, 
          395,  133,  504,  713,  980,  639, 1003,  636, 1049, 1051, 
         1052, 1053,  386,   96,  276,  508,  571,  276,  720,  587, 
          250,  630,   88,  577,  228,   77,   83,  416,  666,   81, 
          288,  549,  230,   88,  275,   74,  215,  275,  495,  509, 
          497,  491,  636,   79,  651,  630,  534,  535,  651,  571, 
          250,  350,  513,  537,  602,  587,  505,  699,  699,  577, 
          564,  639,  518,  711,  319,  519,  636,  549,   73,  106, 
          106, 1085,  587,  528, 1036,   82,  106,  106,  106,   76, 
          533,  312,  106,  106,  745,  565,  106,  695,  587,  527, 
          602,  564,  577,  837,  534,  535,  315,  382,  774,  774, 
          549,  537,  730,  375,  446,   79,  380,  383,  103,  436, 
          133,   80,  106,  525,  248,  248,  248,  248,  106,  596, 
          597,  378,  789,  602,  381,  376,   82,  379,  384,  385, 
          315,  377,  639,  774,  639,  819,  816,  783,  287,  498, 
         1072,   76,  781,  780,  544,  315,  574,  548,  787,  786, 
          783,  844,  655,  446,  663,  790,  780,  436,  789,   17, 
           17,   17,   80,  445,  436,   17,   17,  583,   17,  319, 
          103,  350,  459,  473,   78,  789,  867,  315,  783,   84, 
          639,  639,  676,  639,  780,  250,   88,  786,  586,  789, 
          436,  815,  818,  459,  818,  106,   88,  106,  811,  502, 
          810,  685,  818,  565,  228,  565,  499,  500,  998,  693, 
          562,  563,  230,  853, 1000,  215,  215,  677,  528,  682, 
          789,  686,  289,  295,  250,   78,  296,  684,  715,  639, 
          133,  696,  904,  858,  669,   96,  716,  721,   17,  847, 
          848,   84,  849,   77,   88,  891,  893,  532,   83,  350, 
          110,  896,  898,  717,  801,  858,  534,  535,  723,   17, 
          889,  646,  726,  537,  414,  534,  535,  539,  542,  745, 
          854,  415,  537,   88,   88,  802,  639,  639,  639,  865, 
          731,  868,  707,   17,  565,  742,  565,  750,  751,   16, 
          752,   88,  875,   88,  753,   88,  250,  250,  838,  110, 
          758,  106,  250,  250,  651,   77,   59,   60,  133,  774, 
          760,  762,  250,  764,  834,  445,  350,  765,  769,  794, 
          287,  287,  778,  920,  287,  779,  924,  639,  106,  106, 
          784,  511,  785,  795,   88,  574,  798,  250,   16,  379, 
          380,  381,  382,  383,   82, 1010,  311,  313,   88,   88, 
           88,  822,  287,  287,  805,  353,  355,  816,  823,  824, 
          858,  446,  867,  639,  106,  825,  106,  106,  976,  639, 
          106,  828,  106,  840,  496,  133,  287,  106,  867,  745, 
           80,  745,  855,  106,  901,  106,  287, 1040,  639,  639, 
          913,  912,  902,  639,  106,  639,  516,  517,  916,  915, 
          443,  918,  248,  922,  971,  926,   82,  444,  928,  457, 
          471,  927,  639,  934,  315,  935,  458,  472,  639,  250, 
          287,  315,  939,  699,  942,  943,  618,  925,   88,   88, 
          506,  944,  446,  639,  639,  287,  995,  507,  946,  818, 
           88,  248,   80,   78,  315,  948,  106,  106,  106,  106, 
          106,  106,  106,  574,  511,  574,  950,  534,  535,  536, 
          639,  445,  445,  133,  537,  745, 1011,  445,  947,  956, 
          952, 1017,  867,  957, 1020,  551,  565,  552,  553,  554, 
          555, 1024,  960,  106,  530, 1028,  962,  106,  511,  106, 
          106,  531,  964,  106,  106,  133,  106, 1048,  972,   88, 
          966,  863,  864,  511,  486,   78,  489,  110,  534,  535, 
          539,  514,  106,  106,  106,  537,   88,  973,   88,  887, 
          614,  888,  106,  890,   88,   88,  106,  974,  975, 1004, 
          106, 1008,  639,  133,  745,  511,  745,  639,  288, 1005, 
          106,   16,   16,   16, 1023,  514, 1034,   16,   16,  491, 
           16,  818,  443,  630,  248, 1031,  789,  714,  250, 1032, 
          514, 1035,  921, 1067, 1037,  718,  719,  636,  511,  106, 
          126,  106,  745, 1046,  636,  511,  930,  931,  932, 1081, 
          614, 1050,  106,  727, 1054,  107,  287,  287,  287,  355, 
         1056,  287,  514,   61,   62,   63,   64,  115, 1058,  106, 
          621,  614,  287, 1061,  287,  287,  206,  551,  107,  552, 
          553,  554,  555,  503, 1075,  639,  639,  639, 1076,  126, 
           16, 1087,  639,  639, 1038,  626,  639,  639,  639,  627, 
          332, 1039,  315,  639,  621,  628,   97,  632,  287,  287, 
          287,   16,  107,  287,  287,  287,  115,  287,  628,  621, 
          632,  315,  634,  628,  304,  206,  979,  287,  287,  107, 
          639,  628,  449,  375,  478,   16,  287,  287,  999,  287, 
          287,  287,  287,  287,  363,  585,  137,  728,  516,   96, 
         1074,  621,  217,  517,  791,  981,  866,  878,  871,  315, 
         1026,  598,  599,  600,  601,  602,  603,  604,  605,  606, 
          607,  608,  609,  610,  611,  612,  613,  614,  615,  616, 
          617,  618,  619,  620,  621,  622,  279,  287, 1025,  903, 
          287,  287,  287,  796,  614,  643,  516,  647,   95,   95, 
         1073,  287,  661,  852,  106,  106,    0,  556,  287, 1078, 
          278,    0,  557,    0, 1041,  106, 1042,  806,    0,   98, 
          287,    0, 1043, 1044,    0,    0,   92,   92,  135,  135, 
            0,    0,  287,    0,  287,  643,  692,  661,  277,    0, 
          287,   95,  511,  106,  562,  563,    0,    0,  287,  511, 
            0,  615,    0,    0,  614,  287,  287,    0,    0,  287, 
            0,   99,  839,  106,    0,  386,  518,    0,    0,   92, 
          842,    0,  511,  351, 1012,  614,  552,  553,  554,  555, 
          564,  399,  400,  724,  725,    0,    0,    0,    0,  856, 
          126,    0,  106,  106,    0,  287,  401,  126,  287,  514, 
          403,  404,  405,  406,    0,    0,  514,  287,  519,    0, 
          106,  615,  106,    0,  106,  106,  106,    0,    0,    0, 
          289,  106,  106,  351,  115,    0,   95,    0,    0,  514, 
          289,  106,  615,  475,  476,  477,    0,    0,  479,  315, 
          621,  116,    0,    0,  102,  102,  315,  107,  914,    0, 
            0,  618,    0,  106,   92,  117,  106,  287,  315,  534, 
          535,  541,    0,    0,  289,  315,  537,  106,  106,  106, 
          618,    0,  206,    0,  206,  206,  206,  206,  206,  289, 
            0,    0,    0,  206,  115,  516,    0,  102,  621,    0, 
          517,    0,  516,  937,  517,  621,  315,  517,  776,    0, 
          617,  517,    0,  315,  117,  206,  206,    0,  618,  107, 
            0,    0,    0,  206,  206,  206,  206,  118,  621,  287, 
          874,  621,  552,  553,  554,  555,  556,    0,    0,    0, 
           95,  557,  101,  516,    0,   97,  518,    0,  106,    0, 
          516,    0,  534,  535,  545,    0,    0,  106,  106,  537, 
          640,  206,    0,  558,  117,    0,    0,  287,   92,  106, 
          640,  560,  561,  562,  563,    0,  118,    0,   91,   97, 
            0,    0,  102,    0,  649,    0,    0,    0,  659,  521, 
            0,    0,  287,    0,  287,    0,   97,  292,  534,  535, 
          584,  287,  287,    0,    0,  537,  118,  292,  519,  564, 
            0,    0,   91,  518,    0,    0,   95,    0,    0,  640, 
          518,    0,   95,    0,   95,  113,  517,  649,  106,   91, 
            0,    0,  542,    0,  551,  287,  552,  553,  554,  555, 
            0,  287,  708,  710,   92,  106,  332,  106,    0,    0, 
           92,    0,   92,  106,  106,  519,  292,    0,    0,  511, 
            0,    0,  519,  892,  894,    0,    0,  743,   96,  897, 
          899,    0,    0,    0,  113,  744,    0,    0,  905,  692, 
          287,  542,  710,  351,  909,  332,  102,  106,    0,   95, 
            0,  120,  289,  289,  289,    0,    0,  289,  289,  289, 
            0,  289,   96,    0,   98,    0,  514,  892,  894,  897, 
          899,  289,  289,   99,  287,    0,    0,   92,    0,   96, 
          289,  289,  117,  289,  289,  289,  289,  289,  650,   95, 
          483,  483,  483,    0,    0,   95,    0,  483,   98,    0, 
          120,  465,  465,  465,  767,    0,    0,   99,  465,  516, 
            0,  122,   95,  119,    0,   98,  425,   92,  351,    0, 
            0,   95,  102,   92,   99,    0,  425,    0,  102,   95, 
          102,  289,  521,    0,  289,    0,  289,  120,    0,    0, 
           92,    0,    0,  518,  118,  518,  977,    0,    0,   92, 
          518,  287,  289,    0,  519,    0,    0,   92,    0,    0, 
          122,    0,  119,  540,    0,  543,  792,  546,    0,    0, 
           95,    0,  977,  546,   97,  425,  289,    0,    0,  287, 
            0,   95,  640,  640,  640,    0,  521,  640,  640,  640, 
            0,  640,  436,  521,  520,  102,  121,    0,   92,    0, 
            0,  640,  640,    0,  813,  519,    0,   91,  614,   92, 
          640,  640,  519,  640,  640,  640,  640,  640,    0,  292, 
          292,  292,    0,  517,    0,  292,  292,  351,  292,  835, 
          517,  836,    0,    0,    0,  102,   97,  229,  710,  332, 
            0,  102,  113,    0,    0,  121,    0,  229,    0,    0, 
          292,  292,  292,  292,  292,  615,  511,    0,  102,    0, 
          100,  640,    0,  511,  640,    0,  640,  102,  614,   91, 
            0,    0,  859,    0,    0,  102,    0,  522, 1066,  540, 
            0,  229,  640,    0,   94,  287,    0,    0,  542,  614, 
          542,  542,  542,  542,  542,  229,  229,   96,  292,  542, 
          229,    0,  102,  514,    0,    0,  640,  520,  120,  123, 
          514,    0,  112,    0,    0,  615,  102,  907,   94,  292, 
            0,  542,    0,    0,    0,    0,   93,  102,    0,  542, 
          542,  542,  542,   98,   95,   94,  615,  101,  471,  471, 
          471,    0,   99,  292,   95,  471,  516,  351,  741,  522, 
            0,  929,    0,  516,    0,    0,    0,    0,  123,   96, 
            0,  112,   92,    0,    0,  514,    0,  542,  122,  521, 
          119,  101,   92,  513,    0,    0,  521,    0,  425,  425, 
          425,  436,  518,  425,  425,  425,  741,  425,  101,  518, 
          617,  519,   95,  513,    0,   98,  100,  425,  519,    0, 
            0,    0,    0,    0,   99,    0,  425,  425,    0,  425, 
          425,  425,  425,  425,   60,    0,    0,    0,  521,    0, 
           92,   95,   95,    0,   60,  351,    0,    0,  978,  436, 
          100,  520,  125,  851,    0,    0,  436,    0,  520,   95, 
            0,   95,  199,   95,  425,    0,    0,  100,  386,   92, 
           92,  425,    0,  121,    0,    0,  332,  425,    0,    0, 
          650,    0,  436,    0,    0,    0,    0,   92,    0,   92, 
            0,   92,    0,   60,  111,    0,    0,  520,  425,  401, 
          102,  125,   95,  403,  404,  405,  406,    0,    0,    0, 
          102,  199,  351,    0,   91,  119,   95,   95,   95,  229, 
          229,  229,  425,    0,  229,  229,  229,    0,  229,    0, 
           92,   92,   95,  618,  522,    0,    0,    0,  229,  229, 
            0,  522,    0,  111,   92,   92,   92,  229,  229,    0, 
          229,  229,  229,  229,  229,    0,    0,  121,  102,    0, 
            0,  511,  229,    0,  520,    0,    0,    0,    0,    0, 
            0,  520,    0,   94,  615,  512,    0,    0,  512,  515, 
            0,  112,    0,  511,    0,    0,  123,  102,  102,  112, 
            0,    0,    0,  511,    0,  229,   95,   95,  229,  617, 
          135,  229,    0,  229,  997,  102,  522,  102,   95,  102, 
            0,    0,  551,  522,  552,  553,  554,  555,    0,  229, 
            0,    0,  514,    0,   92,   92,  101,  511,    0,  514, 
          513,  229,  996,    0,  615,   94,   92,  513,    0,    0, 
            0,  511,  511,  229,  110,  743,  511,  617,  102,    0, 
          513,    0,    0,  940,  617,  615,    0,  513,    0,  617, 
            0,    0,  102,  102,  102,    0,    0,   95,    0,    0, 
          135,    0,    0,    0,  511,  521,    0,    0,    0,    0, 
          617,    0,  521,    0,   95,  100,   95,    0,  101,    0, 
            0,    0,   95,   95,    0,   92,   60,   60,   60,    0, 
            0,   60,   60,   60,    0,   60,    0,    0,    0,  125, 
            0,    0,   92,  514,   92,   60,   60,    0,    0,    0, 
           92,   92,  618,  514,   60,   60,    0,   60,   60,   60, 
           60,   60,    0,    0,  520,  551,    0,  552,  553,  554, 
          555,  520,  102,  102,    0,    0,    0,  100,    0,  110, 
          614,  111,    0,    0,  102,    0,    0,  514,  199,    0, 
          199,  199,  199,  199,  199,    0,  111,  114,  743,  199, 
          618,  514,  514,    0,  113,   60,  514,  618,   60,    0, 
          516,    0,  618,    0,    0,    0,    0,  516,    0,    0, 
            0,  199,  199,    0,    0,    0,   60,    0,  511,  199, 
          199,  199,  199,  618,  514,  511,    0,    0,    0,    0, 
          614,    0,  512,  102,    0,  512,  515,    0,    0,  512, 
           60,    0,  512,  515,    0,    0,    0,    0,    0,    0, 
          102,  614,  102,    0,  209,    0,    0,  199,  102,  102, 
          614,  614,  614,    0,  614,  511,  511,  511,  614,  614, 
          511,  511,  511,  614,  511,  614,  614,  614,  614,  614, 
          614,  614,    0,  614,  511,  511,  614,  614,  614,  614, 
          614,  614,  614,  511,  511,  614,  511,  511,  511,  511, 
          511,    0,  614,  209,    0,  614,  614,  614,  511,  614, 
          614,  614,  614,  614,  614,  614,  614,  614,  614,  614, 
          511,  511,  511,  511,  511,  511,  511,  511,  511,  511, 
          511,  511,  511,  511,  886,    0,  511,  511,  511,  614, 
          523,  511,  614,  614,  511,  614,  614,  511,  614,  511, 
          614,  511,  614,  511,  614,  511,  511,  511,  511,  511, 
          511,  511,  614,  511,  614,  511,    0,  614,  614,  614, 
          614,  614,  614,    0,    0,   62,  614,  511,  614,  614, 
            0,  614,  614,  614,  614,   62,  614,  614,  614,  511, 
          615,  615,  615,    0,  615,  514,  514,  514,  615,  615, 
          514,  514,  514,  615,  514,  615,  615,  615,  615,  615, 
          615,  615,    0,  615,  514,  514,  615,  615,  615,  615, 
          615,  615,  615,  514,  514,  615,  514,  514,  514,  514, 
          514,    0,  615,    0,   62,  615,  615,  615,  514,  615, 
          615,  615,  615,  615,  615,  615,  615,  615,  615,  615, 
          514,  514,  514,  514,  514,  514,  514,  514,  514,  514, 
          514,  514,  514,  514,    0,    0,  514,  514,  514,  615, 
          526,  514,  615,  615,  514,  615,  615,  514,  615,  514, 
          615,  514,  615,  514,  615,  514,  514,  514,  514,  514, 
          514,  514,  615,  514,  615,  514,    0,  615,  615,  615, 
          615,  615,  615,    0,    0,  617,  615,  514,  615,  615, 
            0,  615,  615,  615,  615,  617,  615,  615,  615,  514, 
          886,    0,    0,  886,    0,  886,    0,  886,    0,  961, 
          626,  626,  626,  965,    0,    0,  626,  626,    0,  626, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  617, 
          209,    0,  209,  209,  209,  209,  209,    0,    0,    0, 
            0,  209,    0,  617,  617,    0,  123,    0,  617,    0, 
            0,    0,  518,    0,    0,    0,    0,    0,    0,  518, 
            0,    0,    0,  209,  209,    0,    0,    0,    0,    0, 
            0,  209,  209,  209,  209,    0,  617,    0,    0,  627, 
          627,  627,    0,    0,    0,  627,  627,    0,  627,  626, 
            0,    0,    0,    0,    0,    0,    0,  886,    0,  886, 
            0,  886,    0,    0,  886,    0,    0,    0,    0,  209, 
          626,    0,    0,    0,    0,  618,    0,   62,   62,   62, 
            0,    0,   62,   62,   62,  618,   62,    0,    0,    0, 
          886,    0,    0,    0,  626,    0,   62,   62,    0,    0, 
            0,    0,    0,    0,    0,   62,   62,    0,   62,   62, 
           62,   62,   62, 1055,  386,    0, 1057, 1059,  627,  618, 
         1062, 1063,    0,    0,    0,    0,    0,    0,    0,    0, 
          399,  400,    0,  618,  618,    0,  125,    0,  618,  627, 
            0,    0,    0,    0,    0,  401,    0,  402,    0,  403, 
          404,  405,  406,  386,    0,  409,   62,  410,    0,   62, 
            0,    0,    0,  627,    0,    0,  618,    0,    0,  399, 
          400,    0, 1086, 1088, 1089, 1090,    0,   62,    0,    0, 
            0,    0,    0, 1092,  401,    0,  402,    0,  403,  404, 
          405,  406,    0,    0,  194,    0,    0,    0,    0,    0, 
            0,   62,  617,  617,  617,    0,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,    0,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  194,  617,    0,    0,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,    0,    0,  617,  617, 
          617,  617,    0,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,    0,  617, 
          617,  617,  617,  617,  617,    0,    0,   64,  617,  617, 
          617,  617,    0,  617,  617,  617,  617,   64,  617,  617, 
          617,  617,  618,  618,  618,    0,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,    0,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,    0,  618,    0,   64,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,    0,    0,  618,  618, 
          618,  618,    0,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,    0,  618, 
          618,  618,  618,  618,  618,    0,    0,  621,  618,  618, 
          618,  618,    0,  618,  618,  618,  618,  621,  618,  618, 
          618,  618,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          194,  621,  194,  194,  194,  194,  194,    0,    0,    0, 
            0,  194,    0,    0,    0,  621,  621,    0,  124,    0, 
          621,  551,  519,  552,  553,  554,  555,  556,    0,  519, 
            0,    0,  557,  194,  194,    0,    0,    0,    0,    0, 
            0,  194,  194,  194,  194,    0,    0,    0,  621,    0, 
            0,    0,    0,    0,  558,  559,    0,    0,    0,    0, 
            0,    0,  560,  561,  562,  563,    0,    0,    0,  551, 
            0,  552,  553,  554,  555,  556,    0,    0,    0,  194, 
          557,    0,    0,    0,    0,    0,    0,  306,    0,   64, 
           64,   64,    0,    0,   64,   64,   64,  306,   64,    0, 
          564,    0,  558,    0,    0,    0,    0,    0,   64,   64, 
          560,  561,  562,  563,    0,    0,    0,   64,   64,    0, 
           64,   64,   64,   64,   64,    0,    0,    0,    0,    0, 
            0,  306,  874,    0,  552,  553,  554,  555,  556,    0, 
            0,    0,    0,  557,    0,  306,  306,    0,  564,    0, 
          306,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  386,  558,    0,    0,   64,  391, 
          392,   64,    0,  560,  561,  562,  563,    0,  306,    0, 
          399,  400,    0,    0,    0,    0,    0,    0,    0,   64, 
            0,    0,    0,    0,    0,  401,    0,  402,    0,  403, 
          404,  405,  406,  407,  408,  409,  176,  410,    0,    0, 
            0,  564,    0,   64,  617,  617,  617,    0,  617,  621, 
          621,  621,  617,  617,  621,  621,  621,  617,  621,  617, 
          617,  617,  617,  617,  617,  617,    0,  621,  621,  621, 
          617,  617,  617,  617,  617,  617,  617,  621,  621,  617, 
          621,  621,  621,  621,  621,  176,  617,    0,    0,  617, 
          617,  617,  621,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  621,  621,  621,  621,  621,  621, 
          621,  621,  621,  621,  621,  621,  621,  621,    0,    0, 
          621,  621,  621,  617,    0,  621,  617,  617,  621,  617, 
          617,  621,  617,  621,  617,  621,  617,  621,  617,  621, 
          621,  621,  621,  621,  621,  621,  617,  621,  621,  621, 
            0,  617,  617,  617,  617,  617,  617,    0,    0,   51, 
          617,  621,  617,  617,    0,  617,  617,  617,  617,   51, 
          617,  617,  617,  621,  616,  616,  616,    0,  616,  306, 
          306,  306,  616,  616,  306,  306,  306,  616,  306,  616, 
          616,  616,  616,  616,  616,  616,    0,  616,  306,  306, 
          616,  616,  616,  616,  616,  616,  616,  306,  306,  616, 
          306,  306,  306,  306,  306,    0,  616,    0,   51,  616, 
          616,  616,  306,  616,  616,  616,  616,  616,  616,  616, 
          616,  616,  616,  616,  306,  306,  306,  306,  306,  306, 
          306,  306,  306,  306,  306,  306,  306,  306,    0,    0, 
          306,  306,  306,  616,    0,  306,  616,  616,  306,  616, 
          616,  306,  616,  306,  616,  306,  616,  306,  616,  306, 
          306,  306,  306,  306,  306,  306,  616,  306,  616,  306, 
            0,  616,  616,  616,  616,  616,  616,    0,    0,  622, 
          616,  306,  616,  616,    0,  616,  616,  616,  616,  622, 
          616,  616,  616,  306,    0,    0,  551,    0,  552,  553, 
          554,  555,  556,    0,    0,    0,    0,  557,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  176,  622,  176,  176,  176,  176,  176,  558, 
            0,    0,    0,  176,    0,    0,    0,  622,  622,  562, 
          563,    0,  622,    0,  521,    0,    0,    0,    0,    0, 
            0,  521,    0,    0,    0,  176,  176,    0,    0,    0, 
            0,    0,    0,  176,  176,  176,  176,    0,    0,    0, 
          622,    0,    0,    0,    0,  564,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  176,    0,    0,    0,    0,    0,    0,    0,  623, 
            0,   51,   51,   51,    0,    0,   51,   51,   51,  623, 
           51,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           51,    0,    0,    0,    0,    0,    0,    0,    0,   51, 
           51,    0,   51,   51,   51,   51,   51,    0,    0,    0, 
            0,    0,    0,  623,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  623,  623,    0, 
            0,    0,  623,    0,    0,    0,    0,  386,  387,  388, 
          389,  390,  391,  392,  393,  394,  395,  396,    0,    0, 
           51,    0,    0,  399,  400,    0,    0,    0,    0,    0, 
          623,    0,    0,    0,    0,    0,    0,    0,  401,    0, 
          402,   51,  403,  404,  405,  406,  407,  408,  409,    0, 
          410,    0,    0,    0,    0,    0,    0,    0,  177,    0, 
            0,    0,    0,    0,    0,   51,  619,  619,  619,    0, 
          619,  622,  622,  622,  619,  619,  622,  622,  622,  619, 
          622,  619,  619,  619,  619,  619,  619,  619,    0,  622, 
          622,  622,  619,  619,  619,  619,  619,  619,  619,  622, 
          622,  619,  622,  622,  622,  622,  622,  177,  619,    0, 
            0,  619,  619,  619,  622,  619,  619,  619,  619,  619, 
          619,  619,  619,  619,  619,  619,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
            0,    0,  622,  622,  622,  619,    0,  622,  619,  619, 
          622,  619,  619,  622,  619,  622,  619,  622,  619,  622, 
          619,  622,  622,  622,  622,  622,  622,  622,  619,  622, 
          622,  622,    0,  619,  619,  619,  619,  619,  619,    0, 
            0,   53,  619,  622,  619,  619,    0,  619,  619,  619, 
          619,   53,  619,  619,  619,  622,  620,  620,  620,    0, 
          620,  623,  623,  623,  620,  620,  623,  623,  623,  620, 
          623,  620,  620,  620,  620,  620,  620,  620,    0,  623, 
          623,  623,  620,  620,  620,  620,  620,  620,  620,  623, 
          623,  620,  623,  623,  623,  623,  623,    0,  620,    0, 
           53,  620,  620,  620,  623,  620,  620,  620,  620,  620, 
          620,  620,  620,  620,  620,  620,  623,  623,  623,  623, 
          623,  623,  623,  623,  623,  623,  623,  623,  623,  623, 
            0,    0,  623,  623,  623,  620,    0,  623,  620,  620, 
          623,  620,  620,  623,  620,  623,  620,  623,  620,  623, 
          620,  623,  623,  623,  623,  623,  623,  623,  620,  623, 
          623,  623,    0,  620,  620,  620,  620,  620,  620,    0, 
            0,  315,  620,  623,  620,  620,    0,  620,  620,  620, 
          620,  315,  620,  620,  620,  623,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  177,  315,  177,  177,  177,  177, 
          177,    0,    0,    0,    0,  177,    0,    0,    0,  315, 
          315,    0,  126,    0,  315,    0,  520,    0,    0,    0, 
            0,    0,    0,  520,    0,    0,    0,  177,  177,    0, 
            0,    0,    0,    0,    0,  177,  177,  177,  177,    0, 
            0,    0,  315,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  177,    0,    0,    0,    0,    0,    0, 
            0,  435,    0,   53,   53,   53,    0,    0,   53,   53, 
           53,  435,   53,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   53,    0,    0,    0,    0,    0,    0,    0, 
            0,   53,   53,    0,   53,   53,   53,   53,   53,    0, 
            0,    0,    0,    0,    0,  435,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          435,    0,    0,    0,  435,    0,    0,    0,    0,  386, 
          387,  388,  389,  390,  391,  392,  393,    0,  395,  396, 
            0,    0,   53,    0,    0,  399,  400,    0,    0,    0, 
            0,    0,  435,    0,    0,    0,    0,    0,    0,    0, 
          401,  178,  402,   53,  403,  404,  405,  406,  407,  408, 
          409,    0,  410,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   53,  618,  618, 
          618,    0,  618,  315,  315,  315,  618,  618,  315,  315, 
          315,  618,  315,  618,  618,  618,  618,  618,  618,  618, 
          178,    0,  315,  315,  618,  618,  618,  618,  618,  618, 
          618,  315,  315,  618,  315,  315,  315,  315,  315,    0, 
          618,    0,    0,  618,  618,  618,  315,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  315,  315, 
          315,  315,  315,  315,  315,  315,  315,  315,  315,  315, 
          315,  315,    0,    0,  315,  315,  315,  618,    0,  315, 
          618,  618,  315,  618,  618,  315,  618,  315,  618,  315, 
          618,  315,  618,  315,  315,  315,  315,  315,  315,  315, 
          618,  315,    0,  315,    0,  618,  618,  618,  618,  618, 
          618,    0,    0,   55,  618,  315,  618,  618,    0,  618, 
          618,  618,  618,   55,  618,  618,  618,  315,  282,  282, 
          282,    0,  282,  435,  435,  435,  282,  282,  435,  435, 
          435,  282,  435,  282,  282,  282,  282,  282,  282,  282, 
            0,  435,  435,  435,  282,  282,  282,  282,  282,  282, 
          282,  435,  435,  282,  435,  435,  435,  435,  435,    0, 
          282,    0,   55,  282,  282,  282,    0,  282,  282,  282, 
          282,  282,  282,  282,  282,  282,  282,  282,  435,  435, 
          435,  435,  435,  435,  435,  435,  435,  435,  435,  435, 
          435,  435,    0,    0,  435,  435,  435,  282,    0,  435, 
          282,    0,  435,  282,  282,  435,  282,  435,  282,  435, 
          282,  435,  282,  435,  435,  435,  435,  435,  435,  435, 
          282,  435,  435,  435,    0,  282,  282,  282,  282,  282, 
          282,    0,    0,  639,  282,    0,  282,  282,    0,  282, 
          282,  282,  282,  639,  282,  282,  282,  435,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  178,    0,  178, 
          178,  178,  178,  178,    0,    0,    0,    0,  178,    0, 
            0,    0,    0,    0,    0,    0,    0,  639,    0,  522, 
            0,    0,    0,    0,    0,    0,  522,    0,    0,    0, 
          178,  178,  639,    0,    0,    0,  639,    0,  178,  178, 
          178,  178,  639,  626,    0,    0,  640,    0,    0,    0, 
          183,  184,    0,  185,  186,  187,  188,  189,  190,  191, 
            0,    0,  192,  193,  639,    0,    0,  194,  195,  196, 
          197,    0,    0,    0,    0,    0,  178,    0,    0,    0, 
            0,    0,    0,  199,  200,    0,  201,  202,  203,  204, 
          205,  206,  207,  208,  209,  210,  211,    0,    0,  212, 
            0,    0,    0,  322,    0,   55,   55,   55,    0,    0, 
           55,   55,   55,  322,   55,    0,    0,    0,    0,    0, 
            0,  213,    0,    0,   55,    0,    0,    0,    0,    0, 
            0,    0,    0,   55,   55,    0,   55,   55,   55,   55, 
           55,    0,    0,    0,    0,    0,    0,  322,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  322,    0,    0,    0,  322,    0,    0,    0, 
            0,  386,  387,  388,  389,  390,  391,  392,    0,    0, 
          395,  396,    0,    0,   55,    0,    0,  399,  400,    0, 
            0,    0,    0,    0,  322,    0,    0,    0,    0,    0, 
            0,    0,  401,    0,  402,   55,  403,  404,  405,  406, 
          407,  408,  409,    0,  410,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   55, 
          282,  282,  282,    0,  282,  639,  639,  639,  282,  282, 
          639,  639,  639,  282,  639,  282,  282,  282,  282,  282, 
          282,  282,    0,  639,  639,  639,  282,  282,  282,  282, 
          282,  282,  282,  639,  639,  282,  639,  639,  639,  639, 
          639,    0,  282,    0,    0,  282,  282,  282,    0,  282, 
          282,  282,  282,  282,  282,  282,  282,  282,  282,  282, 
          639,  639,  639,  639,  639,  639,  639,  639,  639,  639, 
          639,  639,  639,  639,    0,    0,  639,  639,  639,  282, 
            0,  639,  282,  304,  639,  282,  282,  639,  282,  639, 
          282,  639,  282,  639,  282,  639,  639,  639,  639,  639, 
          639,  639,  282,  639,  639,  639,  873,  282,  282,  282, 
          282,  282,  282,    0,    0,  885,  282,    0,  282,  282, 
            0,  282,  282,  282,  282,    0,  282,  282,  282,  639, 
          282,  282,  282,    0,  282,  322,  322,  322,  282,  282, 
          322,  322,  322,  282,  322,  282,  282,  282,  282,  282, 
          282,  282,    0,    0,  322,  322,  282,  282,  282,  282, 
          282,  282,  282,  322,  322,  282,  322,  322,  322,  322, 
          322,    0,  282,    0,    0,  282,  282,  282,    0,  282, 
          282,  282,  282,  282,  282,  282,  282,  282,  282,  282, 
          322,  322,  322,  322,  322,  322,  322,  322,  322,  322, 
          322,  322,  322,  322,    0,    0,  322,  322,  322,  282, 
            0,  322,  282,    0,  322,  282,  282,  322,  282,  322, 
          282,  322,  282,  322,  282,  322,  322,  322,  322,  322, 
          322,  322,  282,  322,  511,  322,    0,  282,  282,  282, 
          282,  282,  282,    0,  511,    0,  282,    0,  282,  282, 
            0,  282,  282,  282,  282,    0,  282,  282,  282,  322, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   91,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  511,    0,  110,    0,  511,    0,    0, 
            0,  885,    0,    0,  885,    0, 1027,    0,  885,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  511,    0,    0,    0,    0, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,   19,   20,   21,  235, 
          236,  237,  238,    0,  514,  117,    0,    0,    0,    0, 
            0,    0,   28,    0,  514,  239,  240,  241,    0,  242, 
           35,  243,  244,  245,  246,  281,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,  885,    0, 
          885,    0,  885,    0,    0,  885,    0,    0,   94,  247, 
            0,    0,  130,    0,    0,   46,   47,    0,   48,    0, 
          282,    0,  283,  514,   50,  113,    0,  514,    0,    0, 
            0,  885,  284,    0,    0,    0,    0,   52,  285,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,  514,   65,   66,  286,    0, 
            0,    0,    0,    0,  134,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  614,  614,  614,    0,  614,  511,  511,  511,  614, 
          614,    0,  511,  511,  614,  511,  614,  614,  614,  614, 
          614,  614,  614,  134,  614,    0,  135,  614,  614,  614, 
          614,  614,  614,  614,  511,  511,  614,  511,  511,  511, 
          511,  511,    0,  614,    0,    0,  614,  614,  614,    0, 
          614,  614,  614,  614,  614,  614,  614,  614,  614,  614, 
          614,  511,  511,  511,  511,  511,  511,  511,  511,  511, 
          511,  511,  511,  511,  511,  135,    0,  511,  511,  511, 
          614,  523,    0,  614,  614,  511,  614,  614,    0,  614, 
            0,  614,  511,  614,  511,  614,  511,  511,  511,  511, 
          511,  511,  511,  614,  511,  614,  511,    0,  614,  614, 
          614,  614,  614,  614,    0,    0,   56,  614,    0,  614, 
          614,    0,  614,  614,  614,  614,   56,  614,  614,  614, 
          511,  615,  615,  615,    0,  615,  514,  514,  514,  615, 
          615,    0,  514,  514,  615,  514,  615,  615,  615,  615, 
          615,  615,  615,    0,  615,    0,    0,  615,  615,  615, 
          615,  615,  615,  615,  514,  514,  615,  514,  514,  514, 
          514,  514,    0,  615,    0,   56,  615,  615,  615,    0, 
          615,  615,  615,  615,  615,  615,  615,  615,  615,  615, 
          615,  514,  514,  514,  514,  514,  514,  514,  514,  514, 
          514,  514,  514,  514,  514,    0,    0,  514,  514,  514, 
          615,  526,    0,  615,  615,  514,  615,  615,    0,  615, 
            0,  615,  514,  615,  514,  615,  514,  514,  514,  514, 
          514,  514,  514,  615,  514,  615,  514,    0,  615,  615, 
          615,  615,  615,  615,    0,    0,  617,  615,    0,  615, 
          615,    0,  615,  615,  615,  615,  617,  615,  615,  615, 
          514,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          134,    0,  134,  134,  134,  134,  134,    0,    0,    0, 
            0,  134,    0,    0,    0,    0,    0,    0,    0,    0, 
          104,    0,  511,    0,    0,    0,    0,    0,    0,  511, 
            0,    0,    0,  134,  134,  617,    0,  123,    0,  617, 
            0,  134,  134,  134,  134,    0,    0,    0,    0,    0, 
            0,    0,  135,    0,  135,  135,  135,  135, 
      };
   }

   private static final short[] yyTable2() {
      return new short[] {

          135,    0,    0,    0,    0,  135,    0,    0,    0,  617, 
            0,    0,    0,    0,    0,    0,  514,    0,    0,    0, 
            0,  134,    0,  514,    0,    0,    0,  135,  135,    0, 
            0,    0,    0,    0,    0,  135,  135,  135,  135,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  618,    0, 
           56,   56,   56,    0,    0,   56,   56,   56,  618,   56, 
            0,  102,    0,    0,    0,    0,    0,    0,    0,   56, 
            0,    0,    0,  135,    0,    0,    0,    0,   56,   56, 
            0,   56,   56,   56,   56,   56,    0,    0,    0,    0, 
            0,    0,  106,    0,    0,  102,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  618,    0,  125, 
            0,  618,  102,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   56, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  618, 
            0,    0,  522,    0,    0,    0,    0,    0,    0,    0, 
           56,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   56,  617,  617,  617,    0,  617, 
          617,  617,  617,  617,  617,    0,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,    0,  617,    0, 
          124,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,    0,  617,    0,    0, 
          617,  617,  617,    0,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  124, 
            0,  617,  617,  617,  617,    0,    0,  617,  617,  617, 
          617,  617,    0,  617,    0,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  621,  617,  617,  617,  617,  617,  617,    0,    0, 
           52,  617,    0,  617,  617,    0,  617,  617,  617,  617, 
           52,  617,  617,  617,  617,  618,  618,  618,    0,  618, 
          618,  618,  618,  618,  618,    0,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,    0,  618,    0, 
          102,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,    0,  618,    0,   52, 
          618,  618,  618,    0,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  522, 
            0,  618,  618,  618,  618,    0,  522,  618,  618,  618, 
          618,  618,  102,  618,    0,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,    0,  618,  618,  618,  618,  618,  618,    0,    0, 
          621,  618,    0,  618,  618,    0,  618,  618,  618,  618, 
          621,  618,  618,  618,  618,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  124,    0,    0, 
            0,    0,    0,    0,  105,    0,    0,  109,    0,    0, 
          621,    0,    0,    0,    0,    0,    0,    0,    0,  621, 
            0,  124,    0,  621,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  621,    0,    0,  305,    0,    0,    0,  621,    0, 
            0,    0,    0,    0,    0,  621,    0,    0,    0,    0, 
          617,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          315,  621,   52,   52,   52,    0,    0,   52,   52,   52, 
          315,   52,    0,   93,    0,    0,    0,    0,    0,    0, 
            0,   52,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   52,   52,   52,   52,   52,    0,    0, 
            0,    0,    0,    0,  107,    0,    0,   93,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  315, 
            0,  126,    0,  315,   93,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   52,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  315,    0,    0,  513,    0,    0,    0,  304,    0, 
            0,    0,   52,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   52,  617,  617,  617, 
            0,  617,  621,  621,  621,  617,  617,    0,  621,  621, 
          617,  621,  617,  617,  617,  617,  617,  617,  617,    0, 
          621,  411,  128,  617,  617,  617,  617,  617,  617,  617, 
          621,  621,  617,  621,  621,  621,  621,  621,    0,  617, 
            0,    0,  617,  617,  617,    0,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  621,  621,  621, 
          621,  621,  621,  621,  621,  621,  621,  621,  621,  621, 
          621,  305,    0,  621,  621,  621,  617,    0,  305,  617, 
          617,  621,  617,  617,    0,  617,    0,  617,  621,  617, 
          621,  617,  621,  621,  621,  621,  621,  621,  621,  617, 
          621,  621,  621,    0,  617,  617,  617,  617,  617,  617, 
            0,    0,  639,  617,    0,  617,  617,    0,  617,  617, 
          617,  617,  639,  617,  617,  617,  621,  618,  618,  618, 
            0,  618,  315,  315,  315,  618,  618,    0,  315,  315, 
          618,  315,  618,  618,  618,  618,  618,  618,  618,    0, 
            0,    0,   93,  618,  618,  618,  618,  618,  618,  618, 
          315,  315,  618,  315,  315,  315,  315,  315,    0,  618, 
            0,  639,  618,  618,  618,    0,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  315,  315,  315, 
          315,  315,  315,  315,  315,  315,  315,  315,  315,  315, 
          315,  513,    0,  315,  315,  315,  618,    0,  513,  618, 
          618,  315,  618,  618,   93,  618,    0,  618,  315,  618, 
          315,  618,  315,  315,  315,  315,  315,  315,  315,  618, 
          315,    0,  315,    0,  618,  618,  618,  618,  618,  618, 
            0,    0,  436,  618,    0,  618,  618,    0,  618,  618, 
          618,  618,  436,  618,  618,  618,  315,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  386,  387,  388,  389,  390, 
          391,  392,  393,  394,  395,  396,  436,  397,  398,    0, 
            0,  399,  400,    0,  103,    0,    0,    0,    0,    0, 
          436,  436,    0,  122,    0,  436,  401,    0,  402,    0, 
          403,  404,  405,  406,  407,  408,  409,    0,  410,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  436,    0,    0,    0,    0,    0,    0, 
            0,  436,    0,    0,    0,    0,  861,    0,    0,    0, 
            0,   43,    0,  870,    0,    0,    0,    0,    0,    0, 
            0,   43,    0,    0,  877,    0,  108,    0,  114,  282, 
          282,  282,    0,  282,  639,  639,  639,  282,  282,  639, 
          639,  639,  282,  639,  282,  282,  282,  282,  282,  282, 
          282,    0,  639,  639,   94,  282,  282,  282,  282,  282, 
          282,  282,  639,  639,  282,  639,  639,  639,  639,  639, 
           43,  282,    0,  316,  282,  282,  282,  114,  282,  282, 
          282,  282,  282,  282,  282,  282,  282,  282,  282,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          639,  514,    0,    0,    0,    0,    0,  639,  282,  515, 
            0,  282,    0,  639,  282,  282,    0,  282,  435,  282, 
            0,  282,    0,  282,    0,    0,    0,    0,  435,    0, 
            0,  282,    0,  639,  639,    0,  282,  282,  282,  282, 
          282,  282,    0,    0,    0,  282,    0,  282,  282,    0, 
          282,  282,  282,  282,    0,  282,  282,  282,  639,    0, 
            0,    0,  435,    0,  436,  436,  436,    0,    0,  436, 
          436,  436,    0,  436,    0,    0,  435,  435,    0,    0, 
            0,  435,  436,  436,  436,    0,    0,    0,    0,  122, 
          436,    0,  436,  436,    0,  436,  436,  436,  436,  436, 
            0, 1016,    0, 1018,    0, 1019,    0,  436,    0,  435, 
         1021,    0,    0,    0,    0,  104,    0, 1029,    0,  436, 
          436,  436,  436,  436,  436,  436,  436,  436,  436,  436, 
          436,  436,  436,    0,  517,  436,  436,  436,  436,    0, 
          436,    0,    0,  436,  517,  436,  436,    0,  436,  104, 
          436,    0,  436,    0,  436,  436,  436,  436,  436,  436, 
          436,  127,  436,  436,  436,    0,  104,    0,    0,    0, 
            0,  436,    0,   43,   43,   43,  436,    0,  517,   43, 
           43,    0,   43,    0,    0,  114,  128,    0,  436,  113, 
          615,    0,  517,  517,    0,  116,  617,  517,    0,    0, 
            0,    0,    0, 1079,   43,   43,   43,   43,   43, 1080, 
          316, 1082,    0,    0, 1083,    0,    0,  316,    0,    0, 
            0,    0,    0,    0,    0,  517,  127,    0,    0,    0, 
            0,    0,    0,    0,    0,  128,    0,    0,  514,    0, 
         1091,    0,    0,   92,    0,  514,  515,    0,    0,    0, 
          615,    0,   43,  515,    0,    0,    0,    0,    0,  516, 
            0,    0,    0,    0,    0,    0,    0,  305,    0,  516, 
            0,  615,    0,   43,    0,  127,    0,   92,    0,    0, 
          435,  435,  435,    0,    0,  435,  435,  435,    0,  435, 
            0,    0,    0,    0,   92,    0,    0,   43,  435,  435, 
          435,    0,    0,  516,    0,    0,    0,  316,  435,  435, 
            0,  435,  435,  435,  435,  435,    0,  516,  516,    0, 
          115,    0,  516,  435,  512,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  435,  435,  435,  435,  435, 
          435,  435,  435,  435,  435,  435,  435,  435,  435,    0, 
          516,  435,  435,  435,    0,  106,  435,   95,    0,  435, 
            0,    0,  435,    0,  435,    0,  435,  264,  435,    0, 
          435,  435,  435,  435,  435,  435,  435,  264,  435,  435, 
          435,    0,    0,    0,  104,  617,    0,    0,    0,  106, 
            0,   95,  435,    0,    0,    0,  517,  517,  517,    0, 
            0,  517,  517,  517,  435,  517,  106,    0,   95,    0, 
            0,  264,    0,    0,  105,  517,  517,    0,    0,    0, 
            0,    0,    0,    0,  517,  517,  264,  517,  517,  517, 
          517,  517,    0,  617,    0,    0,  618,    0,  515,  517, 
          617,    0,    0,  128,    0,  617,  104,    0,  105,    0, 
            0,  517,  517,  517,  517,  517,  517,  517,  517,  517, 
          517,  517,  517,  517,  517,  105,  617,  517,  517,  517, 
            0,  529,  517,    0,    0,  517,    0,    0,  517,    0, 
          517,    0,  517,  127,  517,    0,  517,  517,  517,  517, 
          517,  517,  517,    0,  517,  621,  517,    0,    0,  518, 
            0,    0,    0,    0,  305,    0,    0,    0,  517,  518, 
            0,  305,   92,    0,    0,    0,    0,    0,    0,    0, 
          517,  516,  516,  516,    0,    0,  516,  516,  516,    0, 
          516,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          516,  516,    0,  518,  316,    0,    0,    0,    0,  516, 
          516,  316,  516,  516,  516,  516,  516,  518,  518,    0, 
          117,  512,  518,    0,  516,    0,    0,    0,  512,    0, 
            0,    0,    0,    0,   92,    0,  516,  516,  516,  516, 
          516,  516,  516,  516,  516,  516,  516,  516,  516,  516, 
          518,    0,  516,  516,  516,    0,  528,  516,    0,    0, 
          516,    0,    0,  516,    0,  516,    0,  516,  519,  516, 
            0,  516,  516,  516,  516,  516,  516,  516,  519,  516, 
            0,  516,    0,    0,  106,  618,   95,    0,    0,  264, 
          264,  264,    0,  516,  264,  264,  264,    0,  264,    0, 
            0,    0,    0,    0,    0,  516,    0,    0,  264,  264, 
            0,    0,  519,    0,    0,    0,    0,  264,  264,    0, 
          264,  264,  264,  264,  264,    0,  519,  519,    0,  118, 
            0,  519,  264,  618,    0,  515,    0,    0,    0,    0, 
          618,    0,  515,  105,  621,  618,  106,    0,   95,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  519, 
            0,    0,    0,    0,    0,  264,  618,    0,  264,    0, 
            0,  264,  104,  264,    0,    0,  521,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  521,    0,    0,  264, 
            0,    0,  621,    0,    0,    0,    0,    0,    0,  621, 
            0,  264,    0,    0,  617,  105,    0,    0,    0,    0, 
            0,    0,    0,  264,    0,    0,    0,    0,    0,  617, 
          521,  518,  518,  518,    0,  621,  518,  518,  518,    0, 
          518,    0,    0,    0,  521,  521,    0,  120,    0,  521, 
          518,  518,    0,    0,    0,    0,    0,    0,    0,  518, 
          518,    0,  518,  518,  518,  518,  518,    0,    0,    0, 
            0,    0,    0,    0,  518,    0,    0,  521,    0,    0, 
            0,    0,    0,    0,    0,    0,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
            0,    0,  518,  518,  518,    0,  530,  518,    0,    0, 
          518,    0,    0,  518,    0,  518,    0,  518,  520,  518, 
            0,  518,  518,  518,  518,  518,  518,  518,  520,  518, 
            0,  518,    0,  106,    0,    0,    0,    0,    0,    0, 
          519,  519,  519,  518,    0,  519,  519,  519,    0,  519, 
            0,    0,    0,    0,    0,  518,    0,    0,    0,  519, 
          519,    0,  520,    0,    0,    0,    0,    0,  519,  519, 
            0,  519,  519,  519,  519,  519,  520,  520,    0,  119, 
          618,  520,    0,  519,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  520, 
            0,  519,  519,  519,    0,  531,  519,  123,  617,  519, 
            0,    0,  519,    0,  519,    0,  519,  522,  519,    0, 
          519,  519,  519,  519,  519,  519,  519,  522,  519,    0, 
          519,  109,    0,    0,    0,    0,    0,    0,  521,  521, 
          521,    0,  519,  521,  521,  521,    0,  521,    0,    0, 
            0,    0,    0,    0,  519,    0,  617,  521,  521,    0, 
            0,  522,    0,  617,    0,  109,  521,  521,  617,  521, 
          521,  521,  521,  521,    0,  522,  522,    0,  121,    0, 
          522,  521,  109,    0,    0,    0,    0,    0,    0,  617, 
            0,    0,    0,  521,  521,  521,  521,  521,  521,  521, 
          521,  521,  521,  521,  521,  521,  521,    0,  522,  521, 
          521,  521,  305,  533,  521,    0,    0,  521,    0,    0, 
          521,    0,  521,    0,  521,  513,  521,    0,  521,  521, 
          521,  521,  521,  521,  521,  513,  521,    0,  521,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          521,    0,    0,    0,    0,    0,    0,    0,  125,  618, 
            0,    0,  521,    0,    0,    0,    0,    0,    0,  513, 
          520,  520,  520,    0,    0,  520,  520,  520,    0,  520, 
            0,    0,    0,  513,  513,    0,  112,    0,  513,  520, 
          520,    0,    0,    0,    0,    0,    0,    0,  520,  520, 
            0,  520,  520,  520,  520,  520,    0,  618,    0,    0, 
            0,    0,    0,  520,  618,    0,  513,    0,    0,  618, 
            0,    0,    0,    0,    0,  520,  520,  520,  520,  520, 
          520,  520,  520,  520,  520,  520,  520,  520,  520,    0, 
          618,  520,  520,  520,    0,  532,  520,    0,    0,  520, 
            0,    0,  520,    0,  520,    0,  520,  512,  520,    0, 
          520,  520,  520,  520,  520,  520,  520,  512,  520,    0, 
          520,    0,  105,    0,    0,    0,    0,    0,    0,  522, 
          522,  522,  520,    0,  522,  522,  522,    0,  522,    0, 
            0,    0,    0,    0,  520,    0,    0,    0,  522,  522, 
          109,  512,    0,    0,    0,    0,    0,  522,  522,    0, 
          522,  522,  522,  522,  522,  512,  512,    0,  111,  621, 
          512,    0,  522,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  522,  522,  522,  522,  522,  522, 
          522,  522,  522,  522,  522,  522,  522,  522,  512,  305, 
          522,  522,  522,    0,  534,  522,  305,    0,  522,    0, 
            0,  522,  109,  522,    0,  522,  515,  522,    0,  522, 
          522,  522,  522,  522,  522,  522,  515,  522,    0,  522, 
          108,    0,    0,    0,    0,    0,    0,  513,  513,  513, 
            0,  522,  513,  513,  513,    0,  513,    0,    0,    0, 
            0,    0,    0,  522,    0,    0,  513,  513,    0,    0, 
          515,    0,    0,    0,  108,  513,  513,    0,  513,  513, 
          513,  513,  513,    0,  515,  515,    0,  114,    0,  515, 
          513,  108,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  513,  513,  513,  513,  513,  513,  513,  513, 
          513,  513,  513,  513,  513,  513,    0,  515,  513,  513, 
          513,  316,  525,  513,    0,    0,  513,    0,    0,  513, 
            0,  513,    0,  513,  639,  513,    0,  513,  513,  513, 
          513,  513,  513,  513,  639,  513,    0,  513,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  513, 
            0,    0,    0,    0,    0,    0,    0,  124,  621,    0, 
            0,  513,    0,    0,    0,    0,    0,    0,  639,  512, 
          512,  512,    0,    0,  512,  512,  512,    0,  512,    0, 
            0,    0,  639,  639,    0,    0,    0,  639,  512,  512, 
            0,    0,    0,    0,    0,    0,    0,  512,  512,    0, 
          512,  512,  512,  512,  512,    0,  621,    0,    0,    0, 
            0,    0,  512,  621,    0,  639,    0,    0,  617,    0, 
            0,    0,    0,    0,  512,  512,  512,  512,  512,  512, 
          512,  512,  512,  512,  512,  512,  512,  512,    0,  621, 
          512,  512,  512,    0,  524,  512,    0,    0,  512,    0, 
            0,  512,    0,  512,    0,  512,  305,  512,    0,  512, 
          512,  512,  512,  512,  512,  512,  305,  512,    0,  512, 
            0,    0,    0,    0,    0,    0,    0,    0,  515,  515, 
          515,  512,    0,  515,  515,  515,    0,  515,    0,    0, 
            0,    0,    0,  512,    0,    0,    0,  515,  515,  108, 
          305,    0,    0,    0,    0,    0,  515,  515,    0,  515, 
          515,  515,  515,  515,  305,  305,    0,  128,    0,  305, 
            0,  515,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  515,  515,  515,  515,  515,  515,  515, 
          515,  515,  515,  515,  515,  515,  515,  305,  316,  515, 
          515,  515,    0,  527,  515,  316,    0,  515,    0,    0, 
          515,  108,  515,    0,  515,  316,  515,    0,  515,  515, 
          515,  515,  515,  515,  515,  316,  515,    0,  515,    0, 
            0,    0,    0,    0,    0,    0,  639,  639,  639,    0, 
          515,  639,  639,  639,    0,  639,    0,    0,    0,    0, 
            0,    0,  515,    0,  639,  639,  639,    0,    0,  316, 
            0,    0,    0,    0,  639,  639,    0,  639,  639,  639, 
          639,  639,    0,  316,  316,    0,  127,    0,  316,  639, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  639,  639,  639,  639,  639,  639,  639,  639,  639, 
          639,  639,  639,  639,  639,    0,  316,  639,  639,  639, 
            0,    0,  639,    0,    0,  639,    0,    0,  639,    0, 
          639,    0,  639,  456,  639,    0,  639,  639,  639,  639, 
          639,  639,  639,  456,  639,  639,  639,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  639,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          639,    0,    0,    0,    0,    0,    0,  456,  305,  305, 
          305,    0,    0,  305,  305,  305,    0,  305,    0,    0, 
            0,  456,  456,    0,    0,    0,  456,  305,  305,    0, 
            0,    0,    0,    0,    0,    0,  305,  305,    0,  305, 
          305,  305,  305,  305,    0,    0,    0,    0,    0,    0, 
            0,  305,    0,    0,  456,    0,    0,    0,    0,    0, 
            0,    0,    0,  305,  305,  305,  305,  305,  305,  305, 
          305,  305,  305,  305,  305,  305,  305,    0,    0,  305, 
          305,  305,    0,    0,  305,    0,    0,  305,    0,    0, 
          305,    0,  305,    0,  305,  327,  305,    0,  305,  305, 
          305,  305,  305,  305,  305,  327,  305,    0,  305,    0, 
            0,    0,    0,    0,    0,    0,    0,  316,  316,  316, 
          305,    0,  316,  316,  316,    0,  316,    0,    0,    0, 
            0,    0,  305,    0,    0,    0,  316,  316,    0,  327, 
            0,    0,    0,    0,    0,  316,  316,    0,  316,  316, 
          316,  316,  316,  327,  327,    0,    0,    0,  327,    0, 
          316,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  316,  316,  316,  316,  316,  316,  316,  316, 
          316,  316,  316,  316,  316,  316,  327,    0,  316,  316, 
          316,    0,    0,  316,    0,    0,  316,    0,    0,  316, 
            0,  316,    0,  316,  263,  316,    0,  316,  316,  316, 
          316,  316,  316,  316,  263,  316,    0,  316,    0,    0, 
            0,    0,    0,    0,    0,  456,  456,  456,    0,  316, 
          456,  456,  456,    0,  456,    0,    0,    0,    0,    0, 
            0,  316,    0,    0,  456,  456,    0,    0,  263,    0, 
            0,    0,    0,  456,  456,    0,  456,  456,  456,  456, 
          456,    0,  263,  263,    0,    0,    0,  263,  456,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          456,  456,  456,  456,  456,  456,  456,  456,  456,  456, 
          456,  456,  456,  456,    0,  359,  456,  456,  456,    0, 
            0,  456,    0,    0,  456,    0,    0,  456,    0,  456, 
            0,  456,  322,  456,    0,  456,  456,  456,  456,  456, 
          456,  456,  322,  456,    0,  456,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  456,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  456, 
            0,    0,    0,    0,    0,    0,  322,  327,  327,  327, 
            0,    0,  327,  327,  327,    0,  327,    0,    0,    0, 
          322,  322,    0,    0,    0,  322,  327,  327,    0,    0, 
            0,    0,    0,    0,    0,  327,  327,    0,  327,  327, 
          327,  327,  327,    0,    0,    0,    0,    0,    0,    0, 
          327,    0,    0,  322,    0,    0,    0,    0,    0,    0, 
            0,    0,  327,  327,  327,  327,  327,  327,  327,  327, 
          327,  327,  327,  327,  327,  327,    0,    0,  327,  327, 
          327,    0,    0,  327,    0,    0,  327,    0,    0,  327, 
            0,  327,    0,  327,  506,  327,    0,  327,  327,  327, 
          327,  327,  327,  327,  506,  327,    0,  327,    0,    0, 
            0,    0,    0,    0,    0,    0,  263,  263,  263,  327, 
            0,  263,  263,  263,    0,  263,    0,    0,    0,    0, 
            0,  327,    0,    0,    0,  263,  263,    0,  506,    0, 
            0,    0,    0,    0,  263,  263,    0,  263,  263,  263, 
          263,  263,  506,  506,    0,    0,    0,  506,    0,  263, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  263,  263,  263,  263,  263,  263,  263,  263,  263, 
          263,  263,  359,  263,  263,  506,    0,  263,  263,  359, 
            0,    0,  263,    0,    0,  263,    0,    0,  263,    0, 
          263,    0,  263,  355,  263,    0,  263,  263,  263,  263, 
          263,  263,  263,  355,  263,    0,  263,    0,    0,    0, 
            0,    0,    0,    0,  322,  322,  322,    0,  263,  322, 
          322,  322,    0,  322,    0,    0,    0,    0,    0,    0, 
          263,    0,    0,  322,  322,    0,    0,  355,    0,    0, 
            0,    0,  322,  322,    0,  322,  322,  322,  322,  322, 
            0,    0,  355,    0,    0,    0,  355,  322,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  322, 
          322,  322,  322,  322,  322,  322,  322,  322,  322,  322, 
          322,  322,  322,    0,  355,  322,  322,  322,    0,    0, 
          322,    0,    0,  322,    0,    0,  322,    0,  322,    0, 
          322,  356,  322,    0,  322,  322,  322,  322,  322,  322, 
          322,  356,  322,    0,  322,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  322,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  322,    0, 
            0,    0,    0,    0,    0,  356,  506,  506,  506,    0, 
            0,  506,  506,  506,    0,  506,    0,    0,    0,    0, 
          356,    0,    0,    0,  356,  506,  506,    0,    0,    0, 
            0,    0,    0,    0,  506,  506,    0,  506,  506,  506, 
          506,  506,    0,    0,    0,    0,    0,    0,    0,  506, 
            0,    0,  356,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  506,  506,  506,  506,  506,  506,  506,  506, 
          506,  506,  506,  506,  506,    0,    0,  506,  506,  506, 
            0,    0,  506,    0,    0,  506,    0,    0,  506,    0, 
          506,    0,  506,  319,  506,    0,  506,  506,  506,  506, 
          506,  506,  506,  319,  506,    0,  506,    0,    0,    0, 
            0,    0,    0,    0,    0,  355,  355,  355,  506,    0, 
          355,  355,  355,    0,  355,    0,    0,    0,    0,    0, 
          506,    0,    0,    0,  355,  355,    0,  319,    0,    0, 
            0,    0,    0,  355,  355,    0,  355,  355,  355,  355, 
          355,    0,  319,    0,    0,    0,  319,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          355,  355,  355,  355,  355,  355,  355,  355,  355,  355, 
          355,  355,  355,  355,  319,    0,  355,  355,  355,    0, 
            0,  355,    0,    0,  355,    0,    0,  355,    0,  355, 
            0,  355,  239,  355,    0,  355,  355,  355,  355,  355, 
          355,  355,  239,  355,    0,  355,    0,    0,    0,    0, 
            0,    0,    0,  356,  356,  356,    0,    0,  356,  356, 
          356,    0,  356,    0,    0,    0,    0,    0,    0,  355, 
            0,    0,  356,  356,    0,    0,  239,    0,    0,    0, 
            0,  356,  356,    0,  356,  356,  356,  356,  356,    0, 
          239,  239,    0,    0,    0,  239,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  356,  356, 
          356,  356,  356,  356,  356,  356,  356,  356,  356,  356, 
          356,  356,    0,    0,  356,  356,  356,    0,    0,  356, 
            0,    0,  356,    0,    0,  356,    0,  356,    0,  356, 
          236,  356,    0,  356,  356,  356,  356,  356,  356,  356, 
          236,  356,    0,  356,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  356,    0,    0, 
            0,    0,    0,    0,  236,  319,  319,  319,    0,    0, 
          319,  319,  319,    0,  319,    0,    0,    0,  236,  236, 
            0,    0,    0,  236,  319,  319,    0,    0,    0,    0, 
            0,    0,    0,  319,  319,    0,  319,  319,  319,  319, 
          319,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          319,  319,  319,  319,  319,  319,  319,  319,  319,  319, 
          319,  319,  319,  319,    0,    0,  319,  319,  319,    0, 
            0,  319,    0,    0,  319,    0,    0,  319,    0,  319, 
            0,  319,  233,  319,    0,  319,  319,  319,  319,  319, 
          319,  319,  233,  319,    0,  319,    0,    0,    0,    0, 
            0,    0,    0,    0,  239,  239,  239,    0,    0,  239, 
          239,  239,    0,  239,    0,    0,    0,    0,    0,  319, 
            0,    0,    0,  239,  239,  872,  233,    0,  872,    0, 
            0,    0,  239,  239,  882,  239,  239,  239,  239,  239, 
          233,  233,    0,    0,    0,  233,    0,  239,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          239,  239,  239,  239,  239,  239,  239,  239,  239,  239, 
            0,  239,  239,    0,    0,  239,  239,    0,    0,    0, 
          239,    0,    0,  239,    0,    0,  239,    0,  239,    0, 
          239,  235,  239,    0,  239,  239,  239,  239,  239,  239, 
          239,  235,  239,    0,  239,    0,    0,    0,    0,    0, 
            0,    0,  236,  236,  236,    0,  239,  236,  236,  236, 
            0,  236,    0,    0,    0,    0,    0,    0,  239,    0, 
            0,  236,  236,    0,    0,  235,    0,    0,    0,    0, 
          236,  236,    0,  236,  236,  236,  236,  236,    0,  235, 
          235,    0,    0,    0,  235,  236,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  236,  236, 
          236,  236,  236,  236,  236,  236,  236,  236,    0,  236, 
          236,    0,    0,  236,  236,    0,    0,    0,  236,    0, 
            0,  236,    0,    0,  236,    0,  236,    0,  236,  234, 
          236,    0,  236,  236,  236,  236,  236,  236,  236,  234, 
          236,    0,  236,    0,    0,    0,    0,    0,    0,    0, 
          882,    0,    0,  882,  236,  872,    0,  882,    0,    0, 
            0,    0,    0,    0,    0,    0,  236,    0,    0,    0, 
            0,    0,    0,  234,  233,  233,  233,    0,    0,  233, 
          233,  233,    0,  233,    0,    0,    0,  234,  234,    0, 
            0,    0,  234,  233,  233,    0,    0,    0,    0,    0, 
            0,    0,  233,  233,    0,  233,  233,  233,  233,  233, 
            0,    0,    0,    0,    0,    0,    0,  233,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          233,  233,  233,  233,  233,  233,  233,  233,  233,  233, 
            0,  233,  233,    0,    0,  233,  233,  882,    0,  882, 
          233,  882,    0,  233,  882,    0,  233,    0,  233,    0, 
          233,  237,  233,    0,  233,  233,  233,  233,  233,  233, 
          233,  237,  233,    0,  233,    0,    0,    0,    0,    0, 
          882,    0,    0,  235,  235,  235,  233,    0,  235,  235, 
          235,    0,  235,    0,    0,    0,    0,    0,  233,    0, 
            0,    0,  235,  235,    0,  237,    0,    0,    0,    0, 
            0,  235,  235,    0,  235,  235,  235,  235,  235,  237, 
          237,    0,    0,    0,  237,    0,  235,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  235, 
          235,  235,  235,  235,  235,  235,  235,  235,  235,    0, 
          235,  235,    0,    0,  235,  235,    0,    0,    0,  235, 
            0,    0,  235,    0,    0,  235,    0,  235,    0,  235, 
          436,  235,    0,  235,  235,  235,  235,  235,  235,  235, 
          436,  235,    0,  235,    0,    0,    0,    0,    0,    0, 
            0,  234,  234,  234,    0,  235,  234,  234,  234,    0, 
          234,    0,    0,    0,    0,    0,    0,  235,    0,    0, 
          234,  234,    0,    0,  103,    0,    0,    0,    0,  234, 
          234,    0,  234,  234,  234,  234,  234,    0,    0,  436, 
            0,  122,    0,  436,  234,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  234,  234,  234, 
          234,  234,  234,  234,  234,  234,  234,    0,  234,  234, 
            0,  436,  234,  234,    0,    0,    0,  234,    0,    0, 
          234,    0,    0,  234,    0,  234,    0,  234,  517,  234, 
            0,  234,  234,  234,  234,  234,  234,  234,  517,  234, 
            0,  234,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  234,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  234,    0,    0,    0,    0, 
            0,    0,   97,  237,  237,  237,    0,    0,  237,  237, 
          237,    0,  237,    0,    0,    0,    0,  517,    0,  116, 
            0,  517,  237,  237,    0,    0,    0,    0,    0,    0, 
            0,  237,  237,    0,  237,  237,  237,  237,  237,    0, 
            0,    0,    0,    0,    0,    0,  237,    0,    0,  517, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  237, 
          237,  237,  237,  237,  237,  237,  237,  237,  237,    0, 
          237,  237,    0,    0,  237,  237,    0,    0,    0,  237, 
            0,    0,  237,    0,    0,  237,    0,  237,    0,  237, 
          516,  237,    0,  237,  237,  237,  237,  237,  237,  237, 
          516,  237,    0,  237,    0,    0,    0,    0,    0,    0, 
            0,    0,  436,  436,  436,  237,    0,    0,  436,  436, 
            0,  436,    0,    0,    0,    0,    0,  237,    0,    0, 
          436,    0,    0,    0,   96,    0,    0,    0,    0,    0, 
          436,  436,    0,  436,  436,  436,  436,  436,    0,  516, 
            0,  115,    0,  516,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  436,  436,  436, 
          436,  436,  436,  436,  436,  436,  436,  436,  436,  436, 
          436,  516,    0,  436,  436,  436,    0,    0,    0,    0, 
            0,  436,    0,    0,    0,    0,    0,    0,  436,  518, 
          436,    0,  436,  436,  436,  436,  436,  436,  436,  518, 
          436,  436,  436,    0,    0,    0,    0,    0,    0,    0, 
          517,  517,  517,    0,    0,    0,  517,  517,    0,  517, 
            0,    0,    0,    0,    0,    0,  436,    0,    0,    0, 
            0,    0,    0,   98,    0,    0,    0,    0,  517,  517, 
            0,  517,  517,  517,  517,  517,    0,    0,  518,    0, 
          117,    0,  518,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  517,  517,  517,  517,  517, 
          517,  517,  517,  517,  517,  517,  517,  517,  517,    0, 
          518,  517,  517,  517,    0,  529,    0,    0,    0,  517, 
            0,    0,    0,    0,    0,    0,  517,  519,  517,    0, 
          517,  517,  517,  517,  517,  517,  517,  519,  517,    0, 
          517,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  517,    0,    0,    0,    0,    0, 
            0,   99,  516,  516,  516,    0,    0,    0,  516,  516, 
            0,  516,    0,    0,    0,    0,  519,    0,  118,    0, 
          519,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          516,  516,    0,  516,  516,  516,  516,  516,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  519,    0, 
            0,    0,    0,    0,    0,    0,    0,  516,  516,  516, 
          516,  516,  516,  516,  516,  516,  516,  516,  516,  516, 
          516,    0,    0,  516,  516,  516,    0,  528,    0,    0, 
            0,  516,    0,    0,    0,    0,    0,    0,  516,  521, 
          516,    0,  516,  516,  516,  516,  516,  516,  516,  521, 
          516,    0,  516,    0,    0,    0,    0,    0,    0,    0, 
            0,  518,  518,  518,    0,    0,    0,  518,  518,    0, 
          518,    0,    0,    0,    0,    0,  516,    0,    0,    0, 
            0,    0,    0,  101,    0,    0,    0,    0,    0,  518, 
          518,    0,  518,  518,  518,  518,  518,    0,  521,    0, 
          120,    0,  521,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
          521,    0,  518,  518,  518,    0,  530,    0,    0,    0, 
          518,    0,    0,    0,    0,    0,    0,  518,  520,  518, 
            0,  518,  518,  518,  518,  518,  518,  518,  520,  518, 
            0,  518,    0,    0,    0,    0,    0,    0,    0,  519, 
          519,  519,    0,    0,    0,  519,  519,    0,  519,    0, 
            0,    0,    0,    0,    0,  518,    0,    0,    0,    0, 
            0,    0,  100,    0,    0,    0,    0,  519,  519,    0, 
          519,  519,  519,  519,  519,    0,    0,  520,    0,  119, 
            0,  520,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,  519,  519,  519,  519,    0,  520, 
          519,  519,  519,    0,  531,    0,    0,    0,  519,    0, 
            0,    0,    0,    0,    0,  519,  522,  519,    0,  519, 
          519,  519,  519,  519,  519,  519,  522,  519,    0,  519, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  519,    0,    0,    0,    0,    0,    0, 
          102,  521,  521,  521,    0,    0,    0,  521,  521,    0, 
          521,    0,    0,    0,    0,  522,    0,  121,    0,  522, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  521, 
          521,    0,  521,  521,  521,  521,  521,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  522,    0,    0, 
            0,    0,    0,    0,    0,    0,  521,  521,  521,  521, 
          521,  521,  521,  521,  521,  521,  521,  521,  521,  521, 
            0,    0,  521,  521,  521,    0,  533,    0,    0,    0, 
          521,    0,    0,    0,    0,    0,    0,  521,  513,  521, 
            0,  521,  521,  521,  521,  521,  521,  521,  513,  521, 
            0,  521,    0,    0,    0,    0,    0,    0,    0,    0, 
          520,  520,  520,    0,    0,    0,  520,  520,    0,  520, 
            0,    0,    0,    0,    0,  521,    0,    0,    0,    0, 
            0,    0,   93,    0,    0,    0,    0,    0,  520,  520, 
            0,  520,  520,  520,  520,  520,    0,  513,    0,  112, 
            0,  513,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  520,  520,  520,  520,  520, 
          520,  520,  520,  520,  520,  520,  520,  520,  520,  513, 
            0,  520,  520,  520,    0,  532,    0,    0,    0,  520, 
            0,    0,    0,    0,    0,    0,  520,  512,  520,    0, 
          520,  520,  520,  520,  520,  520,  520,  512,  520,    0, 
          520,    0,    0,    0,    0,    0,    0,    0,  522,  522, 
          522,    0,    0,    0,  522,  522,    0,  522,    0,    0, 
            0,    0,    0,    0,  520,    0,    0,    0,    0,    0, 
            0,   92,    0,    0,    0,    0,  522,  522,    0,  522, 
          522,  522,  522,  522,    0,    0,  512,    0,  111,    0, 
          512,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  522,  522,  522,  522,  522,  522,  522, 
          522,  522,  522,  522,  522,  522,  522,    0,  512,  522, 
          522,  522,    0,  534,    0,    0,    0,  522,    0,    0, 
            0,    0,    0,    0,  522,  515,  522,    0,  522,  522, 
          522,  522,  522,  522,  522,  515,  522,    0,  522,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0, 
      };
   }

   private static final short[] yyTable3() {
      return new short[] {

            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  522,    0,    0,    0,    0,    0,    0, 
           95,  513,  513,  513,    0,    0,    0,  513,  513,    0, 
          513,    0,    0,    0,    0,  515,    0,  114,    0,  515, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  513, 
          513,    0,  513,  513,  513,  513,  513,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  515,    0,    0, 
            0,    0,    0,    0,    0,    0,  513,  513,  513,  513, 
          513,  513,  513,  513,  513,  513,  513,  513,  513,  513, 
            0,    0,  513,  513,  513,    0,  525,    0,    0,    0, 
          513,    0,    0,    0,    0,    0,    0,  513,  231,  513, 
            0,  513,  513,  513,  513,  513,  513,  513,  231,  513, 
            0,  513,    0,    0,    0,    0,    0,    0,    0,    0, 
          512,  512,  512,    0,    0,    0,  512,  512,    0,  512, 
            0,    0,    0,    0,    0,  513,    0,    0,    0,    0, 
            0,    0,  231,    0,    0,    0,    0,    0,  512,  512, 
            0,  512,  512,  512,  512,  512,  231,  231,    0,    0, 
            0,  231,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  512,  512,  512,  512,  512, 
          512,  512,  512,  512,  512,  512,  512,  512,  512,    0, 
            0,  512,  512,  512,    0,  524,    0,    0,    0,  512, 
            0,    0,    0,    0,    0,    0,  512,  232,  512,    0, 
          512,  512,  512,  512,  512,  512,  512,  232,  512,    0, 
          512,    0,    0,    0,    0,    0,    0,    0,  515,  515, 
          515,    0,    0,    0,  515,  515,    0,  515,    0,    0, 
            0,    0,    0,    0,  512,    0,    0,    0,    0,    0, 
            0,  232,    0,    0,    0,    0,  515,  515,    0,  515, 
          515,  515,  515,  515,    0,  232,  232,    0,    0,    0, 
          232,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  515,  515,  515,  515,  515,  515,  515, 
          515,  515,  515,  515,  515,  515,  515,    0,    0,  515, 
          515,  515,    0,  527,    0,    0,    0,  515,    0,    0, 
            0,    0,    0,    0,  515,  305,  515,    0,  515,  515, 
          515,  515,  515,  515,  515,  305,  515,    0,  515,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  515,    0,    0,    0,    0,    0,    0,  109, 
          231,  231,  231,    0,    0,  231,  231,  231,    0,  231, 
            0,    0,    0,    0,  305,    0,  128,    0,  305,  231, 
          231,    0,    0,    0,    0,    0,    0,    0,  231,  231, 
            0,  231,  231,  231,  231,  231,    0,    0,    0,    0, 
            0,    0,    0,  231,    0,    0,  305,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  231,  231,  231,  231, 
          231,  231,  231,  231,  231,  231,    0,  231,  231,    0, 
            0,  231,  231,    0,    0,    0,  231,    0,    0,  231, 
            0,    0,  231,    0,  231,    0,    0,  316,  231,    0, 
            0,    0,  231,  231,  231,  231,  231,  316,  231,    0, 
          231,    0,    0,    0,    0,    0,    0,    0,    0,  232, 
          232,  232,  231,    0,  232,  232,  232,    0,  232,    0, 
            0,    0,    0,    0,  231,    0,    0,    0,  232,  232, 
            0,  108,    0,    0,    0,    0,    0,  232,  232,    0, 
          232,  232,  232,  232,  232,    0,  316,    0,  127,    0, 
          316,    0,  232,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  232,  232,  232,  232,  232, 
          232,  232,  232,  232,  232,    0,  232,  232,  316,    0, 
          232,  232,    0,    0,    0,  232,    0,    0,  232,    0, 
            0,  232,    0,  232,    0,    0,  255,  232,    0,    0, 
            0,  232,  232,  232,  232,  232,  255,  232,    0,  232, 
            0,    0,    0,    0,    0,    0,    0,  305,  305,  305, 
            0,  232,    0,  305,  305,    0,  305,    0,    0,    0, 
            0,    0,    0,  232,    0,    0,    0,    0,    0,    0, 
          255,    0,    0,    0,    0,  305,  305,    0,  305,  305, 
          305,  305,  305,    0,  255,  255,    0,    0,    0,  255, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  305,  305,  305,  305,  305,  305,  305,  305, 
          305,  305,  305,  305,  305,  305,    0,    0,  305,  305, 
          305,    0,    0,    0,    0,    0,  305,    0,    0,    0, 
            0,    0,    0,  305,  256,  305,    0,  305,  305,  305, 
          305,  305,  305,  305,  256,  305,    0,  305,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  305,    0,    0,    0,    0,    0,    0,  256,  316, 
          316,  316,    0,    0,    0,  316,  316,    0,  316,    0, 
            0,    0,  256,  256,    0,    0,    0,  256,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  316,  316,    0, 
          316,  316,  316,  316,  316,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  316,  316,  316,  316,  316,  316, 
          316,  316,  316,  316,  316,  316,  316,  316,    0,    0, 
          316,  316,  316,    0,    0,    0,    0,    0,  316,    0, 
            0,    0,    0,    0,    0,  316,  242,  316,    0,  316, 
          316,  316,  316,  316,  316,  316,  242,  316,    0,  316, 
            0,    0,    0,    0,    0,    0,    0,    0,  255,  255, 
          255,    0,    0,  255,  255,  255,    0,  255,    0,    0, 
            0,    0,    0,  316,    0,    0,    0,  255,  255,    0, 
          242,    0,    0,    0,    0,    0,  255,  255,    0,  255, 
          255,  255,  255,  255,  242,  242,    0,    0,    0,  242, 
            0,  255,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  255,  255,  255,  255,  255,  255, 
          255,  255,  255,  255,    0,  255,  255,    0,    0,  255, 
          255,    0,    0,    0,  255,    0,    0,  255,    0,    0, 
          255,    0,  255,    0,    0,  240,  255,    0,    0,    0, 
            0,    0,  255,  255,  255,  240,  255,    0,  255,    0, 
            0,    0,    0,    0,    0,    0,  256,  256,  256,    0, 
          255,  256,  256,  256,    0,  256,    0,    0,    0,    0, 
            0,    0,  255,    0,    0,  256,  256,    0,    0,  240, 
            0,    0,    0,    0,  256,  256,    0,  256,  256,  256, 
          256,  256,    0,  240,  240,    0,    0,    0,  240,  256, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  256,  256,  256,  256,  256,  256,  256,  256, 
          256,  256,    0,  256,  256,    0,    0,  256,  256,    0, 
            0,    0,  256,    0,    0,  256,    0,    0,  256,    0, 
          256,    0,    0,  241,  256,    0,    0,    0,    0,    0, 
          256,  256,  256,  241,  256,    0,  256,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  256,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          256,    0,    0,    0,    0,    0,    0,  241,  242,  242, 
          242,    0,    0,  242,  242,  242,    0,  242,    0,    0, 
            0,  241,  241,    0,    0,    0,  241,  242,  242,    0, 
            0,    0,    0,    0,    0,    0,  242,  242,    0,  242, 
          242,  242,  242,  242,    0,    0,    0,    0,    0,    0, 
            0,  242,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  242,  242,  242,  242,  242,  242, 
          242,  242,  242,  242,    0,  242,  242,    0,    0,    0, 
            0,    0,    0,    0,  242,    0,    0,  242,    0,    0, 
          242,    0,  242,    0,    0,  245,  242,    0,    0,    0, 
            0,    0,  242,  242,  242,  245,  242,    0,  242,    0, 
            0,    0,    0,    0,    0,    0,    0,  240,  240,  240, 
          242,    0,  240,  240,  240,    0,  240,    0,    0,    0, 
            0,    0,  242,    0,    0,    0,  240,  240,    0,  245, 
            0,    0,    0,    0,    0,  240,  240,    0,  240,  240, 
          240,  240,  240,  245,  245,    0,    0,    0,  245,    0, 
          240,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  240,  240,  240,  240,  240,  240,  240, 
          240,  240,  240,    0,  240,  240,    0,    0,    0,    0, 
            0,    0,  247,  240,    0,    0,  240,    0,    0,  240, 
            0,  240,  247,    0,    0,    0,    0,    0,    0,    0, 
            0,  240,  240,  240,    0,  240,    0,  240,    0,    0, 
            0,    0,    0,    0,    0,  241,  241,  241,    0,  240, 
          241,  241,  241,    0,  241,    0,  247,    0,    0,    0, 
            0,  240,    0,    0,  241,  241,    0,    0,    0,    0, 
          247,  247,    0,  241,  241,  247,  241,  241,  241,  241, 
          241,    0,    0,    0,    0,    0,    0,    0,  241,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  241,  241,  241,  241,  241,  241,  241,  241,  241, 
          241,    0,  241,  241,    0,    0,    0,    0,    0,    0, 
            0,  241,    0,    0,  241,    0,    0,  241,    0,  241, 
            0,    0,  246,    0,    0,    0,    0,    0,    0,  241, 
          241,  241,  246,  241,    0,  241,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  241,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  241, 
            0,    0,    0,    0,    0,    0,  246,  245,  245,  245, 
            0,    0,  245,  245,  245,    0,  245,    0,    0,    0, 
          246,  246,    0,    0,    0,  246,  245,  245,    0,    0, 
            0,    0,    0,    0,    0,  245,  245,    0,  245,  245, 
          245,  245,  245,    0,    0,    0,    0,    0,    0,    0, 
          245,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  245,  245,  245,  245,  245,  245,  245, 
          245,  245,  245,    0,  245,  245,    0,    0,    0,    0, 
            0,    0,  244,  245,    0,    0,  245,    0,    0,  245, 
            0,  245,  244,    0,    0,    0,    0,    0,    0,    0, 
            0,  245,  245,    0,  247,  247,  247,  245,    0,  247, 
          247,  247,    0,  247,    0,    0,    0,    0,    0,  245, 
            0,    0,    0,  247,  247,    0,  244,    0,    0,    0, 
            0,  245,  247,  247,    0,  247,  247,  247,  247,  247, 
          244,  244,    0,    0,    0,  244,    0,  247,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          247,  247,  247,  247,  247,  247,  247,  247,  247,  247, 
            0,  247,  247,    0,    0,    0,    0,    0,    0,  243, 
          247,    0,    0,  247,    0,    0,  247,    0,  247,  243, 
            0,    0,    0,    0,    0,    0,    0,    0,  247,  247, 
            0,    0,    0,    0,  247,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  247,    0,    0,    0, 
            0,    0,    0,  243,  246,  246,  246,    0,  247,  246, 
          246,  246,    0,  246,    0,    0,    0,  243,  243,    0, 
            0,    0,  243,  246,  246,    0,    0,    0,    0,    0, 
            0,    0,  246,  246,    0,  246,  246,  246,  246,  246, 
            0,    0,    0,    0,    0,    0,    0,  246,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          246,  246,  246,  246,  246,  246,  246,  246,  246,  246, 
            0,  246,  246,    0,    0,    0,    0,    0,    0,  248, 
          246,    0,    0,  246,    0,    0,  246,    0,  246,  248, 
            0,    0,    0,    0,    0,    0,    0,    0,  246,  246, 
            0,    0,    0,    0,  246,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  246,    0,    0,    0, 
            0,    0,    0,  248,  244,  244,  244,    0,  246,  244, 
          244,  244,    0,  244,    0,    0,    0,  248,  248,    0, 
            0,    0,  248,  244,  244,    0,    0,    0,    0,    0, 
            0,    0,  244,  244,    0,  244,  244,  244,  244,  244, 
            0,    0,    0,    0,    0,    0,    0,  244,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          244,  244,  244,  244,  244,  244,  244,  244,  244,  244, 
            0,  244,  244,    0,    0,    0,    0,    0,    0,  249, 
          244,    0,    0,  244,    0,    0,  244,    0,  244,  249, 
            0,    0,    0,    0,    0,    0,    0,    0,  244,  244, 
            0,  243,  243,  243,  244,    0,  243,  243,  243,    0, 
          243,    0,    0,    0,    0,    0,  244,    0,    0,    0, 
          243,  243,    0,  249,    0,    0,    0,    0,  244,  243, 
          243,    0,  243,  243,  243,  243,  243,  249,  249,    0, 
            0,    0,  249,    0,  243,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  243,  243,    0,    0,    0,  243,  243, 
            0,    0,    0,    0,    0,    0,  250,  243,    0,    0, 
          243,    0,    0,  243,    0,  243,  250,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  243,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  243,    0,    0,    0,    0,    0,    0, 
          250,  248,  248,  248,    0,  243,  248,  248,  248,    0, 
          248,    0,    0,    0,  250,  250,    0,    0,    0,  250, 
          248,  248,    0,    0,    0,    0,    0,    0,    0,  248, 
          248,    0,  248,  248,  248,  248,  248,    0,    0,    0, 
            0,    0,    0,    0,  248,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   25,    0,    0, 
            0,    0,    0,  248,  248,    0,    0,   25,  248,  248, 
            0,    0,    0,    0,    0,    0,  257,  248,    0,    0, 
          248,    0,    0,  248,    0,  248,  257,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  248,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  248,    0,    0,   25,    0,    0,    0, 
          257,  249,  249,  249,    0,  248,  249,  249,  249,    0, 
          249,    0,    0,    0,  257,  257,    0,    0,    0,  257, 
          249,  249,    0,    0,    0,    0,    0,    0,    0,  249, 
          249,    0,  249,  249,  249,  249,  249,    0,    0,    0, 
            0,    0,    0,    0,  249,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  249,  249,  251,    0,    0,  249,  249, 
            0,    0,    0,    0,    0,  251,    0,  249,    0,    0, 
          249,    0,    0,  249,    0,  249,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  250,  250, 
          250,  249,    0,  250,  250,  250,    0,  250,    0,  251, 
            0,    0,    0,  249,    0,    0,    0,  250,  250,    0, 
            0,    0,    0,  251,  251,  249,  250,  250,  251,  250, 
          250,  250,  250,  250,    0,    0,    0,    0,    0,    0, 
            0,  250,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  252,    0,    0,    0,    0,    0,    0, 
          250,  250,    0,  252,    0,  250,  250,    0,    0,  218, 
            0,    0,    0,    0,  250,    0,    0,  250,    0,  218, 
          250,    0,  250,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  252,  250,   25, 
           25,   25,    0,    0,    0,   25,   25,    0,   25,    0, 
          250,  252,  252,  264,    0,    0,  252,    0,  257,  257, 
          257,    0,  250,  257,  257,  257,    0,  257,  218,    0, 
           25,   25,   25,   25,   25,    0,    0,  257,  257,    0, 
            0,    0,    0,    0,    0,    0,  257,  257,    0,  257, 
          257,  257,  257,  257,  258,    0,    0,    0,    0,    0, 
            0,  257,    0,    0,  258,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   25,    0, 
          257,  257,    0,    0,    0,  257,  257,    0,    0,    0, 
            0,    0,    0,    0,  257,    0,    0,  257,  258,   25, 
          257,    0,  257,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  258,  258,    0,    0,    0,  258,  257,    0, 
            0,    0,    0,   25,    0,    0,    0,  251,  251,  251, 
          257,    0,  251,  251,  251,    0,  251,    0,    0,  230, 
            0,    0,  257,    0,    0,    0,  251,  251,    0,  230, 
            0,    0,    0,    0,    0,  251,  251,    0,  251,  251, 
          251,  251,  251,    0,    0,    0,    0,    0,    0,    0, 
          251,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  230,    0,    0,    0,    0,    0,  251, 
          251,    0,    0,    0,  251,  251,    0,  230,  230,    0, 
            0,    0,  230,  251,    0,    0,  251,    0,    0,  251, 
            0,  251,    0,    0,    0,  252,  252,  252,    0,    0, 
          252,  252,  252,    0,  252,    0,  259,  251,    0,    0, 
            0,  218,  218,  218,  252,  252,  259,  218,  218,  251, 
          218,    0,    0,  252,  252,    0,  252,  252,  252,  252, 
          252,  251,    0,    0,    0,    0,    0,    0,  252,  218, 
          218,    0,  218,  218,  218,  218,    0,    0,    0,    0, 
          259,    0,    0,    0,    0,    0,    0,  252,  252,    0, 
            0,    0,  252,  252,  259,  259,    0,    0,    0,    0, 
            0,  252,    0,    0,  252,    0,    0,  252,    0,  252, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          218,    0,    0,    0,  228,  252,  258,  258,  258,    0, 
            0,  258,  258,  258,  228,  258,    0,  252,    0,    0, 
            0,  218,    0,    0,    0,  258,  258,    0,    0,  252, 
            0,    0,    0,    0,  258,  258,    0,  258,  258,  258, 
          258,  258,    0,    0,    0,  218,    0,    0,  228,  258, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  228,  228,    0,    0,    0,    0,    0,  258, 
            0,    0,    0,  258,  258,    0,    0,    0,    0,    0, 
            0,    0,  258,    0,    0,  258,    0,    0,  258,  227, 
          258,  230,  230,  230,    0,    0,  230,  230,  230,  227, 
          230,    0,    0,    0,    0,    0,  258,    0,    0,    0, 
          230,  230,    0,    0,    0,    0,    0,    0,  258,  230, 
          230,    0,  230,  230,  230,  230,  230,    0,    0,    0, 
          258,    0,    0,  227,  230,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  227,  227,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  230,    0,    0, 
          230,    0,    0,  230,    0,  230,  223,    0,  259,  259, 
          259,    0,    0,  259,  259,  259,  223,  259,    0,    0, 
            0,  230,    0,    0,    0,    0,    0,  259,  259,    0, 
            0,    0,    0,  230,    0,    0,  259,  259,    0,  259, 
          259,  259,  259,  259,    0,  230,    0,    0,    0,    0, 
          223,  259,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  223,  223,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  259,    0,    0,  259,    0,    0, 
          259,    0,  259,    0,  224,    0,  228,  228,  228,    0, 
            0,  228,  228,  228,  224,  228,    0,    0,  259,    0, 
            0,    0,    0,    0,    0,  228,  228,    0,    0,    0, 
          259,    0,    0,    0,  228,  228,    0,  228,  228,  228, 
          228,  228,  259,    0,    0,    0,    0,    0,  224,  228, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  224,  224,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  228,    0,    0,  228,    0,    0,  228,  225, 
          228,  227,  227,  227,    0,    0,  227,  227,  227,  225, 
          227,    0,    0,    0,    0,    0,  228,    0,    0,    0, 
          227,  227,    0,    0,    0,    0,    0,    0,  228,  227, 
          227,    0,  227,  227,  227,  227,  227,    0,    0,    0, 
          228,    0,    0,  225,  227,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  225,  225,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  227,    0,    0, 
          227,    0,    0,  227,    0,  227,  226,    0,  223,  223, 
          223,    0,    0,  223,  223,  223,  226,  223,    0,    0, 
            0,  227,    0,    0,    0,    0,    0,  223,  223,    0, 
            0,    0,    0,  227,    0,    0,  223,  223,    0,  223, 
          223,  223,  223,  223,    0,  227,    0,    0,    0,    0, 
          226,  223,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  226,  226,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  223,    0,    0,  223,    0,    0, 
          223,    0,  223,    0,  219,    0,  224,  224,  224,    0, 
            0,  224,  224,  224,  219,  224,    0,    0,  223,    0, 
            0,    0,    0,    0,    0,  224,  224,    0,    0,    0, 
          223,    0,    0,    0,  224,  224,    0,  224,  224,  224, 
          224,  224,  223,    0,    0,    0,    0,    0,  219,  224, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  219,  219,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  224,    0,    0,  224,    0,    0,  224,  221, 
          224,  225,  225,  225,    0,    0,  225,  225,  225,  221, 
          225,    0,    0,    0,    0,    0,  224,    0,    0,    0, 
          225,  225,    0,    0,    0,    0,    0,    0,  224,  225, 
          225,    0,  225,  225,  225,  225,  225,    0,    0,    0, 
          224,    0,    0,  221,  225,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  221,  221,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  225,    0,    0, 
          225,    0,    0,  225,    0,  225,  222,    0,  226,  226, 
          226,    0,    0,  226,  226,  226,  222,  226,    0,    0, 
            0,  225,    0,    0,    0,    0,    0,  226,  226,    0, 
            0,    0,    0,  225,    0,    0,  226,  226,    0,  226, 
          226,  226,  226,  226,    0,  225,    0,    0,    0,    0, 
          222,  226,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  222,  222,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  226,    0,    0,  226,    0,    0, 
          226,    0,  226,    0,  262,    0,  219,  219,  219,    0, 
            0,  219,  219,  219,  262,  219,    0,    0,  226,    0, 
            0,    0,    0,    0,    0,  219,  219,    0,    0,    0, 
          226,    0,    0,    0,  219,  219,    0,  219,  219,  219, 
          219,  219,  226,    0,    0,    0,    0,    0,  262,  219, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  262,  262,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  219,    0,    0,  219,    0,    0,  219,  220, 
          219,  221,  221,  221,    0,    0,  221,  221,  221,  220, 
          221,    0,    0,    0,    0,    0,  219,    0,    0,    0, 
          221,  221,    0,    0,    0,    0,    0,    0,  219,  221, 
          221,    0,  221,  221,  221,  221,  221,    0,    0,    0, 
          219,    0,    0,  220,  221,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  220,  220,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  221,    0,    0, 
          221,    0,    0,  221,    0,  221,  218,    0,  222,  222, 
          222,    0,    0,  222,  222,  222,  218,  222,    0,    0, 
            0,  221,    0,    0,    0,    0,    0,  222,  222,    0, 
            0,    0,    0,  221,    0,    0,  222,  222,    0,  222, 
          222,  222,  222,  222,    0,  221,    0,    0,    0,    0, 
          218,  222,    0,    0,    0,    0,    0,    0,    0,    0, 
          295,    0,    0,    0,  218,  218,    0,    0,    0,    0, 
          295,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  222,    0,    0,  222,    0,    0, 
          222,    0,  222,    0,    0,    0,  262,  262,  262,    0, 
            0,  262,  262,  262,  288,  262,    0,    0,  222,    0, 
            0,    0,    0,    0,    0,  262,  262,    0,    0,  295, 
          222,    0,    0,    0,  262,  262,    0,  262,  262,  262, 
          262,  262,  222,    0,    0,    0,    0,    0,    0,  262, 
          293,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          293,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  262,    0,    0,  262,    0,    0,  262,    0, 
          262,  220,  220,  220,  289,    0,  220,  220,  220,    0, 
          220,    0,  294,    0,    0,    0,  262,    0,    0,  293, 
          220,  220,  294,    0,    0,    0,    0,    0,  262,  220, 
          220,    0,  220,  220,  220,  220,    0,    0,    0,    0, 
          262,    0,    0,    0,  220,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  290,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  411, 
            0,  294,    0,    0,    0,    0,    0,  220,    0,    0, 
          220,    0,    0,  220,    0,  220,    0,    0,  218,  218, 
          218,    0,    0,  218,  218,  218,    0,  218,    0,    0, 
            0,  220,    0,    0,    0,    0,    0,  218,  218,    0, 
            0,    0,    0,  220,    0,    0,  218,  218,    0,  218, 
          218,  218,  218,    0,    0,  220,    0,    0,    0,  129, 
            0,  218,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  295,  295,  295,    0,    0,  295,  295,  295, 
            0,  295,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  218,    0,    0,  218,    0,    0, 
          218,    0,  218,  295,  295,  295,  295,  295,  129,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  218,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          218,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          511,    0,  218,    0,    0,    0,    0,    0,  295,    0, 
            0,  295,  293,  293,  293,    0,    0,  293,  293,  293, 
            0,  293,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  295,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  293,  293,  293,  293,  293,    0,    0, 
            0,  130,    0,    0,    0,    0,  295,    0,    0,    0, 
            0,    0,    0,    0,  294,  294,  294,    0,    0,  294, 
          294,  294,    0,  294,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  293,    0, 
            0,  293,    0,  793,    0,  294,  294,  294,  294,  294, 
          130,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  293,  386,  387,  388,  389,  390,  391,  392, 
          393,  394,  395,  396,    0,  397,  398,    0,    0,  399, 
          400,    0,  514,    0,    0,    0,  293,    0,    0,    0, 
          294,    0,    0,  294,  401,    0,  402,    0,  403,  404, 
          405,  406,  407,  408,  409,    0,  410,    0,    0,    0, 
            0,    0,    0,    0,  294,  129,  129,  129,  129,  129, 
          129,  129,  129,  129,  129,  129,    0,    0,  129,  129, 
          129,  129,  129,  129,  129,  129,  129,  129,  294,  614, 
            0,    0,  129,  129,  129,  129,  129,  129,  129,    0, 
            0,  129,    0,    0,    0,    0,    0,  129,  129,    0, 
          129,  129,  129,  129,    0,  129,  129,  129,  129,  129, 
          129,    0,  129,  129,  129,  129,    0,    0,    0,  129, 
            0,    0,    0,    0,    0,    0,    0,  511,    0,    0, 
            0,    0,    0,    0,  511,  129,    0,    0,  129,  614, 
            0,  129,  129,    0,  129,    0,  129,    0,    0,    0, 
          129,  621,    0,    0,    0,  129,    0,    0,  129,    0, 
          614,    0,    0,  129,  129,  129,  129,  129,  129,    0, 
            0,    0,  129,    0,  129,  129,    0,  129,  129,  129, 
          129,    0,  129,  129,    0,    0,    0,  130,  130,  130, 
          130,  130,  130,  130,  130,  130,  130,  130,    0,  130, 
          130,  130,    0,  130,  130,  130,  130,  130,  130,  130, 
            0,  615,    0,    0,  130,  130,  130,  130,  130,  130, 
          130,    0,    0,  130,    0,    0,    0,    0,    0,  130, 
          130,    0,  130,  130,  130,  130,    0,  130,  130,  130, 
          130,  130,  130,    0,  130,  130,  130,  130,  130,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  514, 
            0,    0,    0,    0,    0,    0,  514,  130,    0,    0, 
          130,  615,    0,  130,  130,    0,  130,    0,  130,    0, 
          315,    0,  130,    0,    0,    0,    0,  130,    0,    0, 
          130,    0,  615,    0,    0,  130,  130,  130,  130,  130, 
          130,    0,    0,    0,  130,    0,  130,  130,    0,  130, 
          130,  130,  130,    0,  130,  130,  129,  129,  129,  129, 
          129,  129,  129,  129,  129,  129,  129,    0,  130,  129, 
          129,    0,  129,  129,  129,  129,  129,  129,  129,    0, 
          621,    0,    0,  129,  129,  129,  129,  129,  129,  129, 
            0,    0,  129,    0,    0,    0,    0,    0,  129,  129, 
            0,  129,  129,  129,  129,    0,  129,  129,  129,  129, 
          129,  129,    0,  129,  129,  129,  129,  130,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  621,    0, 
            0,    0,    0,    0,    0,  621,  129,    0,    0,  129, 
          617,    0,  129,  129,    0,  129,    0,  129,    0,  316, 
            0,  129,    0,    0,    0,    0,  129,    0,    0,  129, 
            0,  621,    0,    0,  129,  129,  129,  129,  129,  129, 
            0,    0,    0,  129,    0,  129,  129,    0,  129,  129, 
          129,  129,    0,  129,  129,  130,  130,  130,  130,  130, 
          130,  130,  130,  130,  130,  130,    0,  360,  130,  130, 
            0,  130,  130,  130,  130,  130,  130,  130,    0,    0, 
            0,    0,  130,  130,  130,  130,  130,  130,  130,    0, 
            0,  130,    0,    0,    0,    0,    0,  130,  130,    0, 
          130,  130,  130,  130,    0,  130,  130,  130,  130,  130, 
          130,    0,  130,  130,  130,  130,  360,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  315,    0,    0, 
            0,    0,    0,    0,  315,  130,    0,    0,  130,  618, 
            0,  130,  130,    0,  130,    0,  130,    0,    0,    0, 
          130,    0,    0,    0,    0,  130,    0,    0,  130,    0, 
            0,    0,    0,  130,  130,  130,  130,  130,  130,    0, 
            0,    0,  130,    0,  130,  130,    0,  130,  130,  130, 
          130,    0,  130,  130,  130,  130,  130,  130,  130,  130, 
          130,  130,  130,  130,  130,    0,  307,  130,  130,    0, 
          130,  130,  130,  130,  130,  130,  130,    0,    0,    0, 
            0,  130,  130,  130,  130,  130,  130,  130,    0,    0, 
          130,    0,    0,    0,    0,    0,  130,  130,    0,  130, 
          130,  130,  130,    0,  130,  130,  130,  130,  130,  130, 
            0,  130,  130,  130,  130,  307,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  316,    0,    0,    0, 
            0,    0,    0,  316,  130,    0,    0,  130,    0,    0, 
          130,  130,    0,  130,    0,  130,    0,    0,    0,  130, 
            0,    0,    0,    0,  130,    0,    0,  130,    0,    0, 
            0,    0,  130,  130,  130,  130,  130,  130,    0,    0, 
            0,  130,    0,  130,  130,    0,  130,  130,  130,  130, 
            0,  130,  130,  360,  360,  360,  360,  360,  360,  360, 
          360,  360,  360,  360,    0,  360,  360,  360,  360,  360, 
          360,  360,  360,  360,  360,  360,  639,    0,    0,    0, 
          360,  360,  360,  360,  360,  360,  360,    0,    0,  360, 
            0,    0,    0,    0,    0,  360,  360,    0,  360,  360, 
          360,  360,    0,  360,  360,  360,  360,  360,  360,    0, 
          360,  360,  360,  360,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  639,    0,    0,    0,    0, 
            0,    0,    0,  360,    0,    0,  360,    0,    0,  360, 
          360,    0,  360,    0,  360,    0,    0,    0,  360,    0, 
            0,    0,    0,    0,    0,    0,  360,    0,    0,    0, 
            0,  360,  360,  360,  360,  360,  360,    0,    0,    0, 
          360,    0,  360,  360,    0,  360,  360,  360,  360,    0, 
          360,  360,  307,  307,  307,  307,  307,  307,  307,  307, 
          307,  307,  307,    0,    0,  307,  307,    0,  307,  307, 
          307,  307,  307,  307,  307,  639,    0,    0,    0,  307, 
          307,  307,  307,  307,  307,  307,    0,    0,  307,    0, 
            0,    0,    0,    0,  307,  307,    0,  307,  307,  307, 
          307,    0,  307,  307,  307,  307,  307,  307,    0,  307, 
          307,  307,  307,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  639,    0,    0,    0,    0,    0, 
            0,    0,  307,    0,    0,  307,    0,    0,  307,  307, 
            0,  307,    0,  307,    0,    0,    0,  307,    0,    0, 
            0,    0,    0,    0,    0,  307,    0,   18,    0,    0, 
          307,  307,  307,  307,  307,  307,    0,    0,    0,  307, 
            0,  307,  307,    0,  307,  307,  307,  307,    0,  307, 
          307,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  639,  639,  639,  639,  639,  639,    0,    0, 
          639,  639,  639,    0,  256,    0,  639,    0,  639,  639, 
          639,  639,  639,  639,  639,    0,    0,    0,    0,  639, 
          639,  639,  639,  639,  639,  639,    0,    0,  639,    0, 
            0,    0,    0,    0,  639,  639,    0,  639,  639,  639, 
          639,    0,  639,  639,  639,  639,  639,  639,    0,  639, 
          639,  639,  639,  255,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  639,    0,    0,  639,    0,    0,  639,  639, 
            0,  639,    0,  639,    0,    0,    0,  639,    0,    0, 
            0,    0,    0,    0,    0,  639,    0,    0,    0,    0, 
          639,  639,  639,  639,  639,  639,    0,    0,    0,  639, 
            0,  639,  639,    0,  639,  639,  639,  639,    0,  639, 
          639,  639,  639,  639,  639,  639,  639,    0,    0,    0, 
          639,  639,  309,    0,    0,  639,    0,  639,  639,  639, 
          639,  639,  639,  639,    0,    0,    0,    0,  639,  639, 
          639,  639,  639,  639,  639,    0,    0,  639,    0,    0, 
            0,    0,    0,  639,  639,    0,  639,  639,  639,  639, 
            0,  639,  639,  639,  639,  639,  639,    0,  639,  639, 
          639,  639,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  639,    0,    0,  639,    0,    0,  639,  639,    0, 
          639,    0,  639,    0,    0,    0,  639,    0,    0,    0, 
            0,    0,    0,    0,  639,    0,    0,  639,    0,  639, 
          639,  639,  639,  639,  639,    0,    0,    0,  639,    0, 
          639,  639,    0,  639,  639,  639,  639,    0,  639,  639, 
            0,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,  304,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
          235,  236,  237,  238,    0,    0,   26,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  239,  240,  241,    0, 
          242,   35,  243,  244,  245,  246,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          247,    0,    0,  130,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,   51,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,  311, 
          311,  311,    0,  311,    0,    0,    0,  311,  311,    0, 
            0,    0,  311,    0,  311,  311,  311,  311,  311,  311, 
          311,    0,    0,    0,    0,  311,  311,  311,  311,  311, 
          311,  311,    0,    0,  311,    0,    0,    0,    0,    0, 
            0,  311,    0,  349,  311,  311,  311,    0,  311,  311, 
          311,  311,  311,  311,    0,  311,  311,  311,  311,    0, 
            0,    0,    0,  411,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  311,    0, 
            0,  311,    0,  309,  311,  311,    0,  311,    0,    0, 
            0,    0,    0,  311,    0,    0,    0,    0,    0,    0, 
            0,  311,    0,    0,    0,    0,  311,  311,  311,  311, 
          311,  311,    0,    0,    0,  311,    0,  311,  311,    0, 
          311,  311,  311,  311,    0,  311,  311,    0,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,  235,  236,  237, 
          238,    0,    0,   26,    0,    0,    0,    0,    0,    0, 
           28,  653,    0,  239,  240,  241,    0,  242,   35,  243, 
          244,  245,  246,    0,   40,   41,   42,   43,    0,    0, 
            0,  411,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  247,    0,    0, 
          130,    0,    0,   46,   47,    0,   48,    0,    0,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
           51,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,   65,   66,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  108,  109,   17,   18,    0,    0, 
            0,    0,  110,  111,  112,  336,  337,  338, 
      };
   }

   private static final short[] yyTable4() {
      return new short[] {

          339,    0,    0,  117,    0,    0,    0,    0,    0,  799, 
          118,    0,    0,  340,  341,  342,    0,  343,   35,  344, 
          345,  346,  347,    0,   40,    0,  467,  127,    0,  386, 
          387,  388,  389,  390,  391,  392,  393,  394,  395,  396, 
            0,  397,  398,    0,    0,  399,  400,  348,    0,    0, 
          130,    0,    0,   46,   47,    0,   48,    0,    0,    0, 
          401,    0,  402,    0,  403,  404,  405,  406,  407,  408, 
          409,    0,  410,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,   65,   66,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  108,  109,   17,   18,    0,    0, 
            0,    0,  110,  111,  112,  336,  337,  338,  339,    0, 
            0,  117,    0,    0,    0,    0,    0,    0,  118,    0, 
            0,  340,  341,  342,    0,  343,   35,  344,  345,  346, 
          347,    0,   40,    0,  467,  127,    0,  386,  387,  388, 
          389,  390,  391,  392,  393,  394,  395,  396,    0,  397, 
          398,    0,    0,  399,  400,  348,    0,    0,  130,    0, 
            0,   46,   47,    0,   48,    0,    0,    0,  401,    0, 
          402,    0,  403,  404,  405,  406,  407,  408,  409,    0, 
          410,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,   65,   66,    4,    5,    6,    7,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
           19,   20,   21,   22,   23,   24,   25,    0,    0,   26, 
            0,    0,    0,    0,    0,   27,   28,   29,   30,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   44,    0,    0,   45,    0,    0,   46, 
           47,    0,   48,    0,   49,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,   51,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
           65,   66,    4,    5,    6,    7,  317,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,   19,   20, 
           21,   22,   23,   24,   25,    0,    0,   26,    0,    0, 
            0,    0,    0,   27,   28,    0,   30,   31,   32,   33, 
            0,   34,   35,   36,   37,   38,   39,    0,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   44,    0,    0,   45,    0,    0,   46,   47,    0, 
           48,    0,   49,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,   51,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
          138,  139,  140,  141,  142,  143,  144,  145,  146,  147, 
          148,  149,  150,  151,  152,  153,  154,  155,  156,  157, 
          158,  159,  160,  161,    0,    0,  162,  163,  164,  165, 
          166,  167,  168,  169,  170,  171,    0,    0,    0,    0, 
          172,  173,  174,  175,  176,  177,  178,  179,    0,  180, 
          181,  123,  124,  182,  126,    0,    0,  183,  184,    0, 
          185,  186,  187,  188,  189,  190,  191,    0,    0,  192, 
          193,    0,    0,    0,  194,  195,  196,  197,    0,    0, 
            0,    0,    0,  198,    0,    0,    0,    0,    0,    0, 
          199,  200,    0,  201,  202,  203,  204,  205,  206,  207, 
          208,  209,  210,  211,    0,    0,  212,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  213,  138, 
          139,  140,  141,  142,  143,  144,  145,  146,  147,  148, 
          149,  150,  151,  152,  153,  154,  155,  156,  157,  158, 
          159,  160,  161,    0,    0,  162,  163,  164,  219,  220, 
          221,  222,  169,  170,  171,    0,    0,    0,    0,  172, 
          173,  174,  175,  176,  223,  224,  225,    0,  226,  181, 
          356,  357,  227,  358,    0,    0,  183,  184,    0,  185, 
          186,  187,  188,  189,  190,  191,    0,    0,  192,  193, 
            0,    0,    0,  194,  195,  196,  197,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  199, 
          200,    0,  201,  202,  203,  204,  205,  206,  207,  208, 
          209,  210,  211,    0,    0,  212,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  213,  138,  139, 
          140,  141,  142,  143,  144,  145,  146,  147,  148,  149, 
          150,  151,  152,  153,  154,  155,  156,  157,  158,  159, 
          160,  161,    0,    0,  162,  163,  164,  219,  220,  221, 
          222,  169,  170,  171,    0,    0,    0,    0,  172,  173, 
          174,  175,  176,  223,  224,  225,    0,  226,  181,  306, 
            0,  227,    0,    0,    0,  183,  184,    0,  185,  186, 
          187,  188,  189,  190,  191,    0,    0,  192,  193,    0, 
            0,    0,  194,  195,  196,  197,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  199,  200, 
            0,  201,  202,  203,  204,  205,  206,  207,  208,  209, 
          210,  211,    0,    0,  212,   52,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  213,  138,  139,  140, 
          141,  142,  143,  144,  145,  146,  147,  148,  149,  150, 
          151,  152,  153,  154,  155,  156,  157,  158,  159,  160, 
          161,    0,    0,  162,  163,  164,  219,  220,  221,  222, 
          169,  170,  171,    0,    0,    0,    0,  172,  173,  174, 
          175,  176,  223,  224,  225,    0,  226,  181,    0,    0, 
          227,    0,    0,    0,  183,  184,    0,  185,  186,  187, 
          188,  189,  190,  191,    0,    0,  192,  193,    0,    0, 
            0,  194,  195,  196,  197,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  199,  200,    0, 
          201,  202,  203,  204,  205,  206,  207,  208,  209,  210, 
          211,    0,    0,  212,   52,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  213,  138,  139,  140,  141, 
          142,  143,  144,  145,  146,  147,  148,  149,  150,  151, 
          152,  153,  154,  155,  156,  157,  158,  159,  160,  161, 
            0,    0,  162,  163,  164,  219,  220,  221,  222,  169, 
          170,  171,    0,    0,    0,    0,  172,  173,  174,  175, 
          176,  223,  224,  225,    0,  226,  181,    0,    0,  227, 
            0,    0,    0,  183,  184,    0,  185,  186,  187,  188, 
          189,  190,  191,    0,    0,  192,  193,    0,    0,    0, 
          194,  195,  196,  197,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  199,  200,    0,  201, 
          202,  203,  204,  205,  206,  207,  208,  209,  210,  211, 
            0,    0,  212,    0,    0,    0,    0,    0,    0,    3, 
            4,    5,    6,    7,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,  213,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,   19,   20,   21,   22, 
           23,   24,   25,    0,    0,   26,    0,    0,    0,    0, 
            0,   27,   28,   29,   30,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   44, 
            0,    0,   45,    0,    0,   46,   47,    0,   48,    0, 
           49,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,   51,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,   65,   66,  316,    4, 
            5,    6,    7,  317,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,    0,    0,   19,   20,   21,   22,   23, 
           24,   25,    0,    0,   26,    0,    0,    0,    0,    0, 
           27,   28,    0,   30,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   44,    0, 
            0,  318,    0,    0,   46,   47,    0,   48,    0,   49, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,   51,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,   65,   66,  316,    4,    5, 
            6,    7,  317,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,   22,   23,   24, 
           25,    0,    0,   26,    0,    0,    0,    0,    0,   27, 
           28,    0,   30,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   44,    0,    0, 
           45,    0,    0,   46,   47,    0,   48,    0,   49,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
           51,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,   65,   66,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   15,   16,   17,   18,    0,    0, 
            0,    0,   19,   20,   21,  235,  236,  237,  238,    0, 
            0,  117,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,  239,  240,  241,    0,  242,   35,  243,  244,  245, 
          246,  281,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  247,    0,    0,  130,    0, 
            0,   46,   47,    0,   48,    0,  282,    0,  283,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,  284,    0, 
            0,    0,    0,   52,  285,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,   65,   66,  286,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  108,  109,   17,   18,    0,    0,    0, 
            0,  110,  111,  112,  235,  236,  237,  238,    0,    0, 
          117,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
          239,  240,  241,    0,  242,   35,  243,  244,  245,  246, 
          281,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  247,    0,    0,  130,    0,    0, 
           46,   47,    0,   48,    0,  709,    0,  283,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  284,    0,    0, 
            0,    0,   52,  285,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,   65,   66,  286,  282,  282,  282,    0,  282,    0, 
            0,    0,  282,  282,    0,    0,    0,  282,    0,  282, 
          282,  282,  282,  282,  282,  282,    0,    0,    0,    0, 
          282,  282,  282,  282,  282,  282,  282,    0,    0,  282, 
            0,    0,    0,    0,    0,    0,  282,    0,    0,  282, 
          282,  282,    0,  282,  282,  282,  282,  282,  282,  282, 
          282,  282,  282,  282,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  282,    0,    0,  282,    0,    0,  282, 
          282,    0,  282,    0,  282,    0,  282,    0,  282,    0, 
            0,    0,    0,    0,    0,    0,  282,    0,    0,    0, 
            0,  282,  282,  282,  282,  282,  282,    0,    0,    0, 
          282,    0,  282,  282,    0,  282,  282,  282,  282,    0, 
          282,  282,  282,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  108,  109,   17,   18,    0,    0,    0,    0,  110, 
          111,  112,  235,  236,  237,  238,    0,    0,  117,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,  239,  240, 
          241,    0,  242,   35,  243,  244,  245,  246,  281,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  247,    0,    0,  130,    0,    0,   46,   47, 
            0,   48,    0,  282,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,  284,    0,    0,    0,    0, 
           52,  285,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,   65, 
           66,  286,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          108,  109,   17,   18,    0,    0,    0,    0,  110,  111, 
          112,  235,  236,  237,  238,    0,    0,  117,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,  239,  240,  241, 
            0,  242,   35,  243,  244,  245,  246,  281,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  247,    0,    0,  130,    0,    0,   46,   47,    0, 
           48,    0,    0,    0,  283,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,  284,    0,    0,    0,    0,   52, 
          285,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
          286,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  108, 
          109,   17,   18,    0,    0,    0,    0,  110,  111,  112, 
          235,  236,  237,  238,    0,    0,  117,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  239,  240,  241,    0, 
          242,   35,  243,  244,  245,  246,  281,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          247,    0,    0,  130,    0,    0,   46,   47,    0,   48, 
            0,  709,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  284,    0,    0,    0,    0,   52,  285, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,  286, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  108,  109, 
           17,   18,    0,    0,    0,    0,  110,  111,  112,  235, 
          236,  237,  238,    0,    0,  117,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  239,  240,  241,    0,  242, 
           35,  243,  244,  245,  246,  281,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  247, 
            0,    0,  130,    0,    0,   46,   47,    0,   48,    0, 
            0,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,  284,    0,    0,    0,    0,   52,  285,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,   65,   66,  286,    4, 
            5,    6,    7,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,    0,    0,   19,   20,   21,   22,   23, 
           24,   25,    0,    0,   26,    0,    0,    0,    0,    0, 
           27,   28,   29,   30,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   44,    0, 
            0,   45,    0,    0,   46,   47,    0,   48,    0,   49, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,   51,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,   65,   66,    4,    5,    6, 
            7,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
            0,    0,    0,   19,   20,   21,   22,   23,   24,   25, 
            0,    0,   26,    0,    0,    0,    0,    0,   27,   28, 
            0,   30,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   44,    0,    0,   45, 
            0,    0,   46,   47,    0,   48,    0,   49,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,   51, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,   65,   66,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  108,  109,   17,   18,    0,    0,    0, 
            0,  110,  111,  112,  235,  236,  237,  238,    0,    0, 
          117,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
          239,  240,  241,    0,  242,   35,  243,  244,  245,  246, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  247,    0,    0,  130,  502,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  284,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,   65,   66,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   15,   16,   17,   18,    0,    0,    0,    0,   19, 
           20,   21,  235,  236,  237,  238,    0,    0,  117,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,  239,  240, 
          241,    0,  242,   35,  243,  244,  245,  246,    0,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  247,    0,    0,  130,    0,    0,   46,   47, 
            0,   48,    0,  644,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,  284,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,   65, 
           66,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  108, 
          109,   17,   18,    0,    0,    0,    0,  110,  111,  112, 
          235,  236,  237,  238,    0,    0,  117,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  239,  240,  241,    0, 
          242,   35,  243,  244,  245,  246,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          247,    0,    0,  130,    0,    0,   46,   47,    0,   48, 
            0,  282,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  284,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  108,  109,   17, 
           18,    0,    0,    0,    0,  110,  111,  112,  235,  236, 
          237,  238,    0,    0,  117,    0,    0,    0,    0,    0, 
            0,   28,    0,    0,  239,  240,  241,    0,  242,   35, 
          243,  244,  245,  246,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  247,    0, 
            0,  130,    0,    0,   46,   47,    0,   48,    0,  644, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,  284,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,   65,   66,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  108,  109,   17,   18,    0, 
            0,    0,    0,  110,  111,  112,  235,  236,  237,  238, 
            0,    0,  117,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,  239,  240,  241,    0,  242,   35,  243,  244, 
          245,  246,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  247,    0,    0,  130, 
            0,    0,   46,   47,    0,   48,    0,  906,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,  284, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,   65,   66,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  108,  109,   17,   18,    0,    0,    0, 
            0,  110,  111,  112,  235,  236,  237,  238,    0,    0, 
          117,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
          239,  240,  241,    0,  242,   35,  243,  244,  245,  246, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  247,    0,    0,  130,    0,    0, 
           46,   47,    0,   48,    0,  709,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  284,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,   65,   66,  628,  628,  628,    0,  628,    0,    0, 
            0,  628,  628,    0,    0,    0,  628,    0,  628,  628, 
          628,  628,  628,  628,  628,    0,    0,    0,    0,  628, 
          628,  628,  628,  628,  628,  628,    0,    0,  628,    0, 
            0,    0,    0,    0,    0,  628,    0,    0,  628,  628, 
          628,    0,  628,  628,  628,  628,  628,  628,    0,  628, 
          628,  628,  628,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  628,    0,    0,  628,  628,    0,  628,  628, 
            0,  628,    0,    0,    0,    0,    0,  628,    0,    0, 
            0,    0,    0,    0,    0,  628,    0,    0,    0,    0, 
          628,  628,  628,  628,  628,  628,    0,    0,    0,  628, 
            0,  628,  628,    0,  628,  628,  628,  628,    0,  628, 
          628,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
          235,  236,  237,  238,    0,    0,   26,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  239,  240,  241,    0, 
          242,   35,  243,  244,  245,  246,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          247,    0,    0,  130,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,   51,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  108,  109,   17, 
           18,    0,    0,    0,    0,  110,  111,  112,  235,  236, 
          237,  238,    0,    0,  117,    0,    0,    0,    0,    0, 
            0,   28,    0,    0,  239,  240,  241,    0,  242,   35, 
          243,  244,  245,  246,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  247,    0, 
            0,  130,    0,    0,   46,   47,    0,   48,    0,    0, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,  284,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,   65,   66,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
            0,    0,    0,   19,   20,   21,  235,  236,  237,  238, 
            0,    0,  117,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,  239,  240,  241,    0,  242,   35,  243,  244, 
          245,  246,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  247,    0,    0,  130, 
            0,    0,   46,   47,    0,   48,    0,    0,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,  284, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,   65,   66,  628,  628,  628,    0,  628, 
            0,    0,    0,  628,  628,    0,    0,    0,  628,    0, 
          628,  628,  628,  628,  628,  628,  628,    0,    0,    0, 
            0,  628,  628,  628,  628,  628,  628,  628,    0,    0, 
          628,    0,    0,    0,    0,    0,    0,  628,    0,    0, 
          628,  628,  628,    0,  628,  628,  628,  628,  628,  628, 
            0,  628,  628,  628,  628,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  628,    0,    0,  628,    0,    0, 
          628,  628,    0,  628,    0,    0,    0,    0,    0,  628, 
            0,    0,    0,    0,    0,    0,    0,  628,    0,    0, 
            0,    0,  628,  628,  628,  628,  628,  628,    0,    0, 
            0,  628,    0,  628,  628,    0,  628,  628,  628,  628, 
            0,  628,  628,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  108,  109,   17,   18,    0,    0,    0,    0,  110, 
          111,  112,  113,  114,  115,  116,    0,    0,  117,    0, 
            0,    0,    0,    0,    0,  118,    0,    0,  119,  120, 
          121,    0,  122,   35,  123,  124,  125,  126,    0,   40, 
            0,    0,  127,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  128, 
            0,    0,  129,    0,    0,  130,    0,    0,   46,   47, 
            0,   48,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,   65, 
           66,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  108, 
          109,   17,   18,    0,    0,    0,    0,  110,  111,  112, 
          263,  264,  265,  266,    0,    0,  117,    0,    0,    0, 
            0,    0,    0,  118,    0,    0,  267,  268,  269,    0, 
          270,   35,  271,  272,  273,  274,    0,   40,    0,    0, 
          127,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          275,    0,    0,   45,    0,    0,   46,   47,    0,   48, 
            0,   49,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  108,  109,   17, 
           18,    0,    0,    0,    0,  110,  111,  112,  336,  337, 
          338,  339,    0,    0,  117,    0,    0,    0,    0,    0, 
            0,  118,    0,    0,  340,  341,  342,    0,  343,   35, 
          344,  345,  346,  347,    0,   40,    0,    0,  127,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  348,    0, 
            0,  423,    0,    0,   46,   47,    0,   48,    0,  424, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,   65,   66,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  108,  109,   17,   18,    0, 
            0,    0,    0,  110,  111,  112,  113,  114,  115,  116, 
            0,    0,  117,    0,    0,    0,    0,    0,    0,  118, 
            0,    0,  119,  120,  121,    0,  122,   35,  123,  124, 
          125,  126,    0,   40,    0,    0,  127,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  129,    0,    0,  130, 
            0,    0,   46,   47,    0,   48,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,   65,   66,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  108,  109,   17,   18,    0,    0,    0, 
            0,  110,  111,  112,  336,  337,  338,  339,    0,    0, 
          117,    0,    0,    0,    0,    0,    0,  118,    0,    0, 
          340,  341,  342,    0,  343,   35,  344,  345,  346,  347, 
            0,   40,    0,    0,  127,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  348,    0,    0,  423,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,   65,   66,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  108,  109,   17,   18,    0,    0,    0,    0,  110, 
          111,  112,  113,  114,  115,  116,    0,    0,  117,    0, 
            0,    0,    0,    0,    0,  118,    0,    0,  119,  120, 
          121,    0,  968,   35,  123,  124,  969,  126,    0,   40, 
            0,    0,  127,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  970,    0,    0,  130,    0,    0,   46,   47, 
            0,   48,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,   65, 
           66,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  108, 
          109,   17,   18,    0,    0,    0,    0,  110,  111,  112, 
          982,  983,  984,  985,    0,    0,  117,    0,    0,    0, 
            0,    0,    0,  118,    0,    0,  986,  987,  988,    0, 
          989,   35,  990,  991,  992,  993,    0,   40,    0,    0, 
          127,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          994,    0,    0,  130,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,  625, 
          626,    0,    0,  627,    0,    0,    0,  183,  184,    0, 
          185,  186,  187,  188,  189,  190,  191,    0,    0,  192, 
          193,    0,    0,    0,  194,  195,  196,  197,    0,    0, 
            0,    0,    0,  300,    0,    0,    0,    0,    0,    0, 
          199,  200,    0,  201,  202,  203,  204,  205,  206,  207, 
          208,  209,  210,  211,  631,  632,  212,    0,  633,    0, 
            0,    0,  183,  184,    0,  185,  186,  187,  188,  189, 
          190,  191,    0,    0,  192,  193,    0,    0,  213,  194, 
          195,  196,  197,    0,    0,    0,    0,    0,  300,    0, 
            0,    0,    0,    0,    0,  199,  200,    0,  201,  202, 
          203,  204,  205,  206,  207,  208,  209,  210,  211,  639, 
          626,  212,    0,  640,    0,    0,    0,  183,  184,    0, 
          185,  186,  187,  188,  189,  190,  191,    0,    0,  192, 
          193,    0,    0,  213,  194,  195,  196,  197,    0,    0, 
            0,    0,    0,  300,    0,    0,    0,    0,    0,    0, 
          199,  200,    0,  201,  202,  203,  204,  205,  206,  207, 
          208,  209,  210,  211,  670,  632,  212,    0,  671,    0, 
            0,    0,  183,  184,    0,  185,  186,  187,  188,  189, 
          190,  191,    0,    0,  192,  193,    0,    0,  213,  194, 
          195,  196,  197,    0,    0,    0,    0,    0,  300,    0, 
            0,    0,    0,    0,    0,  199,  200,    0,  201,  202, 
          203,  204,  205,  206,  207,  208,  209,  210,  211,  687, 
          626,  212,    0,  688,    0,    0,    0,  183,  184,    0, 
          185,  186,  187,  188,  189,  190,  191,    0,    0,  192, 
          193,    0,    0,  213,  194,  195,  196,  197,    0,    0, 
            0,    0,    0,  300,    0,    0,    0,    0,    0,    0, 
          199,  200,    0,  201,  202,  203,  204,  205,  206,  207, 
          208,  209,  210,  211,  689,  632,  212,    0,  690,    0, 
            0,    0,  183,  184,    0,  185,  186,  187,  188,  189, 
          190,  191,    0,    0,  192,  193,    0,    0,  213,  194, 
          195,  196,  197,    0,    0,    0,    0,    0,  300,    0, 
            0,    0,    0,    0,    0,  199,  200,    0,  201,  202, 
          203,  204,  205,  206,  207,  208,  209,  210,  211,  701, 
          626,  212,    0,  702,    0,    0,    0,  183,  184,    0, 
          185,  186,  187,  188,  189,  190,  191,    0,    0,  192, 
          193,    0,    0,  213,  194,  195,  196,  197,    0,    0, 
            0,    0,    0,  300,    0,    0,    0,    0,    0,    0, 
          199,  200,    0,  201,  202,  203,  204,  205,  206,  207, 
          208,  209,  210,  211,  703,  632,  212,    0,  704,    0, 
            0,    0,  183,  184,    0,  185,  186,  187,  188,  189, 
          190,  191,    0,    0,  192,  193,    0,    0,  213,  194, 
          195,  196,  197,    0,    0,    0,    0,    0,  300,    0, 
            0,    0,    0,    0,    0,  199,  200,    0,  201,  202, 
          203,  204,  205,  206,  207,  208,  209,  210,  211,  732, 
          626,  212,    0,  733,    0,    0,    0,  183,  184,    0, 
          185,  186,  187,  188,  189,  190,  191,    0,    0,  192, 
          193,    0,    0,  213,  194,  195,  196,  197,    0,    0, 
            0,    0,    0,  300,    0,    0,    0,    0,    0,    0, 
          199,  200,    0,  201,  202,  203,  204,  205,  206,  207, 
          208,  209,  210,  211,  734,  632,  212,    0,  735,    0, 
            0,    0,  183,  184,    0,  185,  186,  187,  188,  189, 
          190,  191,    0,    0,  192,  193,    0,    0,  213,  194, 
          195,  196,  197,    0,    0,    0,    0,    0,  300,    0, 
            0,    0,    0,    0,    0,  199,  200,    0,  201,  202, 
          203,  204,  205,  206,  207,  208,  209,  210,  211, 1064, 
          632,  212,    0, 1065,    0,    0,    0,  183,  184,    0, 
          185,  186,  187,  188,  189,  190,  191,    0,    0,  192, 
          193,    0,    0,  213,  194,  195,  196,  197,    0,    0, 
            0,    0,    0,  300,    0,    0,    0,    0,    0,    0, 
          199,  200,    0,  201,  202,  203,  204,  205,  206,  207, 
          208,  209,  210,  211, 1068,  626,  212,    0, 1069,    0, 
            0,    0,  183,  184,    0,  185,  186,  187,  188,  189, 
          190,  191,    0,    0,  192,  193,    0,    0,  213,  194, 
          195,  196,  197,    0,    0,    0,    0,    0,  300,    0, 
            0,    0,    0,    0,    0,  199,  200,    0,  201,  202, 
          203,  204,  205,  206,  207,  208,  209,  210,  211, 1070, 
          632,  212,    0, 1071,    0,    0,    0,  183,  184,    0, 
          185,  186,  187,  188,  189,  190,  191,    0,    0,  192, 
          193,    0,    0,  213,  194,  195,  196,  197,    0,    0, 
            0,    0,    0,  300,    0,    0,    0,    0,    0,    0, 
          199,  200,    0,  201,  202,  203,  204,  205,  206,  207, 
          208,  209,  210,  211,    0,    0,  212,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  213, 
      };
   }

   private static final short[] yyCheck1() {
      return new short[] {

           26,    2,   28,   15,   16,   74,  416,   19,   51,   99, 
            2,    3,    4,    5,    2,    3,    6,    9,   10,   11, 
            7,   49,   14,   15,   16,   21,   21,   19,    7,  446, 
          464,    6,    7,  254,   27,  445,  481,  292,  581,  484, 
           27,  422,    3,  484,  674,   10,   47,   48,   27,  459, 
           10,   10,   27,   45,  572,  573,    0,   49,  469,   51, 
          331,  691,   52,  473,  335,    0,   10,   45,   10,   10, 
           10,    4,    5,   59,    0,  705,   10,   52,   10,  129, 
          504,   14,  523,   59,   44,  426,   10,   15,   16,  760, 
           11,   19,  118,   10,   59,   10,   10,  533,   10,   59, 
          414,  415,   10,   44,   10,  419,  736,   99,   10,   11, 
          106,  106,   10,   10,   10,   59,   49,  112,   59,   47, 
           48,   61,  532,  280,  590,   59,  771,   15,   16,  443, 
          104,   19,   44,  943,   10,   59,  128,   10,  130,  853, 
           10,  136,   10,  457,  458,   59,   44,   59,   10,  318, 
           10,   59,  305,   59,   10,  340,  855,  471,  624,   47, 
           43,   59,   59,   59,   10,   10,   99,   10,  340,  344, 
          781,   44,  280,   10,   44,   10,  787,  559,  305,  964, 
          361,   10,  325,  104,   10,   61,   59,  362,   10,   59, 
           44,   59,  506,   10,   10,  372,    0,   59,   32,   59, 
          377,   44,  683,   59,  361,  341,   10,   61,  269,   44, 
          271,  132,  693,   59,   10,  358,  530,  653,   10,   10, 
           10,  374,  358,  104,   59,  939,   10,   10,   44,   91, 
           59,  876,  340,   59,    9,   10,   11, 1047,  493,   61, 
           10,  365,  234,   10,  127,   61,   32,  374,   44,   10, 
           10,  668,   44,  361,  423,   59,   10,   10,  317,  349, 
           32,  678,   10,   59,   10,   10,   10,   59,   59,  261, 
          262,  716,  717, 1058,  310,   59,  717,   44,   61,  950, 
           10,   45,   32,   10,   10,  297,   10,  299,  300,  348, 
           10,   44,   32,  352,  353,  677, 1010,  679,   59,  300, 
           10,  372,  726,  341,   32,  297,  377,  299,  300, 1008, 
          328,  303,  282,  305,  372,   61,  372,  335,  310,  377, 
          358,  377,  256,  306,  316,   44,  318,  310,  316,   10, 
          873,  337, 1046,  337,  800,  327,  257,  880,   61,  279, 
          318,  682,  885,  861,   61,  305,  320,  865,  866,  340, 
          868,   61,  870,  128,   44,  267,  310,  349,   61,  261, 
          262,  271,  798,   44,  337,  341,  130,  281,  264,  297, 
          267,  299,  358,  290,  291,  337,  257,  420,  279,  422, 
           61,  341,  341,  426,  427,  344,  370,  379,  380,  381, 
          382,  383,  384,  385,  444,  383,  424,   10,  358,  320, 
           10,  341,  344,  279,  416,  267,   59,  267,  340,  297, 
           91,  299,   44,  794,  374,  416,  349,  358,  362,  414, 
          310,  386,  356,  834,  416,  279,  341,  362,  420,  344, 
          422,  423,  424,  445,  426,  427,  362,  429,  362,  320, 
          415,  429, 1072,  533,  445,  423,   59,  459,  443,  930, 
          358,   61,  358,  445,  446,  447,  711,  279,  459,  730, 
          358,  473,  457,  455,   10,  341,  328,  459,  429,  444, 
          305,  463,  473,  335,  695,  338,  471,  379,  380,  381, 
          382,  473,   44,  458, 1027,  358,  261,  262,  358,  934, 
          358,  424,  361,  934,  911,  341,  930,  472, 1016, 1017, 
         1018, 1019,  317,  504,  341,  317,  341,  344,  501,  305, 
          502,  506,  504,  305,  501,   61,  504,   91,  439,  341, 
          532,  305,  501,  515,  341,  341,  501,  344,  303,  337, 
          305,  532,  507,  279,  422,  530,  370,  371,  426,  374, 
          532,  533,  341,  377,  305,  341,  310,  468,  469,  341, 
          341,  341,  327,  481,  318,  344,  531,  341,  341,    2, 
            3, 1079,  358,  653,  981,   10,    9,   10,   11,  279, 
           44,  341,   15,   16,  558,  559,   19,  465,  374,  310, 
          341,  341,  374,  838,  370,  371,   10,  341,  589,  590, 
          374,  377,  520,  341,   10,  341,  341,  341,  279,  280, 
          533,   10,   45,  362,  379,  380,  381,  382,   51,  384, 
          385,  341,  638,  374,  341,  341,   61,  341,  290,  291, 
           44,  341,   10,  624,   10,  268,  269,  628,   44,  308, 
         1040,  341,  628,  628,  372,   59,  370,  372,  634,  634, 
          641,  731,   44,   59,  346,  641,  641,  328,  674,  262, 
          263,  264,   61,   91,  335,  268,  269,  372,  271,  423, 
          341,  653,   91,   91,   10,  691,  758,   91,  669,  279, 
           10,   59,  447,   59,  669,  667,  668,  672,  372,  705, 
          361,  682,  683,   91,  685,  128,  678,  130,  681,  340, 
          680,  455,  693,  677,  681,  679,  375,  376,  919,  463, 
          349,  350,  681,   44,  925,  680,  681,  340,  798,  262, 
          736,  267,   15,   16,  706,   61,   19,  264,  341,   59, 
          653,  264,  791,  749, 1038,  726,   44,  502,  341,  308, 
          309,  341,  311,  279,  726,  778,  779,   91,  726,  731, 
           10,  784,  785,   44,  665,  771,  370,  371,  362,  362, 
          776,  794,  361,  377,  328,  370,  371,  372,  382,  743, 
          744,  335,  377,  755,  756,  667,  263,  264,   10,  758, 
           44,  760,  387,  386,  758,   32,  760,   61,  306,   10, 
          306,  773,  771,  775,   44,  777,  778,  779,  716,   59, 
           44,  234,  784,  785,  682,  341,  375,  376,  731,  800, 
           44,   44,  794,  306,  706,   91,  798,   44,   32,   61, 
           15,   16,  337,  814,   19,  337,  817,   59,  261,  262, 
          337,   91,  337,   44,  816,  559,   44,  819,   59,  293, 
          294,  295,  296,  297,  279,   44,   41,   42,  830,  831, 
          832,  337,   47,   48,  264,   50,   51,  269,  337,  337, 
          876,  267,  944,   10,  297,  337,  299,  300,  901,   10, 
          303,  264,  305,  362,  303,  798,    0,  310,  960,  853, 
          279,  855,   44,  316,  337,  318,   10,   91,  264,  267, 
          264,  802,  344,  269,  327,  271,  325,  326,  809,  264, 
          328,  338,  667,  263,  886,  264,  341,  335,  264,  328, 
          328,  337,   59,   44,  328,  362,  335,  335,   59,  901, 
           44,  335,   44,  834,  341,   59,  340,  819,  910,  911, 
          328,   44,  338,  263,  264,   59,  918,  335,  264,  930, 
          922,  706,  341,  279,  358,   44,  379,  380,  381,  382, 
          383,  384,  385,  677,   10,  679,   44,  370,  371,  372, 
          338,  263,  264,  886,  377,  939,  940,  269,  362,   61, 
           44,  950, 1054,   44,  956,  306,  950,  308,  309,  310, 
          311,  960,   44,  416,  328,  964,   44,  420,   44,  422, 
          423,  335,   44,  426,  427,  918,  429, 1013,  264,  981, 
          358,  755,  756,   59,  297,  341,  299,  267,  370,  371, 
          372,   10,  445,  446,  447,  377,  998,  362, 1000,  773, 
          280,  775,  455,  777, 1006, 1007,  459,   58,  264,  264, 
          463,   44,  264,  956, 1008,   91, 1010,  269, 1040,  264, 
          473,  262,  263,  264,  358,   44,  362,  268,  269, 1040, 
          271, 1042,  328, 1038,  819,  310, 1072,  486, 1040,  335, 
           59,  264,  816,  264,  310,  494,  495, 1032,  328,  502, 
           10,  504, 1046,   44, 1039,  335,  830,  831,  832, 1058, 
          340,   44,  515,  512,   44,   44,  281,  282,  283,  284, 
           44,  286,   91,  378,  379,  380,  381,   10,   44,  532, 
           10,  361,  297,   44,  299,  300,   10,  306,   10,  308, 
          309,  310,  311,  308,  264,  262,  263,  264,  386,   59, 
          341,   44,  269,  264,  328,  271,  344,  268,  269,  271, 
           48,  335,   91,  362,   44,  340,   44,  344,  262,  263, 
          264,  362,   44,  267,  268,  269,   59,  271,  341,   59, 
          362,   91,  344,  344,   10,   59,  910,  281,  282,   61, 
          264,   58,  216,   70,  285,  386,  290,  291,  922,  293, 
          294,  295,  296,  297,   54,  372,    5,  515,   91,   44, 
         1042,   91,    6,   91,  641,  917,  758,  771,  762,   91, 
          962,  386,  387,  388,  389,  390,  391,  392,  393,  394, 
          395,  396,  397,  398,  399,  400,  401,  402,  403,  404, 
          405,  406,  407,  408,  409,  410,   14,  341,  960,  790, 
          344,  416,  346,  652,  280,  420,   91,  422,    2,    3, 
         1041,  426,  427,  743,  667,  668,   -1,  312,  362, 1047, 
           14,   -1,  317,   -1,  998,  678, 1000,  676,   -1,   44, 
          445,   -1, 1006, 1007,   -1,   -1,    2,    3,    4,    5, 
           -1,   -1,  386,   -1,  459,  460,  461,  462,   14,   -1, 
          465,   45,  328,  706,  349,  350,   -1,   -1,  473,  335, 
           -1,  280,   -1,   -1,  340,  480,  481,   -1,   -1,  484, 
           -1,   44,  721,  726,   -1,  317,   91,   -1,   -1,   45, 
          729,   -1,  358,   49,  306,  361,  308,  309,  310,  311, 
          385,  333,  334,  508,  509,   -1,   -1,   -1,   -1,  748, 
          279,   -1,  755,  756,   -1,  520,  348,  267,  523,  328, 
          352,  353,  354,  355,   -1,   -1,  335,  532,   91,   -1, 
          773,  340,  775,   -1,  777,  778,  779,   -1,   -1,   -1, 
            0,  784,  785,   99,  267,   -1,  130,   -1,   -1,  358, 
           10,  794,  361,  281,  282,  283,   -1,   -1,  286,  328, 
          280,  279,   -1,   -1,    2,    3,  335,  279,  807,   -1, 
           -1,  340,   -1,  816,  130,   10,  819,  582,  328,  370, 
          371,  372,   -1,   -1,   44,  335,  377,  830,  831,  832, 
          340,   -1,  306,   -1,  308,  309,  310,  311,  312,   59, 
           -1,   -1,   -1,  317,  279,  328,   -1,   45,  328,   -1, 
          328,   -1,  335,  852,  328,  335,  328,  335,  623,   -1, 
          340,  335,   -1,  335,   59,  339,  340,   -1,  340,  341, 
           -1,   -1,   -1,  347,  348,  349,  350,   10,  358,  644, 
          306,  361,  308,  309,  310,  311,  312,   -1,   -1,   -1, 
          234,  317,   44,  328,   -1,   10,   91,   -1,  901,   -1, 
          335,   -1,  370,  371,  372,   -1,   -1,  910,  911,  377, 
            0,  385,   -1,  339,  279,   -1,   -1,  682,  234,  922, 
           10,  347,  348,  349,  350,   -1,   59,   -1,   10,   44, 
           -1,   -1,  130,   -1,  422,   -1,   -1,   -1,  426,   91, 
           -1,   -1,  707,   -1,  709,   -1,   61,    0,  370,  371, 
          372,  716,  717,   -1,   -1,  377,  279,   10,   91,  385, 
           -1,   -1,   44,  328,   -1,   -1,  310,   -1,   -1,   59, 
          335,   -1,  316,   -1,  318,   10,   91,  465,  981,   61, 
           -1,   -1,   10,   -1,  306,  750,  308,  309,  310,  311, 
           -1,   44,  480,  481,  310,  998,  484, 1000,   -1,   -1, 
          316,   -1,  318, 1006, 1007,  328,   59,   -1,   -1,   91, 
           -1,   -1,  335,  778,  779,   -1,   -1,  339,   10,  784, 
          785,   -1,   -1,   -1,   59,  347,   -1,   -1,  793,  794, 
          795,   59,  520,  349,  799,  523,  234, 1040,   -1,  383, 
           -1,   10,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   44,   -1,   10,   -1,   91,  822,  823,  824, 
          825,  281,  282,   10,  829,   -1,   -1,  383,   -1,   61, 
          290,  291,  267,  293,  294,  295,  296,  297,  422,  423, 
          370,  371,  372,   -1,   -1,  429,   -1,  377,   44,   -1, 
           59,  370,  371,  372,  582,   -1,   -1,   44,  377,   91, 
           -1,   10,  446,   10,   -1,   61,    0,  423,  424,   -1, 
           -1,  455,  310,  429,   61,   -1,   10,   -1,  316,  463, 
          318,  341,   91,   -1,  344,   -1,  346,  279,   -1,   -1, 
          446,   -1,   -1,  328,  267,   91,  901,   -1,   -1,  455, 
          335,  906,  362,   -1,   91,   -1,   -1,  463,   -1,   -1, 
           59,   -1,   59,  362,   -1,  364,  644,  366,   -1,   -1, 
          504,   -1,  927,  372,  279,   59,  386,   -1,   -1,  934, 
           -1,  515,  262,  263,  264,   -1,  328,  267,  268,  269, 
           -1,  271,   91,  335,   91,  383,   10,   -1,  504,   -1, 
           -1,  281,  282,   -1,  682,  328,   -1,  279,  280,  515, 
          290,  291,  335,  293,  294,  295,  296,  297,   -1,  262, 
          263,  264,   -1,  328,   -1,  268,  269,  533,  271,  707, 
          335,  709,   -1,   -1,   -1,  423,  341,    0,  716,  717, 
           -1,  429,  267,   -1,   -1,   59,   -1,   10,   -1,   -1, 
          293,  294,  295,  296,  297,  280,  328,   -1,  446,   -1, 
           44,  341,   -1,  335,  344,   -1,  346,  455,  340,  341, 
           -1,   -1,  750,   -1,   -1,  463,   -1,   91, 1033,  478, 
           -1,   44,  362,   -1,   10, 1040,   -1,   -1,  306,  361, 
          308,  309,  310,  311,  312,   58,   59,  279,  341,  317, 
           63,   -1,   44,  328,   -1,   -1,  386,   91,  267,   10, 
          335,   -1,   10,   -1,   -1,  340,  504,  795,   44,  362, 
           -1,  339,   -1,   -1,   -1,   -1,   44,  515,   -1,  347, 
          348,  349,  350,  279,  668,   61,  361,   10,  370,  371, 
          372,   -1,  279,  386,  678,  377,  328,  653,  547,   91, 
           -1,  829,   -1,  335,   -1,   -1,   -1,   -1,   59,  341, 
           -1,   59,  668,   -1,   -1,   91,   -1,  385,  267,  328, 
          267,   44,  678,   91,   -1,   -1,  335,   -1,  262,  263, 
          264,  280,  328,  267,  268,  269,  585,  271,   61,  335, 
           91,  328,  726,   91,   -1,  341,   10,  281,  335,   -1, 
           -1,   -1,   -1,   -1,  341,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,    0,   -1,   -1,   -1,   91,   -1, 
          726,  755,  756,   -1,   10,  731,   -1,   -1,  906,  328, 
           44,  328,   10,  739,   -1,   -1,  335,   -1,  335,  773, 
           -1,  775,   10,  777,  328,   -1,   -1,   61,  317,  755, 
          756,  335,   -1,  267,   -1,   -1,  934,  341,   -1,   -1, 
          794,   -1,  361,   -1,   -1,   -1,   -1,  773,   -1,  775, 
           -1,  777,   -1,   59,   10,   -1,   -1,   91,  362,  348, 
          668,   59,  816,  352,  353,  354,  355,   -1,   -1,   -1, 
          678,   59,  798,   -1,   44,  279,  830,  831,  832,  262, 
          263,  264,  386,   -1,  267,  268,  269,   -1,  271,   -1, 
          816,   44,   44,   91,  328,   -1,   -1,   -1,  281,  282, 
           -1,  335,   -1,   59,  830,  831,  832,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,  279,  726,   -1, 
           -1,   91,  305,   -1,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,   -1,  279,  280,   91,   -1,   -1,   91,   91, 
           -1,  279,   -1,    0,   -1,   -1,  267,  755,  756,  267, 
           -1,   -1,   -1,   10,   -1,  338,  910,  911,  341,  280, 
          886,  344,   -1,  346,  918,  773,  328,  775,  922,  777, 
           -1,   -1,  306,  335,  308,  309,  310,  311,   -1,  362, 
           -1,   -1,  328,   -1,  910,  911,  279,   44,   -1,  335, 
          328,  374,  918,   -1,  340,  341,  922,  335,   -1,   -1, 
           -1,   58,   59,  386,   61,  339,   63,  328,  816,   -1, 
          328,   -1,   -1,  347,  335,  361,   -1,  335,   -1,  340, 
           -1,   -1,  830,  831,  832,   -1,   -1,  981,   -1,   -1, 
          956,   -1,   -1,   -1,   91,  328,   -1,   -1,   -1,   -1, 
          361,   -1,  335,   -1,  998,  279, 1000,   -1,  341,   -1, 
           -1,   -1, 1006, 1007,   -1,  981,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,  267, 
           -1,   -1,  998,    0, 1000,  281,  282,   -1,   -1,   -1, 
         1006, 1007,  280,   10,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,  328,  306,   -1,  308,  309,  310, 
          311,  335,  910,  911,   -1,   -1,   -1,  341,   -1,  279, 
          280,  267,   -1,   -1,  922,   -1,   -1,   44,  306,   -1, 
          308,  309,  310,  311,  312,   -1,  279,  279,  339,  317, 
          328,   58,   59,   -1,   61,  341,   63,  335,  344,   -1, 
          328,   -1,  340,   -1,   -1,   -1,   -1,  335,   -1,   -1, 
           -1,  339,  340,   -1,   -1,   -1,  362,   -1,  328,  347, 
          348,  349,  350,  361,   91,  335,   -1,   -1,   -1,   -1, 
          340,   -1,  328,  981,   -1,  328,  328,   -1,   -1,  335, 
          386,   -1,  335,  335,   -1,   -1,   -1,   -1,   -1,   -1, 
          998,  361, 1000,   -1,   10,   -1,   -1,  385, 1006, 1007, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   -1,  299,   59,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,  771,   -1,  333,  334,  335,  336, 
          337,  338,  339,  340,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,    0,  373,  374,  375,  376, 
           -1,  378,  379,  380,  381,   10,  383,  384,  385,  386, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   -1,  299,   -1,   59,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
          337,  338,  339,  340,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,    0,  373,  374,  375,  376, 
           -1,  378,  379,  380,  381,   10,  383,  384,  385,  386, 
          957,   -1,   -1,  960,   -1,  962,   -1,  964,   -1,  877, 
          262,  263,  264,  881,   -1,   -1,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
          306,   -1,  308,  309,  310,  311,  312,   -1,   -1,   -1, 
           -1,  317,   -1,   58,   59,   -1,   61,   -1,   63,   -1, 
           -1,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335, 
           -1,   -1,   -1,  339,  340,   -1,   -1,   -1,   -1,   -1, 
           -1,  347,  348,  349,  350,   -1,   91,   -1,   -1,  262, 
          263,  264,   -1,   -1,   -1,  268,  269,   -1,  271,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1, 1054,   -1, 1056, 
           -1, 1058,   -1,   -1, 1061,   -1,   -1,   -1,   -1,  385, 
          362,   -1,   -1,   -1,   -1,    0,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   10,  271,   -1,   -1,   -1, 
         1087,   -1,   -1,   -1,  386,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297, 1021,  317,   -1, 1024, 1025,  341,   44, 
         1028, 1029,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          333,  334,   -1,   58,   59,   -1,   61,   -1,   63,  362, 
           -1,   -1,   -1,   -1,   -1,  348,   -1,  350,   -1,  352, 
          353,  354,  355,  317,   -1,  358,  341,  360,   -1,  344, 
           -1,   -1,   -1,  386,   -1,   -1,   91,   -1,   -1,  333, 
          334,   -1, 1080, 1081, 1082, 1083,   -1,  362,   -1,   -1, 
           -1,   -1,   -1, 1091,  348,   -1,  350,   -1,  352,  353, 
          354,  355,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,  386,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,  281,  282,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   59,  299,   -1,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,  338,  339,  340,  341,  342,  343,  344, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,    0,  373,  374, 
          375,  376,   -1,  378,  379,  380,  381,   10,  383,  384, 
          385,  386,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,  281,  282,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   59,  302,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,  338,  339,  340,  341,  342,  343,  344, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,    0,  373,  374, 
          375,  376,   -1,  378,  379,  380,  381,   10,  383,  384, 
          385,  386,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          306,   44,  308,  309,  310,  311,  312,   -1,   -1,   -1, 
           -1,  317,   -1,   -1,   -1,   58,   59,   -1,   61,   -1, 
           63,  306,  328,  308,  309,  310,  311,  312,   -1,  335, 
           -1,   -1,  317,  339,  340,   -1,   -1,   -1,   -1,   -1, 
           -1,  347,  348,  349,  350,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,  339,  340,   -1,   -1,   -1,   -1, 
           -1,   -1,  347,  348,  349,  350,   -1,   -1,   -1,  306, 
           -1,  308,  309,  310,  311,  312,   -1,   -1,   -1,  385, 
          317,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   10,  271,   -1, 
          385,   -1,  339,   -1,   -1,   -1,   -1,   -1,  281,  282, 
          347,  348,  349,  350,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,  306,   -1,  308,  309,  310,  311,  312,   -1, 
           -1,   -1,   -1,  317,   -1,   58,   59,   -1,  385,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  339,   -1,   -1,  341,  322, 
          323,  344,   -1,  347,  348,  349,  350,   -1,   91,   -1, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,  348,   -1,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   10,  360,   -1,   -1, 
           -1,  385,   -1,  386,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,  267,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,  281,  282, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   59,  299,   -1,   -1,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,  338,  339,  340,  341,  342, 
          343,  344,  345,  346,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,    0, 
          373,  374,  375,  376,   -1,  378,  379,  380,  381,   10, 
          383,  384,  385,  386,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,  267,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,  281,  282, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   -1,  299,   -1,   59,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,  338,  339,  340,  341,  342, 
          343,  344,  345,  346,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,    0, 
          373,  374,  375,  376,   -1,  378,  379,  380,  381,   10, 
          383,  384,  385,  386,   -1,   -1,  306,   -1,  308,  309, 
          310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  306,   44,  308,  309,  310,  311,  312,  339, 
           -1,   -1,   -1,  317,   -1,   -1,   -1,   58,   59,  349, 
          350,   -1,   63,   -1,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,   -1,   -1,   -1,  339,  340,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,  349,  350,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,  385,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  385,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   10, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,   -1, 
          341,   -1,   -1,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1, 
          350,  362,  352,  353,  354,  355,  356,  357,  358,   -1, 
          360,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,  386,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   59,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,  338,  339,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,    0,  373,  374,  375,  376,   -1,  378,  379,  380, 
          381,   10,  383,  384,  385,  386,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           59,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,  338,  339,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,    0,  373,  374,  375,  376,   -1,  378,  379,  380, 
          381,   10,  383,  384,  385,  386,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  306,   44,  308,  309,  310,  311, 
          312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,   58, 
           59,   -1,   61,   -1,   63,   -1,  328,   -1,   -1,   -1, 
           -1,   -1,   -1,  335,   -1,   -1,   -1,  339,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,  349,  350,   -1, 
           -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  385,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   10,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,   -1,  326,  327, 
           -1,   -1,  341,   -1,   -1,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          348,   10,  350,  362,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  386,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           59,   -1,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,  338, 
          339,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,   -1,  362,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,    0,  373,  374,  375,  376,   -1,  378, 
          379,  380,  381,   10,  383,  384,  385,  386,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   59,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,  338, 
          339,   -1,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,    0,  373,   -1,  375,  376,   -1,  378, 
          379,  380,  381,   10,  383,  384,  385,  386,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  306,   -1,  308, 
          309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,  335,   -1,   -1,   -1, 
          339,  340,   59,   -1,   -1,   -1,   63,   -1,  347,  348, 
          349,  350,  306,  307,   -1,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   91,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,  385,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,   -1,   -1,  363, 
           -1,   -1,   -1,    0,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   10,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,  385,   -1,   -1,  281,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,   -1, 
          326,  327,   -1,   -1,  341,   -1,   -1,  333,  334,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  348,   -1,  350,  362,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  386, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,  338,  339,   10,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,  762,  364,  365,  366, 
          367,  368,  369,   -1,   -1,  771,  373,   -1,  375,  376, 
           -1,  378,  379,  380,  381,   -1,  383,  384,  385,  386, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,  338,  339,   -1,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,    0,  362,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   10,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  380,  381,   -1,  383,  384,  385,  386, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   61,   -1,   63,   -1,   -1, 
           -1,  957,   -1,   -1,  960,   -1,  962,   -1,  964,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,    0,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   10,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 1054,   -1, 
         1056,   -1, 1058,   -1,   -1, 1061,   -1,   -1,   44,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,  349,   59,  351,   61,   -1,   63,   -1,   -1, 
           -1, 1087,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  380,  381,   91,  383,  384,  385,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,   -1,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   59,  280,   -1,   10,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   59,   -1,  333,  334,  335, 
          336,  337,   -1,  339,  340,  341,  342,  343,   -1,  345, 
           -1,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,    0,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   10,  383,  384,  385, 
          386,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,   -1,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,  280,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   59,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,  337,   -1,  339,  340,  341,  342,  343,   -1,  345, 
           -1,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,    0,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   10,  383,  384,  385, 
          386,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          306,   -1,  308,  309,  310,  311,  312,   -1,   -1,   -1, 
           -1,  317,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335, 
           -1,   -1,   -1,  339,  340,   59,   -1,   61,   -1,   63, 
           -1,  347,  348,  349,  350,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  306,   -1,  308,  309,  310,  311, 
      };
   }

   private static final short[] yyCheck2() {
      return new short[] {

          312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1, 
           -1,  385,   -1,  335,   -1,   -1,   -1,  339,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,  349,  350,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   10,  271, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
           -1,   -1,   -1,  385,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   61, 
           -1,   63,   61,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  386,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,   -1,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,   -1, 
           10,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   59, 
           -1,  333,  334,  335,  336,   -1,   -1,  339,  340,  341, 
          342,  343,   -1,  345,   -1,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,   91,  364,  365,  366,  367,  368,  369,   -1,   -1, 
            0,  373,   -1,  375,  376,   -1,  378,  379,  380,  381, 
           10,  383,  384,  385,  386,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,   -1,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,   -1, 
          279,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   -1,   59, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,  328, 
           -1,  333,  334,  335,  336,   -1,  335,  339,  340,  341, 
          342,  343,  341,  345,   -1,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
            0,  373,   -1,  375,  376,   -1,  378,  379,  380,  381, 
           10,  383,  384,  385,  386,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  267,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   44,   -1,   -1, 
          280,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,   91,   -1,   -1,   -1,  328,   -1, 
           -1,   -1,   -1,   -1,   -1,  335,   -1,   -1,   -1,   -1, 
          340,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,  361,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           10,  271,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,   61,   -1,   63,   61,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,   91,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  386,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,   -1,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,   63,  279,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,  328,   -1,  333,  334,  335,  336,   -1,  335,  339, 
          340,  341,  342,  343,   -1,  345,   -1,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,    0,  373,   -1,  375,  376,   -1,  378,  379, 
          380,  381,   10,  383,  384,  385,  386,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,   -1,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,  279,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   -1,  299, 
           -1,   59,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,  328,   -1,  333,  334,  335,  336,   -1,  335,  339, 
          340,  341,  342,  343,  341,  345,   -1,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,   -1,  362,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,    0,  373,   -1,  375,  376,   -1,  378,  379, 
          380,  381,   10,  383,  384,  385,  386,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   44,  329,  330,   -1, 
           -1,  333,  334,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
           58,   59,   -1,   61,   -1,   63,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,  753,   -1,   -1,   -1, 
           -1,    0,   -1,  760,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,  771,   -1,   44,   -1,   10,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,  281,   44,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           59,  299,   -1,   91,  302,  303,  304,   59,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          328,   91,   -1,   -1,   -1,   -1,   -1,  335,  336,   91, 
           -1,  339,   -1,  341,  342,  343,   -1,  345,    0,  347, 
           -1,  349,   -1,  351,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,  359,   -1,  361,  362,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  380,  381,   -1,  383,  384,  385,  386,   -1, 
           -1,   -1,   44,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   63,  280,  281,  282,   -1,   -1,   -1,   -1,  279, 
          280,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,  948,   -1,  950,   -1,  952,   -1,  305,   -1,   91, 
          957,   -1,   -1,   -1,   -1,   10,   -1,  964,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,    0,  333,  334,  335,  328,   -1, 
          338,   -1,   -1,  341,   10,  335,  344,   -1,  346,   44, 
          348,   -1,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,  279,  360,  361,  362,   -1,   61,   -1,   -1,   -1, 
           -1,  361,   -1,  262,  263,  264,  374,   -1,   44,  268, 
          269,   -1,  271,   -1,   -1,  267,   10,   -1,  386,  279, 
          280,   -1,   58,   59,   -1,   61,   91,   63,   -1,   -1, 
           -1,   -1,   -1, 1050,  293,  294,  295,  296,  297, 1056, 
          328, 1058,   -1,   -1, 1061,   -1,   -1,  335,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,  328,   -1, 
         1087,   -1,   -1,   10,   -1,  335,  328,   -1,   -1,   -1, 
          340,   -1,  341,  335,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   10, 
           -1,  361,   -1,  362,   -1,   59,   -1,   44,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   61,   -1,   -1,  386,  280,  281, 
          282,   -1,   -1,   44,   -1,   -1,   -1,   91,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   58,   59,   -1, 
           61,   -1,   63,  305,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           91,  333,  334,  335,   -1,   10,  338,   10,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,    0,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   10,  360,  361, 
          362,   -1,   -1,   -1,  279,  280,   -1,   -1,   -1,   44, 
           -1,   44,  374,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,  386,  271,   61,   -1,   61,   -1, 
           -1,   44,   -1,   -1,   10,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   59,  293,  294,  295, 
          296,  297,   -1,  328,   -1,   -1,   91,   -1,   91,  305, 
          335,   -1,   -1,  267,   -1,  340,  341,   -1,   44,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   61,  361,  333,  334,  335, 
           -1,  337,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,  348,  267,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,   91,  362,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,  374,   10, 
           -1,  335,  279,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          386,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   44,  328,   -1,   -1,   -1,   -1,  290, 
          291,  335,  293,  294,  295,  296,  297,   58,   59,   -1, 
           61,  328,   63,   -1,  305,   -1,   -1,   -1,  335,   -1, 
           -1,   -1,   -1,   -1,  341,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           91,   -1,  333,  334,  335,   -1,  337,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  348,    0,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   10,  360, 
           -1,  362,   -1,   -1,  279,  280,  279,   -1,   -1,  262, 
          263,  264,   -1,  374,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,  386,   -1,   -1,  281,  282, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   58,   59,   -1,   61, 
           -1,   63,  305,  328,   -1,  328,   -1,   -1,   -1,   -1, 
          335,   -1,  335,  279,  280,  340,  341,   -1,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,  338,  361,   -1,  341,   -1, 
           -1,  344,   44,  346,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,  362, 
           -1,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335, 
           -1,  374,   -1,   -1,  340,  341,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  386,   -1,   -1,   -1,   -1,   -1,   91, 
           44,  262,  263,  264,   -1,  361,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   58,   59,   -1,   61,   -1,   63, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,   -1,  337,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  348,    0,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   10,  360, 
           -1,  362,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,  374,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,  386,   -1,   -1,   -1,  281, 
          282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   58,   59,   -1,   61, 
           91,   63,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   91, 
           -1,  333,  334,  335,   -1,  337,  338,  279,  280,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,    0,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   10,  360,   -1, 
          362,   10,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,  374,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,  386,   -1,  328,  281,  282,   -1, 
           -1,   44,   -1,  335,   -1,   44,  290,  291,  340,  293, 
          294,  295,  296,  297,   -1,   58,   59,   -1,   61,   -1, 
           63,  305,   61,   -1,   -1,   -1,   -1,   -1,   -1,  361, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   91,  333, 
          334,  335,   91,  337,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,  348,    0,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   10,  360,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          374,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  279,  280, 
           -1,   -1,  386,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   58,   59,   -1,   61,   -1,   63,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,  328,   -1,   -1, 
           -1,   -1,   -1,  305,  335,   -1,   91,   -1,   -1,  340, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
          361,  333,  334,  335,   -1,  337,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,    0,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   10,  360,   -1, 
          362,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,  374,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,  386,   -1,   -1,   -1,  281,  282, 
          279,   44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   58,   59,   -1,   61,   91, 
           63,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   91,  328, 
          333,  334,  335,   -1,  337,  338,  335,   -1,  341,   -1, 
           -1,  344,  341,  346,   -1,  348,    0,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   10,  360,   -1,  362, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,  374,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,  386,   -1,   -1,  281,  282,   -1,   -1, 
           44,   -1,   -1,   -1,   44,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   58,   59,   -1,   61,   -1,   63, 
          305,   61,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   91,  333,  334, 
          335,   91,  337,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,  348,    0,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   10,  360,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  279,  280,   -1, 
           -1,  386,   -1,   -1,   -1,   -1,   -1,   -1,   44,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,  328,   -1,   -1,   -1, 
           -1,   -1,  305,  335,   -1,   91,   -1,   -1,  340,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,  361, 
          333,  334,  335,   -1,  337,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,    0,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   10,  360,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  374,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,  386,   -1,   -1,   -1,  281,  282,  279, 
           44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   58,   59,   -1,   61,   -1,   63, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   91,  328,  333, 
          334,  335,   -1,  337,  338,  335,   -1,  341,   -1,   -1, 
          344,  341,  346,   -1,  348,    0,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   10,  360,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
          374,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,  386,   -1,  280,  281,  282,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   58,   59,   -1,   61,   -1,   63,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   91,  333,  334,  335, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,  348,    0,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   10,  360,  361,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          386,   -1,   -1,   -1,   -1,   -1,   -1,   44,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,  348,    0,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   10,  360,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
          374,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,  386,   -1,   -1,   -1,  281,  282,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   58,   59,   -1,   -1,   -1,   63,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   91,   -1,  333,  334, 
          335,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,  348,    0,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   10,  360,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,  374, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,  386,   -1,   -1,  281,  282,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   58,   59,   -1,   -1,   -1,   63,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   91,  333,  334,  335,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,    0,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  386, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   63,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,  348,    0,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   10,  360,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,  374, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,  386,   -1,   -1,   -1,  281,  282,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   58,   59,   -1,   -1,   -1,   63,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   91,   -1,  333,  334,  335, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,  348,    0,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   10,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,  374,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
          386,   -1,   -1,  281,  282,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   59,   -1,   -1,   -1,   63,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   91,  333,  334,  335,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,    0,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  386,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           59,   -1,   -1,   -1,   63,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,  348,    0,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   10,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,  374,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
          386,   -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   91,   -1,  333,  334,  335,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,    0,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,  386, 
           -1,   -1,  281,  282,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348, 
            0,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           10,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  386,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   63,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,    0,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  386, 
           -1,   -1,   -1,  281,  282,  762,   44,   -1,  765,   -1, 
           -1,   -1,  290,  291,  771,  293,  294,  295,  296,  297, 
           58,   59,   -1,   -1,   -1,   63,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,    0,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,  374,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,  386,   -1, 
           -1,  281,  282,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   58, 
           59,   -1,   -1,   -1,   63,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,   -1,  333,  334,   -1,   -1,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348,    0, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   10, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          957,   -1,   -1,  960,  374,  962,   -1,  964,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  386,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,  333,  334, 1054,   -1, 1056, 
          338, 1058,   -1,  341, 1061,   -1,  344,   -1,  346,   -1, 
          348,    0,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
         1087,   -1,   -1,  262,  263,  264,  374,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  386,   -1, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   -1,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348, 
            0,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           10,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,  374,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,  386,   -1,   -1, 
          281,  282,   -1,   -1,   44,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   59, 
           -1,   61,   -1,   63,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   91,  333,  334,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  348,    0,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   10,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  374,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  386,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   59,   -1,   61, 
           -1,   63,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348, 
            0,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           10,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,  374,   -1,   -1,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,  386,   -1,   -1, 
          280,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   91,   -1,  333,  334,  335,   -1,   -1,   -1,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348,    0, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   10, 
          360,  361,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,  386,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           91,  333,  334,  335,   -1,  337,   -1,   -1,   -1,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,    0,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   10,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  386,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,  262,  263,  264,   -1,   -1,   -1,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,   -1,  337,   -1,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348,    0, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   10, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,  386,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           91,   -1,  333,  334,  335,   -1,  337,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,    0,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   10,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,  386,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   91, 
          333,  334,  335,   -1,  337,   -1,   -1,   -1,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,    0,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   10,  360,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  386,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,   -1,  337,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,    0,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   10,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,  386,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   91, 
           -1,  333,  334,  335,   -1,  337,   -1,   -1,   -1,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,    0,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   10,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,  386,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   91,  333, 
          334,  335,   -1,  337,   -1,   -1,   -1,  341,   -1,   -1, 
           -1,   -1,   -1,   -1,  348,    0,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   10,  360,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
      };
   }

   private static final short[] yyCheck3() {
      return new short[] {

           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  386,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,   -1,  337,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,    0,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   10,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,  386,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,   -1,  337,   -1,   -1,   -1,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,    0,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   10,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,  386,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,   -1,  337,   -1,   -1,   -1,  341,   -1,   -1, 
           -1,   -1,   -1,   -1,  348,    0,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   10,  360,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  386,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   59,   -1,   61,   -1,   63,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,  333,  334,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,   -1,    0,  350,   -1, 
           -1,   -1,  354,  355,  356,  357,  358,   10,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,  374,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,  386,   -1,   -1,   -1,  281,  282, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   59,   -1,   61,   -1, 
           63,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   91,   -1, 
          333,  334,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,   -1,    0,  350,   -1,   -1, 
           -1,  354,  355,  356,  357,  358,   10,  360,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,  374,   -1,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,  386,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,  348,    0,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   10,  360,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  386,   -1,   -1,   -1,   -1,   -1,   -1,   44,  262, 
          263,  264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,   -1,   -1,   -1,   -1,   -1,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,    0,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   10,  360,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,  386,   -1,   -1,   -1,  281,  282,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   58,   59,   -1,   -1,   -1,   63, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,   -1,    0,  350,   -1,   -1,   -1, 
           -1,   -1,  356,  357,  358,   10,  360,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
          374,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,  386,   -1,   -1,  281,  282,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   58,   59,   -1,   -1,   -1,   63,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,  333,  334,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,    0,  350,   -1,   -1,   -1,   -1,   -1, 
          356,  357,  358,   10,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          386,   -1,   -1,   -1,   -1,   -1,   -1,   44,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,   -1,    0,  350,   -1,   -1,   -1, 
           -1,   -1,  356,  357,  358,   10,  360,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
          374,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,  386,   -1,   -1,   -1,  281,  282,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   58,   59,   -1,   -1,   -1,   63,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  356,  357,  358,   -1,  360,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,  374, 
          267,  268,  269,   -1,  271,   -1,   44,   -1,   -1,   -1, 
           -1,  386,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           58,   59,   -1,  290,  291,   63,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,  356, 
          357,  358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  386, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   63,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  356,  357,   -1,  262,  263,  264,  362,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  374, 
           -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1, 
           -1,  386,  290,  291,   -1,  293,  294,  295,  296,  297, 
           58,   59,   -1,   -1,   -1,   63,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  356,  357, 
           -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,  262,  263,  264,   -1,  386,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  356,  357, 
           -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,  262,  263,  264,   -1,  386,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  356,  357, 
           -1,  262,  263,  264,  362,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1, 
          281,  282,   -1,   44,   -1,   -1,   -1,   -1,  386,  290, 
          291,   -1,  293,  294,  295,  296,  297,   58,   59,   -1, 
           -1,   -1,   63,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  324,  325,   -1,   -1,   -1,  329,  330, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  374,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,  262,  263,  264,   -1,  386,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,  324,  325,   -1,   -1,   10,  329,  330, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  374,   -1,   -1,   59,   -1,   -1,   -1, 
           44,  262,  263,  264,   -1,  386,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  324,  325,    0,   -1,   -1,  329,  330, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  362,   -1,  267,  268,  269,   -1,  271,   -1,   44, 
           -1,   -1,   -1,  374,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   58,   59,  386,  290,  291,   63,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
          324,  325,   -1,   10,   -1,  329,  330,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   10, 
          344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  362,  262, 
          263,  264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1, 
          374,   58,   59,   44,   -1,   -1,   63,   -1,  262,  263, 
          264,   -1,  386,  267,  268,  269,   -1,  271,   59,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1, 
          324,  325,   -1,   -1,   -1,  329,  330,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   44,  362, 
          344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,  362,   -1, 
           -1,   -1,   -1,  386,   -1,   -1,   -1,  262,  263,  264, 
          374,   -1,  267,  268,  269,   -1,  271,   -1,   -1,    0, 
           -1,   -1,  386,   -1,   -1,   -1,  281,  282,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,  324, 
          325,   -1,   -1,   -1,  329,  330,   -1,   58,   59,   -1, 
           -1,   -1,   63,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,    0,  362,   -1,   -1, 
           -1,  262,  263,  264,  281,  282,   10,  268,  269,  374, 
          271,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,  386,   -1,   -1,   -1,   -1,   -1,   -1,  305,  290, 
          291,   -1,  293,  294,  295,  296,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,  324,  325,   -1, 
           -1,   -1,  329,  330,   58,   59,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,    0,  362,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   10,  271,   -1,  374,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,  281,  282,   -1,   -1,  386, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,  386,   -1,   -1,   44,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1,  325, 
           -1,   -1,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,    0, 
          346,  262,  263,  264,   -1,   -1,  267,  268,  269,   10, 
          271,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,  374,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
          386,   -1,   -1,   44,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,    0,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   10,  271,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,  374,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,  386,   -1,   -1,   -1,   -1, 
           44,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,    0,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   10,  271,   -1,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
          374,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,  386,   -1,   -1,   -1,   -1,   -1,   44,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,    0, 
          346,  262,  263,  264,   -1,   -1,  267,  268,  269,   10, 
          271,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,  374,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
          386,   -1,   -1,   44,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,    0,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   10,  271,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,  374,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,  386,   -1,   -1,   -1,   -1, 
           44,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,    0,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   10,  271,   -1,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
          374,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,  386,   -1,   -1,   -1,   -1,   -1,   44,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,    0, 
          346,  262,  263,  264,   -1,   -1,  267,  268,  269,   10, 
          271,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,  374,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
          386,   -1,   -1,   44,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,    0,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   10,  271,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,  374,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,  386,   -1,   -1,   -1,   -1, 
           44,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,    0,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   10,  271,   -1,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
          374,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,  386,   -1,   -1,   -1,   -1,   -1,   44,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,    0, 
          346,  262,  263,  264,   -1,   -1,  267,  268,  269,   10, 
          271,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,  374,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
          386,   -1,   -1,   44,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,    0,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   10,  271,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,  374,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,  386,   -1,   -1,   -1,   -1, 
           44,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   44,  271,   -1,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   59, 
          374,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,  386,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,  262,  263,  264,   44,   -1,  267,  268,  269,   -1, 
          271,   -1,    0,   -1,   -1,   -1,  362,   -1,   -1,   59, 
          281,  282,   10,   -1,   -1,   -1,   -1,   -1,  374,  290, 
          291,   -1,  293,  294,  295,  296,   -1,   -1,   -1,   -1, 
          386,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   63, 
           -1,   59,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,  374,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,   -1,   -1,  386,   -1,   -1,   -1,   10, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,  293,  294,  295,  296,  297,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          374,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,  386,   -1,   -1,   -1,   -1,   -1,  338,   -1, 
           -1,  341,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,  386,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1, 
           -1,  341,   -1,  297,   -1,  293,  294,  295,  296,  297, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  362,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   -1,   91,   -1,   -1,   -1,  386,   -1,   -1,   -1, 
          338,   -1,   -1,  341,  348,   -1,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  362,  256,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,   -1,   -1,  269,  270, 
           10,  272,  273,  274,  275,  276,  277,  278,  386,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,   -1,   -1,  335,  336,   -1,   -1,  339,  340, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1, 
          351,   91,   -1,   -1,   -1,  356,   -1,   -1,  359,   -1, 
          361,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  380, 
          381,   -1,  383,  384,   -1,   -1,   -1,  256,  257,  258, 
          259,  260,  261,  262,  263,  264,  265,  266,   -1,   10, 
          269,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,   -1,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1, 
          339,  340,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
           91,   -1,  351,   -1,   -1,   -1,   -1,  356,   -1,   -1, 
          359,   -1,  361,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  380,  381,   -1,  383,  384,  256,  257,  258,  259, 
          260,  261,  262,  263,  264,  265,  266,   -1,   10,  269, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299, 
           -1,  301,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1, 
           -1,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1,  339, 
          340,   -1,  342,  343,   -1,  345,   -1,  347,   -1,   91, 
           -1,  351,   -1,   -1,   -1,   -1,  356,   -1,   -1,  359, 
           -1,  361,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          380,  381,   -1,  383,  384,  256,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,   -1,   10,  269,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,   -1,   -1,  335,  336,   -1,   -1,  339,  340, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,  356,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  380, 
          381,   -1,  383,  384,  256,  257,  258,  259,  260,  261, 
          262,  263,  264,  265,  266,   -1,   10,  269,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1, 
           -1,   -1,   -1,  335,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,  356,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  380,  381, 
           -1,  383,  384,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   10,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  380,  381,   -1, 
          383,  384,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   -1,  269,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   10,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,  361,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  380,  381,   -1,  383, 
          384,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  256,  257,  258,  259,  260,  261,   -1,   -1, 
          264,  265,  266,   -1,   10,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  380,  381,   -1,  383, 
          384,  256,  257,  258,  259,  260,  261,   -1,   -1,   -1, 
          265,  266,   10,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,   -1,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,  362,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  380,  381,   -1,  383,  384, 
           -1,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   10,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,   -1,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   -1,  383,  384,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   44,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,  341,  342,  343,   -1,  345,   -1,   -1, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  380,  381,   -1,  383,  384,   -1,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   44,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  380,  381,   -1,  383,  384,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288, 
      };
   }

   private static final short[] yyCheck4() {
      return new short[] {

          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  297, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,   -1,   59,  316,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,  333,  334,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1, 
          348,   -1,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  380,  381,   -1,  383,  384,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,   -1,   59,  316,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,   -1,  333,  334,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,   -1,   -1,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   -1, 
          360,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  380, 
          381,   -1,  383,  384,  257,  258,  259,  260,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  380,  381,   -1, 
          383,  384,  257,  258,  259,  260,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,   -1,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  380,  381,   -1,  383,  384, 
          257,  258,  259,  260,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,  279,  280,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,   -1,   -1,   -1,   -1, 
          297,  298,  299,  300,  301,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,   -1,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  385,  257, 
          258,  259,  260,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,  279,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,   -1,   -1,   -1,   -1,  297, 
          298,  299,  300,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,   -1,   -1,  363,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  385,  257,  258, 
          259,  260,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
          279,  280,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,   -1,   -1,   -1,   -1,  297,  298, 
          299,  300,  301,  302,  303,  304,   -1,  306,  307,  308, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
           -1,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,   -1,   -1,  363,  364,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  385,  257,  258,  259, 
          260,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,  279, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,   -1,   -1,   -1,   -1,  297,  298,  299, 
          300,  301,  302,  303,  304,   -1,  306,  307,   -1,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348,   -1, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,   -1,   -1,  363,  364,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  385,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,  279,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,   -1,   -1,   -1,   -1,  297,  298,  299,  300, 
          301,  302,  303,  304,   -1,  306,  307,   -1,   -1,  310, 
           -1,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
           -1,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,  256, 
          257,  258,  259,  260,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,  385,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,  298,  299,  300,  301,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  380,  381,   -1,  383,  384,  256,  257, 
          258,  259,  260,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,   -1,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  380,  381,   -1,  383,  384,  256,  257,  258, 
          259,  260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,   -1,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  380,  381,   -1,  383,  384,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,  349,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  380, 
          381,   -1,  383,  384,  385,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,  349,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  380,  381, 
           -1,  383,  384,  385,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,  349,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  380,  381,   -1, 
          383,  384,  385,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  380,  381,   -1,  383, 
          384,  385,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,   -1,   -1,  349,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  380,  381,   -1,  383,  384, 
          385,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   -1,  383,  384,  385, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
           -1,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  380,  381,   -1,  383,  384,  385,  257, 
          258,  259,  260,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,  300,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  380,  381,   -1,  383,  384,  257,  258,  259, 
          260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299, 
           -1,  301,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          380,  381,   -1,  383,  384,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,  340,   -1, 
          342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  380,  381, 
           -1,  383,  384,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  380,  381,   -1,  383, 
          384,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   -1,  383,  384,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  380,  381,   -1,  383,  384,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          380,  381,   -1,  383,  384,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  380,  381, 
           -1,  383,  384,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,  340,   -1,  342,  343, 
           -1,  345,   -1,   -1,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  380,  381,   -1,  383, 
          384,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,   -1,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   -1,  383,  384,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  380,  381,   -1,  383,  384,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          380,  381,   -1,  383,  384,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  380,  381, 
           -1,  383,  384,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
           -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  380,  381,   -1,  383, 
          384,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,   -1,   -1, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   -1,  383,  384,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,   -1,   -1,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  380,  381,   -1,  383,  384,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          380,  381,   -1,  383,  384,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  380,  381, 
           -1,  383,  384,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
           -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  380,  381,   -1,  383, 
          384,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,   -1,   -1, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   -1,  383,  384,  306, 
          307,   -1,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  306,  307,  363,   -1,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,  385,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  306, 
          307,  363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,  385,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  306,  307,  363,   -1,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,  385,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  306, 
          307,  363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,  385,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  306,  307,  363,   -1,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,  385,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  306, 
          307,  363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,  385,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  306,  307,  363,   -1,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,  385,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  306, 
          307,  363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,  385,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  306,  307,  363,   -1,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,  385,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  306, 
          307,  363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,  385,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  306,  307,  363,   -1,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,  385,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  306, 
          307,  363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,  385,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,   -1,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  385, 
      };
   }

}
