//  * This file is part of the uutils coreutils package.
//  *
//  * (c) Michael Gehring <mg@ebfe.org>
//  *
//  * For the full copyright and license information, please view the LICENSE
//  * file that was distributed with this source code.

#[macro_use]
extern crate uucore;

use std::fs::hard_link;
use std::io::Error;
use std::path::Path;

static SYNTAX: &str = "[OPTIONS] FILE1 FILE2";
static SUMMARY: &str = "Create a link named FILE2 to FILE1";
static LONG_HELP: &str = "";

pub fn normalize_error_message(e: Error) -> String {
    match e.raw_os_error() {
        Some(2) => String::from("No such file or directory (os error 2)"),
        _ => format!("{}", e),
    }
}

pub fn uumain(args: impl uucore::Args) -> i32 {
    let matches = app!(SYNTAX, SUMMARY, LONG_HELP).parse(args.collect_str());
    if matches.free.len() != 2 {
        crash!(1, "{}", msg_wrong_number_of_arguments!(2));
    }

    let old = Path::new(&matches.free[0]);
    let new = Path::new(&matches.free[1]);

    match hard_link(old, new) {
        Ok(_) => 0,
        Err(err) => {
            show_error!("{}", normalize_error_message(err));
            1
        }
    }
}
