package net.corda.testing.contracts

import net.corda.core.contracts.BelongsToContract
import net.corda.core.contracts.ContractState
import net.corda.core.identity.AbstractParty

/**
 * Dummy state for use in testing. Not part of any contract, not even the [DummyContract].
 */
@BelongsToContract(DummyContract::class)
data class DummyState @JvmOverloads constructor (
        /** Some information that the state represents for test purposes. **/
        val magicNumber: Int = 0,
        override val participants: List<AbstractParty> = listOf()) : ContractState {

    fun copy(magicNumber: Int = this.magicNumber) = DummyState(magicNumber)
}
