/*
 * Decompiled with CFR 0.152.
 */
package net.corda.finance.contracts;

import java.security.PublicKey;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kotlin.Unit;
import net.corda.core.contracts.Amount;
import net.corda.core.contracts.CommandAndState;
import net.corda.core.contracts.CommandData;
import net.corda.core.contracts.CommandWithParties;
import net.corda.core.contracts.Contract;
import net.corda.core.contracts.ContractsDSL;
import net.corda.core.contracts.Issued;
import net.corda.core.contracts.OwnableState;
import net.corda.core.contracts.PartyAndReference;
import net.corda.core.contracts.TimeWindow;
import net.corda.core.crypto.NullKeys;
import net.corda.core.identity.AbstractParty;
import net.corda.core.identity.AnonymousParty;
import net.corda.core.transactions.LedgerTransaction;
import net.corda.finance.contracts.ICommercialPaperState;
import net.corda.finance.contracts.utils.StateSumming;
import org.jetbrains.annotations.NotNull;

public class JavaCommercialPaper
implements Contract {
    public static final String JCP_PROGRAM_ID = "net.corda.finance.contracts.JavaCommercialPaper";

    @NotNull
    private List<CommandWithParties<Commands>> extractCommands(@NotNull LedgerTransaction tx) {
        return tx.getCommands().stream().filter(command -> command.getValue() instanceof Commands).map(command -> new CommandWithParties(command.getSigners(), command.getSigningParties(), (CommandData)((Commands)command.getValue()))).collect(Collectors.toList());
    }

    public void verify(@NotNull LedgerTransaction tx) throws IllegalArgumentException {
        List groups2 = tx.groupStates(State.class, State::withoutOwner);
        List commands = tx.getCommands().stream().filter(it -> it.getValue() instanceof Commands).collect(Collectors.toList());
        CommandWithParties command = (CommandWithParties)JavaCommercialPaper.onlyElementOf(commands);
        TimeWindow timeWindow = tx.getTimeWindow();
        for (LedgerTransaction.InOutGroup group : groups2) {
            Instant time;
            State input;
            CommandWithParties cmd;
            List inputs = group.getInputs();
            List outputs = group.getOutputs();
            if (command.getValue() instanceof Commands.Move) {
                cmd = ContractsDSL.requireSingleCommand((Collection)tx.getCommands(), Commands.Move.class);
                input = (State)JavaCommercialPaper.onlyElementOf(inputs);
                if (!cmd.getSigners().contains(input.getOwner().getOwningKey())) {
                    throw new IllegalStateException("Failed requirement: the transaction is signed by the owner of the CP");
                }
                if (outputs.size() == 1) continue;
                throw new IllegalStateException("the state is propagated");
            }
            if (command.getValue() instanceof Commands.Redeem) {
                cmd = ContractsDSL.requireSingleCommand((Collection)tx.getCommands(), Commands.Redeem.class);
                input = (State)JavaCommercialPaper.onlyElementOf(inputs);
                if (!cmd.getSigners().contains(input.getOwner().getOwningKey())) {
                    throw new IllegalStateException("Failed requirement: the transaction is signed by the owner of the CP");
                }
                time = timeWindow == null ? null : timeWindow.getUntilTime();
                Amount<Issued<Currency>> received = StateSumming.sumCashBy(tx.getOutputStates(), input.getOwner());
                ContractsDSL.requireThat(require -> {
                    require.using("must be timestamped", timeWindow != null);
                    require.using("received amount equals the face value: " + received + " vs " + input.getFaceValue(), received.equals(input.getFaceValue()));
                    require.using("the paper must have matured", time != null && !time.isBefore(input.getMaturityDate()));
                    require.using("the received amount equals the face value", input.getFaceValue().equals((Object)received));
                    require.using("the paper must be destroyed", outputs.isEmpty());
                    return Unit.INSTANCE;
                });
                continue;
            }
            if (!(command.getValue() instanceof Commands.Issue)) continue;
            cmd = ContractsDSL.requireSingleCommand((Collection)tx.getCommands(), Commands.Issue.class);
            State output = (State)JavaCommercialPaper.onlyElementOf(outputs);
            time = null == timeWindow ? null : timeWindow.getUntilTime();
            ContractsDSL.requireThat(require -> {
                require.using("output values sum to more than the inputs", inputs.isEmpty());
                require.using("output values sum to more than the inputs", output.faceValue.getQuantity() > 0L);
                require.using("must be timestamped", timeWindow != null);
                require.using("the maturity date is not in the past", time != null && time.isBefore(output.getMaturityDate()));
                require.using("output states are issued by a command signer", cmd.getSigners().contains(output.issuance.getParty().getOwningKey()));
                return Unit.INSTANCE;
            });
        }
    }

    private static <T> T onlyElementOf(Iterable<T> iterable) {
        Iterator<T> iter = iterable.iterator();
        T item = iter.next();
        if (iter.hasNext()) {
            throw new IllegalArgumentException("Iterable has more than one element!");
        }
        return item;
    }

    public static interface Commands
    extends CommandData {

        public static class Issue
        implements Commands {
            public boolean equals(Object obj) {
                return obj instanceof Issue;
            }
        }

        public static class Redeem
        implements Commands {
            public boolean equals(Object obj) {
                return obj instanceof Redeem;
            }
        }

        public static class Move
        implements Commands {
            public boolean equals(Object obj) {
                return obj instanceof Move;
            }
        }
    }

    public static class State
    implements OwnableState,
    ICommercialPaperState {
        private PartyAndReference issuance;
        private AbstractParty owner;
        private Amount<Issued<Currency>> faceValue;
        private Instant maturityDate;

        public State() {
        }

        public State(PartyAndReference issuance, AbstractParty owner, Amount<Issued<Currency>> faceValue, Instant maturityDate) {
            this.issuance = issuance;
            this.owner = owner;
            this.faceValue = faceValue;
            this.maturityDate = maturityDate;
        }

        public State copy() {
            return new State(this.issuance, this.owner, this.faceValue, this.maturityDate);
        }

        @Override
        public ICommercialPaperState withOwner(AbstractParty newOwner) {
            return new State(this.issuance, newOwner, this.faceValue, this.maturityDate);
        }

        @NotNull
        public CommandAndState withNewOwner(@NotNull AbstractParty newOwner) {
            return new CommandAndState((CommandData)new Commands.Move(), (OwnableState)new State(this.issuance, newOwner, this.faceValue, this.maturityDate));
        }

        @Override
        public ICommercialPaperState withFaceValue(Amount<Issued<Currency>> newFaceValue) {
            return new State(this.issuance, this.owner, newFaceValue, this.maturityDate);
        }

        @Override
        public ICommercialPaperState withMaturityDate(Instant newMaturityDate) {
            return new State(this.issuance, this.owner, this.faceValue, newMaturityDate);
        }

        public PartyAndReference getIssuance() {
            return this.issuance;
        }

        @NotNull
        public AbstractParty getOwner() {
            return this.owner;
        }

        public Amount<Issued<Currency>> getFaceValue() {
            return this.faceValue;
        }

        public Instant getMaturityDate() {
            return this.maturityDate;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            State state = (State)that;
            if (!Objects.equals(this.issuance, state.issuance)) {
                return false;
            }
            if (!Objects.equals(this.owner, state.owner)) {
                return false;
            }
            if (!Objects.equals(this.faceValue, state.faceValue)) {
                return false;
            }
            return Objects.equals(this.maturityDate, state.maturityDate);
        }

        public int hashCode() {
            return Objects.hash(this.issuance, this.owner, this.faceValue, this.maturityDate);
        }

        State withoutOwner() {
            return new State(this.issuance, (AbstractParty)new AnonymousParty((PublicKey)NullKeys.NullPublicKey.INSTANCE), this.faceValue, this.maturityDate);
        }

        @NotNull
        public List<AbstractParty> getParticipants() {
            return Collections.singletonList(this.owner);
        }
    }
}

