/*
 * Decompiled with CFR 0.152.
 */
package jtermios.linux;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import jtermios.FDSet;
import jtermios.JTermios;
import jtermios.Pollfd;
import jtermios.Termios;
import jtermios.TimeVal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTermiosImpl
implements JTermios.JTermiosInterface {
    private static String DEVICE_DIR_PATH = "/dev/";
    private static final boolean IS64B = NativeLong.SIZE == 8;
    static Linux_C_lib_DirectMapping m_ClibDM = new Linux_C_lib_DirectMapping();
    static Linux_C_lib m_Clib = m_ClibDM;
    private static final int TIOCGSERIAL = 21534;
    private static final int TIOCSSERIAL = 21535;
    private static final int ASYNC_SPD_MASK = 4144;
    private static final int ASYNC_SPD_CUST = 48;
    private static final int[] m_BaudRates = new int[]{50, 1, 75, 2, 110, 3, 134, 4, 150, 5, 200, 6, 300, 7, 600, 8, 1200, 9, 1800, 10, 2400, 11, 4800, 12, 9600, 13, 19200, 14, 38400, 15, 57600, 4097, 115200, 4098, 230400, 4099, 460800, 4100, 500000, 4101, 576000, 4102, 921600, 4103, 1000000, 4104, 1152000, 4105, 1500000, 4106, 2000000, 4107, 2500000, 4108, 3000000, 4109, 3500000, 4110, 4000000, 4111};

    public JTermiosImpl() {
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "instantiating %s\n", this.getClass().getCanonicalName());
        JTermios.FIONREAD = 21531;
        JTermios.O_RDWR = 2;
        JTermios.O_NONBLOCK = 2048;
        JTermios.O_NOCTTY = 256;
        JTermios.O_NDELAY = 2048;
        JTermios.F_GETFL = 3;
        JTermios.F_SETFL = 4;
        JTermios.EAGAIN = 11;
        JTermios.EACCES = 13;
        JTermios.EEXIST = 17;
        JTermios.EINTR = 4;
        JTermios.EINVAL = 22;
        JTermios.EIO = 5;
        JTermios.EISDIR = 21;
        JTermios.ELOOP = 40;
        JTermios.EMFILE = 24;
        JTermios.ENAMETOOLONG = 36;
        JTermios.ENFILE = 23;
        JTermios.ENOENT = 2;
        JTermios.ENOSR = 63;
        JTermios.ENOSPC = 28;
        JTermios.ENOTDIR = 20;
        JTermios.ENXIO = 6;
        JTermios.EOVERFLOW = 75;
        JTermios.EROFS = 30;
        JTermios.ENOTSUP = 95;
        JTermios.TIOCM_RNG = 128;
        JTermios.TIOCM_CAR = 64;
        JTermios.IGNBRK = 1;
        JTermios.BRKINT = 2;
        JTermios.IGNPAR = 4;
        JTermios.PARMRK = 8;
        JTermios.INLCR = 64;
        JTermios.IGNCR = 128;
        JTermios.ICRNL = 256;
        JTermios.ECHONL = 64;
        JTermios.IEXTEN = 32768;
        JTermios.CLOCAL = 2048;
        JTermios.OPOST = 1;
        JTermios.VSTART = 8;
        JTermios.TCSANOW = 0;
        JTermios.VSTOP = 9;
        JTermios.VMIN = 6;
        JTermios.VTIME = 5;
        JTermios.VEOF = 4;
        JTermios.TIOCMGET = 21525;
        JTermios.TIOCM_CTS = 32;
        JTermios.TIOCM_DSR = 256;
        JTermios.TIOCM_RI = 128;
        JTermios.TIOCM_CD = 64;
        JTermios.TIOCM_DTR = 2;
        JTermios.TIOCM_RTS = 4;
        JTermios.ICANON = 2;
        JTermios.ECHO = 8;
        JTermios.ECHOE = 16;
        JTermios.ISIG = 1;
        JTermios.TIOCMSET = 21528;
        JTermios.IXON = 1024;
        JTermios.IXOFF = 4096;
        JTermios.IXANY = 2048;
        JTermios.CRTSCTS = Integer.MIN_VALUE;
        JTermios.TCSADRAIN = 1;
        JTermios.INPCK = 16;
        JTermios.ISTRIP = 32;
        JTermios.CSIZE = 48;
        JTermios.TCIFLUSH = 0;
        JTermios.TCOFLUSH = 1;
        JTermios.TCIOFLUSH = 2;
        JTermios.CS5 = 0;
        JTermios.CS6 = 16;
        JTermios.CS7 = 32;
        JTermios.CS8 = 48;
        JTermios.CSTOPB = 64;
        JTermios.CREAD = 128;
        JTermios.PARENB = 256;
        JTermios.PARODD = 512;
        JTermios.B0 = 0;
        JTermios.B50 = 1;
        JTermios.B75 = 2;
        JTermios.B110 = 3;
        JTermios.B134 = 4;
        JTermios.B150 = 5;
        JTermios.B200 = 6;
        JTermios.B300 = 7;
        JTermios.B600 = 8;
        JTermios.B1200 = 9;
        JTermios.B1800 = 10;
        JTermios.B2400 = 11;
        JTermios.B4800 = 12;
        JTermios.B9600 = 13;
        JTermios.B19200 = 14;
        JTermios.B38400 = 15;
        JTermios.B57600 = 4097;
        JTermios.B115200 = 4098;
        JTermios.B230400 = 4099;
        JTermios.POLLIN = 1;
        JTermios.POLLPRI = (short)2;
        JTermios.POLLOUT = (short)4;
        JTermios.POLLERR = (short)8;
        JTermios.POLLNVAL = (short)32;
        JTermios.POLLIN_IN = JTermiosImpl.pollMask(0, JTermios.POLLIN);
        JTermios.POLLOUT_IN = JTermiosImpl.pollMask(0, JTermios.POLLOUT);
        JTermios.POLLIN_OUT = JTermiosImpl.pollMask(1, JTermios.POLLIN);
        JTermios.POLLOUT_OUT = JTermiosImpl.pollMask(1, JTermios.POLLOUT);
        JTermios.POLLNVAL_OUT = JTermiosImpl.pollMask(1, JTermios.POLLNVAL);
    }

    public static int pollMask(int i, short n) {
        short[] s = new short[2];
        int[] d = new int[1];
        s[i] = n;
        if (IS64B) {
            m_ClibDM.memcpy(d, s, 4L);
        } else {
            m_ClibDM.memcpy(d, s, 4);
        }
        return d[0];
    }

    @Override
    public int errno() {
        return Native.getLastError();
    }

    @Override
    public void cfmakeraw(Termios termios2) {
        Linux_C_lib.termios t = new Linux_C_lib.termios(termios2);
        m_Clib.cfmakeraw(t);
        t.update(termios2);
    }

    @Override
    public int fcntl(int fd, int cmd, int arg) {
        return m_Clib.fcntl(fd, cmd, arg);
    }

    @Override
    public int tcdrain(int fd) {
        return m_Clib.tcdrain(fd);
    }

    @Override
    public int cfgetispeed(Termios termios2) {
        return m_Clib.cfgetispeed(new Linux_C_lib.termios(termios2)).intValue();
    }

    @Override
    public int cfgetospeed(Termios termios2) {
        return m_Clib.cfgetospeed(new Linux_C_lib.termios(termios2)).intValue();
    }

    @Override
    public int cfsetispeed(Termios termios2, int speed) {
        Linux_C_lib.termios t = new Linux_C_lib.termios(termios2);
        int ret = m_Clib.cfsetispeed(t, new NativeLong((long)speed));
        t.update(termios2);
        return ret;
    }

    @Override
    public int cfsetospeed(Termios termios2, int speed) {
        Linux_C_lib.termios t = new Linux_C_lib.termios(termios2);
        int ret = m_Clib.cfsetospeed(t, new NativeLong((long)speed));
        t.update(termios2);
        return ret;
    }

    @Override
    public int open(String s, int t) {
        if (s != null && !s.startsWith("/")) {
            s = DEVICE_DIR_PATH + s;
        }
        return m_Clib.open(s, t);
    }

    @Override
    public int read(int fd, byte[] buffer, int len) {
        if (IS64B) {
            return (int)m_Clib.read(fd, buffer, (long)len);
        }
        return m_Clib.read(fd, buffer, len);
    }

    @Override
    public int write(int fd, byte[] buffer, int len) {
        if (IS64B) {
            return (int)m_Clib.write(fd, buffer, (long)len);
        }
        return m_Clib.write(fd, buffer, len);
    }

    @Override
    public int close(int fd) {
        return m_Clib.close(fd);
    }

    @Override
    public int tcflush(int fd, int b) {
        return m_Clib.tcflush(fd, b);
    }

    @Override
    public int tcgetattr(int fd, Termios termios2) {
        Linux_C_lib.termios t = new Linux_C_lib.termios();
        int ret = m_Clib.tcgetattr(fd, t);
        t.update(termios2);
        return ret;
    }

    @Override
    public void perror(String msg) {
        m_Clib.perror(msg);
    }

    @Override
    public int tcsendbreak(int fd, int duration) {
        return m_Clib.tcsendbreak(fd, duration / 250);
    }

    @Override
    public int tcsetattr(int fd, int cmd, Termios termios2) {
        return m_Clib.tcsetattr(fd, cmd, new Linux_C_lib.termios(termios2));
    }

    @Override
    public void FD_CLR(int fd, FDSet set) {
        if (set == null) {
            return;
        }
        FDSetImpl p = (FDSetImpl)set;
        int n = fd / 32;
        p.bits[n] = p.bits[n] & ~(1 << fd % 32);
    }

    @Override
    public boolean FD_ISSET(int fd, FDSet set) {
        if (set == null) {
            return false;
        }
        FDSetImpl p = (FDSetImpl)set;
        return (p.bits[fd / 32] & 1 << fd % 32) != 0;
    }

    @Override
    public void FD_SET(int fd, FDSet set) {
        if (set == null) {
            return;
        }
        FDSetImpl p = (FDSetImpl)set;
        int n = fd / 32;
        p.bits[n] = p.bits[n] | 1 << fd % 32;
    }

    @Override
    public void FD_ZERO(FDSet set) {
        if (set == null) {
            return;
        }
        FDSetImpl p = (FDSetImpl)set;
        Arrays.fill(p.bits, 0);
    }

    @Override
    public int select(int nfds, FDSet rfds, FDSet wfds, FDSet efds, TimeVal timeout) {
        Linux_C_lib.timeval tout = null;
        if (timeout != null) {
            tout = new Linux_C_lib.timeval(timeout);
        }
        int[] r = rfds != null ? ((FDSetImpl)rfds).bits : null;
        int[] w = wfds != null ? ((FDSetImpl)wfds).bits : null;
        int[] e = efds != null ? ((FDSetImpl)efds).bits : null;
        return m_Clib.select(nfds, r, w, e, tout);
    }

    @Override
    public int poll(Pollfd[] fds, int nfds, int timeout) {
        Linux_C_lib.pollfd[] pfds = new Linux_C_lib.pollfd[fds.length];
        for (int i = 0; i < nfds; ++i) {
            pfds[i] = new Linux_C_lib.pollfd(fds[i]);
        }
        int ret = m_Clib.poll(pfds, nfds, timeout);
        for (int i = 0; i < nfds; ++i) {
            fds[i].revents = pfds[i].revents;
        }
        return ret;
    }

    @Override
    public int poll(int[] fds, int nfds, int timeout) {
        return m_Clib.poll(fds, nfds, timeout);
    }

    @Override
    public FDSet newFDSet() {
        return new FDSetImpl();
    }

    @Override
    public int ioctl(int fd, int cmd, int[] data) {
        return m_Clib.ioctl(fd, cmd, data);
    }

    private int ioctl(int fd, int cmd, Linux_C_lib.serial_struct data) {
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> ioctl(%d,%d,%s)\n", new Object[]{fd, cmd, data});
        int ret = m_Clib.ioctl(fd, cmd, data);
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(3, "< tcsetattr(%d,%d,%s) => %d\n", new Object[]{fd, cmd, data, ret});
        return ret;
    }

    @Override
    public String getPortNamePattern() {
        ArrayList<String> prefixes = new ArrayList<String>();
        try {
            String line;
            BufferedReader drivers = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("/proc/tty/drivers"), "US-ASCII"));
            while ((line = drivers.readLine()) != null) {
                String[] parts = line.split(" +");
                if (parts.length != 5 || !"serial".equals(parts[4]) || !parts[1].startsWith("/dev/")) continue;
                prefixes.add(parts[1].substring(5));
            }
            drivers.close();
        }
        catch (IOException e) {
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "failed to read /proc/tty/drivers\n", new Object[0]);
            prefixes.add("ttyS");
            prefixes.add("ttyUSB");
            prefixes.add("ttyACM");
        }
        StringBuilder pattern = new StringBuilder();
        pattern.append('^');
        boolean first = true;
        for (String prefix : prefixes) {
            if (first) {
                first = false;
            } else {
                pattern.append('|');
            }
            pattern.append("(");
            pattern.append(prefix);
            pattern.append(".+)");
        }
        return pattern.toString();
    }

    @Override
    public List<String> getPortList() {
        File dir = new File(DEVICE_DIR_PATH);
        if (!dir.isDirectory()) {
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "device directory %s does not exist\n", DEVICE_DIR_PATH);
            return null;
        }
        String[] devs = dir.list();
        LinkedList<String> list = new LinkedList<String>();
        Pattern p = JTermios.getPortNamePattern(this);
        if (devs != null) {
            for (int i = 0; i < devs.length; ++i) {
                String s = devs[i];
                if (!p.matcher(s).matches()) continue;
                list.add(s);
            }
        }
        return list;
    }

    @Override
    public void shutDown() {
    }

    @Override
    public int setspeed(int fd, Termios termios2, int speed) {
        int c = speed;
        for (int i = 0; i < m_BaudRates.length; i += 2) {
            if (m_BaudRates[i] != speed) continue;
            Linux_C_lib.serial_struct ss = new Linux_C_lib.serial_struct();
            int r = this.ioctl(fd, 21534, ss);
            if (r == 0) {
                ss.flags &= 0xFFFFEFCF;
                r = this.ioctl(fd, 21535, ss);
            }
            if ((r = JTermios.cfsetispeed(termios2, c = m_BaudRates[i + 1])) != 0) {
                return r;
            }
            r = JTermios.cfsetospeed(termios2, c);
            if (r != 0) {
                return r;
            }
            r = JTermios.tcsetattr(fd, JTermios.TCSANOW, termios2);
            if (r != 0) {
                return r;
            }
            return 0;
        }
        Linux_C_lib.serial_struct ss = new Linux_C_lib.serial_struct();
        int r = this.ioctl(fd, 21534, ss);
        if (r != 0) {
            return r;
        }
        ss.flags = ss.flags & 0xFFFFEFCF | 0x30;
        if (speed == 0) {
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "unable to set custom baudrate %d \n", speed);
            return -1;
        }
        ss.custom_divisor = (ss.baud_base + speed / 2) / speed;
        if (ss.custom_divisor == 0) {
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "unable to set custom baudrate %d (possible division by zero)\n", speed);
            return -1;
        }
        int closestSpeed = ss.baud_base / ss.custom_divisor;
        if (closestSpeed < speed * 98 / 100 || closestSpeed > speed * 102 / 100) {
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "best available baudrate %d not close enough to requested %d \n", closestSpeed, speed);
            return -1;
        }
        r = this.ioctl(fd, 21535, ss);
        if (r != 0) {
            return r;
        }
        r = JTermios.cfsetispeed(termios2, JTermios.B38400);
        if (r != 0) {
            return r;
        }
        r = JTermios.cfsetospeed(termios2, JTermios.B38400);
        if (r != 0) {
            return r;
        }
        r = JTermios.tcsetattr(fd, JTermios.TCSANOW, termios2);
        if (r != 0) {
            return r;
        }
        return 0;
    }

    @Override
    public int pipe(int[] fds) {
        return m_Clib.pipe(fds);
    }

    private static class FDSetImpl
    extends FDSet {
        static final int FD_SET_SIZE = 1024;
        static final int NFBBITS = 32;
        int[] bits = new int[32];

        private FDSetImpl() {
        }

        public String toString() {
            return String.format("%08X%08X", this.bits[0], this.bits[1]);
        }
    }

    public static interface Linux_C_lib
    extends Library {
        public long memcpy(int[] var1, short[] var2, long var3);

        public int memcpy(int[] var1, short[] var2, int var3);

        public int pipe(int[] var1);

        public int tcdrain(int var1);

        public void cfmakeraw(termios var1);

        public int fcntl(int var1, int var2, int var3);

        public int ioctl(int var1, int var2, int[] var3);

        public int ioctl(int var1, int var2, serial_struct var3);

        public int open(String var1, int var2);

        public int close(int var1);

        public int tcgetattr(int var1, termios var2);

        public int tcsetattr(int var1, int var2, termios var3);

        public int cfsetispeed(termios var1, NativeLong var2);

        public int cfsetospeed(termios var1, NativeLong var2);

        public NativeLong cfgetispeed(termios var1);

        public NativeLong cfgetospeed(termios var1);

        public int write(int var1, byte[] var2, int var3);

        public int read(int var1, byte[] var2, int var3);

        public long write(int var1, byte[] var2, long var3);

        public long read(int var1, byte[] var2, long var3);

        public int select(int var1, int[] var2, int[] var3, int[] var4, timeval var5);

        public int poll(pollfd[] var1, int var2, int var3);

        public int poll(int[] var1, int var2, int var3);

        public int tcflush(int var1, int var2);

        public void perror(String var1);

        public int tcsendbreak(int var1, int var2);

        public static class termios
        extends Structure {
            public int c_iflag;
            public int c_oflag;
            public int c_cflag;
            public int c_lflag;
            public byte c_line;
            public byte[] c_cc = new byte[32];
            public int c_ispeed;
            public int c_ospeed;

            protected List getFieldOrder() {
                return Arrays.asList("c_iflag", "c_oflag", "c_cflag", "c_lflag", "c_line", "c_cc", "c_ispeed", "c_ospeed");
            }

            public termios() {
            }

            public termios(Termios t) {
                this.c_iflag = t.c_iflag;
                this.c_oflag = t.c_oflag;
                this.c_cflag = t.c_cflag;
                this.c_lflag = t.c_lflag;
                System.arraycopy(t.c_cc, 0, this.c_cc, 0, t.c_cc.length);
                this.c_ispeed = t.c_ispeed;
                this.c_ospeed = t.c_ospeed;
            }

            public void update(Termios t) {
                t.c_iflag = this.c_iflag;
                t.c_oflag = this.c_oflag;
                t.c_cflag = this.c_cflag;
                t.c_lflag = this.c_lflag;
                System.arraycopy(this.c_cc, 0, t.c_cc, 0, t.c_cc.length);
                t.c_ispeed = this.c_ispeed;
                t.c_ospeed = this.c_ospeed;
            }
        }

        public static class serial_struct
        extends Structure {
            public int type;
            public int line;
            public int port;
            public int irq;
            public int flags;
            public int xmit_fifo_size;
            public int custom_divisor;
            public int baud_base;
            public short close_delay;
            public short io_type;
            public int hub6;
            public short closing_wait;
            public short closing_wait2;
            public Pointer iomem_base;
            public short iomem_reg_shift;
            public int port_high;
            public NativeLong iomap_base;

            protected List getFieldOrder() {
                return Arrays.asList("type", "line", "port", "irq", "flags", "xmit_fifo_size", "custom_divisor", "baud_base", "close_delay", "io_type", "hub6", "closing_wait", "closing_wait2", "iomem_base", "iomem_reg_shift", "port_high", "iomap_base");
            }
        }

        public static class pollfd
        extends Structure {
            public int fd;
            public short events;
            public short revents;

            protected List getFieldOrder() {
                return Arrays.asList("fd", "events", "revents");
            }

            public pollfd(Pollfd pfd) {
                this.fd = pfd.fd;
                this.events = pfd.events;
                this.revents = pfd.revents;
            }
        }

        public static class timeval
        extends Structure {
            public NativeLong tv_sec;
            public NativeLong tv_usec;

            protected List getFieldOrder() {
                return Arrays.asList("tv_sec", "tv_usec");
            }

            public timeval(TimeVal timeout) {
                this.tv_sec = new NativeLong(timeout.tv_sec);
                this.tv_usec = new NativeLong(timeout.tv_usec);
            }
        }
    }

    public static class Linux_C_lib_DirectMapping
    implements Linux_C_lib {
        public native long memcpy(int[] var1, short[] var2, long var3);

        public native int memcpy(int[] var1, short[] var2, int var3);

        public native int pipe(int[] var1);

        public native int tcdrain(int var1);

        public native void cfmakeraw(Linux_C_lib.termios var1);

        public native int fcntl(int var1, int var2, int var3);

        public native int ioctl(int var1, int var2, int[] var3);

        public native int ioctl(int var1, int var2, Linux_C_lib.serial_struct var3);

        public native int open(String var1, int var2);

        public native int close(int var1);

        public native int tcgetattr(int var1, Linux_C_lib.termios var2);

        public native int tcsetattr(int var1, int var2, Linux_C_lib.termios var3);

        public native int cfsetispeed(Linux_C_lib.termios var1, NativeLong var2);

        public native int cfsetospeed(Linux_C_lib.termios var1, NativeLong var2);

        public native NativeLong cfgetispeed(Linux_C_lib.termios var1);

        public native NativeLong cfgetospeed(Linux_C_lib.termios var1);

        public native int write(int var1, byte[] var2, int var3);

        public native int read(int var1, byte[] var2, int var3);

        public native long write(int var1, byte[] var2, long var3);

        public native long read(int var1, byte[] var2, long var3);

        public native int select(int var1, int[] var2, int[] var3, int[] var4, Linux_C_lib.timeval var5);

        public native int poll(int[] var1, int var2, int var3);

        public int poll(Linux_C_lib.pollfd[] fds, int nfds, int timeout) {
            throw new IllegalArgumentException();
        }

        public native int tcflush(int var1, int var2);

        public native void perror(String var1);

        public native int tcsendbreak(int var1, int var2);

        static {
            try {
                Native.register((String)"c");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

