/*
 * Decompiled with CFR 0.152.
 */
package net.corda.finance.contracts;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.serialization.CordaSerializable;
import net.corda.finance.contracts.DateRollConvention;
import net.corda.finance.contracts.DateRollDirection;
import net.corda.finance.contracts.DayCountBasisDay;
import net.corda.finance.contracts.DayCountBasisYear;
import net.corda.finance.contracts.Frequency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CordaSerializable
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0004H\u0016J\u001e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0010J\u0011\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lnet/corda/finance/contracts/BusinessCalendar;", "", "holidayDates", "Ljava/util/SortedSet;", "Ljava/time/LocalDate;", "(Ljava/util/SortedSet;)V", "getHolidayDates", "()Ljava/util/SortedSet;", "applyRollConvention", "testDate", "dateRollConvention", "Lnet/corda/finance/contracts/DateRollConvention;", "equals", "", "other", "hashCode", "", "isWorkingDay", "date", "moveBusinessDays", "direction", "Lnet/corda/finance/contracts/DateRollDirection;", "i", "plus", "toString", "", "Companion", "contracts"})
public class BusinessCalendar {
    @NotNull
    private final SortedSet<LocalDate> holidayDates;
    @JvmField
    @NotNull
    public static final BusinessCalendar EMPTY;
    public static final Companion Companion;

    @NotNull
    public final BusinessCalendar plus(@NotNull BusinessCalendar other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return new BusinessCalendar(CollectionsKt.toSortedSet((Iterable)SetsKt.plus((Set)this.holidayDates, (Iterable)other.holidayDates)));
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof BusinessCalendar && Intrinsics.areEqual(this.holidayDates, ((BusinessCalendar)other).holidayDates);
    }

    public int hashCode() {
        return this.holidayDates.hashCode();
    }

    public boolean isWorkingDay(@NotNull LocalDate date) {
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        return date.getDayOfWeek() == DayOfWeek.SATURDAY ? false : (date.getDayOfWeek() == DayOfWeek.SUNDAY ? false : !this.holidayDates.contains(date));
    }

    @NotNull
    public LocalDate applyRollConvention(@NotNull LocalDate testDate, @NotNull DateRollConvention dateRollConvention) {
        Intrinsics.checkParameterIsNotNull((Object)testDate, (String)"testDate");
        Intrinsics.checkParameterIsNotNull((Object)((Object)dateRollConvention), (String)"dateRollConvention");
        if (dateRollConvention == DateRollConvention.Actual) {
            return testDate;
        }
        long direction = ((DateRollDirection)((Object)dateRollConvention.getDirection().invoke())).getValue();
        LocalDate trialDate = testDate;
        while (!this.isWorkingDay(trialDate)) {
            Intrinsics.checkExpressionValueIsNotNull((Object)trialDate.plusDays(direction), (String)"trialDate.plusDays(direction)");
        }
        if (dateRollConvention.isModified() && testDate.getMonth() != trialDate.getMonth()) {
            direction = -direction;
            trialDate = testDate;
            while (!this.isWorkingDay(trialDate)) {
                Intrinsics.checkExpressionValueIsNotNull((Object)trialDate.plusDays(direction), (String)"trialDate.plusDays(direction)");
            }
        }
        return trialDate;
    }

    @NotNull
    public final LocalDate moveBusinessDays(@NotNull LocalDate date, @NotNull DateRollDirection direction, int i) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
        Intrinsics.checkParameterIsNotNull((Object)((Object)direction), (String)"direction");
        boolean bl2 = bl = i >= 0;
        if (!bl) {
            String string = "Days to add/subtract must be positive";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (i == 0) {
            return date;
        }
        LocalDate retDate = date;
        int ctr = 0;
        while (ctr < i) {
            Intrinsics.checkExpressionValueIsNotNull((Object)retDate.plusDays(direction.getValue()), (String)"retDate.plusDays(direction.value)");
            if (!this.isWorkingDay(retDate)) continue;
            ++ctr;
        }
        return retDate;
    }

    @NotNull
    public String toString() {
        return "BusinessCalendar(" + this.holidayDates + ')';
    }

    @NotNull
    public final SortedSet<LocalDate> getHolidayDates() {
        return this.holidayDates;
    }

    public BusinessCalendar(@NotNull SortedSet<LocalDate> holidayDates) {
        Intrinsics.checkParameterIsNotNull(holidayDates, (String)"holidayDates");
        this.holidayDates = holidayDates;
    }

    static {
        Companion = new Companion(null);
        SortedSet<LocalDate> sortedSet = Collections.emptySortedSet();
        Intrinsics.checkExpressionValueIsNotNull(sortedSet, (String)"emptySortedSet()");
        EMPTY = new BusinessCalendar(sortedSet);
    }

    @JvmStatic
    public static final int calculateDaysBetween(@NotNull LocalDate startDate, @NotNull LocalDate endDate, @NotNull DayCountBasisYear dcbYear, @NotNull DayCountBasisDay dcbDay) {
        return Companion.calculateDaysBetween(startDate, endDate, dcbYear, dcbDay);
    }

    @JvmStatic
    @NotNull
    public static final LocalDate parseDateFromString(@NotNull String it) {
        return Companion.parseDateFromString(it);
    }

    @JvmStatic
    @NotNull
    public static final List<LocalDate> createGenericSchedule(@NotNull LocalDate startDate, @NotNull Frequency period, @NotNull BusinessCalendar calendar, @NotNull DateRollConvention dateRollConvention, int noOfAdditionalPeriods, @Nullable LocalDate endDate, @Nullable Integer periodOffset) {
        return Companion.createGenericSchedule(startDate, period, calendar, dateRollConvention, noOfAdditionalPeriods, endDate, periodOffset);
    }

    @JvmStatic
    @NotNull
    public static final LocalDate getOffsetDate(@NotNull LocalDate startDate, @NotNull Frequency period, int steps) {
        return Companion.getOffsetDate(startDate, period, steps);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007JY\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0002\u0010\u0017J\"\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0019\u001a\u00020\u0006H\u0007J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lnet/corda/finance/contracts/BusinessCalendar$Companion;", "", "()V", "EMPTY", "Lnet/corda/finance/contracts/BusinessCalendar;", "calculateDaysBetween", "", "startDate", "Ljava/time/LocalDate;", "endDate", "dcbYear", "Lnet/corda/finance/contracts/DayCountBasisYear;", "dcbDay", "Lnet/corda/finance/contracts/DayCountBasisDay;", "createGenericSchedule", "", "period", "Lnet/corda/finance/contracts/Frequency;", "calendar", "dateRollConvention", "Lnet/corda/finance/contracts/DateRollConvention;", "noOfAdditionalPeriods", "periodOffset", "(Ljava/time/LocalDate;Lnet/corda/finance/contracts/Frequency;Lnet/corda/finance/contracts/BusinessCalendar;Lnet/corda/finance/contracts/DateRollConvention;ILjava/time/LocalDate;Ljava/lang/Integer;)Ljava/util/List;", "getOffsetDate", "steps", "parseDateFromString", "it", "", "contracts"})
    public static final class Companion {
        @JvmStatic
        public final int calculateDaysBetween(@NotNull LocalDate startDate, @NotNull LocalDate endDate, @NotNull DayCountBasisYear dcbYear, @NotNull DayCountBasisDay dcbDay) {
            int n;
            Intrinsics.checkParameterIsNotNull((Object)startDate, (String)"startDate");
            Intrinsics.checkParameterIsNotNull((Object)endDate, (String)"endDate");
            Intrinsics.checkParameterIsNotNull((Object)((Object)dcbYear), (String)"dcbYear");
            Intrinsics.checkParameterIsNotNull((Object)((Object)dcbDay), (String)"dcbDay");
            if (dcbDay == DayCountBasisDay.DActual) {
                n = (int)(endDate.toEpochDay() - startDate.toEpochDay());
            } else if (dcbDay == DayCountBasisDay.D30 && dcbYear == DayCountBasisYear.Y360) {
                n = (int)((double)(endDate.getYear() - startDate.getYear()) * 360.0 + (double)(endDate.getMonthValue() - startDate.getMonthValue()) * 30.0 + (double)endDate.getDayOfMonth() - (double)startDate.getDayOfMonth());
            } else {
                String string = "Can't calculate days using convention " + (Object)((Object)dcbDay) + " / " + (Object)((Object)dcbYear);
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
            return n;
        }

        @JvmStatic
        @NotNull
        public final LocalDate parseDateFromString(@NotNull String it) {
            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
            LocalDate localDate = LocalDate.parse(it, DateTimeFormatter.ISO_LOCAL_DATE);
            Intrinsics.checkExpressionValueIsNotNull((Object)localDate, (String)"LocalDate.parse(it, Date\u2026Formatter.ISO_LOCAL_DATE)");
            return localDate;
        }

        @JvmStatic
        @NotNull
        public final List<LocalDate> createGenericSchedule(@NotNull LocalDate startDate, @NotNull Frequency period, @NotNull BusinessCalendar calendar, @NotNull DateRollConvention dateRollConvention, int noOfAdditionalPeriods, @Nullable LocalDate endDate, @Nullable Integer periodOffset) {
            LocalDate localDate;
            Intrinsics.checkParameterIsNotNull((Object)startDate, (String)"startDate");
            Intrinsics.checkParameterIsNotNull((Object)((Object)period), (String)"period");
            Intrinsics.checkParameterIsNotNull((Object)calendar, (String)"calendar");
            Intrinsics.checkParameterIsNotNull((Object)((Object)dateRollConvention), (String)"dateRollConvention");
            ArrayList<LocalDate> ret = new ArrayList<LocalDate>();
            int ctr = 0;
            LocalDate currentDate = startDate;
            do {
                currentDate = net.corda.finance.contracts.BusinessCalendar$Companion.getOffsetDate$default(this, currentDate, period, 0, 4, null);
                if (periodOffset == null || periodOffset <= ctr) {
                    ret.add(calendar.applyRollConvention(currentDate, dateRollConvention));
                }
                if (++ctr > noOfAdditionalPeriods) break;
                localDate = endDate;
            } while (currentDate.compareTo(localDate != null ? (ChronoLocalDate)localDate : (ChronoLocalDate)currentDate) < 0);
            return ret;
        }

        @JvmStatic
        @NotNull
        public static /* bridge */ /* synthetic */ List createGenericSchedule$default(Companion companion, LocalDate localDate, Frequency frequency, BusinessCalendar businessCalendar, DateRollConvention dateRollConvention, int n, LocalDate localDate2, Integer n2, int n3, Object object) {
            if ((n3 & 4) != 0) {
                businessCalendar = EMPTY;
            }
            if ((n3 & 8) != 0) {
                dateRollConvention = DateRollConvention.Following;
            }
            if ((n3 & 0x10) != 0) {
                n = Integer.MAX_VALUE;
            }
            if ((n3 & 0x20) != 0) {
                localDate2 = null;
            }
            if ((n3 & 0x40) != 0) {
                n2 = null;
            }
            return companion.createGenericSchedule(localDate, frequency, businessCalendar, dateRollConvention, n, localDate2, n2);
        }

        @JvmStatic
        @NotNull
        public final LocalDate getOffsetDate(@NotNull LocalDate startDate, @NotNull Frequency period, int steps) {
            Intrinsics.checkParameterIsNotNull((Object)startDate, (String)"startDate");
            Intrinsics.checkParameterIsNotNull((Object)((Object)period), (String)"period");
            if (steps == 0) {
                return startDate;
            }
            return (LocalDate)period.getOffset().invoke((Object)startDate, (Object)steps);
        }

        @JvmStatic
        @NotNull
        public static /* bridge */ /* synthetic */ LocalDate getOffsetDate$default(Companion companion, LocalDate localDate, Frequency frequency, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 1;
            }
            return companion.getOffsetDate(localDate, frequency, n);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

