/*
 * Decompiled with CFR 0.152.
 */
package purejavacomm.testsuite;

import purejavacomm.SerialPortEvent;
import purejavacomm.SerialPortEventListener;
import purejavacomm.testsuite.TestBase;

public class Test1
extends TestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void run() throws Exception {
        try {
            Test1.begin("Test1 - control lines ");
            Test1.openPort();
            m_Port.setRTS(false);
            m_Port.setDTR(false);
            Test1.sleep();
            m_Port.notifyOnCTS(true);
            m_Port.notifyOnRingIndicator(true);
            m_Port.notifyOnCarrierDetect(true);
            m_Port.notifyOnDSR(true);
            final int[] counts = new int[11];
            m_Port.addEventListener(new SerialPortEventListener(){

                public void serialEvent(SerialPortEvent event) {
                    try {
                        if (event.getEventType() == 3) {
                            counts[3] = counts[3] + 1;
                        }
                        if (event.getEventType() == 5) {
                            counts[5] = counts[5] + 1;
                        }
                        if (event.getEventType() == 6) {
                            counts[6] = counts[6] + 1;
                        }
                        if (event.getEventType() == 4) {
                            counts[4] = counts[4] + 1;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            int N = 128;
            for (int i = 0; i < N; ++i) {
                m_Port.setRTS((i & 1) != 0);
                m_Port.setDTR((i & 2) != 0);
                Test1.sleep();
            }
            if (counts[3] != N - 1) {
                Test1.fail("CTS loopback failed, expected %d toggles, got %d", N - 1, counts[3]);
            }
            if (counts[4] != N / 2 - 1) {
                Test1.fail("DSR loopback failed, expected %d toggles, got %d", N / 2 - 1, counts[4]);
            }
            if (counts[5] != N - 1) {
                Test1.fail("RI loopback failed, expected %d toggles, got %d", N - 1, counts[5]);
            }
            if (counts[6] != N / 2 - 1) {
                Test1.fail("CTS loopback failed, expected %d toggles, got %d", N / 2 - 1, counts[6]);
            }
            Test1.finishedOK();
        }
        finally {
            Test1.closePort();
        }
    }
}

