/*
 * Decompiled with CFR 0.152.
 */
package jtermios.freebsd;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Structure;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import jtermios.FDSet;
import jtermios.JTermios;
import jtermios.Pollfd;
import jtermios.Termios;
import jtermios.TimeVal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTermiosImpl
implements JTermios.JTermiosInterface {
    private static String DEVICE_DIR_PATH = "/dev/";
    static FreeBSD_C_lib m_Clib = (FreeBSD_C_lib)Native.loadLibrary((String)"c", FreeBSD_C_lib.class);

    public JTermiosImpl() {
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "instantiating %s\n", this.getClass().getCanonicalName());
        JTermios.FIONREAD = 1074030207;
        JTermios.O_RDWR = 2;
        JTermios.O_NONBLOCK = 4;
        JTermios.O_NOCTTY = 32768;
        JTermios.O_NDELAY = 4;
        JTermios.F_GETFL = 3;
        JTermios.F_SETFL = 4;
        JTermios.EAGAIN = 35;
        JTermios.EBADF = 9;
        JTermios.EACCES = 22;
        JTermios.EEXIST = 17;
        JTermios.EINTR = 4;
        JTermios.EINVAL = 22;
        JTermios.EIO = 5;
        JTermios.EISDIR = 21;
        JTermios.ELOOP = 62;
        JTermios.EMFILE = 24;
        JTermios.ENAMETOOLONG = 63;
        JTermios.ENFILE = 23;
        JTermios.ENOENT = 2;
        JTermios.ENOSPC = 28;
        JTermios.ENOTDIR = 20;
        JTermios.ENXIO = 6;
        JTermios.EOVERFLOW = 84;
        JTermios.EROFS = 30;
        JTermios.ENOTSUP = 45;
        JTermios.TIOCM_RNG = 128;
        JTermios.TIOCM_CAR = 64;
        JTermios.IGNBRK = 1;
        JTermios.BRKINT = 2;
        JTermios.PARMRK = 8;
        JTermios.INLCR = 64;
        JTermios.IGNCR = 128;
        JTermios.ICRNL = 256;
        JTermios.ECHONL = 16;
        JTermios.IEXTEN = 1024;
        JTermios.CLOCAL = 32768;
        JTermios.OPOST = 1;
        JTermios.VSTART = 12;
        JTermios.TCSANOW = 0;
        JTermios.VSTOP = 13;
        JTermios.VMIN = 16;
        JTermios.VTIME = 17;
        JTermios.VEOF = 0;
        JTermios.TIOCMGET = 1074033770;
        JTermios.TIOCM_CTS = 32;
        JTermios.TIOCM_DSR = 256;
        JTermios.TIOCM_RI = 128;
        JTermios.TIOCM_CD = 64;
        JTermios.TIOCM_DTR = 2;
        JTermios.TIOCM_RTS = 4;
        JTermios.ICANON = 256;
        JTermios.ECHO = 8;
        JTermios.ECHOE = 2;
        JTermios.ISIG = 128;
        JTermios.TIOCMSET = -2147191699;
        JTermios.IXON = 512;
        JTermios.IXOFF = 1024;
        JTermios.IXANY = 2048;
        JTermios.CRTSCTS = 196608;
        JTermios.TCSADRAIN = 1;
        JTermios.INPCK = 16;
        JTermios.ISTRIP = 32;
        JTermios.CSIZE = 768;
        JTermios.TCIFLUSH = 1;
        JTermios.TCOFLUSH = 2;
        JTermios.TCIOFLUSH = 3;
        JTermios.CS5 = 0;
        JTermios.CS6 = 256;
        JTermios.CS7 = 512;
        JTermios.CS8 = 768;
        JTermios.CSTOPB = 1024;
        JTermios.CREAD = 2048;
        JTermios.PARENB = 4096;
        JTermios.PARODD = 8192;
        JTermios.B0 = 0;
        JTermios.B50 = 50;
        JTermios.B75 = 75;
        JTermios.B110 = 110;
        JTermios.B134 = 134;
        JTermios.B150 = 150;
        JTermios.B200 = 200;
        JTermios.B300 = 300;
        JTermios.B600 = 600;
        JTermios.B1200 = 600;
        JTermios.B1800 = 1800;
        JTermios.B2400 = 2400;
        JTermios.B4800 = 4800;
        JTermios.B9600 = 9600;
        JTermios.B19200 = 19200;
        JTermios.B38400 = 38400;
        JTermios.B7200 = 7200;
        JTermios.B14400 = 14400;
        JTermios.B28800 = 28800;
        JTermios.B57600 = 57600;
        JTermios.B76800 = 76800;
        JTermios.B115200 = 115200;
        JTermios.B230400 = 230400;
        JTermios.POLLIN = 1;
        JTermios.POLLPRI = (short)2;
        JTermios.POLLOUT = (short)4;
        JTermios.POLLERR = (short)8;
        JTermios.POLLNVAL = (short)32;
    }

    @Override
    public int errno() {
        return Native.getLastError();
    }

    @Override
    public void cfmakeraw(Termios termios2) {
        FreeBSD_C_lib.termios t = new FreeBSD_C_lib.termios(termios2);
        m_Clib.cfmakeraw(t);
        t.update(termios2);
    }

    public int fcntl(int fd, int cmd, int[] arg) {
        return m_Clib.fcntl(fd, cmd, arg);
    }

    @Override
    public int fcntl(int fd, int cmd, int arg) {
        return m_Clib.fcntl(fd, cmd, arg);
    }

    @Override
    public int tcdrain(int fd) {
        return m_Clib.tcdrain(fd);
    }

    @Override
    public int cfgetispeed(Termios termios2) {
        return m_Clib.cfgetispeed(new FreeBSD_C_lib.termios(termios2)).intValue();
    }

    @Override
    public int cfgetospeed(Termios termios2) {
        return m_Clib.cfgetospeed(new FreeBSD_C_lib.termios(termios2)).intValue();
    }

    @Override
    public int cfsetispeed(Termios termios2, int speed) {
        FreeBSD_C_lib.termios t = new FreeBSD_C_lib.termios(termios2);
        int ret = m_Clib.cfsetispeed(t, new NativeLong((long)speed));
        t.update(termios2);
        return ret;
    }

    @Override
    public int cfsetospeed(Termios termios2, int speed) {
        FreeBSD_C_lib.termios t = new FreeBSD_C_lib.termios(termios2);
        int ret = m_Clib.cfsetospeed(t, new NativeLong((long)speed));
        t.update(termios2);
        return ret;
    }

    @Override
    public int open(String s, int t) {
        if (s != null && !s.startsWith("/")) {
            s = DEVICE_DIR_PATH + s;
        }
        return m_Clib.open(s, t);
    }

    @Override
    public int read(int fd, byte[] buffer, int len) {
        return m_Clib.read(fd, ByteBuffer.wrap(buffer), new NativeLong((long)len)).intValue();
    }

    @Override
    public int write(int fd, byte[] buffer, int len) {
        return m_Clib.write(fd, ByteBuffer.wrap(buffer), new NativeLong((long)len)).intValue();
    }

    @Override
    public int close(int fd) {
        return m_Clib.close(fd);
    }

    @Override
    public int tcflush(int fd, int b) {
        return m_Clib.tcflush(fd, b);
    }

    @Override
    public int tcgetattr(int fd, Termios termios2) {
        FreeBSD_C_lib.termios t = new FreeBSD_C_lib.termios();
        int ret = m_Clib.tcgetattr(fd, t);
        t.update(termios2);
        return ret;
    }

    @Override
    public void perror(String msg) {
        m_Clib.perror(msg);
    }

    @Override
    public int tcsendbreak(int fd, int duration) {
        return m_Clib.tcsendbreak(fd, duration / 250);
    }

    @Override
    public int tcsetattr(int fd, int cmd, Termios termios2) {
        return m_Clib.tcsetattr(fd, cmd, new FreeBSD_C_lib.termios(termios2));
    }

    @Override
    public void FD_CLR(int fd, FDSet set) {
        if (set == null) {
            return;
        }
        FDSetImpl p = (FDSetImpl)set;
        int i = fd / FDSetImpl.NFBBITS;
        p.bits[i] = new NativeLong(p.bits[i].longValue() & (long)(~(1 << fd % FDSetImpl.NFBBITS)));
    }

    @Override
    public boolean FD_ISSET(int fd, FDSet set) {
        if (set == null) {
            return false;
        }
        FDSetImpl p = (FDSetImpl)set;
        int i = fd / FDSetImpl.NFBBITS;
        return (p.bits[i].longValue() & (long)(1 << fd % FDSetImpl.NFBBITS)) != 0L;
    }

    @Override
    public void FD_SET(int fd, FDSet set) {
        if (set == null) {
            return;
        }
        FDSetImpl p = (FDSetImpl)set;
        int i = fd / FDSetImpl.NFBBITS;
        p.bits[i] = new NativeLong(p.bits[i].longValue() | (long)(1 << fd % FDSetImpl.NFBBITS));
    }

    @Override
    public void FD_ZERO(FDSet set) {
        if (set == null) {
            return;
        }
        FDSetImpl p = (FDSetImpl)set;
        Arrays.fill(p.bits, new NativeLong(0L));
    }

    @Override
    public int select(int nfds, FDSet rfds, FDSet wfds, FDSet efds, TimeVal timeout) {
        FreeBSD_C_lib.timeval tout = null;
        if (timeout != null) {
            tout = new FreeBSD_C_lib.timeval(timeout);
        }
        NativeLong[] r = rfds != null ? ((FDSetImpl)rfds).bits : null;
        NativeLong[] w = wfds != null ? ((FDSetImpl)wfds).bits : null;
        NativeLong[] e = efds != null ? ((FDSetImpl)efds).bits : null;
        return m_Clib.select(nfds, r, w, e, tout);
    }

    @Override
    public int poll(Pollfd[] fds, int nfds, int timeout) {
        FreeBSD_C_lib.pollfd[] pfds = new FreeBSD_C_lib.pollfd[fds.length];
        for (int i = 0; i < nfds; ++i) {
            pfds[i] = new FreeBSD_C_lib.pollfd(fds[i]);
        }
        int ret = m_Clib.poll(pfds, nfds, timeout);
        for (int i = 0; i < nfds; ++i) {
            fds[i].revents = pfds[i].revents;
        }
        return ret;
    }

    @Override
    public int poll(int[] fds, int nfds, int timeout) {
        return m_Clib.poll(fds, nfds, timeout);
    }

    @Override
    public FDSet newFDSet() {
        return new FDSetImpl();
    }

    @Override
    public int ioctl(int fd, int cmd, int[] data) {
        return m_Clib.ioctl(fd, cmd, data);
    }

    @Override
    public List<String> getPortList() {
        File dir = new File(DEVICE_DIR_PATH);
        if (!dir.isDirectory()) {
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "device directory %s does not exist\n", DEVICE_DIR_PATH);
            return null;
        }
        String[] devs = dir.list();
        LinkedList<String> list = new LinkedList<String>();
        if (devs != null) {
            for (int i = 0; i < devs.length; ++i) {
                String s = devs[i];
                if (!s.startsWith("cua") && !s.startsWith("tty")) continue;
                list.add(s);
            }
        }
        return list;
    }

    @Override
    public void shutDown() {
    }

    @Override
    public String getPortNamePattern() {
        return "^(tty\\.|cu\\.).*";
    }

    @Override
    public int setspeed(int fd, Termios termios2, int speed) {
        int r = this.cfsetispeed(termios2, speed);
        if (r == 0) {
            r = this.cfsetospeed(termios2, speed);
        }
        if (r == 0) {
            r = this.tcsetattr(fd, JTermios.TCSANOW, termios2);
        }
        return r;
    }

    @Override
    public int pipe(int[] fds) {
        return m_Clib.pipe(fds);
    }

    private static class FDSetImpl
    extends FDSet {
        static final int FD_SET_SIZE = 1024;
        static final int NFBBITS = NativeLong.SIZE * 8;
        NativeLong[] bits = new NativeLong[(1024 + NFBBITS - 1) / NFBBITS];

        private FDSetImpl() {
        }

        public String toString() {
            return String.format("%08X%08X", this.bits[0], this.bits[1]);
        }
    }

    public static interface FreeBSD_C_lib
    extends Library {
        public int pipe(int[] var1);

        public int tcdrain(int var1);

        public void cfmakeraw(termios var1);

        public int fcntl(int var1, int var2, int[] var3);

        public int fcntl(int var1, int var2, int var3);

        public int ioctl(int var1, int var2, int[] var3);

        public int open(String var1, int var2);

        public int close(int var1);

        public int tcgetattr(int var1, termios var2);

        public int tcsetattr(int var1, int var2, termios var3);

        public int cfsetispeed(termios var1, NativeLong var2);

        public int cfsetospeed(termios var1, NativeLong var2);

        public NativeLong cfgetispeed(termios var1);

        public NativeLong cfgetospeed(termios var1);

        public NativeLong write(int var1, ByteBuffer var2, NativeLong var3);

        public NativeLong read(int var1, ByteBuffer var2, NativeLong var3);

        public int select(int var1, NativeLong[] var2, NativeLong[] var3, NativeLong[] var4, timeval var5);

        public int poll(pollfd[] var1, int var2, int var3);

        public int poll(int[] var1, int var2, int var3);

        public int tcflush(int var1, int var2);

        public void perror(String var1);

        public int tcsendbreak(int var1, int var2);

        public static class termios
        extends Structure {
            public int c_iflag;
            public int c_oflag;
            public int c_cflag;
            public int c_lflag;
            public byte[] c_cc = new byte[20];
            public int c_ispeed;
            public int c_ospeed;

            protected List getFieldOrder() {
                return Arrays.asList("c_iflag", "c_oflag", "c_cflag", "c_lflag", "c_cc", "c_ispeed", "c_ospeed");
            }

            public termios() {
            }

            public termios(Termios t) {
                this.c_iflag = t.c_iflag;
                this.c_oflag = t.c_oflag;
                this.c_cflag = t.c_cflag;
                this.c_lflag = t.c_lflag;
                System.arraycopy(t.c_cc, 0, this.c_cc, 0, t.c_cc.length);
                this.c_ispeed = t.c_ispeed;
                this.c_ospeed = t.c_ospeed;
            }

            public void update(Termios t) {
                t.c_iflag = this.c_iflag;
                t.c_oflag = this.c_oflag;
                t.c_cflag = this.c_cflag;
                t.c_lflag = this.c_lflag;
                System.arraycopy(this.c_cc, 0, t.c_cc, 0, t.c_cc.length);
                t.c_ispeed = this.c_ispeed;
                t.c_ospeed = this.c_ospeed;
            }
        }

        public static class pollfd
        extends Structure {
            public int fd;
            public short events;
            public short revents;

            protected List getFieldOrder() {
                return Arrays.asList("fd", "events", "revents");
            }

            public pollfd(Pollfd pfd) {
                this.fd = pfd.fd;
                this.events = pfd.events;
                this.revents = pfd.revents;
            }
        }

        public static class timeval
        extends Structure {
            public NativeLong tv_sec;
            public NativeLong tv_usec;

            protected List getFieldOrder() {
                return Arrays.asList("tv_sec", "tv_usec");
            }

            public timeval(TimeVal timeout) {
                this.tv_sec = new NativeLong(timeout.tv_sec);
                this.tv_usec = new NativeLong(timeout.tv_usec);
            }
        }
    }
}

