/*
 * Decompiled with CFR 0.152.
 */
package net.corda.finance.contracts;

import java.security.PublicKey;
import java.time.Instant;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.contracts.Amount;
import net.corda.core.contracts.CommandAndState;
import net.corda.core.contracts.CommandData;
import net.corda.core.contracts.CommandWithParties;
import net.corda.core.contracts.Contract;
import net.corda.core.contracts.ContractsDSL;
import net.corda.core.contracts.Issued;
import net.corda.core.contracts.OwnableState;
import net.corda.core.contracts.PartyAndReference;
import net.corda.core.contracts.Requirements;
import net.corda.core.contracts.TimeWindow;
import net.corda.core.contracts.TypeOnlyCommandData;
import net.corda.core.crypto.CryptoUtils;
import net.corda.core.crypto.NullKeys;
import net.corda.core.identity.AbstractParty;
import net.corda.core.internal.Emoji;
import net.corda.core.schemas.MappedSchema;
import net.corda.core.schemas.PersistentState;
import net.corda.core.schemas.QueryableState;
import net.corda.core.transactions.LedgerTransaction;
import net.corda.finance.contracts.CommercialPaper;
import net.corda.finance.contracts.ICommercialPaperState;
import net.corda.finance.contracts.utils.StateSumming;
import net.corda.finance.schemas.CommercialPaperSchemaV1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \b2\u00020\u0001:\u0003\u0007\b\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lnet/corda/finance/contracts/CommercialPaper;", "Lnet/corda/core/contracts/Contract;", "()V", "verify", "", "tx", "Lnet/corda/core/transactions/LedgerTransaction;", "Commands", "Companion", "State", "contracts"})
public final class CommercialPaper
implements Contract {
    @NotNull
    public static final String CP_PROGRAM_ID = "net.corda.finance.contracts.CommercialPaper";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public void verify(@NotNull LedgerTransaction tx) {
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
        LedgerTransaction ledgerTransaction = tx;
        Function1 selector$iv = verify.groups.1.INSTANCE;
        List groups2 = this_$iv.groupStates(State.class, selector$iv);
        Collection $receiver$iv = tx.getCommands();
        CommandWithParties command = ContractsDSL.requireSingleCommand((Collection)$receiver$iv, Commands.class);
        TimeWindow timeWindow = tx.getTimeWindow();
        for (LedgerTransaction.InOutGroup inOutGroup : groups2) {
            String $receiver;
            State input;
            List inputs = inOutGroup.component1();
            List outputs = inOutGroup.component2();
            State key = (State)inOutGroup.component3();
            Commands commands = (Commands)command.getValue();
            if (commands instanceof Commands.Move) {
                String $receiver$iv2;
                input = (State)CollectionsKt.single((List)inputs);
                Requirements $receiver2 = Requirements.INSTANCE;
                String string = "the transaction is signed by the owner of the CP";
                Requirements requirements = $receiver2;
                boolean expr$iv = command.getSigners().contains(input.getOwner().getOwningKey());
                if (!expr$iv) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv2);
                }
                $receiver$iv2 = "the state is propagated";
                Requirements this_$iv2 = $receiver2;
                expr$iv = outputs.size() == 1;
                if (expr$iv) continue;
                throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv2);
            }
            if (commands instanceof Commands.Redeem) {
                String $receiver$iv3;
                boolean expr$iv;
                input = (State)CollectionsKt.single((List)inputs);
                Amount<Issued<Currency>> received = StateSumming.sumCashBy(tx.getOutputStates(), input.getOwner());
                Object object = timeWindow;
                if (object == null || (object = object.getFromTime()) == null) {
                    throw (Throwable)new IllegalArgumentException("Redemptions must have a time-window");
                }
                Object time = object;
                $receiver = Requirements.INSTANCE;
                String expr$iv2 = "the paper must have matured";
                String $i$f$using = $receiver;
                boolean bl = expr$iv = ((Instant)time).compareTo(input.getMaturityDate()) >= 0;
                if (!expr$iv) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv3);
                }
                $receiver$iv3 = "the received amount equals the face value";
                String this_$iv3 = $receiver;
                expr$iv = Intrinsics.areEqual(received, input.getFaceValue());
                if (!expr$iv) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv3);
                }
                $receiver$iv3 = "the paper must be destroyed";
                this_$iv3 = $receiver;
                expr$iv = outputs.isEmpty();
                if (!expr$iv) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv3);
                }
                $receiver$iv3 = "the transaction is signed by the owner of the CP";
                this_$iv3 = $receiver;
                expr$iv = command.getSigners().contains(input.getOwner().getOwningKey());
                if (expr$iv) continue;
                throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv3);
            }
            if (commands instanceof Commands.Issue) {
                String $receiver$iv4;
                boolean expr$iv;
                State output = (State)CollectionsKt.single((List)outputs);
                Object object = timeWindow;
                if (object == null || (object = object.getUntilTime()) == null) {
                    throw (Throwable)new IllegalArgumentException("Issuances have a time-window");
                }
                Object time = object;
                Requirements $receiver3 = Requirements.INSTANCE;
                $receiver = "output states are issued by a command signer";
                Requirements $receiver$iv5 = $receiver3;
                boolean this_$iv4 = command.getSigners().contains(output.getIssuance().getParty().getOwningKey());
                if (!expr$iv) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv4);
                }
                $receiver$iv4 = "output values sum to more than the inputs";
                Requirements this_$iv5 = $receiver3;
                boolean bl = expr$iv = output.getFaceValue().getQuantity() > 0L;
                if (!expr$iv) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv4);
                }
                $receiver$iv4 = "the maturity date is not in the past";
                this_$iv5 = $receiver3;
                boolean bl2 = expr$iv = ((Instant)time).compareTo(output.getMaturityDate()) < 0;
                if (!expr$iv) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv4);
                }
                $receiver$iv4 = "output values sum to more than the inputs";
                this_$iv5 = $receiver3;
                expr$iv = inputs.isEmpty();
                if (expr$iv) continue;
                throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv4);
            }
            throw (Throwable)new IllegalArgumentException("Unrecognised command");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B1\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J\u0015\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\rH\u00c6\u0003J=\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u00d6\u0003J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\t\u0010(\u001a\u00020)H\u00d6\u0001J\u0011\u0010*\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007H\u0086\u0004J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020'0,H\u0016J\b\u0010-\u001a\u00020.H\u0016J\u001c\u0010/\u001a\u00020\u00032\u0012\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tH\u0016J\u0010\u00101\u001a\u00020\u00032\u0006\u00102\u001a\u00020\rH\u0016J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0007H\u0016J\u0010\u00106\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u0007H\u0016J\u0006\u00107\u001a\u00020\u0000R\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00068"}, d2={"Lnet/corda/finance/contracts/CommercialPaper$State;", "Lnet/corda/core/contracts/OwnableState;", "Lnet/corda/core/schemas/QueryableState;", "Lnet/corda/finance/contracts/ICommercialPaperState;", "issuance", "Lnet/corda/core/contracts/PartyAndReference;", "owner", "Lnet/corda/core/identity/AbstractParty;", "faceValue", "Lnet/corda/core/contracts/Amount;", "Lnet/corda/core/contracts/Issued;", "Ljava/util/Currency;", "maturityDate", "Ljava/time/Instant;", "(Lnet/corda/core/contracts/PartyAndReference;Lnet/corda/core/identity/AbstractParty;Lnet/corda/core/contracts/Amount;Ljava/time/Instant;)V", "getFaceValue", "()Lnet/corda/core/contracts/Amount;", "getIssuance", "()Lnet/corda/core/contracts/PartyAndReference;", "getMaturityDate", "()Ljava/time/Instant;", "getOwner", "()Lnet/corda/core/identity/AbstractParty;", "participants", "", "getParticipants", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "generateMappedObject", "Lnet/corda/core/schemas/PersistentState;", "schema", "Lnet/corda/core/schemas/MappedSchema;", "hashCode", "", "owned by", "supportedSchemas", "", "toString", "", "withFaceValue", "newFaceValue", "withMaturityDate", "newMaturityDate", "withNewOwner", "Lnet/corda/core/contracts/CommandAndState;", "newOwner", "withOwner", "withoutOwner", "contracts"})
    public static final class State
    implements OwnableState,
    QueryableState,
    ICommercialPaperState {
        @NotNull
        private final List<AbstractParty> participants;
        @NotNull
        private final PartyAndReference issuance;
        @NotNull
        private final AbstractParty owner;
        @NotNull
        private final Amount<Issued<Currency>> faceValue;
        @NotNull
        private final Instant maturityDate;

        @NotNull
        public List<AbstractParty> getParticipants() {
            return this.participants;
        }

        @NotNull
        public CommandAndState withNewOwner(@NotNull AbstractParty newOwner) {
            Intrinsics.checkParameterIsNotNull((Object)newOwner, (String)"newOwner");
            return new CommandAndState((CommandData)new Commands.Move(), (OwnableState)State.copy$default(this, null, newOwner, null, null, 13, null));
        }

        @NotNull
        public final State withoutOwner() {
            return State.copy$default(this, null, (AbstractParty)NullKeys.INSTANCE.getNULL_PARTY(), null, null, 13, null);
        }

        @NotNull
        public String toString() {
            return Emoji.INSTANCE.getNewspaper() + "CommercialPaper(of " + this.faceValue + " redeemable on " + this.maturityDate + " by '" + this.issuance + "', owned by " + this.getOwner() + ')';
        }

        @Override
        @NotNull
        public ICommercialPaperState withOwner(@NotNull AbstractParty newOwner) {
            Intrinsics.checkParameterIsNotNull((Object)newOwner, (String)"newOwner");
            return State.copy$default(this, null, newOwner, null, null, 13, null);
        }

        @Override
        @NotNull
        public ICommercialPaperState withFaceValue(@NotNull Amount<Issued<Currency>> newFaceValue) {
            Intrinsics.checkParameterIsNotNull(newFaceValue, (String)"newFaceValue");
            return State.copy$default(this, null, null, newFaceValue, null, 11, null);
        }

        @Override
        @NotNull
        public ICommercialPaperState withMaturityDate(@NotNull Instant newMaturityDate) {
            Intrinsics.checkParameterIsNotNull((Object)newMaturityDate, (String)"newMaturityDate");
            return State.copy$default(this, null, null, null, newMaturityDate, 7, null);
        }

        @NotNull
        public Iterable<MappedSchema> supportedSchemas() {
            return CollectionsKt.listOf((Object)((Object)CommercialPaperSchemaV1.INSTANCE));
        }

        @NotNull
        public PersistentState generateMappedObject(@NotNull MappedSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            MappedSchema mappedSchema = schema;
            if (!(mappedSchema instanceof CommercialPaperSchemaV1)) {
                throw (Throwable)new IllegalArgumentException("Unrecognised schema " + schema);
            }
            String string = CryptoUtils.toStringShort((PublicKey)this.issuance.getParty().getOwningKey());
            byte[] byArray = this.issuance.getReference().getBytes();
            String string2 = CryptoUtils.toStringShort((PublicKey)this.getOwner().getOwningKey());
            long l = this.faceValue.getQuantity();
            String string3 = ((Currency)((Issued)this.faceValue.getToken()).getProduct()).getCurrencyCode();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"this.faceValue.token.product.currencyCode");
            return new CommercialPaperSchemaV1.PersistentCommercialPaperState(string, byArray, string2, this.maturityDate, l, string3, CryptoUtils.toStringShort((PublicKey)((Issued)this.faceValue.getToken()).getIssuer().getParty().getOwningKey()), ((Issued)this.faceValue.getToken()).getIssuer().getReference().getBytes());
        }

        @NotNull
        public final State owned by(@NotNull AbstractParty owner) {
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            return State.copy$default(this, null, owner, null, null, 13, null);
        }

        @NotNull
        public final PartyAndReference getIssuance() {
            return this.issuance;
        }

        @NotNull
        public AbstractParty getOwner() {
            return this.owner;
        }

        @NotNull
        public final Amount<Issued<Currency>> getFaceValue() {
            return this.faceValue;
        }

        @NotNull
        public final Instant getMaturityDate() {
            return this.maturityDate;
        }

        public State(@NotNull PartyAndReference issuance, @NotNull AbstractParty owner, @NotNull Amount<Issued<Currency>> faceValue, @NotNull Instant maturityDate) {
            Intrinsics.checkParameterIsNotNull((Object)issuance, (String)"issuance");
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            Intrinsics.checkParameterIsNotNull(faceValue, (String)"faceValue");
            Intrinsics.checkParameterIsNotNull((Object)maturityDate, (String)"maturityDate");
            this.issuance = issuance;
            this.owner = owner;
            this.faceValue = faceValue;
            this.maturityDate = maturityDate;
            this.participants = CollectionsKt.listOf((Object)this.getOwner());
        }

        @NotNull
        public final PartyAndReference component1() {
            return this.issuance;
        }

        @NotNull
        public final AbstractParty component2() {
            return this.getOwner();
        }

        @NotNull
        public final Amount<Issued<Currency>> component3() {
            return this.faceValue;
        }

        @NotNull
        public final Instant component4() {
            return this.maturityDate;
        }

        @NotNull
        public final State copy(@NotNull PartyAndReference issuance, @NotNull AbstractParty owner, @NotNull Amount<Issued<Currency>> faceValue, @NotNull Instant maturityDate) {
            Intrinsics.checkParameterIsNotNull((Object)issuance, (String)"issuance");
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            Intrinsics.checkParameterIsNotNull(faceValue, (String)"faceValue");
            Intrinsics.checkParameterIsNotNull((Object)maturityDate, (String)"maturityDate");
            return new State(issuance, owner, faceValue, maturityDate);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ State copy$default(State state, PartyAndReference partyAndReference, AbstractParty abstractParty, Amount amount, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                partyAndReference = state.issuance;
            }
            if ((n & 2) != 0) {
                abstractParty = state.getOwner();
            }
            if ((n & 4) != 0) {
                amount = state.faceValue;
            }
            if ((n & 8) != 0) {
                instant = state.maturityDate;
            }
            return state.copy(partyAndReference, abstractParty, amount, instant);
        }

        public int hashCode() {
            PartyAndReference partyAndReference = this.issuance;
            AbstractParty abstractParty = this.getOwner();
            Amount<Issued<Currency>> amount = this.faceValue;
            Instant instant = this.maturityDate;
            return (((partyAndReference != null ? partyAndReference.hashCode() : 0) * 31 + (abstractParty != null ? abstractParty.hashCode() : 0)) * 31 + (amount != null ? amount.hashCode() : 0)) * 31 + (instant != null ? ((Object)instant).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof State)) break block3;
                    State state = (State)object;
                    if (!Intrinsics.areEqual((Object)this.issuance, (Object)state.issuance) || !Intrinsics.areEqual((Object)this.getOwner(), (Object)state.getOwner()) || !Intrinsics.areEqual(this.faceValue, state.faceValue) || !Intrinsics.areEqual((Object)this.maturityDate, (Object)state.maturityDate)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u00a8\u0006\u0005"}, d2={"Lnet/corda/finance/contracts/CommercialPaper$Commands;", "Lnet/corda/core/contracts/CommandData;", "Issue", "Move", "Redeem", "contracts"})
    public static interface Commands
    extends CommandData {

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lnet/corda/finance/contracts/CommercialPaper$Commands$Move;", "Lnet/corda/core/contracts/TypeOnlyCommandData;", "Lnet/corda/finance/contracts/CommercialPaper$Commands;", "()V", "contracts"})
        public static final class Move
        extends TypeOnlyCommandData
        implements Commands {
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lnet/corda/finance/contracts/CommercialPaper$Commands$Redeem;", "Lnet/corda/core/contracts/TypeOnlyCommandData;", "Lnet/corda/finance/contracts/CommercialPaper$Commands;", "()V", "contracts"})
        public static final class Redeem
        extends TypeOnlyCommandData
        implements Commands {
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lnet/corda/finance/contracts/CommercialPaper$Commands$Issue;", "Lnet/corda/core/contracts/TypeOnlyCommandData;", "Lnet/corda/finance/contracts/CommercialPaper$Commands;", "()V", "contracts"})
        public static final class Issue
        extends TypeOnlyCommandData
        implements Commands {
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/corda/finance/contracts/CommercialPaper$Companion;", "", "()V", "CP_PROGRAM_ID", "", "Lnet/corda/core/contracts/ContractClassName;", "contracts"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

