/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.strands.queues.CircularBuffer;

abstract class CircularWordBuffer<E>
extends CircularBuffer<E> {
    private final int[] array;
    private static final int base;
    private static final int shift;

    public CircularWordBuffer(int size, boolean singleProducer) {
        super(size, singleProducer);
        this.array = new int[this.capacity];
    }

    void enqRaw(int elem) {
        long index = this.preEnq();
        this.orderedSet((int)index & this.mask, elem);
        this.postEnq();
    }

    private static long byteOffset(int i) {
        return ((long)i << shift) + (long)base;
    }

    private void orderedSet(int i, int value) {
        UNSAFE.putOrderedInt(this.array, CircularWordBuffer.byteOffset(i), value);
    }

    static {
        try {
            base = UNSAFE.arrayBaseOffset(int[].class);
            int scale = UNSAFE.arrayIndexScale(int[].class);
            if ((scale & scale - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            shift = 31 - Integer.numberOfLeadingZeros(scale);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
    }

    abstract class WordConsumer
    extends CircularBuffer.Consumer {
        private int value;

        WordConsumer() {
            super(CircularWordBuffer.this);
        }

        @Override
        protected void grabValue(int index) {
            this.value = CircularWordBuffer.this.array[index];
        }

        @Override
        protected void clearValue() {
        }

        int getRawValue() {
            return this.value;
        }
    }
}

