"""
/******************************************************************************
 * $Id$
 *
 * Project:  libLAS - http://liblas.org - A BSD library for LAS format data.
 * Purpose:  Python SRS implementation
 * Author:   Howard Butler, hobu.inc@gmail.com
 *
 ******************************************************************************
 * Copyright (c) 2009, Howard Butler
 *
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following 
 * conditions are met:
 * 
 *     * Redistributions of source code must retain the above copyright 
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright 
 *       notice, this list of conditions and the following disclaimer in 
 *       the documentation and/or other materials provided 
 *       with the distribution.
 *     * Neither the name of the Martin Isenburg or Iowa Department 
 *       of Natural Resources nor the names of its contributors may be 
 *       used to endorse or promote products derived from this software 
 *       without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS 
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT 
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
 * OF SUCH DAMAGE.
 ****************************************************************************/
 """
import core
import ctypes
import vlr

class SRS(object):
    def __init__(self, owned=True, handle=None):
        if handle:
            self.handle = handle
        else:
            self.handle = core.las.LASSRS_Create()
        self.owned = owned
    def __del__(self):
        if self.owned:
            if self.handle and core:
                core.las.LASSRS_Destroy(self.handle)
    
    def get_wkt(self):
        return core.las.LASSRS_GetWKT(self.handle)
    def set_wkt(self, value):
        return core.las.LASSRS_SetWKT(self.handle, value)
    wkt = property(get_wkt, set_wkt)
    
    def get_proj4(self):
        return core.las.LASSRS_GetProj4(self.handle)
    def set_proj4(self, value):
        return core.las.LASSRS_SetProj4(self.handle, value)
    proj4 = property(get_proj4, set_proj4)
    
    def add_vlr(self, vlr):
        return core.las.LASSRS_AddVLR(self.handle, vlr.handle)
        
    # def get_red(self):
    #     return core.las.LASColor_GetRed(self.handle)
    # def set_red(self, value):
    #     return core.las.LASColor_SetRed(self.handle, value)
    # red = property(get_red, set_red)
    # 
    # def get_green(self):
    #     return core.las.LASColor_GetGreen(self.handle)
    # def set_green(self, value):
    #     return core.las.LASColor_SetGreen(self.handle, value)
    # green = property(get_green, set_green)
    # 
    # def get_blue(self):
    #     return core.las.LASColor_GetBlue(self.handle)
    # def set_blue(self, value):
    #     return core.las.LASColor_SetBlue(self.handle, value)
    # blue = property(get_blue, set_blue)

