/*
 * Copyright (c) 2013 Oracle and/or its affiliates. All rights reserved. This
 * code is released under a tri EPL/GPL/LGPL license. You can use it,
 * redistribute it and/or modify it under the terms of the:
 *
 * Eclipse Public License version 1.0
 * GNU General Public License version 2
 * GNU Lesser General Public License version 2.1
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.*;
import com.oracle.truffle.api.dsl.*;
import org.jruby.truffle.nodes.*;
import org.jruby.truffle.runtime.*;

@NodeChild(value = "arguments", type = RubyNode[].class)
public abstract class CoreMethodNode extends RubyNode {

    public CoreMethodNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public CoreMethodNode(CoreMethodNode prev) {
        super(prev);
    }

}
