/*
 ***** BEGIN LICENSE BLOCK *****
 * Version: EPL 2.0/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Eclipse Public
 * License Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.eclipse.org/legal/epl-v20.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * Copyright (C) 2013-2017 The JRuby Team (jruby@jruby.org)
 * 
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the EPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the EPL, the GPL or the LGPL.
 ***** END LICENSE BLOCK *****/
package org.jruby.parser;

public class YyTables {
   private static int[] combine(int[] t1, int[] t2, 
                                  int[] t3, int[] t4) {
      int[] t = new int[t1.length + t2.length + t3.length + t4.length];
      int index = 0;
      System.arraycopy(t1, 0, t, index, t1.length);
      index += t1.length;
      System.arraycopy(t2, 0, t, index, t2.length);
      index += t2.length;
      System.arraycopy(t3, 0, t, index, t3.length);
      index += t3.length;
      System.arraycopy(t4, 0, t, index, t4.length);
      return t;
   }

   public static final int[] yyTable() {
      return combine(yyTable1(), yyTable2(), yyTable3(), yyTable4());
   }

   public static final int[] yyCheck() {
      return combine(yyCheck1(), yyCheck2(), yyCheck3(), yyCheck4());
   }
   private static final int[] yyTable1() {
      return new int[] {

          110,   92,  323,  410,  454,  457,  368,  311,  234,  234, 
          321,  277,  284,  416,  601,   99,  495,  208,  209,  423, 
          693,  430,  789,  201,  784,  796,  345,  204,  236,  236, 
          591,  925,  332,  697,  504,  591,  986,  368,  311,  255, 
          577,  314,  719,  201,  661,  577,  719,  204,  919,  282, 
          922,  281,  281,  288,  292,  242,  242,  435,  722,  435, 
          435,  718,  311,  237,  237,  657,   99,   99,  666,  798, 
          312,  453,  797,  311,  311,  917,  674,  252,  821,  204, 
          236,  575,  339,  339,  775,  328,  329,  330,  779,  534, 
          248,  751,  689,  536,  821,  287,  291,  722,  823,  905, 
          718,  359,  365,  285,  239,  246,  262,  261, 1184,  823, 
          234,  616,  555,  557,  367, 1005,  841,  821,  714,  857, 
          841,  841,  247,  455,  365,  312,  882,  821,  814,  474, 
          236,  419,  236,  770,  236,  236,  470,  470,  821,  657, 
          204,  666,  403,  821,  746,  326,  940,  401, 1007, 1169, 
          489,  364,  402,  523, 1230,  981,  476,  242, 1061,  365, 
          616,  409, 1190,  835, 1277,  237,  821,  807,  112,  808, 
          418,  483,  738,  364,  748,  746, 1261, 1264,  746,  797, 
          921,  520,  415,  277,  752,   98,  365,  821,  821,  506, 
          253,  509,  256,  746,  368,  438,  737,  738,  342, 1130, 
          822,  247,  758, 1114, 1114,  409,  432, 1344,  364, 1242, 
          787,  926,  821, 1189,  341,  752,  821,  540,  752,  722, 
          779,  252, 1250,  281,  860,  415,  545,  605,  788,  339, 
          339,  822,  326,  752,  277,  364,  314,  821,   99,  808, 
          234, 1319,  415,  234, 1231,  503, 1259, 1262,  517,  759, 
          722,  779,  614,  615,  616,  617,  110,   92,  311,  415, 
          236,  821,  738,  236,  236,  880,  236,  314,  722,  779, 
          414,   99,  282,  610,  281, 1005,  495,  719, 1344,  719, 
          525,  257,  435,  822, 1075,  252,  737,  488, 1348,   99, 
          242,  722,  807,  415,  808,  499,  718,  517,  237,  821, 
          989,  604,  526,  606,  488,  678, 1157,  435,  435,  435, 
          435, 1058,  620,  621, 1225,  917,  794,  946,  408,  314, 
          133,  312,  353,  252, 1223,  822,  770,  912,  142, 1114, 
          395,  881,  394,  515,  248,  821,  889,  418,  544,  505, 
          530,  281,  971,  281,  484,  485,  123,  756,  687,  756, 
          694, 1351,  868,  251,  738, 1016,   99,  236,   99,  695, 
          979,  341,  408,  696,  687,  538,   92,  353,  616,  109, 
          368,  821, 1353,  802,  529,  821,  821,  142,  719,  311, 
           99,  684,  236,  236,  236,  236,  277,  236,  236,  841, 
          841,  821,  821,  687,  688,  841,  841,  718, 1019,  821, 
          109, 1018,  574,   98,  773,  435,  965,  234,  821,  687, 
         1064, 1053,  503,  680,  921, 1183,  684,  746, 1183,  821, 
          109, 1009, 1011, 1013,  282, 1015,  281,  236,  822,  821, 
         1017,  281,  809,  377, 1353,  773,  667, 1226,  773,  341, 
          763,   99,  312, 1182,  667,  821,   99,  817,  821,  819, 
          821,  141,  616,  773,  821,  540,  691,  752, 1129, 1129, 
          575,  537, 1018,  274,  821,  805,  821,  591,  234,  591, 
         1188,  763,  821, 1278,  763,  770,  770,  821,  841,  326, 
          236,  234,  821,  412,  422,  665,  503,  686,  236,  763, 
          841,  415,  722,  779,  893,  821,  311,  809,  671,   60, 
          141,  236,  675,  676,  677,  517,  816,  746,  821,  667, 
          820,  822,  895,  821,  807,  242, 1347,  795,  773, 1349, 
          548,  804,  807,  237,  821,  731,  412,  413, 1384,  201, 
          720,  821,  686,  204,  718,  335,  609,  234,  405,   99, 
          667,  862,  503,  412,  487,  906,  898,  752, 1062,  906, 
          811,  719,   14,   14,  763,  152,  821,  236,  665,  312, 
          412,  519,  312,  722,  705,  667,  374,  375,  777,  744, 
          721,  550,  551,  723,  724, 1360,  466, 1158, 1160, 1161, 
         1162,  142,  722,  779, 1129,  142,  809, 1042,  540,  665, 
         1355,  515, 1357,  794,  412,  543,  794,  281,  739,  777, 
          281,  415,  234,  382,  383,  821,  431,  503,  657,  799, 
          666,   14,   99,  236,  665,   99,  236,  777,  812,  917, 
         1148, 1283,  236,  353,  353,  866, 1129, 1129, 1129,  311, 
          667,  737,   99,  421,  770,  770,  837,  527,  109,  762, 
          837,  837,  855,  864,  530,  312,  701, 1233,  931,  687, 
          687,  874, 1390,  821,  899,  935,  839, 1166,  821,  466, 
          846,  445,  883,  821,  834,  687,  687,  800,  893,  809, 
          896,  821,  834,  374,  375,  917, 1069,  773,  533,  665, 
          737,  252,  777,  281,  838,  415,  763,  825,  838,  838, 
          236,  281,  312, 1234,  234,  311,  833,  591,   99,  503, 
          236,  281,  281,  591,  845, 1321,   99,  577,  141, 1220, 
          445,  821, 1330,  763,  236, 1367,   99,   99,  425,  885, 
         1345,  821,  667,  201,  851,  851,  824,  204,  980,  809, 
          957,  982,  475,  313,  568,  831,  834,  426, 1129, 1299, 
          816,  991, 1154,  831,  427,  236,  510,  809,  101,  960, 
          569,  477,  958, 1254,  807,  926,  511,  512,  312,  988, 
          863,  101,  101,  591,  313,  894,  152,  773,  548,  938, 
          540,  665,  816,  577,  754,  445,  415,  924,  907,  908, 
          573,  574,  909,  910,  924, 1292,  101,  779,  686,  686, 
         1380,  987,  412,  608,    7,  821,  794, 1022,  415,  101, 
          101,  815,  353,  763,    7,  251,  824,  831,  754,  281, 
          644,  311,  787,  101,  435,  152,  313,  101,  453,  550, 
          551, 1288, 1246,  754,   99,  828,  971,  479,  871,  706, 
         1196, 1055,  122,  486,  686,  753,  779,  101,  807,  737, 
         1059,  777,  821,  701,  821, 1063,  353,  353, 1066,  646, 
         1163, 1164,  920,    7,  738,  726,  927,  644,  728, 1057, 
          729,  968,  974,  101,  645,  101,  894,  101,  101,  753, 
          737, 1241,  974,  821,  312,  281,  794,  741,  828,  686, 
          353,  490,  353,  493,  753,  738,  107,  204,  754,  236, 
           99,  821, 1281,  822, 1269,  353,  646,  105,  944,  945, 
          808,  779,  412,  700, 1065, 1002,  950,  951,  808,  837, 
          837,  645,  828,  494,  435,  837,  837,  107, 1334,    7, 
          821,  821,  821, 1153,  822,  794,  821,  353,  105, 1028, 
         1030,  777,  771, 1056,  403, 1034, 1036,  107,  496,  401, 
          399,  738,  400,   99,  402,  236, 1252, 1253,  105,  753, 
          234,  947,  446,  497,  932,  503,  647,  838,  838,  952, 
          353,  970,  971,  838,  838,  994,  995, 1054,  997,  998, 
          236,  101,  828,  281,   99,  807,  807,  807,  667,  821, 
          890,  807,  807,  514,  807,  281,  412,  956,   99,  236, 
         1024,  518,  807,  101,   97,  737,  101,  101,  837,  101, 
           99,  446, 1269,  647,  101, 1269, 1186, 1187,  765, 1281, 
          837, 1281,  312, 1350,  900,  695,  521,  851, 1133, 1165, 
         1152,  524,  101,  152,  377, 1033,  737,  665,  532, 1156, 
         1131, 1132,  859, 1293, 1294,  807, 1045,  807, 1136, 1179, 
          535,  429,  765,  312,  737,  828,  838, 1139, 1143,  821, 
         1147,  993,   99,  539,  821,  101,  821,  765,  838,  884, 
          281,   99,  432,  102, 1247,  656,  446,  141,  656,  281, 
         1350, 1281,  429, 1067,  937,   99,  656,  412, 1287,  430, 
          942,  433,  943,  807,   99,  546, 1074,  558, 1076,  101, 
          101,  101, 1077,  432,  102,  311,  821,  110, 1202,  412, 
         1363,  821, 1203,  353,  353,  600, 1221,  821, 1149,  603, 
          430,  821,  433,  101,  102,  101,  101,  101,  101,  435, 
          101,  101,  765,  915,  607,  821,  821,  821,  110, 1200, 
         1200, 1289,  821,  542,  542,  686,  686,  103,  281,  656, 
          840,  656,  281, 1167,  847, 1176,  281,  990,  110,  611, 
          974,  117,  669,   99,  821,  107,  431,   99, 1217, 1284, 
          101,   99, 1249,  681,  117,  117,  105,  612,  103, 1260, 
         1263,  656,  656,  143,  101,  698, 1339, 1340, 1290,  101, 
          124,  704,  688,  353,  353,  821,  709,  431,  103, 1298, 
          840,  710,  847,  730,  236,  656,  281,  656, 1279,  281, 
          548,  725,  117,  117, 1369,  108,  828, 1312,  897,  688, 
          129,   99,  496,  101,   99,  727,  117,  734,  281,  974, 
          977,  101,  143, 1026, 1027,  377,  743,  688,  745,  281, 
          311,  435,  435,   99,  101,  772,  108, 1236,  144, 1256, 
         1258,  774,  390,  391,   99,  776,  106,  549,  778, 1000, 
         1001,  550,  551, 1244,  688,  783,  108,  496,  828, 1177, 
          656,  785,  656,  786,  818, 1004,  117,  821,  117,  117, 
          117,  117,  101,  826,  689, 1273,  829,  106,  830,  311, 
          435,  234,  861, 1143,  865,  868,  503,  144,  968,  496, 
          101,  148,  871, 1328,  714,  281, 1366,  106,  809,  793, 
          117,  236,  913,  117,  888,  681,  236,  236, 1137,  667, 
           99,  435,  891,  892,  435, 1279,  548, 1279, 1229,  689, 
          117,  924,  714,  889, 1279,  793,  714,  496,  930,  117, 
          914,  681,  102,  828,  828,  933,  281,  934,  941,  948, 
          148,  949, 1364,  714,  953,  101,  101,  955,  101,  101, 
          681,   99,  656,  828,  656,  101,  959,  963,  665,  252, 
         1174, 1229,  964,  553,  974,  101,  110,  550,  551,  966, 
          708,  971,  496, 1279,  117, 1279,  681, 1279,  104, 1279, 
          403,  398,  793,  996,  999,  401,  399,  575,  400,  992, 
          402,  576, 1354, 1032, 1008, 1279,  117, 1010, 1012,  117, 
          117, 1361,  117, 1014,  496,  788,  103,  117,  793,  104, 
          125,   20,  689, 1029, 1031,  143, 1072,  101,  548, 1035, 
         1037,  101,  101,  101, 1073,  117,  828,  828,  828,  104, 
          143,  101, 1141,  101, 1145, 1238, 1239, 1159, 1229,  101, 
         1178, 1185,   20, 1193, 1194,  148,  496,  101,  323,  101, 
          101, 1197, 1388,  548, 1389, 1255, 1391,  689,  323, 1243, 
           20, 1183, 1245, 1029, 1031,  553, 1035, 1037, 1087,  550, 
          551,  403, 1397, 1295,  108, 1286,  401,  399,  101,  400, 
         1296,  402, 1301,  688,  688,  511, 1302, 1305, 1313,  323, 
         1314,  129,  117,  117,  117,  144, 1316, 1320,  828, 1322, 
          554,  511, 1134, 1323,  550,  551, 1368,  323,  548, 1346, 
          688,  688, 1177,  496,  496,  106,  117,  746,  117,  117, 
          117,  117,  129,  117,  117,  129,   20,  496, 1309, 1310, 
         1311,  511, 1358,  126, 1362,  511, 1134, 1370,  117,  793, 
         1372,  323,  129, 1374, 1257,  821,  126,  126,  148, 1376, 
         1378,  746,  127, 1394,  691,  553,  821,  101,  807,  550, 
          551,  496, 1246,  117,  136,  793,  746,  809,  438,  548, 
          556,  814,  496,  323,  814,  689,  689,  117,   40,   41, 
           42,   43,  117,  548,  126,  126,  809,  816,  809,  372, 
          714, 1300,  714,  714,  714,  714,  714,  809,  126,  691, 
         1365, 1304,  809,  331,  496,  334,  681,  681,  656,  473, 
          656,  761,  714, 1306, 1307, 1308,  117,  978, 1020, 1021, 
          550,  551,  101,  101,  117,  517,  714,  613,  496,  496, 
          755,  746,  681,  681,  550,  551,  714,  117,  740, 1038, 
         1039,  714,  714,  714,  742,  144, 1291,  104,  126, 1048, 
          126, 1337,  126,  126, 1331,  563,  136,  564,  565,  566, 
          567,  568,  844,   20,   20,   20, 1356, 1270,  452,   20, 
           20,  377,   20,  918, 1006,  117,  911,  569,  101, 1201, 
           20,  923, 1180, 1359,  316,  317,  793,  318,  390,  391, 
          101,  101,  681,  117,  336, 1387,  101,  101,  961,  651, 
          126,  571,  690,  101,  336,  136,  572,  573,  574,  363, 
          323,  323,  323,  689,  689,  323,  323,  323,  128,  323, 
          692,  101,  101,   20, 1385,   20, 1251,  323, 1181,  323, 
          323, 1248,  100,  101,  417,  336, 1266,  681,  330,  323, 
          323, 1049,  323,  323,  323,  323,  323,  690,  117,  117, 
         1371,  117,  117,  336, 1267,  732,  126, 1329,  117, 1089, 
          129,  496,  377,  100,    0,  692,  112,  139,  117,  793, 
          323,   20,  323,    0,    0,  569,    0,    0,  126,  101, 
          548,  126,  126,   98,  126,  101,    0,  146,  119,  126, 
          683,  101,    0,    0,  101,    0,  563,  794,  564,  565, 
          566,  567,    0,  684,  323,  573,    0,  126,  101, 1265, 
          120,    0,    0,    0,    0,  289,  139,  101,  323,  336, 
          117,  648,    0,    0,  117,  117,  117,  760,  496,  496, 
            0,  550,  551,  131,  117,  683,  117,    0,    0,    0, 
          794,  120,  117,    0,  120,  635,  684,    0,  684,    0, 
          117,    0,  117,  117,    0,  691,  691,  640,    0,    0, 
          118,  120,  682,  793,  131,  636,    0,  131,  648,  798, 
            0,    0,  648,  648,  126,  126,  126,    0,  641,    0, 
          794,  117,    0,    0,  131,    0,  101,    0,  681,    0, 
          101,  684,  635,    0,  101,    0,  635,  635,  126,    0, 
          126,  126,  126,  126,  640,  126,  126,  682,  640,  640, 
            0,    0,  636,  136,  798,    0,  636,  636,  793,    0, 
            0,    0,  681,  794,  681,  641,  793,  101,    0,  641, 
          641,    0,    0,    0,    0,  145,    0,  681,    0,  656, 
            0,  656,    0,    0,  101,  126,  798,  101,  121,    0, 
          685,    0,    0,  147,    0,    0,  336,  336,  336,  126, 
          117,  336,  336,  336,  126,  336,  101,    0,    0,  681, 
            0,    0,    0,  336,    0, 1126, 1126,  101,    0,    0, 
          714,  146,  478,    0,    0,  480,  481,  482,  336,  336, 
          336,  336,  336,  681,  681,  685,    0,    0,  126,    0, 
          107,  793,  681,  690,  690,    0,  126,  794,  714,    0, 
            0,  120,  714,  684,    0,  656,  336,  691,  336,  126, 
            0,  692,  692,  138,  139,  117,  117,    0,    0,  714, 
          146,  821,    0,    0,  101,    0,  133,  794,    0,  101, 
          101,    0,    0,  101,    0,  336,    0,  150,    0,    0, 
            0,  107,  107,    0,    0,  313,    0,  126,  684,    0, 
            0,    0,  691,    0,  336,    0,  794,  133,    0,    0, 
          133,    0,  353,    0,    0,  126,    0,  793,  145,  120, 
          794,  117,    0,  798,  101,    0,  360,  133,    0,    0, 
          794,  683,  683,  117,  117,  137,  150,    0,    0,  117, 
          117, 1126,  131,  798,  684,  684,  117,    0,  485,    0, 
          313,    0,    0,    0,  690,    0,    0,  353,  485,    0, 
            0,  471,  471,    0,  117,  117,    0,  145,  798,    0, 
          126,  126,    0,  126,  126,    0,  117,    0,    0,    0, 
          126,    0,    0, 1126, 1126, 1126,    0,  684,  684,  485, 
          126,    0,    0,    0,  485,    0,    0,    0,  793,  690, 
          798,    0,    0,  682,  682,  316,  317,  485,  318,    0, 
          798,  798,    0,    0,    0,   45,   46,    0,  123,    0, 
            0,    0,  117,  140,    0,    0,    0,    0,  117,    0, 
         1099, 1099,    0,    0,  117,    0,  563,  117,  564,  565, 
          566,  567,  126,    0,    0,    0,  126,  126,  126,  123, 
            0,  117,  123,    0,  687,   84,  126,    0,  126,    0, 
          117,    0,    0,  107,  126,  681,  681,    0,  147,  123, 
            0,  298,  126,  485,  126,  126,    0,    0,  146,    0, 
            0,  298,  764,    0,    0,  711,  139,  794,    0,  717, 
            0,  685,  685,  289,    0, 1126,  107, 1099, 1099,  687, 
            0, 1099,    0,  126,  692,    0,   84,   84,    0,    0, 
          309,    0,  298,    0,  107,  298,  714,  147,  714,  714, 
          714,  714,  714,  369,  370,  371,  372,  373,  717,  117, 
          298,    0,  289,  117,    0, 1099,    0,  117,  714,    0, 
            0,  309,    0,    0,  150,  133,  313,    0,    0,  692, 
            0,    0,  714,    0,  684,  684, 1099,  798,  691,  691, 
            0,    0,  714,    0,  298,  309,    0,  714,  714,  714, 
          117,    0,    0,    0, 1099,  145,  309,  309, 1099,   85, 
            0,  107,  126,  107,    0,    0,  135,  117,  346,  780, 
          117, 1099, 1099, 1099, 1099,    0,  298,    0, 1099, 1099, 
            0, 1099,    0,    0,    0,  107,    0,    0,    0,  117, 
          485,  485,  485,  353,  353,  485,  485,  485,    0,  485, 
          117,    0,    0,  130,  798,  798,    0,  485,    0,  485, 
           85,   85,    0,  346,  310,    0,    0,    0,    0,  485, 
          485,    0,  485,  485,  485,  485,  485,  126,  126,    0, 
            0,    0,    0,  793,  130,  690,  690,  130,    0,  793, 
            0,    0,    0,  132,    0,  310,  107,  313,    0,    0, 
          485,  107,  485,    0,  130,  850,  856,  117,   84,    0, 
            0,    0,  117,  117,    0,    0,  117,  123,    0,  310, 
            0,    0,    0,  794,  132,  485,  485,  132,    0,  794, 
          310,  310,    0,  126,  793,    0,    0,  886,    0, 1099, 
            0,   84, 1099,    0,  132,  126,  126,    0,  485,    0, 
         1099,  126,  126,    0,  717,  147,  289,  117,  126,   84, 
            0,    0,    0,  298,  298,  298,  793,    0,  298,  298, 
          298,    0,  298,    0,  794,  684,  126,  126,    0,    0, 
          298,    0,  298,  298,  298,  687,  687,    0,  126,    0, 
            0,  309,  298,  298,  107,  298,  298,  298,  298,  298, 
            0,    0,    0,    0,    0,  794,  794, 1099,    0,  684, 
          929,  684,    0,  134,  313,  354, 1341,    0,  564,  565, 
          566,  567,    0,  298,  684,  298,   84,    0,   84, 1282, 
            0,    0,   85,    0,  126,  692,  692,    0,    0,    0, 
          126,    0,    0,    0,    0,  122,  126,    0,    0,  126, 
           84,  154,  298,    0,    0,  717,  684,  298,    0,  124, 
          354,    0,    0,  126,    0,   85,    0,  107,    0,    0, 
          107,  298,  126,    0,  298,    0,  122,  962,    0,  122, 
            0,  686,    0,   85,    0,    0,  103,  107,  794,  684, 
          124,    0,    0,  124,    0,  688,  122,    0, 1100, 1100, 
          125,    0,  984,    0,    0,    0,    0,  109,    0,    0, 
          124,   84,  309,    0,    0,  310,   84,    0,    0,  346, 
          346,    0,  130,  793, 1280,    0,  686,    0,    0,    0, 
            0,  125,    0,    0,  125,    0,  689,  103,  103,  842, 
          688,  126,    0,  842,  842,  126, 1282,  313, 1282,  126, 
           85,  125,   85,  107,    0, 1282,    0,    0,  109,  109, 
            0,  107,  132,  794,    0, 1100, 1100,    0,    0, 1100, 
            0,  107,  107,    0,   85,    0,    0,    0,    0,    0, 
            0,  689,  126,    0,  149,    0,    0,    0,    0,  138, 
          793,  793, 1047,  362,    0,    0,    0,    0, 1051,  126, 
            0,    0,  126, 1100, 1282,    0, 1282,    0, 1282,   84, 
         1282,    0, 1060,  313,  793,    0,    0,    0,    0,  151, 
          793,  126,  903,    0, 1100,  683, 1282,    0,  289,  309, 
          794,  794,  126,  149,    0,   85,  310,    0,  138,    0, 
           85, 1280, 1100, 1280,    0,  794, 1100, 1280,  153,  794, 
         1280,    0,    0,    0,    0,  794,    0,  137,    0, 1100, 
         1100, 1100, 1100,    0,    0,  793, 1100, 1100,  151, 1100, 
          683,    0,    0,    0,    0, 1138,    0,    0,    0,  107, 
            0,    0,   84,    0,    0,   84,    0,    0,    0,  126, 
         1151,    0,    0,  682,  126,  126,    0,  793,  126, 1280, 
          794, 1280,   84, 1280,    0, 1280,  137,    0,  268,  103, 
            0,    0,  684,  684,  122,    0,  354,  354,  268,    0, 
            0, 1280,    0,    0,    0,    0,    0,    0,  124,  313, 
          109,    0,  794,   85,    0,    0,    0,    0,  682,  126, 
            0,    0,  103,    0,    0,  107,    0,    0,    0,  268, 
            0,    0,  268,  310,   84,  798,    0,    0,   84,   84, 
          103,    0,  309,  109,    0,    0,  268,  268,   84,  125, 
          563,  268,  564,  565,  566,  567,   84, 1100,    0, 1224, 
         1100,  109,  686,  686,    0,  793,   84,   84, 1100,  798, 
            0,  798,    0, 1109, 1109,    0,  688,  688,    0,    0, 
            0,  268,    0,    0,  798,    0,   85,    0,    0,   85, 
            0,    0,  842,  842,    0,    0,  764,    0,  842,  842, 
            0,  765,    0,    0,    0,  140,   85,  103,  309,  103, 
            0,    0,    0,  268,    0,    0,  798,  689,  689,    0, 
            0,  149,    0,  107,    0, 1100,  138,    0,  109,    0, 
          109,  103,    0,    0,  793,  107,    0,    0,    0,    0, 
            0,  685,    0,    0, 1168,    0,    0,    0,  798,  798, 
            0,    0,  109,    0,  140,    0,  151,    0,   85,    0, 
            0,    0,   85,   85,    0,    0,  310,  154,    0,  794, 
            0,    0,   85,    0,   84,    0,    0,    0, 1195,    0, 
           85,  842,    0,    0,    0,    0,  685,  107,    0,    0, 
           85,   85,  103,  842,  137,  230,  107,  103,    0, 1109, 
            0,  793,  793,  346,    0,    0,  683,  683,    0,    0, 
          107,    0,    0,  109,    0,    0,  154, 1237,  109,  107, 
            0,    0,    0,  230,  309,  230,    0,  230,    0,    0, 
            0,  687,  310,    0, 1168,    0,  794,  794,    0,    0, 
           84, 1168, 1168,    0,  230,    0,  230,    0,  346,    0, 
          268,  268,  268,  153,    0,  268,  268,  268,    0,  268, 
            0,    0,    0,    0,    0,    0,    0,  268,    0,  268, 
          268,  268,    0,    0,  682,  682,    0,    0,    0,  268, 
          268,    0,  268,  268,  268,  268,  268,    0,  107,  354, 
          103,    0,  107, 1218,    0,    0,  107,  575,   85, 1068, 
            0,  576,  153,    0,    0,  798,    0,   84,   84,  127, 
          268,  109,  268,   84,   84,    0,    0,    0,    0,    0, 
            0,    0,    0,  268,  268,    0,    0,  268,  268,    0, 
            0,    0,    0,    0,  354,    0,    0,    0,   84,  268, 
          127,    0,    0,  127,  268,  691,  107,    0,  310,  107, 
           84,    0,    0,    0,    0,    0,    0,  789,  268,    0, 
          127,  268,  140,  103,   85,    0,  103,  789,  107,    0, 
          793,    0,  798,  798,  131,    0,  798,    0,    0,  107, 
            0,    0,    0,  103,  109,    0,    0,  109,    0,    0, 
          691,    0,    0,    0,    0,    0,   84,    0,  789,    0, 
            0,  789,   84,    0,  109,    0,    0,    0,   84,    0, 
            0,   84,  403,  398,    0,    0,  789,  401,  399,    0, 
          400,  798,  402,    0,  154,   84,    0,    0,  471,    0, 
            0,   85,   85,    0,   84,  103,    0,   85,   85,  103, 
          103,    0,  685,  685,    0,  107,    0,    0,    0,  103, 
          789,    0,    0,  798,    0,    0,  843,  103,    0,    0, 
          843,  843,   85,    0,    0,    0,    0,  103,  103,  397, 
          109,    0,    0,    0,   85,    0,    0,  471,  109,    0, 
            0,    0,  789,    0,    0,  126,  107,    0,  109,  109, 
            0,  230,    0,  230,  230,  230,  230,  230,    0,  396, 
            0,    0,    0,   84,  346,  346,    0,   84,  309,    0, 
          153,   84,    0,  230,    0,    0,  126,    0,    0,  126, 
           85,  690,    0,  128,    0,    0,   85,  230,    0,    0, 
            0,    0,   85,  687,    0,   85,  126,  230,    0,    0, 
            0,    0,  230,  230,  230,    0,    0,    0,    0,   85, 
            0,    0,    0,  808,  128,    0,    0,  128,   85,  692, 
            0,   84,    0,    0,   84,  563,  690,  564,  565,  566, 
          567,  568,    0,    0,  128,  103,    0,    0,  127,    0, 
            0,    0,    0,   84,    0,    0,    0,  569,    0,    0, 
          354,  354,    0,    0,   84,    0,  109,    0,    0,  793, 
            0,  570,    0,  130,  692,  793,    0,    0,    0,  150, 
          798,  571,    0,    0,    0,    0,  572,  573,  574,  789, 
          789,  789,    0,    0,  789,  789,  789,   85,  789,    0, 
            0,   85,  310,    0,    0,   85,  789,  808,  789,  789, 
          223,  103,    0,  309,    0,    0,  691,  691,  789,  789, 
          793,  789,  789,  789,  789,  789,    0,    0,    0,    0, 
           84,    0,  109,    0,  233,  233,    0,    0,  223,    0, 
          223,    0,  223,    0,    0,    0,  686,  798,  798,  789, 
            0,  789,  793,    0,    0,   85,    0,    0,   85,  223, 
            0,  223,  309,    0,    0,    0,    0,  266,  271,  272, 
          273,   84,    0,  377,  233,  233,    0,   85,  103,  103, 
            0,    0,    0,  789,  103,  103,  331,  333,   85,    0, 
          390,  391, 1101, 1101,    0,    0,    0,  789,    0,  843, 
          843,    0,    0,    0,    0,  843,  843,    0,    0,  103, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  103,    0,    0,  126,    0,    0,    0,    0,    0, 
          109,    0,    0,    0,    0,    0,  233,  310,    0,    0, 
            0,    0,  109,    0,  808,  808,  808,    0,    0,    0, 
          808,  808,    0,  808,   85,    0,    0,    0,    0, 1101, 
         1101,  808,  128, 1101,    0,    0,    0,  103,    0,    0, 
            0,    0,    0,  103,    0,    0,    0,    0,    0,  103, 
          334,    0,  103,    0,    0,    0,  310,    0,  843,    0, 
          334,    0,  690,  690,  109,   85,  103, 1101,    0,    0, 
          843,    0,    0,  109,  808,  103,  808,    0,  149,  793, 
            0,    0,    0,    0,    0,    0,    0,  109, 1101,    0, 
            0,  334,    0,    0,  328,    0,  109,    0,    0,    0, 
          692,  692,    0,    0,    0,    0, 1101,  119,    0,  334, 
         1101,    0,  233,    0,    0,  233,  233,  233,    0,  331, 
            0,    0,  808, 1101, 1101, 1101, 1101,    0,    0,    0, 
         1101, 1101,    0, 1101,    0,    0,  233,    0,  119,  233, 
            0,  119,    0,  683,  103,    0,  793,  793,  103,    0, 
            0,    0,  103,  575,    0,    0,    0,  576,  119,    0, 
            0,    0,    0,    0,  233,  109,    0,    0,    0,  109, 
         1219,    0,    0,  109,    0,  334,  223,    0,  223,  223, 
          223,  223,  223,    0,    0,    0,    0,    0,  683,    0, 
            0,    0,  233,    0,  233,    0,  233,    0,  223,    0, 
          688,    0,  103,    0,    0,  103,    0,    0,    0,    0, 
            0,    0,  223,  233,    0,  233,    0,    0,  686,    0, 
            0,    0,  223,  109,  103,    0,  109,  223,  223,  223, 
            0,    0,    0,    0,    0,  103,    0,    0,    0,    0, 
            0, 1101,    0,    0, 1101,  109,    0,    0,    0,    0, 
            0,    0, 1101,    0,    0,    0,  109,    0,    0,    0, 
            0,  331,    0,    0,    0,    0,  623,  624,  625,  626, 
          627,  331,    0,  628,  629,  630,  631,  632,  633,  634, 
          635,    0,  637,    0,    0,  638,  639,  640,  641,  642, 
          643,  644,  645,  646,    0,    0,    0,    0,    0,    0, 
          118,  103,  331,  233,    0,  331,  668,  121,    0, 1101, 
            0,    0,  334,  334,  334,    0,    0,  334,  334,  334, 
          331,  334,  109,    0,    0,   74,    0,    0,    0,  334, 
            0,  118,    0,    0,  118,   74,  682,    0,  121,    0, 
            0,  121,  103,  685,  334,  334,  334,  334,  334,    0, 
            0,  118,    0,    0,  331,    0,    0,    0,  121,    0, 
            0,    0,    0,  109,  233,    0,   74,    0,    0,    0, 
            0,    0,  334,    0,  334,  233,  119,  233,    0,  233, 
            0,  682,    0,  233,   74,    0,  331,  273,  685,    0, 
            0,    0,    0,    0,  496,    0,    0,    0,    0,    0, 
            0,  334,    0,    0,  496,  733,    0,  735,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  233,    0, 
          334,  563,  233,  564,  565,  566,  567,  568,    0,    0, 
            0,  496,  496,  233,    0,  496,  496,  496,  496,  496, 
          496,  496,    0,  569,  683,  683,    0,    0,    0,    0, 
           74,    0,  496,  496,  496,  148,  496,  496,    0,    0, 
          233,    0,  233,  233,  233,  233,  233,  571,    0,    0, 
            0,    0,  572,  573,  574,    0,    0,    0,    0,  233, 
          794,    0,  233,    0,  132,  496,  794,  496,  496,  793, 
            0,    0,  793,    0,    0,    0,  233,    0,  233,    0, 
            0,    0,  688,    0,    0,    0,  233,    0,    0,    0, 
            0,  233,  233,  233,    0,    0,    0,  496,  496,  496, 
            0,    0,    0,  331,  331,  331,    0,    0,  331,  331, 
          331,  794,  331,    0,    0,    0,    0,    0,    0,    0, 
          331,    0,  331,  331,    0,    0,    0,    0,    0,    0, 
            0,    0,  331,  331,    0,  331,  331,  331,  331,  331, 
          836,    0,    0,  794,  836,  849,  233,    0,    0,  118, 
            0,    0,    0,    0,  303,    0,  121,    0,    0,    0, 
            0,    0,    0,  331,  303,  331,    0,   74,   74,   74, 
          233,    0,   74,   74,   74,    0,   74,  233,  793,  793, 
            0,    0,    0,    0,   74,    0,   74,    0,    0,    0, 
          836,    0,  836,  836,  233,  303,  233,  331,  303,   74, 
           74,   74,   74,   74,    0,    0,    0,    0,  836,    0, 
            0,  331,  303,  303,    0,    0,    0,  682,  682,    0, 
            0,    0, 1102, 1102,  685,  685,    0,   74,    0,   74, 
            0,    0,    0,    0,    0,    0,  496,  496,  496,    0, 
            0,  496,  496,  496,    0,  496,    0,  303,    0,    0, 
          233,    0,    0,  496,  496,  496,  496,  496,    0,    0, 
            0,    0,    0,    0,    0,  496,  496,    0,  496,  496, 
          496,  496,  496,    0,    0,   74,    0,    0,    0,  303, 
            0,    0,    0,    0,    0,    0,    0,    0,    0, 1102, 
         1102,    0,    0, 1102,    0,  233,  496,    0,  496,  151, 
          794,  135,  496,  496,  496,  496,  496,  496,  496,  496, 
          496,  496,  496,  496,  496,    0,    0,  233,  681,  496, 
          496,  496,  496,    0,    0,  496,    0, 1102,  681,    0, 
          496,    0,  135,    0,    0,  135,    0,  346,    0,    0, 
            0,    0,  233,    0,  496,    0,    0,  496, 1102,    0, 
            0,  793,  135,    0,    0,  681,  681,    0,  793,  681, 
          681,  681,  681,  681,  681,  681, 1102,  794,  794,    0, 
         1102,    0,    0,    0,    0,    0,  681,  681,  681,  136, 
          681,  681,  346, 1102, 1102, 1102, 1102,    0,    0,    0, 
         1102, 1102,    0, 1102,    0,    0,    0,    0,    0,    0, 
            0,  793,    0,    0,    0,    0,    0,    0,    0,  681, 
         1025,  681,  681,  836,  836,    0,  303,  303,  303,  836, 
          836,  303,  303,  303,    0,  303,  233,    0,    0,    0, 
            0,    0,  233,  303,    0,  303,  303,  303,  233,    0, 
            0,  793,  681,  681,  793,  303,  303,    0,  303,  303, 
          303,  303,  233,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  793,  836,  836,    0,  836,  836,  233,    0, 
            0,    0,    0,    0,    0,    0,  303,    0,  303,    0, 
            0,    0,  134,    0,    0,    0,  403,  398,    0, 1078, 
         1079,  401,  399,    0,  400,    0,  402,    0,    0,    0, 
            0, 1102,  836,    0, 1102,  303,    0, 1135,    0,  395, 
          303,  394, 1102,  134,  836,  233,  134,  575,  354,    0, 
            0,  576,    0,    0,  303,    0,    0,  303,    0,    0, 
          233,    0,    0,  134,    0,    0,  836,    0,    0,    0, 
            0,    0,    0,  397,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  354,    0,    0,    0,    0,    0, 1102, 
          135,    0,    0,  396,    0,  793,  793,  793,    0,  793, 
          681,  681,  681,  793,  793,  681,  681,  681,  793,  681, 
          793,  793,  793,  793,  793,  793,  793,  681,  793,  681, 
          681,  681,  793,  793,  793,  793,  793,  793,  793,  681, 
          681,  793,  681,  681,  681,  681,  681,  575,  793,  233, 
            0,  793,  793,  793,  793,  793,  793,  793,  793,  793, 
          793,  793,  793,  793,  793,  793,  793,  793,  346,  346, 
          681,  793,  681,    0,  793,  793,  681,  681,  681,  681, 
          681,  681,  681,  681,  681,  681,  681,  681,  681,  793, 
          793,    0,    0,  681,  681,  681,  681,  793,  693,  681, 
          793,  793,  793,  793,  681,  793,  793,  793,  793,  793, 
          793,  793,  793,  793,  793,  684,  793,  793,  681,    0, 
            0,  681,    0,    0,    0,  684,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  794,    0, 
            0,    0,  684,  684,    0,  794,  684,  684,  684,  684, 
          684,  684,  684,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  684,  684,  684,  139,  684,  684,    0, 
            0,  134,    0,    0,    0,    0,    0,  233,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  684,  377,  684,  684, 
            0,    0,  382,  383,    0,  563,    0,  564,  565,  566, 
          567,  568,    0, 1317,  390,  391,    0,    0, 1324,    0, 
            0,    0,  798,    0,    0,    0,    0,  569,  794,  684, 
          684,  794,  798,    0,    0,    0,    0,    0,    0,  354, 
          354,  570,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  571,    0,    0,    0,  793,  572,  573,  574,  798, 
          798,    0,  793,  798,  798,  798,  798,  798,  798,  798, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          798,  798,  798,  150,  798,  798,    0,    0,    0,    0, 
            0,    0,    0,    0, 1373, 1375, 1377, 1379,    0,    0, 
            0, 1381,    0,    0,    0,  563,    0,  564,  565,  566, 
          567,  568,    0,  798,    0,  798,  798,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  569, 1392, 1393, 
         1395, 1396,    0,    0,    0,    0,    0, 1398,    0,    0, 
            0,  570,    0,    0,    0,  798,  798,  798,  793,    0, 
            0,  571,    0,    0,    0,    0,    0,  573,  574,    0, 
            0,    0,  794,  794,  794,    0,  794,  684,  684,  684, 
          794,  794,  684,  684,  684,  794,  684,  794,  794,  794, 
          794,  794,  794,  794,  684,  794,  684,  684,  684,  794, 
          794,  794,  794,  794,  794,  794,  684,  684,  794,  684, 
          684,  684,  684,  684,  575,  794,    0,    0,  794,  794, 
          794,  794,  794,  794,  794,  794,  794,  794,  794,  794, 
          794,  794,  794,  794,  794,    0,    0,  684,  794,  684, 
            0,  794,  794,  684,  684,  684,  684,  684,  684,  684, 
          684,  684,  684,  684,  684,  684,  794,  794,    0,    0, 
          684,  684,  684,  684,  794,  696,  684,  794,  794,  794, 
          794,  684,  794,  794,  794,  794,  794,  794,  794,  794, 
          794,  794,    0,  794,  794,  684,    0,    0,  684,  793, 
          793,  793,    0,  793,  798,  798,  798,  793,  793,  798, 
          798,  798,  793,  798,  793,  793,  793,  793,  793,  793, 
          793,  798,  798,  798,  798,  798,  793,  793,  793,  793, 
          793,  793,  793,  798,  798,  793,  798,  798,  798,  798, 
          798,    0,  793,    0,    0,  793,  793,  793,  793,  793, 
          793,  793,  793,  793,  793,  793,  793,  793,  793,  793, 
          793,  793,    0,    0,  798,  793,  798,    0,  793,  793, 
          798,  798,  798,  798,  798,  798,  798,  798,  798,  798, 
          798,  798,  798,  793,  793,    0,    0,  798,  798,  798, 
          798,  793,    0,  798,  793,  793,  793,  793,  798,  793, 
          793,  793,  793,  793,  793,  793,  793,  793,  793,  793, 
          793,  793,  798,    0,    0,  798,    0,    0,    0,  793, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  793,    0,    0,    0,  793,  793,    0,  793, 
          793,  793,  793,  793,  793,  793,  793,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  793,  793,  793, 
          149,  793,  793,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  563,    0,  564,  565,  566,  567,  568,    0, 
          793,    0,  793,  793,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  569,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  794,    0,    0,    0, 
            0,    0,  793,  793,  793,  793,  794,    0,  571,    0, 
            0,    0,    0,    0,  573,  574,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  794, 
            0,    0,    0,  794,  794,    0,  794,  794,  794,  794, 
          794,  794,  794,  794,    0,    0,    0,    0,    0,    0, 
         1080, 1081, 1082, 1083,  794,  794,  794,  151,  794,  794, 
            0,    0,    0,    0,    0,    0, 1084, 1085, 1086,    0, 
            0,    0,    0,    0,    0,    0,   40,   41,   42,   43, 
           44,    0,    0,    0,    0,    0,  306,  794,    0,  794, 
          794,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  794, 
          794,  794,  794,   58,   59,   60,   61,   62,   63,   64, 
            0,   65,   66,    0,    0,    0,  793,  793,  793,    0, 
          793,  793,  793,  793,  793,  793,  793,  793,  793,  793, 
          793,  793,  793,  793,  793,  793,  793,  793,  793,  793, 
          793,  793,  793,  793,  793,  793,  793,  793,  793,  793, 
          793,  793,  793,  793,  793,  793,  793,  793,    0,  793, 
            0,    0,  793,  793,  793,  793,  793,  793,  793,  793, 
          793,  793,  793,  793,  793,  793,  793,  793,  793,    0, 
            0,  793,  793,  793,    0,  793,  793,  793,  793,  793, 
          793,  793,  793,  793,  793,  793,  793,  793,  793,  793, 
          793,  793,    0,    0,  793,  793,  793,  793,  793,    0, 
          793,  793,  793,  793,  793,  793,  793,  793,  793,  793, 
          793,  793,  793,  793,  793,  793,    0,  793,  793,  793, 
            0,    0,  793,  794,  794,  794,    0,  794,  794,  794, 
          794,  794,  794,  794,  794,  794,  794,  794,  794,  794, 
          794,  794,  794,  794,  794,  794,  794,  794,  794,  794, 
          794,  794,  794,  794,  794,  794,  794,  794,  794,  794, 
          794,  794,  794,  794,  794,    0,  794,    0,    0,  794, 
          794,  794,  794,  794,  794,  794,  794,  794,  794,  794, 
          794,  794,  794,  794,  794,  794,    0,    0,  794,  794, 
          794,    0,  794,  794,  794,  794,  794,  794,  794,  794, 
          794,  794,  794,  794,  794,  794,  794,  794,  794,    0, 
            0,  794,  794,  794,  794,  794,    0,  794,  794,  794, 
          794,  794,  794,  794,  794,  794,  794,  794,  794,  794, 
          794,  794,  794,  347,  794,  794,  794,    0,    0,  794, 
            0,    0,    0,  347,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  795,    0,    0,    0, 
          347,  347,    0,  795,  347,  347,  347,  347,  347,  347, 
          347,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  347,  347,  347,    0,  347,  347,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  347,    0,  347,  347,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          799,    0,    0,    0,    0,    0,  795,  347,  347,  795, 
          799,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  795,    0,    0,    0,  799,  799,    0, 
          795,  799,  799,  799,  799,  799,  799,  799,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  799,  799, 
          799,    0,  799,  799,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  799,    0,  799,  799,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  799,  799,  799,  795,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          795,  795,  795,    0,  795,  347,  347,  347,  795,  795, 
          347,  347,  347,  795,  347,  795,  795,  795,  795,  795, 
          795,  795,  347,  795,  347,  347,  347,  795,  795,  795, 
          795,  795,  795,  795,  347,  347,  795,  347,  347,  347, 
          347,  347,    0,  795,    0,    0,  795,  795,  795,  795, 
          795,  795,  795,  795,  795,  795,  795,  795,  795,  795, 
          795,  795,  795,    0,    0,  347,  795,  347,    0,  795, 
          795,  347,  347,  347,  347,  347,  347,  347,  347,  347, 
          347,  347,  347,  347,  795,  795,    0,    0,  347,  347, 
          347,  347,  795,    0,  347,  795,  795,  795,  795,  347, 
          795,  795,  795,  795,  795,  795,  795,  795,  795,  795, 
            0,  795,  795,  347,    0,    0,  347,  795,  795,  795, 
            0,  795,  799,  799,  799,  795,  795,  799,  799,  799, 
          795,  799,  795,  795,  795,  795,  795,  795,  795,  799, 
          799,  799,  799,  799,  795,  795,  795,  795,  795,  795, 
          795,  799,  799,  795,  799,  799,  799,  799,  799,    0, 
          795,    0,    0,  795,  795,  795,  795,  795,  795,  795, 
          795,  795,  795,  795,  795,  795,  795,  795,  795,  795, 
            0,    0,  799,  795,  799,    0,  795,  795,  799,  799, 
          799,  799,  799,  799,  799,  799,  799,  799,  799,  799, 
          799,  795,  795,    0,    0,  799,  799,  799,  799,  795, 
            0,  799,  795,  795,  795,  795,  799,  795,  795,  795, 
          795,  795,  795,  795,  795,  795,  795,  800,  795,  795, 
          799,    0,    0,  799,    0,    0,    0,  800,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          797,    0,    0,    0,  800,  800,    0,  797,  800,  800, 
          800,  800,  800,  800,  800,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  800,  800,  800,    0,  800, 
          800,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  800,    0, 
          800,  800,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  687, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  687, 
          800,  800,  800,  797,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  687,  687,    0,    0, 
          687,  687,  687,  687,  687,  687,  687,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  687,  687,  687, 
          142,  687,  687,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  218,    0,    0,    0,    0,    0,    0, 
          687,    0,  687,  687,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  218,    0,  218,    0,  218,    0,    0,    0,  689, 
            0,    0,    0,  687,  687,    0,    0,    0,    0,    0, 
            0,    0,  218,    0,  218,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  797,  797,  797,    0,  797,  800, 
          800,  800,  797,  797,  800,  800,  800,  797,  800,  797, 
          797,  797,  797,  797,  797,  797,  800,  800,  800,  800, 
          800,  797,  797,  797,  797,  797,  797,  797,  800,  800, 
          797,  800,  800,  800,  800,  800,    0,  797,    0,    0, 
          797,  797,  797,  797,  797,  797,  797,  797,  797,  797, 
          797,  797,  797,  797,  797,  797,  797,    0,    0,  800, 
          797,  800,    0,  797,  797,  800,  800,  800,  800,  800, 
          800,  800,  800,  800,  800,  800,  800,  800,  797,  797, 
            0,    0,  800,  800,  800,  800,  797,    0,  800,  797, 
          797,  797,  797,  800,  797,  797,  797,  797,  797,  797, 
          797,  797,  797,  797,    0,  797,  797,  800,    0,    0, 
          800,  687,  687,  687,    0,    0,  687,  687,  687,    0, 
          687,    0,    0,    0,    0,    0,    0,    0,  687,    0, 
          687,  687,  687,    0,    0,    0,    0,    0,    0,    0, 
          687,  687,    0,  687,  687,  687,  687,  687,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  686,    0,    0,    0,    0, 
            0,  687,    0,  687,    0,  686,    0,  687,  687,  687, 
          687,  687,  687,  687,  687,  687,  687,  687,  687,  687, 
            0,    0,    0,    0,  687,  687,  687,  687,    0,  699, 
          687,    0,  686,  686,    0,  687,  686,  686,  686,  686, 
          686,  686,  686,    0,    0,    0,    0,    0,    0,  687, 
            0,    0,  687,  686,  686,  686,  141,  686,  686,  218, 
            0,  218,  218,  218,  218,  218,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  218,    0,    0,    0,    0,  686,    0,  686,  686, 
          688,    0,    0,    0,    0,  218,    0,    0,    0,    0, 
          688,  689,    0,    0,    0,  218,    0,    0,    0,    0, 
          218,  218,  218,    0,    0,    0,    0,    0,    0,  686, 
          686,    0,    0,    0,    0,    0,    0,  688,  688,    0, 
            0,  688,  688,  688,  688,  688,  688,  688,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  688,  688, 
          688,  143,  688,  688,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  688,    0,  688,  688,    0,    0,    0,  689,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  689,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  688,  688,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  689,  689,    0,    0,  689, 
          689,  689,  689,  689,  689,  689,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  689,  689,  689,  144, 
          689,  689,    0,    0,    0,    0,    0,  686,  686,  686, 
            0,    0,  686,  686,  686,    0,  686,    0,    0,    0, 
            0,    0,    0,    0,  686,    0,  686,  686,  686,  689, 
            0,  689,  689,    0,    0,    0,  686,  686,    0,  686, 
          686,  686,  686,  686,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  689,  689,    0,    0,    0,  686,    0,  686, 
            0,    0,    0,  686,  686,  686,  686,  686,  686,  686, 
          686,  686,  686,  686,  686,  686,    0,    0,    0,    0, 
          686,  686,  686,  686,    0,  698,  686,    0,    0,    0, 
            0,  686,  688,  688,  688,    0,    0,  688,  688,  688, 
            0,  688,    0,    0,    0,  686,    0,    0,  686,  688, 
            0,  688,  688,  688,    0,    0,    0,    0,    0,    0, 
            0,  688,  688,    0,  688,  688,  688,  688,  688,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  822,    0,    0, 
            0,    0,  688,    0,  688,    0,    0,  822,  688,  688, 
          688,  688,  688,  688,  688,  688,  688,  688,  688,  688, 
          688,    0,    0,    0,    0,  688,  688,  688,  688,    0, 
          700,  688,    0,    0,    0,    0,  688,    0,  822,    0, 
          689,  689,  689,    0,    0,  689,  689,  689,    0,  689, 
          688,    0,    0,  688,    0,    0,  822,  689,    0,  689, 
          689,  689,    0,    0,    0,    0,    0,    0,    0,  689, 
          689,    0,  689,  689,  689,  689,  689,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          822,    0,    0,    0,  691,    0,    0,    0,    0,    0, 
          689,    0,  689,    0,  691,    0,  689,  689,  689,  689, 
          689,  689,  689,  689,  689,  689,  689,  689,  689,    0, 
            0,    0,  822,  689,  689,  689,  689,    0,  701,  689, 
            0,  691,  691,    0,  689,  691,  691,  691,  691,  691, 
          691,  691,    0,    0,    0,    0,    0,    0,  689,    0, 
            0,  689,  691,  691,  691,  146,  691,  691,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  691,    0,  691,  691,  690, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  690, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  691,  691, 
            0,    0,    0,    0,    0,    0,  690,  690,    0,    0, 
          690,  690,  690,  690,  690,  690,  690,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  690,  690,  690, 
          145,  690,  690,    0,    0,    0,    0,    0,    0,  822, 
          822,  822,    0,    0,  822,  822,  822,    0,  822,    0, 
            0,    0,    0,    0,    0,    0,  822,    0,  822,  822, 
          690,    0,  690,  690,    0,    0,    0,  692,  822,  822, 
            0,  822,  822,  822,  822,  822,    0,  692,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  690,  690,    0,    0,    0,    0,  822, 
            0,  822,    0,    0,  692,  692,    0,    0,  692,  692, 
          692,  692,  692,  692,  692,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  692,  692,  692,  147,  692, 
          692,    0,    0,  822,    0,    0,  691,  691,  691,    0, 
            0,  691,  691,  691,    0,  691,    0,  822,    0,    0, 
            0,    0,    0,  691,    0,  691,  691,  691,  692,    0, 
          692,  692,    0,    0,    0,  691,  691,    0,  691,  691, 
          691,  691,  691,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  692,  692,    0,    0,    0,  691,    0,  691,    0, 
            0,    0,  691,  691,  691,  691,  691,  691,  691,  691, 
          691,  691,  691,  691,  691,    0,    0,    0,    0,  691, 
          691,  691,  691,    0,  703,  691,    0,    0,    0,    0, 
          691,  690,  690,  690,    0,    0,  690,  690,  690,    0, 
          690,    0,    0,    0,  691,    0,    0,  691,  690,    0, 
          690,  690,  690,    0,    0,    0,    0,    0,    0,    0, 
          690,  690,    0,  690,  690,  690,  690,  690,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   85,    0,    0,    0, 
            0,  690,    0,  690,    0,    0,   85,  690,  690,  690, 
          690,  690,  690,  690,  690,  690,  690,  690,  690,  690, 
            0,    0,    0,    0,  690,  690,  690,  690,    0,  702, 
          690,    0,    0,    0,    0,  690,    0,   85,    0,  692, 
          692,  692,    0,    0,  692,  692,  692,    0,  692,  690, 
            0,    0,  690,    0,    0,   85,  692,    0,  692,  692, 
          692,    0,    0,    0,    0,    0,    0,    0,  692,  692, 
            0,  692,  692,  692,  692,  692,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   85, 
            0,    0,    0,  683,    0,    0,    0,    0,    0,  692, 
            0,  692,    0,  683,    0,  692,  692,  692,  692,  692, 
          692,  692,  692,  692,  692,  692,  692,  692,    0,    0, 
            0,   85,  692,  692,  692,  692,    0,  704,  692,    0, 
          683,  683,    0,  692,  683,  683,  683,  683,  683,  683, 
          683,    0,    0,    0,    0,    0,    0,  692,    0,    0, 
          692,  683,  683,  683,  138,  683,  683,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  683,    0,  683,  683,  682,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  682,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  683,  683,    0, 
            0,    0,    0,    0,    0,  682,  682,    0,    0,  682, 
          682,  682,  682,  682,  682,  682,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  682,  682,  682,  137, 
          682,  682,    0,    0,    0,    0,    0,    0,   85,   85, 
           85,    0,    0,   85,   85,   85,    0,   85,    0,    0, 
            0,    0,    0,    0,    0,   85,    0,   85,   85,  682, 
            0,  682,  682,    0,    0,    0,  685,   85,   85,    0, 
           85,   85,   85,   85,   85,    0,  685,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  682,  682,    0,    0,    0,    0,   85,    0, 
           85,    0,    0,  685,  685,    0,    0,  685,  685,  685, 
          685,  685,  685,  685,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  685,  685,  685,  140,  685,  685, 
            0,    0,    0,    0,    0,  683,  683,  683,    0,    0, 
          683,  683,  683,    0,  683,    0,   85,    0,    0,    0, 
            0,    0,  683,    0,  683,  683,  683,  685,    0,  685, 
          685,    0,    0,    0,  683,  683,    0,  683,  683,  683, 
          683,  683,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          685,  685,    0,    0,    0,  683,    0,  683,    0,    0, 
            0,  683,  683,  683,  683,  683,  683,  683,  683,  683, 
          683,  683,  683,  683,    0,    0,    0,    0,  683,  683, 
          683,  683,    0,  695,  683,    0,    0,    0,    0,  683, 
          682,  682,  682,    0,    0,  682,  682,  682,    0,  682, 
            0,    0,    0,  683,    0,    0,  683,  682,    0,  682, 
          682,  682,    0,    0,    0,    0,    0,    0,    0,  682, 
          682,    0,  682,  682,  682,  682,  682,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   89,    0,    0,    0,    0, 
          682,    0,  682,    0,    0,   89,  682,  682,  682,  682, 
          682,  682,  682,  682,  682,  682,  682,  682,  682,    0, 
            0,    0,    0,  682,  682,  682,  682,    0,  694,  682, 
            0,    0,    0,    0,  682,    0,   89,    0,  685,  685, 
          685,    0,    0,  685,  685,  685,    0,  685,  682,    0, 
            0,  682,    0,    0,   89,  685,    0,  685,  685,  685, 
            0,    0,    0,    0,    0,    0,    0,  685,  685,    0, 
          685,  685,  685,  685,  685,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   89,    0, 
            0,    0,  495,    0,    0,    0,    0,    0,  685,    0, 
          685,    0,  495,    0,  685,  685,  685,  685,  685,  685, 
          685,  685,  685,  685,  685,  685,  685,    0,    0,    0, 
           89,  685,  685,  685,  685,    0,  697,  685,    0,  495, 
          495,    0,  685,  495,  495,  495,  495,  495,  495,  495, 
            0,    0,    0,    0,    0,    0,  685,    0,    0,  685, 
          495,  495,  495,    0,  495,  495,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  495,    0,  495,  495,  353,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  353,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  495,  495,  495,    0,    0, 
            0,    0,    0,    0,  353,  353,    0,  794,  353,  353, 
          353,  353,  353,  353,  353,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  353,  353,  353,  152,  353, 
          353,    0,    0,    0,    0,    0,    0,   89,   89,   89, 
            0,    0,   89,   89, 
      };
   }

   private static final int[] yyTable2() {
      return new int[] {

           89,    0,   89,    0,    0,    0,    0,    0,    0,    0, 
           89,    0,   89,   89,  353,    0,  353,  353,    0,    0, 
            0,  821,   89,   89,    0,   89,   89,   89,   89,   89, 
            0,  821,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  353,  353,    0, 
            0,    0,    0,   89,    0,   89,    0,    0,  821,  821, 
            0,    0,  821,  821,  821,  821,  821,  821,  821,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  821, 
          821,  821,    0,  821,  821,    0,    0,    0,    0,    0, 
          495,  495,  495,    0,    0,  495,  495,  495,    0,  495, 
            0,   89,    0,    0,    0,    0,    0,  495,  495,  495, 
          495,  495,  821,    0,  821,  821,    0,    0,    0,  495, 
          495,    0,  495,  495,  495,  495,  495,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  821,  821,  821,    0,    0,    0, 
          495,    0,  495,    0,    0,    0,  495,  495,  495,  495, 
          495,  495,  495,  495,  495,  495,  495,  495,  495,    0, 
            0,    0,    0,  495,  495,  495,  495,    0,    0,  495, 
            0,    0,    0,    0,  495,  353,  353,  353,    0,    0, 
          353,  353,  353,    0,  353,    0,    0,    0,  495,    0, 
            0,  495,  353,    0,  353,  353,  353,    0,    0,    0, 
            0,    0,    0,    0,  353,  353,    0,  353,  353,  353, 
          353,  353,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           87,    0,    0,    0,    0,  353,    0,  353,    0,    0, 
           87,  353,  353,  353,  353,  353,  353,  353,  353,  353, 
          353,  353,  353,  353,    0,    0,    0,    0,  353,  353, 
          353,  353,    0,    0,  353,    0,    0,    0,    0,  353, 
            0,   87,    0,  821,  821,  821,    0,    0,  821,  821, 
          821,    0,  821,  353,    0,    0,  353,    0,    0,   87, 
          821,  821,  821,  821,  821,    0,    0,    0,    0,    0, 
            0,    0,  821,  821,    0,  821,  821,  821,  821,  821, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   87,    0,    0,    0,  346,    0,    0, 
            0,    0,    0,  821,    0,  821,    0,  346,    0,  821, 
          821,  821,  821,  821,  821,  821,  821,  821,  821,  821, 
          821,  821,    0,    0,    0,   87,  821,  821,  821,  821, 
            0,    0,  821,    0,  346,  346,    0,  821,  346,  346, 
          346,  346,  346,  346,  346,    0,    0,    0,    0,    0, 
            0,  821,    0,    0,  821,  346,  346,  346,  154,  346, 
          346,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  346,    0, 
          346,  346,  354,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  354,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  346,  346,    0,    0,    0,    0,    0,    0,  354, 
          354,    0,    0,  354,  354,  354,  354,  354,  354,  354, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          354,  354,  354,  153,  354,  354,    0,    0,    0,    0, 
            0,    0,   87,   87,   87,    0,    0,   87,   87,   87, 
            0,   87,    0,    0,    0,    0,    0,    0,    0,   87, 
            0,   87,   87,  354,    0,  354,  354,    0,    0,    0, 
          625,   87,   87,    0,   87,   87,   87,   87,   87,    0, 
          625,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  354,  354,    0,    0, 
            0,    0,   87,    0,   87,    0,    0,  625,  625,    0, 
            0,  625,  625,  625,  625,  625,  625,  625,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  625,  625, 
          625,    0,  625,  625,    0,    0,    0,    0,    0,  346, 
          346,  346,    0,    0,  346,  346,  346,    0,  346,    0, 
           87,    0,    0,    0,    0,    0,  346,    0,  346,  346, 
          346,  625,    0,  625,  625,    0,    0,    0,  346,  346, 
            0,  346,  346,  346,  346,  346,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  625,  625,    0,    0,    0,  346, 
            0,  346,    0,    0,    0,  346,  346,  346,  346,  346, 
          346,  346,  346,  346,  346,  346,  346,  346,    0,    0, 
            0,    0,  346,  346,  346,  346,    0,    0,  346,    0, 
            0,    0,    0,  346,  354,  354,  354,    0,    0,  354, 
          354,  354,    0,  354,    0,    0,    0,  346,    0,    0, 
          346,  354,    0,  354,  354,  354,    0,    0,    0,    0, 
            0,    0,    0,  354,  354,    0,  354,  354,  354,  354, 
          354,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  567, 
            0,    0,    0,    0,  354,    0,  354,    0,    0,  567, 
          354,  354,  354,  354,  354,  354,  354,  354,  354,  354, 
          354,  354,  354,    0,    0,    0,    0,  354,  354,  354, 
          354,    0,    0,  354,    0,    0,    0,    0,  354,    0, 
          567,    0,  625,  625,  625,    0,    0,  625,  625,  625, 
            0,  625,  354,    0,    0,  354,    0,    0,  567,  625, 
            0,  625,  625,  625,    0,    0,    0,    0,    0,    0, 
            0,  625,  625,    0,  625,  625,  625,  625,  625,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  567,    0,    0,    0,  285,    0,    0,    0, 
            0,    0,  625,    0,  625,    0,  285,    0,  625,  625, 
          625,  625,  625,  625,  625,  625,  625,  625,  625,  625, 
          625,    0,    0,    0,  567,  625,  625,  625,  625,    0, 
            0,  625,    0,  285,  285,    0,  625,  285,  285,  285, 
          285,  285,  392,  285,    0,    0,    0,    0,    0,    0, 
          625,    0,    0,  625,  285,  285,  285,    0,  285,  285, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  392,    0,  285, 
          285,  365,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  365,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          285,  285,    0,    0,    0,    0,    0,    0,  365,  365, 
            0,    0,  365,  365,  365,  365,  365,  365,  365,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  365, 
          365,  365,    0,  365,  365,    0,    0,    0,    0,    0, 
            0,  567,  567,  567,    0,    0,  567,  567,  567,    0, 
          567,    0,    0,    0,    0,    0,    0,    0,  567,    0, 
          567,    0,  365,    0,  365,  365,    0,    0,    0,  360, 
          567,  567,    0,  567,  567,  567,  567,  567,    0,  360, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  365,  365,    0,    0,    0, 
            0,  567,    0,  567,    0,    0,  360,  360,    0,    0, 
          360,  360,  360,  360,  360,  360,  360,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  360,  360,  360, 
            0,  360,  360,    0,    0,    0,    0,    0,  285,  285, 
          285,    0,    0,  285,  285,  285,    0,  285,    0,  567, 
            0,    0,    0,    0,    0,  285,    0,  285,  285,  285, 
          360,    0,  360,  360,    0,    0,    0,  285,  285,    0, 
          285,  285,  285,  285,  285,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  360,  360,    0,    0,    0,  285,    0, 
          285,    0,    0,    0,  285,  285,  285,  285,  285,  285, 
          285,  285,  285,  285,  285,  285,  285,    0,    0,    0, 
            0,  285,  285,  392,  392,    0,    0,  285,    0,    0, 
            0,    0,  285,  365,  365,  365,    0,  303,  365,  365, 
          365,    0,  365,    0,    0,    0,  285,  303,    0,  285, 
          365,    0,  365,  365,  365,    0,    0,    0,    0,    0, 
            0,    0,  365,  365,    0,  365,  365,  365,  365,  365, 
            0,    0,    0,    0,    0,    0,    0,    0,  303,    0, 
            0,  298,    0,    0,    0,    0,    0,  558,    0,    0, 
            0,    0,    0,  365,    0,  365,  303,  558,    0,  365, 
          365,  365,  365,  365,  365,  365,  365,  365,  365,  365, 
          365,  365,    0,    0,    0,    0,  365,  365,  365,  365, 
            0,    0,  365,    0,    0,    0,    0,  365,  558,    0, 
            0,  360,  360,  360,    0,    0,  360,  360,  360,    0, 
          360,  365,    0,    0,  365,    0,  558,    0,  360,    0, 
          360,  360,  360,    0,    0,    0,    0,    0,    0,    0, 
          360,  360,  303,  360,  360,  360,  360,  360,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          558,    0,    0,    0,    0,  673,    0,    0,    0,    0, 
            0,  360,    0,  360,    0,  673,    0,  360,  360,  360, 
          360,  360,  360,  360,  360,  360,  360,  360,  360,  360, 
            0,    0,  558,    0,  360,  360,  360,  360,    0,    0, 
          360,    0,  673,  673,    0,  360,  673,  673,  673,  673, 
          673,  673,  673,    0,    0,    0,    0,    0,    0,  360, 
            0,    0,  360,  673,  673,  673,    0,  673,  673,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  673,    0,  673,  673, 
          252,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          252,    0,    0,    0,    0,    0,    0,    0,    0,  303, 
          303,  303,    0,    0,    0,  303,  303,    0,  303,  673, 
          673,    0,    0,    0,    0,    0,  303,  252,  252,    0, 
            0,  252,  252,  252,  252,  252,    0,  252,  303,  303, 
            0,  303,  303,  303,  303,    0,    0,    0,  252,  252, 
          252,    0,  252,  252,    0,    0,    0,    0,    0,  558, 
          558,  558,    0,    0,  558,  558,  558,    0,  558,  303, 
            0,  303,    0,    0,    0,    0,  558,    0,  558,    0, 
            0,    0,    0,  252,  252,    0,  253,    0,  558,  558, 
            0,  558,  558,  558,  558,  558,  253,    0,  303,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  252,  252,    0,  303,    0,  558, 
            0,  558,    0,  253,  253,    0,    0,  253,  253,  253, 
          253,  253,    0,  253,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  253,  253,  253,    0,  253,  253, 
            0,    0,    0,    0,    0,    0,    0,  673,  673,  673, 
            0,    0,  673,  673,  673,    0,  673,  558,    0,    0, 
            0,    0,    0,    0,  673,    0,  673,  673,  673,  253, 
          253,    0,    0,    0,    0,    0,  673,  673,    0,  673, 
          673,  673,  673,  673,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  577,    0, 
          253,  253,    0,    0,    0,    0,    0,  673,  577,  673, 
            0,    0,    0,    0,  673,  673,  673,  673,  673,  673, 
          673,  673,  673,  673,  673,  673,    0,    0,    0,    0, 
          673,  673,  673,  673,    0,    0,  673,  200,    0,  577, 
            0,  673,  252,  252,  252,    0,    0,  252,  252,  252, 
            0,  252,    0,    0,    0,  673,    0,  577,  673,  252, 
            0,  252,  252,  252,    0,  200,    0,  200,    0,  200, 
            0,  252,  252,  691,  252,  252,  252,  252,  252,    0, 
            0,    0,    0,    0,    0,    0,  200,    0,  200,    0, 
            0,  577,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  252,    0,  252,    0,    0,    0,  252,  252, 
          252,  252,  252,  252,  252,  252,  252,  252,  252,  252, 
          252,    0,    0,  577,    0,  252,  252,    0,    0,    0, 
            0,  252,    0,    0,    0,    0,  252,    0,  253,  253, 
          253,    0,    0,  253,  253,  253,    0,  253,    0,    0, 
          252,    0,    0,  252,    0,  253,    0,  253,  253,  253, 
            0,    0,    0,    0,    0,    0,    0,  253,  253,    0, 
          253,  253,  253,  253,  253,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  264,    0,    0,    0,    0,    0,  253,    0, 
          253,    0,  264,    0,  253,  253,  253,  253,  253,  253, 
          253,  253,  253,  253,  253,  253,  253,    0,    0,    0, 
            0,  253,  253,    0,    0,    0,    0,  253,    0,  264, 
          264,    0,  253,  264,  264,  264,  264,  264,    0,  264, 
            0,    0,    0,    0,    0,    0,  253,    0,    0,  253, 
          264,  264,  264,    0,  264,  264,    0,    0,    0,    0, 
          577,  577,  577,    0,    0,  577,  577,  577,    0,  577, 
            0,    0,    0,    0,    0,    0,    0,  577,    0,  577, 
            0,    0,    0,    0,    0,  264,  264,  261,    0,  577, 
          577,    0,  577,  577,  577,  577,  577,  261,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  264,  264,    0,    0, 
          577,    0,  577,    0,  261,  261,    0,    0,  261,  261, 
          261,  261,  261,  200,  261,  200,  200,  200,  200,  200, 
            0,    0,    0,    0,    0,  261,  261,  261,    0,  261, 
          261,    0,    0,    0,    0,  200,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  577,  200, 
            0,    0,    0,    0,    0,  691,    0,    0,    0,  200, 
          261,  261,    0,  258,  200,  200,  200,    0,    0,    0, 
            0,    0,    0,  258,  403,  398,    0,    0,    0,  401, 
          399,    0,  400,    0,  402,    0,    0,    0,    0,    0, 
            0,  261,  261,    0,    0,    0,    0,  395,    0,  394, 
          258,  258,    0,    0,  258,  258,  258,  258,  258,    0, 
          258,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  258,  258,  258,    0,  258,  258,    0,    0,    0, 
            0,  397,    0,    0,  264,  264,  264,    0,    0,  264, 
          264,  264,    0,  264,    0,    0,    0,    0,    0,    0, 
            0,  264,    0,  264,  264,  264,  258,  258,    0,    0, 
            0,  396,    0,  264,  264,    0,  264,  264,  264,  264, 
          264,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  551,    0,  258,  258,    0, 
            0,    0,    0,    0,  264,  551,  264,    0,    0,    0, 
            0,  264,  264,  264,  264,  264,  264,  264,  264,  264, 
          264,  264,  264,    0,    0,    0,    0,  264,  264,    0, 
            0,    0,    0,  264,  201,    0,  551,    0,  264,  261, 
          261,  261,    0,    0,  261,  261,  261,    0,  261,    0, 
            0,    0,  264,    0,  551,  264,  261,    0,  261,  261, 
          261,    0,  201,    0,  201,    0,  201,    0,  261,  261, 
          690,  261,  261,  261,  261,  261,    0,    0,    0,    0, 
            0,    0,    0,  201,    0,  201,    0,    0,  551,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  261, 
            0,  261,    0,    0,    0,    0,  261,  261,  261,  261, 
          261,  261,  261,  261,  261,  261,  261,  261,    0,    0, 
          551,    0,  261,  261,    0,    0,    0,    0,  261,    0, 
            0,    0,    0,  261,    0,  258,  258,  258,    0,    0, 
          258,  258,  258,    0,  258,    0,    0,  261,    0,    0, 
          261,    0,  258,    0,  258,  258,  258,    0,    0,    0, 
            0,    0,    0,    0,  258,  258,    0,  258,  258,  258, 
          258,  258,    0,    0,    0,  377,  378,  379,  380,  381, 
          382,  383,  384,  385,  386,  387,    0,    0,    0,  259, 
            0,    0,  390,  391,    0,  258,    0,  258,    0,  259, 
            0,    0,  258,  258,  258,  258,  258,  258,  258,  258, 
          258,  258,  258,  258,    0,    0,    0,    0,  258,  258, 
            0,    0,    0,    0,  258,    0,  259,  259,    0,  258, 
          259,  259,  259,  259,  259,    0,  259,    0,    0,    0, 
            0,    0,    0,  258,    0,    0,  258,  259,  259,  259, 
            0,  259,  259,    0,    0,    0,    0,  551,  551,  551, 
            0,    0,  551,  551,  551,    0,  551,    0,    0,    0, 
            0,    0,    0,    0,  551,    0,  551,    0,    0,    0, 
            0,    0,  259,  259,  260,    0,  551,  551,    0,  551, 
          551,  551,  551,  551,  260,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  259,  259,    0,    0,  551,    0,  551, 
            0,  260,  260,    0,    0,  260,  260,  260,  260,  260, 
          201,  260,  201,  201,  201,  201,  201,    0,    0,    0, 
            0,    0,  260,  260,  260,    0,  260,  260,    0,    0, 
            0,    0,  201,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  551,  201,    0,    0,    0, 
            0,    0,  690,    0,    0,    0,  201,  260,  260,    0, 
          262,  201,  201,  201,    0,    0,    0,    0,    0,    0, 
          262,  403,  398,    0,    0,    0,  401,  399,    0,  400, 
            0,  402,    0,    0,    0,    0,    0,    0,  260,  260, 
            0,    0,    0,    0,  395,    0,  394,  262,  262,    0, 
            0,  262,  262,  262,  262,  262,    0,  262,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  262,  262, 
          262,    0,  262,  262,    0,    0,    0,    0,  397,    0, 
            0,  259,  259,  259,    0,    0,  259,  259,  259,    0, 
          259,    0,    0,    0,    0,    0,    0,    0,  259,    0, 
          259,  259,  259,  262,  262,    0,    0,    0,  396,    0, 
          259,  259,    0,  259,  259,  259,  259,  259,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  568,    0,  262,  262,    0,    0,    0,    0, 
            0,  259,  568,  259,    0,    0,    0,    0,  259,  259, 
          259,  259,  259,  259,  259,  259,  259,  259,  259,  259, 
            0,    0,    0,    0,  259,  259,    0,    0,    0,    0, 
          259,  202,    0,  568,    0,  259,  260,  260,  260,    0, 
            0,  260,  260,  260,    0,  260,    0,    0,    0,  259, 
            0,  568,  259,  260,    0,  260,  260,  260,    0,  202, 
            0,  202,    0,  202,    0,  260,  260,  692,  260,  260, 
          260,  260,  260,    0,    0,    0,    0,    0,    0,    0, 
          202,    0,  202,    0,    0,  568,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  260,    0,  260,    0, 
            0,    0,    0,  260,  260,  260,  260,  260,  260,  260, 
          260,  260,  260,  260,  260,    0,    0,  568,    0,  260, 
          260,    0,    0,    0,    0,  260,    0,    0,    0,    0, 
          260,    0,  262,  262,  262,    0,    0,  262,  262,  262, 
            0,  262,    0,    0,  260,    0,    0,  260,    0,  262, 
            0,  262,  262,  262,    0,    0,    0,    0,    0,    0, 
            0,  262,  262,    0,  262,  262,  262,  262,  262,    0, 
            0,    0,  377,  378,  379,  380,  381,  382,  383,  384, 
            0,  386,  387,    0,    0,    0,  283,    0,    0,  390, 
          391,    0,  262,    0,  262,    0,  283,    0,    0,  262, 
          262,  262,  262,  262,  262,  262,  262,  262,  262,  262, 
          262,    0,    0,    0,    0,  262,  262,    0,    0,    0, 
            0,  262,    0,  283,  283,    0,  262,  283,  283,  283, 
          283,  283,    0,  283,    0,    0,    0,    0,    0,    0, 
          262,    0,    0,  262,  283,  283,  283,    0,  283,  283, 
            0,    0,    0,    0,  568,  568,  568,    0,    0,  568, 
          568,  568,    0,  568,    0,    0,    0,    0,    0,    0, 
            0,  568,    0,  568,    0,    0,    0,    0,    0,  283, 
          283,  284,    0,  568,  568,    0,  568,  568,  568,  568, 
          568,  284,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          283,  283,    0,    0,  568,    0,  568,    0,  284,  284, 
            0,    0,  284,  284,  284,  284,  284,  202,  284,  202, 
          202,  202,  202,  202,    0,    0,    0,    0,    0,  284, 
          284,  284,    0,  284,  284,    0,    0,    0,    0,  202, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  568,  202,    0,    0,    0,    0,    0,  692, 
            0,    0,    0,  202,  284,  284,    0,  288,  202,  202, 
          202,    0,    0,    0,    0,    0,    0,  288,  403,  398, 
            0,    0,    0,  401,  399,    0,  400,    0,  402,    0, 
            0,    0,    0,    0,    0,  284,  284,    0,    0,    0, 
            0,  395,    0,  394,  288,  288,    0,    0,  288,  288, 
          288,  288,  288,    0,  288,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  288,  288,  288,    0,  288, 
          288,    0,    0,    0,    0,  397,    0,    0,  283,  283, 
          283,    0,    0,  283,  283,  283,    0,  283,    0,    0, 
            0,    0,    0,    0,    0,  283,    0,  283,  283,  283, 
          288,  288,    0,    0,    0,  396,    0,  283,  283,    0, 
          283,  283,  283,  283,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  552, 
            0,  288,  288,    0,    0,    0,    0,    0,  283,  552, 
          283,    0,    0,    0,  283,  283,  283,  283,  283,  283, 
          283,  283,  283,  283,  283,  283,  283,    0,    0,    0, 
            0,  283,  283,    0,    0,    0,    0,  283,    0,    0, 
          552,  335,  283,  284,  284,  284,    0,    0,  284,  284, 
          284,  335,  284,    0,    0,    0,  283,    0,  552,  283, 
          284,    0,  284,  284,  284,    0,    0,    0,    0,    0, 
            0,    0,  284,  284,    0,  284,  284,  284,  284,    0, 
            0,    0,  335,    0,    0,  330,    0,    0,    0,    0, 
            0,    0,  552,    0,    0,    0,    0,    0,    0,    0, 
          335,    0,    0,  284,    0,  284,    0,    0,    0,  284, 
          284,  284,  284,  284,  284,  284,  284,  284,  284,  284, 
          284,  284,    0,    0,  552,    0,  284,  284,    0,    0, 
            0,    0,  284,    0,    0,    0,    0,  284,    0,  288, 
          288,  288,    0,    0,  288,  288,  288,    0,  288,    0, 
            0,  284,    0,    0,  284,    0,  288,    0,  288,  288, 
          288,    0,    0,    0,    0,    0,  335,    0,  288,  288, 
            0,  288,  288,  288,  288,    0,    0,    0,    0,  377, 
          378,  379,  380,  381,  382,  383,    0,    0,  386,  387, 
            0,    0,    0,  269,    0,    0,  390,  391,    0,  288, 
            0,  288,    0,  269,    0,  288,  288,  288,  288,  288, 
          288,  288,  288,  288,  288,  288,  288,  288,    0,    0, 
            0,    0,  288,  288,    0,    0,    0,    0,  288,    0, 
          269,  269,    0,  288,  269,  269,  269,  269,  269,    0, 
          269,    0,    0,    0,    0,    0,    0,  288,    0,    0, 
          288,  269,  269,    0,    0,    0,  269,    0,    0,    0, 
            0,  552,  552,  552,    0,    0,  552,  552,  552,    0, 
          552,    0,    0,    0,    0,    0,    0,    0,  552,    0, 
          552,    0,    0,    0,    0,    0,  269,  269,  256,    0, 
          552,  552,    0,  552,  552,  552,  552,  552,  256,    0, 
            0,    0,    0,  335,  335,  335,    0,    0,  335,  335, 
          335,    0,  335,    0,    0,    0,    0,  269,  269,    0, 
          335,  552,    0,  552,    0,    0,  256,    0,    0,  256, 
            0,  256,  256,  256,    0,  335,  335,  335,  335,  335, 
            0,    0,    0,    0,    0,    0,  256,  256,  256,    0, 
          256,  256,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  335,    0,  335,    0,    0,    0,  552, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  256,  256,    0,  257,    0,    0,    0,    0,    0, 
            0,    0,  335,    0,  257,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  335,  256,  256,    0,    0,    0,    0,    0,    0, 
            0,    0,  257,    0,    0,  257,    0,  257,  257,  257, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  257,  257,  257,    0,  257,  257,    0,    0, 
            0,    0,    0,    0,    0,  269,  269,  269,    0,    0, 
          269,  269,  269,    0,  269,    0,    0,    0,    0,    0, 
            0,    0,  269,    0,  269,  269,  269,  257,  257,    0, 
            0,    0,    0,    0,  269,  269,    0,  269,  269,  269, 
          269,  269,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  257,  257, 
            0,    0,    0,    0,    0,  269,    0,  269,    0,    0, 
            0,  269,  269,  269,  269,  269,    0,    0,  269,  269, 
          269,  269,  269,  269,    0,   42,    0,    0,  269,  269, 
            0,    0,    0,    0,  269,   42,    0,    0,    0,  269, 
          256,  256,  256,    0,    0,  256,  256,  256,    0,  256, 
            0,    0,    0,  269,    0,    0,  269,  256,    0,  256, 
          256,  256,    0,    0,    0,    0,   42,    0,    0,  256, 
          256,    0,  256,  256,  256,  256,  256,    0,    0,    0, 
            0,    0,    0,    0,   42,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          256,    0,  256,    0,    0,    0,    0,  256,  256,  256, 
          256,  256,  256,  256,  256,  256,  256,  256,  256,    0, 
            0,    0,    0,  256,  256,    0,    0,    0,    0,  256, 
            0,    0,    0,    0,  256,    0,  257,  257,  257,    0, 
            0,  257,  257,  257,    0,  257,    0,    0,  256,    0, 
           42,  256,    0,  257,    0,  257,  257,  257,    0,    0, 
            0,    0,    0,    0,    0,  257,  257,    0,  257,  257, 
          257,  257,  257,    0,    0,    0,    0,  277,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  277,    0,    0, 
            0,    0,    0,    0,    0,    0,  257,    0,  257,    0, 
            0,    0,    0,  257,  257,  257,  257,  257,  257,  257, 
          257,  257,  257,  257,  257,  277,    0,    0,  277,  257, 
          257,  277,    0,    0,    0,  257,    0,    0,    0,    0, 
          257,    0,    0,    0,    0,  277,  277,  277,    0,  277, 
          277,    0,    0,    0,  257,    0,    0,  257,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          277,  277,  278,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  278,    0,    0,    0,    0,   42,   42,   42, 
            0,    0,    0,   42,   42,    0,   42,    0,    0,    0, 
            0,  277,  277,    0,   42,    0,    0,    0,    0,    0, 
          278,    0,    0,  278,    0,    0,  278,    0,    0,   42, 
           42,   42,   42,   42,    0,    0,    0,    0,    0,    0, 
          278,  278,  278,    0,  278,  278,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   42,    0,   42, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  278,  278,    0,  267,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  267,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   42,  278,  278,    0,    0, 
            0,    0,    0,    0,    0,    0,  267,    0,    0,  267, 
            0,    0,  267,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  267,  267,  267,    0, 
          267,  267,    0,    0,    0,    0,    0,    0,    0,  277, 
          277,  277,    0,    0,  277,  277,  277,    0,  277,    0, 
            0,    0,    0,    0,    0,    0,  277,    0,  277,  277, 
          277,  267,  267,    0,    0,    0,    0,    0,  277,  277, 
            0,  277,  277,  277,  277,  277,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  267,  267,    0,    0,    0,    0,    0,  277, 
            0,  277,    0,    0,    0,    0,  277,  277,  277,  277, 
          277,  277,  277,  277,  277,  277,  277,  277,    0,    0, 
            0,    0,  277,  277,    0,    0,    0,    0,  277,    0, 
          252,    0,    0,  277,  278,  278,  278,    0,    0,  278, 
          278,  278,    0,  278,    0,    0,    0,  277,    0,    0, 
          277,  278,    0,  278,  278,  278,    0,    0,    0,    0, 
            0,    0,    0,  278,  278,    0,  278,  278,  278,  278, 
          278,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  278,    0,  278,    0,    0,    0, 
            0,  278,  278,  278,  278,  278,  278,  278,  278,  278, 
          278,  278,  278,    0, 1098,    0,    0,  278,  278,    0, 
            0,    0,    0,  278,    0,    0,    0,    0,  278,    0, 
          267,  267,  267,    0,    0,  267,  267,  267,    0,  267, 
            0,    0,  278,    0,    0,  278,    0,  267,    0,  267, 
          267,  267,    0,    0,    0,    0,    0,    0,    0,  267, 
          267,    0,  267,  267,  267,  267,  267,    0,  265,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  265,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          267,    0,  267,    0,    0,    0,    0,  267,  267,  267, 
          267,  267,  267,  267,  267,  267,  267,  267,  267,  265, 
            0,    0,  265,    0,    0,    0,    0,    0,    0,  267, 
            0,    0,    0,    0,  267,    0,  265,  265,  265,    0, 
          265,  265,    0,    0,    0,    0,    0,    0,  267,    0, 
            0,  267,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  266,    0,    0,    0,    0,    0, 
            0,  265,  265,    0,  266,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  265,  265,    0,  266,    0,    0,  266,    0, 
            0,    0,    0,    0,    0,    0,    0, 1080, 1081, 1082, 
         1083,    0,  266,  266,  266,    0,  266,  266,    0,    0, 
            0,    0,    0, 1084, 1085, 1086, 1087,    0,    0,    0, 
         1088,    0,    0,   40,   41,   42,   43,   44,    0,    0, 
            0,    0,    0,  306,    0,    0,    0,  266,  266,  293, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  293, 
            0, 1090, 1091,    0,    0,    0,    0,    0,    0, 1092, 
            0,    0, 1093,    0, 1094, 1095,    0, 1096,  266,  266, 
           58,   59,   60,   61,   62,   63,   64,    0,   65,   66, 
          293,    0,    0,  293,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  293,  293,  293, 
            0,  293,  293,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          265,  265,  265,    0,    0,  265,  265,  265,    0,  265, 
            0,    0,  293,    0,    0,    0,    0,  265,    0,  265, 
          265,  265,    0,    0,    0,    0,    0,    0,    0,  265, 
          265,    0,  265,  265,  265,  265,  265,    0,    0,    0, 
            0,  270,    0,    0,  293,    0,    0,    0,    0,    0, 
            0,  270,    0,    0,    0,    0,    0,    0,    0,    0, 
          265,    0,  265,    0,    0,    0,    0,  265,  265,  265, 
          265,  265,  265,  265,  265,  265,  265,  265,  265,    0, 
            0,    0,  270,    0,    0,  270,  266,  266,  266,  265, 
            0,  266,  266,  266,  265,  266,    0,    0,    0,  270, 
          270,    0,    0,  266,  270,  266,  266,  266,  265,    0, 
            0,  265,    0,    0,    0,  266,  266,    0,  266,  266, 
          266,  266,  266,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  270,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  266,    0,  266,    0, 
            0,    0,    0,  266,  266,  266,  266,  266,  266,  266, 
          266,  266,  266,  266,  266,    0,  270,    0,  294,    0, 
            0,    0,    0,    0,    0,  266,    0,    0,  294,    0, 
          266,  293,  293,  293,    0,    0,  293,  293,  293,    0, 
          293,    0,    0,    0,  266,    0,    0,  266,  293,    0, 
          293,  293,  293,    0,    0,    0,    0,    0,    0,  294, 
          293,  293,  294,  293,  293,  293,  293,  293,    0,    0, 
            0,    0,    0,    0,    0,    0,  294,  294,  294,    0, 
          294,  294,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  293,    0,  293,    0,    0,    0,    0,  293,  293, 
          293,  293,  293,  293,  293,  293,  293,  293,  293,  293, 
            0,  294,    0,    0,    0,    0,    0,    0,    0,    0, 
          293,    0,    0,    0,    0,  293,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  271,    0,    0,    0,  293, 
            0,    0,  293,  294,    0,  271,    0,    0,    0,    0, 
            0,    0,    0,  270,  270,  270,    0,    0,  270,  270, 
          270,    0,  270,    0,    0,    0,    0,    0,    0,    0, 
          270,    0,  270,  270,  270,    0,  271,    0,    0,  271, 
            0,    0,  270,  270,    0,  270,  270,  270,  270,  270, 
            0,    0,    0,  271,  271,    0,    0,    0,  271,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  270,    0,  270,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  270,  270,  271,    0, 
          270,  270,    0,    0,    0,  272,    0,    0,    0,    0, 
            0,    0,  270,    0,    0,  272,    0,  270,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          271,  270,    0,    0,  270,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  272,    0,    0,  272, 
          294,  294,  294,    0,    0,  294,  294,  294,    0,  294, 
            0,    0,    0,  272,  272,    0,    0,  294,  272,  294, 
          294,  294,    0,    0,    0,    0,    0,    0,    0,  294, 
          294,    0,  294,  294,  294,  294,  294,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  272,    0, 
            0,  279,    0,    0,    0,    0,    0,    0,    0,    0, 
          294,  279,  294,    0,    0,    0,    0,  294,  294,  294, 
          294,  294,  294,  294,  294,  294,  294,  294,  294,    0, 
          272,    0,    0,    0,    0,    0,    0,    0,    0,  294, 
            0,    0,  279,    0,  294,  279,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  294,  279, 
          279,  294,    0,    0,  279,    0,    0,  271,  271,  271, 
            0,    0,  271,  271,  271,    0,  271,    0,    0,    0, 
            0,    0,    0,    0,  271,    0,  271,  271,  271,    0, 
            0,    0,    0,    0,  279,    0,  271,  271,    0,  271, 
          271,  271,  271,  271,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  273,    0,    0,    0,  279,  271,    0,  271, 
            0,    0,  273,    0,    0,    0,    0,    0,    0,    0, 
          271,  271,    0,    0,  271,  271,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  271,    0,    0,    0, 
            0,  271,    0,  273,    0,    0,  273,  272,  272,  272, 
            0,    0,  272,  272,  272,  271,  272,    0,  271,    0, 
          273,  273,    0,    0,  272,  273,  272,  272,  272,    0, 
            0,    0,    0,    0,    0,    0,  272,  272,    0,  272, 
          272,  272,  272,  272,    0,    0,    0,    0,  274,    0, 
            0,    0,    0,    0,    0,  273,    0,    0,  274,    0, 
            0,    0,    0,    0,    0,    0,    0,  272,    0,  272, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          272,  272,    0,    0,  272,  272,    0,  273,    0,  274, 
            0,    0,  274,    0,    0,    0,  272,    0,    0,    0, 
            0,  272,    0,  279,  279,  279,  274,  274,  279,  279, 
          279,  274,  279,    0,    0,  272,    0,    0,  272,    0, 
          279,    0,  279,  279,  279,    0,    0,    0,    0,    0, 
            0,    0,  279,  279,    0,  279,  279,  279,  279,  279, 
            0,  274,    0,  280,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  280,    0,    0,    0,    0,  160,    0, 
            0,    0,    0,  279,    0,  279,    0,    0,    0,    0, 
            0,    0,    0,  274,    0,    0,  279,  279,    0,    0, 
          279,  279,    0,    0,  280,    0,  160,  280,  160,    0, 
          160,    0,  279,    0,  681,    0,    0,  279,    0,    0, 
            0,  280,  280,    0,    0,    0,  280,  160,    0,  160, 
            0,  279,    0,    0,  279,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  273,  273,  273,    0,    0,  273, 
          273,  273,    0,  273,    0,    0,  280,    0,    0,    0, 
            0,  273,    0,  273,  273,  273,    0,    0,    0,    0, 
            0,    0,    0,  273,  273,    0,  273,  273,  273,  273, 
          273,    0,    0,    0,    0,  254,    0,    0,  280,    0, 
            0,    0,    0,    0,    0,  254,    0,    0,    0,    0, 
            0,    0,    0,    0,  273,    0,  273,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  273,  273,    0, 
            0,  273,  273,    0,    0,    0,  254,    0,    0,  254, 
          274,  274,  274,  273,    0,  274,  274,  274,  273,  274, 
            0,    0,    0,  254,  254,    0,    0,  274,  254,  274, 
          274,  274,  273,    0,    0,  273,    0,    0,    0,  274, 
          274,    0,  274,  274,  274,  274,  274,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  254,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          274,    0,  274,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  274,  274,    0,    0,  274,  274,    0, 
          254,    0,  255,    0,    0,    0,    0,    0,    0,  274, 
            0,    0,  255,    0,  274,  280,  280,  280,    0,    0, 
          280,  280,  280,    0,  280,    0,    0,    0,  274,    0, 
            0,  274,  280,    0,  280,  280,  280,    0,    0,    0, 
            0,    0,    0,  255,  280,  280,  255,  280,  280,  280, 
          280,  280,    0,    0,    0,    0,    0,    0,    0,    0, 
          255,  255,    0,    0,  160,  255,  160,  160,  160,  160, 
          160,    0,    0,    0,    0,  280,    0,  280,    0,    0, 
            0,    0,    0,    0,    0,    0,  160,    0,    0,  280, 
            0,    0,  280,  280,    0,  255,    0,    0,    0,    0, 
          160,    0,    0,    0,  280,    0,  681,    0,    0,  280, 
          160,    0,    0,    0,    0,  160,  160,  160,  250,    0, 
            0,    0,    0,  280,    0,    0,  280,  255,  250,    0, 
            0,    0,    0,    0,    0,    0,    0,  254,  254,  254, 
            0,    0,  254,  254,  254,    0,  254,    0,    0,    0, 
            0,    0,    0,    0,  254,    0,  254,  254,  254,  250, 
            0,    0,  250,    0,    0,  251,  254,  254,    0,  254, 
          254,  254,  254,  254,    0,  251,  250,  250,    0,    0, 
            0,  250,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  254,    0,  254, 
            0,    0,    0,    0,    0,    0,  251,    0,    0,  251, 
            0,  250,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  251,  251,    0,  254,    0,  251,    0, 
            0,  254,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  250,    0,  254,    0,    0,  254,    0, 
            0,  281,    0,    0,    0,    0,    0,    0,  251,    0, 
            0,  281,    0,    0,  255,  255,  255,    0,    0,  255, 
          255,  255,    0,  255,    0,    0,    0,    0,    0,    0, 
            0,  255,    0,  255,  255,  255,    0,    0,    0,    0, 
          251,    0,  281,  255,  255,  281,  255,  255,  255,  255, 
          255,  286,    0,    0,    0,    0,    0,    0,    0,  281, 
          281,  286,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  255,    0,  255,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  286,    0,  281,  286,    0,    0,    0,    0, 
            0,    0,    0,  255,    0,    0,    0,    0,  255,  286, 
          286,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  255,    0,    0,  255,  281,    0,    0,    0, 
          250,  250,  250,    0,    0,  250,  250,  250,    0,  250, 
            0,    0,    0,    0,  286,    0,    0,  250,    0,  250, 
          250,  250,    0,    0,    0,    0,    0,    0,    0,  250, 
          250,    0,  250,  250,  250,  250,  250,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  286,  251,  251,  251, 
            0,    0,  251,  251,  251,  282,  251,    0,    0,    0, 
          250,    0,  250,    0,  251,  282,  251,  251,  251,    0, 
            0,    0,    0,    0,    0,    0,  251,  251,    0,  251, 
          251,  251,  251,  251,    0,    0,    0,    0,    0,  250, 
            0,    0,    0,    0,  250,    0,  282,    0,    0,  282, 
            0,    0,    0,    0,    0,    0,    0,  251,  250,  251, 
            0,  250,    0,  282,  282,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  281,  281,  281,  251,    0,  281,  281, 
          281,  251,  281,    0,    0,    0,    0,    0,  282,    0, 
          281,    0,  281,  281,  281,  251,    0,    0,  251,    0, 
            0,    0,  281,  281,    0,  281,  281,  281,  281,  281, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          282,    0,    0,  286,  286,  286,    0,    0,  286,  286, 
          286,  287,  286,  281,    0,  281,    0,    0,    0,    0, 
          286,  287,  286,  286,  286,    0,    0,    0,    0,    0, 
            0,    0,  286,  286,    0,  286,  286,  286,  286,  286, 
            0,    0,  281,    0,    0,    0,    0,  281,    0,    0, 
            0,    0,  287,    0,    0,  287,    0,    0,  304,    0, 
            0,  281,    0,  286,  281,  286,    0,    0,  304,  287, 
          287,    0,    0,  161,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  286,    0,    0,    0,    0,  286,    0,  304, 
            0,  161,  304,  161,  287,  161,    0,    0,    0,  684, 
            0,  286,    0,    0,  286,    0,  304,  304,    0,    0, 
            0,    0,  161,    0,  161,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  287,  282,  282,  282, 
            0,    0,  282,  282,  282,    0,  282,    0,    0,    0, 
            0,  304,    0,    0,  282,    0,  282,  282,  282,    0, 
            0,    0,    0,    0,    0,    0,  282,  282,    0,  282, 
          282,  282,  282,  282,    0,  495,    0,    0,    0,    0, 
            0,    0,    0,  304,    0,  495,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  282,    0,  282, 
            0,    0,    0,    0,    0,    0,    0,    0,  320,    0, 
            0,    0,  495,  495,    0,    0,  495,  495,  495,  495, 
          495,  495,  495,    0,    0,    0,  282,    0,    0,    0, 
            0,  282,    0,    0,  495,  495,    0,  495,  495,    0, 
            0,    0,    0,    0,    0,  282,    0,    0,  282,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  495,    0,  495,  495, 
            0,    0,    0,  287,  287,  287,    0,    0,  287,  287, 
          287,    0,  287,    0,    0,    0,    0,    0,    0,    0, 
          287,    0,  287,  287,  287,    0,    0,    0,  495,  495, 
          495,  320,  287,  287,    0,  287,  287,  287,  287,  287, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          304,  304,  304,    0,    0,  304,  304,  304,    0,  304, 
            0,    0,    0,  287,    0,  287,    0,  304,    0,  304, 
          304,  304,    0,    0,    0,    0,    0,    0,    0,  304, 
          304,    0,  304,  304,  304,  304,  304,    0,    0,    0, 
            0,    0,  287,    0,    0,    0,    0,  287,    0,  161, 
            0,  161,  161,  161,  161,  161,    0,    0,    0,    0, 
          304,  287,  304,    0,  287,    0,    0,    0,    0,    0, 
            0,  161,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  161,    0,    0,    0,  304, 
            0,  684,    0,    0,  304,  161,    0,    0,    0,    0, 
          161,  161,  161,    0,    0,    0,    0,    0,  304,    0, 
            0,  304,  320,  320,  320,    0,  320,  495,  495,  495, 
          320,  320,  495,  495,  495,  320,  495,  320,  320,  320, 
          320,  320,  320,  320,  495,  495,  495,  495,    0,  320, 
          320,  320,  320,  320,  320,  320,  495,  495,  320,  495, 
          495,  495,  495,  495,    0,  320,    0,    0,  320,  320, 
          320,  320,  320,  320,  320,  320,  320,  320,  320,  320, 
          320,  320,  320,  320,  320,    0,    0,  495,  320,  495, 
            0,  320,  320,  495,  495,  495,  495,  495,  495,  495, 
          495,  495,  495,  495,  495,  495,  320,  320,    0,    0, 
          495,  495,  495,  495,  320,    0,  495,  320,  320,  320, 
          320,  495,  320,  320,  320,  320,  320,  320,  320,  320, 
          320,  320,  821,  320,  320,  495,    0,    0,    0,    0, 
            0,    0,  821,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  320,    0,    0,    0,  821, 
          821,    0,    0,  821,  821,  821,  821,  821,  821,  821, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  821,  821,    0,  821,  821,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  821,    0,  821,  821,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  353, 
            0,    0,    0,    0,    0,  821,  821,  821,  320,  353, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  794,    0,    0,    0,  353,  353,    0,  794, 
          353,  353,  353,  353,  353,  353,  353,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  353,  353, 
          152,  353,  353,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          353,    0,  353,  353,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  353,  353,  794,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  320, 
          320,  320,    0,  320,  821,  821,  821,  320,  320,  821, 
          821,  821,  320,  821,  320,  320,  320,  320,  320,  320, 
          320,  821,  821,  821,  821,    0,  320,  320,  320,  320, 
          320,  320,  320,  821,  821,  320,  821,  821,  821,  821, 
          821,    0,  320,    0,    0,  320,  320,  320,  320,  320, 
          320,  320,  320,  320,  320,  320,  320,  320,  320,  320, 
          320,  320,    0,    0,  821,  320,  821,    0,  320,  320, 
          821,  821,  821,  821,  821,  821,  821,  821,  821,  821, 
          821,  821,  821,  320,  320,    0,    0,  821,  821,  821, 
          821,  320,    0,  821,  320,  320,  320,  320,  821,  320, 
          320,  320,  320,  320,  320,  320,  320,  320,  320,    0, 
          320,  320,  821,    0,    0,    0,  794,  794,  794,    0, 
          794,  353,  353,  353,  794,  794,  353,  353,  353,  794, 
          353,  794,  794,  794,  794,  794,  794,  794,  353,    0, 
          353,  353,    0,  794,  794,  794,  794,  794,  794,  794, 
          353,  353,  794,  353,  353,  353,  353,  353,    0,  794, 
            0,    0,  794,  794,  794,  794,  794,  794,  794,  794, 
          794,  794,  794,  794,  794,  794,  794,  794,  794,    0, 
            0,  353,  794,  353,    0,  794,  794,  353,  353,  353, 
          353,  353,  353,  353,  353,  353,  353,  353,  353,  353, 
          794,  794,    0,    0,  353,  353,  353,  353,  794,    0, 
          353,  794,  794,  794,  794,  353,  794,  794,  794,  794, 
          794,  794,  794,  794,  794,  794,  681,  794,  794,  353, 
            0,    0,    0,    0,    0,    0,  681,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  793, 
            0,    0,    0,  681,  681,    0,  793,  681,  681,  681, 
          117,  681,  681,  681,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  681,  681,  136,  681,  681, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  681,    0,    0, 
          681,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  684,    0,    0,    0,    0,    0,  793, 
          681,  681,  793,  684,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  794,    0,    0,    0, 
          684,  684,    0,  794,  684,  684,  684,  120,  684,  684, 
          684,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  684,  684,  139,  684,  684,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  684,    0,    0,  684,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  794,  684,  684,  794, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  793,  793,  793,    0,  793,  681,  681, 
          681,  793,  793,    0,  681,  681,  793,  681,  793,  793, 
          793,  793,  793,  793,  793,  681,  793,    0,    0,    0, 
          793,  793,  793,  793,  793,  793,  793,  681,  681,  793, 
          681,  681,  681,  681,  681,    0,  793,    0,    0,  793, 
          793,  793,  793,  793,  793,  793,  793,  793,  793,  793, 
          793,  793,  793,  793,  793,  793,    0,    0,  681,  793, 
          681,    0,  793,  793,  681,  681,  681,  681,  681,  681, 
          681,  681,  681,  681,  681,  681,  681,  793,  793,    0, 
            0,  681,  681,  681,  681,  793,  693,  681,  793,  793, 
          793,  793,    0,  793,  793,  793,  793,  793,  793,  793, 
          793,  793,  793,    0,  793,  793,  681,    0,    0,    0, 
          794,  794,  794,    0,  794,  684,  684,  684,  794,  794, 
            0,  684,  684,  794,  684,  794,  794,  794,  794,  794, 
          794,  794,  684,  794,    0,    0,    0,  794,  794,  794, 
          794,  794,  794,  794,  684,  684,  794,  684,  684,  684, 
          684,  684,    0,  794,    0,    0,  794,  794,  794,  794, 
          794,  794,  794,  794,  794,  794,  794,  794,  794,  794, 
          794,  794,  794,    0,    0,  684,  794,  684,    0,  794, 
          794,  684,  684,  684,  684,  684,  684,  684,  684,  684, 
          684,  684,  684,  684,  794,  794,    0,    0,  684,  684, 
          684,  684,  794,  696,  684,  794,  794,  794,  794,    0, 
          794,  794,  794,  794,  794,  794,  794,  794,  794,  794, 
          360,  794,  794,  684,    0,    0,    0,    0,    0,    0, 
          360,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  320,    0,    0,    0,  360,  360,    0, 
            0,  360,  360,  360,  360,  360,  360,  360,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  360, 
          360,    0,  360,  360,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  360,    0,  360,  360,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  798,    0,    0, 
            0,    0,    0,    0,  360,  360,  320,  798,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          793,    0,    0,    0,  798,  798,    0,  793,  798,  798, 
          798,  131,  798,  798,  798,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  798,  798,  150,  798, 
          798,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  798,    0, 
            0,  798,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          798,  798,  798,  793,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  320,  320,  320, 
            0,  320,  360,  360,  360,  320,  320,  360,  360,  360, 
          320,  360,  320,  320,  320,  320,  320,  320,  320,  360, 
            0,  360,  360,    0,  320,  320,  320,  320,  320,  320, 
          320,  360,  360,  320,  360,  360,  360,  360,  360,    0, 
          320,    0,    0,  320,  320,  320,  320,  320,  320,  320, 
          320,  320,  320,  320,  320,  320,  320,  320,  320,  320, 
            0,    0,  360,  320,  360,    0,  320,  320,  360,  360, 
          360,  360,  360,  360,  360,  360,  360,  360,  360,  360, 
          360,  320,  320,    0,    0,  360,  360,  360,  360,  320, 
            0,  360,  320,  320,  320,  320,  360,  320,  320,  320, 
          320,  320,  320,  320,  320,  320,  320,    0,  320,  320, 
          360,    0,    0,    0,  793,  793,  793,    0,  793,  798, 
          798,  798,  793,  793,    0,  798,  798,  793,  798,  793, 
          793,  793,  793,  793,  793,  793,  798,  798,    0,    0, 
            0,  793,  793,  793,  793,  793,  793,  793,  798,  798, 
          793,  798,  798,  798,  798,  798,    0,  793,    0,    0, 
          793,  793,  793,  793,  793,  793,  793,  793,  793,  793, 
          793,  793,  793,  793,  793,  793,  793,    0,    0,  798, 
          793,  798,    0,  793,  793,  798,  798,  798,  798,  798, 
          798,  798,  798,  798,  798,  798,  798,  798,  793,  793, 
            0,    0,  798,  798,  798,  798,  793,    0,  798,  793, 
          793,  793,  793,    0,  793,  793,  793,  793,  793,  793, 
          793,  793,  793,  793,  793,  793,  793,  798,    0,    0, 
            0,    0,    0,    0,  793,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  793,    0,    0, 
            0,  793,  793,    0,  793,  793,  793,  793,  130,  793, 
          793,  793,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  793,  793,  149,  793,  793,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0, 
      };
   }

   private static final int[] yyTable3() {
      return new int[] {

            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          793,    0,    0,  793,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  794,    0,    0,    0, 
            0,    0,  793,  793,  793,  793,  794,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  794, 
            0,    0,    0,  794,  794,    0,  794,  794,  794,  794, 
          132,  794,  794,  794,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  794,  794,  151,  794,  794, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  794,    0,    0, 
          794,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  794, 
          794,  794,  794,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  793,  793,  793,    0, 
          793,  793,  793,  793,  793,  793,    0,  793,  793,  793, 
          793,  793,  793,  793,  793,  793,  793,  793,  793,  793, 
            0,    0,    0,  793,  793,  793,  793,  793,  793,  793, 
          793,  793,  793,  793,  793,  793,  793,  793,    0,  793, 
            0,    0,  793,  793,  793,  793,  793,  793,  793,  793, 
          793,  793,  793,  793,  793,  793,  793,  793,  793,    0, 
            0,  793,  793,  793,    0,  793,  793,  793,  793,  793, 
          793,  793,  793,  793,  793,  793,  793,  793,  793,  793, 
          793,  793,    0,    0,  793,  793,  793,  793,  793,    0, 
          793,  793,  793,  793,  793,    0,  793,  793,  793,  793, 
          793,  793,  793,  793,  793,  793,    0,  793,  793,  793, 
            0,    0,    0,  794,  794,  794,    0,  794,  794,  794, 
          794,  794,  794,    0,  794,  794,  794,  794,  794,  794, 
          794,  794,  794,  794,  794,  794,  794,    0,    0,    0, 
          794,  794,  794,  794,  794,  794,  794,  794,  794,  794, 
          794,  794,  794,  794,  794,    0,  794,    0,    0,  794, 
          794,  794,  794,  794,  794,  794,  794,  794,  794,  794, 
          794,  794,  794,  794,  794,  794,    0,    0,  794,  794, 
          794,    0,  794,  794,  794,  794,  794,  794,  794,  794, 
          794,  794,  794,  794,  794,  794,  794,  794,  794,    0, 
            0,  794,  794,  794,  794,  794,    0,  794,  794,  794, 
          794,  794,    0,  794,  794,  794,  794,  794,  794,  794, 
          794,  794,  794,  798,  794,  794,  794,    0,    0,    0, 
            0,    0,    0,  798,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  793,    0,    0,    0, 
          798,  798,    0,  793,  798,  798,  798,  798,  798,  798, 
          798,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  798,  798,  150,  798,  798,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  798,    0,    0,  798,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          793,    0,    0,    0,    0,    0,  798,  798,  798,  793, 
          793,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  793,    0,    0,    0,  793,  793,    0, 
          793,  793,  793,  793,  793,  793,  793,  793,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  793, 
          793,  149,  793,  793,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  793,    0,    0,  793,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  793,  793,  793,  793,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          793,  793,  793,    0,  793,  798,  798,  798,  793,  793, 
            0,  798,  798,  793,  798,  793,  793,  793,  793,  793, 
          793,  793,  798,  798,    0,    0,    0,  793,  793,  793, 
          793,  793,  793,  793,  798,  798,  793,  798,  798,  798, 
          798,  798,    0,  793,    0,    0,  793,  793,  793,  793, 
          793,  793,  793,  793,  793,  793,  793,  793,  793,  793, 
          793,  793,  793,    0,    0,  798,  793,  798,    0,  793, 
          793,  798,  798,  798,  798,  798,  798,  798,  798,  798, 
          798,  798,  798,  798,  793,  793,    0,    0,  798,  798, 
          798,  798,  793,    0,  798,  793,  793,  793,  793,    0, 
          793,  793,  793,  793,  793,  793,  793,  793,  793,  793, 
            0,  793,  793,  798,    0,    0,    0,  793,  793,  793, 
            0,  793,  793,  793,  793,  793,  793,    0,  793,  793, 
          793,  793,  793,  793,  793,  793,  793,  793,  793,  793, 
          793,    0,    0,    0,  793,  793,  793,  793,  793,  793, 
          793,  793,  793,  793,  793,  793,  793,  793,  793,    0, 
          793,    0,    0,  793,  793,  793,  793,  793,  793,  793, 
          793,  793,  793,  793,  793,  793,  793,  793,  793,  793, 
            0,    0,  793,  793,  793,    0,  793,  793,  793,  793, 
          793,  793,  793,  793,  793,  793,  793,  793,  793,  793, 
          793,  793,  793,    0,    0,  793,  793,  793,  793,  793, 
            0,  793,  793,  793,  793,  793,    0,  793,  793,  793, 
          793,  793,  793,  793,  793,  793,  793,  794,  793,  793, 
          793,    0,    0,    0,    0,    0,    0,  794,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          794,    0,    0,    0,  794,  794,    0,  794,  794,  794, 
          794,  794,  794,  794,  794,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  794,  794,  151,  794, 
          794,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  794,    0, 
            0,  794,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  353,    0,    0,    0,    0,    0, 
          794,  794,  794,  794,  353,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  794,    0,    0, 
            0,  353,  353,    0,  794,  353,  353,  353,  133,  353, 
          353,  353,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  353,  353,  152,  353,  353,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  353,    0,    0,  353,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  353,  353, 
          794,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  794,  794,  794,    0,  794,  794, 
          794,  794,  794,  794,    0,  794,  794,  794,  794,  794, 
          794,  794,  794,  794,  794,  794,  794,  794,    0,    0, 
            0,  794,  794,  794,  794,  794,  794,  794,  794,  794, 
          794,  794,  794,  794,  794,  794,    0,  794,    0,    0, 
          794,  794,  794,  794,  794,  794,  794,  794,  794,  794, 
          794,  794,  794,  794,  794,  794,  794,    0,    0,  794, 
          794,  794,    0,  794,  794,  794,  794,  794,  794,  794, 
          794,  794,  794,  794,  794,  794,  794,  794,  794,  794, 
            0,    0,  794,  794,  794,  794,  794,    0,  794,  794, 
          794,  794,  794,    0,  794,  794,  794,  794,  794,  794, 
          794,  794,  794,  794,    0,  794,  794,  794,    0,    0, 
            0,  794,  794,  794,    0,  794,  353,  353,  353,  794, 
          794,    0,  353,  353,  794,  353,  794,  794,  794,  794, 
          794,  794,  794,  353,    0,    0,    0,    0,  794,  794, 
          794,  794,  794,  794,  794,  353,  353,  794,  353,  353, 
          353,  353,  353,    0,  794,    0,    0,  794,  794,  794, 
          794,  794,  794,  794,  794,  794,  794,  794,  794,  794, 
          794,  794,  794,  794,    0,    0,  353,  794,  353, 1098, 
          794,  794,  353,  353,  353,  353,  353,  353,  353,  353, 
          353,  353,  353,  353,  353,  794,  794,    0,    0,  353, 
          353,  353,  353,  794,    0,  353,  794,  794,  794,  794, 
            0,  794,  794,  794,  794,  794,  794,  794,  794,  794, 
          794,  353,  794,  794,  353,    0,    0,    0,    0,    0, 
            0,  353,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  794,    0,    0,    0,  353,  353, 
            0,  794,  353,  353,  353,  353,  353,  353,  353,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          353,  353,  152,  353,  353,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  353,    0,    0,  353,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  821,    0, 
            0,    0,    0,    0,    0,  353,  353,  794,  821,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  320, 1080, 1081, 1082, 1083,    0,    0,    0,  821, 
            0,    0,    0,    0,  821,    0,    0,    0, 1084, 1085, 
         1086, 1087,    0,    0,    0, 1088,    0,  821,   40,   41, 
           42,   43,   44,    0,    0,    0,    0,    0,  306,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0, 1090, 1091,    0,    0, 
            0,    0,    0,    0, 1092,    0,    0, 1093,    0, 1094, 
         1095,    0, 1096,    0,    0,   58,   59,   60,   61,   62, 
           63,   64,    0,   65,   66,    0,    0,    0,    0,    0, 
            0,  821,    0,  821,  320,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  794,  794, 
          794,    0,  794,  353,  353,  353,  794,  794,    0,  353, 
          353,  794,  353,  794,  794,  794,  794,  794,  794,  794, 
          353,    0,    0,    0,    0,  794,  794,  794,  794,  794, 
          794,  794,  353,  353,  794,  353,  353,  353,  353,  353, 
            0,  794,    0,    0,  794,  794,  794,  794,  794,  794, 
          794,  794,  794,  794,  794,  794,  794,  794,  794,  794, 
          794,    0,    0,  353,  794,  353,    0,  794,  794,  353, 
          353,  353,  353,  353,  353,  353,  353,  353,  353,  353, 
          353,  353,  794,  794,    0,    0,  353,  353,  353,  353, 
          794,    0,  353,  794,  794,  794,  794,    0,  794,  794, 
          794,  794,  794,  794,  794,  794,  794,  794,    0,  794, 
          794,  353,    0,    0,    0,  320,  320,  320,    0,  320, 
          821,  821,  821,  320,  320,  821,  821,  821,  320,  821, 
          320,  320,  320,  320,  320,  320,  320,  821,  821,  821, 
            0,    0,  320,  320,  320,  320,  320,  320,  320,  821, 
          821,  320,  821,  821,  821,  821,  821,    0,  320,    0, 
            0,  320,  320,  320,  320,  320,  320,  320,  320,  320, 
          320,  320,  320,  320,  320,  320,  320,  320,    0,    0, 
          821,  320,  821,    0,  320,  320,    0,    0,    0,    0, 
            0,    0,  388,    0,    0,    0,    0,    0,    0,  320, 
          320,    0,  388,    0,    0,  821,  821,  320,    0,    0, 
          320,  320,  320,  320,    0,  320,  320,  320,  320,  320, 
          320,  320,  320,  320,  320,    0,  320,  320,  821,  388, 
          388,    0,    0,  388,  388,  388,  388,  388,  388,  388, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  388,  388,    0,  388,  388,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  389,  388,    0,  388,  388,    0,    0,    0, 
            0,    0,  389,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  388,  388,    0,  389, 
          389,    0,    0,  389,  389,  389,  389,  389,  389,  389, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  389,  389,    0,  389,  389,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  389,    0,  389,  389,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  357,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  357,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  389,  389,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  357,  357,    0,    0,  357,  357,  357, 
          357,  357,  357,  357,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  357,  357,    0,  357,  357, 
            0,    0,    0,    0,  388,  388,  388,    0,    0,  388, 
          388,  388,    0,  388,    0,    0,    0,    0,    0,    0, 
            0,  388,    0,  388,  388,    0,    0,  357,    0,  357, 
          357,    0,    0,  388,  388,    0,  388,  388,  388,  388, 
          388,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          357,  357,    0,    0,  388,    0,  388,    0,    0,    0, 
          388,  388,  388,  388,  388,  388,  388,  388,  388,  388, 
          388,  388,  388,    0,    0,    0,    0,  388,  388,  388, 
          388,    0,    0,  388,  389,  389,  389,    0,  388,  389, 
          389,  389,    0,  389,    0,    0,    0,    0,    0,    0, 
            0,  389,  388,  389,  389,    0,    0,    0,    0,    0, 
            0,    0,    0,  389,  389,    0,  389,  389,  389,  389, 
          389,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  389,    0,  389,    0,    0,    0, 
          389,  389,  389,  389,  389,  389,  389,  389,  389,  389, 
          389,  389,  389,    0,    0,    0,    0,  389,  389,  389, 
          389,    0,    0,  389,    0,    0,    0,    0,  389,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  357,  357, 
          357,    0,  389,  357,  357,  357,    0,  357,    0,    0, 
            0,    0,    0,    0,    0,  357,    0,  357,  357,    0, 
            0,    0,    0,    0,    0,    0,    0,  357,  357,    0, 
          357,  357,  357,  357,  357,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  496,    0,    0,    0,    0,    0,  357,    0, 
          357,    0,  496,    0,  357,  357,  357,  357,  357,  357, 
          357,  357,  357,  357,  357,  357,  357,    0,    0,    0, 
            0,  357,  357,  357,  357,    0,    0,  357,    0,  496, 
          496,    0,  357,  496,  496,  496,  129,  496,  496,  496, 
            0,    0,    0,    0,    0,    0,  357,    0,    0,    0, 
            0,  496,  496,  148,  496,  496,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  496,  496,    0,  496,    0,    0,    0, 
            0,    0,    0,    0,  496,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  496,  496,  496,    0,    0, 
            0,  496,  496,    0,    0,  496,  496,  496,  496,  496, 
          496,  496,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  496,  496,  148,  496,  496,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  687,  496,    0,    0,  496,    0, 
            0,    0,    0,    0,  687,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  496,  496,  496, 
            0,  687,  687,    0,    0,  687,  687,  687,  123,  687, 
          687,  687,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  687,  687,  142,  687,  687,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  496,  496,  496,    0,    0,    0, 
          496,  496,    0,  496,    0,  687,    0,    0,  687,    0, 
            0,  496,  496,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  496,  496,    0,  496,  496,  496,  496, 
          496,    0,    0,    0,    0,    0,    0,    0,  687,  687, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  496,    0,  496,    0,    0,    0, 
          496,  496,  496,  496,  496,  496,  496,  496,  496,  496, 
          496,  496,  496,    0,    0,    0,    0,  496,  496,  496, 
          496,    0,    0,  496,    0,    0,  496,  496,  496,    0, 
            0,    0,  496,  496,    0,  496,    0,    0,    0,    0, 
            0,    0,  496,  496,  496,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  496,  496,    0,  496,  496, 
          496,  496,  496,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  496,    0,  496,    0, 
            0,    0,  496,  496,  496,  496,  496,  496,  496,  496, 
          496,  496,  496,  496,  496,    0,    0,    0,    0,  496, 
          496,  496,  496,    0,    0,  496,  687,  687,  687,    0, 
            0,    0,  687,  687,    0,  687,    0,    0,    0,    0, 
            0,    0,    0,  687,  496,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  687,  687,    0,  687,  687, 
          687,  687,  687,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  686, 
            0,    0,    0,    0,    0,    0,  687,    0,  687,  686, 
            0,    0,  687,  687,  687,  687,  687,  687,  687,  687, 
          687,  687,  687,  687,  687,    0,    0,    0,    0,  687, 
          687,  687,  687,    0,  699,  687,  686,  686,    0,    0, 
          686,  686,  686,  122,  686,  686,  686,    0,    0,    0, 
            0,    0,    0,    0,  687,    0,    0,    0,  686,  686, 
          141,  686,  686,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  688, 
          686,    0,    0,  686,    0,    0,    0,    0,    0,  688, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  686,  686,    0,  688,  688,    0,    0, 
          688,  688,  688,  124,  688,  688,  688,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  688,  688, 
          143,  688,  688,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          688,  689,    0,  688,    0,    0,    0,    0,    0,    0, 
            0,  689,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  688,  688,    0,    0,    0,  689,  689, 
            0,    0,  689,  689,  689,  125,  689,  689,  689,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          689,  689,  144,  689,  689,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  686,  686,  686,    0,    0,    0,  686,  686,    0, 
          686,    0,  689,    0,    0,  689,    0,    0,  686,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          686,  686,    0,  686,  686,  686,  686,  686,    0,    0, 
            0,    0,    0,    0,    0,  689,  689,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  686,    0,  686,    0,    0,    0,  686,  686,  686, 
          686,  686,  686,  686,  686,  686,  686,  686,  686,  686, 
            0,    0,    0,    0,  686,  686,  686,  686,    0,  698, 
          686,  688,  688,  688,    0,    0,    0,  688,  688,    0, 
          688,    0,    0,    0,    0,    0,    0,    0,  688,  686, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          688,  688,    0,  688,  688,  688,  688,  688,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  688,    0,  688,    0,    0,    0,  688,  688,  688, 
          688,  688,  688,  688,  688,  688,  688,  688,  688,  688, 
            0,    0,    0,    0,  688,  688,  688,  688,    0,  700, 
          688,    0,    0,  689,  689,  689,    0,    0,    0,  689, 
          689,    0,  689,    0,    0,    0,    0,    0,    0,  688, 
          689,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  689,  689,    0,  689,  689,  689,  689,  689, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  691,    0,    0,    0, 
            0,    0,    0,  689,    0,  689,  691,    0,    0,  689, 
          689,  689,  689,  689,  689,  689,  689,  689,  689,  689, 
          689,  689,    0,    0,    0,    0,  689,  689,  689,  689, 
            0,  701,  689,  691,  691,    0,    0,  691,  691,  691, 
          127,  691,  691,  691,    0,    0,    0,    0,    0,    0, 
            0,  689,    0,    0,    0,  691,  691,  146,  691,  691, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  690,  691,    0,    0, 
          691,    0,    0,    0,    0,    0,  690,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          691,  691,    0,  690,  690,    0,    0,  690,  690,  690, 
          126,  690,  690,  690,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  690,  690,  145,  690,  690, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  690,  692,    0, 
          690,    0,    0,    0,    0,    0,    0,    0,  692,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          690,  690,    0,    0,    0,  692,  692,    0,    0,  692, 
          692,  692,  128,  692,  692,  692,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  692,  692,  147, 
          692,  692,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  691,  691, 
          691,    0,    0,    0,  691,  691,    0,  691,    0,  692, 
            0,    0,  692,    0,    0,  691,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  691,  691,    0, 
          691,  691,  691,  691,  691,    0,    0,    0,    0,    0, 
            0,    0,  692,  692,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  691,    0, 
          691,    0,    0,    0,  691,  691,  691,  691,  691,  691, 
          691,  691,  691,  691,  691,  691,  691,    0,    0,    0, 
            0,  691,  691,  691,  691,    0,  703,  691,  690,  690, 
          690,    0,    0,    0,  690,  690,    0,  690,    0,    0, 
            0,    0,    0,    0,    0,  690,  691,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  690,  690,    0, 
          690,  690,  690,  690,  690,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  690,    0, 
          690,    0,    0,    0,  690,  690,  690,  690,  690,  690, 
          690,  690,  690,  690,  690,  690,  690,    0,    0,    0, 
            0,  690,  690,  690,  690,    0,  702,  690,    0,    0, 
          692,  692,  692,    0,    0,    0,  692,  692,    0,  692, 
            0,    0,    0,    0,    0,    0,  690,  692,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  692, 
          692,    0,  692,  692,  692,  692,  692,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  683,    0,    0,    0,    0,    0,    0, 
          692,    0,  692,  683,    0,    0,  692,  692,  692,  692, 
          692,  692,  692,  692,  692,  692,  692,  692,  692,    0, 
            0,    0,    0,  692,  692,  692,  692,    0,  704,  692, 
          683,  683,    0,    0,  683,  683,  683,  119,  683,  683, 
          683,    0,    0,    0,    0,    0,    0,    0,  692,    0, 
            0,    0,  683,  683,  138,  683,  683,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  682,  683,    0,    0,  683,    0,    0, 
            0,    0,    0,  682,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  683,  683,    0, 
          682,  682,    0,    0,  682,  682,  682,  118,  682,  682, 
          682,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  682,  682,  137,  682,  682,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  682,  685,    0,  682,    0,    0, 
            0,    0,    0,    0,    0,  685,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  682,  682,    0, 
            0,    0,  685,  685,    0,    0,  685,  685,  685,  121, 
          685,  685,  685,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  685,  685,  140,  685,  685,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  683,  683,  683,    0,    0, 
            0,  683,  683,    0,  683,    0,  685,    0,    0,  685, 
            0,    0,  683,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  683,  683,    0,  683,  683,  683, 
          683,  683,    0,    0,    0,    0,    0,    0,    0,  685, 
          685,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  683,    0,  683,    0,    0, 
            0,  683,  683,  683,  683,  683,  683,  683,  683,  683, 
          683,  683,  683,  683,    0,    0,    0,    0,  683,  683, 
          683,  683,    0,  695,  683,  682,  682,  682,    0,    0, 
            0,  682,  682,    0,  682,    0,    0,    0,    0,    0, 
            0,    0,  682,  683,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  682,  682,    0,  682,  682,  682, 
          682,  682,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  682,    0,  682,    0,    0, 
            0,  682,  682,  682,  682,  682,  682,  682,  682,  682, 
          682,  682,  682,  682,    0,    0,    0,    0,  682,  682, 
          682,  682,    0,  694,  682,    0,    0,  685,  685,  685, 
            0,    0,    0,  685,  685,    0,  685,    0,    0,    0, 
            0,    0,    0,  682,  685,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  685,  685,    0,  685, 
          685,  685,  685,  685,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          346,    0,    0,    0,    0,    0,    0,  685,    0,  685, 
          346,    0,    0,  685,  685,  685,  685,  685,  685,  685, 
          685,  685,  685,  685,  685,  685,    0,    0,    0,    0, 
          685,  685,  685,  685,    0,  697,  685,  346,  346,    0, 
            0,  346,  346,  346,  135,  346,  346,  346,    0,    0, 
            0,    0,    0,    0,    0,  685,    0,    0,    0,  346, 
          346,  154,  346,  346,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          354,  346,    0,    0,  346,    0,    0,    0,    0,    0, 
          354,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  346,  346,    0,  354,  354,    0, 
            0,  354,  354,  354,  134,  354,  354,  354,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  354, 
          354,  153,  354,  354,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  354,  346,    0,  354,    0,    0,    0,    0,    0, 
            0,    0,  346,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  354,  354,    0,    0,    0,  346, 
          346,    0,    0,  346,  346,  346,  346,  346,  346,  346, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  346,  346,  154,  346,  346,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  346,  346,  346,    0,    0,    0,  346,  346, 
            0,  346,    0,  346,    0,    0,  346,    0,    0,  346, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  346,  346,    0,  346,  346,  346,  346,  346,    0, 
            0,    0,    0,    0,    0,    0,  346,  346,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  346,    0,  346,    0,    0,    0,  346,  346, 
          346,  346,  346,  346,  346,  346,  346,  346,  346,  346, 
          346,    0,    0,    0,    0,  346,  346,  346,  346,    0, 
          792,  346,  354,  354,  354,    0,    0,    0,  354,  354, 
          792,  354,    0,    0,    0,    0,    0,    0,    0,  354, 
          346,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  354,  354,    0,  354,  354,  354,  354,  354,    0, 
            0,  792,    0,    0,  792,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  792, 
            0,    0,  354,    0,  354,    0,    0,    0,  354,  354, 
          354,  354,  354,  354,  354,  354,  354,  354,  354,  354, 
          354,    0,    0,    0,    0,  354,  354,  354,  354,    0, 
            0,  354,    0,  792,  346,  346,  346,    0,  326,    0, 
          346,  346,    0,  346,    0,    0,    0,    0,  326,    0, 
          354,  346,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  346,  346,  792,  346,  346,  346,  346, 
          346,    0,    0,    0,    0,    0,    0,    0,    0,  326, 
            0,    0,  326,    0,    0,  328,    0,    0,    0,    0, 
            0,    0,    0,    0,  346,  328,  346,  326,    0,    0, 
          346,  346,  346,  346,  346,  346,  346,  346,  346,  346, 
          346,  346,  346,    0,    0,    0,    0,  346,  346,  346, 
          346,    0,    0,  346,  581,    0,  328,    0,    0,  328, 
            0,  326,    0,    0,  581,    0,    0,    0,    0,    0, 
            0,    0,  346,    0,  328,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  326,    0,  581,    0,    0,  581,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  328,    0, 
            0,    0,    0,  581,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  792,  792,  792,    0,    0,  792,  792,  792, 
          328,  792,    0,    0,    0,    0,    0,  581,    0,  792, 
            0,  792,  792,    0,    0,    0,    0,    0,    0,    0, 
            0,  792,  792,  588,  792,  792,  792,  792,  792,    0, 
            0,    0,    0,  588,    0,    0,    0,    0,  581,  581, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  792,    0,  792,    0,    0,    0,    0,    0, 
            0,    0,  584,    0,  588,    0,    0,  588,    0,    0, 
            0,    0,  584,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  588,    0,    0,    0,  792,    0,    0,    0, 
          326,  326,  326,    0,    0,  326,  326,  326,    0,  326, 
          792,    0,    0,  584,    0,    0,  584,  326,    0,  326, 
          326,    0,    0,    0,    0,    0,  588,    0,    0,  326, 
          326,  584,  326,  326,  326,  326,  326,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  328,  328,  328, 
            0,    0,  328,  328,  328,    0,  328,  588,  588,    0, 
          326,    0,  326,    0,  328,  584,  328,  328,    0,    0, 
            0,    0,    0,    0,    0,    0,  328,  328,    0,  328, 
          328,  328,  328,  328,    0,    0,  581,  581,  581,    0, 
            0,  581,  581,  581,  326,  581,  584,  584,    0,    0, 
            0,    0,    0,  581,    0,  581,    0,  328,  326,  328, 
            0,    0,    0,  585,    0,  581,  581,    0,  581,  581, 
          581,  581,  581,  585,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  328,    0,    0,    0,    0,  581,    0,  581,    0, 
            0,    0,    0,    0,  585,  328,    0,  585,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  585,    0,    0,  581,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  581,  588,  588,  588,    0,    0, 
          588,  588,  588,    0,  588,    0,  585,    0,    0,    0, 
            0,    0,  588,    0,  588,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  588,  588,    0,  588,  588,  588, 
          588,  588,  528,    0,  584,  584,  584,  585,  585,  584, 
          584,  584,  528,  584,    0,    0,    0,    0,    0,    0, 
            0,  584,    0,  584,    0,  588,    0,  588,    0,    0, 
            0,    0,    0,  584,  584,    0,  584,  584,  584,  584, 
          584,  562,    0,  528,    0,    0,  528,    0,    0,    0, 
            0,  562,    0,    0,  588,    0,    0,    0,    0,    0, 
            0,  528,    0,    0,  584,    0,  584,    0,    0,    0, 
            0,    0,    0,  588,    0,    0,    0,    0,    0,  573, 
            0,    0,  562,    0,    0,  562,    0,    0,    0,  573, 
            0,    0,    0,  584,    0,  528,    0,    0,    0,    0, 
          562,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  584,    0,    0,    0,    0,    0,    0,    0, 
          573,    0,    0,  573,    0,    0,  550,  528,    0,    0, 
            0,    0,    0,    0,  562,    0,  550,    0,  573,    0, 
            0,    0,    0,    0,    0,  585,  585,  585,    0,    0, 
          585,  585,  585,    0,  585,    0,    0,    0,    0,    0, 
            0,    0,  585,    0,  585,    0,  562,  550,    0,    0, 
          565,    0,  573,    0,  585,  585,    0,  585,  585,  585, 
          585,  585,    0,    0,    0,  550,    0,    0,    0,  572, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  572, 
            0,    0,    0,    0,  573,  585,    0,  585,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  550, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          572,    0,    0,  572,  585,    0,  565,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  565,    0,  572,    0, 
            0,  550,    0,  585,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  528,  528,  528,    0,    0,  528, 
          528,  528,    0,  528,    0,  553,    0,  565,    0,    0, 
          565,  528,  572,  528,    0,  553,    0,    0,    0,    0, 
            0,    0,    0,  528,  528,  565,  528,  528,  528,  528, 
          528,    0,    0,  562,  562,  562,    0,    0,  562,  562, 
          562,    0,  562,    0,  572,    0,  553,    0,    0,    0, 
          562,    0,  562,    0,  528,    0,  528,    0,    0,  565, 
            0,    0,  562,  562,  553,  562,  562,  562,  562,  562, 
            0,  573,  573,  573,    0,    0,  573,  573,  573,    0, 
          573,    0,    0,  528,    0,    0,    0,    0,  573,    0, 
          573,  565,    0,  562,    0,  562,    0,    0,  553,  559, 
          573,  573,  528,  573,  573,  573,  573,  573,    0,  559, 
            0,    0,    0,    0,    0,    0,    0,    0,  550,  550, 
          550,    0,    0,  550,  550,  550,    0,  550,    0,    0, 
          553,  573,    0,  573,    0,  550,    0,  550,    0,    0, 
          559,  562,    0,    0,    0,    0,    0,  550,  550,    0, 
          550,  550,  550,  550,  550,    0,    0,    0,  559,    0, 
            0,    0,  554,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  554,    0,    0,    0,    0,    0,  550,  573, 
          550,  572,  572,  572,    0,    0,  572,  572,  572,    0, 
          572,    0,  559,    0,    0,    0,    0,    0,  572,    0, 
          572,    0,    0,  554,    0,    0,    0,    0,    0,    0, 
          572,  572,   79,  572,  572,  572,  572,  572,    0,    0, 
            0,  554,   79,    0,  559,    0,  550,    0,  565,  565, 
          565,    0,    0,  565,  565,  565,    0,  565,    0,    0, 
            0,  572,    0,  572,    0,  565,    0,  565,    0,    0, 
            0,    0,    0,   79,    0,  554,    0,  565,  565,    0, 
          565,  565,  565,  565,  565,    0,    0,  553,  553,  553, 
            0,   79,  553,  553,  553,   81,  553,    0,    0,    0, 
            0,    0,    0,    0,  553,   81,  553,  554,  565,  572, 
          565,    0,    0,    0,    0,    0,  553,  553,    0,  553, 
          553,  553,  553,  553,    0,    0,    0,    0,    0,    0, 
            0,    0,   82,    0,    0,    0,   81,    0,    0,    0, 
            0,    0,   82,    0,    0,    0,    0,  553,    0,  553, 
            0,    0,    0,    0,   81,    0,  565,   79,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   82,    0,    0,    0,    0,    0,    0, 
            0,  559,  559,  559,    0,    0,  559,  559,  559,    0, 
          559,   82,    0,    0,    0,  553,    0,    0,  559,    0, 
          559,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          559,  559,    0,  559,  559,  559,  559,  559,    0,    0, 
           81,    0,    0,    0,  520,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  520,    0,    0,    0,    0,    0, 
            0,  559,    0,  559,  554,  554,  554,    0,    0,  554, 
          554,  554,    0,  554,    0,    0,    0,   82,    0,    0, 
            0,  554,    0,  554,    0,  520,    0,    0,    0,    0, 
            0,    0,    0,  554,  554,    0,  554,  554,  554,  554, 
          554,    0,    0,  520,    0,    0,    0,    0,    0,  559, 
            0,    0,    0,    0,   79,   79,   79,    0,    0,   79, 
           79,   79,    0,   79,  554,    0,  554,    0,    0,  521, 
            0,   79,    0,   79,    0,    0,    0,    0,    0,  521, 
            0,    0,    0,   79,   79,    0,   79,   79,   79,   79, 
           79,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  520, 
          521,    0,  554,    0,   79,    0,   79,   81,   81,   81, 
            0,    0,   81,   81,   81,    0,   81,    0,  521,    0, 
            0,    0,    0,  558,   81,    0,   81,    0,    0,    0, 
            0,    0,    0,  558,    0,    0,   81,   81,    0,   81, 
           81,   81,   81,   81,   82,   82,   82,    0,    0,   82, 
           82,   82,   79,   82,    0,    0,    0,    0,    0,    0, 
            0,   82,    0,   82,  558,    0,    0,   81,    0,   81, 
            0,    0,    0,   82,   82,  559,   82,   82,   82,   82, 
           82,    0,  558,    0,  521,  559,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   82,    0,   82,    0,    0,    0, 
            0,    0,    0,    0,    0,   81,  559,   69,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   69,    0,    0, 
            0,    0,    0,    0,  559,    0,  520,  520,  520,    0, 
            0,  520,  520,  520,    0,  520,    0,    0,  558,    0, 
            0,    0,   82,  520,    0,  520,    0,    0,   69,    0, 
            0,    0,    0,    0,    0,  520,  520,    0,  520,  520, 
          520,  520,  520,    0,    0,    0,   69,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  520,    0,  520,    0, 
          559,    0,  333,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  333,    0,    0,    0,    0,    0,    0,    0, 
            0,  521,  521,  521,    0,    0,  521,  521,  521,    0, 
          521,    0,    0,    0,    0,    0,    0,    0,  521,   30, 
          521,    0,   69,  333,  520,    0,  326,    0,    0,   30, 
          521,  521,   55,  521,  521,  521,  521,  521,    0,    0, 
            0,  333,   55,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           30,  521,    0,  521,    0,  558,  558,  558,    0,    0, 
          558,  558,  558,   55,  558,    0,    0,    0,   30,    0, 
            0,    0,  558,    0,  558,    0,    0,    0,    0,    0, 
            0,   55,    0,    0,  558,  558,    0,  558,  558,  558, 
          558,  558,    0,    0,   51,    0,    0,  333,    0,  521, 
            0,    0,    0,    0,   51,    0,    0,  559,  559,  559, 
            0,    0,  559,  559,  559,  558,  559,  558,    0,    0, 
            0,    0,    0,    0,  559,    0,  559,    0,    0,    0, 
            0,    0,    0,    0,   30,   51,  559,  559,    0,  559, 
          559,  559,  559,  559,    0,    0,    0,   55,    0,   69, 
           69,   69,    0,   51,   69,   69,   69,    0,   69,    0, 
            0,    0,   52,  558,    0,    0,    0,  559,   69,  559, 
            0,    0,   52,    0,    0,    0,    0,    0,   69,   69, 
            0,   69,   69,   69,   69,   69,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   52,   57,    0,    0,    0,    0,   69, 
            0,   69,    0,    0,   57,  559,    0,    0,    0,   51, 
            0,   52,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  333,  333,  333,    0,    0,    0, 
          333,  333,    0,  333,    0,   57,    0,    0,    0,    0, 
            0,  333,    0,    0,    0,    0,    0,   69,    0,    0, 
            0,    0,    0,   57,    0,    0,  333,  333,  333,  333, 
          333,   30,   30,   30,    0,    0,    0,   30,   30,    0, 
           30,    0,   41,    0,   55,   55,   55,   52,   30,    0, 
           55,   55,   41,   55,  333,    0,  333,    0,    0,    0, 
            0,   55,   56,   30,   30,   30,   30,   30,    0,    0, 
            0,    0,   56,    0,    0,    0,   55,   55,   55,   55, 
           55,    0,    0,   41,    0,    0,    0,    0,    0,   57, 
            0,   30,    0,   30,    0,    0,    0,    0,    0,    0, 
            0,   41,  333,   56,   55,    0,   55,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   51,   51,   51,    0, 
            0,   56,   51,   51,    0,   51,    0,    0,    0,    0, 
            0,    0,    0,   51,    0,    0,    0,    0,    0,   30, 
            0,    0,    0,    0,    0,    0,    0,    0,   51,   51, 
           51,   51,   55,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   41,    0,    0, 
            0,    0,    0,    0,    0,    0,   51,    0,   51,    0, 
            0,    0,    0,    0,   52,   52,   52,   56,    0,    0, 
           52,   52,    0,   52,    0,    0,    0,    0,    0,    0, 
            0,   52,    0,    0,    0,    0,  155,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   52,   52,   52,   52, 
            0,    0,    0,    0,   51,    0,   57,   57,   57,  155, 
            0,    0,   57,   57,    0,   57,  793,    0,    0,    0, 
            0,    0,  681,   57,   52,    0,   52,    0,    0,    0, 
            0,    0,    0,    0,    0,  155,  155,    0,   57,   57, 
           57,   57,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   57,  681,   57,    0, 
            0,    0,   52,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   41,   41,   41,    0,    0,    0, 
           41,   41,    0,   41,    0,    0,    0,    0,    0,  793, 
            0,   41,  155,    0,   56,   56,   56,    0,    0,    0, 
           56,   56,  156,   56,   57,    0,   41,   41,   41,   41, 
            0,   56,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  156,   56,   56,   56,   56, 
            0,    0,  794,    0,   41,    0,   41,    0,  684,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  156,  156,    0,   56,    0,   56,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   41,  684,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   56,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  794,    0,    0,  156,    0, 
            0,    0,  155,  155,  155,  155,  155,  155,  155,  155, 
          155,  155,  155,    0,    0,  155,  155,    0,  155,  155, 
          155,  155,  155,  155,  155,    0,  793,    0,    0,    0, 
          155,  155,  155,  155,  155,  155,  155,    0,    0,  155, 
            0,    0,    0,    0,    0,  155,  155,  155,  155,  155, 
          155,  155,  155,  155,  155,  155,  155,  155,    0,  155, 
          155,  155,  155,  155,  155,  155,    0,    0,  155,  155, 
            0,    0,  155,  155,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  155,  155,    0, 
            0,    0,    0,  681,  681,  155,    0,    0,  155,  155, 
          155,  155,    0,  155,    0,    0,  155,  155,  155,  155, 
          155,  155,  155,    0,  155,  155,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  156,  156, 
          156,  156,  156,  156,  156,  156,  156,  156,  156,    0, 
            0,  156,  156,    0,  156,  156,  156,  156,  156,  156, 
          156,    0,  794,    0,    0,    0,  156,  156,  156,  156, 
          156,  156,  156,    0,    0,  156,    0,    0,    0,    0, 
            0,  156,  156,  156,  156,  156,  156,  156,  156,  156, 
          156,  156,  156,  156,    0,  156,  156,  156,  156,  156, 
          156,  156,    0,    0,  156,  156,    0,    0,  156,  156, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  156,  156,    0,  155,    0,    0,  684, 
          684,  156,    0,    0,  156,  156,  156,  156,    0,  156, 
            0,    0,  156,  156,  156,  156,  156,  156,  156,  155, 
          156,  156,    0,    0,    0,    0,  793,    0,    0,    0, 
            0,    0,  798,    0,    0,    0, 1103, 1103,    0,    0, 
            0,    0,    0,    0,    0,  155,  155,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  798,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0, 1103, 1103,    0,    0, 1103,    0,  798, 
          156,    0,  155,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  156,    0,    0,    0,    0,    0,    0, 
          794, 1103,    0,    0,    0,    0,  353,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  156, 
          156,    0, 1103,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
         1103,    0,    0,    0, 1103,    0,    0,    0,    0,    0, 
            0,  353,    0,    0,    0,    0,    0, 1103, 1103, 1103, 
         1103,    0,    0,    0, 1103, 1103,    0, 1103,    0,    0, 
            0,  403,  398,    0,    0,    0,  401,  399,    0,  400, 
            0,  402,    0,    0,    0,    0,  156,    0,    0,    0, 
            0,    0,    0,    0,  395,    0,  394,  393,    0,    0, 
            0,    0,  155,  155,  155,  155,  155,  155,  155,  155, 
          155,  155,  155,    0,    0,  155,  155,    0,  155,  155, 
          155,  155,  155,  155,  155,    0,  798,    0,  397,    0, 
          155,  155,  155,  155,  155,  155,  155,    0,    0,  155, 
            0,    0,    0,    0,    0,  155,  155,  155,  155,  155, 
          155,  155,  155,  155,  155,  155,  155,  155,  396,  155, 
          155,  155,  155,  155,  155,  155,    0,    0,  155,  155, 
            0,    0,  155,  155,    0, 1103,    0,    0, 1103,    0, 
            0,    0,    0,    0,    0,    0, 1103,  155,  155,    0, 
            0,    0,    0,  798,  798,  155,    0,    0,  155,  155, 
          155,  155,    0,  155,    0,    0,  155,  155,  155,  155, 
          155,  155,  155,    0,  155,  155,  156,  156,  156,  156, 
          156,  156,  156,  156,  156,  156,  156,    0,    0,  156, 
          156,    0,  156,  156,  156,  156,  156,  156,  156,    0, 
            0,    0,    0, 1103,  156,  156,  156,  156,  156,  156, 
          156,    0,    0,  156,    0,    0,    0,    0,    0,  156, 
          156,  156,  156,  156,  156,  156,  156,  156,  156,  156, 
          156,  156,    0,  156,  156,  156,  156,  156,  156,  156, 
            0,    0,  156,  156,    0,    0,  156,  156,    0,    0, 
            0,    0,    0,    0,    0,  156,    0,    0,    0,    0, 
            0,  156,  156,    0,    0,    0,    0,  353,  353,  156, 
            0,    0,  156,  156,  156,  156,    0,  156,  156,    0, 
          156,  156,  156,  156,  156,  156,  156,    0,  156,  156, 
            0,  354,  954,    0, 1104, 1104,    0,    0,    0,    0, 
            0,    0,    0,    0,  156,  156, 1105, 1105,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  377,  378,  379,  380,  381,  382,  383,  384, 
          385,  386,  387,  388,  389,    0,  354,    0,    0,  390, 
          391,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0, 1104, 1104,    0,    0, 1104,    0,    0,    0,  414, 
            0,  156,    0, 1105, 1105,    0,    0, 1105,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  414,    0,    0,    0,    0,    0,    0, 1104, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0, 1105,    0,    0,    0,    0,    0,    0,  414,    0, 
         1104,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0, 1105,    0,    0,    0,    0,    0, 1104,    0, 
            0,    0, 1104,    0,    0,    0,    0,    0,    0,    0, 
         1105,    0,    0,    0, 1105, 1104, 1104, 1104, 1104,    0, 
            0,    0, 1104, 1104,    0, 1104,    0, 1105, 1105, 1105, 
         1105,    0,    0,    0, 1105, 1105,    0, 1105,    0,    0, 
            0,    0,    0,    0,    0,  414,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  156,  156,  156,  156,  156,  156,  156,  156,  156, 
          156,  156,    0,    0,  156,  156,    0,  156,  156,  156, 
          156,  156,  156,  156,    0,    0,    0,    0,    0,  156, 
          156,  156,  156,  156,  156,  156,    0,    0,  156,    0, 
            0,    0,    0,    0,  156,  156,  156,  156,  156,  156, 
          156,  156,  156,  156,  156,  156,  156,    0,  156,  156, 
          156,  156,  156,  156,  156,    0,    0,  156,  156,    0, 
            0,  156,  156, 1104,    0,    0, 1104,    0,    0,    0, 
            0,    0,    0,    0, 1104, 1105,  156,  156, 1105,    0, 
            0,    0,  354,  354,  156,    0, 1105,  156,  156,  156, 
          156,    0,  156,    0,    0,  156,  156,  156,  156,  156, 
          156,  156,    0,  156,  156,  414,  414,  414,  414,  414, 
          414,  414,  414,  414,  414,  414,    0,  414,  414,  414, 
          414,  414,  414,  414,  414,  414,  414,  414,  414,    0, 
            0, 1104,    0,  414,  414,  414,  414,  414,  414,  414, 
            0,    0,  414, 1105,    0,    0,  713,    0,  414,  414, 
          414,  414,  414,  414,  414,  414,  414,  414,  414,  414, 
          414,    0,  414,  414,  414,  414,  414,  414,  414,  713, 
            0,  414,  414,    0,    0,  414,  414,    0,    0,    0, 
            0,    0, 1106, 1106,    0,    0,    0,    0,    0,    0, 
          414,  414,    0,    0,    0,  713,    0,  710,  414,    0, 
            0,  414,  414,  414,  414,    0,  414,    0,    0,  414, 
          414,  414,  414,  414,  414,  414,    0,  414,  414,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0, 1106, 
         1106,    0,    0, 1106,    0,    0,    0,    0,    0,    0, 
          709,    0,  713,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  709,    0,    0,    0, 1106,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0, 1106,  709, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0, 1106,    0,    0,    0, 
         1106,    0,    0,    0,  252,    0,    0,    0,    0,    0, 
            0,    0,    0, 1106, 1106, 1106, 1106,    0,    0,    0, 
         1106, 1106,    0, 1106,    0,    0,    0,    0,    0,    0, 
            0,  403,  398,    0,    0,    0,  401,  399,    0,  400, 
            0,  402,    0,    0,    0,    0,  709,    0,    0,    0, 
            0,    0,    0,    0,  395,    0,  394,  393,    0,    0, 
            0,    0,  713,  713,  713,  713,  713,  713,  713,  713, 
          713,  713,  713,    0, 
      };
   }

   private static final int[] yyTable4() {
      return new int[] {

            0,  713,  713,    0,  713,  713,  713,  713,  713,  713, 
          713,    0,    0,    0,  397,    0,  713,  713,  713,  713, 
          713,  713,  713,    0,    0,  713,    0,    0,    0,    0, 
            0,  713,  713,  713,  713,  713,  713,  713,  713,  713, 
          713,  713,  713,  713,  396,  713,  713,  713,  713,  713, 
          713,  713,    0,    0,  713,  713,    0, 1106,  713,  713, 
         1106,    0,    0,    0,    0,  821,    0,    0, 1106,    0, 
            0,    0,    0,  713,  713,    0,    0,    0,    0,    0, 
            0,  713,    0,    0,  713,  713,  713,  713,  821,  713, 
            0,    0,  713,  713,  713,  713,  713,  713,  713,    0, 
          713,  713,  709,  709,  709,  709,  709,  709,  709,  709, 
          709,  709,  709,    0,  821,  709,  709,    0,  709,  709, 
          709,  709,  709,  709,  709, 1106,    0,    0,    0,    0, 
          709,  709,  709,  709,  709,  709,  709,    0,    0,  709, 
            0,    0,    0,    0,    0,  709,  709,  709,  709,  709, 
          709,  709,  709,  709,  709,  709,  709,  709,    0,  709, 
          709,  709,  709,  709,  709,  709,    0,    0,  709,  709, 
            0,    0,  709,  709,    0,    0,    0,    0,    0,  821, 
            0,  821,    0,    0,    0,    0,    0,  709,  709,    0, 
            0,    0,    0,    0,    0,  709,    0,    0,  709,  709, 
          709,  709,  821,  709,    0,    0,  709,  709,  709,  709, 
          709,  709,  709,    0,  709,  709,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  821,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  377,  378, 
          379,  380,  381,  382,  383,  384,  385,  386,  387,  388, 
          389,    0,    0,    0,    0,  390,  391,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          403,  398,    0,    0,    0,  401,  399,    0,  400,    0, 
          402,    0,    0,    0,  821,  821,    0,    0,    0,    0, 
            0,    0,    0,  395,    0,  394,  393,    0,    0,    0, 
            0,  821,  821,  821,  821,  821,  821,  821,  821,  821, 
          821,  821,    0,    0,  821,  821,    0,  821,  821,  821, 
          821,  821,  821,  821,    0,    0,    0,  397,    0,  821, 
          821,  821,  821,  821,  821,  821,    0,    0,  821,    0, 
            0,    0,    0,    0,  821,  821,  821,  821,  821,  821, 
          821,  821,  821,  821,  821,  821,  821,  396,  821,  821, 
          821,  821,  821,  821,  821,  252,    0,  821,  821,    0, 
            0,  821,  821,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  821,  821,  230,    0, 
            0,    0,    0,    0,  821,    0,    0,  821,  821,  821, 
          821,    0,  821,    0,    0,  821,  821,  821,  821,  821, 
          821,  821,    0,  821,  821,  821,  821,  821,  821,  821, 
          821,    0,    0,    0,  821,  821,    0,    0,    0,  821, 
            0,  821,  821,  821,  821,  821,  821,  821,    0,    0, 
            0,    0,    0,  821,  821,  821,  821,  821,  821,  821, 
            0,    0,  821,    0,    0,    0,    0,    0,  821,  821, 
          821,  821,  821,  821,  821,  821,  821,  821,  821,  821, 
          821,    0,  821,  821,  821,  821,  821,  821,  821,    0, 
          365,   68,  821,    0,    0,  821,  821,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          821,  821,    0,   67,    0,    0,    0,    0,  821,    0, 
            0,  821,  821,  821,  821,    0,  821,    0,    0,  821, 
          821,  821,  821,  821,  821,  821,    0,  821,  821,  364, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  377,  378,  379,  380,  381,  382,  383,  384,  385, 
          386,  387,  388,  389,    0,    0,    0,    0,  390,  391, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  252,   68,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    4,    5,    6,    0,    8,    0,   67,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,    0,   19, 
           20,   21,  210,  211,  212,  213,    0,    0,  214,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,  215,  216, 
          217,  218,   35,  219,  220,  221,  222,  223,   40,   41, 
           42,   43,   44,   45,   46,    0,    0,    0,   47,    0, 
            0,   48,   49,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   50,   51,    0,    0, 
            0,    0,    0,    0,  224,    0,    0,  225,   54,   55, 
           56,   68,  226,  227,  228,   58,   59,  229,   61,   62, 
           63,   64,    0,   65,   66,    0,  434,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
            0,    0,    0,    0,   19,   20,   21,  210,  211,  212, 
          213,    0,    0,   26,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,  215,  216,  217,  218,   35,  219,  220, 
          221,  222,    0,   40,   41,   42,   43,   44,   45,   46, 
            0,   67,    0,   47,    0,    0,   48,   49,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   50,   51,    0,    0, 1107, 1107,  612,    0,  224, 
            0,    0,  225,   54,   55,   56,    0,    0,    0,    0, 
           58,   59,   60,   61,   62,   63,   64,    0,   65,   66, 
            0,    0,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,    0,   19, 
           20,   21,  210,  211,  212,  213,    0,    0,   26,    0, 
            0,    0, 1107, 1107,   68,   28, 1107,    0,  215,  216, 
          217,  218,   35,  219,  220,  221,  222,    0,   40,   41, 
           42,   43,   44,   45,   46,    0,    0,    0,   47,    0, 
            0,   48,   49,    0,    0,    0,   67,    0,    0,    0, 
         1107,    0,    0,    0,    0,    0,   50,   51,    0,    0, 
            0,    0,    0,    0,  224,    0,    0,  225,   54,   55, 
           56, 1107,  612,    0,    0,   58,   59,   60,   61,   62, 
           63,   64,    0,   65,   66,    0,    0,    0,    0, 1107, 
            0,    0,    0, 1107,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0, 1107, 1107, 1107, 1107, 
            0,    0,    0, 1107, 1107,    0, 1107,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   68, 
            0,    0,    0,    0,    3,    4,    5,    6,    7,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,   67,    0,    0, 
            0,    0,   19,   20,   21,   22,   23,   24,   25,    0, 
            0,   26,    0,    0,    0,    0,    0,   27,   28,   29, 
           30,   31,   32,   33,   34,   35,   36,   37,   38,   39, 
            0,   40,   41,   42,   43,   44,   45,   46,    0,    0, 
            0,   47,    0,    0,   48,   49,    0,    0,    0,    0, 
            0,    0,    0,    0, 1107,    0,    0, 1107,    0,   50, 
           51,    0,    0,    0,    0, 1107,    0,   52,    0,    0, 
           53,   54,   55,   56,    0,   57,    0,    0,   58,   59, 
           60,   61,   62,   63,   64,    0,   65,   66,    0,    0, 
           68,    0,    0,    0,    0,    0,    0,    0,    0,    3, 
            4,    5,    6,    7,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18, 1107,   67,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,   26,    0,    0,    0, 
            0,    0,   27,   28,  275,   30,   31,   32,   33,   34, 
           35,   36,   37,   38,   39,    0,   40,   41,   42,   43, 
           44,   45,   46,    0,    0,    0,   47,    0,    0,   48, 
           49,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   50,   51,    0,    0,    0,    0, 
            0,    0,   52,    0,    0,   53,   54,   55,   56,    0, 
           57,    0,    0,   58,   59,   60,   61,   62,   63,   64, 
            0,   65,   66,    0,    0,    0,   68,    0,    0,    0, 
            3,    4,    5,    6,    7,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,   67,    0,    0,    0,    0,   19,   20, 
           21,   22,   23,   24,   25,    0,    0,   26,    0,    0, 
            0,    0,    0,   27,   28,   29,   30,   31,   32,   33, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,   44,   45,   46,    0,    0,    0,   47,    0,    0, 
           48,   49,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   50,   51,    0,    0,    0, 
            0,    0,    0,   52,    0,    0,   53,   54,   55,   56, 
            0,   57,    0,    0,   58,   59,   60,   61,   62,   63, 
           64,    0,   65,   66,    0,    0,   68,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    3,    4,    5,    6, 
            7,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,   67, 
            0,    0,    0,    0,   19,   20,   21,   22,   23,   24, 
           25,    0,    0,   26,    0,    0,    0,    0,    0,   27, 
           28,  275,   30,   31,   32,   33,   34,   35,   36,   37, 
           38,   39,    0,   40,   41,   42,   43,   44,   45,   46, 
            0,    0,    0,   47,    0,    0,   48,   49,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   50,   51,    0,    0,    0,    0,    0,    0,   52, 
            0,    0,  276,   54,   55,   56,    0,   57,    0,    0, 
           58,   59,   60,   61,   62,   63,   64,    0,   65,   66, 
            0,    0,   68,    0,    0,    0,    3,    4,    5,    6, 
            7,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,  230, 
            0,    0,    0,    0,   19,   20,   21,   22,   23,   24, 
           25,    0,    0,   26,    0,    0,    0,    0,    0,   27, 
           28,  275,   30,   31,   32,   33,   34,   35,   36,   37, 
           38,   39,    0,   40,   41,   42,   43,   44,   45,   46, 
            0,    0,    0,   47,    0,    0,   48,   49,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   50,   51,    0,    0,    0,    0,    0,    0,   52, 
            0,    0,   53,   54,   55,   56,    0,   57,    0,    0, 
           58,   59,   60,   61,   62,   63,   64,    0,   65,   66, 
            0,    0,   68,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    3,    4,    5,    6,    7,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   15,   16,   17,   18,  230,    0,    0,    0,    0, 
           19,   20,   21,   22,   23,   24,   25,    0,    0,   26, 
            0,    0,    0,    0,    0,   27,   28,    0,   30,   31, 
           32,   33,   34,   35,   36,   37,   38,   39,    0,   40, 
           41,   42,   43,   44,   45,   46,    0,    0,    0,   47, 
            0,    0,   48,   49,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   50,   51,    0, 
            0,    0,    0,    0,    0,   52,    0,    0,   53,   54, 
           55,   56,    0,   57,    0,    0,   58,   59,   60,   61, 
           62,   63,   64,    0,   65,   66,    0,    0,   68,    0, 
            0,    0,    0,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   15,   16,   17,   18,  230,    0,    0,    0,    0, 
           19,   20,   21,  210,  211,  212,  213,    0,    0,  214, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  215, 
          216,  217,  218,   35,  219,  220,  221,  222,  223,   40, 
           41,   42,   43,   44,   45,   46,    0,    0,    0,   47, 
            0,    0,   48,   49,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   50,   51,    0, 
            0,    0,    0,    0,    0,  224,    0,    0,  225,   54, 
           55,   56,    0,  226,  227,  228,   58,   59,  229,   61, 
           62,   63,   64,    0,   65,   66,    0,    0,   68,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,  230,    0,    0,    0,    0,   19,   20,   21,  210, 
          211,  212,  213,    0,    0,  214,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  215,  216,  217,  218,   35, 
          219,  220,  221,  222,  223,   40,   41,   42,   43,   44, 
           45,   46,    0,    0,    0,   47,    0,    0,   48,   49, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   50,  498,    0,    0,    0,    0,    0, 
            0,  224,    0,    0,  225,   54,   55,   56,    0,  226, 
          227,  228,   58,   59,  229,   61,   62,   63,   64,    0, 
           65,   66,    0,    0,   68,    0,    0,    0,    0,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  263,  264,   17, 
           18,  320,    0,    0,    0,    0,   19,   20,  265,  210, 
          211,  212,  213,    0,    0,  214,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  215,  216,  217,  218,   35, 
          219,  220,  221,  222,  223,   40,   41,   42,   43,   44, 
           45,   46,    0,    0,    0,   47,    0,    0,   48,   49, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   50,   51,    0,    0,    0,    0,    0, 
            0,  224,    0,    0,  225,   54,   55,   56,    0,  226, 
          227,  228,   58,   59,  229,   61,   62,   63,   64,    0, 
           65,   66,    0,    0,  320,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  263,  264,   17,   18,  230,    0,    0, 
            0,    0,   19,   20,  265,  210,  211,  212,  213,    0, 
            0,  214,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,  215,  216,  217,  218,   35,  219,  220,  221,  222, 
          223,   40,   41,   42,   43,   44,   45,   46,    0,    0, 
            0,   47,    0,    0,   48,   49,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   50, 
          498,    0,    0,    0,    0,    0,    0,  224,    0,    0, 
          225,   54,   55,   56,    0,  226,  227,  228,   58,   59, 
          229,   61,   62,   63,   64,    0,   65,   66,    0,    0, 
           68,    0,    0,    0,    0,  320,  320,  320,    0,  320, 
            0,    0,    0,  320,  320,    0,    0,    0,  320,    0, 
          320,  320,  320,  320,  320,  320,  320,  230,    0,    0, 
            0,    0,  320,  320,  320,  320,  320,  320,  320,    0, 
            0,  320,    0,    0,    0,    0,    0,    0,  320,    0, 
            0,  320,  320,  320,  320,  320,  320,  320,  320,  320, 
          320,  320,  320,  320,  320,  320,  320,  320,    0,    0, 
            0,  320,    0,    0,  320,  320,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  320, 
          320,    0,    0,    0,    0,    0,    0,  320,    0,    0, 
          320,  320,  320,  320,    0,  320,  320,  320,  320,  320, 
          320,  320,  320,  320,  320,    0,  320,  320,    0,    0, 
           68,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  263, 
          264,   17,   18,  230,    0,    0,    0,    0,   19,   20, 
          265,  210,  211,  212,  213,    0,    0,  214,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,  215,  216,  217, 
          218,   35,  219,  220,  221,  222,  223,   40,   41,   42, 
           43,   44,   45,   46,    0,    0,    0,   47,    0,    0, 
           48,   49,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   50,   51,    0,    0,    0, 
            0,    0,    0,  224,    0,    0,  225,   54,   55,   56, 
            0,  226,  227,    0,   58,   59,  229,   61,   62,   63, 
           64,    0,   65,   66,    0,    0,   68,    0,    0,    0, 
            0,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  263, 
          264,   17,   18,   67,    0,    0,    0,    0,   19,   20, 
          265,  210,  211,  212,  213,    0,    0,  214,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,  215,  216,  217, 
          218,   35,  219,  220,  221,  222,  223,   40,   41,   42, 
           43,   44,   45,   46,    0,    0,    0,   47,    0,    0, 
           48,   49,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   50,   51,    0,    0,    0, 
            0,    0,    0,  224,    0,    0,  225,   54,   55,   56, 
            0,    0,  227,  228,   58,   59,  229,   61,   62,   63, 
           64,    0,   65,   66,    0,    0,   68,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  263,  264,   17,   18,  230, 
            0,    0,    0,    0,   19,   20,  265,  210,  211,  212, 
          213,    0,    0,  214,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,  215,  216,  217,  218,   35,  219,  220, 
          221,  222,  223,   40,   41,   42,   43,   44,   45,   46, 
            0,    0,    0,   47,    0,    0,   48,   49,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   50,   51,    0,    0,    0,    0,    0,    0,  224, 
            0,    0,  225,   54,   55,   56,    0,    0,  227,    0, 
           58,   59,  229,   61,   62,   63,   64,    0,   65,   66, 
            0,    0,   68,    0,    0,    0,  434,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,  230, 
            0,    0,    0,    0,   19,   20,   21,  210,  211,  212, 
          213,    0,    0,   26,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,  215,  216,  217,  218,   35,  219,  220, 
          221,  222,    0,   40,   41,   42,   43,   44,   45,   46, 
            0,    0,    0,   47,    0,    0,   48,   49,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   50,   51,    0,    0,    0,    0,    0,    0,  224, 
            0,    0,  225,   54,   55,   56,    0,    0,    0,    0, 
           58,   59,   60,   61,   62,   63,   64,    0,   65,   66, 
            0,    0,   68,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   15,   16,   17,   18,  230,    0,    0,    0,    0, 
           19,   20,   21,  210,  211,  212,  213,    0,    0,  214, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  215, 
          216,  217,  218,   35,  219,  220,  221,  222,    0,   40, 
           41,   42,   43,   44,   45,   46,    0,    0,    0,   47, 
            0,    0,   48,   49,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   50,   51,    0, 
            0,    0,    0,    0,    0,  224,    0,    0,  225,   54, 
           55,   56,    0,  848,    0,    0,   58,   59,   60,   61, 
           62,   63,   64,    0,   65,   66,    0,    0,   68,    0, 
            0,    0,    0,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  263,  264,   17,   18,  230,    0,    0,    0,    0, 
           19,   20,  265,  210,  211,  212,  213,    0,    0,  214, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  215, 
          216,  217,  218,   35,  219,  220,  221,  222,    0,   40, 
           41,   42,   43,   44,   45,   46,    0,    0,    0,   47, 
            0,    0,   48,   49,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   50,   51,    0, 
            0,    0,    0,    0,    0,  224,    0,    0,  225,   54, 
           55,   56,    0,  983,    0,    0,   58,   59,   60,   61, 
           62,   63,   64,    0,   65,   66,    0,    0,   68,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  263,  264,   17, 
           18,  230,    0,    0,    0,    0,   19,   20,  265,  210, 
          211,  212,  213,    0,    0,  214,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  215,  216,  217,  218,   35, 
          219,  220,  221,  222,    0,   40,   41,   42,   43,   44, 
           45,   46,    0,    0,    0,   47,    0,    0,   48,   49, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   50,   51,    0,    0,    0,    0,    0, 
            0,  224,    0,    0,  225,   54,   55,   56,    0, 1046, 
            0,    0,   58,   59,   60,   61,   62,   63,   64,    0, 
           65,   66,    0,    0,   68,    0,    0,    0,    0,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  263,  264,   17, 
           18,    0,    0,    0,    0,    0,   19,   20,  265,  210, 
          211,  212,  213,    0,    0,  214,    0,  809,    0,    0, 
            0,    0,   28,    0,  809,  215,  216,  217,  218,   35, 
          219,  220,  221,  222,    0,   40,   41,   42,   43,   44, 
           45,   46,    0,    0,    0,   47,    0,    0,   48,   49, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   50,   51,    0,    0,    0,    0,    0, 
            0,  224,    0,    0,  225,   54,   55,   56,    0,  848, 
            0,    0,   58,   59,   60,   61,   62,   63,   64,    0, 
           65,   66,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    4,    5,    6,    0,    8, 
          809,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  263,  264,   17,   18,    0,    0,    0, 
          230,    0,   19,   20,  265,  210,  211,  212,  213,    0, 
            0,  214,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,  215,  216,  217,  218,   35,  219,  220,  221,  222, 
            0,   40,   41,   42,   43,   44,   45,   46,    0,    0, 
            0,   47,    0,    0,   48,   49,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   50, 
           51,    0,    0,    0,    0,    0,    0,  224,    0,    0, 
          225,   54,   55,   56,    0, 1150,    0,    0,   58,   59, 
           60,   61,   62,   63,   64,    0,   65,   66,    0,    0, 
            0,    0,    0,   68,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  809,  809,  809,    0,  809,    0,  230,    0,  809, 
          809,    0,    0,    0,  809,    0,  809,  809,  809,  809, 
          809,  809,  809,    0,    0,    0,    0,    0,  809,  809, 
          809,  809,  809,  809,  809,    0,    0,  809,    0,    0, 
            0,    0,    0,    0,  809,    0,    0,  809,  809,  809, 
          809,  809,  809,  809,  809,  809,    0,  809,  809,  809, 
          809,  809,  809,  809,    0,    0,    0,  809,    0,    0, 
          809,  809,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  809,  809,    0,    0,    0, 
            0,    0,    0,  809,    0,    0,  809,  809,  809,  809, 
           68,    0,    0,    0,  809,  809,  809,  809,  809,  809, 
          809,    0,  809,  809,    4,    5,    6,    0,    8,    0, 
           67,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  263,  264,   17,   18,    0,    0,    0,    0, 
            0,   19,   20,  265,  210,  211,  212,  213,    0,    0, 
          214,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
          215,  216,  217,  218,   35,  219,  220,  221,  222,    0, 
           40,   41,   42,   43,   44,   45,   46,    0,    0,    0, 
           47,    0,    0,   48,   49,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   50,   51, 
            0,    0,    0,    0,    0,    0,  224,    0,    0,  225, 
           54,   55,   56,   68,    0,    0,    0,   58,   59,   60, 
           61,   62,   63,   64,    0,   65,   66,    0,    0,    0, 
            0,    4,    5,    6,    0,    8,    0,  230,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,    0,   19,   20, 
           21,  210,  211,  212,  213,    0,    0,  214,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,  215,  216,  217, 
          218,   35,  219,  220,  221,  222,    0,   40,   41,   42, 
           43,   44,   45,   46,    0,    0,    0,   47,    0,    0, 
           48,   49,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   50,   51,    0,    0,    0, 
            0,    0,    0,  224,    0,    0,  225,   54,   55,   56, 
           68,    0,    0,    0,   58,   59,   60,   61,   62,   63, 
           64,    0,   65,   66,    4,    5,    6,    0,    8,    0, 
          230,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
            0,   19,   20,   21,  210,  211,  212,  213,    0,    0, 
           26,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
          215,  216,  217,  218,   35,  219,  220,  221,  222,    0, 
           40,   41,   42,   43,   44,   45,   46,    0,    0,    0, 
           47,    0,    0,   48,   49,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   50,   51, 
            0,    0,    0,    0,    0,    0,  224,    0,    0,  225, 
           54,   55,   56,   68,    0,    0,    0,   58,   59,   60, 
           61,   62,   63,   64,    0,   65,   66,    0,    0,    0, 
            0,    4,    5,    6,    0,    8,    0,  809,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,    0,   19,   20, 
           21,  210,  211,  212,  213,    0,    0,  790,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,  215,  216,  217, 
          218,   35,  219,  220,  221,  222,    0,   40,   41,   42, 
           43,   44,   45,   46,    0,    0,    0,   47,    0,    0, 
           48,   49,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   50,   51,    0,    0,    0, 
            0,    0,    0,  224,    0,    0,  225,   54,   55,   56, 
          809,    0,    0,    0,   58,   59,   60,   61,   62,   63, 
           64,    0,   65,   66,    4,    5,    6,    0,    8,    0, 
          821,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  263,  264,   17,   18,    0,    0,    0,    0, 
            0,   19,   20,  265,  210,  211,  212,  213,    0,    0, 
          887,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
          215,  216,  217,  218,   35,  219,  220,  221,  222,    0, 
           40,   41,   42,   43,   44,   45,   46,    0,    0,    0, 
           47,    0,    0,   48,   49,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   50,   51, 
            0,    0,    0,    0,    0,    0,  224,    0,    0,  225, 
           54,   55,   56,  821,    0,    0,    0,   58,   59,   60, 
           61,   62,   63,   64,    0,   65,   66,    0,    0,    0, 
            0,  809,  809,  809,    0,  809,    0,    0,    0,  809, 
          809,    0,    0,    0,  809,    0,  809,  809,  809,  809, 
          809,  809,  809,    0,    0,    0,    0,    0,  809,  809, 
          809,  809,  809,  809,  809,    0,    0,  809,    0,    0, 
            0,    0,    0,    0,  809,    0,    0,  809,  809,  809, 
          809,  809,  809,  809,  809,  809,    0,  809,  809,  809, 
          809,  809,  809,  809,    0,    0,    0,  809,    0,    0, 
          809,  809,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  809,  809,    0,    0,    0, 
            0,    0,    0,  809,    0,    0,  809,  809,  809,  809, 
            0,  809,  511,    0,  809,  809,  809,  809,  809,  809, 
          809,    0,  809,  809,  821,  821,  821,    0,  821,    0, 
            0,    0,  821,  821,    0,    0,    0,  821,    0,  821, 
          821,  821,  821,  821,  821,  821,    0,    0,    0,    0, 
            0,  821,  821,  821,  821,  821,  821,  821,    0,    0, 
          821,    0,    0,    0,    0,    0,    0,  821,    0,    0, 
          821,  821,  821,  821,  821,  821,  821,  821,  821,    0, 
          821,  821,  821,  821,  821,  821,  821,    0,    0,    0, 
          821,    0,    0,  821,  821,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  821,  821, 
            0,    0,    0,    0,    0,    0,  821,    0,    0,  821, 
          821,  821,  821,    0,    0,    0,    0,  821,  821,  821, 
          821,  821,  821,  821,  198,  821,  821,    0,  197,  192, 
            0,    0,    0,  195,  193,    0,  194,    0,  196,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  189,    0,  188,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  191,    0,  200,    0,    0, 
            0,    0,    0,    0,    0,  511,  511,  511,  511,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  511,  511,  511,  511,  190,    0,  199,  511,    0, 
          511,  511,  511,  511,  511,  511,    0,    0,    0,  198, 
            0,  511,    0,  197,  192,    0,  511,    0,  195,  193, 
            0,  194,    0,  196,    0,    0,    0,    0,    0,  511, 
          511,    0,    0,    0,    0,    0,  189,  511,  188,    0, 
          511,    0,  511,  511,    0,  511,  511,    0,  511,  511, 
          511,  511,  511,  511,  511,    0,  511,  511,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          191,    0,  200,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  809, 
          190,    0,  199,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  127,  128, 
          129,  130,  131,  132,  133,  134,  135,  136,  137,  138, 
          139,  140,  141,  142,  143,  144,  145,  146,  147,  148, 
          149,  150,  511,    0,    0,  151,  152,  153,  154,  155, 
          156,  157,  158,  159,  160,    0,    0,    0,    0,    0, 
          161,  162,  163,  164,  165,  166,  167,  168,  169,  254, 
            0,  170,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  171,  172,  173, 
          174,  175,  176,  177,  178,  179,    0,    0,  180,  181, 
            0,    0,    0,    0,  182,  183,  184,  185,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  186,  187, 
            0,    0,   59,  127,  128,  129,  130,  131,  132,  133, 
          134,  135,  136,  137,  138,  139,  140,  141,  142,  143, 
          144,  145,  146,  147,  148,  149,  150,    0,    0,    0, 
          151,  152,  153,  154,  155,  156,  157,  158,  159,  160, 
            0,    0,    0,    0,    0,  161,  162,  163,  164,  165, 
          166,  167,  168,  169,    0,    0,  170,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  171,  172,  173,  174,  175,  176,  177,  178, 
          179,    0,    0,  180,  181,    0,    0,    0,    0,  182, 
          183,  184,  185,    0,    0,    0,    0,    0,    0,    0, 
          403,  398,    0,  186,  187,  401,  399,   59,  400,    0, 
          402,    0,    0,    0,    0,  511,  511,  511,  511,    0, 
            0,    0,    0,  395,    0,  394,  393,    0,    0,    0, 
            0,  511,  511,  511,  511,    0,    0,    0,  511,    0, 
          511,  511,  511,  511,  511,  511,    0,    0,    0,    0, 
            0,  511,    0,    0,    0,    0,  511,  397,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  511, 
          511,    0,    0,    0,    0,    0,    0,  511,    0,    0, 
          511,    0,  511,  511,    0,  511,  511,  396,  511,  511, 
          511,  511,  511,  511,  511,  198,  511,  511,    0,  197, 
          192,    0,  449,    0,  195,  193,    0,  194,    0,  196, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  189,    0,  188,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  191,    0,  200,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  190,    0,  199,    0, 
            0,    0,    0,    0,    0,    0,    0,  198,    0,    0, 
            0,  197,  192,    0,    0,    0,  195,  193,    0,  194, 
            0,  196,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  189,    0,  188,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  376,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  191,    0, 
          200,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  190,    0, 
          199,  377,  378,  379,  380,  381,  382,  383,  384,  385, 
          386,  387,  388,  389,    0,    0,    0,    0,  390,  391, 
            0,    0,    0,    0,  392,    0,    0,    0,    0,  127, 
          128,  129,  130,  131,  132,  133,  134,  135,  136,  137, 
          138,  139,  140,  141,  142,  143,  144,  145,  146,  147, 
          148,  149,  150,    0,    0,    0,  151,  152,  153,  437, 
          438,  439,  440,  158,  159,  160,    0,  308,    0,    0, 
            0,  161,  162,  163,  164,  441,  442,  443,  444,  169, 
          445,  446,  447,  448,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  171,  172, 
          173,  174,  175,  176,  177,  178,  179,    0,    0,  180, 
          181,    0,    0,    0,    0,  182,  183,  184,  185,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  186, 
          187,  127,  128,  129,  130,  131,  132,  133,  134,  135, 
          136,  137,  138,  139,  140,  141,  142,  143,  144,  145, 
          146,  147,  148,  149,  150,    0,    0,    0,  151,  152, 
          153,  154,  155,  156,  157,  158,  159,  160,    0,    0, 
            0,    0,    0,  161,  162,  163,  164,  165,  166,  167, 
          168,  169,  316,  317,  170,  318,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          171,  172,  173,  174,  175,  176,  177,  178,  179,    0, 
            0,  180,  181,    0,    0,    0,    0,  182,  183,  184, 
          185,    0,    0,    0,  198,    0,    0,    0,  197,  192, 
            0,  186,  187,  195,  193,    0,  194,    0,  196,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  189,    0,  188,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            4,    5,    6,    0,    8,  191,    0,  200,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  263,  264, 
           17,   18,    0,    0,    0,    0,    0,   19,   20,  265, 
          293,  294,  295,  296,    0,  190,  214,  199,    0,    0, 
            0,    0,    0,  297,    0,  679,  298,  299,  300,  301, 
           35,  302,  303,  304,  305,    0,   40,   41,   42,   43, 
           44,   45,   46,    0,    0,    0,  306,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  307,    0,    0,  225,   54,   55,   56,    0, 
            0,    0,    0,   58,   59,   60,   61,   62,   63,   64, 
            0,   65,   66,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  198,    0,    0,    0,  197,  192,    0,  247,    0, 
          195,  193,    0,  194,    0,  196,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  189,    0, 
          188,    0,    0,    0,    0,    0,    0,    0,  127,  128, 
          129,  130,  131,  132,  133,  134,  135,  136,  137,  138, 
          139,  140,  141,  142,  143,  144,  145,  146,  147,  148, 
          149,  150,  191,    0,  200,  151,  152,  153,  154,  155, 
          156,  157,  158,  159,  160,    0,    0,    0,    0,    0, 
          161,  162,  163,  164,  165,  166,  167,  168,  169,    0, 
            0,  170,  190,    0,  199,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  171,  172,  173, 
          174,  175,  176,  177,  178,  179,    0,    0,  180,  181, 
            0,    0,    0,    0,  182,  183,  184,  185,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,  186,  187, 
            0,   11,    0,   12,   13,   14,  263,  264,   17,   18, 
            0,    0,    0,    0,    0,   19,   20,  265,  293,  294, 
          295,  296,    0,    0,  214,    0,    0,    0,    0,    0, 
            0,  297,    0,    0,  298,  299,  300,  301,   35,  302, 
          303,  304,  305,    0,   40,   41,   42,   43,   44,   45, 
           46,    0,  198,    0,  306,    0,  197,  192,    0,  247, 
            0,  195,  193,    0,  194,    0,  196,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  189, 
          307,  188,    0,  225,   54,   55,   56,    0,    0,    0, 
            0,   58,   59,   60,   61,   62,   63,   64,    0,   65, 
           66,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  191,    0,  200,    0,  198,    0,    0, 
            0,  197,  192,    0,  247,    0,  195,  193,    0,  194, 
            0,  196,    0,    0,  652,  653,    0,    0,  654,    0, 
            0,    0,    0,  190,  189,  199,  188,    0,    0,    0, 
            0,    0,    0,    0,  171,  172,  173,  174,  175,  176, 
          177,  178,  179,    0,    0,  180,  181,    0,    0,    0, 
            0,  182,  183,  184,  185,    0,    0,    0,  191,    0, 
          200,    0,    0,    0,  198,  186,  187,    0,  197,  192, 
            0,  247,    0,  195,  193,    0,  194,    0,  196,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  190,    0, 
          199,  189,    0,  188,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  198,    0,    0,    0,  197, 
          192,    0,  247,    0,  195,  193,    0,  194,    0,  196, 
            0,    0,    0,    0,    0,  191,    0,  200,    0,    0, 
            0,    0,  189,    0,  188,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  190,    0,  199,    0,    0, 
          198,    0,    0,    0,  197,  192,  191,  247,  200,  195, 
          193,    0,  194,    0,  196,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  189,    0,  188, 
            0,    0,    0,    0,    0,    0,  190,    0,  199,    0, 
            0,    0,    0,    0,    0,  662,  663,    0,    0,  664, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  191,    0,  200,    0,  171,  172,  173,  174,  175, 
          176,  177,  178,  179,    0,    0,  180,  181,    0,    0, 
            0,    0,  182,  183,  184,  185,    0,    0,    0,    0, 
            0,  190,    0,  199,  198,    0,  186,  187,  197,  192, 
            0,  247,    0,  195,  193,    0,  194,    0,  196,    0, 
          712,  653,    0,    0,  713,    0,    0,    0,    0,    0, 
            0,  189,    0,  188,    0,    0,    0,    0,    0,    0, 
          171,  172,  173,  174,  175,  176,  177,  178,  179,    0, 
            0,  180,  181,    0,    0,    0,    0,  182,  183,  184, 
          185,    0,    0,    0,    0,  191,    0,  200,    0,    0, 
            0,  186,  187,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  715,  663,    0, 
            0,  716,    0,    0,    0,  190,    0,  199,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  171,  172,  173, 
          174,  175,  176,  177,  178,  179,    0,    0,  180,  181, 
            0,    0,    0,    0,  182,  183,  184,  185,  712,  653, 
            0,    0,  736,    0,    0,    0,    0,    0,  186,  187, 
            0,    0,    0,    0,    0,    0,    0,    0,  171,  172, 
          173,  174,  175,  176,  177,  178,  179,    0,    0,  180, 
          181,    0,    0,    0,    0,  182,  183,  184,  185,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  186, 
          187,    0,    0,  746,  653,    0,    0,  747,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  171,  172,  173,  174,  175,  176,  177, 
          178,  179,    0,    0,  180,  181,    0,    0,    0,    0, 
          182,  183,  184,  185,    0,    0,    0,    0,    0,    0, 
            0,    0,  198,    0,  186,  187,  197,  192,    0,  247, 
            0,  195,  193,    0,  194,    0,  196,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  189, 
            0,  188,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  749,  663,    0, 
            0,  750,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  191,    0,  200,    0,  171,  172,  173, 
          174,  175,  176,  177,  178,  179,    0,    0,  180,  181, 
            0,    0,    0,    0,  182,  183,  184,  185,    0,    0, 
            0,    0,    0,  190,    0,  199,  198,    0,  186,  187, 
          197,  192,    0,  247,    0,  195,  193,    0,  194,    0, 
          196,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  189,    0,  188,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  198,    0,    0, 
            0,  197,  192,    0,  247,    0,  195,  193,    0,  194, 
            0,  196,    0,    0,    0,    0,    0,  191,    0,  200, 
            0,    0,    0,    0,  189,    0,  188,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  198,    0,    0,    0,  197,  192,  190,  247,  199, 
          195,  193,    0,  194,    0,  196,    0,    0,  191,    0, 
          200,    0,    0,    0,    0,    0,    0,    0,  189,    0, 
          188,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  198,  190,    0, 
          199,  197,  192,    0,  247,    0,  195,  193,    0,  194, 
            0,  196,  191,    0,  200,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  189,    0,  188,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  190,    0,  199,  806,  653,    0,    0,  807, 
            0,    0,    0,    0,    0,    0,    0,    0,  191,    0, 
          200,    0,    0,    0,    0,  171,  172,  173,  174,  175, 
          176,  177,  178,  179,    0,    0,  180,  181,    0,    0, 
            0,    0,  182,  183,  184,  185,    0,    0,  190,    0, 
          199,    0,    0,    0,  198,    0,  186,  187,  197,  192, 
            0,  247,    0,  195,  193,    0,  194,    0,  196,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  189,    0,  188,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  809, 
          663,    0,    0,  810,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  191,    0,  200,    0,  171, 
          172,  173,  174,  175,  176,  177,  178,  179,    0,    0, 
          180,  181,    0,    0,    0,    0,  182,  183,  184,  185, 
          878,  653,    0,    0,  879,  190,    0,  199,    0,    0, 
          186,  187,    0,    0,    0,    0,    0,    0,    0,    0, 
          171,  172,  173,  174,  175,  176,  177,  178,  179,    0, 
            0,  180,  181,    0,    0,    0,    0,  182,  183,  184, 
          185,    0,    0,    0,  672,  663,    0,    0,  673,    0, 
            0,  186,  187,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  171,  172,  173,  174,  175,  176, 
          177,  178,  179,    0,    0,  180,  181,    0,    0,    0, 
            0,  182,  183,  184,  185,    0,    0,    0,    0,    0, 
         1040,  653,    0,    0, 1041,  186,  187,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          171,  172,  173,  174,  175,  176,  177,  178,  179,    0, 
            0,  180,  181,    0,    0,    0,    0,  182,  183,  184, 
          185,    0,    0,    0,    0,    0,    0,    0,    0,  198, 
            0,  186,  187,  197,  192,    0,  247,    0,  195,  193, 
            0,  194,    0,  196,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  189,    0,  188,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0, 1043,  663,    0, 
            0, 1044,    0,    0,    0,    0,    0,    0,    0,    0, 
          191,    0,  200,    0,    0,    0,    0,  171,  172,  173, 
          174,  175,  176,  177,  178,  179,    0,    0,  180,  181, 
            0,    0,    0,    0,  182,  183,  184,  185,    0,    0, 
          190,    0,  199,    0,    0,    0,  198,    0,  186,  187, 
          197,  192,    0,  247,    0,  195,  193,    0,  194,    0, 
          196,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  189,    0,  188,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  198,    0,    0, 
            0,  197,  192,    0,  247,    0,  195,  193,    0,  194, 
            0,  196,    0,    0,    0,    0,    0,  191,    0,  200, 
            0,    0,    0,    0,  189,    0,  188,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  190,    0,  199, 
            0,    0,  198,    0,    0,    0,  197,  192,  191,    0, 
          200,  195,  193,    0,  194,    0,  196,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  189, 
            0,  188,    0,    0,    0,    0,    0,    0,  190,    0, 
          199,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  191,    0,  200,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0, 1332,  653,    0,    0, 1333,    0,    0,    0, 
            0,    0,    0,  190,    0,  199,    0,    0,    0,    0, 
            0,    0,  171,  172,  173,  174,  175,  176,  177,  178, 
          179,    0,    0,  180,  181,    0,    0,    0,    0,  182, 
          183,  184,  185, 1098,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  186,  187,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0, 1335, 
          663,    0,    0, 1336,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  171, 
          172,  173,  174,  175,  176,  177,  178,  179, 1098,    0, 
          180,  181,    0,    0,    0,    0,  182,  183,  184,  185, 
         1382,  653,    0,    0, 1383,    0,    0,    0,    0,    0, 
          186,  187,    0,    0,    0,    0,    0,    0,    0,    0, 
          171,  172,  173,  174,  175,  176,  177,  178,  179,    0, 
            0,  180,  181,    0,    0,    0,    0,  182,  183,  184, 
          185,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  186,  187,    0,    0,  672,  663,    0,    0,  673, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  171,  172,  173,  174,  175, 
          176,  177,  178,  179,    0,    0,  180,  181,    0,    0, 
            0,    0,  182,  183,  184,  185, 1080, 1081, 1082, 1083, 
            0,    0,    0,    0,    0,    0,  186,  187,    0,    0, 
            0,    0, 1084, 1085, 1086, 1087,    0,    0,    0, 1088, 
            0, 1089,   40,   41,   42,   43,   44,    0,    0,    0, 
            0,    0,  306,    0,    0,    0,    0,  569,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
         1090, 1091,    0,    0,    0,    0,    0,    0, 1092,    0, 
            0, 1093,    0, 1094, 1095,    0, 1096,  573,    0,   58, 
           59, 1097,   61,   62,   63,   64,    0,   65,   66,    0, 
            0, 1080, 1081, 1082, 1083,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0, 1084, 1085, 1086, 
         1087,    0,    0,    0, 1088,    0,    0,   40,   41,   42, 
           43,   44,    0,    0,    0,    0,    0,  306,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0, 1090, 1091,    0,    0,    0, 
            0,    0,    0, 1092,    0,    0, 1093,    0, 1094, 1095, 
            0,    0,    0,    0,   58,   59,   60,   61,   62,   63, 
           64,    0,   65,   66,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  263,  264,   17,   18,    0,    0,    0,    0, 
            0,   19,   20,  265,  346,  347,  348,  349,    0,    0, 
          214,    0,    0,    0,    0,    0,    0,  297,    0,    0, 
          350,  351,  352,  353,   35,  354,  355,  356,  357,    0, 
           40,   41,   42,   43,   44,   45,   46,    0,    0,    0, 
          306,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  358,    0,    0,   53, 
           54,   55,   56,    0,   57,    0,    0,   58,   59,   60, 
           61,   62,   63,   64,    0,   65,   66,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  263,  264,   17,   18,    0, 
            0,    0,    0,    0,   19,   20,  265,  293,  294,  295, 
          296,    0,    0,  214,    0,    0,    0,    0,    0,    0, 
          297,    0,    0,  298,  299,  300,  301,   35,  302,  303, 
          304,  305,    0,   40,   41,   42,   43,   44,   45,   46, 
            0,    0,    0,  306,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  307, 
            0,    0,  428,   54,   55,   56,    0,  429,    0,    0, 
           58,   59,   60,   61,   62,   63,   64,    0,   65,   66, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  263,  264, 
           17,   18,    0,    0,    0,    0,    0,   19,   20,  265, 
          458,  459,  460,  461,    0,    0,  214,    0,    0,    0, 
            0,    0,    0,  297,    0,    0,  462,  463,  464,  465, 
           35,  445,  446,  466,  448,    0,   40,   41,   42,   43, 
           44,   45,   46,    0,    0,    0,  306,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  467,    0, 
            0,    0,  468,    0,    0,  225,   54,   55,   56,    0, 
            0,    0,    0,   58,   59,   60,   61,   62,   63,   64, 
            0,   65,   66,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  263,  264,   17,   18,    0,    0,    0,    0,    0, 
           19,   20,  265,  458,  459,  460,  461,    0,    0,  214, 
            0,    0,    0,    0,    0,    0,  297,    0,    0,  462, 
          463,  464,  465,   35,  445,  446,  466,  448,    0,   40, 
           41,   42,   43,   44,   45,   46,    0,    0,    0,  306, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  468,    0,    0,  225,   54, 
           55,   56,    0,    0,    0,    0,   58,   59,   60,   61, 
           62,   63,   64,    0,   65,   66,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  263,  264,   17,   18,    0,    0, 
            0,    0,    0,   19,   20,  265,  293,  294,  295,  296, 
            0,    0,  214,    0,    0,    0,    0,    0,    0,  297, 
            0,    0,  298,  299,  300,  301,   35,  302,  303,  304, 
          305,    0,   40,   41,   42,   43,   44,   45,   46,    0, 
            0,    0,  306,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  307,    0, 
            0,  428,   54,   55,   56,    0,    0,    0,    0,   58, 
           59,   60,   61,   62,   63,   64,    0,   65,   66,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  263,  264,   17, 
           18,    0,    0,    0,    0,    0,   19,   20,  265, 1204, 
         1205, 1206, 1207,    0,    0,  214,    0,    0,    0,    0, 
            0,    0,  297,    0,    0, 1208, 1209, 1210, 1211,   35, 
         1212, 1213, 1214, 1215,    0,   40,   41,   42,   43,   44, 
           45,   46,    0,    0,    0,  306,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0, 1216,    0,    0,  225,   54,   55,   56,    0,    0, 
            0,    0,   58,   59,   60,   61,   62,   63,   64,    0, 
           65,   66,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          263,  264,   17,   18,    0,    0,    0,    0,    0,   19, 
           20,  265,  458,  459,  460,  461,    0,    0,  214,    0, 
            0,    0,    0,    0,    0,  297,    0,    0,  462,  463, 
          464, 1325,   35,  445,  446, 1326,  448,    0,   40,   41, 
           42,   43,   44,   45,   46,    0,    0,    0,  306,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0, 1327,    0,    0,  225,   54,   55, 
           56,    0,    0,    0,    0,   58,   59,   60,   61,   62, 
           63,   64,    0,   65,   66, 
      };
   }

   private static final int[] yyCheck1() {
      return new int[] {

            2,    2,   60,   98,  121,  122,   90,   57,   15,   16, 
           59,   53,   54,   99,  340,    2,  242,   13,   14,  105, 
          457,  112,  599,    7,  594,  602,   87,    7,   15,   16, 
          335,  776,   67,  468,  247,  340,  874,  121,   88,   27, 
          335,   57,  490,   27,  414,  340,  494,   27,  772,   53, 
          774,   53,   54,   55,   56,   15,   16,  119,  494,  121, 
          122,  490,  112,   15,   16,  413,   53,   54,  416,  603, 
           57,  120,  603,  123,  124,  772,  424,   10,   10,   59, 
           67,   38,   84,   85,  581,   64,   65,   66,  585,  287, 
           21,  546,   46,  291,   10,   55,   56,  533,  123,  754, 
          529,   88,   10,   55,   15,   16,   47,   30,   44,  123, 
          117,   10,  324,  325,   90,  913,  671,   10,  488,  677, 
          675,  676,   40,  121,   10,  112,  703,   59,  636,  125, 
          117,  101,  119,  571,  121,  122,  123,  124,   10,  487, 
          120,  489,   37,   59,   10,   44,  814,   42,  914, 1094, 
          236,   59,   47,  276,  283,  870,  126,  117,   44,   10, 
           59,  123,   40,  669, 1197,  117,   59,    0,   44,    0, 
          101,  229,  520,   59,  544,   41, 1191, 1192,   44,  710, 
          774,  267,   46,  225,   10,   61,   10,   59,   10,  251, 
           26,  253,   28,   59,  278,   61,  283,  545,   85, 1024, 
           10,   40,  320, 1023, 1024,  123,  117, 1296,   59, 1171, 
          288,  776,   10,   91,   85,   41,   10,  308,   44,   10, 
           10,   10, 1184,  225,  679,   46,  312,  344,  306,  231, 
          232,   41,   32,   59,  276,   59,   10,   59,  225,  609, 
          247, 1274,   46,  250,  373,  247, 1191, 1192,   10,  367, 
           41,   41,  369,  370,  371,  372,  258,  258,  308,   46, 
          247,   59,  610,  250,  251,  700,  253,   41,   59,   59, 
           91,  258,  276,  359,  276, 1073,  502,  725, 1367,  727, 
          278,  123,  344,   93, 1008,   10,  373,   91, 1303,  276, 
          250,  727,  125,   46,  125,  247,  725,   59,  250,   93, 
          877,  343,  278,  345,   91,  428, 1072,  369,  370,  371, 
          372,  979,  374,  375, 1152, 1012,   40,  823,  280,   93, 
           44,  308,   46,   10, 1149,  350,  764,  765,   10, 1149, 
           60,  701,   62,  256,  265,  267,  350,  268,   91,  250, 
           10,  343,  269,  345,  231,  232,   44,  559,   46,  561, 
          467, 1313,  279,   40,  702,  925,  343,  344,  345,  306, 
          868,  232,  280,  310,   46,  306,  367,   91,  267,   10, 
          454,  264, 1314,  281,   44,  268,  269,   59,  826,  429, 
          367,  267,  369,  370,  371,  372,  428,  374,  375,  944, 
          945,  263,  264,   91,  348,  950,  951,  826,  932,   10, 
           41,  932,  359,  279,   10,  467,  861,  414,  324,   91, 
          987,  969,  414,  429, 1008,  351,  267,  283,  351,  351, 
           61,  918,  919,  920,  428,  922,  428,  414,   10,  322, 
          927,  433,   59,  328, 1376,   41,  416, 1152,   44,  310, 
           10,  428,  429, 1098,  424,  267,  433,  648,   59,  650, 
          322,   10,  351,   59,  370,  546,  454,  283, 1023, 1024, 
           38,  297,  993,  310,   10,  606,  264,  772,  475,  774, 
          348,   41,    0, 1197,   44,  913,  914,   10, 1033,   32, 
          467,  488,   10,  347,  348,  416,  488,   46,  475,   59, 
         1045,   46,  283,  283,  720,   41,  546,  124,  421,  362, 
           59,  488,  425,  426,  427,  267,  647,  373,   41,  489, 
          651,   93,  725,   59,  271,  475, 1302,  601,  124, 1305, 
          320,  605,  279,  475,  322,  513,  347,  348, 1366,  513, 
          490,   59,   91,  513,  963,   40,   91,  544,  282,  526, 
          520,  682,  544,  347,  348,  757,  744,  373,  985,  761, 
          611,  999,  263,  264,  124,  279,   10,  544,  489,  546, 
          347,  348,   10,  999,  475,  545,  291,  292,   10,  529, 
          493,  371,  372,  496,  497, 1320,   41, 1074, 1075, 1076, 
         1077,  279,  373,  373, 1149,  267,   41,  957,  679,  520, 
         1314,  514, 1316,  600,  347,  348,  603,  599,  521,   41, 
          602,   46,  609,  333,  334,   59,   44,  609,  956,  264, 
          958,  322,  599,  600,  545,  602,  603,   59,  619, 1316, 
         1057, 1198,  609,  347,  348,  687, 1191, 1192, 1193,  679, 
          610,   10,  619,  350, 1072, 1073,  671,  283,  279,  320, 
          675,  676,  677,  685,   10,   93,   91,  324,  789,  347, 
          348,  693, 1376,  264,  745,  796,  671, 1092,  269,  124, 
          675,   10,  704,  264,  666,  347,  348,  322,  894,  124, 
          732,  125,  674,  291,  292, 1372, 1002,  283,   44,  610, 
           59,   10,  124,  685,  671,   46,  367,  657,  675,  676, 
          677,  693,  679,  370,  701,  745,  666, 1002,  685,  701, 
          687,  703,  704, 1008,  674, 1275,  693, 1002,  267, 1146, 
           59,  322, 1282,  283,  701,   44,  703,  704,  350,  707, 
         1297,  322,  702,  707,  676,  677,  657,  707,  869,   41, 
           91,  872,   40,   10,  312,  666,  738,   61, 1303, 1236, 
           93,  882, 1068,  674,   61,  732,  308,   59,    2,  844, 
          328,   44,  838, 1188,   41, 1320,  318,  319,  745,  876, 
          683,   15,   16, 1068,   41,  725,   10,  373,  320,  811, 
          861,  702,  125, 1068,   10,  124,   46,  776,  757,  758, 
          358,  359,  761,  762,  783, 1222,   10,   10,  347,  348, 
         1360,  875,  347,  348,    0,   10,   40,  938,   46,   53, 
           54,  637,   46,  373,   10,   40,  737,  738,   44,  811, 
          320,  861,  288,   67,  876,   59,   93,   41,  867,  371, 
          372,   91,  374,   59,  811,  661,  269,  310,  271,  475, 
          306,  972,   44,  351,   46,   10,   59,   61,  125,   10, 
          981,  283,   10,   91,   59,  986,   10,   91,  989,  320, 
         1090, 1091,  774,   59,   10,  501,  778,  367,  504,  976, 
          506,  863,  864,  117,  320,  119,  826,  121,  122,   44, 
           41, 1171,  874,   10,  861,  877,   40,  523,  714,   91, 
           44,   44,   46,  350,   59,   41,   10,  867,  124,  876, 
          877,   59, 1197,   10, 1194,   59,  367,   10,  821,  822, 
          271,  124,  347,  348,  988,  901,  829,  830,  279,  944, 
          945,  367,  748,   44,  976,  950,  951,   41, 1288,  125, 
          263,  264,   59, 1064,   41,  932,  269,   91,   41,  944, 
          945,  373,  578,  975,   37,  950,  951,   61,  350,   42, 
           43, 1289,   45,   10,   47,  932, 1186, 1187,   61,  124, 
          957,  825,   10,   61,  790,  957,  320,  944,  945,  833, 
          124,  268,  269,  950,  951,  888,  889,  969,  891,  892, 
          957,  225,  808,  975,   41,  262,  263,  264,  958,  322, 
          714,  268,  269,   40,  271,  987,  347,  348,  975,  976, 
          940,  328,  279,  247,   61,   10,  250,  251, 1033,  253, 
          987,   59, 1302,  367,  258, 1305,  339,  340,   10, 1314, 
         1045, 1316,   10, 1313,  748,  306,  350,  969, 1033,  310, 
         1062,   41,  276,  267,  328,  948,   41,  958,   93, 1071, 
         1026, 1027,  678,  294,  295,  322,  959,  324, 1039, 1097, 
          125,   10,   44,   41,   59,  881, 1033, 1048, 1050,  264, 
         1052,  887, 1039,  310,  269,  279,  271,   59, 1045,  705, 
         1062, 1048,   10,   10, 1181,  413,  124,  279,  416, 1071, 
         1370, 1376,   41,  996,  808, 1062,  424,  347,  348,   10, 
          817,   10,  819,  370, 1071,   44, 1008,   32, 1010,  343, 
          344,  345, 1014,   41,   41, 1145,  264,   10, 1140,  347, 
          348,  269, 1144,  347,  348,   61, 1148,  322, 1058,   61, 
           41,  279,   41,  367,   61,  369,  370,  371,  372, 1181, 
          374,  375,  124,  769,  310,  262,  263,  264,   41, 1131, 
         1132, 1217,  269,  309,  310,  347,  348,   10, 1140,  487, 
          671,  489, 1144, 1093,  675, 1095, 1148,  881,   61,  279, 
         1152,    2,  356, 1140,  322,  279,   10, 1144, 1145, 1201, 
          414, 1148, 1184,   44,   15,   16,  279,   59,   41, 1191, 
         1192,  519,  520,   10,  428,   60, 1293, 1294, 1220,  433, 
           44,  123,   46,  347,  348,  322,   61,   41,   61, 1231, 
          721,   61,  723,   41, 1181,  543, 1198,  545, 1197, 1201, 
          320,   44,   53,   54, 1345,   10, 1042, 1265,  739,   46, 
           44, 1198,   46,  467, 1201,   44,   67,  125, 1220, 1221, 
          866,  475,   59,  942,  943,  328,   41,   91,   44, 1231, 
         1280, 1293, 1294, 1220,  488,   44,   41, 1159,   10, 1189, 
         1190,   44,  345,  346, 1231,   44,   10,  367,   44,  895, 
          896,  371,  372, 1176,   91,   44,   61,   91, 1094, 1095, 
          608,  306,  610,  306,  125,  911,  117,  350,  119,   10, 
          121,  122,  526,   44,   46, 1197,  350,   41,  350, 1329, 
           10, 1288,   44, 1285,  267,  279, 1288,   59, 1290,  123, 
          544,   10,  271, 1280,   10, 1297, 1338,   61,  125,   40, 
           41, 1288,   44,   44,  350,   46, 1293, 1294, 1042, 1289, 
         1297,   41,  350,  350,   44, 1314,  320, 1316, 1154,   91, 
           61, 1320,   38,  350, 1323,   40,   42,   46,   61,   44, 
           44,   46,  279, 1169, 1170,  298, 1338,  298,   58,  350, 
           59,   93, 1329,   59,  125,  599,  600,  298,  602,  603, 
           91, 1338,  700, 1189,  702,  609,   61,   44, 1289,   10, 
         1094, 1197,  298,  367, 1366,  619,  279,  371,  372,  262, 
          374,  269,   91, 1372,  225, 1374,   91, 1376,   10, 1378, 
           37,   38,  123,  350,   44,   42,   43,   38,   45,  125, 
           47,   42, 1314,  125,   44, 1394,  247,   44,   44,  250, 
          251, 1323,  253,   44,  123,  306,  279,  258,  123,   41, 
           44,   10,   46,  944,  945,  279,   44,  671,  320,  950, 
          951,  675,  676,  677,   44,  276, 1262, 1263, 1264,   61, 
          267,  685,  263,  687,  351, 1169, 1170,   44, 1274,  693, 
          306,  124,   41,   44,   44,  279,  280,  701,    0,  703, 
          704,  124, 1374,  320, 1376, 1189, 1378,   91,   10,   44, 
           59,  351,  125,  994,  995,  367,  997,  998,  306,  371, 
          372,   37, 1394,   41,  279,  310,   42,   43,  732,   45, 
           59,   47,   44,  347,  348,  312,   44,   44,   44,   41, 
           44,   10,  343,  344,  345,  267,   44,   44, 1334,  124, 
          367,  328, 1033,   44,  371,  372, 1342,   59,  320,  125, 
          347,  348, 1348,  347,  348,  279,  367,   10,  369,  370, 
          371,  372,   41,  374,  375,   44,  125,   46, 1262, 1263, 
         1264,  358,  124,    2,  310,  362, 1067,   44,  279,  280, 
           44,   93,   61,   44, 1190,  125,   15,   16,  267,   44, 
           44,   44,   44,   44,   46,  367,   93,  811,  271,  371, 
          372,  280,  374,  414,  279,  280,   59,   41,   61,  320, 
          321,   93,   91,  125,  125,  347,  348,  428,  313,  314, 
          315,  316,  433,  320,   53,   54,   40,   93,   58,  271, 
          306, 1237,  308,  309,  310,  311,  312,   93,   67,   91, 
         1334, 1247,  125,   44,  123,   70,  347,  348,  956,  124, 
          958,  561,  328, 1259, 1260, 1261,  467,  867,  933,  934, 
          371,  372,  876,  877,  475,  258,  342,  367,  347,  348, 
          367,  124,  347,  348,  371,  372,  352,  488,  522,  954, 
          955,  357,  358,  359,  526,  279, 1221,  279,  117,  964, 
          119, 1290,  121,  122, 1285,  306,   10,  308,  309,  310, 
          311,  312,  674,  262,  263,  264, 1316, 1197,  120,  268, 
          269,  328,  271,  772,  913,  526,  764,  328,  932, 1132, 
          279,  776,  306, 1320,  308,  309,   40,  311,  345,  346, 
          944,  945,   46,  544,    0, 1367,  950,  951,  845,  411, 
           44,  352,   46,  957,   10,   59,  357,  358,  359,   88, 
          262,  263,  264,  347,  348,  267,  268,  269,   44,  271, 
           46,  975,  976,  322, 1366,  324, 1185,  279,  352,  281, 
          282, 1183,   10,  987,  100,   41, 1193,   91,   44,  291, 
          292,  967,  294,  295,  296,  297,  298,   91,  599,  600, 
         1348,  602,  603,   59, 1193,  514,  225, 1281,  609,  312, 
          279,  280,  328,   41,   -1,   91,   44,   10,  619,  123, 
          322,  370,  324,   -1,   -1,  328,   -1,   -1,  247, 1033, 
          320,  250,  251,   61,  253, 1039,   -1,  279,   44,  258, 
           46, 1045,   -1,   -1, 1048,   -1,  306,   40,  308,  309, 
          310,  311,   -1,   46,  356,  358,   -1,  276, 1062,  362, 
           10,   -1,   -1,   -1,   -1,   56,   59, 1071,  370,  125, 
          671,  320,   -1,   -1,  675,  676,  677,  367,  347,  348, 
           -1,  371,  372,   10,  685,   91,  687,   -1,   -1,   -1, 
           40,   41,  693,   -1,   44,  320,   46,   -1,   91,   -1, 
          701,   -1,  703,  704,   -1,  347,  348,  320,   -1,   -1, 
           44,   61,   46,   40,   41,  320,   -1,   44,  367,   46, 
           -1,   -1,  371,  372,  343,  344,  345,   -1,  320,   -1, 
          123,  732,   -1,   -1,   61,   -1, 1140,   -1,   10,   -1, 
         1144,   91,  367,   -1, 1148,   -1,  371,  372,  367,   -1, 
          369,  370,  371,  372,  367,  374,  375,   91,  371,  372, 
           -1,   -1,  367,  267,   91,   -1,  371,  372,   40,   -1, 
           -1,   -1,   44,  123,   46,  367,  280, 1181,   -1,  371, 
          372,   -1,   -1,   -1,   -1,  279,   -1,   59,   -1, 1287, 
           -1, 1289,   -1,   -1, 1198,  414,  123, 1201,   44,   -1, 
           46,   -1,   -1,  279,   -1,   -1,  262,  263,  264,  428, 
          811,  267,  268,  269,  433,  271, 1220,   -1,   -1,   91, 
           -1,   -1,   -1,  279,   -1, 1023, 1024, 1231,   -1,   -1, 
           10,   10,  223,   -1,   -1,  226,  227,  228,  294,  295, 
          296,  297,  298,  347,  348,   91,   -1,   -1,  467,   -1, 
            2,  123,  124,  347,  348,   -1,  475,   40,   38,   -1, 
           -1,   44,   42,   46,   -1, 1363,  322,   46,  324,  488, 
           -1,  347,  348,  279,  267,  876,  877,   -1,   -1,   59, 
           59,   61,   -1,   -1, 1288,   -1,   10,  280,   -1, 1293, 
         1294,   -1,   -1, 1297,   -1,  351,   -1,   10,   -1,   -1, 
           -1,   53,   54,   -1,   -1,   57,   -1,  526,   91,   -1, 
           -1,   -1,   91,   -1,  370,   -1,   40,   41,   -1,   -1, 
           44,   -1,   46,   -1,   -1,  544,   -1,   40,   10,  279, 
          280,  932,   -1,   46, 1338,   -1,   88,   61,   -1,   -1, 
          123,  347,  348,  944,  945,  279,   59,   -1,   -1,  950, 
          951, 1149,  279,  280,  347,  348,  957,   -1,    0,   -1, 
          112,   -1,   -1,   -1,   46,   -1,   -1,   91,   10,   -1, 
           -1,  123,  124,   -1,  975,  976,   -1,   59,   91,   -1, 
          599,  600,   -1,  602,  603,   -1,  987,   -1,   -1,   -1, 
          609,   -1,   -1, 1191, 1192, 1193,   -1,  347,  348,   41, 
          619,   -1,   -1,   -1,   46,   -1,   -1,   -1,  280,   91, 
          123,   -1,   -1,  347,  348,  308,  309,   59,  311,   -1, 
          347,  348,   -1,   -1,   -1,  318,  319,   -1,   10,   -1, 
           -1,   -1, 1033,  279,   -1,   -1,   -1,   -1, 1039,   -1, 
         1023, 1024,   -1,   -1, 1045,   -1,  306, 1048,  308,  309, 
          310,  311,  671,   -1,   -1,   -1,  675,  676,  677,   41, 
           -1, 1062,   44,   -1,   46,    2,  685,   -1,  687,   -1, 
         1071,   -1,   -1,  225,  693,  347,  348,   -1,   10,   61, 
           -1,    0,  701,  125,  703,  704,   -1,   -1,  267,   -1, 
           -1,   10,  352,   -1,   -1,  486,  279,  280,   -1,  490, 
           -1,  347,  348,  494,   -1, 1303,  258, 1090, 1091,   91, 
           -1, 1094,   -1,  732,   46,   -1,   53,   54,   -1,   -1, 
           57,   -1,   41,   -1,  276,   44,  306,   59,  308,  309, 
          310,  311,  312,  294,  295,  296,  297,  298,  529, 1140, 
           59,   -1,  533, 1144,   -1, 1128,   -1, 1148,  328,   -1, 
           -1,   88,   -1,   -1,  267,  279,  308,   -1,   -1,   91, 
           -1,   -1,  342,   -1,  347,  348, 1149,  280,  347,  348, 
           -1,   -1,  352,   -1,   93,  112,   -1,  357,  358,  359, 
         1181,   -1,   -1,   -1, 1167,  267,  123,  124, 1171,    2, 
           -1,  343,  811,  345,   -1,   -1,   44, 1198,   46,  590, 
         1201, 1184, 1185, 1186, 1187,   -1,  125,   -1, 1191, 1192, 
           -1, 1194,   -1,   -1,   -1,  367,   -1,   -1,   -1, 1220, 
          262,  263,  264,  347,  348,  267,  268,  269,   -1,  271, 
         1231,   -1,   -1,   10,  347,  348,   -1,  279,   -1,  281, 
           53,   54,   -1,   91,   57,   -1,   -1,   -1,   -1,  291, 
          292,   -1,  294,  295,  296,  297,  298,  876,  877,   -1, 
           -1,   -1,   -1,   40,   41,  347,  348,   44,   -1,   46, 
           -1,   -1,   -1,   10,   -1,   88,  428,  429,   -1,   -1, 
          322,  433,  324,   -1,   61,  676,  677, 1288,  225,   -1, 
           -1,   -1, 1293, 1294,   -1,   -1, 1297,  279,   -1,  112, 
           -1,   -1,   -1,   40,   41,  347,  348,   44,   -1,   46, 
          123,  124,   -1,  932,   91,   -1,   -1,  708,   -1, 1302, 
           -1,  258, 1305,   -1,   61,  944,  945,   -1,  370,   -1, 
         1313,  950,  951,   -1,  725,  267,  727, 1338,  957,  276, 
           -1,   -1,   -1,  262,  263,  264,  123,   -1,  267,  268, 
          269,   -1,  271,   -1,   91,   10,  975,  976,   -1,   -1, 
          279,   -1,  281,  282,  283,  347,  348,   -1,  987,   -1, 
           -1,  308,  291,  292,  526,  294,  295,  296,  297,  298, 
           -1,   -1,   -1,   -1,   -1,   40,  123, 1370,   -1,   44, 
          781,   46,   -1,   44,  546,   46,  306,   -1,  308,  309, 
          310,  311,   -1,  322,   59,  324,  343,   -1,  345, 1197, 
           -1,   -1,  225,   -1, 1033,  347,  348,   -1,   -1,   -1, 
         1039,   -1,   -1,   -1,   -1,   10, 1045,   -1,   -1, 1048, 
          367,  279,  351,   -1,   -1,  826,   91,  356,   -1,   10, 
           91,   -1,   -1, 1062,   -1,  258,   -1,  599,   -1,   -1, 
          602,  370, 1071,   -1,  373,   -1,   41,  848,   -1,   44, 
           -1,   46,   -1,  276,   -1,   -1,    2,  619,  123,  124, 
           41,   -1,   -1,   44,   -1,   46,   61,   -1, 1023, 1024, 
           10,   -1,  873,   -1,   -1,   -1,   -1,    2,   -1,   -1, 
           61,  428,  429,   -1,   -1,  308,  433,   -1,   -1,  347, 
          348,   -1,  279,  280, 1197,   -1,   91,   -1,   -1,   -1, 
           -1,   41,   -1,   -1,   44,   -1,   46,   53,   54,  671, 
           91, 1140,   -1,  675,  676, 1144, 1314,  679, 1316, 1148, 
          343,   61,  345,  685,   -1, 1323,   -1,   -1,   53,   54, 
           -1,  693,  279,  280,   -1, 1090, 1091,   -1,   -1, 1094, 
           -1,  703,  704,   -1,  367,   -1,   -1,   -1,   -1,   -1, 
           -1,   91, 1181,   -1,   10,   -1,   -1,   -1,   -1,   10, 
          347,  348,  963,   88,   -1,   -1,   -1,   -1,  969, 1198, 
           -1,   -1, 1201, 1128, 1372,   -1, 1374,   -1, 1376,  526, 
         1378,   -1,  983,  745,   40,   -1,   -1,   -1,   -1,   10, 
           46, 1220,  754,   -1, 1149,   46, 1394,   -1,  999,  546, 
          347,  348, 1231,   59,   -1,  428,  429,   -1,   59,   -1, 
          433, 1314, 1167, 1316,   -1,  280, 1171, 1320,  279,   40, 
         1323,   -1,   -1,   -1,   -1,   46,   -1,   10,   -1, 1184, 
         1185, 1186, 1187,   -1,   -1,   91, 1191, 1192,   59, 1194, 
           91,   -1,   -1,   -1,   -1, 1046,   -1,   -1,   -1,  811, 
           -1,   -1,  599,   -1,   -1,  602,   -1,   -1,   -1, 1288, 
         1061,   -1,   -1,   46, 1293, 1294,   -1,  123, 1297, 1372, 
           91, 1374,  619, 1376,   -1, 1378,   59,   -1,    0,  225, 
           -1,   -1,  347,  348,  279,   -1,  347,  348,   10,   -1, 
           -1, 1394,   -1,   -1,   -1,   -1,   -1,   -1,  279,  861, 
          225,   -1,  123,  526,   -1,   -1,   -1,   -1,   91, 1338, 
           -1,   -1,  258,   -1,   -1,  877,   -1,   -1,   -1,   41, 
           -1,   -1,   44,  546,  671,   10,   -1,   -1,  675,  676, 
          276,   -1,  679,  258,   -1,   -1,   58,   59,  685,  279, 
          306,   63,  308,  309,  310,  311,  693, 1302,   -1, 1150, 
         1305,  276,  347,  348,   -1,   40,  703,  704, 1313,   44, 
           -1,   46,   -1, 1023, 1024,   -1,  347,  348,   -1,   -1, 
           -1,   93,   -1,   -1,   59,   -1,  599,   -1,   -1,  602, 
           -1,   -1,  944,  945,   -1,   -1,  352,   -1,  950,  951, 
           -1,  357,   -1,   -1,   -1,   10,  619,  343,  745,  345, 
           -1,   -1,   -1,  125,   -1,   -1,   91,  347,  348,   -1, 
           -1,  267,   -1,  975,   -1, 1370,  267,   -1,  343,   -1, 
          345,  367,   -1,   -1,  280,  987,   -1,   -1,   -1,   -1, 
           -1,   46,   -1,   -1, 1094,   -1,   -1,   -1,  123,  124, 
           -1,   -1,  367,   -1,   59,   -1,  267,   -1,  671,   -1, 
           -1,   -1,  675,  676,   -1,   -1,  679,   10,   -1,  280, 
           -1,   -1,  685,   -1,  811,   -1,   -1,   -1, 1128,   -1, 
          693, 1033,   -1,   -1,   -1,   -1,   91, 1039,   -1,   -1, 
          703,  704,  428, 1045,  267,   10, 1048,  433,   -1, 1149, 
           -1,  347,  348,   46,   -1,   -1,  347,  348,   -1,   -1, 
         1062,   -1,   -1,  428,   -1,   -1,   59, 1167,  433, 1071, 
           -1,   -1,   -1,   38,  861,   40,   -1,   42,   -1,   -1, 
           -1,   46,  745,   -1, 1184,   -1,  347,  348,   -1,   -1, 
          877, 1191, 1192,   -1,   59,   -1,   61,   -1,   91,   -1, 
          262,  263,  264,   10,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  279,   -1,  281, 
          282,  283,   -1,   -1,  347,  348,   -1,   -1,   -1,  291, 
          292,   -1,  294,  295,  296,  297,  298,   -1, 1140,   46, 
          526,   -1, 1144, 1145,   -1,   -1, 1148,   38,  811,   40, 
           -1,   42,   59,   -1,   -1,  280,   -1,  944,  945,   10, 
          322,  526,  324,  950,  951,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  335,  336,   -1,   -1,  339,  340,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,  975,  351, 
           41,   -1,   -1,   44,  356,   46, 1198,   -1,  861, 1201, 
          987,   -1,   -1,   -1,   -1,   -1,   -1,    0,  370,   -1, 
           61,  373,  267,  599,  877,   -1,  602,   10, 1220,   -1, 
           40,   -1,  347,  348,   44,   -1,   46,   -1,   -1, 1231, 
           -1,   -1,   -1,  619,  599,   -1,   -1,  602,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1, 1033,   -1,   41,   -1, 
           -1,   44, 1039,   -1,  619,   -1,   -1,   -1, 1045,   -1, 
           -1, 1048,   37,   38,   -1,   -1,   59,   42,   43,   -1, 
           45,   91,   47,   -1,  267, 1062,   -1,   -1, 1280,   -1, 
           -1,  944,  945,   -1, 1071,  671,   -1,  950,  951,  675, 
          676,   -1,  347,  348,   -1, 1297,   -1,   -1,   -1,  685, 
           93,   -1,   -1,  123,   -1,   -1,  671,  693,   -1,   -1, 
          675,  676,  975,   -1,   -1,   -1,   -1,  703,  704,   94, 
          685,   -1,   -1,   -1,  987,   -1,   -1, 1329,  693,   -1, 
           -1,   -1,  125,   -1,   -1,   10, 1338,   -1,  703,  704, 
           -1,  306,   -1,  308,  309,  310,  311,  312,   -1,  124, 
           -1,   -1,   -1, 1140,  347,  348,   -1, 1144, 1145,   -1, 
          267, 1148,   -1,  328,   -1,   -1,   41,   -1,   -1,   44, 
         1033,   46,   -1,   10,   -1,   -1, 1039,  342,   -1,   -1, 
           -1,   -1, 1045,  348,   -1, 1048,   61,  352,   -1,   -1, 
           -1,   -1,  357,  358,  359,   -1,   -1,   -1,   -1, 1062, 
           -1,   -1,   -1,   41,   41,   -1,   -1,   44, 1071,   46, 
           -1, 1198,   -1,   -1, 1201,  306,   91,  308,  309,  310, 
          311,  312,   -1,   -1,   61,  811,   -1,   -1,  279,   -1, 
           -1,   -1,   -1, 1220,   -1,   -1,   -1,  328,   -1,   -1, 
          347,  348,   -1,   -1, 1231,   -1,  811,   -1,   -1,   40, 
           -1,  342,   -1,   44,   91,   46,   -1,   -1,   -1,  279, 
          280,  352,   -1,   -1,   -1,   -1,  357,  358,  359,  262, 
          263,  264,   -1,   -1,  267,  268,  269, 1140,  271,   -1, 
           -1, 1144, 1145,   -1,   -1, 1148,  279,  125,  281,  282, 
           10,  877,   -1, 1280,   -1,   -1,  347,  348,  291,  292, 
           91,  294,  295,  296,  297,  298,   -1,   -1,   -1,   -1, 
         1297,   -1,  877,   -1,   15,   16,   -1,   -1,   38,   -1, 
           40,   -1,   42,   -1,   -1,   -1,   46,  347,  348,  322, 
           -1,  324,  123,   -1,   -1, 1198,   -1,   -1, 1201,   59, 
           -1,   61, 1329,   -1,   -1,   -1,   -1,   48,   49,   50, 
           51, 1338,   -1,  328,   55,   56,   -1, 1220,  944,  945, 
           -1,   -1,   -1,  356,  950,  951,   67,   68, 1231,   -1, 
          345,  346, 1023, 1024,   -1,   -1,   -1,  370,   -1,  944, 
          945,   -1,   -1,   -1,   -1,  950,  951,   -1,   -1,  975, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  987,   -1,   -1,  279,   -1,   -1,   -1,   -1,   -1, 
          975,   -1,   -1,   -1,   -1,   -1,  117, 1280,   -1,   -1, 
           -1,   -1,  987,   -1,  262,  263,  264,   -1,   -1,   -1, 
          268,  269,   -1,  271, 1297,   -1,   -1,   -1,   -1, 1090, 
         1091,  279,  279, 1094,   -1,   -1,   -1, 1033,   -1,   -1, 
           -1,   -1,   -1, 1039,   -1,   -1,   -1,   -1,   -1, 1045, 
            0,   -1, 1048,   -1,   -1,   -1, 1329,   -1, 1033,   -1, 
           10,   -1,  347,  348, 1039, 1338, 1062, 1128,   -1,   -1, 
         1045,   -1,   -1, 1048,  322, 1071,  324,   -1,  279,  280, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1, 1062, 1149,   -1, 
           -1,   41,   -1,   -1,   44,   -1, 1071,   -1,   -1,   -1, 
          347,  348,   -1,   -1,   -1,   -1, 1167,   10,   -1,   59, 
         1171,   -1,  223,   -1,   -1,  226,  227,  228,   -1,  230, 
           -1,   -1,  370, 1184, 1185, 1186, 1187,   -1,   -1,   -1, 
         1191, 1192,   -1, 1194,   -1,   -1,  247,   -1,   41,  250, 
           -1,   44,   -1,   46, 1140,   -1,  347,  348, 1144,   -1, 
           -1,   -1, 1148,   38,   -1,   -1,   -1,   42,   61,   -1, 
           -1,   -1,   -1,   -1,   10, 1140,   -1,   -1,   -1, 1144, 
         1145,   -1,   -1, 1148,   -1,  125,  306,   -1,  308,  309, 
          310,  311,  312,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   38,   -1,   40,   -1,   42,   -1,  328,   -1, 
           46,   -1, 1198,   -1,   -1, 1201,   -1,   -1,   -1,   -1, 
           -1,   -1,  342,   59,   -1,   61,   -1,   -1,  348,   -1, 
           -1,   -1,  352, 1198, 1220,   -1, 1201,  357,  358,  359, 
           -1,   -1,   -1,   -1,   -1, 1231,   -1,   -1,   -1,   -1, 
           -1, 1302,   -1,   -1, 1305, 1220,   -1,   -1,   -1,   -1, 
           -1,   -1, 1313,   -1,   -1,   -1, 1231,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,  377,  378,  379,  380, 
          381,   10,   -1,  384,  385,  386,  387,  388,  389,  390, 
          391,   -1,  393,   -1,   -1,  396,  397,  398,  399,  400, 
          401,  402,  403,  404,   -1,   -1,   -1,   -1,   -1,   -1, 
           10, 1297,   41,  414,   -1,   44,  417,   10,   -1, 1370, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           59,  271, 1297,   -1,   -1,    0,   -1,   -1,   -1,  279, 
           -1,   41,   -1,   -1,   44,   10,   46,   -1,   41,   -1, 
           -1,   44, 1338,   46,  294,  295,  296,  297,  298,   -1, 
           -1,   61,   -1,   -1,   93,   -1,   -1,   -1,   61,   -1, 
           -1,   -1,   -1, 1338,  475,   -1,   41,   -1,   -1,   -1, 
           -1,   -1,  322,   -1,  324,  486,  279,  488,   -1,  490, 
           -1,   91,   -1,  494,   59,   -1,  125,  498,   91,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,  351,   -1,   -1,   10,  516,   -1,  518,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  529,   -1, 
          370,  306,  533,  308,  309,  310,  311,  312,   -1,   -1, 
           -1,   37,   38,  544,   -1,   41,   42,   43,   44,   45, 
           46,   47,   -1,  328,  347,  348,   -1,   -1,   -1,   -1, 
          125,   -1,   58,   59,   60,   61,   62,   63,   -1,   -1, 
          306,   -1,  308,  309,  310,  311,  312,  352,   -1,   -1, 
           -1,   -1,  357,  358,  359,   -1,   -1,   -1,   -1,  590, 
           40,   -1,  328,   -1,   44,   91,   46,   93,   94,  600, 
           -1,   -1,  603,   -1,   -1,   -1,  342,   -1,  609,   -1, 
           -1,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1, 
           -1,  357,  358,  359,   -1,   -1,   -1,  123,  124,  125, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   91,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          279,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  291,  292,   -1,  294,  295,  296,  297,  298, 
          671,   -1,   -1,  123,  675,  676,  677,   -1,   -1,  279, 
           -1,   -1,   -1,   -1,    0,   -1,  279,   -1,   -1,   -1, 
           -1,   -1,   -1,  322,   10,  324,   -1,  262,  263,  264, 
          701,   -1,  267,  268,  269,   -1,  271,  708,  709,  710, 
           -1,   -1,   -1,   -1,  279,   -1,  281,   -1,   -1,   -1, 
          721,   -1,  723,  724,  725,   41,  727,  356,   44,  294, 
          295,  296,  297,  298,   -1,   -1,   -1,   -1,  739,   -1, 
           -1,  370,   58,   59,   -1,   -1,   -1,  347,  348,   -1, 
           -1,   -1, 1023, 1024,  347,  348,   -1,  322,   -1,  324, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   93,   -1,   -1, 
          781,   -1,   -1,  279,  280,  281,  282,  283,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  291,  292,   -1,  294,  295, 
          296,  297,  298,   -1,   -1,  370,   -1,   -1,   -1,  125, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 1090, 
         1091,   -1,   -1, 1094,   -1,  826,  322,   -1,  324,  279, 
          280,   10,  328,  329,  330,  331,  332,  333,  334,  335, 
          336,  337,  338,  339,  340,   -1,   -1,  848,    0,  345, 
          346,  347,  348,   -1,   -1,  351,   -1, 1128,   10,   -1, 
          356,   -1,   41,   -1,   -1,   44,   -1,   46,   -1,   -1, 
           -1,   -1,  873,   -1,  370,   -1,   -1,  373, 1149,   -1, 
           -1,   33,   61,   -1,   -1,   37,   38,   -1,   40,   41, 
           42,   43,   44,   45,   46,   47, 1167,  347,  348,   -1, 
         1171,   -1,   -1,   -1,   -1,   -1,   58,   59,   60,   61, 
           62,   63,   91, 1184, 1185, 1186, 1187,   -1,   -1,   -1, 
         1191, 1192,   -1, 1194,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  932,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
          941,   93,   94,  944,  945,   -1,  262,  263,  264,  950, 
          951,  267,  268,  269,   -1,  271,  957,   -1,   -1,   -1, 
           -1,   -1,  963,  279,   -1,  281,  282,  283,  969,   -1, 
           -1,  123,  124,  125,  126,  291,  292,   -1,  294,  295, 
          296,  297,  983,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  993,  994,  995,   -1,  997,  998,  999,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  322,   -1,  324,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   37,   38,   -1, 1020, 
         1021,   42,   43,   -1,   45,   -1,   47,   -1,   -1,   -1, 
           -1, 1302, 1033,   -1, 1305,  351,   -1, 1038,   -1,   60, 
          356,   62, 1313,   41, 1045, 1046,   44,   38,   46,   -1, 
           -1,   42,   -1,   -1,  370,   -1,   -1,  373,   -1,   -1, 
         1061,   -1,   -1,   61,   -1,   -1, 1067,   -1,   -1,   -1, 
           -1,   -1,   -1,   94,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1, 1370, 
          279,   -1,   -1,  124,   -1,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,  279,  280,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,  298,   38,  300, 1150, 
           -1,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  347,  348, 
          322,  323,  324,   -1,  326,  327,  328,  329,  330,  331, 
          332,  333,  334,  335,  336,  337,  338,  339,  340,  341, 
          342,   -1,   -1,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,  363,  364,  365,  366,    0,  368,  369,  370,   -1, 
           -1,  373,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   33,   -1, 
           -1,   -1,   37,   38,   -1,   40,   41,   42,   43,   44, 
           45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   60,   61,   62,   63,   -1, 
           -1,  279,   -1,   -1,   -1,   -1,   -1, 1288,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,  328,   93,   94, 
           -1,   -1,  333,  334,   -1,  306,   -1,  308,  309,  310, 
          311,  312,   -1, 1273,  345,  346,   -1,   -1, 1278,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,  328,  123,  124, 
          125,  126,   10,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,  342,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  352,   -1,   -1,   -1,   33,  357,  358,  359,   37, 
           38,   -1,   40,   41,   42,   43,   44,   45,   46,   47, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           58,   59,   60,   61,   62,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1, 1354, 1355, 1356, 1357,   -1,   -1, 
           -1, 1361,   -1,   -1,   -1,  306,   -1,  308,  309,  310, 
          311,  312,   -1,   91,   -1,   93,   94,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  328, 1388, 1389, 
         1390, 1391,   -1,   -1,   -1,   -1,   -1, 1397,   -1,   -1, 
           -1,  342,   -1,   -1,   -1,  123,  124,  125,  126,   -1, 
           -1,  352,   -1,   -1,   -1,   -1,   -1,  358,  359,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,  279,  280,  281,  282,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,  298,   38,  300,   -1,   -1,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,   -1,   -1,  322,  323,  324, 
           -1,  326,  327,  328,  329,  330,  331,  332,  333,  334, 
          335,  336,  337,  338,  339,  340,  341,  342,   -1,   -1, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,  363,  364, 
          365,  366,   -1,  368,  369,  370,   -1,   -1,  373,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,  279,  280,  281,  282,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
          298,   -1,  300,   -1,   -1,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,   -1,   -1,  322,  323,  324,   -1,  326,  327, 
          328,  329,  330,  331,  332,  333,  334,  335,  336,  337, 
          338,  339,  340,  341,  342,   -1,   -1,  345,  346,  347, 
          348,  349,   -1,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,  363,  364,  365,  366,    0, 
          368,  369,  370,   -1,   -1,  373,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   33,   -1,   -1,   -1,   37,   38,   -1,   40, 
           41,   42,   43,   44,   45,   46,   47,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   60, 
           61,   62,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  306,   -1,  308,  309,  310,  311,  312,   -1, 
           91,   -1,   93,   94,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,  123,  124,  125,  126,   10,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,  358,  359,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   33, 
           -1,   -1,   -1,   37,   38,   -1,   40,   41,   42,   43, 
           44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1, 
          287,  288,  289,  290,   58,   59,   60,   61,   62,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,  303,  304,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  313,  314,  315,  316, 
          317,   -1,   -1,   -1,   -1,   -1,  323,   91,   -1,   93, 
           94,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  123, 
          124,  125,  126,  360,  361,  362,  363,  364,  365,  366, 
           -1,  368,  369,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,  279,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,  298,   -1,  300, 
           -1,   -1,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,   -1, 
           -1,  322,  323,  324,   -1,  326,  327,  328,  329,  330, 
          331,  332,  333,  334,  335,  336,  337,  338,  339,  340, 
          341,  342,   -1,   -1,  345,  346,  347,  348,  349,   -1, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,  363,  364,  365,  366,   -1,  368,  369,  370, 
           -1,   -1,  373,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,  279,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,  298,   -1,  300,   -1,   -1,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,   -1,   -1,  322,  323, 
          324,   -1,  326,  327,  328,  329,  330,  331,  332,  333, 
          334,  335,  336,  337,  338,  339,  340,  341,  342,   -1, 
           -1,  345,  346,  347,  348,  349,   -1,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,  363, 
          364,  365,  366,    0,  368,  369,  370,   -1,   -1,  373, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   33,   -1,   -1,   -1, 
           37,   38,   -1,   40,   41,   42,   43,   44,   45,   46, 
           47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   60,   -1,   62,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   93,   94,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,  123,  124,  125,  126, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   33,   -1,   -1,   -1,   37,   38,   -1, 
           40,   41,   42,   43,   44,   45,   46,   47,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
           60,   -1,   62,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   93,   94,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  123,  124,  125,  126,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,  279,  280,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,  298,   -1,  300,   -1,   -1,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,   -1,   -1,  322,  323,  324,   -1,  326, 
          327,  328,  329,  330,  331,  332,  333,  334,  335,  336, 
          337,  338,  339,  340,  341,  342,   -1,   -1,  345,  346, 
          347,  348,  349,   -1,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,  363,  364,  365,  366, 
           -1,  368,  369,  370,   -1,   -1,  373,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,  279, 
          280,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,  298,   -1, 
          300,   -1,   -1,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
           -1,   -1,  322,  323,  324,   -1,  326,  327,  328,  329, 
          330,  331,  332,  333,  334,  335,  336,  337,  338,  339, 
          340,  341,  342,   -1,   -1,  345,  346,  347,  348,  349, 
           -1,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,  363,  364,  365,  366,    0,  368,  369, 
          370,   -1,   -1,  373,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           33,   -1,   -1,   -1,   37,   38,   -1,   40,   41,   42, 
           43,   44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   60,   -1,   62, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           93,   94,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
          123,  124,  125,  126,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   37,   38,   -1,   -1, 
           41,   42,   43,   44,   45,   46,   47,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   60, 
           61,   62,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   93,   94,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   38,   -1,   40,   -1,   42,   -1,   -1,   -1,   46, 
           -1,   -1,   -1,  124,  125,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   61,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,  267,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,  279,  280,  281,  282, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,  298,   -1,  300,   -1,   -1, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,   -1,   -1,  322, 
          323,  324,   -1,  326,  327,  328,  329,  330,  331,  332, 
          333,  334,  335,  336,  337,  338,  339,  340,  341,  342, 
           -1,   -1,  345,  346,  347,  348,  349,   -1,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
          363,  364,  365,  366,   -1,  368,  369,  370,   -1,   -1, 
          373,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  279,   -1, 
          281,  282,  283,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          291,  292,   -1,  294,  295,  296,  297,  298,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,  322,   -1,  324,   -1,   10,   -1,  328,  329,  330, 
          331,  332,  333,  334,  335,  336,  337,  338,  339,  340, 
           -1,   -1,   -1,   -1,  345,  346,  347,  348,   -1,  350, 
          351,   -1,   37,   38,   -1,  356,   41,   42,   43,   44, 
           45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,  370, 
           -1,   -1,  373,   58,   59,   60,   61,   62,   63,  306, 
           -1,  308,  309,  310,  311,  312,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,   91,   -1,   93,   94, 
            0,   -1,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1, 
           10,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1, 
          357,  358,  359,   -1,   -1,   -1,   -1,   -1,   -1,  124, 
          125,   -1,   -1,   -1,   -1,   -1,   -1,   37,   38,   -1, 
           -1,   41,   42,   43,   44,   45,   46,   47,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
           60,   61,   62,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   93,   94,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  124,  125,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   37,   38,   -1,   -1,   41, 
           42,   43,   44,   45,   46,   47,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   60,   61, 
           62,   63,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  279,   -1,  281,  282,  283,   91, 
           -1,   93,   94,   -1,   -1,   -1,  291,  292,   -1,  294, 
          295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  124,  125,   -1,   -1,   -1,  322,   -1,  324, 
           -1,   -1,   -1,  328,  329,  330,  331,  332,  333,  334, 
          335,  336,  337,  338,  339,  340,   -1,   -1,   -1,   -1, 
          345,  346,  347,  348,   -1,  350,  351,   -1,   -1,   -1, 
           -1,  356,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,  370,   -1,   -1,  373,  279, 
           -1,  281,  282,  283,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  291,  292,   -1,  294,  295,  296,  297,  298,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,  322,   -1,  324,   -1,   -1,   10,  328,  329, 
          330,  331,  332,  333,  334,  335,  336,  337,  338,  339, 
          340,   -1,   -1,   -1,   -1,  345,  346,  347,  348,   -1, 
          350,  351,   -1,   -1,   -1,   -1,  356,   -1,   41,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
          370,   -1,   -1,  373,   -1,   -1,   59,  279,   -1,  281, 
          282,  283,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  291, 
          292,   -1,  294,  295,  296,  297,  298,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           93,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
          322,   -1,  324,   -1,   10,   -1,  328,  329,  330,  331, 
          332,  333,  334,  335,  336,  337,  338,  339,  340,   -1, 
           -1,   -1,  125,  345,  346,  347,  348,   -1,  350,  351, 
           -1,   37,   38,   -1,  356,   41,   42,   43,   44,   45, 
           46,   47,   -1,   -1,   -1,   -1,   -1,   -1,  370,   -1, 
           -1,  373,   58,   59,   60,   61,   62,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   93,   94,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  124,  125, 
           -1,   -1,   -1,   -1,   -1,   -1,   37,   38,   -1,   -1, 
           41,   42,   43,   44,   45,   46,   47,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   60, 
           61,   62,   63,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  279,   -1,  281,  282, 
           91,   -1,   93,   94,   -1,   -1,   -1,    0,  291,  292, 
           -1,  294,  295,  296,  297,  298,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  124,  125,   -1,   -1,   -1,   -1,  322, 
           -1,  324,   -1,   -1,   37,   38,   -1,   -1,   41,   42, 
           43,   44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   60,   61,   62, 
           63,   -1,   -1,  356,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,  370,   -1,   -1, 
           -1,   -1,   -1,  279,   -1,  281,  282,  283,   91,   -1, 
           93,   94,   -1,   -1,   -1,  291,  292,   -1,  294,  295, 
          296,  297,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  124,  125,   -1,   -1,   -1,  322,   -1,  324,   -1, 
           -1,   -1,  328,  329,  330,  331,  332,  333,  334,  335, 
          336,  337,  338,  339,  340,   -1,   -1,   -1,   -1,  345, 
          346,  347,  348,   -1,  350,  351,   -1,   -1,   -1,   -1, 
          356,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,  370,   -1,   -1,  373,  279,   -1, 
          281,  282,  283,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          291,  292,   -1,  294,  295,  296,  297,  298,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,  322,   -1,  324,   -1,   -1,   10,  328,  329,  330, 
          331,  332,  333,  334,  335,  336,  337,  338,  339,  340, 
           -1,   -1,   -1,   -1,  345,  346,  347,  348,   -1,  350, 
          351,   -1,   -1,   -1,   -1,  356,   -1,   41,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,  370, 
           -1,   -1,  373,   -1,   -1,   59,  279,   -1,  281,  282, 
          283,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  291,  292, 
           -1,  294,  295,  296,  297,  298,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   93, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,  322, 
           -1,  324,   -1,   10,   -1,  328,  329,  330,  331,  332, 
          333,  334,  335,  336,  337,  338,  339,  340,   -1,   -1, 
           -1,  125,  345,  346,  347,  348,   -1,  350,  351,   -1, 
           37,   38,   -1,  356,   41,   42,   43,   44,   45,   46, 
           47,   -1,   -1,   -1,   -1,   -1,   -1,  370,   -1,   -1, 
          373,   58,   59,   60,   61,   62,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   93,   94,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  124,  125,   -1, 
           -1,   -1,   -1,   -1,   -1,   37,   38,   -1,   -1,   41, 
           42,   43,   44,   45,   46,   47,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   60,   61, 
           62,   63,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  279,   -1,  281,  282,   91, 
           -1,   93,   94,   -1,   -1,   -1,    0,  291,  292,   -1, 
          294,  295,  296,  297,  298,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  124,  125,   -1,   -1,   -1,   -1,  322,   -1, 
          324,   -1,   -1,   37,   38,   -1,   -1,   41,   42,   43, 
           44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   60,   61,   62,   63, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,  370,   -1,   -1,   -1, 
           -1,   -1,  279,   -1,  281,  282,  283,   91,   -1,   93, 
           94,   -1,   -1,   -1,  291,  292,   -1,  294,  295,  296, 
          297,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          124,  125,   -1,   -1,   -1,  322,   -1,  324,   -1,   -1, 
           -1,  328,  329,  330,  331,  332,  333,  334,  335,  336, 
          337,  338,  339,  340,   -1,   -1,   -1,   -1,  345,  346, 
          347,  348,   -1,  350,  351,   -1,   -1,   -1,   -1,  356, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,  370,   -1,   -1,  373,  279,   -1,  281, 
          282,  283,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  291, 
          292,   -1,  294,  295,  296,  297,  298,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
          322,   -1,  324,   -1,   -1,   10,  328,  329,  330,  331, 
          332,  333,  334,  335,  336,  337,  338,  339,  340,   -1, 
           -1,   -1,   -1,  345,  346,  347,  348,   -1,  350,  351, 
           -1,   -1,   -1,   -1,  356,   -1,   41,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,  370,   -1, 
           -1,  373,   -1,   -1,   59,  279,   -1,  281,  282,  283, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  291,  292,   -1, 
          294,  295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   93,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,  322,   -1, 
          324,   -1,   10,   -1,  328,  329,  330,  331,  332,  333, 
          334,  335,  336,  337,  338,  339,  340,   -1,   -1,   -1, 
          125,  345,  346,  347,  348,   -1,  350,  351,   -1,   37, 
           38,   -1,  356,   41,   42,   43,   44,   45,   46,   47, 
           -1,   -1,   -1,   -1,   -1,   -1,  370,   -1,   -1,  373, 
           58,   59,   60,   -1,   62,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   93,   94,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  123,  124,  125,   -1,   -1, 
           -1,   -1,   -1,   -1,   37,   38,   -1,   40,   41,   42, 
           43,   44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   60,   61,   62, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268, 
      };
   }

   private static final int[] yyCheck2() {
      return new int[] {

          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          279,   -1,  281,  282,   91,   -1,   93,   94,   -1,   -1, 
           -1,    0,  291,  292,   -1,  294,  295,  296,  297,  298, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  124,  125,   -1, 
           -1,   -1,   -1,  322,   -1,  324,   -1,   -1,   37,   38, 
           -1,   -1,   41,   42,   43,   44,   45,   46,   47,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   60,   -1,   62,   63,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,  370,   -1,   -1,   -1,   -1,   -1,  279,  280,  281, 
          282,  283,   91,   -1,   93,   94,   -1,   -1,   -1,  291, 
          292,   -1,  294,  295,  296,  297,  298,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  123,  124,  125,   -1,   -1,   -1, 
          322,   -1,  324,   -1,   -1,   -1,  328,  329,  330,  331, 
          332,  333,  334,  335,  336,  337,  338,  339,  340,   -1, 
           -1,   -1,   -1,  345,  346,  347,  348,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,  356,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,  370,   -1, 
           -1,  373,  279,   -1,  281,  282,  283,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  291,  292,   -1,  294,  295,  296, 
          297,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,  322,   -1,  324,   -1,   -1, 
           10,  328,  329,  330,  331,  332,  333,  334,  335,  336, 
          337,  338,  339,  340,   -1,   -1,   -1,   -1,  345,  346, 
          347,  348,   -1,   -1,  351,   -1,   -1,   -1,   -1,  356, 
           -1,   41,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,  370,   -1,   -1,  373,   -1,   -1,   59, 
          279,  280,  281,  282,  283,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  291,  292,   -1,  294,  295,  296,  297,  298, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   93,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,  322,   -1,  324,   -1,   10,   -1,  328, 
          329,  330,  331,  332,  333,  334,  335,  336,  337,  338, 
          339,  340,   -1,   -1,   -1,  125,  345,  346,  347,  348, 
           -1,   -1,  351,   -1,   37,   38,   -1,  356,   41,   42, 
           43,   44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1, 
           -1,  370,   -1,   -1,  373,   58,   59,   60,   61,   62, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           93,   94,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  124,  125,   -1,   -1,   -1,   -1,   -1,   -1,   37, 
           38,   -1,   -1,   41,   42,   43,   44,   45,   46,   47, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           58,   59,   60,   61,   62,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  279, 
           -1,  281,  282,   91,   -1,   93,   94,   -1,   -1,   -1, 
            0,  291,  292,   -1,  294,  295,  296,  297,  298,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  124,  125,   -1,   -1, 
           -1,   -1,  322,   -1,  324,   -1,   -1,   37,   38,   -1, 
           -1,   41,   42,   43,   44,   45,   46,   47,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
           60,   -1,   62,   63,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
          370,   -1,   -1,   -1,   -1,   -1,  279,   -1,  281,  282, 
          283,   91,   -1,   93,   94,   -1,   -1,   -1,  291,  292, 
           -1,  294,  295,  296,  297,  298,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  124,  125,   -1,   -1,   -1,  322, 
           -1,  324,   -1,   -1,   -1,  328,  329,  330,  331,  332, 
          333,  334,  335,  336,  337,  338,  339,  340,   -1,   -1, 
           -1,   -1,  345,  346,  347,  348,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,  356,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,  370,   -1,   -1, 
          373,  279,   -1,  281,  282,  283,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  291,  292,   -1,  294,  295,  296,  297, 
          298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,  322,   -1,  324,   -1,   -1,   10, 
          328,  329,  330,  331,  332,  333,  334,  335,  336,  337, 
          338,  339,  340,   -1,   -1,   -1,   -1,  345,  346,  347, 
          348,   -1,   -1,  351,   -1,   -1,   -1,   -1,  356,   -1, 
           41,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,  370,   -1,   -1,  373,   -1,   -1,   59,  279, 
           -1,  281,  282,  283,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  291,  292,   -1,  294,  295,  296,  297,  298,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   93,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,  322,   -1,  324,   -1,   10,   -1,  328,  329, 
          330,  331,  332,  333,  334,  335,  336,  337,  338,  339, 
          340,   -1,   -1,   -1,  125,  345,  346,  347,  348,   -1, 
           -1,  351,   -1,   37,   38,   -1,  356,   41,   42,   43, 
           44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1, 
          370,   -1,   -1,  373,   58,   59,   60,   -1,   62,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   93, 
           94,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          124,  125,   -1,   -1,   -1,   -1,   -1,   -1,   37,   38, 
           -1,   -1,   41,   42,   43,   44,   45,   46,   47,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   60,   -1,   62,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  279,   -1, 
          281,   -1,   91,   -1,   93,   94,   -1,   -1,   -1,    0, 
          291,  292,   -1,  294,  295,  296,  297,  298,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  124,  125,   -1,   -1,   -1, 
           -1,  322,   -1,  324,   -1,   -1,   37,   38,   -1,   -1, 
           41,   42,   43,   44,   45,   46,   47,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   60, 
           -1,   62,   63,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,  370, 
           -1,   -1,   -1,   -1,   -1,  279,   -1,  281,  282,  283, 
           91,   -1,   93,   94,   -1,   -1,   -1,  291,  292,   -1, 
          294,  295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  124,  125,   -1,   -1,   -1,  322,   -1, 
          324,   -1,   -1,   -1,  328,  329,  330,  331,  332,  333, 
          334,  335,  336,  337,  338,  339,  340,   -1,   -1,   -1, 
           -1,  345,  346,  347,  348,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,  356,  262,  263,  264,   -1,    0,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,  370,   10,   -1,  373, 
          279,   -1,  281,  282,  283,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  291,  292,   -1,  294,  295,  296,  297,  298, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   41,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,  322,   -1,  324,   59,   10,   -1,  328, 
          329,  330,  331,  332,  333,  334,  335,  336,  337,  338, 
          339,  340,   -1,   -1,   -1,   -1,  345,  346,  347,  348, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,  356,   41,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,  370,   -1,   -1,  373,   -1,   59,   -1,  279,   -1, 
          281,  282,  283,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          291,  292,  125,  294,  295,  296,  297,  298,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           93,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,  322,   -1,  324,   -1,   10,   -1,  328,  329,  330, 
          331,  332,  333,  334,  335,  336,  337,  338,  339,  340, 
           -1,   -1,  125,   -1,  345,  346,  347,  348,   -1,   -1, 
          351,   -1,   37,   38,   -1,  356,   41,   42,   43,   44, 
           45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,  370, 
           -1,   -1,  373,   58,   59,   60,   -1,   62,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   93,   94, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,   -1,  268,  269,   -1,  271,  124, 
          125,   -1,   -1,   -1,   -1,   -1,  279,   37,   38,   -1, 
           -1,   41,   42,   43,   44,   45,   -1,   47,  291,  292, 
           -1,  294,  295,  296,  297,   -1,   -1,   -1,   58,   59, 
           60,   -1,   62,   63,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,  322, 
           -1,  324,   -1,   -1,   -1,   -1,  279,   -1,  281,   -1, 
           -1,   -1,   -1,   93,   94,   -1,    0,   -1,  291,  292, 
           -1,  294,  295,  296,  297,  298,   10,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  124,  125,   -1,  370,   -1,  322, 
           -1,  324,   -1,   37,   38,   -1,   -1,   41,   42,   43, 
           44,   45,   -1,   47,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   60,   -1,   62,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,  370,   -1,   -1, 
           -1,   -1,   -1,   -1,  279,   -1,  281,  282,  283,   93, 
           94,   -1,   -1,   -1,   -1,   -1,  291,  292,   -1,  294, 
          295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
          124,  125,   -1,   -1,   -1,   -1,   -1,  322,   10,  324, 
           -1,   -1,   -1,   -1,  329,  330,  331,  332,  333,  334, 
          335,  336,  337,  338,  339,  340,   -1,   -1,   -1,   -1, 
          345,  346,  347,  348,   -1,   -1,  351,   10,   -1,   41, 
           -1,  356,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,  370,   -1,   59,  373,  279, 
           -1,  281,  282,  283,   -1,   38,   -1,   40,   -1,   42, 
           -1,  291,  292,   46,  294,  295,  296,  297,  298,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1, 
           -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  322,   -1,  324,   -1,   -1,   -1,  328,  329, 
          330,  331,  332,  333,  334,  335,  336,  337,  338,  339, 
          340,   -1,   -1,  125,   -1,  345,  346,   -1,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,  356,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
          370,   -1,   -1,  373,   -1,  279,   -1,  281,  282,  283, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  291,  292,   -1, 
          294,  295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,  322,   -1, 
          324,   -1,   10,   -1,  328,  329,  330,  331,  332,  333, 
          334,  335,  336,  337,  338,  339,  340,   -1,   -1,   -1, 
           -1,  345,  346,   -1,   -1,   -1,   -1,  351,   -1,   37, 
           38,   -1,  356,   41,   42,   43,   44,   45,   -1,   47, 
           -1,   -1,   -1,   -1,   -1,   -1,  370,   -1,   -1,  373, 
           58,   59,   60,   -1,   62,   63,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  279,   -1,  281, 
           -1,   -1,   -1,   -1,   -1,   93,   94,    0,   -1,  291, 
          292,   -1,  294,  295,  296,  297,  298,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  124,  125,   -1,   -1, 
          322,   -1,  324,   -1,   37,   38,   -1,   -1,   41,   42, 
           43,   44,   45,  306,   47,  308,  309,  310,  311,  312, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   60,   -1,   62, 
           63,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  370,  342, 
           -1,   -1,   -1,   -1,   -1,  348,   -1,   -1,   -1,  352, 
           93,   94,   -1,    0,  357,  358,  359,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   37,   38,   -1,   -1,   -1,   42, 
           43,   -1,   45,   -1,   47,   -1,   -1,   -1,   -1,   -1, 
           -1,  124,  125,   -1,   -1,   -1,   -1,   60,   -1,   62, 
           37,   38,   -1,   -1,   41,   42,   43,   44,   45,   -1, 
           47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   60,   -1,   62,   63,   -1,   -1,   -1, 
           -1,   94,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  279,   -1,  281,  282,  283,   93,   94,   -1,   -1, 
           -1,  124,   -1,  291,  292,   -1,  294,  295,  296,  297, 
          298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,  124,  125,   -1, 
           -1,   -1,   -1,   -1,  322,   10,  324,   -1,   -1,   -1, 
           -1,  329,  330,  331,  332,  333,  334,  335,  336,  337, 
          338,  339,  340,   -1,   -1,   -1,   -1,  345,  346,   -1, 
           -1,   -1,   -1,  351,   10,   -1,   41,   -1,  356,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,  370,   -1,   59,  373,  279,   -1,  281,  282, 
          283,   -1,   38,   -1,   40,   -1,   42,   -1,  291,  292, 
           46,  294,  295,  296,  297,  298,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   61,   -1,   -1,   93,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  322, 
           -1,  324,   -1,   -1,   -1,   -1,  329,  330,  331,  332, 
          333,  334,  335,  336,  337,  338,  339,  340,   -1,   -1, 
          125,   -1,  345,  346,   -1,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,  356,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,  370,   -1,   -1, 
          373,   -1,  279,   -1,  281,  282,  283,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  291,  292,   -1,  294,  295,  296, 
          297,  298,   -1,   -1,   -1,  328,  329,  330,  331,  332, 
          333,  334,  335,  336,  337,  338,   -1,   -1,   -1,    0, 
           -1,   -1,  345,  346,   -1,  322,   -1,  324,   -1,   10, 
           -1,   -1,  329,  330,  331,  332,  333,  334,  335,  336, 
          337,  338,  339,  340,   -1,   -1,   -1,   -1,  345,  346, 
           -1,   -1,   -1,   -1,  351,   -1,   37,   38,   -1,  356, 
           41,   42,   43,   44,   45,   -1,   47,   -1,   -1,   -1, 
           -1,   -1,   -1,  370,   -1,   -1,  373,   58,   59,   60, 
           -1,   62,   63,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  279,   -1,  281,   -1,   -1,   -1, 
           -1,   -1,   93,   94,    0,   -1,  291,  292,   -1,  294, 
          295,  296,  297,  298,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  124,  125,   -1,   -1,  322,   -1,  324, 
           -1,   37,   38,   -1,   -1,   41,   42,   43,   44,   45, 
          306,   47,  308,  309,  310,  311,  312,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   60,   -1,   62,   63,   -1,   -1, 
           -1,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  370,  342,   -1,   -1,   -1, 
           -1,   -1,  348,   -1,   -1,   -1,  352,   93,   94,   -1, 
            0,  357,  358,  359,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   37,   38,   -1,   -1,   -1,   42,   43,   -1,   45, 
           -1,   47,   -1,   -1,   -1,   -1,   -1,   -1,  124,  125, 
           -1,   -1,   -1,   -1,   60,   -1,   62,   37,   38,   -1, 
           -1,   41,   42,   43,   44,   45,   -1,   47,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
           60,   -1,   62,   63,   -1,   -1,   -1,   -1,   94,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  279,   -1, 
          281,  282,  283,   93,   94,   -1,   -1,   -1,  124,   -1, 
          291,  292,   -1,  294,  295,  296,  297,  298,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,  124,  125,   -1,   -1,   -1,   -1, 
           -1,  322,   10,  324,   -1,   -1,   -1,   -1,  329,  330, 
          331,  332,  333,  334,  335,  336,  337,  338,  339,  340, 
           -1,   -1,   -1,   -1,  345,  346,   -1,   -1,   -1,   -1, 
          351,   10,   -1,   41,   -1,  356,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,  370, 
           -1,   59,  373,  279,   -1,  281,  282,  283,   -1,   38, 
           -1,   40,   -1,   42,   -1,  291,  292,   46,  294,  295, 
          296,  297,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,   -1,   61,   -1,   -1,   93,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  322,   -1,  324,   -1, 
           -1,   -1,   -1,  329,  330,  331,  332,  333,  334,  335, 
          336,  337,  338,  339,  340,   -1,   -1,  125,   -1,  345, 
          346,   -1,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
          356,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,  370,   -1,   -1,  373,   -1,  279, 
           -1,  281,  282,  283,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  291,  292,   -1,  294,  295,  296,  297,  298,   -1, 
           -1,   -1,  328,  329,  330,  331,  332,  333,  334,  335, 
           -1,  337,  338,   -1,   -1,   -1,    0,   -1,   -1,  345, 
          346,   -1,  322,   -1,  324,   -1,   10,   -1,   -1,  329, 
          330,  331,  332,  333,  334,  335,  336,  337,  338,  339, 
          340,   -1,   -1,   -1,   -1,  345,  346,   -1,   -1,   -1, 
           -1,  351,   -1,   37,   38,   -1,  356,   41,   42,   43, 
           44,   45,   -1,   47,   -1,   -1,   -1,   -1,   -1,   -1, 
          370,   -1,   -1,  373,   58,   59,   60,   -1,   62,   63, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  279,   -1,  281,   -1,   -1,   -1,   -1,   -1,   93, 
           94,    0,   -1,  291,  292,   -1,  294,  295,  296,  297, 
          298,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          124,  125,   -1,   -1,  322,   -1,  324,   -1,   37,   38, 
           -1,   -1,   41,   42,   43,   44,   45,  306,   47,  308, 
          309,  310,  311,  312,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   60,   -1,   62,   63,   -1,   -1,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  370,  342,   -1,   -1,   -1,   -1,   -1,  348, 
           -1,   -1,   -1,  352,   93,   94,   -1,    0,  357,  358, 
          359,   -1,   -1,   -1,   -1,   -1,   -1,   10,   37,   38, 
           -1,   -1,   -1,   42,   43,   -1,   45,   -1,   47,   -1, 
           -1,   -1,   -1,   -1,   -1,  124,  125,   -1,   -1,   -1, 
           -1,   60,   -1,   62,   37,   38,   -1,   -1,   41,   42, 
           43,   44,   45,   -1,   47,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   60,   -1,   62, 
           63,   -1,   -1,   -1,   -1,   94,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  279,   -1,  281,  282,  283, 
           93,   94,   -1,   -1,   -1,  124,   -1,  291,  292,   -1, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,  124,  125,   -1,   -1,   -1,   -1,   -1,  322,   10, 
          324,   -1,   -1,   -1,  328,  329,  330,  331,  332,  333, 
          334,  335,  336,  337,  338,  339,  340,   -1,   -1,   -1, 
           -1,  345,  346,   -1,   -1,   -1,   -1,  351,   -1,   -1, 
           41,    0,  356,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   10,  271,   -1,   -1,   -1,  370,   -1,   59,  373, 
          279,   -1,  281,  282,  283,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  291,  292,   -1,  294,  295,  296,  297,   -1, 
           -1,   -1,   41,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,   -1,   -1,  322,   -1,  324,   -1,   -1,   -1,  328, 
          329,  330,  331,  332,  333,  334,  335,  336,  337,  338, 
          339,  340,   -1,   -1,  125,   -1,  345,  346,   -1,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,  356,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,  370,   -1,   -1,  373,   -1,  279,   -1,  281,  282, 
          283,   -1,   -1,   -1,   -1,   -1,  125,   -1,  291,  292, 
           -1,  294,  295,  296,  297,   -1,   -1,   -1,   -1,  328, 
          329,  330,  331,  332,  333,  334,   -1,   -1,  337,  338, 
           -1,   -1,   -1,    0,   -1,   -1,  345,  346,   -1,  322, 
           -1,  324,   -1,   10,   -1,  328,  329,  330,  331,  332, 
          333,  334,  335,  336,  337,  338,  339,  340,   -1,   -1, 
           -1,   -1,  345,  346,   -1,   -1,   -1,   -1,  351,   -1, 
           37,   38,   -1,  356,   41,   42,   43,   44,   45,   -1, 
           47,   -1,   -1,   -1,   -1,   -1,   -1,  370,   -1,   -1, 
          373,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  279,   -1, 
          281,   -1,   -1,   -1,   -1,   -1,   93,   94,    0,   -1, 
          291,  292,   -1,  294,  295,  296,  297,  298,   10,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,  124,  125,   -1, 
          279,  322,   -1,  324,   -1,   -1,   38,   -1,   -1,   41, 
           -1,   43,   44,   45,   -1,  294,  295,  296,  297,  298, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   60,   -1, 
           62,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  322,   -1,  324,   -1,   -1,   -1,  370, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   93,   94,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  351,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  370,  124,  125,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   38,   -1,   -1,   41,   -1,   43,   44,   45, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   60,   -1,   62,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  279,   -1,  281,  282,  283,   93,   94,   -1, 
           -1,   -1,   -1,   -1,  291,  292,   -1,  294,  295,  296, 
          297,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  124,  125, 
           -1,   -1,   -1,   -1,   -1,  322,   -1,  324,   -1,   -1, 
           -1,  328,  329,  330,  331,  332,   -1,   -1,  335,  336, 
          337,  338,  339,  340,   -1,    0,   -1,   -1,  345,  346, 
           -1,   -1,   -1,   -1,  351,   10,   -1,   -1,   -1,  356, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,  370,   -1,   -1,  373,  279,   -1,  281, 
          282,  283,   -1,   -1,   -1,   -1,   41,   -1,   -1,  291, 
          292,   -1,  294,  295,  296,  297,  298,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          322,   -1,  324,   -1,   -1,   -1,   -1,  329,  330,  331, 
          332,  333,  334,  335,  336,  337,  338,  339,  340,   -1, 
           -1,   -1,   -1,  345,  346,   -1,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,  356,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,  370,   -1, 
          125,  373,   -1,  279,   -1,  281,  282,  283,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  291,  292,   -1,  294,  295, 
          296,  297,  298,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  322,   -1,  324,   -1, 
           -1,   -1,   -1,  329,  330,  331,  332,  333,  334,  335, 
          336,  337,  338,  339,  340,   38,   -1,   -1,   41,  345, 
          346,   44,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
          356,   -1,   -1,   -1,   -1,   58,   59,   60,   -1,   62, 
           63,   -1,   -1,   -1,  370,   -1,   -1,  373,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           93,   94,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,  124,  125,   -1,  279,   -1,   -1,   -1,   -1,   -1, 
           38,   -1,   -1,   41,   -1,   -1,   44,   -1,   -1,  294, 
          295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1,   -1, 
           58,   59,   60,   -1,   62,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  322,   -1,  324, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   93,   94,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  370,  124,  125,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   38,   -1,   -1,   41, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   60,   -1, 
           62,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  279,   -1,  281,  282, 
          283,   93,   94,   -1,   -1,   -1,   -1,   -1,  291,  292, 
           -1,  294,  295,  296,  297,  298,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  124,  125,   -1,   -1,   -1,   -1,   -1,  322, 
           -1,  324,   -1,   -1,   -1,   -1,  329,  330,  331,  332, 
          333,  334,  335,  336,  337,  338,  339,  340,   -1,   -1, 
           -1,   -1,  345,  346,   -1,   -1,   -1,   -1,  351,   -1, 
           10,   -1,   -1,  356,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,  370,   -1,   -1, 
          373,  279,   -1,  281,  282,  283,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  291,  292,   -1,  294,  295,  296,  297, 
          298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  322,   -1,  324,   -1,   -1,   -1, 
           -1,  329,  330,  331,  332,  333,  334,  335,  336,  337, 
          338,  339,  340,   -1,   94,   -1,   -1,  345,  346,   -1, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,  356,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,  370,   -1,   -1,  373,   -1,  279,   -1,  281, 
          282,  283,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  291, 
          292,   -1,  294,  295,  296,  297,  298,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          322,   -1,  324,   -1,   -1,   -1,   -1,  329,  330,  331, 
          332,  333,  334,  335,  336,  337,  338,  339,  340,   41, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,  356,   -1,   58,   59,   60,   -1, 
           62,   63,   -1,   -1,   -1,   -1,   -1,   -1,  370,   -1, 
           -1,  373,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   93,   94,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  124,  125,   -1,   41,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  287,  288,  289, 
          290,   -1,   58,   59,   60,   -1,   62,   63,   -1,   -1, 
           -1,   -1,   -1,  303,  304,  305,  306,   -1,   -1,   -1, 
          310,   -1,   -1,  313,  314,  315,  316,  317,   -1,   -1, 
           -1,   -1,   -1,  323,   -1,   -1,   -1,   93,   94,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,  341,  342,   -1,   -1,   -1,   -1,   -1,   -1,  349, 
           -1,   -1,  352,   -1,  354,  355,   -1,  357,  124,  125, 
          360,  361,  362,  363,  364,  365,  366,   -1,  368,  369, 
           41,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   60, 
           -1,   62,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   93,   -1,   -1,   -1,   -1,  279,   -1,  281, 
          282,  283,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  291, 
          292,   -1,  294,  295,  296,  297,  298,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,  125,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          322,   -1,  324,   -1,   -1,   -1,   -1,  329,  330,  331, 
          332,  333,  334,  335,  336,  337,  338,  339,  340,   -1, 
           -1,   -1,   41,   -1,   -1,   44,  262,  263,  264,  351, 
           -1,  267,  268,  269,  356,  271,   -1,   -1,   -1,   58, 
           59,   -1,   -1,  279,   63,  281,  282,  283,  370,   -1, 
           -1,  373,   -1,   -1,   -1,  291,  292,   -1,  294,  295, 
          296,  297,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   93,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  322,   -1,  324,   -1, 
           -1,   -1,   -1,  329,  330,  331,  332,  333,  334,  335, 
          336,  337,  338,  339,  340,   -1,  125,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,  351,   -1,   -1,   10,   -1, 
          356,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,  370,   -1,   -1,  373,  279,   -1, 
          281,  282,  283,   -1,   -1,   -1,   -1,   -1,   -1,   41, 
          291,  292,   44,  294,  295,  296,  297,  298,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   60,   -1, 
           62,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  322,   -1,  324,   -1,   -1,   -1,   -1,  329,  330, 
          331,  332,  333,  334,  335,  336,  337,  338,  339,  340, 
           -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,  356,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,  370, 
           -1,   -1,  373,  125,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          279,   -1,  281,  282,  283,   -1,   41,   -1,   -1,   44, 
           -1,   -1,  291,  292,   -1,  294,  295,  296,  297,  298, 
           -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  322,   -1,  324,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   93,   -1, 
          339,  340,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,  351,   -1,   -1,   10,   -1,  356,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          125,  370,   -1,   -1,  373,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   41,   -1,   -1,   44, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   58,   59,   -1,   -1,  279,   63,  281, 
          282,  283,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  291, 
          292,   -1,  294,  295,  296,  297,  298,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   93,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          322,   10,  324,   -1,   -1,   -1,   -1,  329,  330,  331, 
          332,  333,  334,  335,  336,  337,  338,  339,  340,   -1, 
          125,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  351, 
           -1,   -1,   41,   -1,  356,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  370,   58, 
           59,  373,   -1,   -1,   63,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  279,   -1,  281,  282,  283,   -1, 
           -1,   -1,   -1,   -1,   93,   -1,  291,  292,   -1,  294, 
          295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,  125,  322,   -1,  324, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          335,  336,   -1,   -1,  339,  340,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,  356,   -1,   41,   -1,   -1,   44,  262,  263,  264, 
           -1,   -1,  267,  268,  269,  370,  271,   -1,  373,   -1, 
           58,   59,   -1,   -1,  279,   63,  281,  282,  283,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  291,  292,   -1,  294, 
          295,  296,  297,  298,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   93,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  322,   -1,  324, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          335,  336,   -1,   -1,  339,  340,   -1,  125,   -1,   41, 
           -1,   -1,   44,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,  356,   -1,  262,  263,  264,   58,   59,  267,  268, 
          269,   63,  271,   -1,   -1,  370,   -1,   -1,  373,   -1, 
          279,   -1,  281,  282,  283,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  291,  292,   -1,  294,  295,  296,  297,  298, 
           -1,   93,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,  322,   -1,  324,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  125,   -1,   -1,  335,  336,   -1,   -1, 
          339,  340,   -1,   -1,   41,   -1,   38,   44,   40,   -1, 
           42,   -1,  351,   -1,   46,   -1,   -1,  356,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,   59,   -1,   61, 
           -1,  370,   -1,   -1,  373,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   93,   -1,   -1,   -1, 
           -1,  279,   -1,  281,  282,  283,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  291,  292,   -1,  294,  295,  296,  297, 
          298,   -1,   -1,   -1,   -1,    0,   -1,   -1,  125,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  322,   -1,  324,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1, 
           -1,  339,  340,   -1,   -1,   -1,   41,   -1,   -1,   44, 
          262,  263,  264,  351,   -1,  267,  268,  269,  356,  271, 
           -1,   -1,   -1,   58,   59,   -1,   -1,  279,   63,  281, 
          282,  283,  370,   -1,   -1,  373,   -1,   -1,   -1,  291, 
          292,   -1,  294,  295,  296,  297,  298,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   93,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          322,   -1,  324,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  335,  336,   -1,   -1,  339,  340,   -1, 
          125,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,  351, 
           -1,   -1,   10,   -1,  356,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,  370,   -1, 
           -1,  373,  279,   -1,  281,  282,  283,   -1,   -1,   -1, 
           -1,   -1,   -1,   41,  291,  292,   44,  294,  295,  296, 
          297,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           58,   59,   -1,   -1,  306,   63,  308,  309,  310,  311, 
          312,   -1,   -1,   -1,   -1,  322,   -1,  324,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,  336, 
           -1,   -1,  339,  340,   -1,   93,   -1,   -1,   -1,   -1, 
          342,   -1,   -1,   -1,  351,   -1,  348,   -1,   -1,  356, 
          352,   -1,   -1,   -1,   -1,  357,  358,  359,    0,   -1, 
           -1,   -1,   -1,  370,   -1,   -1,  373,  125,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  279,   -1,  281,  282,  283,   41, 
           -1,   -1,   44,   -1,   -1,    0,  291,  292,   -1,  294, 
          295,  296,  297,  298,   -1,   10,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  322,   -1,  324, 
           -1,   -1,   -1,   -1,   -1,   -1,   41,   -1,   -1,   44, 
           -1,   93,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   58,   59,   -1,  351,   -1,   63,   -1, 
           -1,  356,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  125,   -1,  370,   -1,   -1,  373,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   93,   -1, 
           -1,   10,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  279,   -1,  281,  282,  283,   -1,   -1,   -1,   -1, 
          125,   -1,   41,  291,  292,   44,  294,  295,  296,  297, 
          298,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  322,   -1,  324,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   41,   -1,   93,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,  356,   58, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  370,   -1,   -1,  373,  125,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   93,   -1,   -1,  279,   -1,  281, 
          282,  283,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  291, 
          292,   -1,  294,  295,  296,  297,  298,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  125,  262,  263,  264, 
           -1,   -1,  267,  268,  269,    0,  271,   -1,   -1,   -1, 
          322,   -1,  324,   -1,  279,   10,  281,  282,  283,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  291,  292,   -1,  294, 
          295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,  356,   -1,   41,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  322,  370,  324, 
           -1,  373,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,  351,   -1,  267,  268, 
          269,  356,  271,   -1,   -1,   -1,   -1,   -1,   93,   -1, 
          279,   -1,  281,  282,  283,  370,   -1,   -1,  373,   -1, 
           -1,   -1,  291,  292,   -1,  294,  295,  296,  297,  298, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          125,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,    0,  271,  322,   -1,  324,   -1,   -1,   -1,   -1, 
          279,   10,  281,  282,  283,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  291,  292,   -1,  294,  295,  296,  297,  298, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,  356,   -1,   -1, 
           -1,   -1,   41,   -1,   -1,   44,   -1,   -1,    0,   -1, 
           -1,  370,   -1,  322,  373,  324,   -1,   -1,   10,   58, 
           59,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,  356,   -1,   41, 
           -1,   38,   44,   40,   93,   42,   -1,   -1,   -1,   46, 
           -1,  370,   -1,   -1,  373,   -1,   58,   59,   -1,   -1, 
           -1,   -1,   59,   -1,   61,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  125,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   93,   -1,   -1,  279,   -1,  281,  282,  283,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  291,  292,   -1,  294, 
          295,  296,  297,  298,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  125,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  322,   -1,  324, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   33,   -1, 
           -1,   -1,   37,   38,   -1,   -1,   41,   42,   43,   44, 
           45,   46,   47,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,  356,   -1,   -1,   59,   60,   -1,   62,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,  370,   -1,   -1,  373,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   93,   94, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          279,   -1,  281,  282,  283,   -1,   -1,   -1,  123,  124, 
          125,  126,  291,  292,   -1,  294,  295,  296,  297,  298, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,  322,   -1,  324,   -1,  279,   -1,  281, 
          282,  283,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  291, 
          292,   -1,  294,  295,  296,  297,  298,   -1,   -1,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,  356,   -1,  306, 
           -1,  308,  309,  310,  311,  312,   -1,   -1,   -1,   -1, 
          322,  370,  324,   -1,  373,   -1,   -1,   -1,   -1,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  342,   -1,   -1,   -1,  351, 
           -1,  348,   -1,   -1,  356,  352,   -1,   -1,   -1,   -1, 
          357,  358,  359,   -1,   -1,   -1,   -1,   -1,  370,   -1, 
           -1,  373,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,  279,  280,  281,  282,   -1,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,  298,   -1,  300,   -1,   -1,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,   -1,   -1,  322,  323,  324, 
           -1,  326,  327,  328,  329,  330,  331,  332,  333,  334, 
          335,  336,  337,  338,  339,  340,  341,  342,   -1,   -1, 
          345,  346,  347,  348,  349,   -1,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,  363,  364, 
          365,  366,    0,  368,  369,  370,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   33,   -1,   -1,   -1,   37, 
           38,   -1,   -1,   41,   42,   43,   44,   45,   46,   47, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,   60,   -1,   62,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   93,   94,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,  123,  124,  125,  126,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   33,   -1,   -1,   -1,   37,   38,   -1,   40, 
           41,   42,   43,   44,   45,   46,   47,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   60, 
           61,   62,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   93,   94,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  124,  125,  126,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,  279,  280,  281,  282,   -1,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
          298,   -1,  300,   -1,   -1,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,   -1,   -1,  322,  323,  324,   -1,  326,  327, 
          328,  329,  330,  331,  332,  333,  334,  335,  336,  337, 
          338,  339,  340,  341,  342,   -1,   -1,  345,  346,  347, 
          348,  349,   -1,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,  363,  364,  365,  366,   -1, 
          368,  369,  370,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,  279,   -1, 
          281,  282,   -1,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,  298,   -1,  300, 
           -1,   -1,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,   -1, 
           -1,  322,  323,  324,   -1,  326,  327,  328,  329,  330, 
          331,  332,  333,  334,  335,  336,  337,  338,  339,  340, 
          341,  342,   -1,   -1,  345,  346,  347,  348,  349,   -1, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,  363,  364,  365,  366,    0,  368,  369,  370, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   33, 
           -1,   -1,   -1,   37,   38,   -1,   40,   41,   42,   43, 
           44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   60,   61,   62,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           94,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,  123, 
          124,  125,  126,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   33,   -1,   -1,   -1, 
           37,   38,   -1,   40,   41,   42,   43,   44,   45,   46, 
           47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   60,   61,   62,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,   94,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  123,  124,  125,  126, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,   -1,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,  279,  280,   -1,   -1,   -1, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,  298,   -1,  300,   -1,   -1,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,   -1,   -1,  322,  323, 
          324,   -1,  326,  327,  328,  329,  330,  331,  332,  333, 
          334,  335,  336,  337,  338,  339,  340,  341,  342,   -1, 
           -1,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,   -1,  357,  358,  359,  360,  361,  362,  363, 
          364,  365,  366,   -1,  368,  369,  370,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
           -1,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,  279,  280,   -1,   -1,   -1,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,  298,   -1,  300,   -1,   -1,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,   -1,   -1,  322,  323,  324,   -1,  326, 
          327,  328,  329,  330,  331,  332,  333,  334,  335,  336, 
          337,  338,  339,  340,  341,  342,   -1,   -1,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,   -1, 
          357,  358,  359,  360,  361,  362,  363,  364,  365,  366, 
            0,  368,  369,  370,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   33,   -1,   -1,   -1,   37,   38,   -1, 
           -1,   41,   42,   43,   44,   45,   46,   47,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           60,   -1,   62,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   93,   94,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,  124,  125,  126,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           33,   -1,   -1,   -1,   37,   38,   -1,   40,   41,   42, 
           43,   44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   60,   61,   62, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   94,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          123,  124,  125,  126,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,  279, 
           -1,  281,  282,   -1,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,  298,   -1, 
          300,   -1,   -1,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
           -1,   -1,  322,  323,  324,   -1,  326,  327,  328,  329, 
          330,  331,  332,  333,  334,  335,  336,  337,  338,  339, 
          340,  341,  342,   -1,   -1,  345,  346,  347,  348,  349, 
           -1,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,  363,  364,  365,  366,   -1,  368,  369, 
          370,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,  279,  280,   -1,   -1, 
           -1,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,  298,   -1,  300,   -1,   -1, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,   -1,   -1,  322, 
          323,  324,   -1,  326,  327,  328,  329,  330,  331,  332, 
          333,  334,  335,  336,  337,  338,  339,  340,  341,  342, 
           -1,   -1,  345,  346,  347,  348,  349,   -1,  351,  352, 
          353,  354,  355,   -1,  357,  358,  359,  360,  361,  362, 
          363,  364,  365,  366,    0,  368,  369,  370,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   33,   -1,   -1, 
           -1,   37,   38,   -1,   40,   41,   42,   43,   44,   45, 
           46,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   60,   61,   62,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1, 
      };
   }

   private static final int[] yyCheck3() {
      return new int[] {

           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   94,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,  123,  124,  125,  126,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   33, 
           -1,   -1,   -1,   37,   38,   -1,   40,   41,   42,   43, 
           44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   60,   61,   62,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           94,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  123, 
          124,  125,  126,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,   -1,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,  279,  280, 
           -1,   -1,   -1,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,  298,   -1,  300, 
           -1,   -1,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,   -1, 
           -1,  322,  323,  324,   -1,  326,  327,  328,  329,  330, 
          331,  332,  333,  334,  335,  336,  337,  338,  339,  340, 
          341,  342,   -1,   -1,  345,  346,  347,  348,  349,   -1, 
          351,  352,  353,  354,  355,   -1,  357,  358,  359,  360, 
          361,  362,  363,  364,  365,  366,   -1,  368,  369,  370, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,   -1,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,  279,  280,   -1,   -1,   -1, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,  298,   -1,  300,   -1,   -1,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,   -1,   -1,  322,  323, 
          324,   -1,  326,  327,  328,  329,  330,  331,  332,  333, 
          334,  335,  336,  337,  338,  339,  340,  341,  342,   -1, 
           -1,  345,  346,  347,  348,  349,   -1,  351,  352,  353, 
          354,  355,   -1,  357,  358,  359,  360,  361,  362,  363, 
          364,  365,  366,    0,  368,  369,  370,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   33,   -1,   -1,   -1, 
           37,   38,   -1,   40,   41,   42,   43,   44,   45,   46, 
           47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   60,   61,   62,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,   94,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,  123,  124,  125,  126, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   33,   -1,   -1,   -1,   37,   38,   -1, 
           40,   41,   42,   43,   44,   45,   46,   47,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           60,   61,   62,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,   94,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  123,  124,  125,  126,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
           -1,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,  279,  280,   -1,   -1,   -1,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,  298,   -1,  300,   -1,   -1,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,   -1,   -1,  322,  323,  324,   -1,  326, 
          327,  328,  329,  330,  331,  332,  333,  334,  335,  336, 
          337,  338,  339,  340,  341,  342,   -1,   -1,  345,  346, 
          347,  348,  349,   -1,  351,  352,  353,  354,  355,   -1, 
          357,  358,  359,  360,  361,  362,  363,  364,  365,  366, 
           -1,  368,  369,  370,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,   -1,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,  279, 
          280,   -1,   -1,   -1,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,  298,   -1, 
          300,   -1,   -1,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
           -1,   -1,  322,  323,  324,   -1,  326,  327,  328,  329, 
          330,  331,  332,  333,  334,  335,  336,  337,  338,  339, 
          340,  341,  342,   -1,   -1,  345,  346,  347,  348,  349, 
           -1,  351,  352,  353,  354,  355,   -1,  357,  358,  359, 
          360,  361,  362,  363,  364,  365,  366,    0,  368,  369, 
          370,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           33,   -1,   -1,   -1,   37,   38,   -1,   40,   41,   42, 
           43,   44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   60,   61,   62, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   94,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
          123,  124,  125,  126,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   33,   -1,   -1, 
           -1,   37,   38,   -1,   40,   41,   42,   43,   44,   45, 
           46,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   60,   61,   62,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   94,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  124,  125, 
          126,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,  279,  280,   -1,   -1, 
           -1,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,  298,   -1,  300,   -1,   -1, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,   -1,   -1,  322, 
          323,  324,   -1,  326,  327,  328,  329,  330,  331,  332, 
          333,  334,  335,  336,  337,  338,  339,  340,  341,  342, 
           -1,   -1,  345,  346,  347,  348,  349,   -1,  351,  352, 
          353,  354,  355,   -1,  357,  358,  359,  360,  361,  362, 
          363,  364,  365,  366,   -1,  368,  369,  370,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,   -1,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,  279,   -1,   -1,   -1,   -1,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,  298,   -1,  300,   -1,   -1,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,   -1,   -1,  322,  323,  324,   94, 
          326,  327,  328,  329,  330,  331,  332,  333,  334,  335, 
          336,  337,  338,  339,  340,  341,  342,   -1,   -1,  345, 
          346,  347,  348,  349,   -1,  351,  352,  353,  354,  355, 
           -1,  357,  358,  359,  360,  361,  362,  363,  364,  365, 
          366,    0,  368,  369,  370,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   33,   -1,   -1,   -1,   37,   38, 
           -1,   40,   41,   42,   43,   44,   45,   46,   47,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,   60,   61,   62,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   91,   -1,   -1,   94,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,  124,  125,  126,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   33,  287,  288,  289,  290,   -1,   -1,   -1,   41, 
           -1,   -1,   -1,   -1,   46,   -1,   -1,   -1,  303,  304, 
          305,  306,   -1,   -1,   -1,  310,   -1,   59,  313,  314, 
          315,  316,  317,   -1,   -1,   -1,   -1,   -1,  323,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  341,  342,   -1,   -1, 
           -1,   -1,   -1,   -1,  349,   -1,   -1,  352,   -1,  354, 
          355,   -1,  357,   -1,   -1,  360,  361,  362,  363,  364, 
          365,  366,   -1,  368,  369,   -1,   -1,   -1,   -1,   -1, 
           -1,  123,   -1,  125,  126,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,   -1,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
          279,   -1,   -1,   -1,   -1,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,  298, 
           -1,  300,   -1,   -1,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,   -1,   -1,  322,  323,  324,   -1,  326,  327,  328, 
          329,  330,  331,  332,  333,  334,  335,  336,  337,  338, 
          339,  340,  341,  342,   -1,   -1,  345,  346,  347,  348, 
          349,   -1,  351,  352,  353,  354,  355,   -1,  357,  358, 
          359,  360,  361,  362,  363,  364,  365,  366,   -1,  368, 
          369,  370,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,  279,  280,  281, 
           -1,   -1,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,  298,   -1,  300,   -1, 
           -1,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,   -1,   -1, 
          322,  323,  324,   -1,  326,  327,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,  341, 
          342,   -1,   10,   -1,   -1,  347,  348,  349,   -1,   -1, 
          352,  353,  354,  355,   -1,  357,  358,  359,  360,  361, 
          362,  363,  364,  365,  366,   -1,  368,  369,  370,   37, 
           38,   -1,   -1,   41,   42,   43,   44,   45,   46,   47, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,   60,   -1,   62,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   91,   -1,   93,   94,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  124,  125,   -1,   37, 
           38,   -1,   -1,   41,   42,   43,   44,   45,   46,   47, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,   60,   -1,   62,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   93,   94,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  124,  125,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   37,   38,   -1,   -1,   41,   42,   43, 
           44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   60,   -1,   62,   63, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  279,   -1,  281,  282,   -1,   -1,   91,   -1,   93, 
           94,   -1,   -1,  291,  292,   -1,  294,  295,  296,  297, 
          298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          124,  125,   -1,   -1,  322,   -1,  324,   -1,   -1,   -1, 
          328,  329,  330,  331,  332,  333,  334,  335,  336,  337, 
          338,  339,  340,   -1,   -1,   -1,   -1,  345,  346,  347, 
          348,   -1,   -1,  351,  262,  263,  264,   -1,  356,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  279,  370,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  291,  292,   -1,  294,  295,  296,  297, 
          298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  322,   -1,  324,   -1,   -1,   -1, 
          328,  329,  330,  331,  332,  333,  334,  335,  336,  337, 
          338,  339,  340,   -1,   -1,   -1,   -1,  345,  346,  347, 
          348,   -1,   -1,  351,   -1,   -1,   -1,   -1,  356,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,  370,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  279,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  291,  292,   -1, 
          294,  295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,  322,   -1, 
          324,   -1,   10,   -1,  328,  329,  330,  331,  332,  333, 
          334,  335,  336,  337,  338,  339,  340,   -1,   -1,   -1, 
           -1,  345,  346,  347,  348,   -1,   -1,  351,   -1,   37, 
           38,   -1,  356,   41,   42,   43,   44,   45,   46,   47, 
           -1,   -1,   -1,   -1,   -1,   -1,  370,   -1,   -1,   -1, 
           -1,   59,   60,   61,   62,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,    0,   -1,   94,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  123,  124,  125,   -1,   -1, 
           -1,   37,   38,   -1,   -1,   41,   42,   43,   44,   45, 
           46,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   60,   61,   62,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   91,   -1,   -1,   94,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  123,  124,  125, 
           -1,   37,   38,   -1,   -1,   41,   42,   43,   44,   45, 
           46,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   60,   61,   62,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,   -1, 
          268,  269,   -1,  271,   -1,   91,   -1,   -1,   94,   -1, 
           -1,  279,  280,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  291,  292,   -1,  294,  295,  296,  297, 
          298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  124,  125, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  322,   -1,  324,   -1,   -1,   -1, 
          328,  329,  330,  331,  332,  333,  334,  335,  336,  337, 
          338,  339,  340,   -1,   -1,   -1,   -1,  345,  346,  347, 
          348,   -1,   -1,  351,   -1,   -1,  262,  263,  264,   -1, 
           -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,  370,  279,  280,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  291,  292,   -1,  294,  295, 
          296,  297,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  322,   -1,  324,   -1, 
           -1,   -1,  328,  329,  330,  331,  332,  333,  334,  335, 
          336,  337,  338,  339,  340,   -1,   -1,   -1,   -1,  345, 
          346,  347,  348,   -1,   -1,  351,  262,  263,  264,   -1, 
           -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  279,  370,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  291,  292,   -1,  294,  295, 
          296,  297,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,  322,   -1,  324,   10, 
           -1,   -1,  328,  329,  330,  331,  332,  333,  334,  335, 
          336,  337,  338,  339,  340,   -1,   -1,   -1,   -1,  345, 
          346,  347,  348,   -1,  350,  351,   37,   38,   -1,   -1, 
           41,   42,   43,   44,   45,   46,   47,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  370,   -1,   -1,   -1,   59,   60, 
           61,   62,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           91,   -1,   -1,   94,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  124,  125,   -1,   37,   38,   -1,   -1, 
           41,   42,   43,   44,   45,   46,   47,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   60, 
           61,   62,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,    0,   -1,   94,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  124,  125,   -1,   -1,   -1,   37,   38, 
           -1,   -1,   41,   42,   43,   44,   45,   46,   47,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,   60,   61,   62,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   -1,   91,   -1,   -1,   94,   -1,   -1,  279,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          291,  292,   -1,  294,  295,  296,  297,  298,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  124,  125,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  322,   -1,  324,   -1,   -1,   -1,  328,  329,  330, 
          331,  332,  333,  334,  335,  336,  337,  338,  339,  340, 
           -1,   -1,   -1,   -1,  345,  346,  347,  348,   -1,  350, 
          351,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  279,  370, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          291,  292,   -1,  294,  295,  296,  297,  298,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  322,   -1,  324,   -1,   -1,   -1,  328,  329,  330, 
          331,  332,  333,  334,  335,  336,  337,  338,  339,  340, 
           -1,   -1,   -1,   -1,  345,  346,  347,  348,   -1,  350, 
          351,   -1,   -1,  262,  263,  264,   -1,   -1,   -1,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,  370, 
          279,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  291,  292,   -1,  294,  295,  296,  297,  298, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,  322,   -1,  324,   10,   -1,   -1,  328, 
          329,  330,  331,  332,  333,  334,  335,  336,  337,  338, 
          339,  340,   -1,   -1,   -1,   -1,  345,  346,  347,  348, 
           -1,  350,  351,   37,   38,   -1,   -1,   41,   42,   43, 
           44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  370,   -1,   -1,   -1,   59,   60,   61,   62,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   91,   -1,   -1, 
           94,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          124,  125,   -1,   37,   38,   -1,   -1,   41,   42,   43, 
           44,   45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   60,   61,   62,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,    0,   -1, 
           94,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          124,  125,   -1,   -1,   -1,   37,   38,   -1,   -1,   41, 
           42,   43,   44,   45,   46,   47,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   60,   61, 
           62,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1,   91, 
           -1,   -1,   94,   -1,   -1,  279,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  291,  292,   -1, 
          294,  295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  124,  125,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  322,   -1, 
          324,   -1,   -1,   -1,  328,  329,  330,  331,  332,  333, 
          334,  335,  336,  337,  338,  339,  340,   -1,   -1,   -1, 
           -1,  345,  346,  347,  348,   -1,  350,  351,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  279,  370,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  291,  292,   -1, 
          294,  295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  322,   -1, 
          324,   -1,   -1,   -1,  328,  329,  330,  331,  332,  333, 
          334,  335,  336,  337,  338,  339,  340,   -1,   -1,   -1, 
           -1,  345,  346,  347,  348,   -1,  350,  351,   -1,   -1, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,  370,  279,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  291, 
          292,   -1,  294,  295,  296,  297,  298,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
          322,   -1,  324,   10,   -1,   -1,  328,  329,  330,  331, 
          332,  333,  334,  335,  336,  337,  338,  339,  340,   -1, 
           -1,   -1,   -1,  345,  346,  347,  348,   -1,  350,  351, 
           37,   38,   -1,   -1,   41,   42,   43,   44,   45,   46, 
           47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  370,   -1, 
           -1,   -1,   59,   60,   61,   62,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   91,   -1,   -1,   94,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  124,  125,   -1, 
           37,   38,   -1,   -1,   41,   42,   43,   44,   45,   46, 
           47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   60,   61,   62,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,    0,   -1,   94,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  124,  125,   -1, 
           -1,   -1,   37,   38,   -1,   -1,   41,   42,   43,   44, 
           45,   46,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   60,   61,   62,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
           -1,  268,  269,   -1,  271,   -1,   91,   -1,   -1,   94, 
           -1,   -1,  279,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  291,  292,   -1,  294,  295,  296, 
          297,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  124, 
          125,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  322,   -1,  324,   -1,   -1, 
           -1,  328,  329,  330,  331,  332,  333,  334,  335,  336, 
          337,  338,  339,  340,   -1,   -1,   -1,   -1,  345,  346, 
          347,  348,   -1,  350,  351,  262,  263,  264,   -1,   -1, 
           -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  279,  370,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  291,  292,   -1,  294,  295,  296, 
          297,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  322,   -1,  324,   -1,   -1, 
           -1,  328,  329,  330,  331,  332,  333,  334,  335,  336, 
          337,  338,  339,  340,   -1,   -1,   -1,   -1,  345,  346, 
          347,  348,   -1,  350,  351,   -1,   -1,  262,  263,  264, 
           -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,  370,  279,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  291,  292,   -1,  294, 
          295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,  322,   -1,  324, 
           10,   -1,   -1,  328,  329,  330,  331,  332,  333,  334, 
          335,  336,  337,  338,  339,  340,   -1,   -1,   -1,   -1, 
          345,  346,  347,  348,   -1,  350,  351,   37,   38,   -1, 
           -1,   41,   42,   43,   44,   45,   46,   47,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  370,   -1,   -1,   -1,   59, 
           60,   61,   62,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   91,   -1,   -1,   94,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  124,  125,   -1,   37,   38,   -1, 
           -1,   41,   42,   43,   44,   45,   46,   47,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           60,   61,   62,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,    0,   -1,   94,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  124,  125,   -1,   -1,   -1,   37, 
           38,   -1,   -1,   41,   42,   43,   44,   45,   46,   47, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,   60,   61,   62,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,   -1,  268,  269, 
           -1,  271,   -1,   91,   -1,   -1,   94,   -1,   -1,  279, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  291,  292,   -1,  294,  295,  296,  297,  298,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  124,  125,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  322,   -1,  324,   -1,   -1,   -1,  328,  329, 
          330,  331,  332,  333,  334,  335,  336,  337,  338,  339, 
          340,   -1,   -1,   -1,   -1,  345,  346,  347,  348,   -1, 
            0,  351,  262,  263,  264,   -1,   -1,   -1,  268,  269, 
           10,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  279, 
          370,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  291,  292,   -1,  294,  295,  296,  297,  298,   -1, 
           -1,   41,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,   -1,  322,   -1,  324,   -1,   -1,   -1,  328,  329, 
          330,  331,  332,  333,  334,  335,  336,  337,  338,  339, 
          340,   -1,   -1,   -1,   -1,  345,  346,  347,  348,   -1, 
           -1,  351,   -1,   93,  262,  263,  264,   -1,    0,   -1, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   10,   -1, 
          370,  279,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  291,  292,  125,  294,  295,  296,  297, 
          298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   41, 
           -1,   -1,   44,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  322,   10,  324,   59,   -1,   -1, 
          328,  329,  330,  331,  332,  333,  334,  335,  336,  337, 
          338,  339,  340,   -1,   -1,   -1,   -1,  345,  346,  347, 
          348,   -1,   -1,  351,    0,   -1,   41,   -1,   -1,   44, 
           -1,   93,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  370,   -1,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  125,   -1,   41,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   93,   -1, 
           -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
          125,  271,   -1,   -1,   -1,   -1,   -1,   93,   -1,  279, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  291,  292,    0,  294,  295,  296,  297,  298,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,  124,  125, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  322,   -1,  324,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   41,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   -1,   -1,  356,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
          370,   -1,   -1,   41,   -1,   -1,   44,  279,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   93,   -1,   -1,  291, 
          292,   59,  294,  295,  296,  297,  298,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,  124,  125,   -1, 
          322,   -1,  324,   -1,  279,   93,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  291,  292,   -1,  294, 
          295,  296,  297,  298,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,  356,  271,  124,  125,   -1,   -1, 
           -1,   -1,   -1,  279,   -1,  281,   -1,  322,  370,  324, 
           -1,   -1,   -1,    0,   -1,  291,  292,   -1,  294,  295, 
          296,  297,  298,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  356,   -1,   -1,   -1,   -1,  322,   -1,  324,   -1, 
           -1,   -1,   -1,   -1,   41,  370,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  370,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   93,   -1,   -1,   -1, 
           -1,   -1,  279,   -1,  281,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  291,  292,   -1,  294,  295,  296, 
          297,  298,    0,   -1,  262,  263,  264,  124,  125,  267, 
          268,  269,   10,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  279,   -1,  281,   -1,  322,   -1,  324,   -1,   -1, 
           -1,   -1,   -1,  291,  292,   -1,  294,  295,  296,  297, 
          298,    0,   -1,   41,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,   -1,   -1,  322,   -1,  324,   -1,   -1,   -1, 
           -1,   -1,   -1,  370,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   41,   -1,   -1,   44,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,  351,   -1,   93,   -1,   -1,   -1,   -1, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  370,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           41,   -1,   -1,   44,   -1,   -1,    0,  125,   -1,   -1, 
           -1,   -1,   -1,   -1,   93,   -1,   10,   -1,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  279,   -1,  281,   -1,  125,   41,   -1,   -1, 
           44,   -1,   93,   -1,  291,  292,   -1,  294,  295,  296, 
          297,  298,   -1,   -1,   -1,   59,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,  125,  322,   -1,  324,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   93, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           41,   -1,   -1,   44,  351,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   59,   -1, 
           -1,  125,   -1,  370,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,    0,   -1,   41,   -1,   -1, 
           44,  279,   93,  281,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  291,  292,   59,  294,  295,  296,  297, 
          298,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,  125,   -1,   41,   -1,   -1,   -1, 
          279,   -1,  281,   -1,  322,   -1,  324,   -1,   -1,   93, 
           -1,   -1,  291,  292,   59,  294,  295,  296,  297,  298, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,  351,   -1,   -1,   -1,   -1,  279,   -1, 
          281,  125,   -1,  322,   -1,  324,   -1,   -1,   93,    0, 
          291,  292,  370,  294,  295,  296,  297,  298,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
          125,  322,   -1,  324,   -1,  279,   -1,  281,   -1,   -1, 
           41,  370,   -1,   -1,   -1,   -1,   -1,  291,  292,   -1, 
          294,  295,  296,  297,  298,   -1,   -1,   -1,   59,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,  322,  370, 
          324,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   93,   -1,   -1,   -1,   -1,   -1,  279,   -1, 
          281,   -1,   -1,   41,   -1,   -1,   -1,   -1,   -1,   -1, 
          291,  292,    0,  294,  295,  296,  297,  298,   -1,   -1, 
           -1,   59,   10,   -1,  125,   -1,  370,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,  322,   -1,  324,   -1,  279,   -1,  281,   -1,   -1, 
           -1,   -1,   -1,   41,   -1,   93,   -1,  291,  292,   -1, 
          294,  295,  296,  297,  298,   -1,   -1,  262,  263,  264, 
           -1,   59,  267,  268,  269,    0,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  279,   10,  281,  125,  322,  370, 
          324,   -1,   -1,   -1,   -1,   -1,  291,  292,   -1,  294, 
          295,  296,  297,  298,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   41,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,  322,   -1,  324, 
           -1,   -1,   -1,   -1,   59,   -1,  370,  125,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   41,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   59,   -1,   -1,   -1,  370,   -1,   -1,  279,   -1, 
          281,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          291,  292,   -1,  294,  295,  296,  297,  298,   -1,   -1, 
          125,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,  322,   -1,  324,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,  125,   -1,   -1, 
           -1,  279,   -1,  281,   -1,   41,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  291,  292,   -1,  294,  295,  296,  297, 
          298,   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,  370, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,  322,   -1,  324,   -1,   -1,    0, 
           -1,  279,   -1,  281,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,  291,  292,   -1,  294,  295,  296,  297, 
          298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  125, 
           41,   -1,  370,   -1,  322,   -1,  324,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   59,   -1, 
           -1,   -1,   -1,    0,  279,   -1,  281,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,  291,  292,   -1,  294, 
          295,  296,  297,  298,  262,  263,  264,   -1,   -1,  267, 
          268,  269,  370,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  279,   -1,  281,   41,   -1,   -1,  322,   -1,  324, 
           -1,   -1,   -1,  291,  292,    0,  294,  295,  296,  297, 
          298,   -1,   59,   -1,  125,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  322,   -1,  324,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  370,   41,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,  125,   -1, 
           -1,   -1,  370,  279,   -1,  281,   -1,   -1,   41,   -1, 
           -1,   -1,   -1,   -1,   -1,  291,  292,   -1,  294,  295, 
          296,  297,  298,   -1,   -1,   -1,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  322,   -1,  324,   -1, 
          125,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  279,    0, 
          281,   -1,  125,   41,  370,   -1,   44,   -1,   -1,   10, 
          291,  292,    0,  294,  295,  296,  297,  298,   -1,   -1, 
           -1,   59,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           41,  322,   -1,  324,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   41,  271,   -1,   -1,   -1,   59,   -1, 
           -1,   -1,  279,   -1,  281,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,   -1,   -1,  291,  292,   -1,  294,  295,  296, 
          297,  298,   -1,   -1,    0,   -1,   -1,  125,   -1,  370, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,  322,  271,  324,   -1,   -1, 
           -1,   -1,   -1,   -1,  279,   -1,  281,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  125,   41,  291,  292,   -1,  294, 
          295,  296,  297,  298,   -1,   -1,   -1,  125,   -1,  262, 
          263,  264,   -1,   59,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,    0,  370,   -1,   -1,   -1,  322,  281,  324, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,  291,  292, 
           -1,  294,  295,  296,  297,  298,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   41,    0,   -1,   -1,   -1,   -1,  322, 
           -1,  324,   -1,   -1,   10,  370,   -1,   -1,   -1,  125, 
           -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,   -1, 
          268,  269,   -1,  271,   -1,   41,   -1,   -1,   -1,   -1, 
           -1,  279,   -1,   -1,   -1,   -1,   -1,  370,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   -1,  294,  295,  296,  297, 
          298,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   -1,    0,   -1,  262,  263,  264,  125,  279,   -1, 
          268,  269,   10,  271,  322,   -1,  324,   -1,   -1,   -1, 
           -1,  279,    0,  294,  295,  296,  297,  298,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,  294,  295,  296,  297, 
          298,   -1,   -1,   41,   -1,   -1,   -1,   -1,   -1,  125, 
           -1,  322,   -1,  324,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,  370,   41,  322,   -1,  324,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,   59,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  279,   -1,   -1,   -1,   -1,   -1,  370, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  294,  295, 
          296,  297,  370,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  125,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  322,   -1,  324,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,  125,   -1,   -1, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  279,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,  370,   -1,  262,  263,  264,   33, 
           -1,   -1,  268,  269,   -1,  271,   40,   -1,   -1,   -1, 
           -1,   -1,   46,  279,  322,   -1,  324,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   60,   -1,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  322,   91,  324,   -1, 
           -1,   -1,  370,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,   -1, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,  123, 
           -1,  279,  126,   -1,  262,  263,  264,   -1,   -1,   -1, 
          268,  269,   10,  271,  370,   -1,  294,  295,  296,  297, 
           -1,  279,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   33,  294,  295,  296,  297, 
           -1,   -1,   40,   -1,  322,   -1,  324,   -1,   46,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,   60,   -1,  322,   -1,  324,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  370,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  370,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  123,   -1,   -1,  126,   -1, 
           -1,   -1,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   -1,  269,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,   -1,   -1,   -1, 
          284,  285,  286,  287,  288,  289,  290,   -1,   -1,  293, 
           -1,   -1,   -1,   -1,   -1,  299,  300,  301,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,  317,  318,  319,   -1,   -1,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  341,  342,   -1, 
           -1,   -1,   -1,  347,  348,  349,   -1,   -1,  352,  353, 
          354,  355,   -1,  357,   -1,   -1,  360,  361,  362,  363, 
          364,  365,  366,   -1,  368,  369,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,  257, 
          258,  259,  260,  261,  262,  263,  264,  265,  266,   -1, 
           -1,  269,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,   -1,   -1,   -1,  284,  285,  286,  287, 
          288,  289,  290,   -1,   -1,  293,   -1,   -1,   -1,   -1, 
           -1,  299,  300,  301,  302,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,  317, 
          318,  319,   -1,   -1,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  341,  342,   -1,   10,   -1,   -1,  347, 
          348,  349,   -1,   -1,  352,  353,  354,  355,   -1,  357, 
           -1,   -1,  360,  361,  362,  363,  364,  365,  366,   33, 
          368,  369,   -1,   -1,   -1,   -1,   40,   -1,   -1,   -1, 
           -1,   -1,   46,   -1,   -1,   -1, 1023, 1024,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   60,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1, 1090, 1091,   -1,   -1, 1094,   -1,  123, 
           10,   -1,  126,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   33,   -1,   -1,   -1,   -1,   -1,   -1, 
           40, 1128,   -1,   -1,   -1,   -1,   46,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           60,   -1, 1149,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
         1167,   -1,   -1,   -1, 1171,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1, 1184, 1185, 1186, 
         1187,   -1,   -1,   -1, 1191, 1192,   -1, 1194,   -1,   -1, 
           -1,   37,   38,   -1,   -1,   -1,   42,   43,   -1,   45, 
           -1,   47,   -1,   -1,   -1,   -1,  126,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   60,   -1,   62,   63,   -1,   -1, 
           -1,   -1,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   -1,  269,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,   -1,   94,   -1, 
          284,  285,  286,  287,  288,  289,  290,   -1,   -1,  293, 
           -1,   -1,   -1,   -1,   -1,  299,  300,  301,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,  124,  313, 
          314,  315,  316,  317,  318,  319,   -1,   -1,  322,  323, 
           -1,   -1,  326,  327,   -1, 1302,   -1,   -1, 1305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1, 1313,  341,  342,   -1, 
           -1,   -1,   -1,  347,  348,  349,   -1,   -1,  352,  353, 
          354,  355,   -1,  357,   -1,   -1,  360,  361,  362,  363, 
          364,  365,  366,   -1,  368,  369,  256,  257,  258,  259, 
          260,  261,  262,  263,  264,  265,  266,   -1,   -1,  269, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1, 1370,  284,  285,  286,  287,  288,  289, 
          290,   -1,   -1,  293,   -1,   -1,   -1,   -1,   -1,  299, 
          300,  301,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,  317,  318,  319, 
           -1,   -1,  322,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,  341,  342,   -1,   -1,   -1,   -1,  347,  348,  349, 
           -1,   -1,  352,  353,  354,  355,   -1,  357,   33,   -1, 
          360,  361,  362,  363,  364,  365,  366,   -1,  368,  369, 
           -1,   46,  298,   -1, 1023, 1024,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   60, 1023, 1024,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  328,  329,  330,  331,  332,  333,  334,  335, 
          336,  337,  338,  339,  340,   -1,   91,   -1,   -1,  345, 
          346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1, 1090, 1091,   -1,   -1, 1094,   -1,   -1,   -1,   10, 
           -1,  126,   -1, 1090, 1091,   -1,   -1, 1094,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   33,   -1,   -1,   -1,   -1,   -1,   -1, 1128, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1, 1128,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
         1149,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1, 1149,   -1,   -1,   -1,   -1,   -1, 1167,   -1, 
           -1,   -1, 1171,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
         1167,   -1,   -1,   -1, 1171, 1184, 1185, 1186, 1187,   -1, 
           -1,   -1, 1191, 1192,   -1, 1194,   -1, 1184, 1185, 1186, 
         1187,   -1,   -1,   -1, 1191, 1192,   -1, 1194,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  126,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  256,  257,  258,  259,  260,  261,  262,  263,  264, 
          265,  266,   -1,   -1,  269,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,   -1,  284, 
          285,  286,  287,  288,  289,  290,   -1,   -1,  293,   -1, 
           -1,   -1,   -1,   -1,  299,  300,  301,  302,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,  317,  318,  319,   -1,   -1,  322,  323,   -1, 
           -1,  326,  327, 1302,   -1,   -1, 1305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1, 1313, 1302,  341,  342, 1305,   -1, 
           -1,   -1,  347,  348,  349,   -1, 1313,  352,  353,  354, 
          355,   -1,  357,   -1,   -1,  360,  361,  362,  363,  364, 
          365,  366,   -1,  368,  369,  256,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,   -1,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,  279,   -1, 
           -1, 1370,   -1,  284,  285,  286,  287,  288,  289,  290, 
           -1,   -1,  293, 1370,   -1,   -1,   10,   -1,  299,  300, 
          301,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,  317,  318,  319,   33, 
           -1,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
           -1,   -1, 1023, 1024,   -1,   -1,   -1,   -1,   -1,   -1, 
          341,  342,   -1,   -1,   -1,   59,   -1,   61,  349,   -1, 
           -1,  352,  353,  354,  355,   -1,  357,   -1,   -1,  360, 
          361,  362,  363,  364,  365,  366,   -1,  368,  369,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 1090, 
         1091,   -1,   -1, 1094,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,  126,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   33,   -1,   -1,   -1, 1128,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 1149,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1, 1167,   -1,   -1,   -1, 
         1171,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1, 1184, 1185, 1186, 1187,   -1,   -1,   -1, 
         1191, 1192,   -1, 1194,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   37,   38,   -1,   -1,   -1,   42,   43,   -1,   45, 
           -1,   47,   -1,   -1,   -1,   -1,  126,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   60,   -1,   62,   63,   -1,   -1, 
           -1,   -1,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1, 
      };
   }

   private static final int[] yyCheck4() {
      return new int[] {

           -1,  269,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   94,   -1,  284,  285,  286,  287, 
          288,  289,  290,   -1,   -1,  293,   -1,   -1,   -1,   -1, 
           -1,  299,  300,  301,  302,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,  124,  313,  314,  315,  316,  317, 
          318,  319,   -1,   -1,  322,  323,   -1, 1302,  326,  327, 
         1305,   -1,   -1,   -1,   -1,   10,   -1,   -1, 1313,   -1, 
           -1,   -1,   -1,  341,  342,   -1,   -1,   -1,   -1,   -1, 
           -1,  349,   -1,   -1,  352,  353,  354,  355,   33,  357, 
           -1,   -1,  360,  361,  362,  363,  364,  365,  366,   -1, 
          368,  369,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   59,  269,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278, 1370,   -1,   -1,   -1,   -1, 
          284,  285,  286,  287,  288,  289,  290,   -1,   -1,  293, 
           -1,   -1,   -1,   -1,   -1,  299,  300,  301,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,  317,  318,  319,   -1,   -1,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,  126,   -1,   -1,   -1,   -1,   -1,  341,  342,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,   -1,   -1,  352,  353, 
          354,  355,   33,  357,   -1,   -1,  360,  361,  362,  363, 
          364,  365,  366,   -1,  368,  369,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,  329, 
          330,  331,  332,  333,  334,  335,  336,  337,  338,  339, 
          340,   -1,   -1,   -1,   -1,  345,  346,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           37,   38,   -1,   -1,   -1,   42,   43,   -1,   45,   -1, 
           47,   -1,   -1,   -1,  125,  126,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   60,   -1,   62,   63,   -1,   -1,   -1, 
           -1,  256,  257,  258,  259,  260,  261,  262,  263,  264, 
          265,  266,   -1,   -1,  269,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   94,   -1,  284, 
          285,  286,  287,  288,  289,  290,   -1,   -1,  293,   -1, 
           -1,   -1,   -1,   -1,  299,  300,  301,  302,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,  124,  313,  314, 
          315,  316,  317,  318,  319,   10,   -1,  322,  323,   -1, 
           -1,  326,  327,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  341,  342,   33,   -1, 
           -1,   -1,   -1,   -1,  349,   -1,   -1,  352,  353,  354, 
          355,   -1,  357,   -1,   -1,  360,  361,  362,  363,  364, 
          365,  366,   -1,  368,  369,  256,  257,  258,  259,  260, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,   -1,  284,  285,  286,  287,  288,  289,  290, 
           -1,   -1,  293,   -1,   -1,   -1,   -1,   -1,  299,  300, 
          301,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,  317,  318,  319,   -1, 
           10,  126,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          341,  342,   -1,   33,   -1,   -1,   -1,   -1,  349,   -1, 
           -1,  352,  353,  354,  355,   -1,  357,   -1,   -1,  360, 
          361,  362,  363,  364,  365,  366,   -1,  368,  369,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  328,  329,  330,  331,  332,  333,  334,  335,  336, 
          337,  338,  339,  340,   -1,   -1,   -1,   -1,  345,  346, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,  126,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,   -1,   33,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,   -1,  284, 
          285,  286,  287,  288,  289,  290,   -1,   -1,  293,   -1, 
           -1,   -1,   -1,   -1,   -1,  300,   -1,   -1,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,   -1,   -1,   -1,  323,   -1, 
           -1,  326,  327,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  341,  342,   -1,   -1, 
           -1,   -1,   -1,   -1,  349,   -1,   -1,  352,  353,  354, 
          355,  126,  357,  358,  359,  360,  361,  362,  363,  364, 
          365,  366,   -1,  368,  369,   -1,  256,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,   -1,  284,  285,  286,  287,  288,  289, 
          290,   -1,   -1,  293,   -1,   -1,   -1,   -1,   -1,   -1, 
          300,   -1,   -1,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,  317,  318,  319, 
           -1,   33,   -1,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  341,  342,   -1,   -1, 1023, 1024,   59,   -1,  349, 
           -1,   -1,  352,  353,  354,  355,   -1,   -1,   -1,   -1, 
          360,  361,  362,  363,  364,  365,  366,   -1,  368,  369, 
           -1,   -1,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,   -1,  284, 
          285,  286,  287,  288,  289,  290,   -1,   -1,  293,   -1, 
           -1,   -1, 1090, 1091,  126,  300, 1094,   -1,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,  317,  318,  319,   -1,   -1,   -1,  323,   -1, 
           -1,  326,  327,   -1,   -1,   -1,   33,   -1,   -1,   -1, 
         1128,   -1,   -1,   -1,   -1,   -1,  341,  342,   -1,   -1, 
           -1,   -1,   -1,   -1,  349,   -1,   -1,  352,  353,  354, 
          355, 1149,   59,   -1,   -1,  360,  361,  362,  363,  364, 
          365,  366,   -1,  368,  369,   -1,   -1,   -1,   -1, 1167, 
           -1,   -1,   -1, 1171,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1, 1184, 1185, 1186, 1187, 
           -1,   -1,   -1, 1191, 1192,   -1, 1194,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  126, 
           -1,   -1,   -1,   -1,  256,  257,  258,  259,  260,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   33,   -1,   -1, 
           -1,   -1,  284,  285,  286,  287,  288,  289,  290,   -1, 
           -1,  293,   -1,   -1,   -1,   -1,   -1,  299,  300,  301, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,  317,  318,  319,   -1,   -1, 
           -1,  323,   -1,   -1,  326,  327,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1, 1302,   -1,   -1, 1305,   -1,  341, 
          342,   -1,   -1,   -1,   -1, 1313,   -1,  349,   -1,   -1, 
          352,  353,  354,  355,   -1,  357,   -1,   -1,  360,  361, 
          362,  363,  364,  365,  366,   -1,  368,  369,   -1,   -1, 
          126,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256, 
          257,  258,  259,  260,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278, 1370,   33,   -1,   -1,   -1,  284,  285,  286, 
          287,  288,  289,  290,   -1,   -1,  293,   -1,   -1,   -1, 
           -1,   -1,  299,  300,  301,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
          317,  318,  319,   -1,   -1,   -1,  323,   -1,   -1,  326, 
          327,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  341,  342,   -1,   -1,   -1,   -1, 
           -1,   -1,  349,   -1,   -1,  352,  353,  354,  355,   -1, 
          357,   -1,   -1,  360,  361,  362,  363,  364,  365,  366, 
           -1,  368,  369,   -1,   -1,   -1,  126,   -1,   -1,   -1, 
          256,  257,  258,  259,  260,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   33,   -1,   -1,   -1,   -1,  284,  285, 
          286,  287,  288,  289,  290,   -1,   -1,  293,   -1,   -1, 
           -1,   -1,   -1,  299,  300,  301,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,  317,  318,  319,   -1,   -1,   -1,  323,   -1,   -1, 
          326,  327,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  341,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,   -1,   -1,  352,  353,  354,  355, 
           -1,  357,   -1,   -1,  360,  361,  362,  363,  364,  365, 
          366,   -1,  368,  369,   -1,   -1,  126,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259, 
          260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   33, 
           -1,   -1,   -1,   -1,  284,  285,  286,  287,  288,  289, 
          290,   -1,   -1,  293,   -1,   -1,   -1,   -1,   -1,  299, 
          300,  301,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,  317,  318,  319, 
           -1,   -1,   -1,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  341,  342,   -1,   -1,   -1,   -1,   -1,   -1,  349, 
           -1,   -1,  352,  353,  354,  355,   -1,  357,   -1,   -1, 
          360,  361,  362,  363,  364,  365,  366,   -1,  368,  369, 
           -1,   -1,  126,   -1,   -1,   -1,  256,  257,  258,  259, 
          260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   33, 
           -1,   -1,   -1,   -1,  284,  285,  286,  287,  288,  289, 
          290,   -1,   -1,  293,   -1,   -1,   -1,   -1,   -1,  299, 
          300,  301,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,  317,  318,  319, 
           -1,   -1,   -1,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  341,  342,   -1,   -1,   -1,   -1,   -1,   -1,  349, 
           -1,   -1,  352,  353,  354,  355,   -1,  357,   -1,   -1, 
          360,  361,  362,  363,  364,  365,  366,   -1,  368,  369, 
           -1,   -1,  126,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  256,  257,  258,  259,  260,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   33,   -1,   -1,   -1,   -1, 
          284,  285,  286,  287,  288,  289,  290,   -1,   -1,  293, 
           -1,   -1,   -1,   -1,   -1,  299,  300,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,  317,  318,  319,   -1,   -1,   -1,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  341,  342,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,   -1,   -1,  352,  353, 
          354,  355,   -1,  357,   -1,   -1,  360,  361,  362,  363, 
          364,  365,  366,   -1,  368,  369,   -1,   -1,  126,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   33,   -1,   -1,   -1,   -1, 
          284,  285,  286,  287,  288,  289,  290,   -1,   -1,  293, 
           -1,   -1,   -1,   -1,   -1,   -1,  300,   -1,   -1,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,   -1,   -1,   -1,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  341,  342,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,   -1,   -1,  352,  353, 
          354,  355,   -1,  357,  358,  359,  360,  361,  362,  363, 
          364,  365,  366,   -1,  368,  369,   -1,   -1,  126,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   33,   -1,   -1,   -1,   -1,  284,  285,  286,  287, 
          288,  289,  290,   -1,   -1,  293,   -1,   -1,   -1,   -1, 
           -1,   -1,  300,   -1,   -1,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,   -1,   -1,   -1,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  341,  342,   -1,   -1,   -1,   -1,   -1, 
           -1,  349,   -1,   -1,  352,  353,  354,  355,   -1,  357, 
          358,  359,  360,  361,  362,  363,  364,  365,  366,   -1, 
          368,  369,   -1,   -1,  126,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   33,   -1,   -1,   -1,   -1,  284,  285,  286,  287, 
          288,  289,  290,   -1,   -1,  293,   -1,   -1,   -1,   -1, 
           -1,   -1,  300,   -1,   -1,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,   -1,   -1,   -1,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  341,  342,   -1,   -1,   -1,   -1,   -1, 
           -1,  349,   -1,   -1,  352,  353,  354,  355,   -1,  357, 
          358,  359,  360,  361,  362,  363,  364,  365,  366,   -1, 
          368,  369,   -1,   -1,  126,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   33,   -1,   -1, 
           -1,   -1,  284,  285,  286,  287,  288,  289,  290,   -1, 
           -1,  293,   -1,   -1,   -1,   -1,   -1,   -1,  300,   -1, 
           -1,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,   -1,   -1, 
           -1,  323,   -1,   -1,  326,  327,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  341, 
          342,   -1,   -1,   -1,   -1,   -1,   -1,  349,   -1,   -1, 
          352,  353,  354,  355,   -1,  357,  358,  359,  360,  361, 
          362,  363,  364,  365,  366,   -1,  368,  369,   -1,   -1, 
          126,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   33,   -1,   -1, 
           -1,   -1,  284,  285,  286,  287,  288,  289,  290,   -1, 
           -1,  293,   -1,   -1,   -1,   -1,   -1,   -1,  300,   -1, 
           -1,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,   -1,   -1, 
           -1,  323,   -1,   -1,  326,  327,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  341, 
          342,   -1,   -1,   -1,   -1,   -1,   -1,  349,   -1,   -1, 
          352,  353,  354,  355,   -1,  357,  358,  359,  360,  361, 
          362,  363,  364,  365,  366,   -1,  368,  369,   -1,   -1, 
          126,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   33,   -1,   -1,   -1,   -1,  284,  285, 
          286,  287,  288,  289,  290,   -1,   -1,  293,   -1,   -1, 
           -1,   -1,   -1,   -1,  300,   -1,   -1,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,   -1,   -1,   -1,  323,   -1,   -1, 
          326,  327,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  341,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,   -1,   -1,  352,  353,  354,  355, 
           -1,  357,  358,   -1,  360,  361,  362,  363,  364,  365, 
          366,   -1,  368,  369,   -1,   -1,  126,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   33,   -1,   -1,   -1,   -1,  284,  285, 
          286,  287,  288,  289,  290,   -1,   -1,  293,   -1,   -1, 
           -1,   -1,   -1,   -1,  300,   -1,   -1,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,   -1,   -1,   -1,  323,   -1,   -1, 
          326,  327,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  341,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,   -1,   -1,  352,  353,  354,  355, 
           -1,   -1,  358,  359,  360,  361,  362,  363,  364,  365, 
          366,   -1,  368,  369,   -1,   -1,  126,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   33, 
           -1,   -1,   -1,   -1,  284,  285,  286,  287,  288,  289, 
          290,   -1,   -1,  293,   -1,   -1,   -1,   -1,   -1,   -1, 
          300,   -1,   -1,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
           -1,   -1,   -1,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  341,  342,   -1,   -1,   -1,   -1,   -1,   -1,  349, 
           -1,   -1,  352,  353,  354,  355,   -1,   -1,  358,   -1, 
          360,  361,  362,  363,  364,  365,  366,   -1,  368,  369, 
           -1,   -1,  126,   -1,   -1,   -1,  256,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   33, 
           -1,   -1,   -1,   -1,  284,  285,  286,  287,  288,  289, 
          290,   -1,   -1,  293,   -1,   -1,   -1,   -1,   -1,   -1, 
          300,   -1,   -1,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,  317,  318,  319, 
           -1,   -1,   -1,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  341,  342,   -1,   -1,   -1,   -1,   -1,   -1,  349, 
           -1,   -1,  352,  353,  354,  355,   -1,   -1,   -1,   -1, 
          360,  361,  362,  363,  364,  365,  366,   -1,  368,  369, 
           -1,   -1,  126,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   33,   -1,   -1,   -1,   -1, 
          284,  285,  286,  287,  288,  289,  290,   -1,   -1,  293, 
           -1,   -1,   -1,   -1,   -1,   -1,  300,   -1,   -1,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,  317,  318,  319,   -1,   -1,   -1,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  341,  342,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,   -1,   -1,  352,  353, 
          354,  355,   -1,  357,   -1,   -1,  360,  361,  362,  363, 
          364,  365,  366,   -1,  368,  369,   -1,   -1,  126,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   33,   -1,   -1,   -1,   -1, 
          284,  285,  286,  287,  288,  289,  290,   -1,   -1,  293, 
           -1,   -1,   -1,   -1,   -1,   -1,  300,   -1,   -1,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,  317,  318,  319,   -1,   -1,   -1,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  341,  342,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,   -1,   -1,  352,  353, 
          354,  355,   -1,  357,   -1,   -1,  360,  361,  362,  363, 
          364,  365,  366,   -1,  368,  369,   -1,   -1,  126,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   33,   -1,   -1,   -1,   -1,  284,  285,  286,  287, 
          288,  289,  290,   -1,   -1,  293,   -1,   -1,   -1,   -1, 
           -1,   -1,  300,   -1,   -1,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,  317, 
          318,  319,   -1,   -1,   -1,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  341,  342,   -1,   -1,   -1,   -1,   -1, 
           -1,  349,   -1,   -1,  352,  353,  354,  355,   -1,  357, 
           -1,   -1,  360,  361,  362,  363,  364,  365,  366,   -1, 
          368,  369,   -1,   -1,  126,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,   -1,  284,  285,  286,  287, 
          288,  289,  290,   -1,   -1,  293,   -1,   33,   -1,   -1, 
           -1,   -1,  300,   -1,   40,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,  317, 
          318,  319,   -1,   -1,   -1,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  341,  342,   -1,   -1,   -1,   -1,   -1, 
           -1,  349,   -1,   -1,  352,  353,  354,  355,   -1,  357, 
           -1,   -1,  360,  361,  362,  363,  364,  365,  366,   -1, 
          368,  369,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
          126,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           33,   -1,  284,  285,  286,  287,  288,  289,  290,   -1, 
           -1,  293,   -1,   -1,   -1,   -1,   -1,   -1,  300,   -1, 
           -1,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,  317,  318,  319,   -1,   -1, 
           -1,  323,   -1,   -1,  326,  327,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  341, 
          342,   -1,   -1,   -1,   -1,   -1,   -1,  349,   -1,   -1, 
          352,  353,  354,  355,   -1,  357,   -1,   -1,  360,  361, 
          362,  363,  364,  365,  366,   -1,  368,  369,   -1,   -1, 
           -1,   -1,   -1,  126,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,   33,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,   -1,  284,  285, 
          286,  287,  288,  289,  290,   -1,   -1,  293,   -1,   -1, 
           -1,   -1,   -1,   -1,  300,   -1,   -1,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,  317,  318,  319,   -1,   -1,   -1,  323,   -1,   -1, 
          326,  327,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  341,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,   -1,   -1,  352,  353,  354,  355, 
          126,   -1,   -1,   -1,  360,  361,  362,  363,  364,  365, 
          366,   -1,  368,  369,  257,  258,  259,   -1,  261,   -1, 
           33,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
           -1,  284,  285,  286,  287,  288,  289,  290,   -1,   -1, 
          293,   -1,   -1,   -1,   -1,   -1,   -1,  300,   -1,   -1, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,  317,  318,  319,   -1,   -1,   -1, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  341,  342, 
           -1,   -1,   -1,   -1,   -1,   -1,  349,   -1,   -1,  352, 
          353,  354,  355,  126,   -1,   -1,   -1,  360,  361,  362, 
          363,  364,  365,  366,   -1,  368,  369,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,   33,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,   -1,  284,  285, 
          286,  287,  288,  289,  290,   -1,   -1,  293,   -1,   -1, 
           -1,   -1,   -1,   -1,  300,   -1,   -1,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,  317,  318,  319,   -1,   -1,   -1,  323,   -1,   -1, 
          326,  327,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  341,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,   -1,   -1,  352,  353,  354,  355, 
          126,   -1,   -1,   -1,  360,  361,  362,  363,  364,  365, 
          366,   -1,  368,  369,  257,  258,  259,   -1,  261,   -1, 
           33,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
           -1,  284,  285,  286,  287,  288,  289,  290,   -1,   -1, 
          293,   -1,   -1,   -1,   -1,   -1,   -1,  300,   -1,   -1, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,  317,  318,  319,   -1,   -1,   -1, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  341,  342, 
           -1,   -1,   -1,   -1,   -1,   -1,  349,   -1,   -1,  352, 
          353,  354,  355,  126,   -1,   -1,   -1,  360,  361,  362, 
          363,  364,  365,  366,   -1,  368,  369,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,   33,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,   -1,  284,  285, 
          286,  287,  288,  289,  290,   -1,   -1,  293,   -1,   -1, 
           -1,   -1,   -1,   -1,  300,   -1,   -1,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,  317,  318,  319,   -1,   -1,   -1,  323,   -1,   -1, 
          326,  327,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  341,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,   -1,   -1,  352,  353,  354,  355, 
          126,   -1,   -1,   -1,  360,  361,  362,  363,  364,  365, 
          366,   -1,  368,  369,  257,  258,  259,   -1,  261,   -1, 
           33,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
           -1,  284,  285,  286,  287,  288,  289,  290,   -1,   -1, 
          293,   -1,   -1,   -1,   -1,   -1,   -1,  300,   -1,   -1, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,  317,  318,  319,   -1,   -1,   -1, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  341,  342, 
           -1,   -1,   -1,   -1,   -1,   -1,  349,   -1,   -1,  352, 
          353,  354,  355,  126,   -1,   -1,   -1,  360,  361,  362, 
          363,  364,  365,  366,   -1,  368,  369,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,   -1,  284,  285, 
          286,  287,  288,  289,  290,   -1,   -1,  293,   -1,   -1, 
           -1,   -1,   -1,   -1,  300,   -1,   -1,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,  317,  318,  319,   -1,   -1,   -1,  323,   -1,   -1, 
          326,  327,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  341,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,   -1,   -1,  352,  353,  354,  355, 
           -1,   93,   94,   -1,  360,  361,  362,  363,  364,  365, 
          366,   -1,  368,  369,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
           -1,  284,  285,  286,  287,  288,  289,  290,   -1,   -1, 
          293,   -1,   -1,   -1,   -1,   -1,   -1,  300,   -1,   -1, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,  317,  318,  319,   -1,   -1,   -1, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  341,  342, 
           -1,   -1,   -1,   -1,   -1,   -1,  349,   -1,   -1,  352, 
          353,  354,  355,   -1,   -1,   -1,   -1,  360,  361,  362, 
          363,  364,  365,  366,   33,  368,  369,   -1,   37,   38, 
           -1,   -1,   -1,   42,   43,   -1,   45,   -1,   47,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   60,   -1,   62,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   94,   -1,   96,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  287,  288,  289,  290,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  303,  304,  305,  306,  124,   -1,  126,  310,   -1, 
          312,  313,  314,  315,  316,  317,   -1,   -1,   -1,   33, 
           -1,  323,   -1,   37,   38,   -1,  328,   -1,   42,   43, 
           -1,   45,   -1,   47,   -1,   -1,   -1,   -1,   -1,  341, 
          342,   -1,   -1,   -1,   -1,   -1,   60,  349,   62,   -1, 
          352,   -1,  354,  355,   -1,  357,  358,   -1,  360,  361, 
          362,  363,  364,  365,  366,   -1,  368,  369,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           94,   -1,   96,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   41, 
          124,   -1,  126,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258, 
          259,  260,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
          279,  280,   94,   -1,   -1,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,   -1,   -1,   -1,   -1,   -1, 
          299,  300,  301,  302,  303,  304,  305,  306,  307,  308, 
           -1,  310,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  326,  327,  328, 
          329,  330,  331,  332,  333,  334,   -1,   -1,  337,  338, 
           -1,   -1,   -1,   -1,  343,  344,  345,  346,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  357,  358, 
           -1,   -1,  361,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,  279,  280,   -1,   -1,   -1, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
           -1,   -1,   -1,   -1,   -1,  299,  300,  301,  302,  303, 
          304,  305,  306,  307,   -1,   -1,  310,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  326,  327,  328,  329,  330,  331,  332,  333, 
          334,   -1,   -1,  337,  338,   -1,   -1,   -1,   -1,  343, 
          344,  345,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           37,   38,   -1,  357,  358,   42,   43,  361,   45,   -1, 
           47,   -1,   -1,   -1,   -1,  287,  288,  289,  290,   -1, 
           -1,   -1,   -1,   60,   -1,   62,   63,   -1,   -1,   -1, 
           -1,  303,  304,  305,  306,   -1,   -1,   -1,  310,   -1, 
          312,  313,  314,  315,  316,  317,   -1,   -1,   -1,   -1, 
           -1,  323,   -1,   -1,   -1,   -1,  328,   94,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  341, 
          342,   -1,   -1,   -1,   -1,   -1,   -1,  349,   -1,   -1, 
          352,   -1,  354,  355,   -1,  357,  358,  124,  360,  361, 
          362,  363,  364,  365,  366,   33,  368,  369,   -1,   37, 
           38,   -1,   40,   -1,   42,   43,   -1,   45,   -1,   47, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   60,   -1,   62,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   94,   -1,   96,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  124,   -1,  126,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   33,   -1,   -1, 
           -1,   37,   38,   -1,   -1,   -1,   42,   43,   -1,   45, 
           -1,   47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   60,   -1,   62,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  279,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   94,   -1, 
           96,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  124,   -1, 
          126,  328,  329,  330,  331,  332,  333,  334,  335,  336, 
          337,  338,  339,  340,   -1,   -1,   -1,   -1,  345,  346, 
           -1,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,  257, 
          258,  259,  260,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,  279,  280,   -1,   -1,   -1,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,   -1,   44,   -1,   -1, 
           -1,  299,  300,  301,  302,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  326,  327, 
          328,  329,  330,  331,  332,  333,  334,   -1,   -1,  337, 
          338,   -1,   -1,   -1,   -1,  343,  344,  345,  346,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  357, 
          358,  257,  258,  259,  260,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,  279,  280,   -1,   -1,   -1,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,   -1,   -1, 
           -1,   -1,   -1,  299,  300,  301,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          326,  327,  328,  329,  330,  331,  332,  333,  334,   -1, 
           -1,  337,  338,   -1,   -1,   -1,   -1,  343,  344,  345, 
          346,   -1,   -1,   -1,   33,   -1,   -1,   -1,   37,   38, 
           -1,  357,  358,   42,   43,   -1,   45,   -1,   47,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   60,   -1,   62,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,   94,   -1,   96,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,   -1,  284,  285,  286, 
          287,  288,  289,  290,   -1,  124,  293,  126,   -1,   -1, 
           -1,   -1,   -1,  300,   -1,   44,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
          317,  318,  319,   -1,   -1,   -1,  323,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  349,   -1,   -1,  352,  353,  354,  355,   -1, 
           -1,   -1,   -1,  360,  361,  362,  363,  364,  365,  366, 
           -1,  368,  369,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   33,   -1,   -1,   -1,   37,   38,   -1,   40,   -1, 
           42,   43,   -1,   45,   -1,   47,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   60,   -1, 
           62,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258, 
          259,  260,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
          279,  280,   94,   -1,   96,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,   -1,   -1,   -1,   -1,   -1, 
          299,  300,  301,  302,  303,  304,  305,  306,  307,   -1, 
           -1,  310,  124,   -1,  126,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  326,  327,  328, 
          329,  330,  331,  332,  333,  334,   -1,   -1,  337,  338, 
           -1,   -1,   -1,   -1,  343,  344,  345,  346,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,  357,  358, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,   -1,  284,  285,  286,  287,  288, 
          289,  290,   -1,   -1,  293,   -1,   -1,   -1,   -1,   -1, 
           -1,  300,   -1,   -1,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,  317,  318, 
          319,   -1,   33,   -1,  323,   -1,   37,   38,   -1,   40, 
           -1,   42,   43,   -1,   45,   -1,   47,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   60, 
          349,   62,   -1,  352,  353,  354,  355,   -1,   -1,   -1, 
           -1,  360,  361,  362,  363,  364,  365,  366,   -1,  368, 
          369,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   94,   -1,   96,   -1,   33,   -1,   -1, 
           -1,   37,   38,   -1,   40,   -1,   42,   43,   -1,   45, 
           -1,   47,   -1,   -1,  306,  307,   -1,   -1,  310,   -1, 
           -1,   -1,   -1,  124,   60,  126,   62,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  326,  327,  328,  329,  330,  331, 
          332,  333,  334,   -1,   -1,  337,  338,   -1,   -1,   -1, 
           -1,  343,  344,  345,  346,   -1,   -1,   -1,   94,   -1, 
           96,   -1,   -1,   -1,   33,  357,  358,   -1,   37,   38, 
           -1,   40,   -1,   42,   43,   -1,   45,   -1,   47,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  124,   -1, 
          126,   60,   -1,   62,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   33,   -1,   -1,   -1,   37, 
           38,   -1,   40,   -1,   42,   43,   -1,   45,   -1,   47, 
           -1,   -1,   -1,   -1,   -1,   94,   -1,   96,   -1,   -1, 
           -1,   -1,   60,   -1,   62,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  124,   -1,  126,   -1,   -1, 
           33,   -1,   -1,   -1,   37,   38,   94,   40,   96,   42, 
           43,   -1,   45,   -1,   47,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   60,   -1,   62, 
           -1,   -1,   -1,   -1,   -1,   -1,  124,   -1,  126,   -1, 
           -1,   -1,   -1,   -1,   -1,  306,  307,   -1,   -1,  310, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   94,   -1,   96,   -1,  326,  327,  328,  329,  330, 
          331,  332,  333,  334,   -1,   -1,  337,  338,   -1,   -1, 
           -1,   -1,  343,  344,  345,  346,   -1,   -1,   -1,   -1, 
           -1,  124,   -1,  126,   33,   -1,  357,  358,   37,   38, 
           -1,   40,   -1,   42,   43,   -1,   45,   -1,   47,   -1, 
          306,  307,   -1,   -1,  310,   -1,   -1,   -1,   -1,   -1, 
           -1,   60,   -1,   62,   -1,   -1,   -1,   -1,   -1,   -1, 
          326,  327,  328,  329,  330,  331,  332,  333,  334,   -1, 
           -1,  337,  338,   -1,   -1,   -1,   -1,  343,  344,  345, 
          346,   -1,   -1,   -1,   -1,   94,   -1,   96,   -1,   -1, 
           -1,  357,  358,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  306,  307,   -1, 
           -1,  310,   -1,   -1,   -1,  124,   -1,  126,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  326,  327,  328, 
          329,  330,  331,  332,  333,  334,   -1,   -1,  337,  338, 
           -1,   -1,   -1,   -1,  343,  344,  345,  346,  306,  307, 
           -1,   -1,  310,   -1,   -1,   -1,   -1,   -1,  357,  358, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  326,  327, 
          328,  329,  330,  331,  332,  333,  334,   -1,   -1,  337, 
          338,   -1,   -1,   -1,   -1,  343,  344,  345,  346,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  357, 
          358,   -1,   -1,  306,  307,   -1,   -1,  310,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  326,  327,  328,  329,  330,  331,  332, 
          333,  334,   -1,   -1,  337,  338,   -1,   -1,   -1,   -1, 
          343,  344,  345,  346,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   33,   -1,  357,  358,   37,   38,   -1,   40, 
           -1,   42,   43,   -1,   45,   -1,   47,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   60, 
           -1,   62,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  306,  307,   -1, 
           -1,  310,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   94,   -1,   96,   -1,  326,  327,  328, 
          329,  330,  331,  332,  333,  334,   -1,   -1,  337,  338, 
           -1,   -1,   -1,   -1,  343,  344,  345,  346,   -1,   -1, 
           -1,   -1,   -1,  124,   -1,  126,   33,   -1,  357,  358, 
           37,   38,   -1,   40,   -1,   42,   43,   -1,   45,   -1, 
           47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   60,   -1,   62,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   33,   -1,   -1, 
           -1,   37,   38,   -1,   40,   -1,   42,   43,   -1,   45, 
           -1,   47,   -1,   -1,   -1,   -1,   -1,   94,   -1,   96, 
           -1,   -1,   -1,   -1,   60,   -1,   62,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   33,   -1,   -1,   -1,   37,   38,  124,   40,  126, 
           42,   43,   -1,   45,   -1,   47,   -1,   -1,   94,   -1, 
           96,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   60,   -1, 
           62,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   33,  124,   -1, 
          126,   37,   38,   -1,   40,   -1,   42,   43,   -1,   45, 
           -1,   47,   94,   -1,   96,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   60,   -1,   62,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  124,   -1,  126,  306,  307,   -1,   -1,  310, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   94,   -1, 
           96,   -1,   -1,   -1,   -1,  326,  327,  328,  329,  330, 
          331,  332,  333,  334,   -1,   -1,  337,  338,   -1,   -1, 
           -1,   -1,  343,  344,  345,  346,   -1,   -1,  124,   -1, 
          126,   -1,   -1,   -1,   33,   -1,  357,  358,   37,   38, 
           -1,   40,   -1,   42,   43,   -1,   45,   -1,   47,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   60,   -1,   62,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  306, 
          307,   -1,   -1,  310,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   94,   -1,   96,   -1,  326, 
          327,  328,  329,  330,  331,  332,  333,  334,   -1,   -1, 
          337,  338,   -1,   -1,   -1,   -1,  343,  344,  345,  346, 
          306,  307,   -1,   -1,  310,  124,   -1,  126,   -1,   -1, 
          357,  358,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          326,  327,  328,  329,  330,  331,  332,  333,  334,   -1, 
           -1,  337,  338,   -1,   -1,   -1,   -1,  343,  344,  345, 
          346,   -1,   -1,   -1,  306,  307,   -1,   -1,  310,   -1, 
           -1,  357,  358,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  326,  327,  328,  329,  330,  331, 
          332,  333,  334,   -1,   -1,  337,  338,   -1,   -1,   -1, 
           -1,  343,  344,  345,  346,   -1,   -1,   -1,   -1,   -1, 
          306,  307,   -1,   -1,  310,  357,  358,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          326,  327,  328,  329,  330,  331,  332,  333,  334,   -1, 
           -1,  337,  338,   -1,   -1,   -1,   -1,  343,  344,  345, 
          346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   33, 
           -1,  357,  358,   37,   38,   -1,   40,   -1,   42,   43, 
           -1,   45,   -1,   47,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   60,   -1,   62,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  306,  307,   -1, 
           -1,  310,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           94,   -1,   96,   -1,   -1,   -1,   -1,  326,  327,  328, 
          329,  330,  331,  332,  333,  334,   -1,   -1,  337,  338, 
           -1,   -1,   -1,   -1,  343,  344,  345,  346,   -1,   -1, 
          124,   -1,  126,   -1,   -1,   -1,   33,   -1,  357,  358, 
           37,   38,   -1,   40,   -1,   42,   43,   -1,   45,   -1, 
           47,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   60,   -1,   62,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   33,   -1,   -1, 
           -1,   37,   38,   -1,   40,   -1,   42,   43,   -1,   45, 
           -1,   47,   -1,   -1,   -1,   -1,   -1,   94,   -1,   96, 
           -1,   -1,   -1,   -1,   60,   -1,   62,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  124,   -1,  126, 
           -1,   -1,   33,   -1,   -1,   -1,   37,   38,   94,   -1, 
           96,   42,   43,   -1,   45,   -1,   47,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   60, 
           -1,   62,   -1,   -1,   -1,   -1,   -1,   -1,  124,   -1, 
          126,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   94,   -1,   96,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  306,  307,   -1,   -1,  310,   -1,   -1,   -1, 
           -1,   -1,   -1,  124,   -1,  126,   -1,   -1,   -1,   -1, 
           -1,   -1,  326,  327,  328,  329,  330,  331,  332,  333, 
          334,   -1,   -1,  337,  338,   -1,   -1,   -1,   -1,  343, 
          344,  345,  346,   94,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  357,  358,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  306, 
          307,   -1,   -1,  310,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  326, 
          327,  328,  329,  330,  331,  332,  333,  334,   94,   -1, 
          337,  338,   -1,   -1,   -1,   -1,  343,  344,  345,  346, 
          306,  307,   -1,   -1,  310,   -1,   -1,   -1,   -1,   -1, 
          357,  358,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          326,  327,  328,  329,  330,  331,  332,  333,  334,   -1, 
           -1,  337,  338,   -1,   -1,   -1,   -1,  343,  344,  345, 
          346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  357,  358,   -1,   -1,  306,  307,   -1,   -1,  310, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  326,  327,  328,  329,  330, 
          331,  332,  333,  334,   -1,   -1,  337,  338,   -1,   -1, 
           -1,   -1,  343,  344,  345,  346,  287,  288,  289,  290, 
           -1,   -1,   -1,   -1,   -1,   -1,  357,  358,   -1,   -1, 
           -1,   -1,  303,  304,  305,  306,   -1,   -1,   -1,  310, 
           -1,  312,  313,  314,  315,  316,  317,   -1,   -1,   -1, 
           -1,   -1,  323,   -1,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          341,  342,   -1,   -1,   -1,   -1,   -1,   -1,  349,   -1, 
           -1,  352,   -1,  354,  355,   -1,  357,  358,   -1,  360, 
          361,  362,  363,  364,  365,  366,   -1,  368,  369,   -1, 
           -1,  287,  288,  289,  290,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  303,  304,  305, 
          306,   -1,   -1,   -1,  310,   -1,   -1,  313,  314,  315, 
          316,  317,   -1,   -1,   -1,   -1,   -1,  323,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  341,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,   -1,   -1,  352,   -1,  354,  355, 
           -1,   -1,   -1,   -1,  360,  361,  362,  363,  364,  365, 
          366,   -1,  368,  369,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
           -1,  284,  285,  286,  287,  288,  289,  290,   -1,   -1, 
          293,   -1,   -1,   -1,   -1,   -1,   -1,  300,   -1,   -1, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,  317,  318,  319,   -1,   -1,   -1, 
          323,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  349,   -1,   -1,  352, 
          353,  354,  355,   -1,  357,   -1,   -1,  360,  361,  362, 
          363,  364,  365,  366,   -1,  368,  369,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,   -1,  284,  285,  286,  287,  288,  289, 
          290,   -1,   -1,  293,   -1,   -1,   -1,   -1,   -1,   -1, 
          300,   -1,   -1,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,  317,  318,  319, 
           -1,   -1,   -1,  323,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  349, 
           -1,   -1,  352,  353,  354,  355,   -1,  357,   -1,   -1, 
          360,  361,  362,  363,  364,  365,  366,   -1,  368,  369, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,   -1,  284,  285,  286, 
          287,  288,  289,  290,   -1,   -1,  293,   -1,   -1,   -1, 
           -1,   -1,   -1,  300,   -1,   -1,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
          317,  318,  319,   -1,   -1,   -1,  323,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  345,   -1, 
           -1,   -1,  349,   -1,   -1,  352,  353,  354,  355,   -1, 
           -1,   -1,   -1,  360,  361,  362,  363,  364,  365,  366, 
           -1,  368,  369,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,   -1, 
          284,  285,  286,  287,  288,  289,  290,   -1,   -1,  293, 
           -1,   -1,   -1,   -1,   -1,   -1,  300,   -1,   -1,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,  317,  318,  319,   -1,   -1,   -1,  323, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,   -1,   -1,  352,  353, 
          354,  355,   -1,   -1,   -1,   -1,  360,  361,  362,  363, 
          364,  365,  366,   -1,  368,  369,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,   -1,  284,  285,  286,  287,  288,  289,  290, 
           -1,   -1,  293,   -1,   -1,   -1,   -1,   -1,   -1,  300, 
           -1,   -1,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,  317,  318,  319,   -1, 
           -1,   -1,  323,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  349,   -1, 
           -1,  352,  353,  354,  355,   -1,   -1,   -1,   -1,  360, 
          361,  362,  363,  364,  365,  366,   -1,  368,  369,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,   -1,  284,  285,  286,  287, 
          288,  289,  290,   -1,   -1,  293,   -1,   -1,   -1,   -1, 
           -1,   -1,  300,   -1,   -1,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,  317, 
          318,  319,   -1,   -1,   -1,  323,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  349,   -1,   -1,  352,  353,  354,  355,   -1,   -1, 
           -1,   -1,  360,  361,  362,  363,  364,  365,  366,   -1, 
          368,  369,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,   -1,  284, 
          285,  286,  287,  288,  289,  290,   -1,   -1,  293,   -1, 
           -1,   -1,   -1,   -1,   -1,  300,   -1,   -1,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,  317,  318,  319,   -1,   -1,   -1,  323,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  349,   -1,   -1,  352,  353,  354, 
          355,   -1,   -1,   -1,   -1,  360,  361,  362,  363,  364, 
          365,  366,   -1,  368,  369, 
      };
   }

}
