/*
 * Copyright (c) 2016 Oracle and/or its affiliates. All rights reserved. This
 * code is released under a tri EPL/GPL/LGPL license. You can use it,
 * redistribute it and/or modify it under the terms of the:
 *
 * Eclipse Public License version 1.0
 * GNU General Public License version 2
 * GNU Lesser General Public License version 2.1
 *
 * This file contains configuration values translated from Rubinius.
 *
 * Copyright (c) 2007-2014, Evan Phoenix and contributors
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 * * Neither the name of Rubinius nor the names of its contributors
 *   may be used to endorse or promote products derived from this software
 *   without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.jruby.truffle.platform.solaris;

import org.jruby.truffle.RubyContext;
import org.jruby.truffle.platform.DefaultRubiniusConfiguration;
import org.jruby.truffle.platform.RubiniusConfiguration;

public class SolarisSparcV9RubiniusConfiguration extends DefaultRubiniusConfiguration {

    public static void load(RubiniusConfiguration configuration, RubyContext context) {
        configuration.config("rbx.platform.addrinfo.sizeof", 48);
        configuration.config("rbx.platform.addrinfo.ai_flags.offset", 0);
        configuration.config("rbx.platform.addrinfo.ai_flags.size", 4);
        configuration.config("rbx.platform.addrinfo.ai_flags.type", string(context, "int"));
        configuration.config("rbx.platform.addrinfo.ai_family.offset", 4);
        configuration.config("rbx.platform.addrinfo.ai_family.size", 4);
        configuration.config("rbx.platform.addrinfo.ai_family.type", string(context, "int"));
        configuration.config("rbx.platform.addrinfo.ai_socktype.offset", 8);
        configuration.config("rbx.platform.addrinfo.ai_socktype.size", 4);
        configuration.config("rbx.platform.addrinfo.ai_socktype.type", string(context, "int"));
        configuration.config("rbx.platform.addrinfo.ai_protocol.offset", 12);
        configuration.config("rbx.platform.addrinfo.ai_protocol.size", 4);
        configuration.config("rbx.platform.addrinfo.ai_protocol.type", string(context, "int"));
        configuration.config("rbx.platform.addrinfo.ai_addrlen.offset", 20);
        configuration.config("rbx.platform.addrinfo.ai_addrlen.size", 4);
        configuration.config("rbx.platform.addrinfo.ai_addrlen.type", string(context, "int"));
        configuration.config("rbx.platform.addrinfo.ai_addr.offset", 32);
        configuration.config("rbx.platform.addrinfo.ai_addr.size", 8);
        configuration.config("rbx.platform.addrinfo.ai_addr.type", string(context, "pointer"));
        configuration.config("rbx.platform.addrinfo.ai_canonname.offset", 24);
        configuration.config("rbx.platform.addrinfo.ai_canonname.size", 8);
        configuration.config("rbx.platform.addrinfo.ai_canonname.type", string(context, "string"));
        configuration.config("rbx.platform.addrinfo.ai_next.offset", 40);
        configuration.config("rbx.platform.addrinfo.ai_next.size", 8);
        configuration.config("rbx.platform.addrinfo.ai_next.type", string(context, "pointer"));
        configuration.config("rbx.platform.dirent.sizeof", 24);
        configuration.config("rbx.platform.dirent.d_ino.offset", 0);
        configuration.config("rbx.platform.dirent.d_ino.size", 8);
        configuration.config("rbx.platform.dirent.d_ino.type", string(context, "ino_t"));
        configuration.config("rbx.platform.dirent.d_reclen.offset", 16);
        configuration.config("rbx.platform.dirent.d_reclen.size", 2);
        configuration.config("rbx.platform.dirent.d_reclen.type", string(context, "ushort"));
        configuration.config("rbx.platform.dirent.d_name.offset", 18);
        configuration.config("rbx.platform.dirent.d_name.size", 1);
        configuration.config("rbx.platform.dirent.d_name.type", string(context, "char_array"));
        configuration.config("rbx.platform.timeval.sizeof", 16);
        configuration.config("rbx.platform.timeval.tv_sec.offset", 0);
        configuration.config("rbx.platform.timeval.tv_sec.size", 8);
        configuration.config("rbx.platform.timeval.tv_sec.type", string(context, "time_t"));
        configuration.config("rbx.platform.timeval.tv_usec.offset", 8);
        configuration.config("rbx.platform.timeval.tv_usec.size", 8);
        configuration.config("rbx.platform.timeval.tv_usec.type", string(context, "suseconds_t"));
        configuration.config("rbx.platform.sockaddr_in.sizeof", 16);
        configuration.config("rbx.platform.sockaddr_in.sin_family.offset", 0);
        configuration.config("rbx.platform.sockaddr_in.sin_family.size", 2);
        configuration.config("rbx.platform.sockaddr_in.sin_family.type", string(context, "sa_family_t"));
        configuration.config("rbx.platform.sockaddr_in.sin_port.offset", 2);
        configuration.config("rbx.platform.sockaddr_in.sin_port.size", 2);
        configuration.config("rbx.platform.sockaddr_in.sin_port.type", string(context, "ushort"));
        configuration.config("rbx.platform.sockaddr_in.sin_addr.offset", 4);
        configuration.config("rbx.platform.sockaddr_in.sin_addr.size", 4);
        configuration.config("rbx.platform.sockaddr_in.sin_zero.offset", 8);
        configuration.config("rbx.platform.sockaddr_in.sin_zero.size", 8);
        configuration.config("rbx.platform.sockaddr_in.sin_zero.type", string(context, "char_array"));
        configuration.config("rbx.platform.sockaddr_un.sizeof", 110);
        configuration.config("rbx.platform.sockaddr_un.sun_family.offset", 0);
        configuration.config("rbx.platform.sockaddr_un.sun_family.size", 2);
        configuration.config("rbx.platform.sockaddr_un.sun_family.type", string(context, "sa_family_t"));
        configuration.config("rbx.platform.sockaddr_un.sun_path.offset", 2);
        configuration.config("rbx.platform.sockaddr_un.sun_path.size", 108);
        configuration.config("rbx.platform.sockaddr_un.sun_path.type", string(context, "char_array"));
        configuration.config("rbx.platform.servent.sizeof", 32);
        configuration.config("rbx.platform.servent.s_name.offset", 0);
        configuration.config("rbx.platform.servent.s_name.size", 8);
        configuration.config("rbx.platform.servent.s_name.type", string(context, "pointer"));
        configuration.config("rbx.platform.servent.s_aliases.offset", 8);
        configuration.config("rbx.platform.servent.s_aliases.size", 8);
        configuration.config("rbx.platform.servent.s_aliases.type", string(context, "pointer"));
        configuration.config("rbx.platform.servent.s_port.offset", 16);
        configuration.config("rbx.platform.servent.s_port.size", 4);
        configuration.config("rbx.platform.servent.s_port.type", string(context, "int"));
        configuration.config("rbx.platform.servent.s_proto.offset", 24);
        configuration.config("rbx.platform.servent.s_proto.size", 8);
        configuration.config("rbx.platform.servent.s_proto.type", string(context, "pointer"));
        configuration.config("rbx.platform.stat.sizeof", 128);
        configuration.config("rbx.platform.stat.st_dev.offset", 0);
        configuration.config("rbx.platform.stat.st_dev.size", 8);
        configuration.config("rbx.platform.stat.st_dev.type", string(context, "dev_t"));
        configuration.config("rbx.platform.stat.st_ino.offset", 8);
        configuration.config("rbx.platform.stat.st_ino.size", 8);
        configuration.config("rbx.platform.stat.st_ino.type", string(context, "ino_t"));
        configuration.config("rbx.platform.stat.st_mode.offset", 16);
        configuration.config("rbx.platform.stat.st_mode.size", 4);
        configuration.config("rbx.platform.stat.st_mode.type", string(context, "mode_t"));
        configuration.config("rbx.platform.stat.st_nlink.offset", 20);
        configuration.config("rbx.platform.stat.st_nlink.size", 4);
        configuration.config("rbx.platform.stat.st_nlink.type", string(context, "nlink_t"));
        configuration.config("rbx.platform.stat.st_uid.offset", 24);
        configuration.config("rbx.platform.stat.st_uid.size", 4);
        configuration.config("rbx.platform.stat.st_uid.type", string(context, "uid_t"));
        configuration.config("rbx.platform.stat.st_gid.offset", 28);
        configuration.config("rbx.platform.stat.st_gid.size", 4);
        configuration.config("rbx.platform.stat.st_gid.type", string(context, "gid_t"));
        configuration.config("rbx.platform.stat.st_rdev.offset", 32);
        configuration.config("rbx.platform.stat.st_rdev.size", 8);
        configuration.config("rbx.platform.stat.st_rdev.type", string(context, "dev_t"));
        configuration.config("rbx.platform.stat.st_size.offset", 40);
        configuration.config("rbx.platform.stat.st_size.size", 8);
        configuration.config("rbx.platform.stat.st_size.type", string(context, "off_t"));
        configuration.config("rbx.platform.stat.st_blksize.offset", 96);
        configuration.config("rbx.platform.stat.st_blksize.size", 4);
        configuration.config("rbx.platform.stat.st_blocks.offset", 104);
        configuration.config("rbx.platform.stat.st_blocks.size", 8);
        configuration.config("rbx.platform.stat.st_atime.offset", 48);
        configuration.config("rbx.platform.stat.st_atime.size", 8);
        configuration.config("rbx.platform.stat.st_atime.type", string(context, "time_t"));
        configuration.config("rbx.platform.stat.st_mtime.offset", 64);
        configuration.config("rbx.platform.stat.st_mtime.size", 8);
        configuration.config("rbx.platform.stat.st_mtime.type", string(context, "time_t"));
        configuration.config("rbx.platform.stat.st_ctime.offset", 80);
        configuration.config("rbx.platform.stat.st_ctime.size", 8);
        configuration.config("rbx.platform.stat.st_ctime.type", string(context, "time_t"));
        configuration.config("rbx.platform.rlimit.sizeof", 16);
        configuration.config("rbx.platform.rlimit.rlim_cur.offset", 0);
        configuration.config("rbx.platform.rlimit.rlim_cur.size", 8);
        configuration.config("rbx.platform.rlimit.rlim_cur.type", string(context, "rlim_t"));
        configuration.config("rbx.platform.rlimit.rlim_max.offset", 8);
        configuration.config("rbx.platform.rlimit.rlim_max.size", 8);
        configuration.config("rbx.platform.rlimit.rlim_max.type", string(context, "rlim_t"));
        configuration.config("rbx.platform.file.O_RDONLY", 0);
        configuration.config("rbx.platform.file.O_WRONLY", 1);
        configuration.config("rbx.platform.file.O_RDWR", 2);
        configuration.config("rbx.platform.file.O_CREAT", 256);
        configuration.config("rbx.platform.file.O_EXCL", 1024);
        configuration.config("rbx.platform.file.O_NOCTTY", 2048);
        configuration.config("rbx.platform.file.O_TRUNC", 512);
        configuration.config("rbx.platform.file.O_APPEND", 8);
        configuration.config("rbx.platform.file.O_NONBLOCK", 128);
        configuration.config("rbx.platform.file.O_SYNC", 16);
        configuration.config("rbx.platform.file.S_IRUSR", 256);
        configuration.config("rbx.platform.file.S_IWUSR", 128);
        configuration.config("rbx.platform.file.S_IXUSR", 64);
        configuration.config("rbx.platform.file.S_IRGRP", 32);
        configuration.config("rbx.platform.file.S_IWGRP", 16);
        configuration.config("rbx.platform.file.S_IXGRP", 8);
        configuration.config("rbx.platform.file.S_IROTH", 4);
        configuration.config("rbx.platform.file.S_IWOTH", 2);
        configuration.config("rbx.platform.file.S_IXOTH", 1);
        configuration.config("rbx.platform.file.S_IFMT", 61440);
        configuration.config("rbx.platform.file.S_IFIFO", 4096);
        configuration.config("rbx.platform.file.S_IFCHR", 8192);
        configuration.config("rbx.platform.file.S_IFDIR", 16384);
        configuration.config("rbx.platform.file.S_IFBLK", 24576);
        configuration.config("rbx.platform.file.S_IFREG", 32768);
        configuration.config("rbx.platform.file.S_IFLNK", 40960);
        configuration.config("rbx.platform.file.S_IFSOCK", 49152);
        configuration.config("rbx.platform.file.S_IFWHT", 0);
        configuration.config("rbx.platform.file.S_ISUID", 2048);
        configuration.config("rbx.platform.file.S_ISGID", 1024);
        configuration.config("rbx.platform.io.SEEK_SET", 0);
        configuration.config("rbx.platform.io.SEEK_CUR", 1);
        configuration.config("rbx.platform.io.SEEK_END", 2);
        configuration.config("rbx.platform.fcntl.F_GETFL", 3);
        configuration.config("rbx.platform.fcntl.F_SETFL", 4);
        configuration.config("rbx.platform.fcntl.O_ACCMODE", 6291459);
        configuration.config("rbx.platform.socket.AF_APPLETALK", 16);
        configuration.config("rbx.platform.socket.AF_ATM", 0);
        configuration.config("rbx.platform.socket.AF_AX25", 0);
        configuration.config("rbx.platform.socket.AF_CCITT", 10);
        configuration.config("rbx.platform.socket.AF_CHAOS", 5);
        configuration.config("rbx.platform.socket.AF_CNT", 0);
        configuration.config("rbx.platform.socket.AF_COIP", 0);
        configuration.config("rbx.platform.socket.AF_DATAKIT", 9);
        configuration.config("rbx.platform.socket.AF_DEC", 0);
        configuration.config("rbx.platform.socket.AF_DLI", 13);
        configuration.config("rbx.platform.socket.AF_E164", 0);
        configuration.config("rbx.platform.socket.AF_ECMA", 8);
        configuration.config("rbx.platform.socket.AF_HYLINK", 15);
        configuration.config("rbx.platform.socket.AF_IMPLINK", 3);
        configuration.config("rbx.platform.socket.AF_INET", 2);
        configuration.config("rbx.platform.socket.AF_INET6", 26);
        configuration.config("rbx.platform.socket.AF_IPX", 23);
        configuration.config("rbx.platform.socket.AF_ISDN", 0);
        configuration.config("rbx.platform.socket.AF_ISO", 0);
        configuration.config("rbx.platform.socket.AF_LAT", 14);
        configuration.config("rbx.platform.socket.AF_LINK", 25);
        configuration.config("rbx.platform.socket.AF_LOCAL", 1);
        configuration.config("rbx.platform.socket.AF_MAX", 33);
        configuration.config("rbx.platform.socket.AF_NATM", 0);
        configuration.config("rbx.platform.socket.AF_NDRV", 0);
        configuration.config("rbx.platform.socket.AF_NETBIOS", 0);
        configuration.config("rbx.platform.socket.AF_NETGRAPH", 0);
        configuration.config("rbx.platform.socket.AF_NS", 6);
        configuration.config("rbx.platform.socket.AF_OSI", 19);
        configuration.config("rbx.platform.socket.AF_PPP", 0);
        configuration.config("rbx.platform.socket.AF_PUP", 4);
        configuration.config("rbx.platform.socket.AF_ROUTE", 24);
        configuration.config("rbx.platform.socket.AF_SIP", 0);
        configuration.config("rbx.platform.socket.AF_SNA", 11);
        configuration.config("rbx.platform.socket.AF_SYSTEM", 0);
        configuration.config("rbx.platform.socket.AF_UNIX", 1);
        configuration.config("rbx.platform.socket.AF_UNSPEC", 0);
        configuration.config("rbx.platform.socket.AI_ADDRCONFIG", 4);
        configuration.config("rbx.platform.socket.AI_ALL", 2);
        configuration.config("rbx.platform.socket.AI_CANONNAME", 16);
        configuration.config("rbx.platform.socket.AI_DEFAULT", 5);
        configuration.config("rbx.platform.socket.AI_MASK", 0);
        configuration.config("rbx.platform.socket.AI_NUMERICHOST", 32);
        configuration.config("rbx.platform.socket.AI_PASSIVE", 8);
        configuration.config("rbx.platform.socket.AI_V4MAPPED", 1);
        configuration.config("rbx.platform.socket.AI_V4MAPPED_CFG", 0);
        configuration.config("rbx.platform.socket.EAI_ADDRFAMILY", 1);
        configuration.config("rbx.platform.socket.EAI_AGAIN", 2);
        configuration.config("rbx.platform.socket.EAI_BADFLAGS", 3);
        configuration.config("rbx.platform.socket.EAI_BADHINTS", 0);
        configuration.config("rbx.platform.socket.EAI_FAIL", 4);
        configuration.config("rbx.platform.socket.EAI_FAMILY", 5);
        configuration.config("rbx.platform.socket.EAI_MAX", 14);
        configuration.config("rbx.platform.socket.EAI_MEMORY", 6);
        configuration.config("rbx.platform.socket.EAI_NODATA", 7);
        configuration.config("rbx.platform.socket.EAI_NONAME", 8);
        configuration.config("rbx.platform.socket.EAI_PROTOCOL", 13);
        configuration.config("rbx.platform.socket.EAI_SERVICE", 9);
        configuration.config("rbx.platform.socket.EAI_SOCKTYPE", 10);
        configuration.config("rbx.platform.socket.EAI_SYSTEM", 11);
        configuration.config("rbx.platform.socket.INADDR_ALLHOSTS_GROUP", 3758096385L);
        configuration.config("rbx.platform.socket.INADDR_ANY", 0);
        configuration.config("rbx.platform.socket.INADDR_BROADCAST", 4294967295L);
        configuration.config("rbx.platform.socket.INADDR_LOOPBACK", 2130706433);
        configuration.config("rbx.platform.socket.INADDR_MAX_LOCAL_GROUP", 3758096639L);
        configuration.config("rbx.platform.socket.INADDR_NONE", 4294967295L);
        configuration.config("rbx.platform.socket.INADDR_UNSPEC_GROUP", 3758096384L);
        configuration.config("rbx.platform.socket.IPPORT_RESERVED", 1024);
        configuration.config("rbx.platform.socket.IPPORT_USERRESERVED", 5000);
        configuration.config("rbx.platform.socket.IPPROTO_BIP", 0);
        configuration.config("rbx.platform.socket.IPPROTO_EGP", 8);
        configuration.config("rbx.platform.socket.IPPROTO_EON", 80);
        configuration.config("rbx.platform.socket.IPPROTO_GGP", 3);
        configuration.config("rbx.platform.socket.IPPROTO_HELLO", 63);
        configuration.config("rbx.platform.socket.IPPROTO_ICMP", 1);
        configuration.config("rbx.platform.socket.IPPROTO_IDP", 22);
        configuration.config("rbx.platform.socket.IPPROTO_IGMP", 2);
        configuration.config("rbx.platform.socket.IPPROTO_IP", 0);
        configuration.config("rbx.platform.socket.IPPROTO_MAX", 256);
        configuration.config("rbx.platform.socket.IPPROTO_ND", 77);
        configuration.config("rbx.platform.socket.IPPROTO_PUP", 12);
        configuration.config("rbx.platform.socket.IPPROTO_RAW", 255);
        configuration.config("rbx.platform.socket.IPPROTO_TCP", 6);
        configuration.config("rbx.platform.socket.IPPROTO_TP", 0);
        configuration.config("rbx.platform.socket.IPPROTO_UDP", 17);
        configuration.config("rbx.platform.socket.IPPROTO_XTP", 0);
        configuration.config("rbx.platform.socket.IPX_TYPE", 0);
        configuration.config("rbx.platform.socket.IP_ADD_MEMBERSHIP", 19);
        configuration.config("rbx.platform.socket.IP_DEFAULT_MULTICAST_LOOP", 1);
        configuration.config("rbx.platform.socket.IP_DEFAULT_MULTICAST_TTL", 1);
        configuration.config("rbx.platform.socket.IP_DROP_MEMBERSHIP", 20);
        configuration.config("rbx.platform.socket.IP_HDRINCL", 2);
        configuration.config("rbx.platform.socket.IP_MAX_MEMBERSHIPS", 0);
        configuration.config("rbx.platform.socket.IP_MULTICAST_IF", 16);
        configuration.config("rbx.platform.socket.IP_MULTICAST_LOOP", 18);
        configuration.config("rbx.platform.socket.IP_MULTICAST_TTL", 17);
        configuration.config("rbx.platform.socket.IP_OPTIONS", 1);
        configuration.config("rbx.platform.socket.IP_RECVDSTADDR", 7);
        configuration.config("rbx.platform.socket.IP_RECVOPTS", 5);
        configuration.config("rbx.platform.socket.IP_RECVRETOPTS", 6);
        configuration.config("rbx.platform.socket.IP_RETOPTS", 8);
        configuration.config("rbx.platform.socket.IP_TOS", 3);
        configuration.config("rbx.platform.socket.IP_TTL", 4);
        configuration.config("rbx.platform.socket.MSG_COMPAT", 0);
        configuration.config("rbx.platform.socket.MSG_CTRUNC", 16);
        configuration.config("rbx.platform.socket.MSG_DONTROUTE", 4);
        configuration.config("rbx.platform.socket.MSG_DONTWAIT", 128);
        configuration.config("rbx.platform.socket.MSG_EOF", 0);
        configuration.config("rbx.platform.socket.MSG_EOR", 8);
        configuration.config("rbx.platform.socket.MSG_FLUSH", 0);
        configuration.config("rbx.platform.socket.MSG_HAVEMORE", 0);
        configuration.config("rbx.platform.socket.MSG_HOLD", 0);
        configuration.config("rbx.platform.socket.MSG_OOB", 1);
        configuration.config("rbx.platform.socket.MSG_PEEK", 2);
        configuration.config("rbx.platform.socket.MSG_RCVMORE", 0);
        configuration.config("rbx.platform.socket.MSG_SEND", 0);
        configuration.config("rbx.platform.socket.MSG_TRUNC", 32);
        configuration.config("rbx.platform.socket.MSG_WAITALL", 64);
        configuration.config("rbx.platform.socket.NI_DGRAM", 16);
        configuration.config("rbx.platform.socket.NI_MAXHOST", 1025);
        configuration.config("rbx.platform.socket.NI_MAXSERV", 32);
        configuration.config("rbx.platform.socket.NI_NAMEREQD", 4);
        configuration.config("rbx.platform.socket.NI_NOFQDN", 1);
        configuration.config("rbx.platform.socket.NI_NUMERICHOST", 2);
        configuration.config("rbx.platform.socket.NI_NUMERICSERV", 8);
        configuration.config("rbx.platform.socket.PF_APPLETALK", 16);
        configuration.config("rbx.platform.socket.PF_AX25", 0);
        configuration.config("rbx.platform.socket.PF_CCITT", 10);
        configuration.config("rbx.platform.socket.PF_CHAOS", 5);
        configuration.config("rbx.platform.socket.PF_CNT", 0);
        configuration.config("rbx.platform.socket.PF_COIP", 0);
        configuration.config("rbx.platform.socket.PF_DATAKIT", 9);
        configuration.config("rbx.platform.socket.PF_DLI", 13);
        configuration.config("rbx.platform.socket.PF_ECMA", 8);
        configuration.config("rbx.platform.socket.PF_HYLINK", 15);
        configuration.config("rbx.platform.socket.PF_IMPLINK", 3);
        configuration.config("rbx.platform.socket.PF_INET", 2);
        configuration.config("rbx.platform.socket.PF_INET6", 26);
        configuration.config("rbx.platform.socket.PF_IPX", 23);
        configuration.config("rbx.platform.socket.PF_ISDN", 0);
        configuration.config("rbx.platform.socket.PF_ISO", 0);
        configuration.config("rbx.platform.socket.PF_KEY", 27);
        configuration.config("rbx.platform.socket.PF_LAT", 14);
        configuration.config("rbx.platform.socket.PF_LINK", 25);
        configuration.config("rbx.platform.socket.PF_LOCAL", 1);
        configuration.config("rbx.platform.socket.PF_MAX", 33);
        configuration.config("rbx.platform.socket.PF_NATM", 0);
        configuration.config("rbx.platform.socket.PF_NDRV", 0);
        configuration.config("rbx.platform.socket.PF_NETBIOS", 0);
        configuration.config("rbx.platform.socket.PF_NETGRAPH", 0);
        configuration.config("rbx.platform.socket.PF_NS", 6);
        configuration.config("rbx.platform.socket.PF_OSI", 19);
        configuration.config("rbx.platform.socket.PF_PIP", 0);
        configuration.config("rbx.platform.socket.PF_PPP", 0);
        configuration.config("rbx.platform.socket.PF_PUP", 4);
        configuration.config("rbx.platform.socket.PF_ROUTE", 24);
        configuration.config("rbx.platform.socket.PF_RTIP", 0);
        configuration.config("rbx.platform.socket.PF_SIP", 0);
        configuration.config("rbx.platform.socket.PF_SNA", 11);
        configuration.config("rbx.platform.socket.PF_SYSTEM", 0);
        configuration.config("rbx.platform.socket.PF_UNIX", 1);
        configuration.config("rbx.platform.socket.PF_UNSPEC", 0);
        configuration.config("rbx.platform.socket.PF_XTP", 0);
        configuration.config("rbx.platform.socket.SHUT_RD", 0);
        configuration.config("rbx.platform.socket.SHUT_RDWR", 2);
        configuration.config("rbx.platform.socket.SHUT_WR", 1);
        configuration.config("rbx.platform.socket.SOCK_DGRAM", 1);
        configuration.config("rbx.platform.socket.SOCK_PACKET", 0);
        configuration.config("rbx.platform.socket.SOCK_RAW", 4);
        configuration.config("rbx.platform.socket.SOCK_RDM", 5);
        configuration.config("rbx.platform.socket.SOCK_SEQPACKET", 6);
        configuration.config("rbx.platform.socket.SOCK_STREAM", 2);
        configuration.config("rbx.platform.socket.SOL_ATALK", 0);
        configuration.config("rbx.platform.socket.SOL_AX25", 0);
        configuration.config("rbx.platform.socket.SOL_IP", 0);
        configuration.config("rbx.platform.socket.SOL_IPX", 0);
        configuration.config("rbx.platform.socket.SOL_SOCKET", 65535);
        configuration.config("rbx.platform.socket.SOL_TCP", 0);
        configuration.config("rbx.platform.socket.SOL_UDP", 0);
        configuration.config("rbx.platform.socket.SOPRI_BACKGROUND", 0);
        configuration.config("rbx.platform.socket.SOPRI_INTERACTIVE", 0);
        configuration.config("rbx.platform.socket.SOPRI_NORMAL", 0);
        configuration.config("rbx.platform.socket.SO_ACCEPTCONN", 2);
        configuration.config("rbx.platform.socket.SO_ACCEPTFILTER", 0);
        configuration.config("rbx.platform.socket.SO_ATTACH_FILTER", 1073741825);
        configuration.config("rbx.platform.socket.SO_BINDTODEVICE", 0);
        configuration.config("rbx.platform.socket.SO_BROADCAST", 32);
        configuration.config("rbx.platform.socket.SO_DEBUG", 1);
        configuration.config("rbx.platform.socket.SO_DETACH_FILTER", 1073741826);
        configuration.config("rbx.platform.socket.SO_DONTROUTE", 16);
        configuration.config("rbx.platform.socket.SO_DONTTRUNC", 0);
        configuration.config("rbx.platform.socket.SO_ERROR", 4103);
        configuration.config("rbx.platform.socket.SO_KEEPALIVE", 8);
        configuration.config("rbx.platform.socket.SO_LINGER", 128);
        configuration.config("rbx.platform.socket.SO_NKE", 0);
        configuration.config("rbx.platform.socket.SO_NOSIGPIPE", 0);
        configuration.config("rbx.platform.socket.SO_NO_CHECK", 0);
        configuration.config("rbx.platform.socket.SO_NREAD", 0);
        configuration.config("rbx.platform.socket.SO_OOBINLINE", 256);
        configuration.config("rbx.platform.socket.SO_PASSCRED", 0);
        configuration.config("rbx.platform.socket.SO_PEERCRED", 0);
        configuration.config("rbx.platform.socket.SO_PEERNAME", 0);
        configuration.config("rbx.platform.socket.SO_PRIORITY", 0);
        configuration.config("rbx.platform.socket.SO_RCVBUF", 4098);
        configuration.config("rbx.platform.socket.SO_RCVLOWAT", 4100);
        configuration.config("rbx.platform.socket.SO_RCVTIMEO", 4102);
        configuration.config("rbx.platform.socket.SO_REUSEADDR", 4);
        configuration.config("rbx.platform.socket.SO_REUSEPORT", 4110);
        configuration.config("rbx.platform.socket.SO_SECURITY_AUTHENTICATION", 0);
        configuration.config("rbx.platform.socket.SO_SECURITY_ENCRYPTION_NETWORK", 0);
        configuration.config("rbx.platform.socket.SO_SECURITY_ENCRYPTION_TRANSPORT", 0);
        configuration.config("rbx.platform.socket.SO_SNDBUF", 4097);
        configuration.config("rbx.platform.socket.SO_SNDLOWAT", 4099);
        configuration.config("rbx.platform.socket.SO_SNDTIMEO", 4101);
        configuration.config("rbx.platform.socket.SO_TIMESTAMP", 4115);
        configuration.config("rbx.platform.socket.SO_TYPE", 4104);
        configuration.config("rbx.platform.socket.SO_USELOOPBACK", 64);
        configuration.config("rbx.platform.socket.SO_WANTMORE", 0);
        configuration.config("rbx.platform.socket.SO_WANTOOBFLAG", 0);
        configuration.config("rbx.platform.socket.TCP_MAXSEG", 2);
        configuration.config("rbx.platform.socket.TCP_NODELAY", 1);
        configuration.config("rbx.platform.process.WNOHANG", 64);
        configuration.config("rbx.platform.process.WUNTRACED", 4);
        configuration.config("rbx.platform.process.PRIO_PROCESS", 0);
        configuration.config("rbx.platform.process.PRIO_PGRP", 1);
        configuration.config("rbx.platform.process.PRIO_USER", 2);
        configuration.config("rbx.platform.process.RLIMIT_CPU", 0);
        configuration.config("rbx.platform.process.RLIMIT_FSIZE", 1);
        configuration.config("rbx.platform.process.RLIMIT_DATA", 2);
        configuration.config("rbx.platform.process.RLIMIT_STACK", 3);
        configuration.config("rbx.platform.process.RLIMIT_CORE", 4);
        configuration.config("rbx.platform.process.RLIMIT_RSS", 0);
        configuration.config("rbx.platform.process.RLIMIT_NPROC", 0);
        configuration.config("rbx.platform.process.RLIMIT_NOFILE", 5);
        configuration.config("rbx.platform.process.RLIMIT_MEMLOCK", 0);
        configuration.config("rbx.platform.process.RLIMIT_AS", 6);
        configuration.config("rbx.platform.process.RLIMIT_SBSIZE", 0);
        configuration.config("rbx.platform.process.RLIM_INFINITY", newBignum(context, "18446744073709551613"));
        configuration.config("rbx.platform.process.RLIM_SAVED_MAX", newBignum(context, "18446744073709551614"));
        configuration.config("rbx.platform.process.RLIM_SAVED_CUR", newBignum(context, "18446744073709551615"));
        configuration.config("rbx.platform.signal.SIGHUP", 1);
        configuration.config("rbx.platform.signal.SIGINT", 2);
        configuration.config("rbx.platform.signal.SIGQUIT", 3);
        configuration.config("rbx.platform.signal.SIGILL", 4);
        configuration.config("rbx.platform.signal.SIGTRAP", 5);
        configuration.config("rbx.platform.signal.SIGIOT", 6);
        configuration.config("rbx.platform.signal.SIGABRT", 6);
        configuration.config("rbx.platform.signal.SIGEMT", 7);
        configuration.config("rbx.platform.signal.SIGFPE", 8);
        configuration.config("rbx.platform.signal.SIGKILL", 9);
        configuration.config("rbx.platform.signal.SIGBUS", 10);
        configuration.config("rbx.platform.signal.SIGSEGV", 11);
        configuration.config("rbx.platform.signal.SIGSYS", 12);
        configuration.config("rbx.platform.signal.SIGPIPE", 13);
        configuration.config("rbx.platform.signal.SIGALRM", 14);
        configuration.config("rbx.platform.signal.SIGTERM", 15);
        configuration.config("rbx.platform.signal.SIGURG", 21);
        configuration.config("rbx.platform.signal.SIGSTOP", 23);
        configuration.config("rbx.platform.signal.SIGTSTP", 24);
        configuration.config("rbx.platform.signal.SIGCONT", 25);
        configuration.config("rbx.platform.signal.SIGCHLD", 18);
        configuration.config("rbx.platform.signal.SIGCLD", 18);
        configuration.config("rbx.platform.signal.SIGTTIN", 26);
        configuration.config("rbx.platform.signal.SIGTTOU", 27);
        configuration.config("rbx.platform.signal.SIGIO", 22);
        configuration.config("rbx.platform.signal.SIGXCPU", 30);
        configuration.config("rbx.platform.signal.SIGXFSZ", 31);
        configuration.config("rbx.platform.signal.SIGVTALRM", 28);
        configuration.config("rbx.platform.signal.SIGPROF", 29);
        configuration.config("rbx.platform.signal.SIGWINCH", 20);
        configuration.config("rbx.platform.signal.SIGUSR1", 16);
        configuration.config("rbx.platform.signal.SIGUSR2", 17);
        configuration.config("rbx.platform.signal.SIGLOST", 37);
        configuration.config("rbx.platform.signal.SIGMSG", 0);
        configuration.config("rbx.platform.signal.SIGPWR", 19);
        configuration.config("rbx.platform.signal.SIGPOLL", 22);
        configuration.config("rbx.platform.signal.SIGDANGER", 0);
        configuration.config("rbx.platform.signal.SIGMIGRATE", 0);
        configuration.config("rbx.platform.signal.SIGPRE", 0);
        configuration.config("rbx.platform.signal.SIGGRANT", 0);
        configuration.config("rbx.platform.signal.SIGRETRACT", 0);
        configuration.config("rbx.platform.signal.SIGSOUND", 0);
        configuration.config("rbx.platform.signal.SIGINFO", 0);
        configuration.config("rbx.platform.zlib.ZLIB_VERSION", string(context, "1.2.8-T4mods"));
        configuration.config("rbx.platform.typedef.lock_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.int8_t", string(context, "char"));
        configuration.config("rbx.platform.typedef.int16_t", string(context, "short"));
        configuration.config("rbx.platform.typedef.int32_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.int64_t", string(context, "long"));
        configuration.config("rbx.platform.typedef.uint8_t", string(context, "uchar"));
        configuration.config("rbx.platform.typedef.uint16_t", string(context, "ushort"));
        configuration.config("rbx.platform.typedef.uint32_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.uint64_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.intmax_t", string(context, "long"));
        configuration.config("rbx.platform.typedef.uintmax_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.intptr_t", string(context, "long"));
        configuration.config("rbx.platform.typedef.uintptr_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.int_fast8_t", string(context, "char"));
        configuration.config("rbx.platform.typedef.int_fast16_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.int_fast32_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.int_fast64_t", string(context, "long"));
        configuration.config("rbx.platform.typedef.uint_fast8_t", string(context, "uchar"));
        configuration.config("rbx.platform.typedef.uint_fast16_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.uint_fast32_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.uint_fast64_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.int_least8_t", string(context, "char"));
        configuration.config("rbx.platform.typedef.int_least16_t", string(context, "short"));
        configuration.config("rbx.platform.typedef.int_least32_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.int_least64_t", string(context, "long"));
        configuration.config("rbx.platform.typedef.uint_least8_t", string(context, "uchar"));
        configuration.config("rbx.platform.typedef.uint_least16_t", string(context, "ushort"));
        configuration.config("rbx.platform.typedef.uint_least32_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.uint_least64_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.longlong_t", string(context, "long_long"));
        configuration.config("rbx.platform.typedef.u_longlong_t", string(context, "ulong_long"));
        configuration.config("rbx.platform.typedef.t_scalar_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.t_uscalar_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.uchar_t", string(context, "uchar"));
        configuration.config("rbx.platform.typedef.ushort_t", string(context, "ushort"));
        configuration.config("rbx.platform.typedef.uint_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.ulong_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.daddr_t", string(context, "long"));
        configuration.config("rbx.platform.typedef.cnt_t", string(context, "short"));
        configuration.config("rbx.platform.typedef.ptrdiff_t", string(context, "long"));
        configuration.config("rbx.platform.typedef.pfn_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.pgcnt_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.spgcnt_t", string(context, "long"));
        configuration.config("rbx.platform.typedef.use_t", string(context, "uchar"));
        configuration.config("rbx.platform.typedef.sysid_t", string(context, "short"));
        configuration.config("rbx.platform.typedef.index_t", string(context, "short"));
        configuration.config("rbx.platform.typedef.off_t", string(context, "long"));
        configuration.config("rbx.platform.typedef.off64_t", string(context, "long"));
        configuration.config("rbx.platform.typedef.ino_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.blkcnt_t", string(context, "long"));
        configuration.config("rbx.platform.typedef.fsblkcnt_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.fsfilcnt_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.ino64_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.blkcnt64_t", string(context, "long"));
        configuration.config("rbx.platform.typedef.fsblkcnt64_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.fsfilcnt64_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.blksize_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.pad64_t", string(context, "long"));
        configuration.config("rbx.platform.typedef.upad64_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.offset_t", string(context, "long_long"));
        configuration.config("rbx.platform.typedef.u_offset_t", string(context, "ulong_long"));
        configuration.config("rbx.platform.typedef.len_t", string(context, "ulong_long"));
        configuration.config("rbx.platform.typedef.diskaddr_t", string(context, "ulong_long"));
        configuration.config("rbx.platform.typedef.k_fltset_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.id_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.lgrp_id_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.useconds_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.suseconds_t", string(context, "long"));
        configuration.config("rbx.platform.typedef.major_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.minor_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.pri_t", string(context, "short"));
        configuration.config("rbx.platform.typedef.cpu_flag_t", string(context, "ushort"));
        configuration.config("rbx.platform.typedef.o_mode_t", string(context, "ushort"));
        configuration.config("rbx.platform.typedef.o_dev_t", string(context, "short"));
        configuration.config("rbx.platform.typedef.o_uid_t", string(context, "ushort"));
        configuration.config("rbx.platform.typedef.o_gid_t", string(context, "ushort"));
        configuration.config("rbx.platform.typedef.o_nlink_t", string(context, "short"));
        configuration.config("rbx.platform.typedef.o_pid_t", string(context, "short"));
        configuration.config("rbx.platform.typedef.o_ino_t", string(context, "ushort"));
        configuration.config("rbx.platform.typedef.key_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.mode_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.uid_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.gid_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.datalink_id_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.vrid_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.taskid_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.projid_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.poolid_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.zoneid_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.ctid_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.pthread_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.pthread_key_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.dev_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.nlink_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.pid_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.size_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.ssize_t", string(context, "long"));
        configuration.config("rbx.platform.typedef.time_t", string(context, "long"));
        configuration.config("rbx.platform.typedef.clock_t", string(context, "long"));
        configuration.config("rbx.platform.typedef.clockid_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.timer_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.unchar", string(context, "uchar"));
        configuration.config("rbx.platform.typedef.ushort", string(context, "ushort"));
        configuration.config("rbx.platform.typedef.uint", string(context, "uint"));
        configuration.config("rbx.platform.typedef.ulong", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.u_char", string(context, "uchar"));
        configuration.config("rbx.platform.typedef.u_short", string(context, "ushort"));
        configuration.config("rbx.platform.typedef.u_int", string(context, "uint"));
        configuration.config("rbx.platform.typedef.u_long", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.hrtime_t", string(context, "long_long"));
        configuration.config("rbx.platform.typedef.fd_mask", string(context, "long"));
        configuration.config("rbx.platform.typedef.fds_mask", string(context, "long"));
        configuration.config("rbx.platform.typedef.mrpid_t", string(context, "int"));
        configuration.config("rbx.platform.typedef.memsize_t", string(context, "ulong_long"));
        configuration.config("rbx.platform.typedef.memtime_sec_t", string(context, "long_long"));
        configuration.config("rbx.platform.typedef.sa_family_t", string(context, "ushort"));
        configuration.config("rbx.platform.typedef.socklen_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.nfds_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.disp_lock_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.model_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.in_port_t", string(context, "ushort"));
        configuration.config("rbx.platform.typedef.in_addr_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.ipaddr_t", string(context, "uint"));
        configuration.config("rbx.platform.typedef.rlim_t", string(context, "ulong"));
        configuration.config("rbx.platform.typedef.rlim64_t", string(context, "ulong_long"));
    }
}
