package org.jruby.truffle.parser.parser;

public class YyTables {
   private static short[] combine(short[] t1, short[] t2, 
                                  short[] t3, short[] t4) {
      short[] t = new short[t1.length + t2.length + t3.length + t4.length];
      int index = 0;
      System.arraycopy(t1, 0, t, index, t1.length);
      index += t1.length;
      System.arraycopy(t2, 0, t, index, t2.length);
      index += t2.length;
      System.arraycopy(t3, 0, t, index, t3.length);
      index += t3.length;
      System.arraycopy(t4, 0, t, index, t4.length);
      return t;
   }

   public static final short[] yyTable() {
      return combine(yyTable1(), yyTable2(), yyTable3(), yyTable4());
   }

   public static final short[] yyCheck() {
      return combine(yyCheck1(), yyCheck2(), yyCheck3(), yyCheck4());
   }
   private static final short[] yyTable1() {
      return new short[] {

          306,  379,  309,   89,   89,  135,  135,  255,  258,  303, 
          251,  251,  251,   84,   84,  277,  251,  251,  308,  355, 
          251,  108,  419,  215,  421,  466,  488,  261,  428,  636, 
          353,  632,  325,  640,  716,  229,  645,  231,  678,  527, 
          703,  216,  216,  529,  697,  649,   89,  293,  293,  768, 
          351,  293,  251,  630,  643,  229,  676,  231,  632,  631, 
          677,  743,  216,  289,  289,  643,  579,  289,  715,  361, 
          748,  715,  692,  716,  632,  807,  640,   74,  441,  332, 
          336,  632,  305,  662,  871,  123,  706,  216,  820,   87, 
          677,  827,  869,  436,  643,  434,  740,  431,  830,  257, 
          579,  351,  643,  643,  548,  836,   73,  577,    8,  571, 
          134,  134,   75,  563,  643,  579,  944,  302,    8,  725, 
          134,  261,  305,  885,  677,  578,  589,  752,   72,  388, 
          251,  515,   89,  832,  123,  298,  848,  602,  292,  292, 
         1018,  577,  292,  571,  432,  737,   87,  315,  256,  677, 
          394,  643,  643,  548, 1032,  134,  577,  778,  571,  578, 
          589,  757,  563,   73,  257,  563,  435,    8,  761,  763, 
          331,  257,  643,  344,  578,  589,  563,  524,  388,  638, 
          586,  107,  107,  501,  462,  311,  602,  409,  107,  107, 
          107,  780,  524,  301,  107,  107,  644,  638,  107,  394, 
          377,  643,  941,  433,  409,  377,  134,  450,  773,  302, 
          476,  523,  305,  256,  273,  451,  257,  800,  643,  597, 
          256,  275,  344,  311,  107,  563,  526,  961,  643,  488, 
          107,  758,  437,  433,  602,  563,   89,  632,  656,  305, 
          771,  274,  774, 1018,  387,  810,  510,  812, 1032,  563, 
          467,  502,  503,  597,  632,  748,  857,  381,   84,  471, 
          472,  374,  806,  251,  251,  256,  301,  716,  597,  944, 
          316,   76,  811, 1049,  261,  871,  402,  643,  531,  869, 
          404,  405,  378,  602,  535,   82,  898,  378, 1012,  379, 
          382,  552,  905,  377,  869,  819,  553,  468,  366,  251, 
          380,  251,  251,  715,  715,  251,  325,  251,  107,   84, 
          107,  375,   89,  517,  378,  376,  591,  368,   89,   80, 
           89,  592,   76,  571,   73,   77,  320,  439,  513,  251, 
          293,  440,  293,  385,  386, 1004,   82,  261,   85,  815, 
          958,  844,  123,  372,  822,  819,  289,  965,  289,  289, 
          577,  351,  969,  565,  566,  435,  457,  571,  632, 1047, 
          518,  911,  385,  386,  632,  748,  913,  748,  476,   78, 
           80,  586,  571,  476,  643,  643,   77,  595,  596,  597, 
          598,  251,  251,  251,  251,   89,  251,  251,  869,   85, 
          374,  646,  675,  650, 1078,  599,  413,  660,  664,  548, 
          537,  538,  577,  435,   53,  936,  643,  540,  658,   74, 
          435,  435,  320,  325,  107,  579,  630,  649,  643,  251, 
           78,  292,  631,  292,  251,  423,  251,   89,  351,  643, 
          251,  251,  643,   89,  643,  700,  548,  435,  424,  577, 
          846,  107,  107,   84,   75,  563,  251,  840,   89,  251, 
          666,  748, 1014,  304,  641,  948,  134,  641,  571,   89, 
          952,  954,  251,  956,  531,  957,  289,   89,  833,  548, 
         1085,    8,  577,  457,  578,  589,  251,  107,  388,  107, 
          107,  641,  425,  107,  716,  107,  602,  702,  702,  586, 
          107,  586,  429,  289, 1062,  723,  107,  641,  107,  394, 
           93,   93,  136,  136,  643,  983,  251,  107,   89,  289, 
         1006,  641,  278,  304,  597,  642,  714,  311,   84,   89, 
          748,  715,  748,  289,   96,   96,   83,   84,  644,  602, 
          430,  644,  229,  134,  231,  251,  279,  351,   17,  216, 
           76,  577,  642,   93,   81,  641,  273,  352,  655,  273, 
          442,  597,  655,  275,   82,  733,  275,  748,  642,  107, 
          107,  107,  107,  107,  107,  107,  602,   96,  597,  586, 
          641,  586,  642,  274,  840, 1038,  274,   83,  456,  537, 
          538,  563,  289,  889,  597,  531,  540,   17,   80,  381, 
           84,  698,  508,  374,   77,   81,  453,  107,  352,  602, 
          320,  779,  107,   76,  107,  107,  642,   85,  107,  107, 
          786,  107, 1051, 1053, 1054, 1055,  463,   82,  571,   16, 
          784,  379,  382,  464,  107,  377,  107,  107,  790,   93, 
           79,  642,  380,  793,  465,  468,  470,  107,   78,  473, 
          107,  643,  134,  375,  643,  107,  378,  376,  477,  483, 
          786,   80, 1071,   96,  107,  571,  677,   77,  351,  577, 
          445,  577,  847,  444,  444,  484,  786,  805,   16,  444, 
           85,  251,   89, 1087,  418,  814,  445,  487,   97,  507, 
          786,   79,   89,  587,  107,  804,  107,  387,  571,  643, 
          643,  478, 1001,  643,  286,  511,  478,  107, 1003,  499, 
          813,   78,  103,  103,  512,  516,  837,  320,  415,  445, 
          251,  786,  229,  107,  231,  416,  420,  587,  216,  216, 
          907,  519,  520,  330,  334,  643,  861,  522,  783,  531, 
           89,  528,  587,   93,  530,  351,  789,  643,  643,  688, 
           84,  789,  536,  850,  851,  103,  852,  696,  861,  894, 
          896,  841,  547,  659,  551,  901,  903,   96,   89,   89, 
          587,  117,  586,  134,  590,  650,  667,  505,  305,  643, 
          783,  889,  685,  789,  643,  889,  643,   89,  680,   89, 
          689,   89,  251,  251,  687,  699,  643,  718,  251,  251, 
           17,   17,   17,  719,  720,   83,   17,   17,  251,   17, 
          290,  296,  351,  726,  297,  116,  729,  734,  655,   93, 
          117,   59,   60,   81,  745,   93,  755,   93,  643,  928, 
           89,  915,  760,  251,  753,  643,  770,  559,  919,  754, 
          762,  103,  560,   96,   89,   89,   89,  764,  766,   96, 
          134,   96,  517,   61,   62,   63,   64,  511,  352,  107, 
          107,  461,  861,  702,  116,  537,  538,  539,   83,  767, 
          107,  772,  540,  781,  782,  565,  566,  979,  475,  889, 
           17,   16,   16,   16,  787,  788,   81,   16,   16,  797, 
           16,  511,   93,  798,  717,  801,  516,  808,  107,  973, 
          831,   17,  721,  722,  819,  856,  511,  461,  643,   79, 
          251,  643,  567,  825,  826,  828,   96,  134,  107,  829, 
          730,  415,  108,  415,   89,   89,   17,  445,  416,  417, 
          416,  444,  998,  843,   93,  352,   89,  858,  511,  892, 
           93, 1042,  899,  900,  916,  103,  107,  107,  249,  249, 
          249,  918,  643,  643,  921,   93,  108,  654,   96,  925, 
          930,   16,  929,  931,   96,  107,   93,  107,  937,  107, 
          107,  107,   79,  108,   93,  938,  107,  107,  942,   96, 
          643,  945,   16,  950,  946, 1035,  107,  494,  587,  643, 
           96,  947,  949,  951,  643,   89,  643,  953,   96,  445, 
         1050,  643,  955,  314,  134,  643,  643,   16,  107,  959, 
          962,  107,   89,  964,   89,   93,  966,  968,  534,  975, 
           89,  103,  107,  107,  107,  587,   93,  103,  117,  103, 
           98,  643,  643,  643,  537,  538,  974,  134,  643,   96, 
          643,  540,  587,  978,  352,  643,  545,  976,  865,  866, 
           96, 1011,  251, 1007, 1008,  786, 1025,   89,  587,  445, 
         1033,  799, 1037, 1036,   98, 1048, 1039,  890,  438,  891, 
         1052,  893,  116, 1056,  554, 1058,  555,  556,  557,  558, 
          559,   98, 1060,  127,  809,  560, 1063,  641,  107,  517, 
          134, 1041, 1086,  489,  103,  492,  517,  517,  415,  289, 
         1068, 1076,  107,  107,  494,  416,  460, 1089,  561,  630, 
          924,  517,  643, 1013,  107,  415,  563,  564,  565,  566, 
          643,  632,  416,  474,  933,  934,  935,  614,  631,  842, 
          636,  494,  127,  516,  636,  632,  103,  845,  632,  638, 
          516,  516,  103,  643,  415,  632,  514,  494,  642,  376, 
          481,  416,  509,  364,  589,  567,  859,  103,  138, 1075, 
          731,  494,  218,  794,  314,  352,  984,  554,  103,  555, 
          556,  557,  558,  107,  868,  511,  103,  880,  906,   93, 
          514,  873,  511,  511, 1028, 1027,  387,   97,  614,   93, 
          107,  108,  107,   97,  280,  514, 1074,  314,  107,  855, 
          621,  249,  249,   96,  982, 1079,  511,    0,    0,  614, 
            0,    0,    0,   96,    0,  917, 1002,  103,  402,    0, 
          494,   97,  404,  405,  406,  407,  333,  514,  103,    0, 
          107,  314,    0,    0,  621,  107,    0,   93,   97,    0, 
          314,    0,  352,  498,    0,  500,  314,  314,  314,  621, 
          854,    0,    0,  618,  108,  415,    0,    0,    0,    0, 
          940,   96,  416,  533,  108,   93,   93,  521,  516,  537, 
          538,  542,    0,  867,    0,  870,  540,    0,  314,  777, 
          777,  621,    0,    0,   93,    0,   93,  877,   93,   96, 
           96,    0, 1043,    0, 1044,  286,  415,    0,    0,   98, 
         1045,    0,    0,  416, 1034,  286,    0,    0,   96,  352, 
           96,  314,   96,   99,  777,    0,  537,  538,  542,  249, 
          249,  249,  249,  540,  600,  601,  792,   93,  415,  654, 
            0,  792,    0,    0,  710,  416, 1040, 1077,    0,  286, 
          127,   93,   93,   93,    0,    0,    0,   99,  517,    0, 
            0,   96,    0,    0,  286,  517,  517,    0,  294,    0, 
            0,  118,   98,  792,   99,   96,   96,   96,  294,    0, 
            0,  818,  821,    0,  821,  554,    0,  555,  556,  557, 
          558,  103,  821,  537,  538,  544,    0,  679,    0,    0, 
          540,  103,    0,    0,  518,    0,  136,    0,    0,  288, 
          288,  314,  287,  288,    0,    0,  119,    0,  314,  314, 
          118,  387,    0,  875,  618,   97,  615,  294,    0,    0, 
            0,   93,   93,  887,    0,  312,  314,  400,  401,  999, 
            0,  288,  288,   93,  354,  356,    0,    0,    0,  103, 
            0,    0,  518,  402,  724,   96,   96,  404,  405,  406, 
          407,    0,    0, 1000,    0,  119,   97,   96,    0,    0, 
          478,  479,  480,    0,  514,  482, 1020,  103,  103,    0, 
          621,  514,  514,   53,    0, 1026,    0,  615,    0, 1030, 
            0,    0,  136,   53,    0,    0,  103,  519,  103,  777, 
          103,    0,   93,    0,    0,  514,    0,    0,  615,  127, 
          537,  538,  548,  923,    0,  516,  927,  540,    0,   93, 
            0,   93,  516,  516,    0,  314,   96,   93,  621,   97, 
            0,    0,  314,  314,    0,  621,  621,    0,  618,  103, 
            0,  617,   53,   96,    0,   96,    0,  230,    0,    0, 
            0,   96,    0,  103,  103,  103,  314,  230,  314,  621, 
            0,    0,  621,    0,   93,  314,  314,  286,  286,  286, 
            0,  618,  286,  286,  286,    0,  286,  554,  121,  555, 
          556,  557,  558, 1082,    0,    0,  286,  286,   96,    0, 
            0,  230,   99,  111,    0,  286,  286,    0,  286,  286, 
          286,  286,  286,    0,    0,  230,  230,  537,  538,  588, 
          230,  746,    0,  653,  540,    0,    0,  663,  887,  249, 
            0,  887,    0, 1029,    0,  887,    0,  121,  118,  821, 
          294,  294,  294,  103,  103,  294,  294,  294,    0,  294, 
            0,  518,  111,    0,    0,  103,    0,  286,  518,  518, 
          286,    0,  286,    0,    0,   99,  653,    0,  249,  521, 
            0,  294,  294,  294,  294,  294,    0,    0,  286,    0, 
            0,  711,  713,  119,  511,  333,  288,  288,  288,  356, 
          240,  288, 1015,    0,  555,  556,  557,  558,    0,  518, 
          240,    0,  288,  286,  288,  288,  518,  518,  482,  482, 
          482,    0,    0,  506,  103,  482,    0,  294,    0,    0, 
          294,  713,    0,    0,  333,  887,    0,  887,    0,  887, 
            0,  103,  887,  103,  240,    0,  114,    0,    0,  103, 
            0,  294,    0,    0,  519,    0,    0,  494,  240,  240, 
          821,  519,  519,  240,    0,   53,   53,   53,  887,    0, 
           53,   53,   53,    0,   53,    0,  294,    0,  464,  464, 
          464,  470,  470,  470,   53,  464,  103,    0,  470,    0, 
            0,  249,    0,  769,    0,  114,   53,   53,   53,   53, 
           53,  602,  603,  604,  605,  606,  607,  608,  609,  610, 
          611,  612,  613,  614,  615,  616,  617,  618,  619,  620, 
          621,  622,  623,  624,  625,  626,  627,  514,    0,  230, 
          230,  230,  288,    0,  230,  230,  230,  647,  230,  651, 
            0,    0,    0,  288,  665,   53,    0,    0,  230,  230, 
          380,  381,  382,  383,  384,  121,  795,  230,  230,  288, 
          230,  230,  230,  230,  230,    0,   53,    0,    0,    0, 
          111,    0,  230,    0,    0,  288,    0,  647,  695,  665, 
            0,    0,  288,  614,    0,    0,    0,    0,    0,  288, 
            0,   53,    0,  816,    0,   52,  120,  288,  288,   92, 
            0,  288,  104,    0,    0,   52,  230,    0,    0,  230, 
          862,    0,  230,   98,  230,    0,  521,  872,  838,    0, 
          839,    0,    0,  521,  521,  727,  728,  713,  333,  879, 
          230,  511,    0,   92,    0,    0,  104,  288,  511,  511, 
          288,    0,  230,    0,  614,  120,    0,    0,  288,    0, 
           92,  122,    0,  104,   52,  230,    0,    0,    0,    0, 
          517,  207,  240,  240,  240,  614,    0,  240,  240,  240, 
          554,  240,  555,  556,  557,  558,    0,  520,  876,  125, 
          511,  240,  240,  435,    0,    0,    0,    0,    0,    0, 
          240,  240,    0,  240,  240,  240,  240,  240,    0,  288, 
          122,  100,    0,  114,  746,  240,  910,    0,    0,    0, 
          207,    0,  747,    0,    0,    0,  615,    0,  240,  240, 
          240,  240,  240,  240,  240,  240,  240,  240,  125,  240, 
          240,    0,  522,  240,  240,  100,    0,   97,    0,  240, 
          932,    0,  240,    0,    0,  240,    0,  240,    0,  240, 
           99,  240,  100,  240,  240,  240,  240,  240,  240,  240, 
          621,  240,  288,  240,  514,    0,    0,    0,    0,    0, 
            0,  514,  514,    0,    0,  240,    0,  615,    0,    0, 
            0,    0,  519,    0,  516,    0,    0,    0,  240,    0, 
            0,  511,    0,    0,    0,    0,    0,  518,  615,  288, 
            0,  511,    0,    0,    0,    0, 1019,    0, 1021,    0, 
         1022,    0,    0,    0, 1023,    0,    0,  981,    0,    0, 
            0, 1031,    0,    0,  288,    0,  288,    0,    0,    0, 
            0,    0,    0,  288,  288,  511,  554,    0,  555,  556, 
          557,  558,    0,    0,    0,  333,    0,    0,  117,  511, 
          511,    0,  111,  120,  511,    0,    0,   52,   52,   52, 
            0,    0,   52,   52,   52,    0,   52,    0,   92,  614, 
          746,  104,  435,    0,    0,    0,   52,    0,  943,    0, 
            0,    0,  511,    0,  288,   52,   52,    0,   52,   52, 
           52,   52,   52,    0,    0,  895,  897,  517,    0,    0, 
            0,  902,  904,    0,  517,  517,    0, 1080,  122,    0, 
          908,  695,  288, 1081,  520, 1083,  912,  511, 1084,    0, 
          435,  520,  520,  514,  511,  511,    0,  435,  435,    0, 
          614,   92,    0,  514,  104,    0,  125,   52,    0,  895, 
          897,    0,  902,  904, 1093,    0,  288,    0,    0,  621, 
            0,  614,    0,    0,  435,    0,    0,  207,   52,  207, 
          207,  207,  207,  207,    0,    0,    0,  514,  207,  522, 
          100,    0,  116,    0,    0,    0,  522,  522,    0,  517, 
            0,  514,  514,   52,  114,  118,  514,  517,    0,    0, 
            0,  207,  207,    0,    0,    0,    0,  621,    0,  207, 
          207,  207,  207,    0,  621,  621,  977,    0,    0,    0, 
          617,    0,    0,  980,  514,    0,    0,    0,    0,  519, 
            0,  516,    0,  288,    0,    0,  519,  519,  516,  516, 
            0,  621,    0,  100,  518,    0,    0,    0,  207,    0, 
            0,  518,  518,  200,  980,    0,    0,    0,  614,  614, 
          614,  288,  614,  511,  511,  511,  614,  614,  511,  511, 
          511,  614,  511,  614,  614,  614,  614,  614,  614,  614, 
            0,  614,  511,  511,  614,  614,  614,  614,  614,  614, 
          614,  511,  511,  614,  511,  511,  511,  511,  511,    0, 
          614,    0,  200,  614,  614,  614,  511,  614,  614,  614, 
          614,  614,  614,  614,  614,  614,  614,  614,  511,  511, 
          511,  511,  511,  511,  511,  511,  511,  511,  511,  511, 
          511,  511,    0,    0,  511,  511,  511,  511,  614,  523, 
          511,  614,  614,  511,  614,  614,  511,  614,  511,  614, 
          511,  614,  511,  614,  511,  511,  511,  511,  511,  511, 
          511,  614,  511,  614,  511,  288,  614,  614,  614,  614, 
          614,  614,    0,    0,    0,  614,  511,  614,  614,    0, 
          614,  614,  614,  614,  113,  210,  614,  614,  614,  511, 
          615,  615,  615,    0,  615,  514,  514,  514,  615,  615, 
          514,  514,  514,  615,  514,  615,  615,  615,  615,  615, 
          615,  615,    0,  615,  514,  514,  615,  615,  615,  615, 
          615,  615,  615,  514,  514,  615,  514,  514,  514,  514, 
          514,    0,  615,  113,  210,  615,  615,  615,  514,  615, 
          615,  615,  615,  615,  615,  615,  615,  615,  615,  615, 
          514,  514,  514,  514,  514,  514,  514,  514,  514,  514, 
          514,  514,  514,  514,    0,  513,  514,  514,  514,  514, 
          615,  526,  514,  615,  615,  514,  615,  615,  514,  615, 
          514,  615,  514,  615,  514,  615,  514,  514,  514,  514, 
          514,  514,  514,  615,  514,  615,  514,    0,  615,  615, 
          615,  615,  615,  615,    0,    0,  621,  615,  514,  615, 
          615,    0,  615,  615,  615,  615,  621,    0,  615,  615, 
          615,  514,    0,    0,    0,  543,    0,  546,  963,  549, 
            0,    0,  967,    0,    0,  549,  630,  630,  630,    0, 
            0,    0,  630,  630,    0,  630,    0,    0,    0,  200, 
          621,  200,  200,  200,  200,  200,    0,    0,    0,    0, 
          200,    0,    0,    0,  621,  621,    0,  125,    0,  621, 
          387,  516,    0,    0,    0,    0,    0,    0,    0,  516, 
            0,    0,    0,  200,  200,    0,  400,  401,    0,    0, 
            0,  200,  200,  200,  200,    0,    0,  621,    0,    0, 
            0,    0,  402,    0,  403,    0,  404,  405,  406,  407, 
            0,    0,    0,  631,  631,  631,  630,    0,    0,  631, 
          631,    0,  631,  554,    0,  555,  556,  557,  558,  559, 
          200,    0,    0,    0,  560,    0,    0,  630,  617,    0, 
            0,  113,    0,  543,    0,    0,    0,    0,  617,    0, 
            0,    0,    0,    0,    0,    0,    0,  561,  562,    0, 
            0,    0,  630,    0,    0,  563,  564,  565,  566,    0, 
            0,    0, 1057,    0,    0, 1059, 1061,    0,    0, 1064, 
         1065,  210,  617,  210,  210,  210,  210,  210,    0,    0, 
            0,    0,  210,  631,    0,    0,  617,  617,    0,  124, 
            0,  617,  513,  518,  567,    0,    0,    0,    0,  513, 
          513,  518,  744,    0,  631,  210,  210,    0,    0,    0, 
            0,    0,    0,  210,  210,  210,  210,    0,    0,  617, 
         1088, 1090, 1091, 1092,    0,    0,    0,    0,    0,  631, 
            0,    0, 1094,    0,    0,    0,    0,    0,    0,    0, 
            0,  744,    0,    0,    0,    0,    0,    0,  195,    0, 
            0,    0,  210,  617,  617,  617,    0,  617,  621,  621, 
          621,  617,  617,  621,  621,  621,  617,  621,  617,  617, 
          617,  617,  617,  617,  617,    0,  621,  621,  621,  617, 
          617,  617,  617,  617,  617,  617,  621,  621,  617,  621, 
          621,  621,  621,  621,    0,  617,    0,  195,  617,  617, 
          617,  621,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  621,  621,  621,  621,  621,  621,  621, 
          621,  621,  621,  621,  621,  621,  621,    0,    0,  621, 
          621,  621,  621,  617,  888,  621,  617,  617,  621,  617, 
          617,  621,  617,  621,  617,  621,  617,  621,  617,  621, 
          621,  621,  621,  621,  621,  621,  617,  621,  621,  621, 
          100,  617,  617,  617,  617,  617,  617,    0,    0,    0, 
          617,  621,  617,  617,    0,  617,  617,  617,  617,  112, 
          177,  617,  617,  617,  621,  617,  617,  617,    0,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  519,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,    0,  617,  112,  177, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  102, 
          512,  617,  617,  617,  617,  617,    0,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,    0,  617,  617,  617,  617,  617,  617,    0, 
            0,  618,  617,  617,  617,  617,  521,  617,  617,  617, 
          617,  618,    0,  617,  617,  617,  617,    0,    0,  888, 
            0,    0,  888,    0,  888,    0,  888,  554,    0,  555, 
          556,  557,  558,  559,    0,    0,    0,    0,  560,    0, 
            0,    0,    0,    0,  195,  618,  195,  195,  195,  195, 
          195,    0,    0,    0,    0,  195,    0,    0,    0,  618, 
          618,  561,  126,    0,  618,    0,  519,    0,    0,  563, 
          564,  565,  566,    0,  519,    0,    0,    0,  195,  195, 
            0,    0,    0,    0,    0,    0,  195,  195,  195,  195, 
            0,    0,  618,    0,  554,  119,  555,  556,  557,  558, 
          559,    0,    0,    0,    0,  560,    0,    0,  567,    0, 
            0,    0,    0,    0,    0,    0,  888,    0,  888,    0, 
          888,    0,    0,  888,  387,  195,    0,    0,  561,  392, 
          393,    0,    0,  305,    0,    0,  112,    0,  565,  566, 
          400,  401,    0,  305,  519,    0,    0,    0,    0,  888, 
            0,  519,  519,    0,    0,    0,  402,    0,  403,    0, 
          404,  405,  406,  407,  408,  409,  410,    0,  411,    0, 
            0,    0,    0,    0,    0,  567,  177,  305,  177,  177, 
          177,  177,  177,    0,    0,    0,    0,  177,    0,    0, 
            0,  305,  305,    0,  121,    0,  305,  512,  521,    0, 
          387,    0,    0,    0,  512,  512,  521,    0,    0,    0, 
          177,  177,    0,    0,    0,    0,  400,  401,  177,  177, 
          177,  177,    0,    0,  305,    0,    0,    0,    0,    0, 
            0,    0,  402,    0,  403,    0,  404,  405,  406,  407, 
            0,    0,  410,  521,  411,    0,    0,    0,    0,    0, 
          521,  521,    0,  178,    0,    0,    0,  177,  618,  618, 
          618,    0,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
            0,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,    0, 
          618,    0,  178,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,   92,    0,  618,  618,  618,  618,  618,    0, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  101,  618,  618,  618,  618, 
          618,  618,    0,    0,    0,  618,  618,  618,  618,  511, 
          618,  618,  618,  618,  115,  179,  618,  618,  618,  618, 
          616,  616,  616,    0,  616,  305,  305,  305,  616,  616, 
          305,  305,  305,  616,  305,  616,  616,  616,  616,  616, 
          616,  616,  520,  616,  305,  305,  616,  616,  616,  616, 
          616,  616,  616,  305,  305,  616,  305,  305,  305,  305, 
          305,    0,  616,  115,  179,  616,  616,  616,  305,  616, 
          616,  616,  616,  616,  616,  616,  616,  616,  616,  616, 
          305,  305,  305,  305,  305,  305,  305,  305,  305,  305, 
          305,  305,  305,  305,  103,  515,  305,  305,  305,  305, 
          616,    0,  305,  616,  616,  305,  616,  616,  305,  616, 
          305,  616,  305,  616,  305,  616,  305,  305,  305,  305, 
          305,  305,  305,  616,  305,  616,  305,    0,  616,  616, 
          616,  616,  616,  616,    0,    0,  622,  616,  305,  616, 
          616,  522,  616,  616,  616,  616,  622,    0,  616,  616, 
          616,  305,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  178, 
          622,  178,  178,  178,  178,  178,    0,    0,    0,    0, 
          178,    0,    0,    0,  622,  622,    0,  111,  614,  622, 
            0,  520,    0,    0,    0,    0,    0,    0,    0,  520, 
            0,    0,    0,  178,  178,    0,    0,    0,    0,    0, 
            0,  178,  178,  178,  178,    0,    0,  622,    0,    0, 
          120,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  511,    0,    0,    0, 
            0,    0,    0,  511,  511,    0,    0,    0,    0,  614, 
          178,    0,    0,    0,    0,    0,    0,    0,  623,    0, 
            0,  115,    0,    0,    0,    0,    0,    0,  623,  520, 
          614,    0,    0,    0,    0,    0,  520,  520,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  179,  623,  179,  179,  179,  179,  179,    0,    0, 
            0,    0,  179,    0,    0,    0,  623,  623,    0,  122, 
            0,  623,  515,  522,    0,    0,    0,    0,    0,  515, 
          515,  522,    0,    0,    0,  179,  179,    0,    0,    0, 
            0,    0,    0,  179,  179,  179,  179,    0,    0,  623, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  522,    0, 
            0,    0,    0,    0,    0,  522,  522,    0,  135,    0, 
            0,    0,  179,  619,  619,  619,    0,  619,  622,  622, 
          622,  619,  619,  622,  622,  622,  619,  622,  619,  619, 
          619,  619,  619,  619,  619,    0,  622,  622,  622,  619, 
          619,  619,  619,  619,  619,  619,  622,  622,  619,  622, 
          622,  622,  622,  622,    0,  619,    0,  135,  619,  619, 
          619,  622,  619,  619,  619,  619,  619,  619,  619,  619, 
          619,  619,  619,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,    0,    0,  622, 
          622,  622,  622,  619,    0,  622,  619,  619,  622,  619, 
          619,  622,  619,  622,  619,  622,  619,  622,  619,  622, 
          622,  622,  622,  622,  622,  622,  619,  622,  622,  622, 
          412,  619,  619,  619,  619,  619,  619,    0,    0,    0, 
          619,  622,  619,  619,    0,  619,  619,  619,  619,  129, 
          136,  619,  619,  619,  622,  620,  620,  620,    0,  620, 
          623,  623,  623,  620,  620,  623,  623,  623,  620,  623, 
          620,  620,  620,  620,  620,  620,  620,    0,  623,  623, 
          623,  620,  620,  620,  620,  620,  620,  620,  623,  623, 
          620,  623,  623,  623,  623,  623,    0,  620,  129,  136, 
          620,  620,  620,  623,  620,  620,  620,  620,  620,  620, 
          620,  620,  620,  620,  620,  623,  623,  623,  623,  623, 
          623,  623,  623,  623,  623,  623,  623,  623,  623,   94, 
          304,  623,  623,  623,  623,  620,    0,  623,  620,  620, 
          623,  620,  620,  623,  620,  623,  620,  623,  620,  623, 
          620,  623,  623,  623,  623,  623,  623,  623,  620,  623, 
          623,  623,    0,  620,  620,  620,  620,  620,  620,    0, 
            0,  314,  620,  623,  620,  620,  513,  620,  620,  620, 
          620,  314,    0,  620,  620,  620,  623,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  135,  314,  135,  135,  135,  135, 
          135,    0,    0,    0,    0,  135,    0,    0,    0,  314, 
          314,    0,  127,    0,  314,    0,  511,  387,  388,  389, 
          390,  391,  392,  393,  511,    0,  396,  397,  135,  135, 
            0,    0,    0,  400,  401,    0,  135,  135,  135,  135, 
            0,    0,  314,    0,  796,    0,    0,    0,    0,  402, 
            0,  403,    0,  404,  405,  406,  407,  408,  409,  410, 
            0,  411,    0,    0,  387,  388,  389,  390,  391,  392, 
          393,  394,  395,  396,  397,  135,  398,  399,    0,    0, 
          400,  401,    0,  434,    0,    0,  129,    0,    0,    0, 
            0,    0,    0,  434,    0,    0,  402,    0,  403,    0, 
          404,  405,  406,  407,  408,  409,  410,    0,  411,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  136,  434,  136,  136, 
          136,  136,  136,    0,    0,    0,    0,  136,    0,    0, 
            0,    0,  434,    0,  113,    0,  434,  304,  514,    0, 
            0,    0,    0,    0,  304,  304,  514,    0,    0,    0, 
          136,  136,    0,    0,    0,    0,    0,    0,  136,  136, 
          136,  136,    0,    0,  434,    0,    0,    0,    0,    0, 
            0,    0,  541,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  513,    0,    0,    0,    0,    0,    0, 
          513,  513,    0,    0,    0,    0,    0,  136,  618,  618, 
          618,    0,  618,  314,  314,  314,  618,  618,  314,  314, 
          314,  618,  314,  618,  618,  618,  618,  618,  618,  618, 
            0,  541,  314,  314,  618,  618,  618,  618,  618,  618, 
          618,  314,  314,  618,  314,  314,  314,  314,  314,    0, 
          618,    0,    0,  618,  618,  618,  314,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  314,  314, 
          314,  314,  314,  314,  314,  314,  314,  314,  314,  314, 
          314,  314,   95,    0,  314,  314,  314,  314,  618,    0, 
          314,  618,  618,  314,  618,  618,  314,  618,  314,  618, 
          314,  618,  314,  618,  314,  314,  314,  314,  314,  314, 
          314,  618,  314,    0,  314,  106,  618,  618,  618,  618, 
          618,  618,    0,    0,    0,  618,  314,  618,  618,  514, 
          618,  618,  618,  618,  128,    0,  618,  618,  618,  314, 
          281,  281,  281,    0,  281,  434,  434,  434,  281,  281, 
          434,  434,  434,  281,  434,  281,  281,  281,  281,  281, 
          281,  281,  621,  434,  434,  434,  281,  281,  281,  281, 
          281,  281,  281,  434,  434,  281,  434,  434,  434,  434, 
          434,    0,  281,  128,    0,  281,  281,  281,    0,  281, 
          281,  281,  281,  281,  281,  281,  281,  281,  281,  281, 
          434,  434,  434,  434,  434,  434,  434,  434,  434,  434, 
          434,  434,  434,  434,  643,  315,  434,  434,  434,  434, 
          281,    0,  434,  281,  643,  434,  281,  281,  434,  281, 
          434,  281,  434,  281,  434,  281,  434,  434,  434,  434, 
          434,  434,  434,  281,  434,  434,  434,    0,  281,  281, 
          281,  281,  281,  281,    0,    0,    0,  281,  643,  281, 
          281,    0,  281,  281,  281,  281,    0,    0,  281,  281, 
          281,  434,    0,  643,    0,    0,    0,  643,  541,    0, 
          541,  541,  541,  541,  541,    0,    0,    0,    0,  541, 
            0,    0,  387,  388,  389,  390,  391,  392,  393,  394, 
          395,  396,  397,    0,    0,  643,    0,    0,  400,  401, 
            0,    0,  541,    0,    0,    0,    0,  114,  615,    0, 
          541,  541,  541,  541,  402,    0,  403,    0,  404,  405, 
          406,  407,  408,  409,  410,    0,  411,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  321,    0,    0,    0, 
          125,  621,    0,    0,    0,    0,  321,    0,    0,  541, 
            0,    0,    0,    0,    0,    0,  514,    0,    0,    0, 
            0,    0,    0,  514,  514,    0,    0,    0,    0,  615, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          321,  128,    0,    0,    0,    0,    0,    0,    0,  621, 
          615,    0,    0,    0,    0,  321,  621,  621,    0,  321, 
            0,    0,  617,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  621,    0,    0,    0,  321,    0,    0, 
          305,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  315,    0,    0,    0,    0,    0,    0,  315, 
          315,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  281,  281,  281,    0,  281,  643,  643,  643,  281, 
          281,  643,  643,  643,  281,  643,  281,  281,  281,  281, 
          281,  281,  281,  412,  643,  643,  643,  281,  281,  281, 
          281,  281,  281,  281,  643,  643,  281,  643,  643,  643, 
          643,  643,    0,  281,    0,    0,  281,  281,  281,    0, 
          281,  281,  281,  281,  281,  281,  281,  281,  281,  281, 
          281,  643,  643,  643,  643,  643,  643,  643,  643,  643, 
          643,  643,  643,  643,  643,   93,    0,  643,  643,  643, 
          643,  281,    0,  643,  281,    0,  643,  281,  281,  643, 
          281,  643,  281,  643,  281,  643,  281,  643,  643,  643, 
          643,  643,  643,  643,  281,  643,  643,  643,    0,  281, 
          281,  281,  281,  281,  281,    0,    0,    0,  281,    0, 
          281,  281,  512,  281,  281,  281,  281,  105,    0,  281, 
          281,  281,  643,  281,  281,  281,    0,  281,  321,  321, 
          321,  281,  281,  321,  321,  321,  281,  321,  281,  281, 
          281,  281,  281,  281,  281,    0,    0,  321,  321,  281, 
          281,  281,  281,  281,  281,  281,  321,  321,  281,  321, 
          321,  321,  321,  321,  617,  281,    0,    0,  281,  281, 
          281,    0,  281,  281,  281,  281,  281,  281,  281,  281, 
          281,  281,  281,  321,  321,  321,  321,  321,  321,  321, 
          321,  321,  321,  321,  321,  321,  321,  511,    0,  321, 
          321,  321,  321,  281,    0,  321,  281,  511,  321,  281, 
          281,  321,  281,  321,  281,  321,  281,  321,  281,  321, 
          321,  321,  321,  321,  321,  321,  281,  321,    0,  321, 
            0,  281,  281,  281,  281,  281,  281,    0,    0,    0, 
          281,   92,  281,  281,    0,  281,  281,  281,  281,    0, 
            0,  281,  281,  281,  321,    0,  511,    0,  111,    0, 
          511,    0,    0,    0,    0,    0,    0,  387,  388,  389, 
          390,  391,  392,  393,  394,  395,  396,  397,    0,  398, 
          399,    0,    0,  400,  401,    0,    0,    0,  511,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  402, 
          112,  403,    0,  404,  405,  406,  407,  408,  409,  410, 
            0,  411,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  514, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  514, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  512, 
            0,    0,  124,  617,    0,    0,  512,  512,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   95,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  514,    0, 
          114,    0,  514,    0,    0,    0,    0,    0,    0,    0, 
            0,  617,    0,    0,    0,    0,    0,    0,  617,  617, 
            0,    0,    0,    0,  617,    0,    0,    0,    0,    0, 
          514,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  617,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  614,  614,  614,    0,  614,  511, 
          511,  511,  614,  614,    0,  511,  511,  614,  511,  614, 
          614,  614,  614,  614,  614,  614,    0,  614,    0,    0, 
          614,  614,  614,  614,  614,  614,  614,  511,  511,  614, 
          511,  511,  511,  511,  511,  107,  614,  104,    0,  614, 
          614,  614,    0,  614,  614,  614,  614,  614,  614,  614, 
          614,  614,  614,  614,  511,  511,  511,  511,  511,  511, 
          511,  511,  511,  511,  511,  511,  511,  511,    0,    0, 
          511,  511,  511,  511,  614,  523,    0,  614,  614,  511, 
          614,  614,  618,  614,  435,  614,  511,  614,  511,  614, 
          511,  511,  511,  511,  511,  511,  511,  614,  511,  614, 
          511,   96,  614,  614,  614,  614,  614,  614,    0,  412, 
            0,  614,    0,  614,  614,    0,  614,  614,  614,  614, 
          124,    0,  614,  614,  614,  511,  615,  615,  615,    0, 
          615,  514,  514,  514,  615,  615,    0,  514,  514,  615, 
          514,  615,  615,  615,  615,  615,  615,  615,  515,  615, 
            0,    0,  615,  615,  615,  615,  615,  615,  615,  514, 
          514,  615,  514,  514,  514,  514,  514,    0,  615,  124, 
            0,  615,  615,  615,    0,  615,  615,  615,  615,  615, 
          615,  615,  615,  615,  615,  615,  514,  514,  514,  514, 
          514,  514,  514,  514,  514,  514,  514,  514,  514,  514, 
          412,  617,  514,  514,  514,  514,  615,  526,    0,  615, 
          615,  514,  615,  615,    0,  615,    0,  615,  514,  615, 
          514,  615,  514,  514,  514,  514,  514,  514,  514,  615, 
          514,  615,  514,    0,  615,  615,  615,  615,  615,  615, 
            0,    0,  621,  615,    0,  615,  615,    0,  615,  615, 
          615,  615,  621,    0,  615,  615,  615,  514,  387,  388, 
          389,  390,  391,  392,  393,  394,    0,  396,  397,    0, 
          126,  618,  123,  435,  400,  401,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  106,    0,    0,    0, 
          402,    0,  403,    0,  404,  405,  406,  407,  408,  409, 
          410,  621,  411,  125,    0,  621,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  618, 
            0,  435,    0,    0,    0,    0,  618,  618,  435,  435, 
            0,    0,  618,  621,    0,    0,  115,    0,    0,    0, 
            0,    0,    0,  802,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  618,    0,  435,    0,    0,    0,    0, 
            0,    0,    0,  387,  388,  389,  390,  391,  392,  393, 
          394,  395,  396,  397,  617,  398,  399,  124,    0,  400, 
          401,    0,    0,    0,  617,  515,    0,    0,    0,    0, 
          617,    0,  515,  515,    0,  402,    0,  403,    0,  404, 
          405,  406,  407,  408,  409,  410,    0,  411,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  105,    0, 
            0,  110,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  617,    0,  124,    0,  617,  617,    0, 
            0,    0,    0,    0,    0,  617,  617,    0,    0,    0, 
            0,  617,    0,    0,  387,  388,  389,  390,  391,  392, 
          393,  394,  395,  396,  397,  617,  398,  399,  304,    0, 
          400,  401,  617,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  402,    0,  403,    0, 
          404,  405,  406,  407,  408,  409,  410,    0,  411,  617, 
          617,  617,    0,  617,  621,  621,  621,  617,  617,    0, 
          621,  621,  617,  621,  617,  617,  617,  617,  617,  617, 
          617,    0,  621,    0,    0,  617,  617,  617,  617,  617, 
          617,  617,  621,  621,  617,  621,  621,  621,  621,  621, 
          109,  617,    0,    0,  617,  617,  617,    0,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  621, 
          621,  621,  621,  621,  621,  621,  621,  621,  621,  621, 
          621,  621,  621,    0,    0,  621,  621,  621,  621,  617, 
            0,    0,  617,  617,  621,  617,  617,  315,  617,    0, 
          617,  621,  617,  621,  617,  621,  621,  621,  621,  621, 
          621,  621,  617,  621,  621,  621,    0,  617,  617,  617, 
          617,  617,  617,    0,    0,    0,  617,    0,  617,  617, 
            0,  617,  617,  617,  617,  126,    0,  617,  617, 
      };
   }

   private static final short[] yyTable2() {
      return new short[] {

          617,  621,  617,  617,  617,    0,  617,  617,  617,  617, 
          617,  617,    0,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,    0,  617,    0,  129,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,    0,  617,  126,    0,  617,  617,  617, 
            0,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  304,  618,  617,  617, 
          617,  617,  617,  304,  304,  617,  617,  617,  617,  617, 
            0,  617,    0,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,    0, 
          617,  617,  617,  617,  617,  617,    0,    0,  618,  617, 
            0,  617,  617,    0,  617,  617,  617,  617,  618,    0, 
          617,  617,  617,  617,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  128,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  107,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  618,    0,  126, 
            0,  618,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  315,    0,    0,    0,    0, 
            0,    0,  315,  315,    0,    0,    0,    0,    0,  618, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  643,  638,    0,    0,  644,    0,    0,    0,  184, 
          185,    0,  186,  187,  188,  189,  190,  191,  192,    0, 
          314,  193,  194,  126,    0,    0,  195,  196,  197,  198, 
          314,    0,    0,    0,    0,    0,  618,    0,    0,    0, 
            0,    0,    0,  200,  201,    0,  202,  203,  204,  205, 
          206,  207,  208,  209,  210,  211,  212,    0,    0,  213, 
            0,    0,    0,    0,  108,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  314, 
            0,  127,  214,  314,  618,    0,    0,    0,    0,    0, 
            0,  618,  618,    0,    0,    0,    0,  618,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  314,    0,    0,    0,    0,    0,    0,  618,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  618,  618,  618,    0,  618, 
          618,  618,  618,  618,  618,    0,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,    0,  618,    0, 
            0,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,    0,  618,    0,    0, 
          618,  618,  618,    0,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,    0, 
            0,  618,  618,  618,  618,  618,    0,    0,  618,  618, 
          618,  618,  618,    0,  618,    0,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,    0,  618,  618,  618,  618,  618,  618,    0, 
            0,  643,  618,    0,  618,  618,    0,  618,  618,  618, 
          618,  643,    0,  618,  618,  618,  618,  618,  618,  618, 
            0,  618,  314,  314,  314,  618,  618,    0,  314,  314, 
          618,  314,  618,  618,  618,  618,  618,  618,  618,    0, 
            0,    0,    0,  618,  618,  618,  618,  618,  618,  618, 
          314,  314,  618,  314,  314,  314,  314,  314,    0,  618, 
          643,    0,  618,  618,  618,    0,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  314,  314,  314, 
          314,  314,  314,  314,  314,  314,  314,  314,  314,  314, 
          314,    0,    0,  314,  314,  314,  314,  618,    0,    0, 
          618,  618,  314,  618,  618,    0,  618,    0,  618,  314, 
          618,  314,  618,  314,  314,  314,  314,  314,  314,  314, 
          618,  314,    0,  314,    0,  618,  618,  618,  618,  618, 
          618,    0,    0,  435,  618,    0,  618,  618,    0,  618, 
          618,  618,  618,  435,    0,  618,  618,  618,  314,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   95,    0,  435,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  435,  435,    0,  123,    0,  435,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   95, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  435,    0,   95,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  874, 
            0,    0,  874,    0,    0,    0,    0,    0,    0,  884, 
            0,    0,    0,    0,    0,    0,  514,    0,  281,  281, 
          281,    0,  281,  643,  643,  643,  281,  281,  643,  643, 
          643,  281,  643,  281,  281,  281,  281,  281,  281,  281, 
            0,  643,  643,    0,  281,  281,  281,  281,  281,  281, 
          281,  643,  643,  281,  643,  643,  643,  643,  643,    0, 
          281,    0,    0,  281,  281,  281,    0,  281,  281,  281, 
          281,  281,  281,  281,  281,  281,  281,  281,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  643, 
            0,    0,    0,    0,    0,    0,  643,  643,  281,    0, 
          434,  281,    0,  643,  281,  281,    0,  281,    0,  281, 
          434,  281,    0,  281,    0,    0,    0,    0,    0,    0, 
            0,  281,    0,  643,  643,    0,  281,  281,  281,  281, 
          281,  281,    0,    0,    0,  281,    0,  281,  281,    0, 
          281,  281,  281,  281,  434,    0,  281,  281,  281,  643, 
            0,    0,    0,    0,    0,  435,  435,  435,  434,  434, 
          435,  435,  435,  434,  435,    0,    0,    0,    0,    0, 
            0,    0,    0,  435,  435,  435,    0,    0,    0,    0, 
            0,    0,    0,  435,  435,    0,  435,  435,  435,  435, 
          435,  434,    0,    0,  884,    0,    0,  884,  435,  874, 
            0,  884,    0,    0,   95,  615,    0,    0,    0,    0, 
          435,  435,  435,  435,  435,  435,  435,  435,  435,  435, 
          435,  435,  435,  435,    0,    0,  435,  435,  435,  435, 
            0,  517,  435,    0,    0,  435,    0,    0,  435,    0, 
          435,  517,  435,    0,  435,    0,  435,  435,  435,  435, 
          435,  435,  435,  514,  435,  435,  435,    0,    0,    0, 
          514,  514,    0,    0,    0,    0,  615,   95,  435,    0, 
            0,    0,    0,    0,    0,  517,    0,    0,    0,    0, 
            0,  435,    0,    0,    0,    0,    0,  615,    0,  517, 
          517,  884,  117,  884,  517,  884,    0,    0,  884,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  517,    0,  884,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          516,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          516,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  434,  434,  434,    0,    0,  434,  434,  434, 
            0,  434,    0,    0,    0,    0,    0,    0,    0,    0, 
          434,  434,  434,    0,  516,    0,    0,    0,    0,    0, 
          434,  434,    0,  434,  434,  434,  434,  434,  516,  516, 
            0,  116,    0,  516,    0,  434,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  434,  434,  434, 
          434,  434,  434,  434,  434,  434,  434,  434,  434,  434, 
          434,  516,    0,  434,  434,  434,  434,    0,    0,  434, 
            0,    0,  434,    0,    0,  434,    0,  434,    0,  434, 
            0,  434,    0,  434,  434,  434,  434,  434,  434,  434, 
            0,  434,  434,  434,    0,    0,    0,    0,    0,    0, 
            0,  518,    0,    0,    0,  434,    0,    0,    0,    0, 
            0,  518,    0,    0,    0,    0,    0,    0,  434,    0, 
            0,    0,    0,  517,  517,  517,    0,    0,  517,  517, 
          517,    0,  517,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  517,  517,    0,  518,    0,    0,    0,    0, 
            0,  517,  517,    0,  517,  517,  517,  517,  517,  518, 
          518,    0,  118,    0,  518,    0,  517,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  517,  517, 
          517,  517,  517,  517,  517,  517,  517,  517,  517,  517, 
          517,  517,  518,    0,  517,  517,  517,  517,    0,  529, 
          517,    0,    0,  517,    0,    0,  517,    0,  517,    0, 
          517,  519,  517,    0,  517,  517,  517,  517,  517,  517, 
          517,  519,  517,    0,  517,    0,    0,    0,    0,    0, 
            0,    0,  516,  516,  516,    0,  517,  516,  516,  516, 
            0,  516,    0,    0,    0,    0,    0,    0,    0,  517, 
            0,  516,  516,    0,    0,  519,    0,    0,    0,    0, 
          516,  516,    0,  516,  516,  516,  516,  516,    0,  519, 
          519,    0,  119,    0,  519,  516,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  516,  516,  516, 
          516,  516,  516,  516,  516,  516,  516,  516,  516,  516, 
          516,    0,  519,  516,  516,  516,  516,    0,  528,  516, 
            0,    0,  516,    0,    0,  516,    0,  516,    0,  516, 
            0,  516,    0,  516,  516,  516,  516,  516,  516,  516, 
            0,  516,    0,  516,    0,    0,    0,    0,    0,    0, 
            0,  521,    0,    0,    0,  516,    0,    0,    0,    0, 
            0,  521,    0,    0,    0,    0,    0,    0,  516,    0, 
            0,    0,    0,  518,  518,  518,    0,    0,  518,  518, 
          518,    0,  518,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  518,  518,    0,  521,    0,    0,    0,    0, 
            0,  518,  518,    0,  518,  518,  518,  518,  518,  521, 
          521,    0,  121,    0,  521,    0,  518,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
          518,  518,  521,    0,  518,  518,  518,  518,    0,  530, 
          518,    0,    0,  518,    0,    0,  518,    0,  518,    0, 
          518,  520,  518,    0,  518,  518,  518,  518,  518,  518, 
          518,  520,  518,    0,  518,    0,    0,    0,    0,    0, 
            0,    0,    0,  519,  519,  519,  518,    0,  519,  519, 
          519,    0,  519,    0,    0,    0,    0,    0,    0,  518, 
            0,    0,  519,  519,    0,  520,    0,    0,    0,    0, 
            0,  519,  519,    0,  519,  519,  519,  519,  519,  520, 
          520,    0,  120,    0,  520,    0,  519,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  519,  519, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  520,    0,  519,  519,  519,  519,    0,  531, 
          519,    0,    0,  519,    0,    0,  519,    0,  519,    0, 
          519,    0,  519,    0,  519,  519,  519,  519,  519,  519, 
          519,    0,  519,    0,  519,    0,    0,    0,    0,    0, 
            0,  522,    0,    0,    0,    0,  519,    0,    0,    0, 
            0,  522,    0,    0,    0,    0,    0,    0,    0,  519, 
            0,    0,    0,  521,  521,  521,    0,    0,  521,  521, 
          521,    0,  521,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  521,  521,    0,  522,    0,    0,    0,    0, 
            0,  521,  521,    0,  521,  521,  521,  521,  521,  522, 
          522,    0,  122,    0,  522,    0,  521,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  521,  521, 
          521,  521,  521,  521,  521,  521,  521,  521,  521,  521, 
          521,  521,  522,    0,  521,  521,  521,  521,    0,  533, 
          521,    0,    0,  521,    0,    0,  521,    0,  521,    0, 
          521,  513,  521,    0,  521,  521,  521,  521,  521,  521, 
          521,  513,  521,    0,  521,    0,    0,    0,    0,    0, 
            0,    0,    0,  520,  520,  520,  521,    0,  520,  520, 
          520,    0,  520,    0,    0,    0,    0,    0,    0,  521, 
            0,    0,  520,  520,    0,  513,    0,    0,    0,    0, 
            0,  520,  520,    0,  520,  520,  520,  520,  520,  513, 
          513,    0,  113,    0,  513,    0,  520,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  520,  520, 
          520,  520,  520,  520,  520,  520,  520,  520,  520,  520, 
          520,  520,  513,    0,  520,  520,  520,  520,    0,  532, 
          520,    0,    0,  520,    0,    0,  520,    0,  520,    0, 
          520,    0,  520,    0,  520,  520,  520,  520,  520,  520, 
          520,    0,  520,    0,  520,    0,    0,    0,    0,    0, 
            0,  512,    0,    0,    0,    0,  520,    0,    0,    0, 
            0,  512,    0,    0,    0,    0,    0,    0,    0,  520, 
            0,    0,    0,  522,  522,  522,    0,    0,  522,  522, 
          522,    0,  522,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  522,  522,    0,  512,    0,    0,    0,    0, 
            0,  522,  522,    0,  522,  522,  522,  522,  522,  512, 
          512,    0,  112,    0,  512,    0,  522,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  522,  522, 
          522,  522,  522,  522,  522,  522,  522,  522,  522,  522, 
          522,  522,  512,    0,  522,  522,  522,  522,    0,  534, 
          522,    0,    0,  522,    0,    0,  522,    0,  522,    0, 
          522,  515,  522,    0,  522,  522,  522,  522,  522,  522, 
          522,  515,  522,    0,  522,    0,    0,    0,    0,    0, 
            0,    0,    0,  513,  513,  513,  522,    0,  513,  513, 
          513,    0,  513,    0,    0,    0,    0,    0,    0,  522, 
            0,    0,  513,  513,    0,  515,    0,    0,    0,    0, 
            0,  513,  513,    0,  513,  513,  513,  513,  513,  515, 
          515,    0,  115,    0,  515,    0,  513,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  513,  513, 
          513,  513,  513,  513,  513,  513,  513,  513,  513,  513, 
          513,  513,  515,    0,  513,  513,  513,  513,    0,  525, 
          513,    0,    0,  513,    0,    0,  513,    0,  513,    0, 
          513,    0,  513,    0,  513,  513,  513,  513,  513,  513, 
          513,    0,  513,    0,  513,    0,    0,    0,    0,    0, 
            0,  643,    0,    0,    0,    0,  513,    0,    0,    0, 
            0,  643,    0,    0,    0,    0,    0,    0,    0,  513, 
            0,    0,    0,  512,  512,  512,    0,    0,  512,  512, 
          512,    0,  512,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  512,  512,    0,  643,    0,    0,    0,    0, 
            0,  512,  512,    0,  512,  512,  512,  512,  512,  643, 
          643,    0,    0,    0,  643,    0,  512,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  512,  512, 
          512,  512,  512,  512,  512,  512,  512,  512,  512,  512, 
          512,  512,  643,    0,  512,  512,  512,  512,    0,  524, 
          512,    0,    0,  512,    0,    0,  512,    0,  512,    0, 
          512,  304,  512,    0,  512,  512,  512,  512,  512,  512, 
          512,  304,  512,    0,  512,    0,    0,    0,    0,    0, 
            0,    0,    0,  515,  515,  515,  512,    0,  515,  515, 
          515,    0,  515,    0,    0,    0,    0,    0,    0,  512, 
            0,    0,  515,  515,    0,  304,    0,    0,    0,    0, 
            0,  515,  515,    0,  515,  515,  515,  515,  515,  304, 
          304,    0,  129,    0,  304,    0,  515,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  515,  515, 
          515,  515,  515,  515,  515,  515,  515,  515,  515,  515, 
          515,  515,  304,    0,  515,  515,  515,  515,    0,  527, 
          515,    0,    0,  515,    0,    0,  515,    0,  515,    0, 
          515,    0,  515,    0,  515,  515,  515,  515,  515,  515, 
          515,    0,  515,    0,  515,    0,    0,    0,    0,    0, 
            0,  315,    0,    0,    0,    0,  515,    0,    0,    0, 
            0,  315,    0,    0,    0,    0,    0,    0,    0,  515, 
            0,    0,    0,  643,  643,  643,    0,    0,  643,  643, 
          643,    0,  643,    0,    0,    0,    0,    0,    0,    0, 
            0,  643,  643,  643,    0,  315,    0,    0,    0,    0, 
            0,  643,  643,    0,  643,  643,  643,  643,  643,  315, 
          315,    0,  128,    0,  315,    0,  643,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  643,  643, 
          643,  643,  643,  643,  643,  643,  643,  643,  643,  643, 
          643,  643,  315,    0,  643,  643,  643,  643,    0,    0, 
          643,    0,    0,  643,    0,    0,  643,    0,  643,    0, 
          643,  455,  643,    0,  643,  643,  643,  643,  643,  643, 
          643,  455,  643,  643,  643,    0,    0,    0,    0,    0, 
            0,    0,    0,  304,  304,  304,  643,    0,  304,  304, 
          304,    0,  304,    0,    0,    0,    0,    0,    0,  643, 
            0,    0,  304,  304,    0,  455,    0,    0,    0,    0, 
            0,  304,  304,    0,  304,  304,  304,  304,  304,  455, 
          455,    0,    0,    0,  455,    0,  304,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  304,  304, 
          304,  304,  304,  304,  304,  304,  304,  304,  304,  304, 
          304,  304,  455,    0,  304,  304,  304,  304,    0,    0, 
          304,    0,    0,  304,    0,    0,  304,    0,  304,    0, 
          304,    0,  304,    0,  304,  304,  304,  304,  304,  304, 
          304,    0,  304,    0,  304,    0,    0,    0,    0,    0, 
            0,  326,    0,    0,    0,    0,  304,    0,    0,    0, 
            0,  326,    0,    0,    0,    0,    0,    0,    0,  304, 
            0,    0,    0,  315,  315,  315,    0,    0,  315,  315, 
          315,    0,  315,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  315,  315,    0,  326,    0,    0,    0,    0, 
            0,  315,  315,    0,  315,  315,  315,  315,  315,  326, 
          326,    0,    0,    0,  326,    0,  315,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  315,  315, 
          315,  315,  315,  315,  315,  315,  315,  315,  315,  315, 
          315,  315,  326,    0,  315,  315,  315,  315,    0,    0, 
          315,    0,    0,  315,    0,    0,  315,    0,  315,    0, 
          315,  262,  315,    0,  315,  315,  315,  315,  315,  315, 
          315,  262,  315,    0,  315,    0,    0,    0,    0,    0, 
            0,    0,    0,  455,  455,  455,  315,    0,  455,  455, 
          455,    0,  455,    0,    0,    0,    0,    0,    0,  315, 
            0,    0,  455,  455,    0,  262,    0,    0,    0,    0, 
            0,  455,  455,    0,  455,  455,  455,  455,  455,  262, 
          262,    0,    0,    0,  262,    0,  455,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  455,  455, 
          455,  455,  455,  455,  455,  455,  455,  455,  455,  455, 
          455,  455,  358,    0,  455,  455,  455,  455,    0,    0, 
          455,    0,    0,  455,    0,    0,  455,    0,  455,    0, 
          455,    0,  455,    0,  455,  455,  455,  455,  455,  455, 
          455,    0,  455,    0,  455,    0,    0,    0,    0,    0, 
            0,  321,    0,    0,    0,    0,  455,    0,    0,    0, 
            0,  321,    0,    0,    0,    0,    0,    0,    0,  455, 
            0,    0,    0,  326,  326,  326,    0,    0,  326,  326, 
          326,    0,  326,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  326,  326,    0,  321,    0,    0,    0,    0, 
            0,  326,  326,    0,  326,  326,  326,  326,  326,  321, 
          321,    0,    0,    0,  321,    0,  326,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  326,  326, 
          326,  326,  326,  326,  326,  326,  326,  326,  326,  326, 
          326,  326,  321,    0,  326,  326,  326,  326,    0,    0, 
          326,    0,    0,  326,    0,    0,  326,    0,  326,    0, 
          326,  506,  326,    0,  326,  326,  326,  326,  326,  326, 
          326,  506,  326,    0,  326,    0,    0,    0,    0,    0, 
            0,    0,    0,  262,  262,  262,  326,    0,  262,  262, 
          262,    0,  262,    0,    0,    0,    0,    0,    0,  326, 
            0,    0,  262,  262,    0,  506,    0,    0,    0,    0, 
            0,  262,  262,    0,  262,  262,  262,  262,  262,  506, 
          506,    0,    0,    0,  506,    0,  262,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  262,  262, 
          262,  262,  262,  262,  262,  262,  262,  262,  262,  358, 
          262,  262,  506,    0,  262,  262,  358,  358,    0,    0, 
          262,    0,    0,  262,    0,    0,  262,    0,  262,    0, 
          262,    0,  262,    0,  262,  262,  262,  262,  262,  262, 
          262,    0,  262,    0,  262,    0,    0,    0,    0,    0, 
            0,  354,    0,    0,    0,    0,  262,    0,    0,    0, 
            0,  354,    0,    0,    0,    0,    0,    0,    0,  262, 
            0,    0,    0,  321,  321,  321,    0,    0,  321,  321, 
          321,    0,  321,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  321,  321,    0,  354,    0,    0,    0,    0, 
            0,  321,  321,    0,  321,  321,  321,  321,  321,    0, 
          354,    0,    0,    0,  354,    0,  321,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  321,  321, 
          321,  321,  321,  321,  321,  321,  321,  321,  321,  321, 
          321,  321,  354,    0,  321,  321,  321,  321,    0,    0, 
          321,    0,    0,  321,    0,    0,  321,    0,  321,    0, 
          321,  355,  321,    0,  321,  321,  321,  321,  321,  321, 
          321,  355,  321,    0,  321,    0,    0,    0,    0,    0, 
            0,    0,    0,  506,  506,  506,  321,    0,  506,  506, 
          506,    0,  506,    0,    0,    0,    0,    0,    0,  321, 
            0,    0,  506,  506,    0,  355,    0,    0,    0,    0, 
            0,  506,  506,    0,  506,  506,  506,  506,  506,    0, 
          355,    0,    0,    0,  355,    0,  506,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  506, 
          506,  506,  506,  506,  506,  506,  506,  506,  506,  506, 
          506,  506,  355,    0,  506,  506,  506,  506,    0,    0, 
          506,    0,    0,  506,    0,    0,  506,    0,  506,    0, 
          506,    0,  506,    0,  506,  506,  506,  506,  506,  506, 
          506,    0,  506,    0,  506,    0,    0,    0,    0,    0, 
            0,  318,    0,    0,    0,    0,  506,    0,    0,    0, 
            0,  318,    0,    0,    0,    0,    0,    0,    0,  506, 
            0,    0,    0,  354,  354,  354,    0,    0,  354,  354, 
          354,    0,  354,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  354,  354,    0,  318,    0,    0,    0,    0, 
            0,  354,  354,    0,  354,  354,  354,  354,  354,    0, 
          318,    0,    0,    0,  318,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  354,  354, 
          354,  354,  354,  354,  354,  354,  354,  354,  354,  354, 
          354,  354,  318,    0,  354,  354,  354,  354,    0,    0, 
          354,    0,    0,  354,    0,    0,  354,    0,  354,    0, 
          354,  237,  354,    0,  354,  354,  354,  354,  354,  354, 
          354,  237,  354,    0,  354,    0,    0,    0,    0,    0, 
            0,    0,    0,  355,  355,  355,    0,    0,  355,  355, 
          355,    0,  355,    0,    0,    0,    0,    0,    0,  354, 
            0,    0,  355,  355,    0,  237,    0,    0,    0,    0, 
            0,  355,  355,    0,  355,  355,  355,  355,  355,  237, 
          237,    0,    0,    0,  237,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  355,  355, 
          355,  355,  355,  355,  355,  355,  355,  355,  355,  355, 
          355,  355,    0,    0,  355,  355,  355,  355,    0,    0, 
          355,    0,    0,  355,    0,    0,  355,    0,  355,    0, 
          355,    0,  355,    0,  355,  355,  355,  355,  355,  355, 
          355,    0,  355,    0,  355,    0,    0,    0,    0,    0, 
            0,  234,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  234,    0,    0,    0,    0,    0,    0,    0,  355, 
            0,    0,    0,  318,  318,  318,    0,    0,  318,  318, 
          318,    0,  318,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  318,  318,    0,  234,    0,    0,    0,    0, 
            0,  318,  318,    0,  318,  318,  318,  318,  318,  234, 
          234,    0,    0,    0,  234,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  318,  318, 
          318,  318,  318,  318,  318,  318,  318,  318,  318,  318, 
          318,  318,    0,    0,  318,  318,  318,  318,    0,    0, 
          318,    0,    0,  318,    0,    0,  318,    0,  318,    0, 
          318,  236,  318,    0,  318,  318,  318,  318,  318,  318, 
          318,  236,  318,    0,  318,    0,    0,    0,    0,    0, 
            0,    0,    0,  237,  237,  237,    0,    0,  237,  237, 
          237,    0,  237,    0,    0,    0,    0,    0,    0,  318, 
            0,    0,  237,  237,    0,  236,    0,    0,    0,    0, 
            0,  237,  237,    0,  237,  237,  237,  237,  237,  236, 
          236,    0,    0,    0,  236,    0,  237,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  237, 
          237,  237,  237,  237,  237,  237,  237,  237,  237,    0, 
          237,  237,    0,    0,  237,  237,    0,    0,    0,    0, 
          237,    0,    0,  237,    0,    0,  237,    0,  237,    0, 
          237,    0,  237,    0,  237,  237,  237,  237,  237,  237, 
          237,    0,  237,    0,  237,    0,    0,    0,    0,    0, 
            0,  235,    0,    0,    0,    0,  237,    0,    0,    0, 
            0,  235,    0,    0,    0,    0,    0,    0,    0,  237, 
            0,    0,    0,  234,  234,  234,    0,    0,  234,  234, 
          234,    0,  234,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  234,  234,    0,  235,    0,    0,    0,    0, 
            0,  234,  234,    0,  234,  234,  234,  234,  234,  235, 
          235,    0,    0,    0,  235,    0,  234,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  234, 
          234,  234,  234,  234,  234,  234,  234,  234,  234,    0, 
          234,  234,    0,    0,  234,  234,    0,    0,    0,    0, 
          234,    0,    0,  234,    0,    0,  234,    0,  234,    0, 
          234,  238,  234,    0,  234,  234,  234,  234,  234,  234, 
          234,  238,  234,    0,  234,    0,    0,    0,    0,    0, 
            0,    0,    0,  236,  236,  236,  234,    0,  236,  236, 
          236,    0,  236,    0,    0,    0,    0,    0,    0,  234, 
            0,    0,  236,  236,    0,  238,    0,    0,    0,    0, 
            0,  236,  236,    0,  236,  236,  236,  236,  236,  238, 
          238,    0,    0,    0,  238,    0,  236,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  236, 
          236,  236,  236,  236,  236,  236,  236,  236,  236,    0, 
          236,  236,    0,    0,  236,  236,    0,    0,    0,    0, 
          236,    0,    0,  236,    0,    0,  236,    0,  236,    0, 
          236,    0,  236,    0,  236,  236,  236,  236,  236,  236, 
          236,    0,  236,    0,  236,    0,    0,    0,    0,    0, 
            0,  435,    0,    0,    0,    0,  236,    0,    0,    0, 
            0,  435,    0,    0,    0,    0,    0,    0,    0,  236, 
            0,    0,    0,  235,  235,  235,    0,    0,  235,  235, 
          235,    0,  235,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  235,  235,    0,  104,    0,    0,    0,    0, 
            0,  235,  235,    0,  235,  235,  235,  235,  235,    0, 
          435,    0,  123,    0,  435,    0,  235,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  235, 
          235,  235,  235,  235,  235,  235,  235,  235,  235,    0, 
          235,  235,  435,    0,  235,  235,    0,    0,    0,    0, 
          235,    0,    0,  235,    0,    0,  235,    0,  235,    0, 
          235,  517,  235,    0,  235,  235,  235,  235,  235,  235, 
          235,  517,  235,    0,  235,    0,    0,    0,    0,    0, 
            0,    0,    0,  238,  238,  238,  235,    0,  238,  238, 
          238,    0,  238,    0,    0,    0,    0,    0,    0,  235, 
            0,    0,  238,  238,    0,   98,    0,    0,    0,    0, 
            0,  238,  238,    0,  238,  238,  238,  238,  238,    0, 
          517,    0,  117,    0,  517,    0,  238,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  238, 
          238,  238,  238,  238,  238,  238,  238,  238,  238,    0, 
          238,  238,  517,    0,  238,  238,    0,  102,    0,    0, 
          238,    0,    0,  238,    0,    0,  238,    0,  238,    0, 
          238,    0,  238,  516,  238,  238,  238,  238,  238,  238, 
          238,    0,  238,  516,  238,    0,    0,    0,    0,    0, 
            0,  102,    0,    0,    0,    0,  238,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  102,  238, 
            0,    0,    0,  435,  435,  435,    0,   97,    0,  435, 
          435,    0,  435,    0,    0,    0,    0,    0,    0,    0, 
            0,  435,  516,    0,  116,    0,  516,    0,  521,    0, 
            0,  435,  435,    0,  435,  435,  435,  435,  435,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  516,    0,    0,    0,  435,  435, 
          435,  435,  435,  435,  435,  435,  435,  435,  435,  435, 
          435,  435,  518,    0,  435,  435,  435,  435,    0,    0, 
            0,    0,  518,  435,    0,    0,    0,    0,    0,    0, 
          435,    0,  435,    0,  435,  435,  435,  435,  435,  435, 
          435,    0,  435,  435,  435,    0,    0,    0,    0,    0, 
            0,    0,    0,  517,  517,  517,   99,    0,    0,  517, 
          517,    0,  517,    0,    0,    0,    0,    0,    0,  435, 
            0,  518,    0,  118,    0,  518,    0,    0,    0,    0, 
            0,  517,  517,    0,  517,  517,  517,  517,  517,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  518,    0,    0,    0,    0,  517,  517, 
          517,  517,  517,  517,  517,  517,  517,  517,  517,  517, 
          517,  517,    0,    0,  517,  517,  517,  517,    0,  529, 
            0,    0,    0,  517,    0,    0,    0,    0,    0,    0, 
          517,    0,  517,  519,  517,  517,  517,  517,  517,  517, 
          517,    0,  517,  519,  517,    0,  102,    0,    0,    0, 
            0,    0,    0,    0,    0,  516,  516,  516,    0,    0, 
            0,  516,  516,    0,  516,    0,    0,    0,    0,  517, 
            0,    0,    0,    0,    0,    0,    0,  100,    0,    0, 
            0,    0,    0,  516,  516,    0,  516,  516,  516,  516, 
          516,    0,  519,    0,  119,  521,  519,    0,    0,    0, 
            0,    0,  521,  521,    0,    0,    0,    0,    0,  102, 
          516,  516,  516,  516,  516,  516,  516,  516,  516,  516, 
          516,  516,  516,  516,  519,    0,  516,  516,  516,  516, 
            0,  528,    0,    0,    0,  516,    0,    0,    0,    0, 
            0,    0,  516,  521,  516,    0,  516,  516,  516,  516, 
          516,  516,  516,  521,  516,    0,  516,    0,    0,    0, 
            0,    0,    0,    0,  518,  518,  518,    0,    0,    0, 
          518,  518,    0,  518,    0,    0,    0,    0,    0,    0, 
            0,  516,    0,    0,    0,    0,    0,  102,    0,    0, 
            0,    0,  518,  518,    0,  518,  518,  518,  518,  518, 
            0,    0,  521,    0,  121,    0,  521,    0,    0,    0, 
            0,  101,    0,    0,    0,    0,    0,    0,    0,  518, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
          518,  518,  518,    0,  521,  518,  518,  518,  518,    0, 
          530,    0,    0,    0,  518,  101,    0,    0,    0,    0, 
            0,  518,    0,  518,  520,  518,  518,  518,  518,  518, 
          518,  518,  101,  518,  520,  518,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          518,    0,  520,    0,    0,  519,  519,  519,  101,    0, 
            0,  519,  519,    0,  519,    0,    0,    0,    0,    0, 
            0,    0,    0,  520,    0,  120,    0,  520,    0,    0, 
            0,    0,    0,  519,  519,    0,  519,  519,  519,  519, 
          519,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  520,    0,    0,    0,    0, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,  522,    0,  519,  519,  519,  519, 
            0,  531,    0,    0,  522,  519,    0,    0,    0,    0, 
            0,    0,  519,    0,  519,    0,  519,  519,  519,  519, 
          519,  519,  519,    0,  519,    0,  519,    0,    0,    0, 
            0,    0,    0,    0,    0,  521,  521,  521,  103,    0, 
            0,  521,  521,    0,  521,    0,    0,    0,    0,    0, 
            0,  519,    0,  522,    0,  122,    0,  522,    0,    0, 
            0,    0,    0,  521,  521,    0,  521,  521,  521,  521, 
          521,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  522,    0,    0,    0,    0, 
          521,  521,  521,  521,  521,  521,  521,  521,  521,  521, 
          521,  521,  521,  521,    0,    0,  521,  521,  521,  521, 
          101,  533,    0,    0,    0,  521,    0,    0,    0,    0, 
            0,    0,  521,    0,  521,  513,  521,  521,  521,  521, 
          521,  521,  521,    0,  521,  513,  521,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  520,  520,  520,    0, 
            0,    0,  520,  520,    0,  520,    0,    0,    0,  520, 
            0,  521,    0,    0,    0,    0,  520,  520,    0,   94, 
            0,    0,    0,  101,  520,  520,    0,  520,  520,  520, 
          520,  520,    0,    0,  513,    0,  113,    0,  513,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  520,  520,  520,  520,  520,  520,  520,  520,  520, 
          520,  520,  520,  520,  520,    0,  513,  520,  520,  520, 
          520,    0,  532,    0,    0,    0,  520,    0,    0,    0, 
            0,    0,    0,  520,  512,  520,    0,  520,  520,  520, 
          520,  520,  520,  520,  512,  520,    0,  520,    0,    0, 
            0,    0,    0,    0,    0,    0,  522,  522,  522,    0, 
            0,    0,  522,  522,    0,  522,    0,    0,    0,    0, 
            0,    0,  520,    0,    0,    0,    0,    0,   93,    0, 
            0,    0,    0,    0,  522,  522,    0,  522,  522,  522, 
          522,  522,    0,  512,    0,  112,    0,  512,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  522,  522,  522,  522,  522,  522,  522,  522,  522, 
          522,  522,  522,  522,  522,  512,    0,  522,  522,  522, 
          522,    0,  534,    0,    0,    0,  522,    0,    0,    0, 
            0,    0,    0,  522,    0,  522,  515,  522,  522,  522, 
          522,  522,  522,  522,    0,  522,  515,  522,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  522,    0,    0,    0,    0,  513,  513,  513, 
           96,    0,    0,  513,  513,    0,  513,    0,    0,    0, 
            0,    0,    0,    0,    0,  515,    0,  115,    0,  515, 
            0,    0,    0,    0,    0,  513,  513,    0,  513,  513, 
          513,  513,  513,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  515,    0,  103, 
            0,    0,  513,  513,  513,  513,  513,  513,  513,  513, 
          513,  513,  513,  513,  513,  513,  304,    0,  513,  513, 
          513,  513,    0,  525,    0,    0,  304,  513,    0,    0, 
            0,    0,    0,  103,  513,    0,  513,    0,  513,  513, 
          513,  513,  513,  513,  513,    0,  513,    0,  513,    0, 
          103,    0,    0,    0,    0,    0,  512,  512,  512,    0, 
          110,    0,  512,  512,    0,  512,    0,    0,    0,    0, 
            0,    0,    0,  513,    0,  304,    0,  129,    0,  304, 
          522,    0,    0,    0,  512,  512,    0,  512,  512,  512, 
          512,  512,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  304,    0,    0, 
            0,  512,  512,  512,  512,  512,  512,  512,  512,  512, 
          512,  512,  512,  512,  512,    0,    0,  512,  512,  512, 
          512,    0,  524,    0,    0,    0,  512,    0,    0,    0, 
            0,    0,    0,  512,    0,  512,  315,  512,  512,  512, 
          512,  512,  512,  512,    0,  512,  315,  512,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  515,  515, 
          515,    0,    0,    0,  515,  515,    0,  515,    0,    0, 
            0,    0,  512,    0,    0,    0,    0,    0,    0,    0, 
          109,    0,    0,    0,    0,    0,  515,  515,    0,  515, 
          515,  515,  515,  515,    0,  315,    0,  128,    0,  315, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  515,  515,  515,  515,  515,  515,  515, 
          515,  515,  515,  515,  515,  515,  515,  315,    0,  515, 
          515,  515,  515,    0,  527,    0,    0,    0,  515,    0, 
            0,    0,    0,    0,    0,  515,  232,  515,    0,  515, 
          515,  515,  515,  515,  515,  515,  232,  515,  103,  515, 
            0,    0,    0,    0,    0,    0,    0,    0,  304,  304, 
          304,    0,    0,    0,  304,  304,    0,  304,    0,    0, 
            0,    0,    0,    0,  515,    0,    0,    0,    0,    0, 
          232,    0,    0,    0,    0,    0,  304,  304,    0,  304, 
          304,  304,  304,  304,  232,  232,    0,  522,    0,  232, 
            0,    0,    0,    0,  522,  522,    0,    0,    0,    0, 
            0,  103,    0,  304,  304,  304,  304,  304,  304,  304, 
          304,  304,  304,  304,  304,  304,  304,    0,    0,  304, 
          304,  304,  304,    0,    0,    0,    0,    0,  304,    0, 
            0,    0,    0,    0,    0,  304,    0,  304,    0,  304, 
          304,  304,  304,  304,  304,  304,    0,  304,    0,  304, 
            0,    0,    0,    0,    0,    0,  233,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  233,    0,    0,    0, 
            0,    0,    0,    0,  304,    0,    0,    0,  315,  315, 
          315,    0,    0,    0,  315,  315,    0,  315,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          233,    0,    0,    0,    0,    0,  315,  315,    0,  315, 
          315,  315,  315,  315,  233,  233,    0,    0,    0,  233, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  315,  315,  315,  315,  315,  315,  315, 
          315,  315,  315,  315,  315,  315,  315,    0,    0,  315, 
          315,  315,  315,    0,    0,    0,    0,    0,  315,    0, 
            0,    0,    0,    0,    0,  315,  256,  315,    0,  315, 
          315,  315,  315,  315,  315,  315,  256,  315,    0,  315, 
            0,    0,    0,    0,    0,    0,    0,    0,  232,  232, 
          232,    0,    0,  232,  232,  232,    0,  232,    0,    0, 
            0,    0,    0,    0,  315,    0,    0,  232,  232,    0, 
          256,    0,    0,    0,    0,    0,  232,  232,    0,  232, 
          232,  232,  232,  232,  256,  256,    0,    0,    0,  256, 
            0,  232,    0,    0,    0,    0,    0,    0,    0, 
      };
   }

   private static final short[] yyTable3() {
      return new short[] {

            0,    0,    0,    0,    0,  232,  232,  232,  232,  232, 
          232,  232,  232,  232,  232,    0,  232,  232,    0,    0, 
          232,  232,    0,    0,    0,    0,  232,    0,    0,  232, 
            0,    0,  232,    0,  232,    0,    0,    0,  232,    0, 
          106,    0,  232,  232,  232,  232,  232,    0,  232,    0, 
          232,    0,    0,    0,    0,    0,    0,  257,    0,    0, 
            0,    0,  232,    0,    0,    0,    0,  257,    0,    0, 
            0,    0,    0,    0,  106,  232,    0,    0,    0,  233, 
          233,  233,    0,    0,  233,  233,  233,    0,  233,    0, 
            0,  106,    0,    0,    0,    0,    0,    0,  233,  233, 
            0,  257,    0,    0,    0,    0,    0,  233,  233,    0, 
          233,  233,  233,  233,  233,  257,  257,    0,    0,    0, 
          257,  621,  233,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  233,  233,  233,  233,  233, 
          233,  233,  233,  233,  233,    0,  233,  233,    0,    0, 
          233,  233,    0,    0,    0,    0,  233,    0,    0,  233, 
            0,    0,  233,    0,  233,    0,    0,  243,  233,    0, 
            0,    0,  233,  233,  233,  233,  233,  243,  233,    0, 
          233,    0,    0,    0,    0,    0,    0,    0,    0,  256, 
          256,  256,  233,    0,  256,  256,  256,    0,  256,    0, 
            0,    0,    0,    0,    0,  233,   44,    0,  256,  256, 
            0,  243,    0,    0,    0,    0,   44,  256,  256,    0, 
          256,  256,  256,  256,  256,  243,  243,    0,    0,    0, 
          243,    0,  256,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  256,  256,  256,  256,  256, 
          256,  256,  256,  256,  256,    0,  256,  256,    0,    0, 
          256,  256,    0,    0,    0,   44,  256,    0,    0,  256, 
            0,    0,  256,    0,  256,    0,    0,    0,  256,    0, 
            0,    0,    0,  241,  256,  256,  256,    0,  256,    0, 
          256,    0,    0,  241,    0,    0,    0,    0,    0,    0, 
            0,    0,  256,    0,    0,    0,    0,    0,    0,  106, 
          621,    0,    0,    0,    0,  256,    0,    0,    0,  257, 
          257,  257,    0,    0,  257,  257,  257,  241,  257,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  257,  257, 
            0,  241,  241,    0,    0,    0,  241,  257,  257,    0, 
          257,  257,  257,  257,  257,    0,    0,    0,  621,    0, 
            0,    0,  257,    0,    0,  621,  621,    0,    0,    0, 
            0,  617,  106,    0,    0,  257,  257,  257,  257,  257, 
          257,  257,  257,  257,  257,    0,  257,  257,    0,    0, 
          257,  257,  621,  242,    0,    0,  257,    0,    0,  257, 
            0,    0,  257,  242,  257,    0,    0,    0,  257,    0, 
            0,    0,    0,    0,  257,  257,  257,    0,  257,    0, 
          257,    0,    0,    0,    0,    0,    0,    0,    0,  243, 
          243,  243,  257,    0,  243,  243,  243,  242,  243,    0, 
            0,    0,    0,    0,    0,  257,    0,    0,  243,  243, 
            0,  242,  242,    0,    0,    0,  242,  243,  243,    0, 
          243,  243,  243,  243,  243,    0,    0,    0,   44,   44, 
           44,    0,  243,    0,   44,   44,    0,   44,    0,    0, 
            0,    0,    0,    0,    0,  243,  243,  243,  243,  243, 
          243,  243,  243,  243,  243,    0,  243,  243,    0,   44, 
           44,   44,   44,   44,    0,    0,  243,    0,    0,  243, 
            0,    0,  243,    0,  243,    0,    0,    0,  243,    0, 
            0,    0,    0,  246,  243,  243,  243,    0,  243,    0, 
          243,    0,    0,  246,    0,    0,    0,    0,    0,    0, 
            0,    0,  243,    0,    0,  241,  241,  241,   44,    0, 
          241,  241,  241,    0,  241,  243,    0,    0,    0,    0, 
            0,    0,    0,    0,  241,  241,    0,  246,    0,   44, 
            0,    0,    0,  241,  241,    0,  241,  241,  241,  241, 
          241,  246,  246,    0,    0,    0,  246,   94,  241,    0, 
            0,    0,    0,    0,   44,    0,    0,    0,    0,    0, 
            0,  241,  241,  241,  241,  241,  241,  241,  241,  241, 
          241,    0,  241,  241,    0,    0,    0,    0,    0,    0, 
            0,   94,  241,    0,    0,  241,    0,    0,  241,    0, 
          241,    0,    0,  248,    0,    0,    0,    0,   94,    0, 
          241,  241,  241,  248,  241,    0,  241,    0,    0,    0, 
            0,    0,    0,    0,    0,  242,  242,  242,  241,    0, 
          242,  242,  242,    0,  242,    0,    0,    0,  513,    0, 
            0,  241,   25,    0,  242,  242,    0,  248,    0,    0, 
            0,    0,   25,  242,  242,    0,  242,  242,  242,  242, 
          242,  248,  248,    0,    0,    0,  248,    0,  242,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  242,  242,  242,  242,  242,  242,  242,  242,  242, 
          242,    0,  242,  242,    0,    0,    0,    0,    0,    0, 
            0,   25,  242,    0,    0,  242,    0,    0,  242,    0, 
          242,    0,    0,    0,    0,    0,    0,    0,    0,  247, 
          242,  242,  242,    0,  242,    0,  242,    0,    0,  247, 
            0,    0,    0,    0,    0,    0,    0,    0,  242,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  242,    0,    0,    0,  246,  246,  246,    0,    0, 
          246,  246,  246,  247,  246,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  246,  246,    0,  247,  247,    0, 
            0,    0,  247,  246,  246,    0,  246,  246,  246,  246, 
          246,    0,    0,    0,    0,    0,    0,    0,  246,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  246,  246,  246,  246,  246,  246,  246,  246,  246, 
          246,    0,  246,  246,    0,    0,   94,    0,    0,  245, 
            0,    0,  246,    0,    0,  246,    0,    0,  246,  245, 
          246,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          246,  246,    0,    0,    0,    0,  246,    0,    0,    0, 
            0,    0,    0,    0,    0,  248,  248,  248,  246,    0, 
          248,  248,  248,  245,  248,  513,    0,    0,    0,    0, 
            0,  246,  513,  513,  248,  248,    0,  245,  245,   94, 
            0,    0,  245,  248,  248,    0,  248,  248,  248,  248, 
          248,    0,    0,    0,   25,   25,   25,    0,  248,    0, 
           25,   25,    0,   25,    0,    0,    0,    0,    0,    0, 
            0,  248,  248,  248,  248,  248,  248,  248,  248,  248, 
          248,    0,  248,  248,    0,   25,   25,   25,   25,   25, 
            0,    0,  248,    0,    0,  248,    0,    0,  248,    0, 
          248,    0,    0,    0,    0,  105,    0,    0,    0,  244, 
          248,  248,    0,    0,    0,    0,  248,    0,    0,  244, 
            0,    0,    0,    0,    0,    0,    0,    0,  248,    0, 
            0,  247,  247,  247,   25,    0,  247,  247,  247,  105, 
          247,  248,    0,    0,    0,    0,    0,    0,    0,    0, 
          247,  247,    0,  244,    0,   25,  105,    0,    0,  247, 
          247,    0,  247,  247,  247,  247,  247,  244,  244,    0, 
            0,    0,  244,  107,  247,    0,    0,    0,    0,    0, 
           25,    0,    0,    0,    0,    0,  617,  247,  247,  247, 
          247,  247,  247,  247,  247,  247,  247,    0,  247,  247, 
            0,    0,   93,    0,   96,    0,    0,  107,  247,    0, 
            0,  247,    0,    0,  247,    0,  247,    0,    0,  249, 
            0,    0,    0,    0,  107,    0,  247,  247,    0,  249, 
            0,    0,  247,    0,    0,    0,   93,    0,   96,    0, 
            0,  245,  245,  245,  247,    0,  245,  245,  245,    0, 
          245,    0,    0,   93,  618,   96,    0,  247,    0,    0, 
          245,  245,    0,  249,    0,    0,    0,    0,    0,  245, 
          245,    0,  245,  245,  245,  245,  245,  249,  249,    0, 
            0,    0,  249,  512,  245,  515,    0,    0,  110,    0, 
            0,    0,    0,    0,    0,    0,    0,  245,  245,  245, 
          245,  245,  245,  245,  245,  245,  245,  250,  245,  245, 
            0,    0,    0,    0,    0,    0,    0,  250,  245,    0, 
            0,  245,  110,    0,  245,    0,  245,    0,    0,    0, 
          109,    0,    0,    0,    0,    0,  245,  245,    0,  110, 
            0,    0,  245,    0,    0,    0,    0,    0,    0,    0, 
            0,  250,    0,    0,  245,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  109,  250,  250,  245,    0,  304, 
          250,  244,  244,  244,  105,  617,  244,  244,  244,    0, 
          244,  109,    0,    0,    0,    0,    0,    0,    0,    0, 
          244,  244,    0,    0,    0,    0,    0,    0,    0,  244, 
          244,    0,  244,  244,  244,  244,  244,    0,    0,    0, 
            0,  315,    0,    0,  244,    0,  251,    0,    0,    0, 
            0,    0,    0,  617,    0,    0,  251,    0,    0,    0, 
          617,  617,    0,  244,  244,    0,  617,  105,  244,  244, 
            0,    0,  107,  618,    0,    0,    0,    0,  244,    0, 
            0,  244,    0,    0,  244,    0,  244,  617,    0,    0, 
          251,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   93,  244,   96,  251,  251,    0,    0,    0,  251, 
            0,  249,  249,  249,  244,    0,  249,  249,  249,    0, 
          249,  618,    0,    0,    0,    0,    0,  244,  618,  618, 
          249,  249,    0,    0,  618,  107,    0,    0,    0,  249, 
          249,    0,  249,  249,  249,  249,  249,    0,    0,    0, 
          512,  258,  515,    0,  249,  618,    0,  512,  512,  515, 
          515,  258,    0,    0,   93,    0,   96,    0,    0,    0, 
            0,    0,    0,  249,  249,    0,    0,    0,  249,  249, 
            0,    0,    0,    0,    0,    0,    0,  110,  249,    0, 
            0,  249,    0,    0,  249,  258,  249,    0,    0,  250, 
          250,  250,    0,    0,  250,  250,  250,    0,  250,  258, 
          258,    0,  249,    0,  258,    0,    0,    0,  250,  250, 
            0,    0,    0,    0,  249,    0,    0,  250,  250,  109, 
          250,  250,  250,  250,  250,    0,  304,  249,    0,  252, 
            0,    0,  250,  304,  304,    0,    0,    0,    0,  252, 
          110,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  250,  250,    0,    0,    0,  250,  250,    0,    0, 
            0,    0,    0,    0,    0,    0,  250,    0,  315,  250, 
            0,    0,  250,  252,  250,  315,  315,    0,    0,    0, 
            0,    0,  109,    0,    0,    0,    0,  252,  252,    0, 
          250,    0,  252,    0,    0,    0,    0,    0,  251,  251, 
          251,    0,  250,  251,  251,  251,    0,  251,    0,    0, 
            0,    0,    0,    0,    0,  250,    0,  251,  251,    0, 
            0,    0,    0,    0,    0,    0,  251,  251,    0,  251, 
          251,  251,  251,  251,    0,    0,    0,    0,  253,    0, 
            0,  251,    0,    0,    0,    0,    0,    0,  253,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          251,  251,    0,    0,    0,  251,  251,    0,    0,    0, 
            0,    0,    0,    0,    0,  251,    0,    0,  251,    0, 
            0,  251,  253,  251,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  253,  253,    0,  251, 
            0,  253,    0,  258,  258,  258,    0,    0,  258,  258, 
          258,  251,  258,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  258,  258,  251,    0,    0,    0,    0,    0, 
            0,  258,  258,    0,  258,  258,  258,  258,  258,    0, 
            0,    0,    0,  259,    0,    0,  258,    0,    0,    0, 
            0,    0,    0,  259,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  258,  258,    0,    0,    0, 
          258,  258,    0,    0,    0,    0,    0,    0,    0,    0, 
          258,    0,    0,  258,    0,    0,  258,  259,  258,    0, 
            0,  252,  252,  252,    0,    0,  252,  252,  252,    0, 
          252,  259,  259,    0,  258,    0,  259,    0,    0,    0, 
          252,  252,    0,    0,    0,    0,  258,    0,    0,  252, 
          252,    0,  252,  252,  252,  252,  252,    0,    0,  258, 
            0,  231,    0,    0,  252,    0,    0,    0,    0,    0, 
            0,  231,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  252,  252,    0,    0,    0,  252,  252, 
            0,    0,    0,    0,    0,    0,    0,    0,  252,    0, 
            0,  252,    0,    0,  252,  231,  252,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  231, 
          231,    0,  252,  260,  231,    0,    0,    0,    0,    0, 
          253,  253,  253,  260,  252,  253,  253,  253,    0,  253, 
            0,    0,    0,    0,    0,    0,    0,  252,    0,  253, 
          253,    0,    0,    0,    0,    0,    0,    0,  253,  253, 
            0,  253,  253,  253,  253,  253,    0,  260,    0,    0, 
            0,    0,    0,  253,    0,    0,    0,    0,    0,    0, 
            0,  260,  260,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  253,  253,    0,    0,    0,  253,  253,    0, 
            0,    0,    0,    0,    0,    0,    0,  253,    0,    0, 
          253,    0,    0,  253,    0,  253,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  229,    0, 
            0,  253,    0,    0,    0,  259,  259,  259,  229,    0, 
          259,  259,  259,  253,  259,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  259,  259,  253,    0,    0,    0, 
            0,    0,    0,  259,  259,    0,  259,  259,  259,  259, 
          259,    0,  229,    0,    0,    0,    0,    0,  259,    0, 
            0,    0,    0,    0,    0,    0,  229,  229,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  259,    0, 
            0,    0,  259,  259,    0,    0,    0,    0,    0,    0, 
            0,    0,  259,    0,    0,  259,  228,    0,  259,    0, 
          259,    0,    0,  231,  231,  231,  228,    0,  231,  231, 
          231,    0,  231,    0,    0,    0,  259,    0,    0,    0, 
            0,    0,  231,  231,    0,    0,    0,    0,  259,    0, 
            0,  231,  231,    0,  231,  231,  231,  231,  231,    0, 
          228,  259,    0,    0,    0,    0,  231,    0,    0,    0, 
            0,    0,    0,    0,  228,  228,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  260,  260,  260,    0,    0, 
          260,  260,  260,    0,  260,    0,    0,    0,    0,    0, 
          231,    0,  226,  231,  260,  260,  231,    0,  231,    0, 
            0,    0,  226,  260,  260,    0,  260,  260,  260,  260, 
          260,    0,    0,    0,  231,    0,    0,    0,  260,    0, 
            0,    0,    0,    0,    0,    0,  231,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  226,    0,    0,  231, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          226,  226,  260,    0,    0,  260,    0,    0,  260,    0, 
          260,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  260,    0,    0,    0, 
          229,  229,  229,    0,    0,  229,  229,  229,  260,  229, 
            0,    0,    0,    0,  227,    0,    0,    0,    0,  229, 
          229,  260,    0,    0,  227,    0,    0,    0,  229,  229, 
            0,  229,  229,  229,  229,  229,    0,    0,    0,    0, 
            0,    0,    0,  229,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  227,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  227,  227,    0,    0,    0,  229,    0,    0, 
          229,    0,    0,  229,    0,  229,    0,    0,  228,  228, 
          228,    0,    0,  228,  228,  228,    0,  228,    0,    0, 
          224,  229,    0,    0,    0,    0,    0,  228,  228,    0, 
          224,    0,    0,  229,    0,    0,  228,  228,    0,  228, 
          228,  228,  228,  228,    0,    0,  229,    0,    0,    0, 
            0,  228,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  224,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  224,  224, 
            0,    0,    0,    0,    0,  228,    0,    0,  228,    0, 
            0,  228,    0,  228,  226,  226,  226,    0,    0,  226, 
          226,  226,    0,  226,    0,    0,  225,    0,    0,  228, 
            0,    0,    0,  226,  226,    0,  225,    0,    0,    0, 
            0,  228,  226,  226,    0,  226,  226,  226,  226,  226, 
            0,    0,    0,    0,  228,    0,    0,  226,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          225,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  225,  225,    0,    0,    0,    0, 
            0,  226,    0,    0,  226,    0,    0,  226,    0,  226, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  220,  226,  227,  227,  227,    0, 
            0,  227,  227,  227,  220,  227,    0,  226,    0,    0, 
            0,    0,    0,    0,    0,  227,  227,    0,    0,    0, 
          226,    0,    0,    0,  227,  227,    0,  227,  227,  227, 
          227,  227,    0,    0,    0,    0,    0,    0,  220,  227, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  220,  220,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  227,    0,    0,  227,    0,    0,  227, 
          222,  227,  224,  224,  224,    0,    0,  224,  224,  224, 
          222,  224,    0,    0,    0,    0,    0,  227,    0,    0, 
            0,  224,  224,    0,    0,    0,    0,    0,    0,  227, 
          224,  224,    0,  224,  224,  224,  224,  224,    0,    0, 
            0,    0,  227,    0,  222,  224,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  222,  222, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  224, 
            0,    0,  224,    0,    0,  224,  261,  224,  225,  225, 
          225,    0,    0,  225,  225,  225,  261,  225,    0,    0, 
            0,    0,    0,  224,    0,    0,    0,  225,  225,    0, 
            0,    0,    0,    0,    0,  224,  225,  225,    0,  225, 
          225,  225,  225,  225,    0,    0,    0,    0,  224,    0, 
          261,  225,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  261,  261,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  225,    0,    0,  225,    0, 
            0,  225,    0,  225,  223,    0,  220,  220,  220,    0, 
            0,  220,  220,  220,  223,  220,    0,    0,    0,  225, 
            0,    0,    0,    0,    0,  220,  220,    0,    0,    0, 
            0,  225,    0,    0,  220,  220,    0,  220,  220,  220, 
          220,  220,    0,  263,  225,    0,    0,    0,  223,  220, 
            0,    0,    0,  263,    0,    0,    0,    0,    0,    0, 
            0,    0,  223,  223,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  220,    0,    0,  220,  263,    0,  220, 
            0,  220,  222,  222,  222,    0,    0,  222,  222,  222, 
            0,  222,  263,    0,    0,    0,   54,  220,    0,    0, 
            0,  222,  222,    0,    0,    0,   54,    0,    0,  220, 
          222,  222,    0,  222,  222,  222,  222,  222,    0,    0, 
            0,    0,  220,    0,    0,  222,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  221,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  221,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   54,    0,    0,    0,  222, 
            0,    0,  222,    0,    0,  222,    0,  222,  261,  261, 
          261,    0,    0,  261,  261,  261,    0,  261,    0,  221, 
            0,    0,    0,  222,    0,    0,    0,  261,  261,    0, 
            0,    0,    0,  221,  221,  222,  261,  261,    0,  261, 
          261,  261,  261,  261,    0,    0,    0,    0,  222,    0, 
            0,  261,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  219,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  219,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  261,    0,    0,  261,    0, 
            0,  261,    0,  261,    0,    0,  223,  223,  223,    0, 
            0,  223,  223,  223,    0,  223,    0,    0,  219,  261, 
            0,    0,    0,    0,    0,  223,  223,    0,    0,    0, 
            0,  261,  219,  219,  223,  223,    0,  223,  223,  223, 
          223,  223,    0,    0,  261,  263,  263,  263,    0,  223, 
          263,  263,  263,    0,  263,    0,    0,    0,    0,    0, 
            0,  288,    0,    0,  263,  263,    0,    0,    0,    0, 
            0,  288,    0,  263,  263,    0,  263,  263,  263,  263, 
          263,    0,    0,  223,    0,    0,  223,    0,  263,  223, 
            0,  223,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  644,    0,    0,    0,  288,    0,  223,   54,   54, 
           54,  644,    0,   54,   54,   54,    0,   54,    0,  223, 
          288,    0,  263,    0,    0,  263,    0,   54,  263,    0, 
          263,    0,  223,    0,    0,    0,   54,   54,    0,   54, 
           54,   54,   54,   54,    0,    0,  263,  221,  221,  221, 
            0,    0,  221,  221,  221,    0,  221,    0,  263,    0, 
          644,    0,    0,  424,    0,    0,  221,  221,    0,    0, 
            0,  263,    0,  424,    0,  221,  221,    0,  221,  221, 
          221,  221,    0,    0,    0,    0,    0,    0,   54,    0, 
          221,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   54, 
            0,    0,    0,   61,    0,    0,    0,    0,    0,    0, 
            0,    0,  424,   61,  221,    0,    0,  221,    0,    0, 
          221,    0,  221,    0,   54,    0,  219,  219,  219,    0, 
            0,  219,  219,  219,    0,  219,    0,    0,  221,   65, 
            0,    0,    0,    0,    0,  219,  219,    0,    0,   65, 
          221,    0,    0,    0,  219,  219,    0,  219,  219,  219, 
          219,    0,   61,  221,    0,    0,    0,    0,    0,  219, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   63,    0,    0,    0,    0,    0,   65,    0, 
            0,    0,   63,  219,    0,    0,  219,    0,    0,  219, 
            0,  219,    0,  288,  288,  288,    0,    0,  288,  288, 
          288,    0,  288,    0,    0,    0,    0,  219,    0,    0, 
            0,    0,  288,  288,    0,    0,    0,    0,    0,  219, 
            0,  288,  288,    0,  288,  288,  288,  288,  288,    0, 
            0,   63,  219,  644,  644,  644,    0,    0,  644,  644, 
          644,    0,  644,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  644,  644,    0,    0,    0,    0,    0,    0, 
            0,  644,  644,    0,  644,  644,  644,  644,  644,    0, 
            0,    0,    0,  288,   56,    0,  288,    0,  288,    0, 
            0,    0,    0,    0,   56,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  288,  424,  424,  424,    0,    0, 
          424,  424,  424,    0,  424,    0,    0,    0,    0,    0, 
            0,   57,    0,  644,  424,    0,  644,    0,  644,  288, 
            0,   57,    0,  424,  424,    0,  424,  424,  424,  424, 
          424,    0,    0,   56,  644,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   61,   61,   61,    0,    0, 
           61,   61,   61,    0,   61,    0,    0,    0,    0,  644, 
            0,  424,    0,    0,   61,   61,    0,    0,  424,  424, 
           57,    0,    0,   61,   61,  424,   61,   61,   61,   61, 
           61,   65,   65,   65,    0,    0,   65,   65,   65,    0, 
           65,    0,    0,    0,    0,    0,  424,    0,    0,    0, 
           65,   65,    0,    0,    0,    0,    0,    0,    0,   65, 
           65,    0,   65,   65,   65,   65,   65,    0,    0,    0, 
            0,  424,    0,    0,    0,   61,    0,    0,   61,    0, 
            0,    0,    0,    0,   63,   63,   63,    0,    0,   63, 
           63,   63,  292,   63,    0,    0,   61,    0,    0,    0, 
            0,    0,  292,   63,   63,    0,    0,    0,    0,    0, 
          293,   65,   63,   63,   65,   63,   63,   63,   63,   63, 
          293,   61,    0,    0,    0,    0,    0,    0,    0,    0, 
          219,    0,   65,    0,    0,    0,  288,    0,    0,    0, 
          219,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  292,    0,    0,  289,    0,    0,   65,    0,    0, 
            0,    0,    0,    0,   63,    0,    0,   63,    0,  293, 
            0,    0,    0,    0,  263,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   63,   56,   56,   56,  219, 
            0,   56,   56,   56,  291,   56,    0,    0,    0,    0, 
            0,    0,    0,    0,  291,   56,    0,    0,    0,    0, 
           63,    0,    0,    0,   56,   56,    0,   56,   56,   56, 
           56,   56,    0,   57,   57,   57,    0,    0,   57,   57, 
           57,    0,   57,    0,    0,    0,    0,    0,  286,    0, 
            0,    0,   57,    0,    0,    0,    0,    0,    0,    0, 
            0,   57,   57,  291,   57,   57,   57,   57,   57,    0, 
            0,    0,    0,    0,    0,    0,   56,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   56,    0,    0, 
            0,    0,    0,    0,    0,    0,  305,    0,    0,    0, 
            0,    0,    0,   57,    0,    0,    0,    0,    0,    0, 
            0,    0,   56,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   57,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   57, 
            0,    0,    0,    0,  292,  292,  292,    0,    0,  292, 
          292,  292,    0,  292,    0,    0,    0,    0,    0,    0, 
            0,    0,  293,  293,  293,    0,    0,  293,  293,  293, 
            0,  293,    0,    0,    0,  292,  292,  292,  292,  292, 
            0,    0,  219,  219,  219,    0,    0,    0,  219,  219, 
            0,  219,    0,  293,  293,  293,  293,  293,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          219,  219,    0,  219,  219,  219,  219,    0,  130,    0, 
            0,  292,    0,    0,  292,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  293, 
            0,    0,  293,    0,    0,  292,  291,  291,  291,    0, 
            0,    0,  291,  291,    0,  291,    0,    0,    0,    0, 
            0,    0,  219,  293,    0,    0,    0,  130,    0,    0, 
          292,    0,    0,    0,    0,    0,    0,  291,  291,  291, 
          291,  291,    0,  219,    0,    0,    0,    0,  293,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  511, 
            0,    0,    0,    0,    0,    0,    0,    0,  219,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  291,    0,    0,    0, 
            0,    0,    0,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,  291,   12,   13, 
           14,   15,   16,   17,   18,    0,  131,    0,    0,   19, 
           20,   21,  236,  237,  238,  239,    0,    0,  118,    0, 
            0,    0,  291,    0,    0,   28,    0,    0,  240,  241, 
          242,    0,  243,   35,  244,  245,  246,  247,  282,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  131,    0,    0,    0,    0, 
            0,    0,    0,  248,    0,    0,  131,    0,    0,   46, 
           47,    0,   48,    0,  283,    0,  284,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  285,  514,    0,    0, 
            0,   52,  286,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
            0,   66,   67,  287,  130,  130,  130,  130,  130,  130, 
          130,  130,  130,  130,  130,    0,    0,  130,  130,    0, 
          130,  130,  130,  130,  130,  130,  130,    0,  614,    0, 
          130,  130,  130,  130,  130,  130,  130,  130,    0,    0, 
          130,    0,    0,    0,    0,    0,  130,  130,    0,  130, 
          130,  130,  130,    0,  130,  130,  130,  130,  130,  130, 
            0,  130,  130,  130,  130,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  511,    0,    0,  130, 
            0,    0,    0,  511,  511,  130,    0,    0,  130,  614, 
            0,  130,  130,    0,  130,    0,  130,    0,    0,    0, 
          130,    0,    0,    0,    0,  130,    0,    0,  130,    0, 
          614,  621,    0,  130,  130,  130,  130,  130,  130,    0, 
            0,    0,  130,    0,  130,  130,    0,  130,  130,  130, 
          130,    0,  130,  130,  130,    0,    0,    0,    0,    0, 
            0,    0,  131,  131,  131,  131,  131,  131,  131,  131, 
          131,  131,  131,    0,    0,  131,  131,    0,  131,  131, 
          131,  131,  131,  131,  131,    0,  615,    0,  131,  131, 
          131,  131,  131,  131,  131,  131,    0,    0,  131,    0, 
            0,    0,    0,    0,  131,  131,    0,  131,  131,  131, 
          131,    0,  131,  131,  131,  131,  131,  131,    0,  131, 
          131,  131,  131,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  514,    0,    0,  131,    0,    0, 
            0,  514,  514,  131,    0,    0,  131,  615,    0,  131, 
          131,    0,  131,    0,  131,    0,    0,    0,  131,    0, 
            0,    0,    0,  131,    0,    0,  131,    0,  615,  314, 
            0,  131,  131,  131,  131,  131,  131,    0,    0,    0, 
          131,    0,  131,  131,    0,  131,  131,  131,  131,    0, 
          131,  131,  131,    0,    0,    0,  130,  130,  130,  130, 
          130,  130,  130,  130,  130,  130,  130,    0,    0,  130, 
          130,    0,  130,  130,  130,  130,  130,  130,  130,    0, 
          621,    0,  131,  130,  130,  130,  130,  130,  130,  130, 
            0,    0,  130,    0,    0,    0,    0,    0,  130,  130, 
            0,  130,  130,  130,  130,    0,  130,  130,  130,  130, 
          130,  130,    0,  130,  130,  130,  130,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  621,    0, 
            0,  131,    0,    0,    0,  621,  621,  130,    0,    0, 
          130,  617,    0,  130,  130,    0,  130,    0,  130,    0, 
            0,    0,  130,    0,    0,    0,    0,  130,    0,    0, 
          130,    0,  621,  315,    0,  130,  130,  130,  130,  130, 
          130,    0,    0,    0,  130,    0,  130,  130,    0,  130, 
          130,  130,  130,    0,  130,  130,  130,    0,    0,    0, 
            0,    0,    0,    0,  131,  131,  131,  131,  131,  131, 
          131,  131,  131,  131,  131,    0,    0,  131,  131,    0, 
          131,  131,  131,  131,  131,  131,  131,    0,  359,    0, 
            0,  131,  131,  131,  131,  131,  131,  131,    0,    0, 
          131,    0,    0,    0,    0,    0,  131,  131,    0,  131, 
          131,  131,  131,    0,  131,  131,  131,  131,  131,  131, 
            0,  131,  131,  131,  131,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  314,  359,    0,    0, 
            0,    0,    0,  314,  314,  131,    0,    0,  131,  618, 
            0,  131,  131,    0,  131,    0,  131,    0,    0,    0, 
          131,    0,    0,    0,    0,  131,    0,    0,  131,    0, 
            0,    0,    0,  131,  131,  131,  131,  131,  131,    0, 
            0,    0,  131,    0,  131,  131,    0,  131,  131,  131, 
          131,    0,  131,  131,  131,    0,    0,    0,  131,  131, 
          131,  131,  131,  131,  131,  131,  131,  131,  131,    0, 
            0,  131,  131,    0,  131,  131,  131,  131,  131,  131, 
          131,    0,  306,    0,    0,  131,  131,  131,  131,  131, 
          131,  131,    0,    0,  131,    0,    0,    0,    0,    0, 
          131,  131,    0,  131,  131,  131,  131,    0,  131,  131, 
          131,  131,  131,  131,    0,  131,  131,  131,  131,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          315,  306,    0,    0,    0,    0,    0,  315,  315,  131, 
            0,    0,  131,    0,    0,  131,  131,    0,  131,    0, 
          131,    0,    0,    0,  131,    0,    0,    0,    0,  131, 
            0,    0,  131,    0,    0,    0,    0,  131,  131,  131, 
          131,  131,  131,    0,    0,    0,  131,    0,  131,  131, 
            0,  131,  131,  131,  131,    0,  131,  131,  131,    0, 
            0,    0,    0,    0,  359,  359,  359,  359,  359,  359, 
          359,  359,  359,  359,  359,    0,  359,  359,  359,  359, 
          359,  359,  359,  359,  359,  359,  359,  539,    0,    0, 
            0,  359,  359,  359,  359,  359,  359,  359,    0,    0, 
          359,    0,    0,    0,    0,    0,  359,  359,    0,  359, 
          359,  359,  359,    0,  359,  359,  359,  359,  359,  359, 
            0,  359,  359,  359,  359,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  539,    0,    0,    0, 
            0,    0,    0,    0,    0,  359,    0,    0,  359,    0, 
            0,  359,  359,    0,  359,    0,  359,    0,    0,    0, 
          359,    0,    0,    0,    0,    0,    0,    0,  359,    0, 
            0,    0,    0,  359,  359,  359,  359,  359,  359,    0, 
            0,    0,  359,    0,  359,  359,    0,  359,  359,  359, 
          359,    0,  359,  359,  359,    0,    0,    0,  306,  306, 
          306,  306,  306,  306,  306,  306,  306,  306,  306,    0, 
            0,  306,  306,    0,  306,  306,  306,  306,  306,  306, 
          306,  643,    0,    0,    0,  306,  306,  306,  306,  306, 
          306,  306,    0,    0,  306,    0,    0,    0,    0,    0, 
          306,  306,    0,  306,  306,  306,  306,    0,  306,  306, 
          306,  306,  306,  306,    0,  306,  306,  306,  306,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          643,    0,    0,    0,    0,    0,    0,    0,    0,  306, 
            0,    0,  306,    0,    0,  306,  306,    0,  306,    0, 
          306,    0,    0,    0,  306,    0,    0,    0,    0,    0, 
            0,    0,  306,    0,   18,    0,    0,  306,  306,  306, 
          306,  306,  306,    0,    0,    0,  306,    0,  306,  306, 
            0,  306,  306,  306,  306,    0,  306,  306,  306,    0, 
            0,    0,    0,  539,  539,  539,  539,  539,  539,  539, 
          539,  539,  539,  539,    0,    0,  539,  539,    0,  539, 
          539,  539,  539,  539,  539,  539,  643,    0,    0,    0, 
          539,  539,  539,  539,  539,  539,  539,    0,    0,  539, 
            0,    0,    0,    0,    0,  539,  539,    0,  539,  539, 
          539,  539,    0,  539,  539,  539,  539,  539,  539,    0, 
          539,  539,  539,  539,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  643,    0,    0,    0,    0, 
            0,    0,    0,    0,  539,    0,    0,  539,    0,    0, 
          539,  539,    0,  539,    0,  539,    0,    0,    0,  539, 
            0,    0,    0,    0,    0,    0,    0,  539,    0,    0, 
            0,    0,  539,  539,  539,  539,  539,  539,    0,    0, 
            0,  539,    0,  539,  539,    0,  539,  539,  539,  539, 
            0,  539,  539,  539,    0,    0,    0,  643,  643,  643, 
          643,  643,  643,    0,    0,  643,  643,  643,    0,    0, 
            0,  643,    0,  643,  643,  643,  643,  643,  643,  643, 
          257,    0,    0,    0,  643,  643,  643,  643,  643,  643, 
          643,    0,    0,  643,    0,    0,    0,    0,    0,  643, 
          643,    0,  643,  643,  643,  643,    0,  643,  643,  643, 
          643,  643,  643,    0,  643,  643,  643,  643,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  256, 
            0,    0,    0,    0,    0,    0,    0,    0,  643,    0, 
            0,  643,    0,    0,  643,  643,    0,  643,    0,  643, 
            0,    0,    0,  643,    0,    0,    0,    0,    0,    0, 
            0,  643,    0,    0,    0,    0,  643,  643,  643,  643, 
          643,  643,    0,    0,    0,  643,    0,  643,  643,    0, 
          643,  643,  643,  643,    0,  643,  643,  643,    0,    0, 
            0,    0,  643,  643,  643,  643,  643,  643,    0,    0, 
            0,  643,  643,    0,    0,    0,  643,    0,  643,  643, 
          643,  643,  643,  643,  643,  308,    0,    0,    0,  643, 
          643,  643,  643,  643,  643,  643,    0,    0,  643,    0, 
            0,    0,    0,    0,  643,  643,    0,  643,  643,  643, 
          643,    0,  643,  643,  643,  643,  643,  643,    0,  643, 
          643,  643,  643,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  643,    0,    0,  643,    0,    0,  643, 
          643,    0,  643,    0,  643,    0,    0,    0,  643,    0, 
            0,    0,    0,    0,    0,    0,  643,    0,    0,  643, 
            0,  643,  643,  643,  643,  643,  643,    0,    0,    0, 
          643,    0,  643,  643,    0,  643,  643,  643,  643,    0, 
          643,  643,  643,    0,    0,    0,    0,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,  305, 
            0,    0,    0,   19,   20,   21,  236,  237,  238,  239, 
            0,    0,   26,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,  240,  241,  242,    0,  243,   35,  244,  245, 
          246,  247,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  248,    0,    0, 
          131,    0,    0,   46,   47,    0,   48,    0,    0,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
           51,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,    0,   66,   67,    0,    0,    0, 
            0,    0,  310,  310,  310,    0,  310,    0,    0,    0, 
          310,  310,    0,    0,    0,  310,    0,  310,  310,  310, 
          310,  310,  310,  310,    0,    0,    0,    0,  310,  310, 
          310,  310,  310,  310,  310,    0,    0,  310,    0,    0, 
            0,    0,    0,    0,  310,    0,    0,  310,  310,  310, 
            0,  310,  310,  310,  310,  310,  310,  350,  310,  310, 
          310,  310,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  310,    0,    0,  310,    0,  308,  310,  310, 
            0,  310,    0,    0,    0,    0,    0,  310,    0,    0, 
            0,    0,    0,    0,    0,  310,    0,    0,    0,    0, 
          310,  310,  310,  310,  310,  310,    0,    0,    0,  310, 
            0,  310,  310,    0,  310,  310,  310,  310,    0,    0, 
          310,  310,    0,    0,    0,    0,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   15,   16,   17,   18,    0,    0, 
            0,    0,   19,   20,   21,  236,  237,  238,  239,    0, 
            0,   26,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,  240,  241,  242,    0,  243,   35,  244,  245,  246, 
          247,  657,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  248,    0,    0,  131, 
            0,    0,   46,   47,    0,   48,    0,    0,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0, 
      };
   }

   private static final short[] yyTable4() {
      return new short[] {

           51,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,    0,   66,   67,    0,    0,    0, 
            0,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  109, 
          110,   17,   18,    0,    0,    0,    0,  111,  112,  113, 
          337,  338,  339,  340,    0,    0,  118,    0,    0,    0, 
            0,    0,    0,  119,    0,    0,  341,  342,  343,    0, 
          344,   35,  345,  346,  347,  348,    0,   40,    0,    0, 
          128,    0,    0,    0,    0,    0,    0,  470,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  349,    0,    0,  131,    0,    0,   46,   47,    0, 
           48,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,    0,   66, 
           67,    0,    0,    0,    0,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  109,  110,   17,   18,    0,    0,    0, 
            0,  111,  112,  113,  337,  338,  339,  340,    0,    0, 
          118,    0,    0,    0,    0,    0,    0,  119,    0,    0, 
          341,  342,  343,    0,  344,   35,  345,  346,  347,  348, 
            0,   40,    0,    0,  128,    0,    0,  470,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  349,    0,    0,  131,    0, 
            0,   46,   47,    0,   48,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,    0,   66,   67,    4,    5,    6,    7,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
           26,    0,    0,    0,    0,    0,   27,   28,   29,   30, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   44,    0,    0,   45,    0, 
            0,   46,   47,    0,   48,    0,   49,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,   51,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,   65,   66,   67,    4,    5,    6,    7,  318, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
           26,    0,    0,    0,    0,    0,   27,   28,    0,   30, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   44,    0,    0,   45,    0, 
            0,   46,   47,    0,   48,    0,   49,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,   51,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,   65,   66,   67,  139,  140,  141,  142,  143, 
          144,  145,  146,  147,  148,  149,  150,  151,  152,  153, 
          154,  155,  156,  157,  158,  159,  160,  161,  162,    0, 
            0,  163,  164,  165,  166,  167,  168,  169,  170,  171, 
          172,    0,    0,    0,    0,  173,  174,  175,  176,  177, 
          178,  179,  180,    0,  181,  182,  124,  125,  183,  127, 
            0,    0,  184,  185,    0,  186,  187,  188,  189,  190, 
          191,  192,    0,    0,  193,  194,    0,    0,    0,  195, 
          196,  197,  198,    0,    0,    0,    0,    0,    0,  199, 
            0,    0,    0,    0,    0,    0,  200,  201,    0,  202, 
          203,  204,  205,  206,  207,  208,  209,  210,  211,  212, 
            0,    0,  213,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  214,  139,  140,  141,  142, 
          143,  144,  145,  146,  147,  148,  149,  150,  151,  152, 
          153,  154,  155,  156,  157,  158,  159,  160,  161,  162, 
            0,    0,  163,  164,  165,  220,  221,  222,  223,  170, 
          171,  172,    0,    0,    0,    0,  173,  174,  175,  176, 
          177,  224,  225,  226,    0,  227,  182,  357,  358,  228, 
          359,    0,    0,  184,  185,    0,  186,  187,  188,  189, 
          190,  191,  192,    0,    0,  193,  194,    0,    0,    0, 
          195,  196,  197,  198,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  200,  201,    0, 
          202,  203,  204,  205,  206,  207,  208,  209,  210,  211, 
          212,    0,    0,  213,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  214,  139,  140,  141, 
          142,  143,  144,  145,  146,  147,  148,  149,  150,  151, 
          152,  153,  154,  155,  156,  157,  158,  159,  160,  161, 
          162,    0,    0,  163,  164,  165,  220,  221,  222,  223, 
          170,  171,  172,    0,    0,    0,    0,  173,  174,  175, 
          176,  177,  224,  225,  226,    0,  227,  182,  307,    0, 
          228,    0,    0,    0,  184,  185,    0,  186,  187,  188, 
          189,  190,  191,  192,    0,    0,  193,  194,    0,    0, 
            0,  195,  196,  197,  198,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  200,  201, 
            0,  202,  203,  204,  205,  206,  207,  208,  209,  210, 
          211,  212,    0,    0,  213,   52,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  214,  139,  140, 
          141,  142,  143,  144,  145,  146,  147,  148,  149,  150, 
          151,  152,  153,  154,  155,  156,  157,  158,  159,  160, 
          161,  162,    0,    0,  163,  164,  165,  220,  221,  222, 
          223,  170,  171,  172,    0,    0,    0,    0,  173,  174, 
          175,  176,  177,  224,  225,  226,    0,  227,  182,    0, 
            0,  228,    0,    0,    0,  184,  185,    0,  186,  187, 
          188,  189,  190,  191,  192,    0,    0,  193,  194,    0, 
            0,    0,  195,  196,  197,  198,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  200, 
          201,    0,  202,  203,  204,  205,  206,  207,  208,  209, 
          210,  211,  212,    0,    0,  213,   52,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  214,  139, 
          140,  141,  142,  143,  144,  145,  146,  147,  148,  149, 
          150,  151,  152,  153,  154,  155,  156,  157,  158,  159, 
          160,  161,  162,    0,    0,  163,  164,  165,  220,  221, 
          222,  223,  170,  171,  172,    0,    0,    0,    0,  173, 
          174,  175,  176,  177,  224,  225,  226,    0,  227,  182, 
            0,    0,  228,    0,    0,    0,  184,  185,    0,  186, 
          187,  188,  189,  190,  191,  192,    0,    0,  193,  194, 
            0,    0,    0,  195,  196,  197,  198,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          200,  201,    0,  202,  203,  204,  205,  206,  207,  208, 
          209,  210,  211,  212,    0,    0,  213,    0,    0,    0, 
            0,    0,    0,    0,    3,    4,    5,    6,    7,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,  214, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
           26,    0,    0,    0,    0,    0,   27,   28,   29,   30, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   44,    0,    0,   45,    0, 
            0,   46,   47,    0,   48,    0,   49,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,   51,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,   65,   66,   67,  317,    4,    5,    6,    7, 
          318,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   15,   16,   17,   18,    0,    0, 
            0,    0,   19,   20,   21,   22,   23,   24,   25,    0, 
            0,   26,    0,    0,    0,    0,    0,   27,   28,    0, 
           30,   31,   32,   33,    0,   34,   35,   36,   37,   38, 
           39,    0,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   44,    0,    0,  319, 
            0,    0,   46,   47,    0,   48,    0,   49,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,   51, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,   65,   66,   67,  317,    4,    5,    6, 
            7,  318,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
            0,    0,    0,   19,   20,   21,   22,   23,   24,   25, 
            0,    0,   26,    0,    0,    0,    0,    0,   27,   28, 
            0,   30,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   44,    0,    0, 
           45,    0,    0,   46,   47,    0,   48,    0,   49,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
           51,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,   65,   66,   67,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
            0,    0,    0,   19,   20,   21,  236,  237,  238,  239, 
            0,    0,  118,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,  240,  241,  242,    0,  243,   35,  244,  245, 
          246,  247,  282,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  248,    0,    0, 
          131,    0,    0,   46,   47,    0,   48,    0,  283,    0, 
          284,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          285,    0,    0,    0,    0,   52,  286,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,    0,   66,   67,  287,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,  109,  110,   17,   18, 
            0,    0,    0,    0,  111,  112,  113,  236,  237,  238, 
          239,    0,    0,  118,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,  240,  241,  242,    0,  243,   35,  244, 
          245,  246,  247,  282,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  248,    0, 
            0,  131,    0,    0,   46,   47,    0,   48,    0,  712, 
            0,  284,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,  285,    0,    0,    0,    0,   52,  286,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,    0,   66,   67,  287,  281, 
          281,  281,    0,  281,    0,    0,    0,  281,  281,    0, 
            0,    0,  281,    0,  281,  281,  281,  281,  281,  281, 
          281,    0,    0,    0,    0,  281,  281,  281,  281,  281, 
          281,  281,    0,    0,  281,    0,    0,    0,    0,    0, 
            0,  281,    0,    0,  281,  281,  281,    0,  281,  281, 
          281,  281,  281,  281,  281,  281,  281,  281,  281,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  281, 
            0,    0,  281,    0,    0,  281,  281,    0,  281,    0, 
          281,    0,  281,    0,  281,    0,    0,    0,    0,    0, 
            0,    0,  281,    0,    0,    0,    0,  281,  281,  281, 
          281,  281,  281,    0,    0,    0,  281,    0,  281,  281, 
            0,  281,  281,  281,  281,    0,    0,  281,  281,  281, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  109,  110, 
           17,   18,    0,    0,    0,    0,  111,  112,  113,  236, 
          237,  238,  239,    0,    0,  118,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  240,  241,  242,    0,  243, 
           35,  244,  245,  246,  247,  282,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          248,    0,    0,  131,    0,    0,   46,   47,    0,   48, 
            0,  283,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  285,    0,    0,    0,    0,   52,  286, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,    0,   66,   67, 
          287,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  109, 
          110,   17,   18,    0,    0,    0,    0,  111,  112,  113, 
          236,  237,  238,  239,    0,    0,  118,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  240,  241,  242,    0, 
          243,   35,  244,  245,  246,  247,  282,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  248,    0,    0,  131,    0,    0,   46,   47,    0, 
           48,    0,    0,    0,  284,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,  285,    0,    0,    0,    0,   52, 
          286,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,    0,   66, 
           67,  287,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          109,  110,   17,   18,    0,    0,    0,    0,  111,  112, 
          113,  236,  237,  238,  239,    0,    0,  118,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,  240,  241,  242, 
            0,  243,   35,  244,  245,  246,  247,  282,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  248,    0,    0,  131,    0,    0,   46,   47, 
            0,   48,    0,  712,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,  285,    0,    0,    0,    0, 
           52,  286,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,    0, 
           66,   67,  287,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  109,  110,   17,   18,    0,    0,    0,    0,  111, 
          112,  113,  236,  237,  238,  239,    0,    0,  118,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,  240,  241, 
          242,    0,  243,   35,  244,  245,  246,  247,  282,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  248,    0,    0,  131,    0,    0,   46, 
           47,    0,   48,    0,    0,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  285,    0,    0,    0, 
            0,   52,  286,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
            0,   66,   67,  287,    4,    5,    6,    7,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
           19,   20,   21,   22,   23,   24,   25,    0,    0,   26, 
            0,    0,    0,    0,    0,   27,   28,   29,   30,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   44,    0,    0,   45,    0,    0, 
           46,   47,    0,   48,    0,   49,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,   51,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,   65,   66,   67,    4,    5,    6,    7,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
           19,   20,   21,   22,   23,   24,   25,    0,    0,   26, 
            0,    0,    0,    0,    0,   27,   28,    0,   30,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   44,    0,    0,   45,    0,    0, 
           46,   47,    0,   48,    0,   49,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,   51,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,   65,   66,   67,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  109,  110,   17,   18,    0,    0,    0,    0, 
          111,  112,  113,  236,  237,  238,  239,    0,    0,  118, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  240, 
          241,  242,    0,  243,   35,  244,  245,  246,  247,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  248,    0,    0,  131,  505,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  285,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,   66,   67,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
           19,   20,   21,  236,  237,  238,  239,    0,    0,  118, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  240, 
          241,  242,    0,  243,   35,  244,  245,  246,  247,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  248,    0,    0,  131,    0,    0, 
           46,   47,    0,   48,    0,  648,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  285,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,   66,   67,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  109,  110,   17,   18,    0,    0,    0,    0, 
          111,  112,  113,  236,  237,  238,  239,    0,    0,  118, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  240, 
          241,  242,    0,  243,   35,  244,  245,  246,  247,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  248,    0,    0,  131,    0,    0, 
           46,   47,    0,   48,    0,  283,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  285,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,   66,   67,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  109,  110,   17,   18,    0,    0,    0,    0, 
          111,  112,  113,  236,  237,  238,  239,    0,    0,  118, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  240, 
          241,  242,    0,  243,   35,  244,  245,  246,  247,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  248,    0,    0,  131,    0,    0, 
           46,   47,    0,   48,    0,  648,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  285,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,   66,   67,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  109,  110,   17,   18,    0,    0,    0,    0, 
          111,  112,  113,  236,  237,  238,  239,    0,    0,  118, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  240, 
          241,  242,    0,  243,   35,  244,  245,  246,  247,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  248,    0,    0,  131,    0,    0, 
           46,   47,    0,   48,    0,  909,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  285,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,   66,   67,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  109,  110,   17,   18,    0,    0,    0,    0, 
          111,  112,  113,  236,  237,  238,  239,    0,    0,  118, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  240, 
          241,  242,    0,  243,   35,  244,  245,  246,  247,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  248,    0,    0,  131,    0,    0, 
           46,   47,    0,   48,    0,  712,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  285,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,   66,   67,  632,  632,  632,    0,  632,    0, 
            0,    0,  632,  632,    0,    0,    0,  632,    0,  632, 
          632,  632,  632,  632,  632,  632,    0,    0,    0,    0, 
          632,  632,  632,  632,  632,  632,  632,    0,    0,  632, 
            0,    0,    0,    0,    0,    0,  632,    0,    0,  632, 
          632,  632,    0,  632,  632,  632,  632,  632,  632,    0, 
          632,  632,  632,  632,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  632,    0,    0,  632,  632,    0, 
          632,  632,    0,  632,    0,    0,    0,    0,    0,  632, 
            0,    0,    0,    0,    0,    0,    0,  632,    0,    0, 
            0,    0,  632,  632,  632,  632,  632,  632,    0,    0, 
            0,  632,    0,  632,  632,    0,  632,  632,  632,  632, 
            0,    0,  632,  632,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
           19,   20,   21,  236,  237,  238,  239,    0,    0,   26, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  240, 
          241,  242,    0,  243,   35,  244,  245,  246,  247,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  248,    0,    0,  131,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,   51,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,   66,   67,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  109,  110,   17,   18,    0,    0,    0,    0, 
          111,  112,  113,  236,  237,  238,  239,    0,    0,  118, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  240, 
          241,  242,    0,  243,   35,  244,  245,  246,  247,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  248,    0,    0,  131,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  285,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,   66,   67,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
           19,   20,   21,  236,  237,  238,  239,    0,    0,  118, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  240, 
          241,  242,    0,  243,   35,  244,  245,  246,  247,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  248,    0,    0,  131,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  285,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,   66,   67,  632,  632,  632,    0,  632,    0, 
            0,    0,  632,  632,    0,    0,    0,  632,    0,  632, 
          632,  632,  632,  632,  632,  632,    0,    0,    0,    0, 
          632,  632,  632,  632,  632,  632,  632,    0,    0,  632, 
            0,    0,    0,    0,    0,    0,  632,    0,    0,  632, 
          632,  632,    0,  632,  632,  632,  632,  632,  632,    0, 
          632,  632,  632,  632,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  632,    0,    0,  632,    0,    0, 
          632,  632,    0,  632,    0,    0,    0,    0,    0,  632, 
            0,    0,    0,    0,    0,    0,    0,  632,    0,    0, 
            0,    0,  632,  632,  632,  632,  632,  632,    0,    0, 
            0,  632,    0,  632,  632,    0,  632,  632,  632,  632, 
            0,    0,  632,  632,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  109,  110,   17,   18,    0,    0,    0,    0, 
          111,  112,  113,  114,  115,  116,  117,    0,    0,  118, 
            0,    0,    0,    0,    0,    0,  119,    0,    0,  120, 
          121,  122,    0,  123,   35,  124,  125,  126,  127,    0, 
           40,    0,    0,  128,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          129,    0,    0,    0,  130,    0,    0,  131,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,   66,   67,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  109,  110,   17,   18,    0,    0,    0,    0, 
          111,  112,  113,  264,  265,  266,  267,    0,    0,  118, 
            0,    0,    0,    0,    0,    0,  119,    0,    0,  268, 
          269,  270,    0,  271,   35,  272,  273,  274,  275,    0, 
           40,    0,    0,  128,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  276,    0,    0,   45,    0,    0, 
           46,   47,    0,   48,    0,   49,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,   66,   67,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  109,  110,   17,   18,    0,    0,    0,    0, 
          111,  112,  113,  337,  338,  339,  340,    0,    0,  118, 
            0,    0,    0,    0,    0,    0,  119,    0,    0,  341, 
          342,  343,    0,  344,   35,  345,  346,  347,  348,    0, 
           40,    0,    0,  128,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  349,    0,    0,  426,    0,    0, 
           46,   47,    0,   48,    0,  427,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,   66,   67,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  109,  110,   17,   18,    0,    0,    0,    0, 
          111,  112,  113,  114,  115,  116,  117,    0,    0,  118, 
            0,    0,    0,    0,    0,    0,  119,    0,    0,  120, 
          121,  122,    0,  123,   35,  124,  125,  126,  127,    0, 
           40,    0,    0,  128,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  130,    0,    0,  131,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,   66,   67,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  109,  110,   17,   18,    0,    0,    0,    0, 
          111,  112,  113,  337,  338,  339,  340,    0,    0,  118, 
            0,    0,    0,    0,    0,    0,  119,    0,    0,  341, 
          342,  343,    0,  344,   35,  345,  346,  347,  348,    0, 
           40,    0,    0,  128,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  349,    0,    0,  426,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,   66,   67,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  109,  110,   17,   18,    0,    0,    0,    0, 
          111,  112,  113,  114,  115,  116,  117,    0,    0,  118, 
            0,    0,    0,    0,    0,    0,  119,    0,    0,  120, 
          121,  122,    0,  970,   35,  124,  125,  971,  127,    0, 
           40,    0,    0,  128,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  972,    0,    0,  131,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,   66,   67,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  109,  110,   17,   18,    0,    0,    0,    0, 
          111,  112,  113,  985,  986,  987,  988,    0,    0,  118, 
            0,    0,    0,    0,    0,    0,  119,    0,    0,  989, 
          990,  991,    0,  992,   35,  993,  994,  995,  996,    0, 
           40,    0,    0,  128,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  997,    0,    0,  131,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
          629,  630,   66,   67,  631,    0,    0,    0,  184,  185, 
            0,  186,  187,  188,  189,  190,  191,  192,    0,    0, 
          193,  194,    0,    0,    0,  195,  196,  197,  198,    0, 
            0,    0,    0,    0,    0,  301,    0,    0,    0,    0, 
            0,    0,  200,  201,    0,  202,  203,  204,  205,  206, 
          207,  208,  209,  210,  211,  212,    0,    0,  213,  637, 
          638,    0,    0,  639,    0,    0,    0,  184,  185,    0, 
          186,  187,  188,  189,  190,  191,  192,    0,    0,  193, 
          194,  214,    0,    0,  195,  196,  197,  198,    0,    0, 
            0,    0,    0,    0,  301,    0,    0,    0,    0,    0, 
            0,  200,  201,    0,  202,  203,  204,  205,  206,  207, 
          208,  209,  210,  211,  212,    0,    0,  213,  672,  630, 
            0,    0,  673,    0,    0,    0,  184,  185,    0,  186, 
          187,  188,  189,  190,  191,  192,    0,    0,  193,  194, 
          214,    0,    0,  195,  196,  197,  198,    0,    0,    0, 
            0,    0,    0,  301,    0,    0,    0,    0,    0,    0, 
          200,  201,    0,  202,  203,  204,  205,  206,  207,  208, 
          209,  210,  211,  212,    0,    0,  213,  643,  638,    0, 
            0,  644,    0,    0,    0,  184,  185,    0,  186,  187, 
          188,  189,  190,  191,  192,    0,    0,  193,  194,  214, 
            0,    0,  195,  196,  197,  198,    0,    0,    0,    0, 
            0,    0,  301,    0,    0,    0,    0,    0,    0,  200, 
          201,    0,  202,  203,  204,  205,  206,  207,  208,  209, 
          210,  211,  212,    0,    0,  213,  690,  630,    0,    0, 
          691,    0,    0,    0,  184,  185,    0,  186,  187,  188, 
          189,  190,  191,  192,    0,    0,  193,  194,  214,    0, 
            0,  195,  196,  197,  198,    0,    0,    0,    0,    0, 
            0,  301,    0,    0,    0,    0,    0,    0,  200,  201, 
            0,  202,  203,  204,  205,  206,  207,  208,  209,  210, 
          211,  212,    0,    0,  213,  693,  638,    0,    0,  694, 
            0,    0,    0,  184,  185,    0,  186,  187,  188,  189, 
          190,  191,  192,    0,    0,  193,  194,  214,    0,    0, 
          195,  196,  197,  198,    0,    0,    0,    0,    0,    0, 
          301,    0,    0,    0,    0,    0,    0,  200,  201,    0, 
          202,  203,  204,  205,  206,  207,  208,  209,  210,  211, 
          212,    0,    0,  213,  704,  630,    0,    0,  705,    0, 
            0,    0,  184,  185,    0,  186,  187,  188,  189,  190, 
          191,  192,    0,    0,  193,  194,  214,    0,    0,  195, 
          196,  197,  198,    0,    0,    0,    0,    0,    0,  301, 
            0,    0,    0,    0,    0,    0,  200,  201,    0,  202, 
          203,  204,  205,  206,  207,  208,  209,  210,  211,  212, 
            0,    0,  213,  707,  638,    0,    0,  708,    0,    0, 
            0,  184,  185,    0,  186,  187,  188,  189,  190,  191, 
          192,    0,    0,  193,  194,  214,    0,    0,  195,  196, 
          197,  198,    0,    0,    0,    0,    0,    0,  301,    0, 
            0,    0,    0,    0,    0,  200,  201,    0,  202,  203, 
          204,  205,  206,  207,  208,  209,  210,  211,  212,    0, 
            0,  213,  735,  630,    0,    0,  736,    0,    0,    0, 
          184,  185,    0,  186,  187,  188,  189,  190,  191,  192, 
            0,    0,  193,  194,  214,    0,    0,  195,  196,  197, 
          198,    0,    0,    0,    0,    0,    0,  301,    0,    0, 
            0,    0,    0,    0,  200,  201,    0,  202,  203,  204, 
          205,  206,  207,  208,  209,  210,  211,  212,    0,    0, 
          213,  738,  638,    0,    0,  739,    0,    0,    0,  184, 
          185,    0,  186,  187,  188,  189,  190,  191,  192,    0, 
            0,  193,  194,  214,    0,    0,  195,  196,  197,  198, 
            0,    0,    0,    0,    0,    0,  301,    0,    0,    0, 
            0,    0,    0,  200,  201,    0,  202,  203,  204,  205, 
          206,  207,  208,  209,  210,  211,  212,    0,    0,  213, 
         1066,  630,    0,    0, 1067,    0,    0,    0,  184,  185, 
            0,  186,  187,  188,  189,  190,  191,  192,    0,    0, 
          193,  194,  214,    0,    0,  195,  196,  197,  198,    0, 
            0,    0,    0,    0,    0,  301,    0,    0,    0,    0, 
            0,    0,  200,  201,    0,  202,  203,  204,  205,  206, 
          207,  208,  209,  210,  211,  212,    0,    0,  213, 1069, 
          630,    0,    0, 1070,    0,    0,    0,  184,  185,    0, 
          186,  187,  188,  189,  190,  191,  192,    0,    0,  193, 
          194,  214,    0,    0,  195,  196,  197,  198,    0,    0, 
            0,    0,    0,    0,  301,    0,    0,    0,    0,    0, 
            0,  200,  201,    0,  202,  203,  204,  205,  206,  207, 
          208,  209,  210,  211,  212,    0,    0,  213, 1072,  638, 
            0,    0, 1073,    0,    0,    0,  184,  185,    0,  186, 
          187,  188,  189,  190,  191,  192,    0,    0,  193,  194, 
          214,    0,    0,  195,  196,  197,  198,    0,    0,    0, 
            0,    0,    0,  301,    0,    0,    0,    0,    0,    0, 
          200,  201,    0,  202,  203,  204,  205,  206,  207,  208, 
          209,  210,  211,  212,    0,    0,  213,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  214, 
      };
   }

   private static final short[] yyCheck1() {
      return new short[] {

           26,   75,   28,    2,    3,    4,    5,   10,   11,   21, 
            9,   10,   11,    2,    3,   14,   15,   16,   27,   51, 
           19,    3,   89,    6,   91,  255,  293,   11,  100,  418, 
           49,  417,   45,  419,  487,    7,  422,    7,  447,  332, 
          472,    6,    7,  336,  467,  425,   45,   15,   16,  584, 
           49,   19,   51,    0,   10,   27,  445,   27,   59,    0, 
          446,   32,   27,   15,   16,   10,   10,   19,  484,   52, 
          561,  487,  461,  526,  460,  676,  462,   10,  130,   47, 
           48,   59,   10,  429,  762,   10,  475,   52,  686,   44, 
          476,  692,  760,  119,   10,  107,  536,  105,  696,   10, 
           44,  100,   10,   59,   10,  706,   61,   10,    0,   10, 
            4,    5,   10,   10,   59,   59,  858,   21,   10,  507, 
           14,  105,   10,  774,  510,   10,   10,  562,   61,   10, 
          129,  319,  131,   44,   59,  341,  737,   10,   15,   16, 
          946,   44,   19,   44,  105,  534,   44,   43,   59,  535, 
           10,   59,   10,   59,  966,   49,   59,  594,   59,   44, 
           44,  305,   59,   61,   10,  305,   91,   59,  575,  576, 
           47,   10,   10,   10,   59,   59,   10,   10,   59,  345, 
          371,    2,    3,  308,  251,   10,   59,  342,    9,   10, 
           11,  628,   10,  341,   15,   16,   10,  363,   19,   59, 
          280,   59,  856,  107,  359,  280,  100,  328,  325,  113, 
          277,   44,   10,   59,   10,  336,   10,  657,    0,   10, 
           59,   10,   59,  362,   45,   59,   44,  878,   10,  496, 
           51,  375,  128,  137,   10,  375,  235,  342,  426,   10, 
           32,   10,  359, 1049,  317,  680,  313,  682, 1060,   10, 
          258,  376,  377,   44,  359,  746,  747,   10,   10,  262, 
          263,   10,  671,  262,  263,   59,  341,  720,   59, 1011, 
          310,   10,  681,   44,  258,  953,  349,   59,  350,  947, 
          353,  354,  362,   59,  351,   10,  784,  362,  942,   10, 
           10,  373,  790,   10,  962,  269,  378,  271,   32,  298, 
           10,  300,  301,  719,  720,  304,  319,  306,  129,   61, 
          131,   10,  311,  321,   10,   10,  373,   32,  317,   10, 
          319,  378,   61,   10,  279,   10,   45,  306,  317,  328, 
          298,  310,  300,  290,  291,  933,   61,  321,   10,  685, 
          875,  729,  267,   32,  268,  269,  298,  882,  300,  301, 
          371,  350,  887,  350,  351,  280,  267,   44,  359, 1013, 
          321,  801,  290,  291,  342,  856,  803,  858,  373,   10, 
           61,  562,   59,  378,  263,  264,   61,  380,  381,  382, 
          383,  380,  381,  382,  383,  384,  385,  386, 1056,   61, 
           32,  423,  444,  425, 1048,  384,  282,  429,  430,  305, 
          371,  372,  305,  328,  366,  837,  264,  378,  427,  342, 
          335,  336,  131,  426,  235,  359,  363,  797,  363,  418, 
           61,  298,  363,  300,  423,  338,  425,  426,  427,  345, 
          429,  430,  388,  432,  342,  281,  342,  362,   44,  342, 
          733,  262,  263,  432,  342,  342,  445,  714,  447,  448, 
          432,  942,  943,  341,  419,  862,  350,  422,  359,  458, 
          867,  868,  461,  870,  536,  872,  418,  466,  698,  375, 
         1071,  363,  375,  267,  359,  359,  475,  298,  359,  300, 
          301,  446,   61,  304,  937,  306,  359,  471,  472,  680, 
          311,  682,   61,  445, 1029,  504,  317,  462,  319,  359, 
            2,    3,    4,    5,  342,  914,  505,  328,  507,  461, 
          933,  476,   14,  341,  305,  419,  484,  342,  507,  518, 
         1011,  937, 1013,  475,    2,    3,   10,  279,  342,  305, 
          338,  345,  504,  427,  504,  534,   14,  536,   10,  504, 
          279,  562,  446,   45,   10,  510,  342,   49,  425,  345, 
          357,  342,  429,  342,  279,  523,  345, 1048,  462,  380, 
          381,  382,  383,  384,  385,  386,  342,   45,  359,  760, 
          535,  762,  476,  342,  841,  984,  345,   61,  310,  371, 
          372,  342,  534,  774,  375,  657,  378,   59,  279,  342, 
          342,  468,  311,  342,  279,   61,   44,  418,  100,  375, 
          319,  627,  423,  342,  425,  426,  510,  279,  429,  430, 
          636,  432, 1019, 1020, 1021, 1022,  338,  342,  305,   10, 
          632,  342,  342,   61,  445,  342,  447,  448,  640,  131, 
           10,  535,  342,  645,  338,  271,   59,  458,  279,  310, 
          461,   10,  536,  342,   10,  466,  342,  342,  279,  339, 
          676,  342, 1041,  131,  475,  342, 1042,  342,  657,  680, 
           10,  682,  734,  263,  264,   44,  692,  670,   59,  269, 
          342,  670,  671, 1080,   91,  684,   91,   44,    2,  362, 
          706,   61,  681,   10,  505,  669,  507,  317,  375,   10, 
           59,  373,  922,   59,   44,  317,  378,  518,  928,  304, 
          683,  342,    2,    3,  338,  342,  709,  426,  328,   59, 
          709,  737,  684,  534,  684,  335,  336,   44,  683,  684, 
          794,  326,  327,   47,   48,   10,  752,  345,  632,  801, 
          729,  363,   59,  235,  310,  734,  640,   10,   59,  458, 
          729,  645,   44,  308,  309,   45,  311,  466,  774,  781, 
          782,  719,  373,   44,  373,  787,  788,  235,  757,  758, 
          373,   10,  953,  657,  373,  797,  347,  341,   10,   10, 
          674,  962,  262,  677,   59,  966,   10,  776,  341,  778, 
          267,  780,  781,  782,  264,  264,   59,  342,  787,  788, 
          262,  263,  264,   44,   44,  279,  268,  269,  797,  271, 
           15,   16,  801,  363,   19,   10,  362,   44,  685,  311, 
           59,  376,  377,  279,   32,  317,   44,  319,   59,  822, 
          819,  805,   44,  822,  306,   59,   61,  312,  812,  306, 
           44,  131,  317,  311,  833,  834,  835,   44,  306,  317, 
          734,  319,   91,  379,  380,  381,  382,   10,  350,  670, 
          671,   91,  878,  837,   59,  371,  372,  373,  342,   44, 
          681,   32,  378,  338,  338,  350,  351,  899,   91, 1060, 
          342,  262,  263,  264,  338,  338,  342,  268,  269,   61, 
          271,   44,  384,   44,  489,   44,   91,  264,  709,  888, 
          264,  363,  497,  498,  269,   44,   59,   91,  267,  279, 
          899,  267,  387,  338,  338,  338,  384,  801,  729,  338, 
          515,  328,   10,  328,  913,  914,  388,  267,  335,  336, 
          335,  336,  921,  363,  426,  427,  925,   44,   91,   58, 
          432,  998,  338,  345,  264,  235,  757,  758,    9,   10, 
           11,  264,  263,  264,  339,  447,   44,  425,  426,  263, 
          338,  342,  264,  264,  432,  776,  458,  778,   44,  780, 
          781,  782,  342,   61,  466,  363,  787,  788,   44,  447, 
          339,  342,  363,  363,   59,  974,  797,  301,  305,  264, 
          458,   44,  264,   44,  269,  984,  271,   44,  466,  339, 
         1016,  264,   44,   91,  888,  268,  269,  388,  819,   44, 
           44,  822, 1001,   44, 1003,  507,   44,  359,   91,  264, 
         1009,  311,  833,  834,  835,  342,  518,  317,  267,  319, 
           10,  262,  263,  264,  371,  372,   61,  921,  269,  507, 
          264,  378,  359,  264,  536,  269,  383,  363,  757,  758, 
          518,   44, 1041,  264,  264, 1071,  359, 1046,  375,   91, 
          310,  656,  264,  363,   44,   44,  310,  776,  129,  778, 
           44,  780,  267,   44,  306,   44,  308,  309,  310,  311, 
          312,   61,   44,   10,  679,  317,   44, 1042,  899,  328, 
          974,   91,  388,  298,  384,  300,  335,  336,  328, 1041, 
          264,  264,  913,  914,  418,  335,  336,   44,  340,  271, 
          819,   91,  345,   44,  925,  328,  348,  349,  350,  351, 
          363,  341,  335,  336,  833,  834,  835,  280,  271,  724, 
          345,  445,   59,  328,  363,  342,  426,  732,   58,  345, 
          335,  336,  432,  264,  328,  345,   10,  461, 1042,   71, 
          286,  335,  336,   54,  373,  387,  751,  447,    5, 1044, 
          518,  475,    6,  645,   91,  657,  920,  306,  458,  308, 
          309,  310,  311,  984,  760,  328,  466,  774,  793,  671, 
           44,  764,  335,  336,  964,  962,  317,   10,  341,  681, 
         1001,  279, 1003,  507,   14,   59, 1043,   10, 1009,  746, 
           10,  262,  263,  671,  913, 1049,  359,   -1,   -1,  362, 
           -1,   -1,   -1,  681,   -1,  810,  925,  507,  349,   -1, 
          534,   44,  353,  354,  355,  356,   48,   91,  518,   -1, 
         1041,   44,   -1,   -1,   44, 1046,   -1,  729,   61,   -1, 
          328,   -1,  734,  304,   -1,  306,   59,  335,  336,   59, 
          742,   -1,   -1,  341,  342,  328,   -1,   -1,   -1,   -1, 
          855,  729,  335,  336,   44,  757,  758,  328,   91,  371, 
          372,  373,   -1,  760,   -1,  762,  378,   -1,   91,  593, 
          594,   91,   -1,   -1,  776,   -1,  778,  774,  780,  757, 
          758,   -1, 1001,   -1, 1003,    0,  328,   -1,   -1,  279, 
         1009,   -1,   -1,  335,  336,   10,   -1,   -1,  776,  801, 
          778,   91,  780,   10,  628,   -1,  371,  372,  373,  380, 
          381,  382,  383,  378,  385,  386,  640,  819,  328,  797, 
           -1,  645,   -1,   -1,  389,  335,  336, 1046,   -1,   44, 
          267,  833,  834,  835,   -1,   -1,   -1,   44,  328,   -1, 
           -1,  819,   -1,   -1,   59,  335,  336,   -1,    0,   -1, 
           -1,   10,  342,  677,   61,  833,  834,  835,   10,   -1, 
           -1,  685,  686,   -1,  688,  306,   -1,  308,  309,  310, 
          311,  671,  696,  371,  372,  373,   -1,  448,   -1,   -1, 
          378,  681,   -1,   -1,   91,   -1,  888,   -1,   -1,   15, 
           16,  328,   44,   19,   -1,   -1,   10,   -1,  335,  336, 
           59,  317,   -1,  764,  341,  729,  280,   59,   -1,   -1, 
           -1,  913,  914,  774,   -1,   41,   42,  333,  334,  921, 
           -1,   47,   48,  925,   50,   51,   -1,   -1,   -1,  729, 
           -1,   -1,   91,  349,  505,  913,  914,  353,  354,  355, 
          356,   -1,   -1,  921,   -1,   59,  279,  925,   -1,   -1, 
          282,  283,  284,   -1,  328,  287,  953,  757,  758,   -1, 
          280,  335,  336,    0,   -1,  962,   -1,  341,   -1,  966, 
           -1,   -1,  974,   10,   -1,   -1,  776,   91,  778,  803, 
          780,   -1,  984,   -1,   -1,  359,   -1,   -1,  362,  279, 
          371,  372,  373,  817,   -1,  328,  820,  378,   -1, 1001, 
           -1, 1003,  335,  336,   -1,  328,  984, 1009,  328,  342, 
           -1,   -1,  335,  336,   -1,  335,  336,   -1,  341,  819, 
           -1,  341,   59, 1001,   -1, 1003,   -1,    0,   -1,   -1, 
           -1, 1009,   -1,  833,  834,  835,  359,   10,  328,  359, 
           -1,   -1,  362,   -1, 1046,  335,  336,  262,  263,  264, 
           -1,  341,  267,  268,  269,   -1,  271,  306,   10,  308, 
          309,  310,  311, 1060,   -1,   -1,  281,  282, 1046,   -1, 
           -1,   44,  279,   10,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   58,   59,  371,  372,  373, 
           63,  340,   -1,  425,  378,   -1,   -1,  429,  959,  670, 
           -1,  962,   -1,  964,   -1,  966,   -1,   59,  267,  933, 
          262,  263,  264,  913,  914,  267,  268,  269,   -1,  271, 
           -1,  328,   59,   -1,   -1,  925,   -1,  342,  335,  336, 
          345,   -1,  347,   -1,   -1,  342,  468,   -1,  709,   91, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,  363,   -1, 
           -1,  483,  484,  267,   91,  487,  282,  283,  284,  285, 
            0,  287,  306,   -1,  308,  309,  310,  311,   -1,  328, 
           10,   -1,  298,  388,  300,  301,  335,  336,  371,  372, 
          373,   -1,   -1,  309,  984,  378,   -1,  339,   -1,   -1, 
          342,  523,   -1,   -1,  526, 1056,   -1, 1058,   -1, 1060, 
           -1, 1001, 1063, 1003,   44,   -1,   10,   -1,   -1, 1009, 
           -1,  363,   -1,   -1,  328,   -1,   -1, 1041,   58,   59, 
         1044,  335,  336,   63,   -1,  262,  263,  264, 1089,   -1, 
          267,  268,  269,   -1,  271,   -1,  388,   -1,  371,  372, 
          373,  371,  372,  373,  281,  378, 1046,   -1,  378,   -1, 
           -1,  822,   -1,  585,   -1,   59,  293,  294,  295,  296, 
          297,  387,  388,  389,  390,  391,  392,  393,  394,  395, 
          396,  397,  398,  399,  400,  401,  402,  403,  404,  405, 
          406,  407,  408,  409,  410,  411,  412,   91,   -1,  262, 
          263,  264,  418,   -1,  267,  268,  269,  423,  271,  425, 
           -1,   -1,   -1,  429,  430,  342,   -1,   -1,  281,  282, 
          293,  294,  295,  296,  297,  267,  648,  290,  291,  445, 
          293,  294,  295,  296,  297,   -1,  363,   -1,   -1,   -1, 
          267,   -1,  305,   -1,   -1,  461,   -1,  463,  464,  465, 
           -1,   -1,  468,  280,   -1,   -1,   -1,   -1,   -1,  475, 
           -1,  388,   -1,  685,   -1,    0,   10,  483,  484,   10, 
           -1,  487,   10,   -1,   -1,   10,  339,   -1,   -1,  342, 
          755,   -1,  345,   44,  347,   -1,  328,  762,  710,   -1, 
          712,   -1,   -1,  335,  336,  511,  512,  719,  720,  774, 
          363,  328,   -1,   44,   -1,   -1,   44,  523,  335,  336, 
          526,   -1,  375,   -1,  341,   59,   -1,   -1,  534,   -1, 
           61,   10,   -1,   61,   59,  388,   -1,   -1,   -1,   -1, 
           91,   10,  262,  263,  264,  362,   -1,  267,  268,  269, 
          306,  271,  308,  309,  310,  311,   -1,   91,  770,   10, 
           91,  281,  282,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,  585, 
           59,   10,   -1,  267,  340,  305,  798,   -1,   -1,   -1, 
           59,   -1,  348,   -1,   -1,   -1,  280,   -1,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   59,  329, 
          330,   -1,   91,  333,  334,   44,   -1,   44,   -1,  339, 
          832,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349, 
           44,  351,   61,  353,  354,  355,  356,  357,  358,  359, 
           91,  361,  648,  363,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,  336,   -1,   -1,  375,   -1,  341,   -1,   -1, 
           -1,   -1,   91,   -1,   91,   -1,   -1,   -1,  388,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   91,  362,  685, 
           -1,   10,   -1,   -1,   -1,   -1,  951,   -1,  953,   -1, 
          955,   -1,   -1,   -1,  959,   -1,   -1,  909,   -1,   -1, 
           -1,  966,   -1,   -1,  710,   -1,  712,   -1,   -1,   -1, 
           -1,   -1,   -1,  719,  720,   44,  306,   -1,  308,  309, 
          310,  311,   -1,   -1,   -1,  937,   -1,   -1,  279,   58, 
           59,   -1,   61,  267,   63,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,  279,  280, 
          340,  279,  280,   -1,   -1,   -1,  281,   -1,  348,   -1, 
           -1,   -1,   91,   -1,  770,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,  781,  782,  328,   -1,   -1, 
           -1,  787,  788,   -1,  335,  336,   -1, 1052,  267,   -1, 
          796,  797,  798, 1058,  328, 1060,  802,  328, 1063,   -1, 
          328,  335,  336,    0,  335,  336,   -1,  335,  336,   -1, 
          341,  342,   -1,   10,  342,   -1,  267,  342,   -1,  825, 
          826,   -1,  828,  829, 1089,   -1,  832,   -1,   -1,  280, 
           -1,  362,   -1,   -1,  362,   -1,   -1,  306,  363,  308, 
          309,  310,  311,  312,   -1,   -1,   -1,   44,  317,  328, 
          279,   -1,  279,   -1,   -1,   -1,  335,  336,   -1,  328, 
           -1,   58,   59,  388,   61,  279,   63,  336,   -1,   -1, 
           -1,  340,  341,   -1,   -1,   -1,   -1,  328,   -1,  348, 
          349,  350,  351,   -1,  335,  336,  892,   -1,   -1,   -1, 
          341,   -1,   -1,  899,   91,   -1,   -1,   -1,   -1,  328, 
           -1,  328,   -1,  909,   -1,   -1,  335,  336,  335,  336, 
           -1,  362,   -1,  342,  328,   -1,   -1,   -1,  387,   -1, 
           -1,  335,  336,   10,  930,   -1,   -1,   -1,  257,  258, 
          259,  937,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   59,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,  337,  338, 
          339,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,  363, 1041,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,  375,  376,  377,   -1, 
          379,  380,  381,  382,   10,   10,  385,  386,  387,  388, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   -1,  299,   59,   59,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   91,  333,  334,  335,  336, 
          337,  338,  339,  340,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,  363,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,    0,  374,  375,  376, 
          377,   -1,  379,  380,  381,  382,   10,   -1,  385,  386, 
          387,  388,   -1,   -1,   -1,  363,   -1,  365,  879,  367, 
           -1,   -1,  883,   -1,   -1,  373,  262,  263,  264,   -1, 
           -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,  306, 
           44,  308,  309,  310,  311,  312,   -1,   -1,   -1,   -1, 
          317,   -1,   -1,   -1,   58,   59,   -1,   61,   -1,   63, 
          317,  328,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,   -1,  340,  341,   -1,  333,  334,   -1,   -1, 
           -1,  348,  349,  350,  351,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,  349,   -1,  351,   -1,  353,  354,  355,  356, 
           -1,   -1,   -1,  262,  263,  264,  342,   -1,   -1,  268, 
          269,   -1,  271,  306,   -1,  308,  309,  310,  311,  312, 
          387,   -1,   -1,   -1,  317,   -1,   -1,  363,    0,   -1, 
           -1,  267,   -1,  481,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  340,  341,   -1, 
           -1,   -1,  388,   -1,   -1,  348,  349,  350,  351,   -1, 
           -1,   -1, 1023,   -1,   -1, 1026, 1027,   -1,   -1, 1030, 
         1031,  306,   44,  308,  309,  310,  311,  312,   -1,   -1, 
           -1,   -1,  317,  342,   -1,   -1,   58,   59,   -1,   61, 
           -1,   63,  328,  328,  387,   -1,   -1,   -1,   -1,  335, 
          336,  336,  550,   -1,  363,  340,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,  348,  349,  350,  351,   -1,   -1,   91, 
         1081, 1082, 1083, 1084,   -1,   -1,   -1,   -1,   -1,  388, 
           -1,   -1, 1093,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  589,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,  387,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   59,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,  337,  774,  339,  340,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,  363, 
           44,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,  375,  376,  377,   -1,  379,  380,  381,  382,   10, 
           10,  385,  386,  387,  388,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   91,  280,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   59,   59, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   44, 
           91,  333,  334,  335,  336,  337,   -1,  339,  340,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,  363,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,    0,  374,  375,  376,  377,   91,  379,  380,  381, 
          382,   10,   -1,  385,  386,  387,  388,   -1,   -1,  959, 
           -1,   -1,  962,   -1,  964,   -1,  966,  306,   -1,  308, 
          309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1, 
           -1,   -1,   -1,   -1,  306,   44,  308,  309,  310,  311, 
          312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,   58, 
           59,  340,   61,   -1,   63,   -1,  328,   -1,   -1,  348, 
          349,  350,  351,   -1,  336,   -1,   -1,   -1,  340,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,  349,  350,  351, 
           -1,   -1,   91,   -1,  306,  279,  308,  309,  310,  311, 
          312,   -1,   -1,   -1,   -1,  317,   -1,   -1,  387,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1, 1056,   -1, 1058,   -1, 
         1060,   -1,   -1, 1063,  317,  387,   -1,   -1,  340,  322, 
          323,   -1,   -1,    0,   -1,   -1,  267,   -1,  350,  351, 
          333,  334,   -1,   10,  328,   -1,   -1,   -1,   -1, 1089, 
           -1,  335,  336,   -1,   -1,   -1,  349,   -1,  351,   -1, 
          353,  354,  355,  356,  357,  358,  359,   -1,  361,   -1, 
           -1,   -1,   -1,   -1,   -1,  387,  306,   44,  308,  309, 
          310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1, 
           -1,   58,   59,   -1,  279,   -1,   63,  328,  328,   -1, 
          317,   -1,   -1,   -1,  335,  336,  336,   -1,   -1,   -1, 
          340,  341,   -1,   -1,   -1,   -1,  333,  334,  348,  349, 
          350,  351,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  349,   -1,  351,   -1,  353,  354,  355,  356, 
           -1,   -1,  359,  328,  361,   -1,   -1,   -1,   -1,   -1, 
          335,  336,   -1,   10,   -1,   -1,   -1,  387,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   59,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   44,   -1,  333,  334,  335,  336,  337,   -1, 
          339,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,  363,   44,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,  375,  376,  377,   91, 
          379,  380,  381,  382,   10,   10,  385,  386,  387,  388, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   91,  280,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   -1,  299,   59,   59,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   44,   91,  333,  334,  335,  336, 
          337,   -1,  339,  340,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,  363,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,    0,  374,  375,  376, 
          377,   91,  379,  380,  381,  382,   10,   -1,  385,  386, 
          387,  388,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  306, 
           44,  308,  309,  310,  311,  312,   -1,   -1,   -1,   -1, 
          317,   -1,   -1,   -1,   58,   59,   -1,  279,  280,   63, 
           -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,   -1,  340,  341,   -1,   -1,   -1,   -1,   -1, 
           -1,  348,  349,  350,  351,   -1,   -1,   91,   -1,   -1, 
          279,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1, 
           -1,   -1,   -1,  335,  336,   -1,   -1,   -1,   -1,  341, 
          387,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,  267,   -1,   -1,   -1,   -1,   -1,   -1,   10,  328, 
          362,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  306,   44,  308,  309,  310,  311,  312,   -1,   -1, 
           -1,   -1,  317,   -1,   -1,   -1,   58,   59,   -1,  279, 
           -1,   63,  328,  328,   -1,   -1,   -1,   -1,   -1,  335, 
          336,  336,   -1,   -1,   -1,  340,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,  348,  349,  350,  351,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1, 
           -1,   -1,   -1,   -1,   -1,  335,  336,   -1,   10,   -1, 
           -1,   -1,  387,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   59,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,  337,   -1,  339,  340,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,  363, 
           63,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,  375,  376,  377,   -1,  379,  380,  381,  382,   10, 
           10,  385,  386,  387,  388,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   59,   59, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   44, 
           91,  333,  334,  335,  336,  337,   -1,  339,  340,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,  363,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,    0,  374,  375,  376,  377,   91,  379,  380,  381, 
          382,   10,   -1,  385,  386,  387,  388,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  306,   44,  308,  309,  310,  311, 
          312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,   58, 
           59,   -1,   61,   -1,   63,   -1,  328,  317,  318,  319, 
          320,  321,  322,  323,  336,   -1,  326,  327,  340,  341, 
           -1,   -1,   -1,  333,  334,   -1,  348,  349,  350,  351, 
           -1,   -1,   91,   -1,  297,   -1,   -1,   -1,   -1,  349, 
           -1,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  387,  329,  330,   -1,   -1, 
          333,  334,   -1,    0,   -1,   -1,  267,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,  349,   -1,  351,   -1, 
          353,  354,  355,  356,  357,  358,  359,   -1,  361,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  306,   44,  308,  309, 
          310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1, 
           -1,   -1,   59,   -1,  279,   -1,   63,  328,  328,   -1, 
           -1,   -1,   -1,   -1,  335,  336,  336,   -1,   -1,   -1, 
          340,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349, 
          350,  351,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1, 
          335,  336,   -1,   -1,   -1,   -1,   -1,  387,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,   59,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   44,   -1,  333,  334,  335,  336,  337,   -1, 
          339,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,   -1,  363,   44,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,  375,  376,  377,   91, 
          379,  380,  381,  382,   10,   -1,  385,  386,  387,  388, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   91,  280,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   -1,  299,   59,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,    0,   91,  333,  334,  335,  336, 
          337,   -1,  339,  340,   10,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,  363,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   44,  376, 
          377,   -1,  379,  380,  381,  382,   -1,   -1,  385,  386, 
          387,  388,   -1,   59,   -1,   -1,   -1,   63,  306,   -1, 
          308,  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,   -1,   91,   -1,   -1,  333,  334, 
           -1,   -1,  340,   -1,   -1,   -1,   -1,  279,  280,   -1, 
          348,  349,  350,  351,  349,   -1,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   -1,  361,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
          279,  280,   -1,   -1,   -1,   -1,   10,   -1,   -1,  387, 
           -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1, 
           -1,   -1,   -1,  335,  336,   -1,   -1,   -1,   -1,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,  267,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328, 
          362,   -1,   -1,   -1,   -1,   59,  335,  336,   -1,   63, 
           -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  362,   -1,   -1,   -1,   91,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335, 
          336,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   63,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   44,   -1,  333,  334,  335, 
          336,  337,   -1,  339,  340,   -1,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,  363,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   91,  379,  380,  381,  382,   44,   -1,  385, 
          386,  387,  388,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   91,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,    0,   -1,  333, 
          334,  335,  336,  337,   -1,  339,  340,   10,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,   -1,  363, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   44,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,  385,  386,  387,  388,   -1,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,   -1,  333,  334,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  349, 
          279,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328, 
           -1,   -1,  279,  280,   -1,   -1,  335,  336,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336, 
           -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   44,  299,   44,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,  337,  338,   -1,  340,  341,  342, 
          343,  344,   91,  346,   91,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
          363,   44,  365,  366,  367,  368,  369,  370,   -1,   63, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           10,   -1,  385,  386,  387,  388,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,   -1,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   91,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   -1,  299,   59, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           63,   91,  333,  334,  335,  336,  337,  338,   -1,  340, 
          341,  342,  343,  344,   -1,  346,   -1,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,  363,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,    0,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   10,   -1,  385,  386,  387,  388,  317,  318, 
          319,  320,  321,  322,  323,  324,   -1,  326,  327,   -1, 
          279,  280,  279,  280,  333,  334,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
          349,   -1,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   59,  361,   61,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328, 
           -1,  328,   -1,   -1,   -1,   -1,  335,  336,  335,  336, 
           -1,   -1,  341,   91,   -1,   -1,  279,   -1,   -1,   -1, 
           -1,   -1,   -1,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  362,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,    0,  329,  330,  267,   -1,  333, 
          334,   -1,   -1,   -1,   10,  328,   -1,   -1,   -1,   -1, 
          280,   -1,  335,  336,   -1,  349,   -1,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   61,   -1,   63,  328,   -1, 
           -1,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1,   -1, 
           -1,  341,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   91,  329,  330,   91,   -1, 
          333,  334,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  349,   -1,  351,   -1, 
          353,  354,  355,  356,  357,  358,  359,   -1,  361,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,   -1, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           44,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,  337, 
           -1,   -1,  340,  341,  342,  343,  344,   91,  346,   -1, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,  363,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   10,   -1,  385,  386, 
      };
   }

   private static final short[] yyCheck2() {
      return new short[] {

          387,  388,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,   -1,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,   -1,  279,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   59,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,  328,   91,  333,  334, 
          335,  336,  337,  335,  336,  340,  341,  342,  343,  344, 
           -1,  346,   -1,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,  363,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,    0,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   10,   -1, 
          385,  386,  387,  388,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  279,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1, 
           -1,   -1,  335,  336,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  306,  307,   -1,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
            0,  326,  327,  267,   -1,   -1,  331,  332,  333,  334, 
           10,   -1,   -1,   -1,   -1,   -1,  280,   -1,   -1,   -1, 
           -1,   -1,   -1,  348,  349,   -1,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,   -1,   -1,  364, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,   61,  387,   63,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,  336,   -1,   -1,   -1,   -1,  341,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,   -1,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,  337,   -1,   -1,  340,  341, 
          342,  343,  344,   -1,  346,   -1,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,  363,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,    0,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   10,   -1,  385,  386,  387,  388,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,   -1,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   -1,  299, 
           59,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,  337,   -1,   -1, 
          340,  341,  342,  343,  344,   -1,  346,   -1,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,   -1,  363,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,    0,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   10,   -1,  385,  386,  387,  388,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   61,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  764, 
           -1,   -1,  767,   -1,   -1,   -1,   -1,   -1,   -1,  774, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,  281,   -1,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,  335,  336,  337,   -1, 
            0,  340,   -1,  342,  343,  344,   -1,  346,   -1,  348, 
           10,  350,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,  362,  363,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   44,   -1,  385,  386,  387,  388, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   58,   59, 
          267,  268,  269,   63,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  280,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   91,   -1,   -1,  959,   -1,   -1,  962,  305,  964, 
           -1,  966,   -1,   -1,  279,  280,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,    0,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   10,  349,   -1,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,  328,  361,  362,  363,   -1,   -1,   -1, 
          335,  336,   -1,   -1,   -1,   -1,  341,  342,  375,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  388,   -1,   -1,   -1,   -1,   -1,  362,   -1,   58, 
           59, 1056,   61, 1058,   63, 1060,   -1,   -1, 1063,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   91,   -1, 1089,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          280,  281,  282,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   58,   59, 
           -1,   61,   -1,   63,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   91,   -1,  333,  334,  335,  336,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349, 
           -1,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,  388,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   61,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   91,   -1,  333,  334,  335,  336,   -1,  338, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,    0,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   10,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,  375,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  388, 
           -1,  281,  282,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   58, 
           59,   -1,   61,   -1,   63,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   91,  333,  334,  335,  336,   -1,  338,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349, 
           -1,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,  388,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   61,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   91,   -1,  333,  334,  335,  336,   -1,  338, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,    0,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   10,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,  375,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,  388, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   61,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   91,   -1,  333,  334,  335,  336,   -1,  338, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  388, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   61,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   91,   -1,  333,  334,  335,  336,   -1,  338, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,    0,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   10,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,  375,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,  388, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   61,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   91,   -1,  333,  334,  335,  336,   -1,  338, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  388, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   61,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   91,   -1,  333,  334,  335,  336,   -1,  338, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,    0,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   10,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,  375,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,  388, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   61,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   91,   -1,  333,  334,  335,  336,   -1,  338, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  388, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   -1,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   91,   -1,  333,  334,  335,  336,   -1,  338, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,    0,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   10,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,  375,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,  388, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   61,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   91,   -1,  333,  334,  335,  336,   -1,  338, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  388, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  280,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   61,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   91,   -1,  333,  334,  335,  336,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,    0,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   10,  361,  362,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,  375,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,  388, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   -1,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   91,   -1,  333,  334,  335,  336,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  388, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   -1,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   91,   -1,  333,  334,  335,  336,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,    0,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   10,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,  375,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,  388, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   -1,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   91,   -1,  333,  334,  335,  336,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  388, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   -1,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   91,   -1,  333,  334,  335,  336,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,    0,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   10,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,  375,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,  388, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   -1,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   91,   -1,  333,  334,  335,  336,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  388, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           59,   -1,   -1,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   91,   -1,  333,  334,  335,  336,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,    0,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   10,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,  375,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,  388, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           59,   -1,   -1,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   91,   -1,  333,  334,  335,  336,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  388, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   91,   -1,  333,  334,  335,  336,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,    0,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   10,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,  388, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  388, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,    0,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   10,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,  388, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   -1,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  388, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   -1,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,    0,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   10,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,  375,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,  388, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   -1,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  388, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           59,   -1,   61,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   91,   -1,  333,  334,   -1,   -1,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,    0,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   10,  361,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,  375,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,  388, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           59,   -1,   61,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   91,   -1,  333,  334,   -1,   10,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,   -1,  351,    0,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   10,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   61,  388, 
           -1,   -1,   -1,  262,  263,  264,   -1,   44,   -1,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  280,   59,   -1,   61,   -1,   63,   -1,   91,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,    0,   -1,  333,  334,  335,  336,   -1,   -1, 
           -1,   -1,   10,  342,   -1,   -1,   -1,   -1,   -1,   -1, 
          349,   -1,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,  362,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   44,   -1,   -1,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,  388, 
           -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,  338, 
           -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,   -1, 
          349,   -1,  351,    0,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   10,  363,   -1,  279,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
           -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,  388, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   59,   -1,   61,  328,   63,   -1,   -1,   -1, 
           -1,   -1,  335,  336,   -1,   -1,   -1,   -1,   -1,  342, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   91,   -1,  333,  334,  335,  336, 
           -1,  338,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1, 
           -1,   -1,  349,    0,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   10,  361,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,   -1, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  388,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   91,  333,  334,  335,  336,   -1, 
          338,   -1,   -1,   -1,  342,   44,   -1,   -1,   -1,   -1, 
           -1,  349,   -1,  351,    0,  353,  354,  355,  356,  357, 
          358,  359,   61,  361,   10,  363,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          388,   -1,   91,   -1,   -1,  262,  263,  264,   44,   -1, 
           -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   61,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,    0,   -1,  333,  334,  335,  336, 
           -1,  338,   -1,   -1,   10,  342,   -1,   -1,   -1,   -1, 
           -1,   -1,  349,   -1,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   -1,  361,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   44,   -1, 
           -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,  388,   -1,   59,   -1,   61,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
          279,  338,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1, 
           -1,   -1,  349,   -1,  351,    0,  353,  354,  355,  356, 
          357,  358,  359,   -1,  361,   10,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,  328, 
           -1,  388,   -1,   -1,   -1,   -1,  335,  336,   -1,   44, 
           -1,   -1,   -1,  342,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   59,   -1,   61,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   91,  333,  334,  335, 
          336,   -1,  338,   -1,   -1,   -1,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,    0,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   10,  361,   -1,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,  388,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   59,   -1,   61,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   91,   -1,  333,  334,  335, 
          336,   -1,  338,   -1,   -1,   -1,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,   -1,  351,    0,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   10,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  388,   -1,   -1,   -1,   -1,  262,  263,  264, 
           44,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   10, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,    0,   -1,  333,  334, 
          335,  336,   -1,  338,   -1,   -1,   10,  342,   -1,   -1, 
           -1,   -1,   -1,   44,  349,   -1,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   -1,  361,   -1,  363,   -1, 
           61,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           44,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  388,   -1,   59,   -1,   61,   -1,   63, 
           91,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,  338,   -1,   -1,   -1,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,   -1,  351,    0,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   10,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,  388,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   91,   -1,  333, 
          334,  335,  336,   -1,  338,   -1,   -1,   -1,  342,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,    0,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   10,  361,  279,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,  388,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   58,   59,   -1,  328,   -1,   63, 
           -1,   -1,   -1,   -1,  335,  336,   -1,   -1,   -1,   -1, 
           -1,  342,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,   -1,   -1,   -1,   -1,  342,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,   -1,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  388,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,   -1,   -1,   -1,   -1,  342,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,    0,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   10,  361,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,  388,   -1,   -1,  281,  282,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   58,   59,   -1,   -1,   -1,   63, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
      };
   }

   private static final short[] yyCheck3() {
      return new short[] {

           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
          333,  334,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           10,   -1,  355,  356,  357,  358,  359,   -1,  361,   -1, 
          363,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,  375,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,  388,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   61,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   58,   59,   -1,   -1,   -1, 
           63,   91,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
          333,  334,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,   -1,    0,  351,   -1, 
           -1,   -1,  355,  356,  357,  358,  359,   10,  361,   -1, 
          363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,  375,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,  388,    0,   -1,  281,  282, 
           -1,   44,   -1,   -1,   -1,   -1,   10,  290,  291,   -1, 
          293,  294,  295,  296,  297,   58,   59,   -1,   -1,   -1, 
           63,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
          333,  334,   -1,   -1,   -1,   59,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,    0,  357,  358,  359,   -1,  361,   -1, 
          363,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,  279, 
          280,   -1,   -1,   -1,   -1,  388,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   44,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   58,   59,   -1,   -1,   -1,   63,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,  328,   -1, 
           -1,   -1,  305,   -1,   -1,  335,  336,   -1,   -1,   -1, 
           -1,  341,  342,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
          333,  334,  362,    0,   -1,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   10,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,  357,  358,  359,   -1,  361,   -1, 
          363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,  375,   -1,  267,  268,  269,   44,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,  388,   -1,   -1,  281,  282, 
           -1,   58,   59,   -1,   -1,   -1,   63,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,  262,  263, 
          264,   -1,  305,   -1,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,    0,  357,  358,  359,   -1,  361,   -1, 
          363,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  375,   -1,   -1,  262,  263,  264,  342,   -1, 
          267,  268,  269,   -1,  271,  388,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   44,   -1,  363, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   58,   59,   -1,   -1,   -1,   63,   10,  305,   -1, 
           -1,   -1,   -1,   -1,  388,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,   -1,    0,   -1,   -1,   -1,   -1,   61,   -1, 
          357,  358,  359,   10,  361,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,  375,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   91,   -1, 
           -1,  388,    0,   -1,  281,  282,   -1,   44,   -1,   -1, 
           -1,   -1,   10,  290,  291,   -1,  293,  294,  295,  296, 
          297,   58,   59,   -1,   -1,   -1,   63,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
          357,  358,  359,   -1,  361,   -1,  363,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  388,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   44,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   58,   59,   -1, 
           -1,   -1,   63,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,  279,   -1,   -1,    0, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,   10, 
          347,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          357,  358,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,  375,   -1, 
          267,  268,  269,   44,  271,  328,   -1,   -1,   -1,   -1, 
           -1,  388,  335,  336,  281,  282,   -1,   58,   59,  342, 
           -1,   -1,   63,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,  262,  263,  264,   -1,  305,   -1, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,    0, 
          357,  358,   -1,   -1,   -1,   -1,  363,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1, 
           -1,  262,  263,  264,  342,   -1,  267,  268,  269,   44, 
          271,  388,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   44,   -1,  363,   61,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   58,   59,   -1, 
           -1,   -1,   63,   10,  305,   -1,   -1,   -1,   -1,   -1, 
          388,   -1,   -1,   -1,   -1,   -1,   91,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,   10,   -1,   10,   -1,   -1,   44,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,   -1,    0, 
           -1,   -1,   -1,   -1,   61,   -1,  357,  358,   -1,   10, 
           -1,   -1,  363,   -1,   -1,   -1,   44,   -1,   44,   -1, 
           -1,  262,  263,  264,  375,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   61,   91,   61,   -1,  388,   -1,   -1, 
          281,  282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   58,   59,   -1, 
           -1,   -1,   63,   91,  305,   91,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,    0,  329,  330, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  339,   -1, 
           -1,  342,   44,   -1,  345,   -1,  347,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,  357,  358,   -1,   61, 
           -1,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   58,   59,  388,   -1,   91, 
           63,  262,  263,  264,  279,  280,  267,  268,  269,   -1, 
          271,   61,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,  305,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,  328,   -1,   -1,   10,   -1,   -1,   -1, 
          335,  336,   -1,  324,  325,   -1,  341,  342,  329,  330, 
           -1,   -1,  279,  280,   -1,   -1,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,  362,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  279,  363,  279,   58,   59,   -1,   -1,   -1,   63, 
           -1,  262,  263,  264,  375,   -1,  267,  268,  269,   -1, 
          271,  328,   -1,   -1,   -1,   -1,   -1,  388,  335,  336, 
          281,  282,   -1,   -1,  341,  342,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
          328,    0,  328,   -1,  305,  362,   -1,  335,  336,  335, 
          336,   10,   -1,   -1,  342,   -1,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,  324,  325,   -1,   -1,   -1,  329,  330, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  279,  339,   -1, 
           -1,  342,   -1,   -1,  345,   44,  347,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   58, 
           59,   -1,  363,   -1,   63,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,  375,   -1,   -1,  290,  291,  279, 
          293,  294,  295,  296,  297,   -1,  328,  388,   -1,    0, 
           -1,   -1,  305,  335,  336,   -1,   -1,   -1,   -1,   10, 
          342,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  324,  325,   -1,   -1,   -1,  329,  330,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,  328,  342, 
           -1,   -1,  345,   44,  347,  335,  336,   -1,   -1,   -1, 
           -1,   -1,  342,   -1,   -1,   -1,   -1,   58,   59,   -1, 
          363,   -1,   63,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,  375,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  388,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          324,  325,   -1,   -1,   -1,  329,  330,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   44,  347,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1,  363, 
           -1,   63,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,  375,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,  388,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  324,  325,   -1,   -1,   -1, 
          329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   44,  347,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   58,   59,   -1,  363,   -1,   63,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,  375,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,  388, 
           -1,    0,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  324,  325,   -1,   -1,   -1,  329,  330, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   44,  347,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   -1,  363,    0,   63,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   10,  375,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  388,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  324,  325,   -1,   -1,   -1,  329,  330,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,  363,   -1,   -1,   -1,  262,  263,  264,   10,   -1, 
          267,  268,  269,  375,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,  388,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   44,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  325,   -1, 
           -1,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  339,   -1,   -1,  342,    0,   -1,  345,   -1, 
          347,   -1,   -1,  262,  263,  264,   10,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,  375,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           44,  388,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
          339,   -1,    0,  342,  281,  282,  345,   -1,  347,   -1, 
           -1,   -1,   10,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,  363,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,  388, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           58,   59,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,  375,  271, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,  281, 
          282,  388,   -1,   -1,   10,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
            0,  363,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           10,   -1,   -1,  375,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,  388,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,    0,   -1,   -1,  363, 
           -1,   -1,   -1,  281,  282,   -1,   10,   -1,   -1,   -1, 
           -1,  375,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,  388,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1, 
           -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,  363,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   10,  271,   -1,  375,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
          388,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   44,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345, 
            0,  347,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           10,  271,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,  375, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,  388,   -1,   44,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,  345,    0,  347,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   10,  271,   -1,   -1, 
           -1,   -1,   -1,  363,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,  375,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,  388,   -1, 
           44,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,    0,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   10,  271,   -1,   -1,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,    0,  388,   -1,   -1,   -1,   44,  305, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  339,   -1,   -1,  342,   44,   -1,  345, 
           -1,  347,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   59,   -1,   -1,   -1,    0,  363,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   10,   -1,   -1,  375, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,  388,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   44, 
           -1,   -1,   -1,  363,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   58,   59,  375,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,  388,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   44,  363, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,  375,   58,   59,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,  388,  262,  263,  264,   -1,  305, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,  339,   -1,   -1,  342,   -1,  305,  345, 
           -1,  347,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   44,   -1,  363,  262,  263, 
          264,   10,   -1,  267,  268,  269,   -1,  271,   -1,  375, 
           59,   -1,  339,   -1,   -1,  342,   -1,  281,  345,   -1, 
          347,   -1,  388,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,  363,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,  375,   -1, 
           59,   -1,   -1,    0,   -1,   -1,  281,  282,   -1,   -1, 
           -1,  388,   -1,   10,   -1,  290,  291,   -1,  293,  294, 
          295,  296,   -1,   -1,   -1,   -1,   -1,   -1,  342,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  363, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   10,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,  388,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,  363,    0, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   10, 
          375,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,   -1,   59,  388,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   59,   -1, 
           -1,   -1,   10,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,  363,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,  375, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   59,  388,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,  342,    0,   -1,  345,   -1,  347,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  363,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,  342,  281,   -1,  345,   -1,  347,  388, 
           -1,   10,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   59,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,  388, 
           -1,  328,   -1,   -1,  281,  282,   -1,   -1,  335,  336, 
           59,   -1,   -1,  290,  291,  342,  293,  294,  295,  296, 
          297,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,  388,   -1,   -1,   -1,  342,   -1,   -1,  345,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,    0,  271,   -1,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   10,  281,  282,   -1,   -1,   -1,   -1,   -1, 
            0,  342,  290,  291,  345,  293,  294,  295,  296,  297, 
           10,  388,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,  363,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,   -1,   -1,   44,   -1,   -1,  388,   -1,   -1, 
           -1,   -1,   -1,   -1,  342,   -1,   -1,  345,   -1,   59, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  363,  262,  263,  264,   59, 
           -1,  267,  268,  269,    0,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,  281,   -1,   -1,   -1,   -1, 
          388,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,  281,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   59,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  388,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  388, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,  262,  263,  264,   -1,   -1,   -1,  268,  269, 
           -1,  271,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,   -1,   10,   -1, 
           -1,  339,   -1,   -1,  342,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,  363,  262,  263,  264,   -1, 
           -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,  342,  363,   -1,   -1,   -1,   59,   -1,   -1, 
          388,   -1,   -1,   -1,   -1,   -1,   -1,  293,  294,  295, 
          296,  297,   -1,  363,   -1,   -1,   -1,   -1,  388,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  388,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,  363,  272,  273, 
          274,  275,  276,  277,  278,   -1,   10,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,  388,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,  350,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   91,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,  385,  386,  387,  256,  257,  258,  259,  260,  261, 
          262,  263,  264,  265,  266,   -1,   -1,  269,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,   -1, 
           10,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   59, 
           -1,   -1,   -1,  335,  336,  337,   -1,   -1,  340,  341, 
           -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1, 
          352,   -1,   -1,   -1,   -1,  357,   -1,   -1,  360,   -1, 
          362,   91,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,  384,  385,  386,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   -1,  269,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,   -1,   10,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   59,   -1,   -1, 
           -1,  335,  336,  337,   -1,   -1,  340,  341,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,  357,   -1,   -1,  360,   -1,  362,   91, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
          384,  385,  386,   -1,   -1,   -1,  256,  257,  258,  259, 
          260,  261,  262,  263,  264,  265,  266,   -1,   -1,  269, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,   -1,   10,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299, 
           -1,  301,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1, 
           -1,   59,   -1,   -1,   -1,  335,  336,  337,   -1,   -1, 
          340,  341,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
           -1,   -1,  352,   -1,   -1,   -1,   -1,  357,   -1,   -1, 
          360,   -1,  362,   91,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,  386,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  256,  257,  258,  259,  260,  261, 
          262,  263,  264,  265,  266,   -1,   -1,  269,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   10,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  328,   59,   -1,   -1, 
           -1,   -1,   -1,  335,  336,  337,   -1,   -1,  340,  341, 
           -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1, 
          352,   -1,   -1,   -1,   -1,  357,   -1,   -1,  360,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,  384,  385,  386,   -1,   -1,   -1,  256,  257, 
          258,  259,  260,  261,  262,  263,  264,  265,  266,   -1, 
           -1,  269,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   10,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,   -1,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          328,   59,   -1,   -1,   -1,   -1,   -1,  335,  336,  337, 
           -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1, 
          348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,  357, 
           -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,  384,  385,  386,   -1, 
           -1,   -1,   -1,   -1,  256,  257,  258,  259,  260,  261, 
          262,  263,  264,  265,  266,   -1,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   10,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1, 
           -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1, 
          352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,  384,  385,  386,   -1,   -1,   -1,  256,  257, 
          258,  259,  260,  261,  262,  263,  264,  265,  266,   -1, 
           -1,  269,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   10,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,   -1,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
           -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1, 
          348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  360,   -1,  362,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,  384,  385,  386,   -1, 
           -1,   -1,   -1,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,   -1,  269,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   10,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,  384,  385,  386,   -1,   -1,   -1,  256,  257,  258, 
          259,  260,  261,   -1,   -1,  264,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           10,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,   -1,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,  348, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,  384,  385,  386,   -1,   -1, 
           -1,   -1,  256,  257,  258,  259,  260,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   10,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,  363, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
          384,  385,  386,   -1,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   10, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,   -1,   -1, 
           -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,   -1,  385,  386,   -1,   -1,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   44,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  340,   -1,  342,  343,  344, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,  352,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,   -1, 
          385,  386,   -1,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   44,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340, 
           -1,   -1,  343,  344,   -1,  346,   -1,   -1,   -1,   -1, 
           -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
      };
   }

   private static final short[] yyCheck4() {
      return new short[] {

          360,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,   -1,  385,  386,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,   -1,   -1, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,   -1,  385, 
          386,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,   -1,   -1,  316,   -1,   -1,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1, 
           -1,  343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,   -1,  385,  386,  257,  258,  259,  260,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1, 
           -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1, 
          352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,  384,  385,  386,  257,  258,  259,  260,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1, 
           -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1, 
          352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,  384,  385,  386,  257,  258,  259,  260,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,  279,  280,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,   -1,   -1,   -1,   -1,  297,  298,  299,  300,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
           -1,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  387,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,  279,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,   -1,   -1,   -1,   -1,  297,  298,  299,  300, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,   -1,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  387,  257,  258,  259, 
          260,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,  279, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,   -1,   -1,   -1,   -1,  297,  298,  299, 
          300,  301,  302,  303,  304,   -1,  306,  307,  308,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349, 
           -1,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,   -1,   -1,  364,  365,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  387,  257,  258, 
          259,  260,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
          279,  280,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,   -1,   -1,   -1,   -1,  297,  298, 
          299,  300,  301,  302,  303,  304,   -1,  306,  307,   -1, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  348, 
          349,   -1,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,   -1,   -1,  364,  365,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  387,  257, 
          258,  259,  260,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,  279,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,   -1,   -1,   -1,   -1,  297, 
          298,  299,  300,  301,  302,  303,  304,   -1,  306,  307, 
           -1,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          348,  349,   -1,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,   -1,   -1,  364,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  256,  257,  258,  259,  260,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,  387, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1, 
           -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1, 
          352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,  384,  385,  386,  256,  257,  258,  259,  260, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340, 
           -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1, 
           -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360, 
           -1,   -1,   -1,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   -1,  384,  385,  386,  256,  257,  258,  259, 
          260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299, 
           -1,  301,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
           -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,  384,  385,  386,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
          350,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,   -1,  385,  386,  387,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,  348, 
           -1,  350,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,   -1,  385,  386,  387,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
           -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1, 
          348,   -1,  350,   -1,  352,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,   -1,  385,  386,  387, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,   -1,  385,  386, 
          387,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,   -1,   -1,  350,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,   -1,  385, 
          386,  387,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344, 
           -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,   -1, 
          385,  386,  387,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,   -1,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,  385,  386,  387,  257,  258,  259,  260,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,  384,  385,  386,  257,  258,  259,  260,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,  384,  385,  386,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,  341,   -1, 
          343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,  385,  386,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,  385,  386,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,  385,  386,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,  385,  386,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,  385,  386,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,  385,  386,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,  341,   -1, 
          343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,  385,  386,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,  385,  386,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,  385,  386,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,  385,  386,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,  385,  386,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          333,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,  385,  386,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,  385,  386,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,  385,  386,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,  385,  386,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,  385,  386,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,  385,  386,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
          306,  307,  385,  386,  310,   -1,   -1,   -1,  314,  315, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,   -1, 
          326,  327,   -1,   -1,   -1,  331,  332,  333,  334,   -1, 
           -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1, 
           -1,   -1,  348,  349,   -1,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,   -1,   -1,  364,  306, 
          307,   -1,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,  387,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1, 
           -1,  348,  349,   -1,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,   -1,   -1,  364,  306,  307, 
           -1,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
          387,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1, 
          348,  349,   -1,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,   -1,   -1,  364,  306,  307,   -1, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,  387, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348, 
          349,   -1,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,   -1,   -1,  364,  306,  307,   -1,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,  387,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349, 
           -1,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,   -1,   -1,  364,  306,  307,   -1,   -1,  310, 
           -1,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,  387,   -1,   -1, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,   -1,   -1,  364,  306,  307,   -1,   -1,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,  387,   -1,   -1,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
           -1,   -1,  364,  306,  307,   -1,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,  387,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,  349,   -1,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,   -1, 
           -1,  364,  306,  307,   -1,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,  387,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1, 
           -1,   -1,   -1,   -1,  348,  349,   -1,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,   -1,   -1, 
          364,  306,  307,   -1,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,  387,   -1,   -1,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,  348,  349,   -1,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,   -1,   -1,  364, 
          306,  307,   -1,   -1,  310,   -1,   -1,   -1,  314,  315, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,   -1, 
          326,  327,  387,   -1,   -1,  331,  332,  333,  334,   -1, 
           -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1, 
           -1,   -1,  348,  349,   -1,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,   -1,   -1,  364,  306, 
          307,   -1,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,  387,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1, 
           -1,  348,  349,   -1,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,   -1,   -1,  364,  306,  307, 
           -1,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
          387,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1, 
          348,  349,   -1,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,   -1,   -1,  364,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  387, 
      };
   }

}
