/*
 * Copyright (c) 2015, 2016 Oracle and/or its affiliates. All rights reserved. This
 * code is released under a tri EPL/GPL/LGPL license. You can use it,
 * redistribute it and/or modify it under the terms of the:
 *
 * Eclipse Public License version 1.0
 * GNU General Public License version 2
 * GNU Lesser General Public License version 2.1
 *
 * Some of the code in this class is transposed from org.jruby.runtime.encoding.EncodingService,
 * licensed under the same EPL1.0/GPL 2.0/LGPL 2.1 used throughout.
 */
package org.jruby.truffle.core.encoding;

import org.jcodings.Encoding;
import org.jruby.truffle.Layouts;

import com.oracle.truffle.api.object.DynamicObject;

public abstract class EncodingOperations {

    public static Encoding getEncoding(DynamicObject rubyEncoding) {
        return Layouts.ENCODING.getEncoding(rubyEncoding);
    }

}
