---
title: Announcing Contour v1.10.0
image: /img/posts/contour_xdsv2v3.png
excerpt: This blog post covers xDS Resource Server conversion from v2 to v3 in Contour v1.10.0.
author_name: Steve Sloka
author_avatar: /img/contributors/steve-sloka.png
categories: [kubernetes]
# Tag should match author to drive author pages
tags: ['Contour Team']
date: 2020-11-06
slug: contour_v1100
---

Contour continues to add new features to help you better manage ingress operations in a cluster.
Our latest feature release, Contour 1.10.0, now includes support for Envoy xDS v3 as support for the current v2 version will be deprecated in early 2021.
Contour also adds support for multi-arch images allowing for deployment on multiple platforms as well as extending support for custom JSON logging fields. 

## Envoy xDS v3 Support
Contour is the xDS controller for Envoy providing it with dynamic updates of Listeners, Routes, Clusters, Endpoints and other information over a gRPC connection.
Those objects are defined in the xDS API and are versioned. Currently, Contour supports the v2 xDS API.
The v2 version has been deprecated and has not accepted new features after the end of Q1 2020. Additionally, the v2 API will be removed from Envoy in Q1 of 2021.

One key component in Envoy which relates to which xDS version is used in the bootstrap configuration file.
This file, provided by an initContainer to Envoy, describes both the transport and resource API versions to use when communicating with Contour.
In Contour v1.9.0 and earlier versions, this bootstrap configuration doesn't’t specify a version, which then defaults to v2. 

New in v1.10.0, there’s now an `--xds-resource-version` flag that can be configured on the `contour bootstrap` command to change the bootstrap xDS resource & transport versions in the configuration file to v3, however, the default will still be v2 for the v1.10.0 release. 

This default means that users have a way to upgrade their instance of Envoy from v2 to v3 in place without any connection loss since Contour will serve both the v2 & v3 versions at the same time. 

![image](/img/posts/contour_xdsv2v3.png)

It’s important, however, to note that **this is the only version which will support both resource versions**.
Looking forward to Contour v1.11.0, Contour will remove the v2 support entirely and the bootstrap configuration will use v3 by default.
Users needing to perform an in-place upgrade should leverage Contour v1.10.0 as a stepping stone to the new xDS v3 resource version. 

For more information, please visit the [Upgrade Guide][3] as well as the [Migrating from v2-->v3 Guide][2].

## Custom Logging

As more users adopt Contour as their Ingress Controller, we find that they need more information to solve their needs. One such request is the ability to support custom JSON fields in the Envoy access log. 

Contour v1.10.0 now adds support for users to customize their access logs. You can read about this feature in more detail as well as how to configure it in the [structured JSON logging guide][4]. 

Thanks to [@mike1808](https://github.com/mike1808), [@KauzClay](https://github.com/KauzClay), and [@XanderStrike](https://github.com/XanderStrike) for designing and implementing this feature!

## Multi-arch Images

Similar to the new access logging features, users also have requested more architectures to run Contour.
Envoy now supports ARM based architectures starting in Envoy v1.16.0 and Contour follows suit by offering multi-arch builds allowing Contour & Envoy to run on non amd64 based systems.

![image](/img/posts/multiarch.png)

## Community Thanks!
We’re immensely grateful for all the community contributions that help make Contour even better! For version 1.10, special thanks go out to the following contributors:
- [@narahari92](https://github.com/narahari92)
- [@yoitsro](https://github.com/yoitsro)
- [@mike1808](https://github.com/mike1808)
- [@astrieanna](https://github.com/astrianna)
- [@kauana](https://github.com/kauana)
- [@Glyphack](https://github.com/Glyphack)
- [@danehans](https://github.com/danehans)
- [@KauzClay](https://github.com/KauzClay)
- [@XanderStrike](https://github.com/XanderStrike)


[2]: {{< relref "guides/xds-migration.md" >}}
[3]: {{< relref "resources/upgrading.md" >}}
[4]: {{< relref "guides/structured-logs.md" >}}
