// Copyright Project Contour Authors
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package fixture

// nolint:revive
const (
	// CERTIFICATE generated by https://www.selfsignedcertificate.com
	CERTIFICATE = `-----BEGIN CERTIFICATE-----
MIIDHTCCAgWgAwIBAgIJAOv27DGlF3qdMA0GCSqGSIb3DQEBBQUAMCUxIzAhBgNV
BAMMGmJvcmluZy13b3puaWFrLmV4YW1wbGUuY29tMB4XDTE5MTIwNTAxMzQzM1oX
DTI5MTIwMjAxMzQzM1owJTEjMCEGA1UEAwwaYm9yaW5nLXdvem5pYWsuZXhhbXBs
ZS5jb20wggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDbgwFwfbikZxPb
NYidPuNJoexq5W9fJrB/3jqsWox8pfess0bw/EL/VcEUqlrcuo40Md0MxApPuoPj
eZCOZYhrA2XgcVTMnq61vusnuvmeG/qcrd5apSOoopSo2pmmI1rsJ1AVpheA+eR6
uoWVILK8uYtPmcOQAoCU/E6iZYDLZ0AEiU16kz/cGfWx9lBukd+LQ+ZRQnLDiEI/
4hRmrZrEdJoDglzIgJVI+c8OfwbLq5eRMY2fYnxqm/1BJhqjDBc4Q8ufYgfOwobu
JdVoSgiFy7wyH0GxMk4LRR6yJXLs1yjaihLERbjzlStvFVl4yidpE6Bi0amKW8HT
Qxgk7iRRAgMBAAGjUDBOMB0GA1UdDgQWBBTLcIMeWLFiL2waFL6FPomNZR7gFDAf
BgNVHSMEGDAWgBTLcIMeWLFiL2waFL6FPomNZR7gFDAMBgNVHRMEBTADAQH/MA0G
CSqGSIb3DQEBBQUAA4IBAQBQLWokaWuFeSWLpxxaBX6aatgKAKNUSqDWNzM9zVMH
xJVDywWJT3pwq7JUXujVS/c9mzCPJEsn7OQPihQECRq09l/nBK0kn9I1X6X1SMtD
OJbpEWfQQxgstdgeC6pxrZRanF5a7EWO0pFSfjuM1ABjsdExaG3C8+wgEqOjHFDS
NaW826GOFf/uMOnavpG6QePECAtJVpLAZPw6Rah6cAZrYUUezM/Tg+8JUhYUS20F
STZG5knGQIe6kksWGkJUhMu8xLdH2HKtUVAkDu7jITy2WZbg0O/Pxe30b4qyt29Y
813p8G+7188EFDBGNihYYVJ+GJ/d/WPoptSHJOfShtbk
-----END CERTIFICATE-----`

	CERTIFICATE_WITH_TEXT = CERTIFICATE + "\t\r\n"

	RSA_PRIVATE_KEY = `-----BEGIN RSA PRIVATE KEY-----
MIIEpAIBAAKCAQEA24MBcH24pGcT2zWInT7jSaHsauVvXyawf946rFqMfKX3rLNG
8PxC/1XBFKpa3LqONDHdDMQKT7qD43mQjmWIawNl4HFUzJ6utb7rJ7r5nhv6nK3e
WqUjqKKUqNqZpiNa7CdQFaYXgPnkerqFlSCyvLmLT5nDkAKAlPxOomWAy2dABIlN
epM/3Bn1sfZQbpHfi0PmUUJyw4hCP+IUZq2axHSaA4JcyICVSPnPDn8Gy6uXkTGN
n2J8apv9QSYaowwXOEPLn2IHzsKG7iXVaEoIhcu8Mh9BsTJOC0UesiVy7Nco2ooS
xEW485UrbxVZeMonaROgYtGpilvB00MYJO4kUQIDAQABAoIBAF5L671gNIZjRVNg
rtwl3MuPxJizEOHGJAH5/Ch4CWuufDPzG6GALGO1eekfuUKi3V2sofHO8UMIs4lv
elrBYRXfcs80wCHadODcL/Z0SrDSAhl2U1OLJ0NU/BmBNon5HCDgTnXOUMB2GOFj
6OiEEGQkLKU4P5tIh+X4cOswQWCeoVjW0JVgni20hi3LJNTxSNYeU5VFvPKtoBLl
8nFqF3ky+bqYfS6H6qM/mO+XL0NQ2wjMteyUeDXcVGfsf7Ir21SUw3zGaeBJl55B
6BrUgfxVOKuxkw2bwxmu8HX+CxlMMMzaRt+5URFbfOaMgXzjpikrxdeFAAGeu0m4
bidUR5UCgYEA8lRGqYfowoOCrV8Ksn8nM0Z9PlnmKM5d9mQ875sm/SYLO43h+s0D
R4VWmLzaGyi0m0036lxIthDfbbGWSjmNrgQ0YIS7ilmBPMUKKYzXgDoiI76aJBTz
UMpWutb+VYimPPorLKcxNb3BjR3QHx7vCRS2gV5izV0djtMkKc53OXsCgYEA5+Uz
A7cmO8gHyxlW6SA3+wMH6VKP5ABTkDmKfRF3NCv4UHNn4TtlNuS1D3ZMNXWgCtz6
qJ/bRTAqseBIX15pzR/MvyNmHRUN3A2Ba6vB2pJux+ZyQjxn3Z+gisjX+eN3LvTU
YpcJNi0HSuV57n4AAk5YPO5iMEFw95vfBn3MMaMCgYEAnFwyqAsQ7gmLVTDBJ0GS
Wqx9/bBmKShXSreM9hIHi0pz7v5ytLB6EDkCElWw6dtPBfJCRQ88v3WNpSr0TXpr
Z8BAx5J9rBxqnnqJPxwopQ1dn/DJZsS55wRYCADXZPtiQHAvUYWj5AhHjjWRZ7M/
C3348OqlF9ugSdsFN5CIL2cCgYEAqt5lop03XOFdbLe1JH4LAbgQAkpFoDjlWeYs
N0/BR/4GMDF5H6sGP1ZyW3xNVy7eyGJfiBSSGv8M1phue2c0CmMeGNDakx9KYRTK
gi3C32z6l+0jz852sgTG5Lxs98I1tbHNNQAZV4QCVZuVJrhNBWX4+pykWO4/cRO3
WC8lYIUCgYBmmN4z0MR2YWoRvN3lYey3bRGAvsSU6ouiFo40UZdZaRXc1sA3oc+5
6Di3f8eOIhM5IekOBoaTBf90V8seB6Nw+/jzAViG1HDI7k0ZOoApDuFS6NYk1/bU
dk98FvYdyAjjgNsxXCyx7vIgYU3OgVNgvFsFubX/Uk66fcfCpPBMLg==
-----END RSA PRIVATE KEY-----`

	// EC_CERTIFICATE sample elliptical curve data generated
	// openssl ecparam -name prime256v1 -genkey -out ec_key.pem
	// openssl req -new -x509 -key ec_key.pem -out ec_crt.pem -days 3650 \
	//     -subj "/C=US/ST=CA/O=Acme" \
	//     -reqexts SAN -extensions SAN -config <(ca t /etc/ssl/openssl.cnf \
	//     <(printf "\n[SAN]\nsubjectAltName=DNS:example.com,DNS:www.example.com"))
	EC_CERTIFICATE = `-----BEGIN CERTIFICATE-----
MIIBfzCCASWgAwIBAgIUZ8EBxJShrhAiO9bG6aRVcJdlEJowCgYIKoZIzj0EAwIw
KTELMAkGA1UEBhMCVVMxCzAJBgNVBAgMAkNBMQ0wCwYDVQQKDARBY21lMB4XDTE5
MTIwNTAxNTg0NFoXDTI5MTIwMjAxNTg0NFowKTELMAkGA1UEBhMCVVMxCzAJBgNV
BAgMAkNBMQ0wCwYDVQQKDARBY21lMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAE
zCdqvU5dSKxzDAVakEi97epIazdkUKRT2XZtUk41Hp2H4xy8EzR1Re3r9AdJRsJn
sGrHGbIg2r7OUNYgeN4ot6MrMCkwJwYDVR0RBCAwHoILZXhhbXBsZS5jb22CD3d3
dy5leGFtcGxlLmNvbTAKBggqhkjOPQQDAgNIADBFAiAYFlD2n/uWWxTqi8WcWvb1
CUDxSzF2/jLe1PIFkwNk7wIhAP9kMCO1ys050JNvlVZg3xvPvCHKCkWcSachE5fC
5hc6
-----END CERTIFICATE-----`

	EC_PRIVATE_KEY = `-----BEGIN EC PARAMETERS-----
BggqhkjOPQMBBw==
-----END EC PARAMETERS-----
-----BEGIN EC PRIVATE KEY-----
MHcCAQEEIAM3LdZrzZk8Hn4VqBDNTgOuh9E772M4sgEYvZMNOy4moAoGCCqGSM49
AwEHoUQDQgAEzCdqvU5dSKxzDAVakEi97epIazdkUKRT2XZtUk41Hp2H4xy8EzR1
Re3r9AdJRsJnsGrHGbIg2r7OUNYgeN4otw==
-----END EC PRIVATE KEY-----`

	// MISSING_CN_CERT issue #1965
	// certificate with no CN field.
	// openssl req -new -newkey rsa:2048 -days 365 -nodes -subj="/DC=com/DC=domain/DC=my" -x509 -keyout server.key -out server.crt -sha256
	MISSING_CN_CERT = `-----BEGIN CERTIFICATE-----
MIIDYzCCAkugAwIBAgIUcNI/oD/y3dZ2Rmyvz9Xb4BsC0nswDQYJKoZIhvcNAQEL
BQAwQTETMBEGCgmSJomT8ixkARkWA2NvbTEWMBQGCgmSJomT8ixkARkWBmRvbWFp
bjESMBAGCgmSJomT8ixkARkWAm15MB4XDTE5MTIwMzA0MDYyM1oXDTIwMTIwMjA0
MDYyM1owQTETMBEGCgmSJomT8ixkARkWA2NvbTEWMBQGCgmSJomT8ixkARkWBmRv
bWFpbjESMBAGCgmSJomT8ixkARkWAm15MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8A
MIIBCgKCAQEAxblHSlzhyDY88rhILpn+rCALqK1ELcbL5T3FygLEdUlE/da3VpSz
wBaZc9UIhFpwnkvUy8eKYbLy9jIk3C0aJasrX828MkF4lInSJf0BREbddxmwDovl
KZoo7xz2rY6LPTopZ1GdszzsPxvBFvc1gWl0UEXkxDAZjtnDuVB+hBv6RR7BpSdN
Fxds3OVles1mgasW79gMCb22gFa9vJKkxVJz5IIstrShjCfNvPvULf3aeMJjy8fM
x8kHBiRSs6HC4dFR3cR1uuZCdnkeR76X3gAn9A18VBMvA25JehhfLYnVJi80UgGV
PAxKgjU8dw8auvbmopzkguyFTfW6sYfDBQIDAQABo1MwUTAdBgNVHQ4EFgQUITS5
7JyH/S2wUrZnUjQXAp1nTPQwHwYDVR0jBBgwFoAUITS57JyH/S2wUrZnUjQXAp1n
TPQwDwYDVR0TAQH/BAUwAwEB/zANBgkqhkiG9w0BAQsFAAOCAQEAn5nxNyI6+3MD
X5hzg5G0gTZafL8qN5bJGlFRWeyU2CvWsXbHCYtzADkwGCcCyoA1nmb460kwZ4vk
fOz9FYqZoh4IIegs5bB559Ze26Kjl5AgAFARXxV6s0cPDQ2O1XFkNIQiLFHHPfRR
RJtQgNaLppCe8TFNPjUDqNfoWPQvnlEYMYsvKto7pNw+HGreXhGF5CUCGIqT747P
zYmBGZEE2q1L45nErZFK4d74XzGu/4Kc73zEFS6GT71Zu6Ec6wUCKdciyNtFHFmh
4l3l5YC+1zK6ZeOBxdoMKpldD9EV4GQqW8aE2Adpd5RcUUQJnqWM+/ysod/AnHL/
fm35MjBa+w==
-----END CERTIFICATE-----
`
	MISSING_CN_KEY = `-----BEGIN PRIVATE KEY-----
MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDFuUdKXOHINjzy
uEgumf6sIAuorUQtxsvlPcXKAsR1SUT91rdWlLPAFplz1QiEWnCeS9TLx4phsvL2
MiTcLRolqytfzbwyQXiUidIl/QFERt13GbAOi+UpmijvHPatjos9OilnUZ2zPOw/
G8EW9zWBaXRQReTEMBmO2cO5UH6EG/pFHsGlJ00XF2zc5WV6zWaBqxbv2AwJvbaA
Vr28kqTFUnPkgiy2tKGMJ828+9Qt/dp4wmPLx8zHyQcGJFKzocLh0VHdxHW65kJ2
eR5HvpfeACf0DXxUEy8Dbkl6GF8tidUmLzRSAZU8DEqCNTx3Dxq69uainOSC7IVN
9bqxh8MFAgMBAAECggEAZVvBjAFpTPVg8Rw/BIS05Q/YajPIS58pTu8HwbMBew6A
a4/ylFPOgZ4UNCj1IMQsDznYcE5uRf8yRbsW4jfMu5qvtYEGBM1DPwIX1JmKWLHr
Pe7RLePRKi545Xr3iakU/+Ic73YLXaLRiNh1d4xqxViF49CwoVH3CB/iEdGNybKX
CyWxNUS9Tguzg26zIqvtjjqzP3ULt/P+fi/NTIKswv4Btp6hI8QDA2RL6RFJYIL2
jVpRFUSOhl5N7fg8ZKIAaQFetenzM/yF29qa6nlIhXFsep6bRaLqw9Hni2YB6yCh
7z4I/ygSTirPW1yk+NPiLjc6mTZVf7EvdFeApOOSUQKBgQDq71Hb0hciDyFkdq3R
nxskJeiSk8b141tarlrUTvoPRYwOaeKcDN2Lzj7Y9Pqxllb8CSjoOR0B/pfwvfxI
J2HGoNf7PK3rn166QiFPPFxwa5bMpCcbEoljToB4nCRDsYRlUrd/hAHAb1ptLqK2
OHc2pbOo0mmYORstIFccrKJDYwKBgQDXc9FA78KjZ7iS2GCs3yXOdS2U1TD5hZMr
MDXMA0CMbxTYmLRLD0x41hXzH/2UsfQNCYQZCOqWhW3FJHqAaBz0w2n+dOMkWeSq
EI5ghDQyu/HM2V7xk3tYYXhZ/FxOzcd2l/DUzKZsPJuxsXsNaUn9+ZOE44xHRjNf
wYvNv17QdwKBgQCujZO/hLAlYSKJV1g8OD/dMsFDLsMT7JHypTrdJbTLZfvytZ9m
HHT7LAkr/5DII5CLgG7BY7X2xmezuiTYo1IVV2pBw8rhFy81qm6/RXTVHksTzx8z
ESm8/BWeBz02go2BDt1BxB3dEZ8ZIh5Iz1lb4+/BjlxgeoWDmNTAfE+vSwKBgFGq
I7HSb1tSsEJw48wC1Si5f6p/WI3r1Im1P17yCKByZltnHkepJ9pRg4ZhJNQc052x
crGukIS3VJE6L3jGfdtEysNZeNNJg4P2vJDW65YjaRa1eehld4Zbg6vQHQj9tNI9
61otrBMwse8bj8HYm+Q5mnHvcjd943EzQpOdKwonAoGBAKGymiC7RgrdaxbKf7oE
dsipT/w+MFInBLLiJcqLAfh0647vhjCFNGG4MZ6YGVwiIdvjZ1dH2Ujsdo8e0+Wi
8cnx8JvuAJdr5HzMI6fvnMDzjzAskMgYUNhOUhM2g223JuoyyLY2/DL7dOYkFeSn
b5qYn0JNERfPYdLwXNV1HCM9
-----END PRIVATE KEY-----
`
)
