### HTTPProxy Per-Route and Service Cookie Rewriting

Contour now enables users to customize attributes on HTTP `Set-Cookie` response headers.
Application specific cookies and cookies generated by Contour's ["cookie" load balancing strategy](https://projectcontour.io/docs/v1.19.0/config/request-routing/#session-affinity) can be rewritten either per HTTPProxy `Route` or `Service`.
Users can choose to rewrite the `Path`, `Domain`, `Secure`, and `SameSite` attributes of the `Set-Cookie` header currently.
These attributes may be things an application may not be able to accurately set, without prior knowledge of how the application is deployed.
For example, if Contour is in use to rewrite the path or hostname of a request before it reaches an application backend, the application may not be able to accurately set the `Path` and `Domain` attributes in a `Set-Cookie` response header.
This feature can be used to apply security settings to ensure browsers treat generated cookies appropriately.
The `SameSite` and `Secure` attributes are currently not set by Envoy when it generates the `X-Contour-Session-Affinity`, but with this feature, users can customize this cookie further.
Future iterations of this feature may provide cookie rewriting configuration directly as part of the cookie load balancing strategy configuration.

Some more documentation and example configuration can be found [here](https://projectcontour.io/docs/v1.19.0/config/cookie-rewriting/).
Also see Contour's CRD [API reference](https://projectcontour.io/docs/v1.19.0/config/api/) for more details.
