---
title: Announcing Contour v1.11.0
excerpt: This blog post covers the new Contour Operator released in v1.11.0.
author_name: Steve Sloka & Daneyon Hansen
# author_avatar: /img/contributors/steve-sloka.png
categories: [kubernetes]
# Tag should match author to drive author pages
tags: ['Steve Sloka & Daneyon Hansen']
date: 2020-12-18
slug: contour_v1110
---

Contour continues to add new features to help you better manage ingress operations in a cluster.
Our latest feature release, Contour 1.11.0, now includes support for a new operator aimed at managing the lifecycle of Contour and its corresponding Envoy instances.

## Contour Operator

__FEATURE STATE:__ Contour v1.11.0 [alpha](https://projectcontour.io/resources/deprecation-policy/)

[Contour Operator](https://github.com/projectcontour/contour-operator/blob/main/README.md) provides a method for packaging,
deploying, and managing Contour. The operator extends the functionality of the Kubernetes API to create, configure, and
manage instances of Contour on behalf of users.
It builds upon the basic Kubernetes resource and controller concepts, but includes domain-specific knowledge to automate the entire lifecycle of Contour.

In Kubernetes, controllers of the control-plane implement control loops that repeatedly compare the desired state of the cluster to its actual state.
If the cluster's actual state doesn’t match the desired state, then the controller takes action to fix the problem.
Contour Operator is a custom Kubernetes controller that uses the `Contour` custom resource (CR) to manage Contour and its dependent components, i.e. the Envoy DaemonSet.
The `contours.operator.projectcontour.io` Custom Resource Definition (CRD) defines the `Contour` CR. A `Contour` is handled by the Kubernetes API just like built-in objects, including interaction via kubectl and inclusion in role-based access control (RBAC) policies.
The following example runs an instance of Contour in namespace `projectcontour` with 2 Deployment replicas:
```
cat <<EOF | kubectl apply -f -
apiVersion: operator.projectcontour.io/v1alpha1
kind: Contour
metadata:
  name: contour-sample
spec: {}
EOF
```

No configuration, i.e. `spec`, is provided since `projectcontour` is the default namespace and `2` is the default number
of replicas for a `Contour`.
The default parameters of the `Contour` can be verified in the same way as any other Kubernetes resource:
```
$ kubectl get contour/contour-sample -o yaml
apiVersion: operator.projectcontour.io/v1alpha1
kind: Contour
metadata:
  name: contour-sample
  namespace: default
...
spec:
  namespace:
    name: projectcontour
    removeOnDeletion: false
  replicas: 2
...
```

Contour Operator continues to monitor the `Contour` CR and provides status on whether the actual state matches the desired state. The following example indicates the `Contour` is available:
```
$ kubectl get contour/contour-sample
NAME             READY   REASON
contour-sample   True    ContourAvailable
```

The `Contour` is now ready to start serving `Ingress` and `HTTPProxy` resources.

Check out the [Getting Started](https://projectcontour.io/getting-started/) guide to learn how to start managing Contour using the operator. Learn more about the planned features of Contour Operator by reviewing the GitHub [Issues](https://github.com/projectcontour/contour-operator/issues).

## XDS Resource `v2` Removed

As mentioned in Contour [1.10](https://projectcontour.io/contour_v1100/#envoy-xds-v3-support) the v2 XDS resource version has been removed from Contour ahead of its removal from Envoy.
Please see the [XDS Migration Guide](https://projectcontour.io/guides/xds-migration/) for upgrading your instances of Envoy/Contour.

Also note that this change applies to any External Auth servers that may be integrated, they need to support XDS version `v3` with this release of Contour.

## Community Thanks!
We’re immensely grateful for all the community contributions that help make Contour even better! For version 1.11, special thanks go out to the following contributors:
- [@invidian](https://github.com/invidian)
- [@alexbrand](https://github.com/alexbrand)
- [@danehans](https://github.com/danehans)
- [@shuuji3](https://github.com/shuuji3)
- [@yoitsro](https://github.com/yoitsro)
- [@bascht](https://github.com/bascht)
- [@tsaarni](https://github.com/tsaarni)
- [@georgegoh](https://github.com/georgegoh)