# Query

中文版请见[这里](query-cn.md)

The _SELECT_ statement is more complex than others, because _SELECT_ statement have more clauses.

## Basic

The simplest usage is query all data in the table:

```kotlin
fun sample() {
    lateinit var selectStatement: SelectStatement<Person>
    database {
        PersonTable { table ->
             selectStatement = table SELECT X
        }
    }
    selectStatement.getResult().forEach { person ->
        println(person)
    }
}
```
The `X` represents without any clause, we’ve seen it in _DELETE_ statements.

The _SELECT_ statement has query results, this is another difference from other statements. So, you need to declare a variable that
type is `SelectStatement<T>`. The generic parameter `T` is your database entity's type that you expect to deserialize. You should assign _SELECT_ statement you built to this variable.

Note, all statements will only be executed when the _DatabaseScope_ ends, we mentioned this in the [Modify Database and Transaction](modify-database-and-transaction.md).
So, you must invoke the `getResults` function outside the `database { ... }` block, SQLlin will help you deserialize query results to objects that you expected.

## Single Clause

In SQL, we usually use some clauses to make a conditional query. These clauses could be used alone: _WHERE_, _ORDER BY_, _LIMIT_ and 
_GROUP BY_. The sample code like this:

```kotlin
fun sample() {
    database {
        PersonTable { table ->
            table SELECT WHERE(age LTE 5)
            table SELECT ORDER_BY(age to DESC)
            table SELECT ORDER_BY(age)
            table SELECT LIMIT(3)
            table SELECT GROUP_BY(name)
        }
    }
}
```

## Clause Connection

Sometimes we need to use multiple clauses once. In SQL, some clauses must be added after other clauses. For example, the _HAVING_ behind with
the _GROUP BY_. SQLlin makes sure you don't make mistakes in the order of clauses, the clauses connection regular like this chart: 

|Clause/Statement| Connectable                  |
|---|------------------------------|
|SELECT| WHERE, ORDER BY, LIMIT, GROUP BY |
|WHERE| LIMIT, ORDER BY, GROUP BY    |
|GROUP BY| HAVING, ORDER BY             |
|HAVING| ORDER BY, LIMIT              |
|ORDER BY| LIMIT                        |
|LIMIT| OFFSET                       |
|OFFSET| /                            |

A _SELECT_ statement with multiple clauses like this:

```kotlin
fun sample() {
    lateinit var selectStatement: SelectStatement<Person>
    database {
        PersonTable { table ->
             selectStatement = table SELECT WHERE (age LTE 5) GROUP_BY age HAVING (upper(name) EQ "TOM") ORDER_BY (age to DESC) LIMIT 2 OFFSET 1
        }
    }
    selectStatement.getResult().forEach { person ->
        println(person)
    }
}
```

## Next Step

Next step, we will learn the concurrency safety, how to use SQL functions and advanced query：

- [Concurrency Safety](concurrency-safety.md)
- [SQL Functions](sql-functions.md)
- [Advanced Query](advanced-query.md)