---
sidebarDepth: 0
---

# Community

We welcome issues, contributions and discussion from all users, regardless of background or experience level. In order to create a positive and welcoming environment, all interactions are governed by Prefect's [Code of Conduct](code_of_conduct.md).

Please consider [Chris White](https://github.com/cicdw) the main point of contact for the Prefect repo.

## Discussion

- We have a public [Slack](https://prefect-slackin.herokuapp.com/) for chatting about Prefect, asking questions, and sharing tips.
- For feature requests or bug reports, please open a [new GitHub issue](https://github.com/PrefectHQ/prefect/issues/new).
- Important architectural and design decisions are memorialized in [Prefect Improvement Notices (PINs)](/core/PINs/PIN-01-Introduce-PINs.html).

## Contributing

Prefect encourages users to contribute in any way they can! There are a number of ways you can get involved:

- **closing issues**: the [issue board](https://github.com/PrefectHQ/prefect/issues) contains issues with the tag ["good first issue"](https://github.com/PrefectHQ/prefect/issues?q=is%3Aissue+is%3Aopen+label%3A%22good+first+issue%22) that should be approachable for first-time contributors
- **documentation**: Prefect prioritizes its documentation, as this is usually the first place users go to look for help. If you find any typos, or want to update something for clarity, users everywhere will thank you!
- **the task library**: Prefect's task library helps users build workflows even quicker by abstracting away common boilerplate. If you know of a common operation that isn't represented, open a pull request to add a new task to the library!

See our [Development Guide](/core/development/overview.html) for more information on how to get started.

### Community-supported plugins and related projects

Prefect is intended to be endlessly extensible and our users are always pursuing new use cases for the platform. Though we actively seek to incorporate community contributions directly into core, here are a few other projects or plugins that extend Prefect:

- [`prefect_ds`](https://github.com/AndrewRook/prefect_ds) by [@AndrewRook](https://github.com/AndrewRook)

## Participating 

We'd love to have you involved. Here are a few ways to participate:

- **joining us at sprints**: join Prefect at an upcoming in-person event and jumpstart your contributions. More information is available [here](/core/development/sprints.html).
- **user research**: we pride ourselves on our user research programs - we're interested in learning what you do and how you do it, so we can deliver a better product. Please [contact us](mailto:research@prefect.io) to learn more.