---
sidebarDepth: 2
editLink: false
---
# Great Expectations Task
---
A collection of tasks for interacting with Great Expectations deployments and APIs.

Note that all tasks currently require being executed in an environment where the great expectations configuration directory can be found; 
learn more about how to initialize a great expectation deployment [on their Getting Started docs](https://docs.greatexpectations.io/en/latest/tutorials/getting_started.html).
 ## RunGreatExpectationsValidation
 <div class='class-sig' id='prefect-tasks-great-expectations-checkpoints-rungreatexpectationsvalidation'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.great_expectations.checkpoints.RunGreatExpectationsValidation</p>(checkpoint_name=None, context=None, assets_to_validate=None, batch_kwargs=None, expectation_suite_name=None, context_root_dir=None, runtime_environment=None, run_name=None, run_info_at_end=True, disable_markdown_artifact=False, validation_operator="action_list_operator", **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/great_expectations/checkpoints.py#L24">[source]</a></span></div>

Task for running data validation with Great Expectations.

Example using the GE getting started tutorial: https://github.com/superconductive/ge_tutorials/tree/main/ge_getting_started_tutorial

The task can be used to run validation in one of the following ways:

1. expectation_suite AND batch_kwargs, where batch_kwargs is a dict 2. assets_to_validate: a list of dicts of expectation_suite + batch_kwargs 3. checkpoint_name: the name of a pre-configured checkpoint (which bundles expectation suites and batch_kwargs)


```python
from prefect import task, Flow, Parameter
from prefect.tasks.great_expectations import RunGreatExpectationsValidation


# Define checkpoint task
validation_task = RunGreatExpectationsValidation()


# Task for retrieving batch kwargs including csv dataset
@task
def get_batch_kwargs(datasource_name, dataset):
    dataset = ge.read_csv(dataset)
    return {"dataset": dataset, "datasource": datasource_name}


with Flow("ge_test") as flow:
    datasource_name = Parameter("datasource_name")
    dataset = Parameter("dataset")
    batch_kwargs = get_batch_kwargs(datasource_name, dataset)

    expectation_suite_name = Parameter("expectation_suite_name")
    validation_task(
        batch_kwargs=batch_kwargs,
        expectation_suite_name=expectation_suite_name,
    )

flow.run(
    parameters={
        "datasource_name": "data__dir",
        "dataset": "data/yellow_tripdata_sample_2019-01.csv",
        "expectation_suite_name": "yellow_tripdata_sample_2019-01.warning",
    },
)

```


**Args**:     <ul class="args"><li class="args">`checkpoint_name (str, optional)`: the name of a pre-configured checkpoint; should match the         filename of the checkpoint without .py     </li><li class="args">`context (DataContext, optional)`: an in-memory GE DataContext object. e.g.         `ge.data_context.DataContext()` If not provided then `context_root_dir` will be used to         look for one.     </li><li class="args">`assets_to_validate (list, optional)`: A list of assets to validate when running the         validation operator.     </li><li class="args">`batch_kwargs (dict, optional)`: a dictionary of batch kwargs to be used when validating         assets.     </li><li class="args">`expectation_suite_name (str, optional)`: the name of an expectation suite to be used when         validating assets.     </li><li class="args">`context_root_dir (str, optional)`: the absolute or relative path to the directory holding         your `great_expectations.yml`     </li><li class="args">`runtime_environment (dict, optional)`: a dictionary of great expectation config key-value         pairs to overwrite your config in `great_expectations.yml`     </li><li class="args">`run_name (str, optional)`: the name of this  Great Expectation validation run; defaults to         the task slug     </li><li class="args">`run_info_at_end (bool, optional)`: add run info to the end of the artifact generated by this         task. Defaults to `True`.     </li><li class="args">`disable_markdown_artifact (bool, optional)`: toggle the posting of a markdown artifact from         this tasks. Defaults to `False`.     </li><li class="args">`validation_operator (str, optional)`: configure the actions to be executed after running         validation. Defaults to `action_list_operator`.     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-great-expectations-checkpoints-rungreatexpectationsvalidation-run'><p class="prefect-class">prefect.tasks.great_expectations.checkpoints.RunGreatExpectationsValidation.run</p>(checkpoint_name=None, context=None, assets_to_validate=None, batch_kwargs=None, expectation_suite_name=None, context_root_dir=None, runtime_environment=None, run_name=None, run_info_at_end=True, disable_markdown_artifact=False, validation_operator="action_list_operator")<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/great_expectations/checkpoints.py#L131">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`checkpoint_name (str, optional)`: the name of the checkpoint; should match the filename of         the checkpoint without .py     </li><li class="args">`context (DataContext, optional)`: an in-memory GE DataContext object. e.g.         `ge.data_context.DataContext()` If not provided then `context_root_dir` will be used to         look for one.     </li><li class="args">`assets_to_validate (list, optional)`: A list of assets to validate when running the         validation operator.     </li><li class="args">`batch_kwargs (dict, optional)`: a dictionary of batch kwargs to be used when validating         assets.     </li><li class="args">`expectation_suite_name (str, optional)`: the name of an expectation suite to be used when         validating assets.     </li><li class="args">`context_root_dir (str, optional)`: the absolute or relative path to the directory holding         your `great_expectations.yml`     </li><li class="args">`runtime_environment (dict, optional)`: a dictionary of great expectation config key-value         pairs to overwrite your config in `great_expectations.yml`     </li><li class="args">`run_name (str, optional)`: the name of this  Great Expectation validation run; defaults to         the task slug     </li><li class="args">`run_info_at_end (bool, optional)`: add run info to the end of the artifact generated by this         task. Defaults to `True`.     </li><li class="args">`disable_markdown_artifact (bool, optional)`: toggle the posting of a markdown artifact from         this tasks. Defaults to `False`.     </li><li class="args">`validation_operator (str, optional)`: configure the actions to be executed after running         validation. Defaults to `action_list_operator`.</li></ul> **Raises**:     <ul class="args"><li class="args">'signals.VALIDATIONFAIL' if the validation was not a success</li></ul><br><br>**Returns**:     <ul class="args"></ul></p>|

---
<br>

 ## RunGreatExpectationsCheckpoint
 <div class='class-sig' id='prefect-tasks-great-expectations-checkpoints-rungreatexpectationscheckpoint'><p class="prefect-sig">class </p><p class="prefect-class">prefect.tasks.great_expectations.checkpoints.RunGreatExpectationsCheckpoint</p>(checkpoint_name=None, context_root_dir=None, runtime_environment={}, run_name=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/great_expectations/checkpoints.py#L277">[source]</a></span></div>

DEPRECATED

Task for running a Great Expectations checkpoint. For this task to run properly, it must be run above your great_expectations directory or configured with the `context_root_dir` for your great_expectations directory on the local file system of the worker process.

**Args**:     <ul class="args"><li class="args">`checkpoint_name (str)`: the name of the checkpoint; should match the filename of the         checkpoint without .py     </li><li class="args">`context_root_dir (str)`: the absolute or relative path to the directory holding your         `great_expectations.yml`     </li><li class="args">`runtime_environment (dict)`: a dictionary of great expectation config key-value pairs         to overwrite your config in `great_expectations.yml`     </li><li class="args">`run_name (str)`: the name of this Great Expectation validation run; defaults to the         task slug     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task constructor</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-tasks-great-expectations-checkpoints-rungreatexpectationscheckpoint-run'><p class="prefect-class">prefect.tasks.great_expectations.checkpoints.RunGreatExpectationsCheckpoint.run</p>(checkpoint_name=None, context_root_dir=None, runtime_environment={}, run_name=None, **kwargs)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/tasks/great_expectations/checkpoints.py#L319">[source]</a></span></div>
<p class="methods">Task run method.<br><br>**Args**:     <ul class="args"><li class="args">`checkpoint_name (str)`: the name of the checkpoint; should match the filename of         the checkpoint without .py     </li><li class="args">`context_root_dir (str)`: the absolute or relative path to the directory holding         your `great_expectations.yml`     </li><li class="args">`runtime_environment (dict)`: a dictionary of great expectation config key-value         pairs to overwrite your config in `great_expectations.yml`     </li><li class="args">`run_name (str)`: the name of this  Great Expectation validation run; defaults to         the task slug     </li><li class="args">`**kwargs (dict, optional)`: additional keyword arguments to pass to the Task         constructor</li></ul> **Raises**:     <ul class="args"></ul></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on December 16, 2020 at 21:36 UTC</p>