---
sidebarDepth: 2
editLink: false
---
# Kubernetes Agent
---
 ## KubernetesAgent
 <div class='class-sig' id='prefect-agent-kubernetes-agent-kubernetesagent'><p class="prefect-sig">class </p><p class="prefect-class">prefect.agent.kubernetes.agent.KubernetesAgent</p>(agent_config_id=None, namespace=None, service_account_name=None, image_pull_secrets=None, job_template_path=None, name=None, labels=None, env_vars=None, max_polls=None, agent_address=None, no_cloud_logs=False, volume_mounts=None, volumes=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/agent/kubernetes/agent.py#L32">[source]</a></span></div>

Agent which deploys flow runs as Kubernetes jobs. Currently this is required to either run on a k8s cluster or on a local machine where the kube_config is pointing at the desired cluster. Information on using the Kubernetes Agent can be found at https://docs.prefect.io/orchestration/agents/kubernetes.html

**Args**:     <ul class="args"><li class="args">`agent_config_id (str, optional)`: An optional agent configuration ID that can be used to set         configuration based on an agent from a backend API. If set all configuration values will be         pulled from backend agent configuration.     </li><li class="args">`namespace (str, optional)`: A Kubernetes namespace to create jobs in. Defaults         to the environment variable `NAMESPACE` or `default`.     </li><li class="args">`service_account_name (str, optional)`: A kubernetes service account name to use by         default for created jobs. May be overridden per-flow by specifying         on a flow's `KubernetesRun` run config.     </li><li class="args">`image_pull_secrets (list, optional)`: A list of image pull secrets to use by default         for created jobs. May be overridden per-flow by specifying on a flow's         `KubernetesRun` run config.     </li><li class="args">`job_template_path (str, optional)`: A path to a job template file to use instead         of the default.     </li><li class="args">`name (str, optional)`: An optional name to give this agent. Can also be set through         the environment variable `PREFECT__CLOUD__AGENT__NAME`. Defaults to "agent"     </li><li class="args">`labels (List[str], optional)`: a list of labels, which are arbitrary string         identifiers used by Prefect Agents when polling for work     </li><li class="args">`env_vars (dict, optional)`: a dictionary of environment variables and values that will         be set on each flow run that this agent submits for execution and in the agent's         own environment     </li><li class="args">`max_polls (int, optional)`: maximum number of times the agent will poll Prefect Cloud         for flow runs; defaults to infinite     </li><li class="args">`agent_address (str, optional)`:  Address to serve internal API at. Currently this is         just health checks for use by an orchestration layer. Leave blank for no API server         (default).     </li><li class="args">`no_cloud_logs (bool, optional)`: Disable logging to a Prefect backend for this agent         and all deployed flow runs     </li><li class="args">`volume_mounts (list, optional)`: A list of volumeMounts to mount when a job is         run. The volumeMounts in the list should be specified as dicts         i.e `[{"name": "my-vol", "mountPath": "/mnt/my-mount"}]`     </li><li class="args">`volumes (list, optional)`: A list of volumes to make available to be mounted when a         job is run. The volumes in the list should be specified as nested dicts.         i.e `[{"name": "my-vol", "csi": {"driver": "secrets-store.csi.k8s.io"}}]`</li></ul>

|methods: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;|
|:----|
 | <div class='method-sig' id='prefect-agent-agent-agent-start'><p class="prefect-class">prefect.agent.agent.Agent.start</p>(_loop_intervals=None)<span class="source"><a href="https://github.com/PrefectHQ/prefect/blob/master/src/prefect/agent/agent.py#L212">[source]</a></span></div>
<p class="methods">The main entrypoint to the agent. This function loops and constantly polls for new flow runs to deploy<br><br>**Args**:     <ul class="args"><li class="args">`_loop_intervals (dict, optional)`: Exposed for testing only.</li></ul></p>|

---
<br>


<p class="auto-gen">This documentation was auto-generated from commit <a href='https://github.com/PrefectHQ/prefect/commit/n/a'>n/a</a> </br>on December 16, 2020 at 21:36 UTC</p>